# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_01_01
  module Models
    #
    # Information about the security control.
    #
    class SecureScoreControlDefinitionItem < Resource

      include MsRestAzure

      # @return [String] User friendly display name of the control
      attr_accessor :display_name

      # @return [String] User friendly description of the control
      attr_accessor :description

      # @return [Integer] Maximum control score (0..10)
      attr_accessor :max_score

      # @return [SecureScoreControlDefinitionSource] Source object from which
      # the control was created
      attr_accessor :source

      # @return [Array<AzureResourceLink>] Array of assessments metadata IDs
      # that are included in this security control
      attr_accessor :assessment_definitions


      #
      # Mapper for SecureScoreControlDefinitionItem class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'SecureScoreControlDefinitionItem',
          type: {
            name: 'Composite',
            class_name: 'SecureScoreControlDefinitionItem',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              display_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.displayName',
                type: {
                  name: 'String'
                }
              },
              description: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.description',
                constraints: {
                  MaxLength: 256
                },
                type: {
                  name: 'String'
                }
              },
              max_score: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.maxScore',
                constraints: {
                  InclusiveMaximum: 10,
                  InclusiveMinimum: 0
                },
                type: {
                  name: 'Number'
                }
              },
              source: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.source',
                type: {
                  name: 'Composite',
                  class_name: 'SecureScoreControlDefinitionSource'
                }
              },
              assessment_definitions: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.assessmentDefinitions',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'AzureResourceLinkElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'AzureResourceLink'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
