# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_01_01
  #
  # API spec for Microsoft.Security (Azure Security Center) resource provider
  #
  class Assessments
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Assessments class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [SecurityCenter] reference to the SecurityCenter
    attr_reader :client

    #
    # Get security assessments on all your scanned resources inside a scope
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SecurityAssessment>] operation results.
    #
    def list(scope, custom_headers:nil)
      first_page = list_as_lazy(scope, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Get security assessments on all your scanned resources inside a scope
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(scope, custom_headers:nil)
      list_async(scope, custom_headers:custom_headers).value!
    end

    #
    # Get security assessments on all your scanned resources inside a scope
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(scope, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'scope is nil' if scope.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{scope}/providers/Microsoft.Security/assessments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'scope' => scope},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_01_01::Models::SecurityAssessmentList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a security assessment on your scanned resource
    #
    # @param resource_id [String] The identifier of the resource.
    # @param assessment_name [String] The Assessment Key - Unique key for the
    # assessment type
    # @param expand [ExpandEnum] OData expand. Optional. Possible values include:
    # 'links', 'metadata'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SecurityAssessment] operation results.
    #
    def get(resource_id, assessment_name, expand:nil, custom_headers:nil)
      response = get_async(resource_id, assessment_name, expand:expand, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a security assessment on your scanned resource
    #
    # @param resource_id [String] The identifier of the resource.
    # @param assessment_name [String] The Assessment Key - Unique key for the
    # assessment type
    # @param expand [ExpandEnum] OData expand. Optional. Possible values include:
    # 'links', 'metadata'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_id, assessment_name, expand:nil, custom_headers:nil)
      get_async(resource_id, assessment_name, expand:expand, custom_headers:custom_headers).value!
    end

    #
    # Get a security assessment on your scanned resource
    #
    # @param resource_id [String] The identifier of the resource.
    # @param assessment_name [String] The Assessment Key - Unique key for the
    # assessment type
    # @param expand [ExpandEnum] OData expand. Optional. Possible values include:
    # 'links', 'metadata'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_id, assessment_name, expand:nil, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?
      fail ArgumentError, 'assessment_name is nil' if assessment_name.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'assessmentName' => assessment_name},
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'api-version' => @client.api_version,'$expand' => expand},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_01_01::Models::SecurityAssessment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a security assessment on your resource. An assessment metadata that
    # describes this assessment must be predefined with the same name before
    # inserting the assessment result
    #
    # @param resource_id [String] The identifier of the resource.
    # @param assessment_name [String] The Assessment Key - Unique key for the
    # assessment type
    # @param assessment [SecurityAssessment] Calculated assessment on a pre-defined
    # assessment metadata
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SecurityAssessment] operation results.
    #
    def create_or_update(resource_id, assessment_name, assessment, custom_headers:nil)
      response = create_or_update_async(resource_id, assessment_name, assessment, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a security assessment on your resource. An assessment metadata that
    # describes this assessment must be predefined with the same name before
    # inserting the assessment result
    #
    # @param resource_id [String] The identifier of the resource.
    # @param assessment_name [String] The Assessment Key - Unique key for the
    # assessment type
    # @param assessment [SecurityAssessment] Calculated assessment on a pre-defined
    # assessment metadata
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_with_http_info(resource_id, assessment_name, assessment, custom_headers:nil)
      create_or_update_async(resource_id, assessment_name, assessment, custom_headers:custom_headers).value!
    end

    #
    # Create a security assessment on your resource. An assessment metadata that
    # describes this assessment must be predefined with the same name before
    # inserting the assessment result
    #
    # @param resource_id [String] The identifier of the resource.
    # @param assessment_name [String] The Assessment Key - Unique key for the
    # assessment type
    # @param assessment [SecurityAssessment] Calculated assessment on a pre-defined
    # assessment metadata
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_async(resource_id, assessment_name, assessment, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?
      fail ArgumentError, 'assessment_name is nil' if assessment_name.nil?
      fail ArgumentError, 'assessment is nil' if assessment.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Security::Mgmt::V2020_01_01::Models::SecurityAssessment.mapper()
      request_content = @client.serialize(request_mapper,  assessment)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'assessmentName' => assessment_name},
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 201 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_01_01::Models::SecurityAssessment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_01_01::Models::SecurityAssessment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a security assessment on your resource. An assessment metadata that
    # describes this assessment must be predefined with the same name before
    # inserting the assessment result
    #
    # @param resource_id [String] The identifier of the resource.
    # @param assessment_name [String] The Assessment Key - Unique key for the
    # assessment type
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(resource_id, assessment_name, custom_headers:nil)
      response = delete_async(resource_id, assessment_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Delete a security assessment on your resource. An assessment metadata that
    # describes this assessment must be predefined with the same name before
    # inserting the assessment result
    #
    # @param resource_id [String] The identifier of the resource.
    # @param assessment_name [String] The Assessment Key - Unique key for the
    # assessment type
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_id, assessment_name, custom_headers:nil)
      delete_async(resource_id, assessment_name, custom_headers:custom_headers).value!
    end

    #
    # Delete a security assessment on your resource. An assessment metadata that
    # describes this assessment must be predefined with the same name before
    # inserting the assessment result
    #
    # @param resource_id [String] The identifier of the resource.
    # @param assessment_name [String] The Assessment Key - Unique key for the
    # assessment type
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_id, assessment_name, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?
      fail ArgumentError, 'assessment_name is nil' if assessment_name.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'assessmentName' => assessment_name},
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get security assessments on all your scanned resources inside a scope
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SecurityAssessmentList] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get security assessments on all your scanned resources inside a scope
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Get security assessments on all your scanned resources inside a scope
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_01_01::Models::SecurityAssessmentList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get security assessments on all your scanned resources inside a scope
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SecurityAssessmentList] which provide lazy access to pages of the
    # response.
    #
    def list_as_lazy(scope, custom_headers:nil)
      response = list_async(scope, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
