# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_01_01
  #
  # API spec for Microsoft.Security (Azure Security Center) resource provider
  #
  class AdaptiveNetworkHardenings
    include MsRestAzure

    #
    # Creates and initializes a new instance of the AdaptiveNetworkHardenings class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [SecurityCenter] reference to the SecurityCenter
    attr_reader :client

    #
    # Gets a list of Adaptive Network Hardenings resources in scope of an extended
    # resource.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param resource_namespace [String] The Namespace of the resource.
    # @param resource_type [String] The type of the resource.
    # @param resource_name [String] Name of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<AdaptiveNetworkHardening>] operation results.
    #
    def list_by_extended_resource(resource_group_name, resource_namespace, resource_type, resource_name, custom_headers:nil)
      first_page = list_by_extended_resource_as_lazy(resource_group_name, resource_namespace, resource_type, resource_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets a list of Adaptive Network Hardenings resources in scope of an extended
    # resource.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param resource_namespace [String] The Namespace of the resource.
    # @param resource_type [String] The type of the resource.
    # @param resource_name [String] Name of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_extended_resource_with_http_info(resource_group_name, resource_namespace, resource_type, resource_name, custom_headers:nil)
      list_by_extended_resource_async(resource_group_name, resource_namespace, resource_type, resource_name, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of Adaptive Network Hardenings resources in scope of an extended
    # resource.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param resource_namespace [String] The Namespace of the resource.
    # @param resource_type [String] The type of the resource.
    # @param resource_name [String] Name of the resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_extended_resource_async(resource_group_name, resource_namespace, resource_type, resource_name, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'Pattern': '^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$'" if !@client.subscription_id.nil? && @client.subscription_id.match(Regexp.new('^^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$$')).nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'resource_namespace is nil' if resource_namespace.nil?
      fail ArgumentError, 'resource_type is nil' if resource_type.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/adaptiveNetworkHardenings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceNamespace' => resource_namespace,'resourceType' => resource_type,'resourceName' => resource_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_01_01::Models::AdaptiveNetworkHardeningsList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a single Adaptive Network Hardening resource
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param resource_namespace [String] The Namespace of the resource.
    # @param resource_type [String] The type of the resource.
    # @param resource_name [String] Name of the resource.
    # @param adaptive_network_hardening_resource_name [String] The name of the
    # Adaptive Network Hardening resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AdaptiveNetworkHardening] operation results.
    #
    def get(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, custom_headers:nil)
      response = get_async(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a single Adaptive Network Hardening resource
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param resource_namespace [String] The Namespace of the resource.
    # @param resource_type [String] The type of the resource.
    # @param resource_name [String] Name of the resource.
    # @param adaptive_network_hardening_resource_name [String] The name of the
    # Adaptive Network Hardening resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, custom_headers:nil)
      get_async(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, custom_headers:custom_headers).value!
    end

    #
    # Gets a single Adaptive Network Hardening resource
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param resource_namespace [String] The Namespace of the resource.
    # @param resource_type [String] The type of the resource.
    # @param resource_name [String] Name of the resource.
    # @param adaptive_network_hardening_resource_name [String] The name of the
    # Adaptive Network Hardening resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'Pattern': '^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$'" if !@client.subscription_id.nil? && @client.subscription_id.match(Regexp.new('^^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$$')).nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'resource_namespace is nil' if resource_namespace.nil?
      fail ArgumentError, 'resource_type is nil' if resource_type.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'adaptive_network_hardening_resource_name is nil' if adaptive_network_hardening_resource_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/adaptiveNetworkHardenings/{adaptiveNetworkHardeningResourceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceNamespace' => resource_namespace,'resourceType' => resource_type,'resourceName' => resource_name,'adaptiveNetworkHardeningResourceName' => adaptive_network_hardening_resource_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_01_01::Models::AdaptiveNetworkHardening.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Enforces the given rules on the NSG(s) listed in the request
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param resource_namespace [String] The Namespace of the resource.
    # @param resource_type [String] The type of the resource.
    # @param resource_name [String] Name of the resource.
    # @param adaptive_network_hardening_resource_name [String] The name of the
    # Adaptive Network Hardening resource.
    # @param body [AdaptiveNetworkHardeningEnforceRequest]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def enforce(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, body, custom_headers:nil)
      response = enforce_async(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, body, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param resource_namespace [String] The Namespace of the resource.
    # @param resource_type [String] The type of the resource.
    # @param resource_name [String] Name of the resource.
    # @param adaptive_network_hardening_resource_name [String] The name of the
    # Adaptive Network Hardening resource.
    # @param body [AdaptiveNetworkHardeningEnforceRequest]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def enforce_async(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, body, custom_headers:nil)
      # Send request
      promise = begin_enforce_async(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, body, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Enforces the given rules on the NSG(s) listed in the request
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param resource_namespace [String] The Namespace of the resource.
    # @param resource_type [String] The type of the resource.
    # @param resource_name [String] Name of the resource.
    # @param adaptive_network_hardening_resource_name [String] The name of the
    # Adaptive Network Hardening resource.
    # @param body [AdaptiveNetworkHardeningEnforceRequest]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_enforce(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, body, custom_headers:nil)
      response = begin_enforce_async(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, body, custom_headers:custom_headers).value!
      nil
    end

    #
    # Enforces the given rules on the NSG(s) listed in the request
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param resource_namespace [String] The Namespace of the resource.
    # @param resource_type [String] The type of the resource.
    # @param resource_name [String] Name of the resource.
    # @param adaptive_network_hardening_resource_name [String] The name of the
    # Adaptive Network Hardening resource.
    # @param body [AdaptiveNetworkHardeningEnforceRequest]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_enforce_with_http_info(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, body, custom_headers:nil)
      begin_enforce_async(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, body, custom_headers:custom_headers).value!
    end

    #
    # Enforces the given rules on the NSG(s) listed in the request
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param resource_namespace [String] The Namespace of the resource.
    # @param resource_type [String] The type of the resource.
    # @param resource_name [String] Name of the resource.
    # @param adaptive_network_hardening_resource_name [String] The name of the
    # Adaptive Network Hardening resource.
    # @param body [AdaptiveNetworkHardeningEnforceRequest]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_enforce_async(resource_group_name, resource_namespace, resource_type, resource_name, adaptive_network_hardening_resource_name, body, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'Pattern': '^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$'" if !@client.subscription_id.nil? && @client.subscription_id.match(Regexp.new('^^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$$')).nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'resource_namespace is nil' if resource_namespace.nil?
      fail ArgumentError, 'resource_type is nil' if resource_type.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'adaptive_network_hardening_resource_name is nil' if adaptive_network_hardening_resource_name.nil?
      adaptive_network_hardening_enforce_action = 'enforce'
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'body is nil' if body.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Security::Mgmt::V2020_01_01::Models::AdaptiveNetworkHardeningEnforceRequest.mapper()
      request_content = @client.serialize(request_mapper,  body)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/adaptiveNetworkHardenings/{adaptiveNetworkHardeningResourceName}/{adaptiveNetworkHardeningEnforceAction}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceNamespace' => resource_namespace,'resourceType' => resource_type,'resourceName' => resource_name,'adaptiveNetworkHardeningResourceName' => adaptive_network_hardening_resource_name,'adaptiveNetworkHardeningEnforceAction' => adaptive_network_hardening_enforce_action},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets a list of Adaptive Network Hardenings resources in scope of an extended
    # resource.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AdaptiveNetworkHardeningsList] operation results.
    #
    def list_by_extended_resource_next(next_page_link, custom_headers:nil)
      response = list_by_extended_resource_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a list of Adaptive Network Hardenings resources in scope of an extended
    # resource.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_extended_resource_next_with_http_info(next_page_link, custom_headers:nil)
      list_by_extended_resource_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of Adaptive Network Hardenings resources in scope of an extended
    # resource.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_extended_resource_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_01_01::Models::AdaptiveNetworkHardeningsList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of Adaptive Network Hardenings resources in scope of an extended
    # resource.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param resource_namespace [String] The Namespace of the resource.
    # @param resource_type [String] The type of the resource.
    # @param resource_name [String] Name of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AdaptiveNetworkHardeningsList] which provide lazy access to pages of
    # the response.
    #
    def list_by_extended_resource_as_lazy(resource_group_name, resource_namespace, resource_type, resource_name, custom_headers:nil)
      response = list_by_extended_resource_async(resource_group_name, resource_namespace, resource_type, resource_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_extended_resource_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
