# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_01_01_preview
  module Models
    #
    # GCP cloud account connector based service to service credentials, the
    # credentials are composed of the organization ID and a JSON API key (write
    # only)
    #
    class GcpCredentialsDetailsProperties < AuthenticationDetailsProperties

      include MsRestAzure


      def initialize
        @authenticationType = "gcpCredentials"
      end

      attr_accessor :authenticationType

      # @return [String] The organization ID of the GCP cloud account
      attr_accessor :organization_id

      # @return [String] Type field of the API key (write only)
      attr_accessor :type

      # @return [String] Project ID field of the API key (write only)
      attr_accessor :project_id

      # @return [String] Private key ID field of the API key (write only)
      attr_accessor :private_key_id

      # @return [String] Private key field of the API key (write only)
      attr_accessor :private_key

      # @return [String] Client email field of the API key (write only)
      attr_accessor :client_email

      # @return [String] Client ID field of the API key (write only)
      attr_accessor :client_id

      # @return [String] Auth URI field of the API key (write only)
      attr_accessor :auth_uri

      # @return [String] Token URI field of the API key (write only)
      attr_accessor :token_uri

      # @return [String] Auth provider x509 certificate URL field of the API
      # key (write only)
      attr_accessor :auth_provider_x509cert_url

      # @return [String] Client x509 certificate URL field of the API key
      # (write only)
      attr_accessor :client_x509cert_url


      #
      # Mapper for GcpCredentialsDetailsProperties class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'gcpCredentials',
          type: {
            name: 'Composite',
            class_name: 'GcpCredentialsDetailsProperties',
            model_properties: {
              authentication_provisioning_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'authenticationProvisioningState',
                type: {
                  name: 'String'
                }
              },
              granted_permissions: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'grantedPermissions',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'PermissionPropertyElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              authenticationType: {
                client_side_validation: true,
                required: true,
                serialized_name: 'authenticationType',
                type: {
                  name: 'String'
                }
              },
              organization_id: {
                client_side_validation: true,
                required: true,
                serialized_name: 'organizationId',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              project_id: {
                client_side_validation: true,
                required: true,
                serialized_name: 'projectId',
                type: {
                  name: 'String'
                }
              },
              private_key_id: {
                client_side_validation: true,
                required: true,
                serialized_name: 'privateKeyId',
                type: {
                  name: 'String'
                }
              },
              private_key: {
                client_side_validation: true,
                required: true,
                serialized_name: 'privateKey',
                type: {
                  name: 'String'
                }
              },
              client_email: {
                client_side_validation: true,
                required: true,
                serialized_name: 'clientEmail',
                type: {
                  name: 'String'
                }
              },
              client_id: {
                client_side_validation: true,
                required: true,
                serialized_name: 'clientId',
                type: {
                  name: 'String'
                }
              },
              auth_uri: {
                client_side_validation: true,
                required: true,
                serialized_name: 'authUri',
                type: {
                  name: 'String'
                }
              },
              token_uri: {
                client_side_validation: true,
                required: true,
                serialized_name: 'tokenUri',
                type: {
                  name: 'String'
                }
              },
              auth_provider_x509cert_url: {
                client_side_validation: true,
                required: true,
                serialized_name: 'authProviderX509CertUrl',
                type: {
                  name: 'String'
                }
              },
              client_x509cert_url: {
                client_side_validation: true,
                required: true,
                serialized_name: 'clientX509CertUrl',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
