# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_01_01_preview
  module Models
    #
    # AWS cloud account connector based credentials, the credentials is
    # composed of access key ID and secret key, for more details, refer to <a
    # href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_create.html">Creating
    # an IAM User in Your AWS Account (write only)</a>
    #
    class AwsCredsAuthenticationDetailsProperties < AuthenticationDetailsProperties

      include MsRestAzure


      def initialize
        @authenticationType = "awsCreds"
      end

      attr_accessor :authenticationType

      # @return [String] The ID of the cloud account
      attr_accessor :account_id

      # @return [String] Public key element of the AWS credential object (write
      # only)
      attr_accessor :aws_access_key_id

      # @return [String] Secret key element of the AWS credential object (write
      # only)
      attr_accessor :aws_secret_access_key


      #
      # Mapper for AwsCredsAuthenticationDetailsProperties class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'awsCreds',
          type: {
            name: 'Composite',
            class_name: 'AwsCredsAuthenticationDetailsProperties',
            model_properties: {
              authentication_provisioning_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'authenticationProvisioningState',
                type: {
                  name: 'String'
                }
              },
              granted_permissions: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'grantedPermissions',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'PermissionPropertyElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              authenticationType: {
                client_side_validation: true,
                required: true,
                serialized_name: 'authenticationType',
                type: {
                  name: 'String'
                }
              },
              account_id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'accountId',
                type: {
                  name: 'String'
                }
              },
              aws_access_key_id: {
                client_side_validation: true,
                required: true,
                serialized_name: 'awsAccessKeyId',
                type: {
                  name: 'String'
                }
              },
              aws_secret_access_key: {
                client_side_validation: true,
                required: true,
                serialized_name: 'awsSecretAccessKey',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
