# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_01_01_preview
  module Models
    #
    # AWS cloud account connector based assume role, the role enables
    # delegating access to your AWS resources. The role is composed of role
    # Amazon Resource Name (ARN) and external ID. For more details, refer to <a
    # href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user.html">Creating
    # a Role to Delegate Permissions to an IAM User (write only)</a>
    #
    class AwAssumeRoleAuthenticationDetailsProperties < AuthenticationDetailsProperties

      include MsRestAzure


      def initialize
        @authenticationType = "awsAssumeRole"
      end

      attr_accessor :authenticationType

      # @return [String] The ID of the cloud account
      attr_accessor :account_id

      # @return [String] Assumed role ID is an identifier that you can use to
      # create temporary security credentials.
      attr_accessor :aws_assume_role_arn

      # @return [String] A unique identifier that is required when you assume a
      # role in another account.
      attr_accessor :aws_external_id


      #
      # Mapper for AwAssumeRoleAuthenticationDetailsProperties class as Ruby
      # Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'awsAssumeRole',
          type: {
            name: 'Composite',
            class_name: 'AwAssumeRoleAuthenticationDetailsProperties',
            model_properties: {
              authentication_provisioning_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'authenticationProvisioningState',
                type: {
                  name: 'String'
                }
              },
              granted_permissions: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'grantedPermissions',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'PermissionPropertyElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              authenticationType: {
                client_side_validation: true,
                required: true,
                serialized_name: 'authenticationType',
                type: {
                  name: 'String'
                }
              },
              account_id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'accountId',
                type: {
                  name: 'String'
                }
              },
              aws_assume_role_arn: {
                client_side_validation: true,
                required: true,
                serialized_name: 'awsAssumeRoleArn',
                type: {
                  name: 'String'
                }
              },
              aws_external_id: {
                client_side_validation: true,
                required: true,
                serialized_name: 'awsExternalId',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
