# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2019_08_01
  module Models
    #
    # IoT alert type.
    #
    class IotAlertType < Resource

      include MsRestAzure

      # @return [String] The display name of the alert
      attr_accessor :alert_display_name

      # @return [AlertSeverity] The severity of the alert. Possible values
      # include: 'Informational', 'Low', 'Medium', 'High'
      attr_accessor :severity

      # @return [String] Description of the suspected vulnerability and
      # meaning.
      attr_accessor :description

      # @return [String] The name of the alert provider or internal partner
      attr_accessor :provider_name

      # @return [String] The name of the product which published this alert
      attr_accessor :product_name

      # @return [String] The name of a component inside the product which
      # generated the alert
      attr_accessor :product_component_name

      # @return [String] The name of the vendor that raise the alert
      attr_accessor :vendor_name

      # @return [AlertIntent] Kill chain related intent behind the alert. Could
      # contain multiple enum values (separated by commas). Possible values
      # include: 'Unknown', 'PreAttack', 'InitialAccess', 'Persistence',
      # 'PrivilegeEscalation', 'DefenseEvasion', 'CredentialAccess',
      # 'Discovery', 'LateralMovement', 'Execution', 'Collection',
      # 'Exfiltration', 'CommandAndControl', 'Impact', 'Probing',
      # 'Exploitation'
      attr_accessor :intent

      # @return [Array<String>] Manual action items to take to remediate the
      # alert
      attr_accessor :remediation_steps


      #
      # Mapper for IotAlertType class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'IotAlertType',
          type: {
            name: 'Composite',
            class_name: 'IotAlertType',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              alert_display_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.alertDisplayName',
                type: {
                  name: 'String'
                }
              },
              severity: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.severity',
                type: {
                  name: 'String'
                }
              },
              description: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.description',
                type: {
                  name: 'String'
                }
              },
              provider_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.providerName',
                type: {
                  name: 'String'
                }
              },
              product_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.productName',
                type: {
                  name: 'String'
                }
              },
              product_component_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.productComponentName',
                type: {
                  name: 'String'
                }
              },
              vendor_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.vendorName',
                type: {
                  name: 'String'
                }
              },
              intent: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.intent',
                type: {
                  name: 'String'
                }
              },
              remediation_steps: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.remediationSteps',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
