# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2019_01_01_preview
  #
  # API spec for Microsoft.Security (Azure Security Center) resource provider
  #
  class RegulatoryComplianceAssessments
    include MsRestAzure

    #
    # Creates and initializes a new instance of the RegulatoryComplianceAssessments class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [SecurityCenter] reference to the SecurityCenter
    attr_reader :client

    #
    # Details and state of assessments mapped to selected regulatory compliance
    # control
    #
    # @param regulatory_compliance_standard_name [String] Name of the regulatory
    # compliance standard object
    # @param regulatory_compliance_control_name [String] Name of the regulatory
    # compliance control object
    # @param filter [String] OData filter. Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<RegulatoryComplianceAssessment>] operation results.
    #
    def list(regulatory_compliance_standard_name, regulatory_compliance_control_name, filter:nil, custom_headers:nil)
      first_page = list_as_lazy(regulatory_compliance_standard_name, regulatory_compliance_control_name, filter:filter, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Details and state of assessments mapped to selected regulatory compliance
    # control
    #
    # @param regulatory_compliance_standard_name [String] Name of the regulatory
    # compliance standard object
    # @param regulatory_compliance_control_name [String] Name of the regulatory
    # compliance control object
    # @param filter [String] OData filter. Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(regulatory_compliance_standard_name, regulatory_compliance_control_name, filter:nil, custom_headers:nil)
      list_async(regulatory_compliance_standard_name, regulatory_compliance_control_name, filter:filter, custom_headers:custom_headers).value!
    end

    #
    # Details and state of assessments mapped to selected regulatory compliance
    # control
    #
    # @param regulatory_compliance_standard_name [String] Name of the regulatory
    # compliance standard object
    # @param regulatory_compliance_control_name [String] Name of the regulatory
    # compliance control object
    # @param filter [String] OData filter. Optional.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(regulatory_compliance_standard_name, regulatory_compliance_control_name, filter:nil, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'Pattern': '^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$'" if !@client.subscription_id.nil? && @client.subscription_id.match(Regexp.new('^^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$$')).nil?
      fail ArgumentError, 'regulatory_compliance_standard_name is nil' if regulatory_compliance_standard_name.nil?
      fail ArgumentError, 'regulatory_compliance_control_name is nil' if regulatory_compliance_control_name.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Security/regulatoryComplianceStandards/{regulatoryComplianceStandardName}/regulatoryComplianceControls/{regulatoryComplianceControlName}/regulatoryComplianceAssessments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'regulatoryComplianceStandardName' => regulatory_compliance_standard_name,'regulatoryComplianceControlName' => regulatory_compliance_control_name},
          query_params: {'api-version' => @client.api_version,'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2019_01_01_preview::Models::RegulatoryComplianceAssessmentList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Supported regulatory compliance details and state for selected assessment
    #
    # @param regulatory_compliance_standard_name [String] Name of the regulatory
    # compliance standard object
    # @param regulatory_compliance_control_name [String] Name of the regulatory
    # compliance control object
    # @param regulatory_compliance_assessment_name [String] Name of the regulatory
    # compliance assessment object
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RegulatoryComplianceAssessment] operation results.
    #
    def get(regulatory_compliance_standard_name, regulatory_compliance_control_name, regulatory_compliance_assessment_name, custom_headers:nil)
      response = get_async(regulatory_compliance_standard_name, regulatory_compliance_control_name, regulatory_compliance_assessment_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Supported regulatory compliance details and state for selected assessment
    #
    # @param regulatory_compliance_standard_name [String] Name of the regulatory
    # compliance standard object
    # @param regulatory_compliance_control_name [String] Name of the regulatory
    # compliance control object
    # @param regulatory_compliance_assessment_name [String] Name of the regulatory
    # compliance assessment object
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(regulatory_compliance_standard_name, regulatory_compliance_control_name, regulatory_compliance_assessment_name, custom_headers:nil)
      get_async(regulatory_compliance_standard_name, regulatory_compliance_control_name, regulatory_compliance_assessment_name, custom_headers:custom_headers).value!
    end

    #
    # Supported regulatory compliance details and state for selected assessment
    #
    # @param regulatory_compliance_standard_name [String] Name of the regulatory
    # compliance standard object
    # @param regulatory_compliance_control_name [String] Name of the regulatory
    # compliance control object
    # @param regulatory_compliance_assessment_name [String] Name of the regulatory
    # compliance assessment object
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(regulatory_compliance_standard_name, regulatory_compliance_control_name, regulatory_compliance_assessment_name, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'Pattern': '^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$'" if !@client.subscription_id.nil? && @client.subscription_id.match(Regexp.new('^^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$$')).nil?
      fail ArgumentError, 'regulatory_compliance_standard_name is nil' if regulatory_compliance_standard_name.nil?
      fail ArgumentError, 'regulatory_compliance_control_name is nil' if regulatory_compliance_control_name.nil?
      fail ArgumentError, 'regulatory_compliance_assessment_name is nil' if regulatory_compliance_assessment_name.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Security/regulatoryComplianceStandards/{regulatoryComplianceStandardName}/regulatoryComplianceControls/{regulatoryComplianceControlName}/regulatoryComplianceAssessments/{regulatoryComplianceAssessmentName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'regulatoryComplianceStandardName' => regulatory_compliance_standard_name,'regulatoryComplianceControlName' => regulatory_compliance_control_name,'regulatoryComplianceAssessmentName' => regulatory_compliance_assessment_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2019_01_01_preview::Models::RegulatoryComplianceAssessment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Details and state of assessments mapped to selected regulatory compliance
    # control
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RegulatoryComplianceAssessmentList] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Details and state of assessments mapped to selected regulatory compliance
    # control
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Details and state of assessments mapped to selected regulatory compliance
    # control
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2019_01_01_preview::Models::RegulatoryComplianceAssessmentList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Details and state of assessments mapped to selected regulatory compliance
    # control
    #
    # @param regulatory_compliance_standard_name [String] Name of the regulatory
    # compliance standard object
    # @param regulatory_compliance_control_name [String] Name of the regulatory
    # compliance control object
    # @param filter [String] OData filter. Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RegulatoryComplianceAssessmentList] which provide lazy access to
    # pages of the response.
    #
    def list_as_lazy(regulatory_compliance_standard_name, regulatory_compliance_control_name, filter:nil, custom_headers:nil)
      response = list_async(regulatory_compliance_standard_name, regulatory_compliance_control_name, filter:filter, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
