# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2019_01_01_preview
  module Models
    #
    # Describes the suppression rule
    #
    class AlertsSuppressionRule < Resource

      include MsRestAzure

      # @return [String] Type of the alert to automatically suppress. For all
      # alert types, use '*'
      attr_accessor :alert_type

      # @return [DateTime] The last time this rule was modified
      attr_accessor :last_modified_utc

      # @return [DateTime] Expiration date of the rule, if value is not
      # provided or provided as null this field will default to the maximum
      # allowed expiration date.
      attr_accessor :expiration_date_utc

      # @return [String] The reason for dismissing the alert
      attr_accessor :reason

      # @return [RuleState] Possible states of the rule. Possible values
      # include: 'Enabled', 'Disabled', 'Expired'
      attr_accessor :state

      # @return [String] Any comment regarding the rule
      attr_accessor :comment

      # @return [SuppressionAlertsScope] The suppression conditions
      attr_accessor :suppression_alerts_scope


      #
      # Mapper for AlertsSuppressionRule class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'AlertsSuppressionRule',
          type: {
            name: 'Composite',
            class_name: 'AlertsSuppressionRule',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              alert_type: {
                client_side_validation: true,
                required: true,
                serialized_name: 'properties.alertType',
                type: {
                  name: 'String'
                }
              },
              last_modified_utc: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.lastModifiedUtc',
                type: {
                  name: 'DateTime'
                }
              },
              expiration_date_utc: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.expirationDateUtc',
                type: {
                  name: 'DateTime'
                }
              },
              reason: {
                client_side_validation: true,
                required: true,
                serialized_name: 'properties.reason',
                type: {
                  name: 'String'
                }
              },
              state: {
                client_side_validation: true,
                required: true,
                serialized_name: 'properties.state',
                type: {
                  name: 'Enum',
                  module: 'RuleState'
                }
              },
              comment: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.comment',
                type: {
                  name: 'String'
                }
              },
              suppression_alerts_scope: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.suppressionAlertsScope',
                type: {
                  name: 'Composite',
                  class_name: 'SuppressionAlertsScope'
                }
              }
            }
          }
        }
      end
    end
  end
end
