# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2017_08_01_preview
  module Models
    #
    # Security Solution Recommendation Information
    #
    class IoTSecurityAggregatedRecommendation

      include MsRestAzure

      # @return [String] Resource Id
      attr_accessor :id

      # @return [String] Resource name
      attr_accessor :name

      # @return [String] Resource type
      attr_accessor :type

      # @return [Hash{String => String}] Resource tags
      attr_accessor :tags

      # @return [String] Name of the recommendation
      attr_accessor :recommendation_name

      # @return [String] Display name of the recommendation type.
      attr_accessor :recommendation_display_name

      # @return [String] Description of the incident and what it means
      attr_accessor :description

      # @return [String] The recommendation-type GUID.
      attr_accessor :recommendation_type_id

      # @return [String] Name of the vendor that discovered the issue
      attr_accessor :detected_by

      # @return [String] Recommended steps for remediation
      attr_accessor :remediation_steps

      # @return [ReportedSeverity] Estimated severity of this recommendation.
      # Possible values include: 'Informational', 'Low', 'Medium', 'High'
      attr_accessor :reported_severity

      # @return [Integer] the number of the healthy devices within the solution
      attr_accessor :healthy_devices

      # @return [Integer] the number of the unhealthy devices within the
      # solution
      attr_accessor :unhealthy_device_count

      # @return [String] query in log analytics to get the list of affected
      # devices/alerts
      attr_accessor :log_analytics_query


      #
      # Mapper for IoTSecurityAggregatedRecommendation class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'IoTSecurityAggregatedRecommendation',
          type: {
            name: 'Composite',
            class_name: 'IoTSecurityAggregatedRecommendation',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              tags: {
                client_side_validation: true,
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              recommendation_name: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.recommendationName',
                type: {
                  name: 'String'
                }
              },
              recommendation_display_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.recommendationDisplayName',
                type: {
                  name: 'String'
                }
              },
              description: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.description',
                type: {
                  name: 'String'
                }
              },
              recommendation_type_id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.recommendationTypeId',
                type: {
                  name: 'String'
                }
              },
              detected_by: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.detectedBy',
                type: {
                  name: 'String'
                }
              },
              remediation_steps: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.remediationSteps',
                type: {
                  name: 'String'
                }
              },
              reported_severity: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.reportedSeverity',
                type: {
                  name: 'String'
                }
              },
              healthy_devices: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.healthyDevices',
                type: {
                  name: 'Number'
                }
              },
              unhealthy_device_count: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.unhealthyDeviceCount',
                type: {
                  name: 'Number'
                }
              },
              log_analytics_query: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.logAnalyticsQuery',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
