# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2015_06_01_preview
  module Models
    #
    # Security task that we recommend to do in order to strengthen security
    #
    class SecurityTask < Resource

      include MsRestAzure

      # @return [String] State of the task (Active, Resolved etc.)
      attr_accessor :state

      # @return [DateTime] The time this task was discovered in UTC
      attr_accessor :creation_time_utc

      # @return [SecurityTaskParameters]
      attr_accessor :security_task_parameters

      # @return [DateTime] The time this task's details were last changed in
      # UTC
      attr_accessor :last_state_change_time_utc

      # @return [String] Additional data on the state of the task
      attr_accessor :sub_state


      #
      # Mapper for SecurityTask class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'SecurityTask',
          type: {
            name: 'Composite',
            class_name: 'SecurityTask',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.state',
                type: {
                  name: 'String'
                }
              },
              creation_time_utc: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.creationTimeUtc',
                type: {
                  name: 'DateTime'
                }
              },
              security_task_parameters: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.securityTaskParameters',
                type: {
                  name: 'Composite',
                  class_name: 'SecurityTaskParameters'
                }
              },
              last_state_change_time_utc: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.lastStateChangeTimeUtc',
                type: {
                  name: 'DateTime'
                }
              },
              sub_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.subState',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
