# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2015_06_01_preview
  module Models
    #
    # Describes remote addresses that is recommended to communicate with the
    # Azure resource on some (Protocol, Port, Direction). All other remote
    # addresses are recommended to be blocked
    #
    class Rule

      include MsRestAzure

      # @return [String] The name of the rule
      attr_accessor :name

      # @return [Direction] The rule's direction. Possible values include:
      # 'Inbound', 'Outbound'
      attr_accessor :direction

      # @return [Integer] The rule's destination port
      attr_accessor :destination_port

      # @return [Array<TransportProtocol>] The rule's transport protocols
      attr_accessor :protocols

      # @return [Array<String>] The remote IP addresses that should be able to
      # communicate with the Azure resource on the rule's destination port and
      # protocol
      attr_accessor :ip_addresses


      #
      # Mapper for Rule class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'Rule',
          type: {
            name: 'Composite',
            class_name: 'Rule',
            model_properties: {
              name: {
                client_side_validation: true,
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              direction: {
                client_side_validation: true,
                required: false,
                serialized_name: 'direction',
                type: {
                  name: 'String'
                }
              },
              destination_port: {
                client_side_validation: true,
                required: false,
                serialized_name: 'destinationPort',
                type: {
                  name: 'Number'
                }
              },
              protocols: {
                client_side_validation: true,
                required: false,
                serialized_name: 'protocols',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'TransportProtocolElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              ip_addresses: {
                client_side_validation: true,
                required: false,
                serialized_name: 'ipAddresses',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
