# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2015_06_01_preview
  module Models
    #
    # Security alert
    #
    class Alert < Resource

      include MsRestAzure

      # @return [String] State of the alert (Active, Dismissed etc.)
      attr_accessor :state

      # @return [DateTime] The time the incident was reported to
      # Microsoft.Security in UTC
      attr_accessor :reported_time_utc

      # @return [String] Name of the vendor that discovered the incident
      attr_accessor :vendor_name

      # @return [String] Name of the alert type
      attr_accessor :alert_name

      # @return [String] Display name of the alert type
      attr_accessor :alert_display_name

      # @return [DateTime] The time the incident was detected by the vendor
      attr_accessor :detected_time_utc

      # @return [String] Description of the incident and what it means
      attr_accessor :description

      # @return [String] Recommended steps to reradiate the incident
      attr_accessor :remediation_steps

      # @return [String] The action that was taken as a response to the alert
      # (Active, Blocked etc.)
      attr_accessor :action_taken

      # @return [ReportedSeverity] Estimated severity of this alert. Possible
      # values include: 'Silent', 'Information', 'Low', 'High'
      attr_accessor :reported_severity

      # @return [String] The entity that the incident happened on
      attr_accessor :compromised_entity

      # @return [String] Azure resource ID of the associated resource
      attr_accessor :associated_resource

      # @return
      attr_accessor :extended_properties

      # @return [String] The type of the alerted resource (Azure, Non-Azure)
      attr_accessor :system_source

      # @return [Boolean] Whether this alert can be investigated with Azure
      # Security Center
      attr_accessor :can_be_investigated

      # @return [Boolean] Whether this alert is for incident type or not
      # (otherwise - single alert)
      attr_accessor :is_incident

      # @return [Array<AlertEntity>] objects that are related to this alerts
      attr_accessor :entities

      # @return [Float] level of confidence we have on the alert
      attr_accessor :confidence_score

      # @return [Array<AlertConfidenceReason>] reasons the alert got the
      # confidenceScore value
      attr_accessor :confidence_reasons

      # @return [String] Azure subscription ID of the resource that had the
      # security alert or the subscription ID of the workspace that this
      # resource reports to
      attr_accessor :subscription_id

      # @return [String] Instance ID of the alert.
      attr_accessor :instance_id

      # @return [String] Azure resource ID of the workspace that the alert was
      # reported to.
      attr_accessor :workspace_arm_id

      # @return [String] Alerts with the same CorrelationKey will be grouped
      # together in Ibiza.
      attr_accessor :correlation_key


      #
      # Mapper for Alert class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'Alert',
          type: {
            name: 'Composite',
            class_name: 'Alert',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.state',
                type: {
                  name: 'String'
                }
              },
              reported_time_utc: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.reportedTimeUtc',
                type: {
                  name: 'DateTime'
                }
              },
              vendor_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.vendorName',
                type: {
                  name: 'String'
                }
              },
              alert_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.alertName',
                type: {
                  name: 'String'
                }
              },
              alert_display_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.alertDisplayName',
                type: {
                  name: 'String'
                }
              },
              detected_time_utc: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.detectedTimeUtc',
                type: {
                  name: 'DateTime'
                }
              },
              description: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.description',
                type: {
                  name: 'String'
                }
              },
              remediation_steps: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.remediationSteps',
                type: {
                  name: 'String'
                }
              },
              action_taken: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.actionTaken',
                type: {
                  name: 'String'
                }
              },
              reported_severity: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.reportedSeverity',
                type: {
                  name: 'String'
                }
              },
              compromised_entity: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.compromisedEntity',
                type: {
                  name: 'String'
                }
              },
              associated_resource: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.associatedResource',
                type: {
                  name: 'String'
                }
              },
              extended_properties: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.extendedProperties',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'ObjectElementType',
                      type: {
                        name: 'Object'
                      }
                  }
                }
              },
              system_source: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.systemSource',
                type: {
                  name: 'String'
                }
              },
              can_be_investigated: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.canBeInvestigated',
                type: {
                  name: 'Boolean'
                }
              },
              is_incident: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.isIncident',
                type: {
                  name: 'Boolean'
                }
              },
              entities: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.entities',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'AlertEntityElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'AlertEntity'
                      }
                  }
                }
              },
              confidence_score: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.confidenceScore',
                constraints: {
                  InclusiveMaximum: 1,
                  InclusiveMinimum: 0
                },
                type: {
                  name: 'Double'
                }
              },
              confidence_reasons: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.confidenceReasons',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'AlertConfidenceReasonElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'AlertConfidenceReason'
                      }
                  }
                }
              },
              subscription_id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.subscriptionId',
                type: {
                  name: 'String'
                }
              },
              instance_id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.instanceId',
                type: {
                  name: 'String'
                }
              },
              workspace_arm_id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.workspaceArmId',
                type: {
                  name: 'String'
                }
              },
              correlation_key: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.correlationKey',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
