# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Resources2::Mgmt::V2020_06_01
  #
  # Provides operations for working with resources and resource groups.
  #
  class TagsOperations
    include MsRestAzure2

    #
    # Creates and initializes a new instance of the TagsOperations class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ResourceManagementClient] reference to the ResourceManagementClient
    attr_reader :client

    #
    # Deletes a predefined tag value for a predefined tag name.
    #
    # This operation allows deleting a value from the list of predefined values for
    # an existing predefined tag name. The value being deleted must not be in use
    # as a tag value for the given tag name for any resource.
    #
    # @param tag_name [String] The name of the tag.
    # @param tag_value [String] The value of the tag to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_value(tag_name, tag_value, custom_headers:nil)
      response = delete_value_async(tag_name, tag_value, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes a predefined tag value for a predefined tag name.
    #
    # This operation allows deleting a value from the list of predefined values for
    # an existing predefined tag name. The value being deleted must not be in use
    # as a tag value for the given tag name for any resource.
    #
    # @param tag_name [String] The name of the tag.
    # @param tag_value [String] The value of the tag to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def delete_value_with_http_info(tag_name, tag_value, custom_headers:nil)
      delete_value_async(tag_name, tag_value, custom_headers:custom_headers).value!
    end

    #
    # Deletes a predefined tag value for a predefined tag name.
    #
    # This operation allows deleting a value from the list of predefined values for
    # an existing predefined tag name. The value being deleted must not be in use
    # as a tag value for the given tag name for any resource.
    #
    # @param tag_name [String] The name of the tag.
    # @param tag_value [String] The value of the tag to delete.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_value_async(tag_name, tag_value, custom_headers:nil)
      fail ArgumentError, 'tag_name is nil' if tag_name.nil?
      fail ArgumentError, 'tag_value is nil' if tag_value.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/tagNames/{tagName}/tagValues/{tagValue}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'tagName' => tag_name,'tagValue' => tag_value,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a predefined value for a predefined tag name.
    #
    # This operation allows adding a value to the list of predefined values for an
    # existing predefined tag name. A tag value can have a maximum of 256
    # characters.
    #
    # @param tag_name [String] The name of the tag.
    # @param tag_value [String] The value of the tag to create.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [TagValue] operation results.
    #
    def create_or_update_value(tag_name, tag_value, custom_headers:nil)
      response = create_or_update_value_async(tag_name, tag_value, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a predefined value for a predefined tag name.
    #
    # This operation allows adding a value to the list of predefined values for an
    # existing predefined tag name. A tag value can have a maximum of 256
    # characters.
    #
    # @param tag_name [String] The name of the tag.
    # @param tag_value [String] The value of the tag to create.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_value_with_http_info(tag_name, tag_value, custom_headers:nil)
      create_or_update_value_async(tag_name, tag_value, custom_headers:custom_headers).value!
    end

    #
    # Creates a predefined value for a predefined tag name.
    #
    # This operation allows adding a value to the list of predefined values for an
    # existing predefined tag name. A tag value can have a maximum of 256
    # characters.
    #
    # @param tag_name [String] The name of the tag.
    # @param tag_value [String] The value of the tag to create.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_value_async(tag_name, tag_value, custom_headers:nil)
      fail ArgumentError, 'tag_name is nil' if tag_name.nil?
      fail ArgumentError, 'tag_value is nil' if tag_value.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/tagNames/{tagName}/tagValues/{tagValue}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'tagName' => tag_name,'tagValue' => tag_value,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources2::Mgmt::V2020_06_01::Models::TagValue.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources2::Mgmt::V2020_06_01::Models::TagValue.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a predefined tag name.
    #
    # This operation allows adding a name to the list of predefined tag names for
    # the given subscription. A tag name can have a maximum of 512 characters and
    # is case-insensitive. Tag names cannot have the following prefixes which are
    # reserved for Azure use: 'microsoft', 'azure', 'windows'.
    #
    # @param tag_name [String] The name of the tag to create.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [TagDetails] operation results.
    #
    def create_or_update(tag_name, custom_headers:nil)
      response = create_or_update_async(tag_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a predefined tag name.
    #
    # This operation allows adding a name to the list of predefined tag names for
    # the given subscription. A tag name can have a maximum of 512 characters and
    # is case-insensitive. Tag names cannot have the following prefixes which are
    # reserved for Azure use: 'microsoft', 'azure', 'windows'.
    #
    # @param tag_name [String] The name of the tag to create.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_with_http_info(tag_name, custom_headers:nil)
      create_or_update_async(tag_name, custom_headers:custom_headers).value!
    end

    #
    # Creates a predefined tag name.
    #
    # This operation allows adding a name to the list of predefined tag names for
    # the given subscription. A tag name can have a maximum of 512 characters and
    # is case-insensitive. Tag names cannot have the following prefixes which are
    # reserved for Azure use: 'microsoft', 'azure', 'windows'.
    #
    # @param tag_name [String] The name of the tag to create.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_async(tag_name, custom_headers:nil)
      fail ArgumentError, 'tag_name is nil' if tag_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/tagNames/{tagName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'tagName' => tag_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources2::Mgmt::V2020_06_01::Models::TagDetails.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources2::Mgmt::V2020_06_01::Models::TagDetails.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a predefined tag name.
    #
    # This operation allows deleting a name from the list of predefined tag names
    # for the given subscription. The name being deleted must not be in use as a
    # tag name for any resource. All predefined values for the given name must have
    # already been deleted.
    #
    # @param tag_name [String] The name of the tag.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(tag_name, custom_headers:nil)
      response = delete_async(tag_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes a predefined tag name.
    #
    # This operation allows deleting a name from the list of predefined tag names
    # for the given subscription. The name being deleted must not be in use as a
    # tag name for any resource. All predefined values for the given name must have
    # already been deleted.
    #
    # @param tag_name [String] The name of the tag.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(tag_name, custom_headers:nil)
      delete_async(tag_name, custom_headers:custom_headers).value!
    end

    #
    # Deletes a predefined tag name.
    #
    # This operation allows deleting a name from the list of predefined tag names
    # for the given subscription. The name being deleted must not be in use as a
    # tag name for any resource. All predefined values for the given name must have
    # already been deleted.
    #
    # @param tag_name [String] The name of the tag.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(tag_name, custom_headers:nil)
      fail ArgumentError, 'tag_name is nil' if tag_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/tagNames/{tagName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'tagName' => tag_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets a summary of tag usage under the subscription.
    #
    # This operation performs a union of predefined tags, resource tags, resource
    # group tags and subscription tags, and returns a summary of usage for each tag
    # name and value under the given subscription. In case of a large number of
    # tags, this operation may return a previously cached result.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<TagDetails>] operation results.
    #
    def list(custom_headers:nil)
      first_page = list_as_lazy(custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets a summary of tag usage under the subscription.
    #
    # This operation performs a union of predefined tags, resource tags, resource
    # group tags and subscription tags, and returns a summary of usage for each tag
    # name and value under the given subscription. In case of a large number of
    # tags, this operation may return a previously cached result.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(custom_headers:nil)
      list_async(custom_headers:custom_headers).value!
    end

    #
    # Gets a summary of tag usage under the subscription.
    #
    # This operation performs a union of predefined tags, resource tags, resource
    # group tags and subscription tags, and returns a summary of usage for each tag
    # name and value under the given subscription. In case of a large number of
    # tags, this operation may return a previously cached result.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/tagNames'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources2::Mgmt::V2020_06_01::Models::TagsListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates or updates the entire set of tags on a resource or subscription.
    #
    # This operation allows adding or replacing the entire set of tags on the
    # specified resource or subscription. The specified entity can have a maximum
    # of 50 tags.
    #
    # @param scope [String] The resource scope.
    # @param parameters [TagsResource]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [TagsResource] operation results.
    #
    def create_or_update_at_scope(scope, parameters, custom_headers:nil)
      response = create_or_update_at_scope_async(scope, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates the entire set of tags on a resource or subscription.
    #
    # This operation allows adding or replacing the entire set of tags on the
    # specified resource or subscription. The specified entity can have a maximum
    # of 50 tags.
    #
    # @param scope [String] The resource scope.
    # @param parameters [TagsResource]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_at_scope_with_http_info(scope, parameters, custom_headers:nil)
      create_or_update_at_scope_async(scope, parameters, custom_headers:custom_headers).value!
    end

    #
    # Creates or updates the entire set of tags on a resource or subscription.
    #
    # This operation allows adding or replacing the entire set of tags on the
    # specified resource or subscription. The specified entity can have a maximum
    # of 50 tags.
    #
    # @param scope [String] The resource scope.
    # @param parameters [TagsResource]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_at_scope_async(scope, parameters, custom_headers:nil)
      fail ArgumentError, 'scope is nil' if scope.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Resources2::Mgmt::V2020_06_01::Models::TagsResource.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '{scope}/providers/Microsoft.Resources/tags/default'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'scope' => scope},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources2::Mgmt::V2020_06_01::Models::TagsResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Selectively updates the set of tags on a resource or subscription.
    #
    # This operation allows replacing, merging or selectively deleting tags on the
    # specified resource or subscription. The specified entity can have a maximum
    # of 50 tags at the end of the operation. The 'replace' option replaces the
    # entire set of existing tags with a new set. The 'merge' option allows adding
    # tags with new names and updating the values of tags with existing names. The
    # 'delete' option allows selectively deleting tags based on given names or
    # name/value pairs.
    #
    # @param scope [String] The resource scope.
    # @param parameters [TagsPatchResource]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [TagsResource] operation results.
    #
    def update_at_scope(scope, parameters, custom_headers:nil)
      response = update_at_scope_async(scope, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Selectively updates the set of tags on a resource or subscription.
    #
    # This operation allows replacing, merging or selectively deleting tags on the
    # specified resource or subscription. The specified entity can have a maximum
    # of 50 tags at the end of the operation. The 'replace' option replaces the
    # entire set of existing tags with a new set. The 'merge' option allows adding
    # tags with new names and updating the values of tags with existing names. The
    # 'delete' option allows selectively deleting tags based on given names or
    # name/value pairs.
    #
    # @param scope [String] The resource scope.
    # @param parameters [TagsPatchResource]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def update_at_scope_with_http_info(scope, parameters, custom_headers:nil)
      update_at_scope_async(scope, parameters, custom_headers:custom_headers).value!
    end

    #
    # Selectively updates the set of tags on a resource or subscription.
    #
    # This operation allows replacing, merging or selectively deleting tags on the
    # specified resource or subscription. The specified entity can have a maximum
    # of 50 tags at the end of the operation. The 'replace' option replaces the
    # entire set of existing tags with a new set. The 'merge' option allows adding
    # tags with new names and updating the values of tags with existing names. The
    # 'delete' option allows selectively deleting tags based on given names or
    # name/value pairs.
    #
    # @param scope [String] The resource scope.
    # @param parameters [TagsPatchResource]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_at_scope_async(scope, parameters, custom_headers:nil)
      fail ArgumentError, 'scope is nil' if scope.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Resources2::Mgmt::V2020_06_01::Models::TagsPatchResource.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '{scope}/providers/Microsoft.Resources/tags/default'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'scope' => scope},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources2::Mgmt::V2020_06_01::Models::TagsResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the entire set of tags on a resource or subscription.
    #
    # @param scope [String] The resource scope.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [TagsResource] operation results.
    #
    def get_at_scope(scope, custom_headers:nil)
      response = get_at_scope_async(scope, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the entire set of tags on a resource or subscription.
    #
    # @param scope [String] The resource scope.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def get_at_scope_with_http_info(scope, custom_headers:nil)
      get_at_scope_async(scope, custom_headers:custom_headers).value!
    end

    #
    # Gets the entire set of tags on a resource or subscription.
    #
    # @param scope [String] The resource scope.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_at_scope_async(scope, custom_headers:nil)
      fail ArgumentError, 'scope is nil' if scope.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{scope}/providers/Microsoft.Resources/tags/default'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'scope' => scope},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources2::Mgmt::V2020_06_01::Models::TagsResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes the entire set of tags on a resource or subscription.
    #
    # @param scope [String] The resource scope.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_at_scope(scope, custom_headers:nil)
      response = delete_at_scope_async(scope, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes the entire set of tags on a resource or subscription.
    #
    # @param scope [String] The resource scope.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def delete_at_scope_with_http_info(scope, custom_headers:nil)
      delete_at_scope_async(scope, custom_headers:custom_headers).value!
    end

    #
    # Deletes the entire set of tags on a resource or subscription.
    #
    # @param scope [String] The resource scope.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_at_scope_async(scope, custom_headers:nil)
      fail ArgumentError, 'scope is nil' if scope.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{scope}/providers/Microsoft.Resources/tags/default'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'scope' => scope},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets a summary of tag usage under the subscription.
    #
    # This operation performs a union of predefined tags, resource tags, resource
    # group tags and subscription tags, and returns a summary of usage for each tag
    # name and value under the given subscription. In case of a large number of
    # tags, this operation may return a previously cached result.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [TagsListResult] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a summary of tag usage under the subscription.
    #
    # This operation performs a union of predefined tags, resource tags, resource
    # group tags and subscription tags, and returns a summary of usage for each tag
    # name and value under the given subscription. In case of a large number of
    # tags, this operation may return a previously cached result.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets a summary of tag usage under the subscription.
    #
    # This operation performs a union of predefined tags, resource tags, resource
    # group tags and subscription tags, and returns a summary of usage for each tag
    # name and value under the given subscription. In case of a large number of
    # tags, this operation may return a previously cached result.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources2::Mgmt::V2020_06_01::Models::TagsListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a summary of tag usage under the subscription.
    #
    # This operation performs a union of predefined tags, resource tags, resource
    # group tags and subscription tags, and returns a summary of usage for each tag
    # name and value under the given subscription. In case of a large number of
    # tags, this operation may return a previously cached result.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [TagsListResult] which provide lazy access to pages of the response.
    #
    def list_as_lazy(custom_headers:nil)
      response = list_async(custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
