# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Resources::Mgmt::V2019_10_01
  #
  # Provides operations for working with resources and resource groups.
  #
  class Resources
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Resources class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ResourceManagementClient] reference to the ResourceManagementClient
    attr_reader :client

    #
    # Get all the resources for a resource group.
    #
    # @param resource_group_name [String] The resource group with the resources to
    # get.
    # @param filter [String] The filter to apply on the operation.<br><br>The
    # properties you can use for eq (equals) or ne (not equals) are: location,
    # resourceType, name, resourceGroup, identity, identity/principalId, plan,
    # plan/publisher, plan/product, plan/name, plan/version, and
    # plan/promotionCode.<br><br>For example, to filter by a resource type, use:
    # $filter=resourceType eq 'Microsoft.Network/virtualNetworks'<br><br>You can
    # use substringof(value, property) in the filter. The properties you can use
    # for substring are: name and resourceGroup.<br><br>For example, to get all
    # resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
    # name)<br><br>You can link more than one substringof together by adding and/or
    # operators.<br><br>You can filter by tag names and values. For example, to
    # filter for a tag name and value, use $filter=tagName eq 'tag1' and tagValue
    # eq 'Value1'. When you filter by a tag name and value, the tags for each
    # resource are not returned in the results.<br><br>You can use some properties
    # together when filtering. The combinations you can use are: substringof and/or
    # resourceType, plan and plan/publisher and plan/name, identity and
    # identity/principalId.
    # @param expand [String] Comma-separated list of additional properties to be
    # included in the response. Valid values include `createdTime`, `changedTime`
    # and `provisioningState`. For example, `$expand=createdTime,changedTime`.
    # @param top [Integer] The number of results to return. If null is passed,
    # returns all resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<GenericResourceExpanded>] operation results.
    #
    def list_by_resource_group(resource_group_name, filter:nil, expand:nil, top:nil, custom_headers:nil)
      first_page = list_by_resource_group_as_lazy(resource_group_name, filter:filter, expand:expand, top:top, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Get all the resources for a resource group.
    #
    # @param resource_group_name [String] The resource group with the resources to
    # get.
    # @param filter [String] The filter to apply on the operation.<br><br>The
    # properties you can use for eq (equals) or ne (not equals) are: location,
    # resourceType, name, resourceGroup, identity, identity/principalId, plan,
    # plan/publisher, plan/product, plan/name, plan/version, and
    # plan/promotionCode.<br><br>For example, to filter by a resource type, use:
    # $filter=resourceType eq 'Microsoft.Network/virtualNetworks'<br><br>You can
    # use substringof(value, property) in the filter. The properties you can use
    # for substring are: name and resourceGroup.<br><br>For example, to get all
    # resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
    # name)<br><br>You can link more than one substringof together by adding and/or
    # operators.<br><br>You can filter by tag names and values. For example, to
    # filter for a tag name and value, use $filter=tagName eq 'tag1' and tagValue
    # eq 'Value1'. When you filter by a tag name and value, the tags for each
    # resource are not returned in the results.<br><br>You can use some properties
    # together when filtering. The combinations you can use are: substringof and/or
    # resourceType, plan and plan/publisher and plan/name, identity and
    # identity/principalId.
    # @param expand [String] Comma-separated list of additional properties to be
    # included in the response. Valid values include `createdTime`, `changedTime`
    # and `provisioningState`. For example, `$expand=createdTime,changedTime`.
    # @param top [Integer] The number of results to return. If null is passed,
    # returns all resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, filter:nil, expand:nil, top:nil, custom_headers:nil)
      list_by_resource_group_async(resource_group_name, filter:filter, expand:expand, top:top, custom_headers:custom_headers).value!
    end

    #
    # Get all the resources for a resource group.
    #
    # @param resource_group_name [String] The resource group with the resources to
    # get.
    # @param filter [String] The filter to apply on the operation.<br><br>The
    # properties you can use for eq (equals) or ne (not equals) are: location,
    # resourceType, name, resourceGroup, identity, identity/principalId, plan,
    # plan/publisher, plan/product, plan/name, plan/version, and
    # plan/promotionCode.<br><br>For example, to filter by a resource type, use:
    # $filter=resourceType eq 'Microsoft.Network/virtualNetworks'<br><br>You can
    # use substringof(value, property) in the filter. The properties you can use
    # for substring are: name and resourceGroup.<br><br>For example, to get all
    # resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
    # name)<br><br>You can link more than one substringof together by adding and/or
    # operators.<br><br>You can filter by tag names and values. For example, to
    # filter for a tag name and value, use $filter=tagName eq 'tag1' and tagValue
    # eq 'Value1'. When you filter by a tag name and value, the tags for each
    # resource are not returned in the results.<br><br>You can use some properties
    # together when filtering. The combinations you can use are: substringof and/or
    # resourceType, plan and plan/publisher and plan/name, identity and
    # identity/principalId.
    # @param expand [String] Comma-separated list of additional properties to be
    # included in the response. Valid values include `createdTime`, `changedTime`
    # and `provisioningState`. For example, `$expand=createdTime,changedTime`.
    # @param top [Integer] The number of results to return. If null is passed,
    # returns all resources.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, filter:nil, expand:nil, top:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/resources'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'$expand' => expand,'$top' => top,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::ResourceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Moves resources from one resource group to another resource group.
    #
    # The resources to move must be in the same source resource group. The target
    # resource group may be in a different subscription. When moving resources,
    # both the source group and the target group are locked for the duration of the
    # operation. Write and delete operations are blocked on the groups until the
    # move completes.
    #
    # @param source_resource_group_name [String] The name of the resource group
    # containing the resources to move.
    # @param parameters [ResourcesMoveInfo] Parameters for moving resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def move_resources(source_resource_group_name, parameters, custom_headers:nil)
      response = move_resources_async(source_resource_group_name, parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param source_resource_group_name [String] The name of the resource group
    # containing the resources to move.
    # @param parameters [ResourcesMoveInfo] Parameters for moving resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def move_resources_async(source_resource_group_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_move_resources_async(source_resource_group_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Validates whether resources can be moved from one resource group to another
    # resource group.
    #
    # This operation checks whether the specified resources can be moved to the
    # target. The resources to move must be in the same source resource group. The
    # target resource group may be in a different subscription. If validation
    # succeeds, it returns HTTP response code 204 (no content). If validation
    # fails, it returns HTTP response code 409 (Conflict) with an error message.
    # Retrieve the URL in the Location header value to check the result of the
    # long-running operation.
    #
    # @param source_resource_group_name [String] The name of the resource group
    # containing the resources to validate for move.
    # @param parameters [ResourcesMoveInfo] Parameters for moving resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def validate_move_resources(source_resource_group_name, parameters, custom_headers:nil)
      response = validate_move_resources_async(source_resource_group_name, parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param source_resource_group_name [String] The name of the resource group
    # containing the resources to validate for move.
    # @param parameters [ResourcesMoveInfo] Parameters for moving resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def validate_move_resources_async(source_resource_group_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_validate_move_resources_async(source_resource_group_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Get all the resources in a subscription.
    #
    # @param filter [String] The filter to apply on the operation.<br><br>The
    # properties you can use for eq (equals) or ne (not equals) are: location,
    # resourceType, name, resourceGroup, identity, identity/principalId, plan,
    # plan/publisher, plan/product, plan/name, plan/version, and
    # plan/promotionCode.<br><br>For example, to filter by a resource type, use:
    # $filter=resourceType eq 'Microsoft.Network/virtualNetworks'<br><br>You can
    # use substringof(value, property) in the filter. The properties you can use
    # for substring are: name and resourceGroup.<br><br>For example, to get all
    # resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
    # name)<br><br>You can link more than one substringof together by adding and/or
    # operators.<br><br>You can filter by tag names and values. For example, to
    # filter for a tag name and value, use $filter=tagName eq 'tag1' and tagValue
    # eq 'Value1'. When you filter by a tag name and value, the tags for each
    # resource are not returned in the results.<br><br>You can use some properties
    # together when filtering. The combinations you can use are: substringof and/or
    # resourceType, plan and plan/publisher and plan/name, identity and
    # identity/principalId.
    # @param expand [String] Comma-separated list of additional properties to be
    # included in the response. Valid values include `createdTime`, `changedTime`
    # and `provisioningState`. For example, `$expand=createdTime,changedTime`.
    # @param top [Integer] The number of results to return. If null is passed,
    # returns all resource groups.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<GenericResourceExpanded>] operation results.
    #
    def list(filter:nil, expand:nil, top:nil, custom_headers:nil)
      first_page = list_as_lazy(filter:filter, expand:expand, top:top, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Get all the resources in a subscription.
    #
    # @param filter [String] The filter to apply on the operation.<br><br>The
    # properties you can use for eq (equals) or ne (not equals) are: location,
    # resourceType, name, resourceGroup, identity, identity/principalId, plan,
    # plan/publisher, plan/product, plan/name, plan/version, and
    # plan/promotionCode.<br><br>For example, to filter by a resource type, use:
    # $filter=resourceType eq 'Microsoft.Network/virtualNetworks'<br><br>You can
    # use substringof(value, property) in the filter. The properties you can use
    # for substring are: name and resourceGroup.<br><br>For example, to get all
    # resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
    # name)<br><br>You can link more than one substringof together by adding and/or
    # operators.<br><br>You can filter by tag names and values. For example, to
    # filter for a tag name and value, use $filter=tagName eq 'tag1' and tagValue
    # eq 'Value1'. When you filter by a tag name and value, the tags for each
    # resource are not returned in the results.<br><br>You can use some properties
    # together when filtering. The combinations you can use are: substringof and/or
    # resourceType, plan and plan/publisher and plan/name, identity and
    # identity/principalId.
    # @param expand [String] Comma-separated list of additional properties to be
    # included in the response. Valid values include `createdTime`, `changedTime`
    # and `provisioningState`. For example, `$expand=createdTime,changedTime`.
    # @param top [Integer] The number of results to return. If null is passed,
    # returns all resource groups.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(filter:nil, expand:nil, top:nil, custom_headers:nil)
      list_async(filter:filter, expand:expand, top:top, custom_headers:custom_headers).value!
    end

    #
    # Get all the resources in a subscription.
    #
    # @param filter [String] The filter to apply on the operation.<br><br>The
    # properties you can use for eq (equals) or ne (not equals) are: location,
    # resourceType, name, resourceGroup, identity, identity/principalId, plan,
    # plan/publisher, plan/product, plan/name, plan/version, and
    # plan/promotionCode.<br><br>For example, to filter by a resource type, use:
    # $filter=resourceType eq 'Microsoft.Network/virtualNetworks'<br><br>You can
    # use substringof(value, property) in the filter. The properties you can use
    # for substring are: name and resourceGroup.<br><br>For example, to get all
    # resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
    # name)<br><br>You can link more than one substringof together by adding and/or
    # operators.<br><br>You can filter by tag names and values. For example, to
    # filter for a tag name and value, use $filter=tagName eq 'tag1' and tagValue
    # eq 'Value1'. When you filter by a tag name and value, the tags for each
    # resource are not returned in the results.<br><br>You can use some properties
    # together when filtering. The combinations you can use are: substringof and/or
    # resourceType, plan and plan/publisher and plan/name, identity and
    # identity/principalId.
    # @param expand [String] Comma-separated list of additional properties to be
    # included in the response. Valid values include `createdTime`, `changedTime`
    # and `provisioningState`. For example, `$expand=createdTime,changedTime`.
    # @param top [Integer] The number of results to return. If null is passed,
    # returns all resource groups.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(filter:nil, expand:nil, top:nil, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resources'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'$expand' => expand,'$top' => top,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::ResourceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Checks whether a resource exists.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # the resource to check. The name is case insensitive.
    # @param resource_provider_namespace [String] The resource provider of the
    # resource to check.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type.
    # @param resource_name [String] The name of the resource to check whether it
    # exists.
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Boolean] operation results.
    #
    def check_existence(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:nil)
      response = check_existence_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Checks whether a resource exists.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # the resource to check. The name is case insensitive.
    # @param resource_provider_namespace [String] The resource provider of the
    # resource to check.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type.
    # @param resource_name [String] The name of the resource to check whether it
    # exists.
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def check_existence_with_http_info(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:nil)
      check_existence_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:custom_headers).value!
    end

    #
    # Checks whether a resource exists.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # the resource to check. The name is case insensitive.
    # @param resource_provider_namespace [String] The resource provider of the
    # resource to check.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type.
    # @param resource_name [String] The name of the resource to check whether it
    # exists.
    # @param api_version [String] The API version to use for the operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def check_existence_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'resource_provider_namespace is nil' if resource_provider_namespace.nil?
      fail ArgumentError, 'parent_resource_path is nil' if parent_resource_path.nil?
      fail ArgumentError, 'resource_type is nil' if resource_type.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'resourceProviderNamespace' => resource_provider_namespace,'resourceName' => resource_name,'subscriptionId' => @client.subscription_id},
          skip_encoding_path_params: {'parentResourcePath' => parent_resource_path,'resourceType' => resource_type},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:head, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.body = (status_code == 204)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Deletes a resource.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource to delete. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type.
    # @param resource_name [String] The name of the resource to delete.
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:nil)
      response = delete_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource to delete. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type.
    # @param resource_name [String] The name of the resource to delete.
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:nil)
      # Send request
      promise = begin_delete_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Creates a resource.
    #
    # @param resource_group_name [String] The name of the resource group for the
    # resource. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type of the resource to create.
    # @param resource_name [String] The name of the resource to create.
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Parameters for creating or updating the
    # resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GenericResource] operation results.
    #
    def create_or_update(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:nil)
      response = create_or_update_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group for the
    # resource. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type of the resource to create.
    # @param resource_name [String] The name of the resource to create.
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Parameters for creating or updating the
    # resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates a resource.
    #
    # @param resource_group_name [String] The name of the resource group for the
    # resource. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type of the resource to update.
    # @param resource_name [String] The name of the resource to update.
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Parameters for updating the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GenericResource] operation results.
    #
    def update(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:nil)
      response = update_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group for the
    # resource. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type of the resource to update.
    # @param resource_name [String] The name of the resource to update.
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Parameters for updating the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:nil)
      # Send request
      promise = begin_update_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets a resource.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # the resource to get. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type of the resource.
    # @param resource_name [String] The name of the resource to get.
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GenericResource] operation results.
    #
    def get(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:nil)
      response = get_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a resource.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # the resource to get. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type of the resource.
    # @param resource_name [String] The name of the resource to get.
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:nil)
      get_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:custom_headers).value!
    end

    #
    # Gets a resource.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # the resource to get. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type of the resource.
    # @param resource_name [String] The name of the resource to get.
    # @param api_version [String] The API version to use for the operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'resource_provider_namespace is nil' if resource_provider_namespace.nil?
      fail ArgumentError, 'parent_resource_path is nil' if parent_resource_path.nil?
      fail ArgumentError, 'resource_type is nil' if resource_type.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'resourceProviderNamespace' => resource_provider_namespace,'resourceName' => resource_name,'subscriptionId' => @client.subscription_id},
          skip_encoding_path_params: {'parentResourcePath' => parent_resource_path,'resourceType' => resource_type},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Checks by ID whether a resource exists.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Boolean] operation results.
    #
    def check_existence_by_id(resource_id, api_version, custom_headers:nil)
      response = check_existence_by_id_async(resource_id, api_version, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Checks by ID whether a resource exists.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def check_existence_by_id_with_http_info(resource_id, api_version, custom_headers:nil)
      check_existence_by_id_async(resource_id, api_version, custom_headers:custom_headers).value!
    end

    #
    # Checks by ID whether a resource exists.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def check_existence_by_id_async(resource_id, api_version, custom_headers:nil)
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{resourceId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:head, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.body = (status_code == 204)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Deletes a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete_by_id(resource_id, api_version, custom_headers:nil)
      response = delete_by_id_async(resource_id, api_version, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_by_id_async(resource_id, api_version, custom_headers:nil)
      # Send request
      promise = begin_delete_by_id_async(resource_id, api_version, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Create a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Create or update resource parameters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GenericResource] operation results.
    #
    def create_or_update_by_id(resource_id, api_version, parameters, custom_headers:nil)
      response = create_or_update_by_id_async(resource_id, api_version, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Create or update resource parameters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_by_id_async(resource_id, api_version, parameters, custom_headers:nil)
      # Send request
      promise = begin_create_or_update_by_id_async(resource_id, api_version, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Update resource parameters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GenericResource] operation results.
    #
    def update_by_id(resource_id, api_version, parameters, custom_headers:nil)
      response = update_by_id_async(resource_id, api_version, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Update resource parameters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_by_id_async(resource_id, api_version, parameters, custom_headers:nil)
      # Send request
      promise = begin_update_by_id_async(resource_id, api_version, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GenericResource] operation results.
    #
    def get_by_id(resource_id, api_version, custom_headers:nil)
      response = get_by_id_async(resource_id, api_version, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_by_id_with_http_info(resource_id, api_version, custom_headers:nil)
      get_by_id_async(resource_id, api_version, custom_headers:custom_headers).value!
    end

    #
    # Gets a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_by_id_async(resource_id, api_version, custom_headers:nil)
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{resourceId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Moves resources from one resource group to another resource group.
    #
    # The resources to move must be in the same source resource group. The target
    # resource group may be in a different subscription. When moving resources,
    # both the source group and the target group are locked for the duration of the
    # operation. Write and delete operations are blocked on the groups until the
    # move completes.
    #
    # @param source_resource_group_name [String] The name of the resource group
    # containing the resources to move.
    # @param parameters [ResourcesMoveInfo] Parameters for moving resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_move_resources(source_resource_group_name, parameters, custom_headers:nil)
      response = begin_move_resources_async(source_resource_group_name, parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # Moves resources from one resource group to another resource group.
    #
    # The resources to move must be in the same source resource group. The target
    # resource group may be in a different subscription. When moving resources,
    # both the source group and the target group are locked for the duration of the
    # operation. Write and delete operations are blocked on the groups until the
    # move completes.
    #
    # @param source_resource_group_name [String] The name of the resource group
    # containing the resources to move.
    # @param parameters [ResourcesMoveInfo] Parameters for moving resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_move_resources_with_http_info(source_resource_group_name, parameters, custom_headers:nil)
      begin_move_resources_async(source_resource_group_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Moves resources from one resource group to another resource group.
    #
    # The resources to move must be in the same source resource group. The target
    # resource group may be in a different subscription. When moving resources,
    # both the source group and the target group are locked for the duration of the
    # operation. Write and delete operations are blocked on the groups until the
    # move completes.
    #
    # @param source_resource_group_name [String] The name of the resource group
    # containing the resources to move.
    # @param parameters [ResourcesMoveInfo] Parameters for moving resources.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_move_resources_async(source_resource_group_name, parameters, custom_headers:nil)
      fail ArgumentError, 'source_resource_group_name is nil' if source_resource_group_name.nil?
      fail ArgumentError, "'source_resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !source_resource_group_name.nil? && source_resource_group_name.length > 90
      fail ArgumentError, "'source_resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !source_resource_group_name.nil? && source_resource_group_name.length < 1
      fail ArgumentError, "'source_resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !source_resource_group_name.nil? && source_resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::ResourcesMoveInfo.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/moveResources'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'sourceResourceGroupName' => source_resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Validates whether resources can be moved from one resource group to another
    # resource group.
    #
    # This operation checks whether the specified resources can be moved to the
    # target. The resources to move must be in the same source resource group. The
    # target resource group may be in a different subscription. If validation
    # succeeds, it returns HTTP response code 204 (no content). If validation
    # fails, it returns HTTP response code 409 (Conflict) with an error message.
    # Retrieve the URL in the Location header value to check the result of the
    # long-running operation.
    #
    # @param source_resource_group_name [String] The name of the resource group
    # containing the resources to validate for move.
    # @param parameters [ResourcesMoveInfo] Parameters for moving resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_validate_move_resources(source_resource_group_name, parameters, custom_headers:nil)
      response = begin_validate_move_resources_async(source_resource_group_name, parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # Validates whether resources can be moved from one resource group to another
    # resource group.
    #
    # This operation checks whether the specified resources can be moved to the
    # target. The resources to move must be in the same source resource group. The
    # target resource group may be in a different subscription. If validation
    # succeeds, it returns HTTP response code 204 (no content). If validation
    # fails, it returns HTTP response code 409 (Conflict) with an error message.
    # Retrieve the URL in the Location header value to check the result of the
    # long-running operation.
    #
    # @param source_resource_group_name [String] The name of the resource group
    # containing the resources to validate for move.
    # @param parameters [ResourcesMoveInfo] Parameters for moving resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_validate_move_resources_with_http_info(source_resource_group_name, parameters, custom_headers:nil)
      begin_validate_move_resources_async(source_resource_group_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Validates whether resources can be moved from one resource group to another
    # resource group.
    #
    # This operation checks whether the specified resources can be moved to the
    # target. The resources to move must be in the same source resource group. The
    # target resource group may be in a different subscription. If validation
    # succeeds, it returns HTTP response code 204 (no content). If validation
    # fails, it returns HTTP response code 409 (Conflict) with an error message.
    # Retrieve the URL in the Location header value to check the result of the
    # long-running operation.
    #
    # @param source_resource_group_name [String] The name of the resource group
    # containing the resources to validate for move.
    # @param parameters [ResourcesMoveInfo] Parameters for moving resources.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_validate_move_resources_async(source_resource_group_name, parameters, custom_headers:nil)
      fail ArgumentError, 'source_resource_group_name is nil' if source_resource_group_name.nil?
      fail ArgumentError, "'source_resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !source_resource_group_name.nil? && source_resource_group_name.length > 90
      fail ArgumentError, "'source_resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !source_resource_group_name.nil? && source_resource_group_name.length < 1
      fail ArgumentError, "'source_resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !source_resource_group_name.nil? && source_resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::ResourcesMoveInfo.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/validateMoveResources'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'sourceResourceGroupName' => source_resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Deletes a resource.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource to delete. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type.
    # @param resource_name [String] The name of the resource to delete.
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:nil)
      response = begin_delete_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes a resource.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource to delete. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type.
    # @param resource_name [String] The name of the resource to delete.
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:nil)
      begin_delete_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:custom_headers).value!
    end

    #
    # Deletes a resource.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource to delete. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type.
    # @param resource_name [String] The name of the resource to delete.
    # @param api_version [String] The API version to use for the operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'resource_provider_namespace is nil' if resource_provider_namespace.nil?
      fail ArgumentError, 'parent_resource_path is nil' if parent_resource_path.nil?
      fail ArgumentError, 'resource_type is nil' if resource_type.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'resourceProviderNamespace' => resource_provider_namespace,'resourceName' => resource_name,'subscriptionId' => @client.subscription_id},
          skip_encoding_path_params: {'parentResourcePath' => parent_resource_path,'resourceType' => resource_type},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a resource.
    #
    # @param resource_group_name [String] The name of the resource group for the
    # resource. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type of the resource to create.
    # @param resource_name [String] The name of the resource to create.
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Parameters for creating or updating the
    # resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GenericResource] operation results.
    #
    def begin_create_or_update(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:nil)
      response = begin_create_or_update_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a resource.
    #
    # @param resource_group_name [String] The name of the resource group for the
    # resource. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type of the resource to create.
    # @param resource_name [String] The name of the resource to create.
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Parameters for creating or updating the
    # resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:nil)
      begin_create_or_update_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:custom_headers).value!
    end

    #
    # Creates a resource.
    #
    # @param resource_group_name [String] The name of the resource group for the
    # resource. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type of the resource to create.
    # @param resource_name [String] The name of the resource to create.
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Parameters for creating or updating the
    # resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'resource_provider_namespace is nil' if resource_provider_namespace.nil?
      fail ArgumentError, 'parent_resource_path is nil' if parent_resource_path.nil?
      fail ArgumentError, 'resource_type is nil' if resource_type.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'resourceProviderNamespace' => resource_provider_namespace,'resourceName' => resource_name,'subscriptionId' => @client.subscription_id},
          skip_encoding_path_params: {'parentResourcePath' => parent_resource_path,'resourceType' => resource_type},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates a resource.
    #
    # @param resource_group_name [String] The name of the resource group for the
    # resource. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type of the resource to update.
    # @param resource_name [String] The name of the resource to update.
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Parameters for updating the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GenericResource] operation results.
    #
    def begin_update(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:nil)
      response = begin_update_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates a resource.
    #
    # @param resource_group_name [String] The name of the resource group for the
    # resource. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type of the resource to update.
    # @param resource_name [String] The name of the resource to update.
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Parameters for updating the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_with_http_info(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:nil)
      begin_update_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:custom_headers).value!
    end

    #
    # Updates a resource.
    #
    # @param resource_group_name [String] The name of the resource group for the
    # resource. The name is case insensitive.
    # @param resource_provider_namespace [String] The namespace of the resource
    # provider.
    # @param parent_resource_path [String] The parent resource identity.
    # @param resource_type [String] The resource type of the resource to update.
    # @param resource_name [String] The name of the resource to update.
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Parameters for updating the resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_async(resource_group_name, resource_provider_namespace, parent_resource_path, resource_type, resource_name, api_version, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'resource_provider_namespace is nil' if resource_provider_namespace.nil?
      fail ArgumentError, 'parent_resource_path is nil' if parent_resource_path.nil?
      fail ArgumentError, 'resource_type is nil' if resource_type.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'resourceProviderNamespace' => resource_provider_namespace,'resourceName' => resource_name,'subscriptionId' => @client.subscription_id},
          skip_encoding_path_params: {'parentResourcePath' => parent_resource_path,'resourceType' => resource_type},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete_by_id(resource_id, api_version, custom_headers:nil)
      response = begin_delete_by_id_async(resource_id, api_version, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_by_id_with_http_info(resource_id, api_version, custom_headers:nil)
      begin_delete_by_id_async(resource_id, api_version, custom_headers:custom_headers).value!
    end

    #
    # Deletes a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_by_id_async(resource_id, api_version, custom_headers:nil)
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{resourceId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Create a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Create or update resource parameters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GenericResource] operation results.
    #
    def begin_create_or_update_by_id(resource_id, api_version, parameters, custom_headers:nil)
      response = begin_create_or_update_by_id_async(resource_id, api_version, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Create or update resource parameters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_by_id_with_http_info(resource_id, api_version, parameters, custom_headers:nil)
      begin_create_or_update_by_id_async(resource_id, api_version, parameters, custom_headers:custom_headers).value!
    end

    #
    # Create a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Create or update resource parameters.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_by_id_async(resource_id, api_version, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '{resourceId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Update resource parameters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GenericResource] operation results.
    #
    def begin_update_by_id(resource_id, api_version, parameters, custom_headers:nil)
      response = begin_update_by_id_async(resource_id, api_version, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Update resource parameters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_by_id_with_http_info(resource_id, api_version, parameters, custom_headers:nil)
      begin_update_by_id_async(resource_id, api_version, parameters, custom_headers:custom_headers).value!
    end

    #
    # Updates a resource by ID.
    #
    # @param resource_id [String] The fully qualified ID of the resource, including
    # the resource name and resource type. Use the format,
    # /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
    # @param api_version [String] The API version to use for the operation.
    # @param parameters [GenericResource] Update resource parameters.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_by_id_async(resource_id, api_version, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '{resourceId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::GenericResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all the resources for a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceListResult] operation results.
    #
    def list_by_resource_group_next(next_page_link, custom_headers:nil)
      response = list_by_resource_group_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all the resources for a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_next_with_http_info(next_page_link, custom_headers:nil)
      list_by_resource_group_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Get all the resources for a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::ResourceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all the resources in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceListResult] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all the resources in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Get all the resources in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Resources::Mgmt::V2019_10_01::Models::ResourceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all the resources for a resource group.
    #
    # @param resource_group_name [String] The resource group with the resources to
    # get.
    # @param filter [String] The filter to apply on the operation.<br><br>The
    # properties you can use for eq (equals) or ne (not equals) are: location,
    # resourceType, name, resourceGroup, identity, identity/principalId, plan,
    # plan/publisher, plan/product, plan/name, plan/version, and
    # plan/promotionCode.<br><br>For example, to filter by a resource type, use:
    # $filter=resourceType eq 'Microsoft.Network/virtualNetworks'<br><br>You can
    # use substringof(value, property) in the filter. The properties you can use
    # for substring are: name and resourceGroup.<br><br>For example, to get all
    # resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
    # name)<br><br>You can link more than one substringof together by adding and/or
    # operators.<br><br>You can filter by tag names and values. For example, to
    # filter for a tag name and value, use $filter=tagName eq 'tag1' and tagValue
    # eq 'Value1'. When you filter by a tag name and value, the tags for each
    # resource are not returned in the results.<br><br>You can use some properties
    # together when filtering. The combinations you can use are: substringof and/or
    # resourceType, plan and plan/publisher and plan/name, identity and
    # identity/principalId.
    # @param expand [String] Comma-separated list of additional properties to be
    # included in the response. Valid values include `createdTime`, `changedTime`
    # and `provisioningState`. For example, `$expand=createdTime,changedTime`.
    # @param top [Integer] The number of results to return. If null is passed,
    # returns all resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceListResult] which provide lazy access to pages of the
    # response.
    #
    def list_by_resource_group_as_lazy(resource_group_name, filter:nil, expand:nil, top:nil, custom_headers:nil)
      response = list_by_resource_group_async(resource_group_name, filter:filter, expand:expand, top:top, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_resource_group_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

    #
    # Get all the resources in a subscription.
    #
    # @param filter [String] The filter to apply on the operation.<br><br>The
    # properties you can use for eq (equals) or ne (not equals) are: location,
    # resourceType, name, resourceGroup, identity, identity/principalId, plan,
    # plan/publisher, plan/product, plan/name, plan/version, and
    # plan/promotionCode.<br><br>For example, to filter by a resource type, use:
    # $filter=resourceType eq 'Microsoft.Network/virtualNetworks'<br><br>You can
    # use substringof(value, property) in the filter. The properties you can use
    # for substring are: name and resourceGroup.<br><br>For example, to get all
    # resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
    # name)<br><br>You can link more than one substringof together by adding and/or
    # operators.<br><br>You can filter by tag names and values. For example, to
    # filter for a tag name and value, use $filter=tagName eq 'tag1' and tagValue
    # eq 'Value1'. When you filter by a tag name and value, the tags for each
    # resource are not returned in the results.<br><br>You can use some properties
    # together when filtering. The combinations you can use are: substringof and/or
    # resourceType, plan and plan/publisher and plan/name, identity and
    # identity/principalId.
    # @param expand [String] Comma-separated list of additional properties to be
    # included in the response. Valid values include `createdTime`, `changedTime`
    # and `provisioningState`. For example, `$expand=createdTime,changedTime`.
    # @param top [Integer] The number of results to return. If null is passed,
    # returns all resource groups.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceListResult] which provide lazy access to pages of the
    # response.
    #
    def list_as_lazy(filter:nil, expand:nil, top:nil, custom_headers:nil)
      response = list_async(filter:filter, expand:expand, top:top, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
