# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network2::Mgmt::V2018_12_01
  module Models
    #
    # Interface endpoint resource.
    #
    class InterfaceEndpoint < Resource

      include MsRestAzure2

      # @return [String] A first-party service's FQDN that is mapped to the
      # private IP allocated via this interface endpoint.
      attr_accessor :fqdn

      # @return [EndpointService] A reference to the service being brought into
      # the virtual network.
      attr_accessor :endpoint_service

      # @return [Subnet] The ID of the subnet from which the private IP will be
      # allocated.
      attr_accessor :subnet

      # @return [Array<NetworkInterface>] Gets an array of references to the
      # network interfaces created for this interface endpoint.
      attr_accessor :network_interfaces

      # @return [String] A read-only property that identifies who created this
      # interface endpoint.
      attr_accessor :owner

      # @return [String] The provisioning state of the interface endpoint.
      # Possible values are: 'Updating', 'Deleting', and 'Failed'.
      attr_accessor :provisioning_state

      # @return [String] Gets a unique read-only string that changes whenever
      # the resource is updated.
      attr_accessor :etag


      #
      # Mapper for InterfaceEndpoint class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'InterfaceEndpoint',
          type: {
            name: 'Composite',
            class_name: 'InterfaceEndpoint',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                client_side_validation: true,
                required: false,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                client_side_validation: true,
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              fqdn: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.fqdn',
                type: {
                  name: 'String'
                }
              },
              endpoint_service: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.endpointService',
                type: {
                  name: 'Composite',
                  class_name: 'EndpointService'
                }
              },
              subnet: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.subnet',
                type: {
                  name: 'Composite',
                  class_name: 'Subnet'
                }
              },
              network_interfaces: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.networkInterfaces',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'NetworkInterfaceElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'NetworkInterface'
                      }
                  }
                }
              },
              owner: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.owner',
                type: {
                  name: 'String'
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              etag: {
                client_side_validation: true,
                required: false,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
