# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network2::Mgmt::V2018_04_01
  #
  # ExpressRouteCrossConnections
  #
  class ExpressRouteCrossConnections
    include MsRestAzure2

    #
    # Creates and initializes a new instance of the ExpressRouteCrossConnections class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [NetworkManagementClient] reference to the NetworkManagementClient
    attr_reader :client

    #
    # Retrieves all the ExpressRouteCrossConnections in a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ExpressRouteCrossConnection>] operation results.
    #
    def list(custom_headers:nil)
      first_page = list_as_lazy(custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Retrieves all the ExpressRouteCrossConnections in a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(custom_headers:nil)
      list_async(custom_headers:custom_headers).value!
    end

    #
    # Retrieves all the ExpressRouteCrossConnections in a subscription.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Network/expressRouteCrossConnections'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCrossConnectionListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves all the ExpressRouteCrossConnections in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ExpressRouteCrossConnection>] operation results.
    #
    def list_by_resource_group(resource_group_name, custom_headers:nil)
      first_page = list_by_resource_group_as_lazy(resource_group_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Retrieves all the ExpressRouteCrossConnections in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, custom_headers:nil)
      list_by_resource_group_async(resource_group_name, custom_headers:custom_headers).value!
    end

    #
    # Retrieves all the ExpressRouteCrossConnections in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCrossConnectionListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets details about the specified ExpressRouteCrossConnection.
    #
    # @param resource_group_name [String] The name of the resource group (peering
    # location of the circuit).
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection (service key of the circuit).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCrossConnection] operation results.
    #
    def get(resource_group_name, cross_connection_name, custom_headers:nil)
      response = get_async(resource_group_name, cross_connection_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets details about the specified ExpressRouteCrossConnection.
    #
    # @param resource_group_name [String] The name of the resource group (peering
    # location of the circuit).
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection (service key of the circuit).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, cross_connection_name, custom_headers:nil)
      get_async(resource_group_name, cross_connection_name, custom_headers:custom_headers).value!
    end

    #
    # Gets details about the specified ExpressRouteCrossConnection.
    #
    # @param resource_group_name [String] The name of the resource group (peering
    # location of the circuit).
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection (service key of the circuit).
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, cross_connection_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cross_connection_name is nil' if cross_connection_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'crossConnectionName' => cross_connection_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCrossConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update the specified ExpressRouteCrossConnection.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param parameters [ExpressRouteCrossConnection] Parameters supplied to the
    # update express route crossConnection operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCrossConnection] operation results.
    #
    def create_or_update(resource_group_name, cross_connection_name, parameters, custom_headers:nil)
      response = create_or_update_async(resource_group_name, cross_connection_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param parameters [ExpressRouteCrossConnection] Parameters supplied to the
    # update express route crossConnection operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, cross_connection_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, cross_connection_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCrossConnection.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates an express route cross connection tags.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the cross connection.
    # @param cross_connection_parameters [TagsObject] Parameters supplied to update
    # express route cross connection tags.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCrossConnection] operation results.
    #
    def update_tags(resource_group_name, cross_connection_name, cross_connection_parameters, custom_headers:nil)
      response = update_tags_async(resource_group_name, cross_connection_name, cross_connection_parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the cross connection.
    # @param cross_connection_parameters [TagsObject] Parameters supplied to update
    # express route cross connection tags.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_tags_async(resource_group_name, cross_connection_name, cross_connection_parameters, custom_headers:nil)
      # Send request
      promise = begin_update_tags_async(resource_group_name, cross_connection_name, cross_connection_parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCrossConnection.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets the currently advertised ARP table associated with the express route
    # cross connection in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCircuitsArpTableListResult] operation results.
    #
    def list_arp_table(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      response = list_arp_table_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def list_arp_table_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      # Send request
      promise = begin_list_arp_table_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCircuitsArpTableListResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets the route table summary associated with the express route cross
    # connection in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCrossConnectionsRoutesTableSummaryListResult] operation
    # results.
    #
    def list_routes_table_summary(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      response = list_routes_table_summary_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def list_routes_table_summary_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      # Send request
      promise = begin_list_routes_table_summary_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCrossConnectionsRoutesTableSummaryListResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets the currently advertised routes table associated with the express route
    # cross connection in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCircuitsRoutesTableListResult] operation results.
    #
    def list_routes_table(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      response = list_routes_table_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def list_routes_table_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      # Send request
      promise = begin_list_routes_table_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCircuitsRoutesTableListResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Update the specified ExpressRouteCrossConnection.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param parameters [ExpressRouteCrossConnection] Parameters supplied to the
    # update express route crossConnection operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCrossConnection] operation results.
    #
    def begin_create_or_update(resource_group_name, cross_connection_name, parameters, custom_headers:nil)
      response = begin_create_or_update_async(resource_group_name, cross_connection_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the specified ExpressRouteCrossConnection.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param parameters [ExpressRouteCrossConnection] Parameters supplied to the
    # update express route crossConnection operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, cross_connection_name, parameters, custom_headers:nil)
      begin_create_or_update_async(resource_group_name, cross_connection_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Update the specified ExpressRouteCrossConnection.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param parameters [ExpressRouteCrossConnection] Parameters supplied to the
    # update express route crossConnection operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, cross_connection_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cross_connection_name is nil' if cross_connection_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCrossConnection.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'crossConnectionName' => cross_connection_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCrossConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates an express route cross connection tags.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the cross connection.
    # @param cross_connection_parameters [TagsObject] Parameters supplied to update
    # express route cross connection tags.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCrossConnection] operation results.
    #
    def begin_update_tags(resource_group_name, cross_connection_name, cross_connection_parameters, custom_headers:nil)
      response = begin_update_tags_async(resource_group_name, cross_connection_name, cross_connection_parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates an express route cross connection tags.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the cross connection.
    # @param cross_connection_parameters [TagsObject] Parameters supplied to update
    # express route cross connection tags.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def begin_update_tags_with_http_info(resource_group_name, cross_connection_name, cross_connection_parameters, custom_headers:nil)
      begin_update_tags_async(resource_group_name, cross_connection_name, cross_connection_parameters, custom_headers:custom_headers).value!
    end

    #
    # Updates an express route cross connection tags.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the cross connection.
    # @param cross_connection_parameters [TagsObject] Parameters supplied to update
    # express route cross connection tags.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_tags_async(resource_group_name, cross_connection_name, cross_connection_parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cross_connection_name is nil' if cross_connection_name.nil?
      fail ArgumentError, 'cross_connection_parameters is nil' if cross_connection_parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::TagsObject.mapper()
      request_content = @client.serialize(request_mapper,  cross_connection_parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'crossConnectionName' => cross_connection_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCrossConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the currently advertised ARP table associated with the express route
    # cross connection in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCircuitsArpTableListResult] operation results.
    #
    def begin_list_arp_table(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      response = begin_list_arp_table_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the currently advertised ARP table associated with the express route
    # cross connection in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def begin_list_arp_table_with_http_info(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      begin_list_arp_table_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:custom_headers).value!
    end

    #
    # Gets the currently advertised ARP table associated with the express route
    # cross connection in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_list_arp_table_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cross_connection_name is nil' if cross_connection_name.nil?
      fail ArgumentError, 'peering_name is nil' if peering_name.nil?
      fail ArgumentError, 'device_path is nil' if device_path.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/arpTables/{devicePath}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'crossConnectionName' => cross_connection_name,'peeringName' => peering_name,'devicePath' => device_path,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCircuitsArpTableListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the route table summary associated with the express route cross
    # connection in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCrossConnectionsRoutesTableSummaryListResult] operation
    # results.
    #
    def begin_list_routes_table_summary(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      response = begin_list_routes_table_summary_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the route table summary associated with the express route cross
    # connection in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def begin_list_routes_table_summary_with_http_info(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      begin_list_routes_table_summary_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:custom_headers).value!
    end

    #
    # Gets the route table summary associated with the express route cross
    # connection in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_list_routes_table_summary_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cross_connection_name is nil' if cross_connection_name.nil?
      fail ArgumentError, 'peering_name is nil' if peering_name.nil?
      fail ArgumentError, 'device_path is nil' if device_path.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/routeTablesSummary/{devicePath}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'crossConnectionName' => cross_connection_name,'peeringName' => peering_name,'devicePath' => device_path,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCrossConnectionsRoutesTableSummaryListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the currently advertised routes table associated with the express route
    # cross connection in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCircuitsRoutesTableListResult] operation results.
    #
    def begin_list_routes_table(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      response = begin_list_routes_table_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the currently advertised routes table associated with the express route
    # cross connection in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def begin_list_routes_table_with_http_info(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      begin_list_routes_table_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:custom_headers).value!
    end

    #
    # Gets the currently advertised routes table associated with the express route
    # cross connection in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param cross_connection_name [String] The name of the
    # ExpressRouteCrossConnection.
    # @param peering_name [String] The name of the peering.
    # @param device_path [String] The path of the device.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_list_routes_table_async(resource_group_name, cross_connection_name, peering_name, device_path, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cross_connection_name is nil' if cross_connection_name.nil?
      fail ArgumentError, 'peering_name is nil' if peering_name.nil?
      fail ArgumentError, 'device_path is nil' if device_path.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/routeTables/{devicePath}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'crossConnectionName' => cross_connection_name,'peeringName' => peering_name,'devicePath' => device_path,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCircuitsRoutesTableListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves all the ExpressRouteCrossConnections in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCrossConnectionListResult] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves all the ExpressRouteCrossConnections in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Retrieves all the ExpressRouteCrossConnections in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCrossConnectionListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves all the ExpressRouteCrossConnections in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCrossConnectionListResult] operation results.
    #
    def list_by_resource_group_next(next_page_link, custom_headers:nil)
      response = list_by_resource_group_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves all the ExpressRouteCrossConnections in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure2::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_next_with_http_info(next_page_link, custom_headers:nil)
      list_by_resource_group_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Retrieves all the ExpressRouteCrossConnections in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest2::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure2::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network2::Mgmt::V2018_04_01::Models::ExpressRouteCrossConnectionListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest2::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves all the ExpressRouteCrossConnections in a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCrossConnectionListResult] which provide lazy access to
    # pages of the response.
    #
    def list_as_lazy(custom_headers:nil)
      response = list_async(custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

    #
    # Retrieves all the ExpressRouteCrossConnections in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ExpressRouteCrossConnectionListResult] which provide lazy access to
    # pages of the response.
    #
    def list_by_resource_group_as_lazy(resource_group_name, custom_headers:nil)
      response = list_by_resource_group_async(resource_group_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_resource_group_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
