# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network::Mgmt::V2020_03_01
  #
  # NetworkWatchers
  #
  class NetworkWatchers
    include MsRestAzure

    #
    # Creates and initializes a new instance of the NetworkWatchers class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [NetworkManagementClient] reference to the NetworkManagementClient
    attr_reader :client

    #
    # Creates or updates a network watcher in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [NetworkWatcher] Parameters that define the network watcher
    # resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkWatcher] operation results.
    #
    def create_or_update(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = create_or_update_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates a network watcher in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [NetworkWatcher] Parameters that define the network watcher
    # resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      create_or_update_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Creates or updates a network watcher in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [NetworkWatcher] Parameters that define the network watcher
    # resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NetworkWatcher.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NetworkWatcher.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NetworkWatcher.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the specified network watcher by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkWatcher] operation results.
    #
    def get(resource_group_name, network_watcher_name, custom_headers:nil)
      response = get_async(resource_group_name, network_watcher_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the specified network watcher by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, network_watcher_name, custom_headers:nil)
      get_async(resource_group_name, network_watcher_name, custom_headers:custom_headers).value!
    end

    #
    # Gets the specified network watcher by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, network_watcher_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NetworkWatcher.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes the specified network watcher resource.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, network_watcher_name, custom_headers:nil)
      response = delete_async(resource_group_name, network_watcher_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, network_watcher_name, custom_headers:nil)
      # Send request
      promise = begin_delete_async(resource_group_name, network_watcher_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates a network watcher tags.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [TagsObject] Parameters supplied to update network watcher
    # tags.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkWatcher] operation results.
    #
    def update_tags(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = update_tags_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates a network watcher tags.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [TagsObject] Parameters supplied to update network watcher
    # tags.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_tags_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      update_tags_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Updates a network watcher tags.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [TagsObject] Parameters supplied to update network watcher
    # tags.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_tags_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::TagsObject.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NetworkWatcher.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all network watchers by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkWatcherListResult] operation results.
    #
    def list(resource_group_name, custom_headers:nil)
      response = list_async(resource_group_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all network watchers by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, custom_headers:nil)
      list_async(resource_group_name, custom_headers:custom_headers).value!
    end

    #
    # Gets all network watchers by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NetworkWatcherListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all network watchers by subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkWatcherListResult] operation results.
    #
    def list_all(custom_headers:nil)
      response = list_all_async(custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all network watchers by subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_all_with_http_info(custom_headers:nil)
      list_all_async(custom_headers:custom_headers).value!
    end

    #
    # Gets all network watchers by subscription.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_all_async(custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Network/networkWatchers'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NetworkWatcherListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the current network topology by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [TopologyParameters] Parameters that define the
    # representation of topology.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Topology] operation results.
    #
    def get_topology(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = get_topology_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the current network topology by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [TopologyParameters] Parameters that define the
    # representation of topology.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_topology_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      get_topology_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Gets the current network topology by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [TopologyParameters] Parameters that define the
    # representation of topology.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_topology_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::TopologyParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/topology'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::Topology.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Verify IP flow from the specified VM to a location given the currently
    # configured NSG rules.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [VerificationIPFlowParameters] Parameters that define the
    # IP flow to be verified.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VerificationIPFlowResult] operation results.
    #
    def verify_ipflow(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = verify_ipflow_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [VerificationIPFlowParameters] Parameters that define the
    # IP flow to be verified.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def verify_ipflow_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_verify_ipflow_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::VerificationIPFlowResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Gets the next hop from the specified VM.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [NextHopParameters] Parameters that define the source and
    # destination endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NextHopResult] operation results.
    #
    def get_next_hop(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = get_next_hop_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [NextHopParameters] Parameters that define the source and
    # destination endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_next_hop_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_get_next_hop_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NextHopResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Gets the configured and effective security group rules on the specified VM.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [SecurityGroupViewParameters] Parameters that define the VM
    # to check security groups for.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SecurityGroupViewResult] operation results.
    #
    def get_vmsecurity_rules(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = get_vmsecurity_rules_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [SecurityGroupViewParameters] Parameters that define the VM
    # to check security groups for.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_vmsecurity_rules_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_get_vmsecurity_rules_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::SecurityGroupViewResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Initiate troubleshooting on a specified resource.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [TroubleshootingParameters] Parameters that define the
    # resource to troubleshoot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [TroubleshootingResult] operation results.
    #
    def get_troubleshooting(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = get_troubleshooting_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [TroubleshootingParameters] Parameters that define the
    # resource to troubleshoot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_troubleshooting_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_get_troubleshooting_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::TroubleshootingResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Get the last completed troubleshooting result on a specified resource.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [QueryTroubleshootingParameters] Parameters that define the
    # resource to query the troubleshooting result.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [TroubleshootingResult] operation results.
    #
    def get_troubleshooting_result(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = get_troubleshooting_result_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [QueryTroubleshootingParameters] Parameters that define the
    # resource to query the troubleshooting result.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_troubleshooting_result_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_get_troubleshooting_result_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::TroubleshootingResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Configures flow log and traffic analytics (optional) on a specified resource.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [FlowLogInformation] Parameters that define the
    # configuration of flow log.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [FlowLogInformation] operation results.
    #
    def set_flow_log_configuration(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = set_flow_log_configuration_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [FlowLogInformation] Parameters that define the
    # configuration of flow log.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def set_flow_log_configuration_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_set_flow_log_configuration_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::FlowLogInformation.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Queries status of flow log and traffic analytics (optional) on a specified
    # resource.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [FlowLogStatusParameters] Parameters that define a resource
    # to query flow log and traffic analytics (optional) status.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [FlowLogInformation] operation results.
    #
    def get_flow_log_status(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = get_flow_log_status_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [FlowLogStatusParameters] Parameters that define a resource
    # to query flow log and traffic analytics (optional) status.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_flow_log_status_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_get_flow_log_status_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::FlowLogInformation.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Verifies the possibility of establishing a direct TCP connection from a
    # virtual machine to a given endpoint including another VM or an arbitrary
    # remote server.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [ConnectivityParameters] Parameters that determine how the
    # connectivity check will be performed.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectivityInformation] operation results.
    #
    def check_connectivity(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = check_connectivity_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [ConnectivityParameters] Parameters that determine how the
    # connectivity check will be performed.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def check_connectivity_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_check_connectivity_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::ConnectivityInformation.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # NOTE: This feature is currently in preview and still being tested for
    # stability. Gets the relative latency score for internet service providers
    # from a specified location to Azure regions.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [AzureReachabilityReportParameters] Parameters that
    # determine Azure reachability report configuration.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AzureReachabilityReport] operation results.
    #
    def get_azure_reachability_report(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = get_azure_reachability_report_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [AzureReachabilityReportParameters] Parameters that
    # determine Azure reachability report configuration.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_azure_reachability_report_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_get_azure_reachability_report_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::AzureReachabilityReport.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # NOTE: This feature is currently in preview and still being tested for
    # stability. Lists all available internet service providers for a specified
    # Azure region.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [AvailableProvidersListParameters] Parameters that scope
    # the list of available providers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AvailableProvidersList] operation results.
    #
    def list_available_providers(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = list_available_providers_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [AvailableProvidersListParameters] Parameters that scope
    # the list of available providers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def list_available_providers_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_list_available_providers_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::AvailableProvidersList.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Gets Network Configuration Diagnostic data to help customers understand and
    # debug network behavior. It provides detailed information on what security
    # rules were applied to a specified traffic flow and the result of evaluating
    # these rules. Customers must provide details of a flow like source,
    # destination, protocol, etc. The API returns whether traffic was allowed or
    # denied, the rules evaluated for the specified flow and the evaluation
    # results.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [NetworkConfigurationDiagnosticParameters] Parameters to
    # get network configuration diagnostic.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkConfigurationDiagnosticResponse] operation results.
    #
    def get_network_configuration_diagnostic(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = get_network_configuration_diagnostic_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [NetworkConfigurationDiagnosticParameters] Parameters to
    # get network configuration diagnostic.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_network_configuration_diagnostic_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_get_network_configuration_diagnostic_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NetworkConfigurationDiagnosticResponse.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Deletes the specified network watcher resource.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, network_watcher_name, custom_headers:nil)
      response = begin_delete_async(resource_group_name, network_watcher_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes the specified network watcher resource.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, network_watcher_name, custom_headers:nil)
      begin_delete_async(resource_group_name, network_watcher_name, custom_headers:custom_headers).value!
    end

    #
    # Deletes the specified network watcher resource.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, network_watcher_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Verify IP flow from the specified VM to a location given the currently
    # configured NSG rules.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [VerificationIPFlowParameters] Parameters that define the
    # IP flow to be verified.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VerificationIPFlowResult] operation results.
    #
    def begin_verify_ipflow(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = begin_verify_ipflow_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Verify IP flow from the specified VM to a location given the currently
    # configured NSG rules.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [VerificationIPFlowParameters] Parameters that define the
    # IP flow to be verified.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_verify_ipflow_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      begin_verify_ipflow_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Verify IP flow from the specified VM to a location given the currently
    # configured NSG rules.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [VerificationIPFlowParameters] Parameters that define the
    # IP flow to be verified.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_verify_ipflow_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::VerificationIPFlowParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/ipFlowVerify'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::VerificationIPFlowResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::VerificationIPFlowResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the next hop from the specified VM.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [NextHopParameters] Parameters that define the source and
    # destination endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NextHopResult] operation results.
    #
    def begin_get_next_hop(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = begin_get_next_hop_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the next hop from the specified VM.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [NextHopParameters] Parameters that define the source and
    # destination endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_next_hop_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      begin_get_next_hop_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Gets the next hop from the specified VM.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [NextHopParameters] Parameters that define the source and
    # destination endpoint.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_next_hop_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NextHopParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/nextHop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NextHopResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NextHopResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the configured and effective security group rules on the specified VM.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [SecurityGroupViewParameters] Parameters that define the VM
    # to check security groups for.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SecurityGroupViewResult] operation results.
    #
    def begin_get_vmsecurity_rules(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = begin_get_vmsecurity_rules_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the configured and effective security group rules on the specified VM.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [SecurityGroupViewParameters] Parameters that define the VM
    # to check security groups for.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_vmsecurity_rules_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      begin_get_vmsecurity_rules_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Gets the configured and effective security group rules on the specified VM.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [SecurityGroupViewParameters] Parameters that define the VM
    # to check security groups for.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_vmsecurity_rules_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::SecurityGroupViewParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/securityGroupView'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::SecurityGroupViewResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::SecurityGroupViewResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Initiate troubleshooting on a specified resource.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [TroubleshootingParameters] Parameters that define the
    # resource to troubleshoot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [TroubleshootingResult] operation results.
    #
    def begin_get_troubleshooting(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = begin_get_troubleshooting_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Initiate troubleshooting on a specified resource.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [TroubleshootingParameters] Parameters that define the
    # resource to troubleshoot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_troubleshooting_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      begin_get_troubleshooting_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Initiate troubleshooting on a specified resource.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [TroubleshootingParameters] Parameters that define the
    # resource to troubleshoot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_troubleshooting_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::TroubleshootingParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/troubleshoot'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::TroubleshootingResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::TroubleshootingResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the last completed troubleshooting result on a specified resource.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [QueryTroubleshootingParameters] Parameters that define the
    # resource to query the troubleshooting result.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [TroubleshootingResult] operation results.
    #
    def begin_get_troubleshooting_result(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = begin_get_troubleshooting_result_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the last completed troubleshooting result on a specified resource.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [QueryTroubleshootingParameters] Parameters that define the
    # resource to query the troubleshooting result.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_troubleshooting_result_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      begin_get_troubleshooting_result_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Get the last completed troubleshooting result on a specified resource.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [QueryTroubleshootingParameters] Parameters that define the
    # resource to query the troubleshooting result.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_troubleshooting_result_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::QueryTroubleshootingParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/queryTroubleshootResult'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::TroubleshootingResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::TroubleshootingResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Configures flow log and traffic analytics (optional) on a specified resource.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [FlowLogInformation] Parameters that define the
    # configuration of flow log.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [FlowLogInformation] operation results.
    #
    def begin_set_flow_log_configuration(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = begin_set_flow_log_configuration_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Configures flow log and traffic analytics (optional) on a specified resource.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [FlowLogInformation] Parameters that define the
    # configuration of flow log.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_set_flow_log_configuration_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      begin_set_flow_log_configuration_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Configures flow log and traffic analytics (optional) on a specified resource.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [FlowLogInformation] Parameters that define the
    # configuration of flow log.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_set_flow_log_configuration_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::FlowLogInformation.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/configureFlowLog'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::FlowLogInformation.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::FlowLogInformation.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Queries status of flow log and traffic analytics (optional) on a specified
    # resource.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [FlowLogStatusParameters] Parameters that define a resource
    # to query flow log and traffic analytics (optional) status.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [FlowLogInformation] operation results.
    #
    def begin_get_flow_log_status(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = begin_get_flow_log_status_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Queries status of flow log and traffic analytics (optional) on a specified
    # resource.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [FlowLogStatusParameters] Parameters that define a resource
    # to query flow log and traffic analytics (optional) status.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_flow_log_status_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      begin_get_flow_log_status_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Queries status of flow log and traffic analytics (optional) on a specified
    # resource.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [FlowLogStatusParameters] Parameters that define a resource
    # to query flow log and traffic analytics (optional) status.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_flow_log_status_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::FlowLogStatusParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/queryFlowLogStatus'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::FlowLogInformation.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::FlowLogInformation.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Verifies the possibility of establishing a direct TCP connection from a
    # virtual machine to a given endpoint including another VM or an arbitrary
    # remote server.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [ConnectivityParameters] Parameters that determine how the
    # connectivity check will be performed.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectivityInformation] operation results.
    #
    def begin_check_connectivity(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = begin_check_connectivity_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Verifies the possibility of establishing a direct TCP connection from a
    # virtual machine to a given endpoint including another VM or an arbitrary
    # remote server.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [ConnectivityParameters] Parameters that determine how the
    # connectivity check will be performed.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_check_connectivity_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      begin_check_connectivity_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Verifies the possibility of establishing a direct TCP connection from a
    # virtual machine to a given endpoint including another VM or an arbitrary
    # remote server.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [ConnectivityParameters] Parameters that determine how the
    # connectivity check will be performed.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_check_connectivity_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::ConnectivityParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectivityCheck'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::ConnectivityInformation.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::ConnectivityInformation.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # NOTE: This feature is currently in preview and still being tested for
    # stability. Gets the relative latency score for internet service providers
    # from a specified location to Azure regions.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [AzureReachabilityReportParameters] Parameters that
    # determine Azure reachability report configuration.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AzureReachabilityReport] operation results.
    #
    def begin_get_azure_reachability_report(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = begin_get_azure_reachability_report_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # NOTE: This feature is currently in preview and still being tested for
    # stability. Gets the relative latency score for internet service providers
    # from a specified location to Azure regions.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [AzureReachabilityReportParameters] Parameters that
    # determine Azure reachability report configuration.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_azure_reachability_report_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      begin_get_azure_reachability_report_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # NOTE: This feature is currently in preview and still being tested for
    # stability. Gets the relative latency score for internet service providers
    # from a specified location to Azure regions.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [AzureReachabilityReportParameters] Parameters that
    # determine Azure reachability report configuration.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_azure_reachability_report_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::AzureReachabilityReportParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/azureReachabilityReport'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::AzureReachabilityReport.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::AzureReachabilityReport.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # NOTE: This feature is currently in preview and still being tested for
    # stability. Lists all available internet service providers for a specified
    # Azure region.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [AvailableProvidersListParameters] Parameters that scope
    # the list of available providers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AvailableProvidersList] operation results.
    #
    def begin_list_available_providers(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = begin_list_available_providers_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # NOTE: This feature is currently in preview and still being tested for
    # stability. Lists all available internet service providers for a specified
    # Azure region.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [AvailableProvidersListParameters] Parameters that scope
    # the list of available providers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_list_available_providers_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      begin_list_available_providers_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # NOTE: This feature is currently in preview and still being tested for
    # stability. Lists all available internet service providers for a specified
    # Azure region.
    #
    # @param resource_group_name [String] The name of the network watcher resource
    # group.
    # @param network_watcher_name [String] The name of the network watcher
    # resource.
    # @param parameters [AvailableProvidersListParameters] Parameters that scope
    # the list of available providers.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_list_available_providers_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::AvailableProvidersListParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/availableProvidersList'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::AvailableProvidersList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::AvailableProvidersList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets Network Configuration Diagnostic data to help customers understand and
    # debug network behavior. It provides detailed information on what security
    # rules were applied to a specified traffic flow and the result of evaluating
    # these rules. Customers must provide details of a flow like source,
    # destination, protocol, etc. The API returns whether traffic was allowed or
    # denied, the rules evaluated for the specified flow and the evaluation
    # results.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [NetworkConfigurationDiagnosticParameters] Parameters to
    # get network configuration diagnostic.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkConfigurationDiagnosticResponse] operation results.
    #
    def begin_get_network_configuration_diagnostic(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      response = begin_get_network_configuration_diagnostic_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets Network Configuration Diagnostic data to help customers understand and
    # debug network behavior. It provides detailed information on what security
    # rules were applied to a specified traffic flow and the result of evaluating
    # these rules. Customers must provide details of a flow like source,
    # destination, protocol, etc. The API returns whether traffic was allowed or
    # denied, the rules evaluated for the specified flow and the evaluation
    # results.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [NetworkConfigurationDiagnosticParameters] Parameters to
    # get network configuration diagnostic.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_network_configuration_diagnostic_with_http_info(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      begin_get_network_configuration_diagnostic_async(resource_group_name, network_watcher_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Gets Network Configuration Diagnostic data to help customers understand and
    # debug network behavior. It provides detailed information on what security
    # rules were applied to a specified traffic flow and the result of evaluating
    # these rules. Customers must provide details of a flow like source,
    # destination, protocol, etc. The API returns whether traffic was allowed or
    # denied, the rules evaluated for the specified flow and the evaluation
    # results.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param parameters [NetworkConfigurationDiagnosticParameters] Parameters to
    # get network configuration diagnostic.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_network_configuration_diagnostic_async(resource_group_name, network_watcher_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NetworkConfigurationDiagnosticParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/networkConfigurationDiagnostic'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NetworkConfigurationDiagnosticResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_03_01::Models::NetworkConfigurationDiagnosticResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
