# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network::Mgmt::V2019_12_01
  module Models
    #
    # Describes the HTTP configuration.
    #
    class ConnectionMonitorHttpConfiguration

      include MsRestAzure

      # @return [Integer] The port to connect to.
      attr_accessor :port

      # @return [HTTPConfigurationMethod] The HTTP method to use. Possible
      # values include: 'Get', 'Post'
      attr_accessor :method

      # @return [String] The path component of the URI. For instance,
      # "/dir1/dir2".
      attr_accessor :path

      # @return [Array<HTTPHeader>] The HTTP headers to transmit with the
      # request.
      attr_accessor :request_headers

      # @return [Array<String>] HTTP status codes to consider successful. For
      # instance, "2xx,301-304,418".
      attr_accessor :valid_status_code_ranges

      # @return [Boolean] Value indicating whether HTTPS is preferred over HTTP
      # in cases where the choice is not explicit.
      attr_accessor :prefer_https


      #
      # Mapper for ConnectionMonitorHttpConfiguration class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'ConnectionMonitorHttpConfiguration',
          type: {
            name: 'Composite',
            class_name: 'ConnectionMonitorHttpConfiguration',
            model_properties: {
              port: {
                client_side_validation: true,
                required: false,
                serialized_name: 'port',
                type: {
                  name: 'Number'
                }
              },
              method: {
                client_side_validation: true,
                required: false,
                serialized_name: 'method',
                type: {
                  name: 'String'
                }
              },
              path: {
                client_side_validation: true,
                required: false,
                serialized_name: 'path',
                type: {
                  name: 'String'
                }
              },
              request_headers: {
                client_side_validation: true,
                required: false,
                serialized_name: 'requestHeaders',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'HTTPHeaderElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'HTTPHeader'
                      }
                  }
                }
              },
              valid_status_code_ranges: {
                client_side_validation: true,
                required: false,
                serialized_name: 'validStatusCodeRanges',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              prefer_https: {
                client_side_validation: true,
                required: false,
                serialized_name: 'preferHTTPS',
                type: {
                  name: 'Boolean'
                }
              }
            }
          }
        }
      end
    end
  end
end
