# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network::Mgmt::V2017_11_01
  module Models
    #
    # Connection state snapshot.
    #
    class ConnectionStateSnapshot

      include MsRestAzure

      # @return [ConnectionState] The connection state. Possible values
      # include: 'Reachable', 'Unreachable', 'Unknown'
      attr_accessor :connection_state

      # @return [DateTime] The start time of the connection snapshot.
      attr_accessor :start_time

      # @return [DateTime] The end time of the connection snapshot.
      attr_accessor :end_time

      # @return [EvaluationState] Connectivity analysis evaluation state.
      # Possible values include: 'NotStarted', 'InProgress', 'Completed'
      attr_accessor :evaluation_state

      # @return [Array<ConnectivityHop>] List of hops between the source and
      # the destination.
      attr_accessor :hops


      #
      # Mapper for ConnectionStateSnapshot class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'ConnectionStateSnapshot',
          type: {
            name: 'Composite',
            class_name: 'ConnectionStateSnapshot',
            model_properties: {
              connection_state: {
                client_side_validation: true,
                required: false,
                serialized_name: 'connectionState',
                type: {
                  name: 'String'
                }
              },
              start_time: {
                client_side_validation: true,
                required: false,
                serialized_name: 'startTime',
                type: {
                  name: 'DateTime'
                }
              },
              end_time: {
                client_side_validation: true,
                required: false,
                serialized_name: 'endTime',
                type: {
                  name: 'DateTime'
                }
              },
              evaluation_state: {
                client_side_validation: true,
                required: false,
                serialized_name: 'evaluationState',
                type: {
                  name: 'String'
                }
              },
              hops: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'hops',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'ConnectivityHopElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'ConnectivityHop'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
