# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::KeyVault::Mgmt::V2019_09_01
  #
  # The Azure management API provides a RESTful set of web services that
  # interact with Azure Key Vault.
  #
  class PrivateEndpointConnections
    include MsRestAzure

    #
    # Creates and initializes a new instance of the PrivateEndpointConnections class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [KeyVaultManagementClient] reference to the KeyVaultManagementClient
    attr_reader :client

    #
    # Gets the specified private endpoint connection associated with the key vault.
    #
    # @param resource_group_name [String] Name of the resource group that contains
    # the key vault.
    # @param vault_name [String] The name of the key vault.
    # @param private_endpoint_connection_name [String] Name of the private endpoint
    # connection associated with the key vault.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PrivateEndpointConnection] operation results.
    #
    def get(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:nil)
      response = get_async(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the specified private endpoint connection associated with the key vault.
    #
    # @param resource_group_name [String] Name of the resource group that contains
    # the key vault.
    # @param vault_name [String] The name of the key vault.
    # @param private_endpoint_connection_name [String] Name of the private endpoint
    # connection associated with the key vault.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:nil)
      get_async(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:custom_headers).value!
    end

    #
    # Gets the specified private endpoint connection associated with the key vault.
    #
    # @param resource_group_name [String] Name of the resource group that contains
    # the key vault.
    # @param vault_name [String] The name of the key vault.
    # @param private_endpoint_connection_name [String] Name of the private endpoint
    # connection associated with the key vault.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vault_name is nil' if vault_name.nil?
      fail ArgumentError, "'vault_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{3,24}$'" if !vault_name.nil? && vault_name.match(Regexp.new('^^[a-zA-Z0-9-]{3,24}$$')).nil?
      fail ArgumentError, 'private_endpoint_connection_name is nil' if private_endpoint_connection_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/privateEndpointConnections/{privateEndpointConnectionName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'vaultName' => vault_name,'privateEndpointConnectionName' => private_endpoint_connection_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2019_09_01::Models::PrivateEndpointConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the specified private endpoint connection associated with the key
    # vault.
    #
    # @param resource_group_name [String] Name of the resource group that contains
    # the key vault.
    # @param vault_name [String] The name of the key vault.
    # @param private_endpoint_connection_name [String] Name of the private endpoint
    # connection associated with the key vault.
    # @param properties [PrivateEndpointConnection] The intended state of private
    # endpoint connection.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PrivateEndpointConnection] operation results.
    #
    def put(resource_group_name, vault_name, private_endpoint_connection_name, properties, custom_headers:nil)
      response = put_async(resource_group_name, vault_name, private_endpoint_connection_name, properties, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the specified private endpoint connection associated with the key
    # vault.
    #
    # @param resource_group_name [String] Name of the resource group that contains
    # the key vault.
    # @param vault_name [String] The name of the key vault.
    # @param private_endpoint_connection_name [String] Name of the private endpoint
    # connection associated with the key vault.
    # @param properties [PrivateEndpointConnection] The intended state of private
    # endpoint connection.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def put_with_http_info(resource_group_name, vault_name, private_endpoint_connection_name, properties, custom_headers:nil)
      put_async(resource_group_name, vault_name, private_endpoint_connection_name, properties, custom_headers:custom_headers).value!
    end

    #
    # Updates the specified private endpoint connection associated with the key
    # vault.
    #
    # @param resource_group_name [String] Name of the resource group that contains
    # the key vault.
    # @param vault_name [String] The name of the key vault.
    # @param private_endpoint_connection_name [String] Name of the private endpoint
    # connection associated with the key vault.
    # @param properties [PrivateEndpointConnection] The intended state of private
    # endpoint connection.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def put_async(resource_group_name, vault_name, private_endpoint_connection_name, properties, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vault_name is nil' if vault_name.nil?
      fail ArgumentError, "'vault_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{3,24}$'" if !vault_name.nil? && vault_name.match(Regexp.new('^^[a-zA-Z0-9-]{3,24}$$')).nil?
      fail ArgumentError, 'private_endpoint_connection_name is nil' if private_endpoint_connection_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'properties is nil' if properties.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::KeyVault::Mgmt::V2019_09_01::Models::PrivateEndpointConnection.mapper()
      request_content = @client.serialize(request_mapper,  properties)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/privateEndpointConnections/{privateEndpointConnectionName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'vaultName' => vault_name,'privateEndpointConnectionName' => private_endpoint_connection_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2019_09_01::Models::PrivateEndpointConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes the specified private endpoint connection associated with the key
    # vault.
    #
    # @param resource_group_name [String] Name of the resource group that contains
    # the key vault.
    # @param vault_name [String] The name of the key vault.
    # @param private_endpoint_connection_name [String] Name of the private endpoint
    # connection associated with the key vault.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PrivateEndpointConnection] operation results.
    #
    def delete(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:nil)
      response = delete_async(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group that contains
    # the key vault.
    # @param vault_name [String] The name of the key vault.
    # @param private_endpoint_connection_name [String] Name of the private endpoint
    # connection associated with the key vault.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:nil)
      # Send request
      promise = begin_delete_async(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::KeyVault::Mgmt::V2019_09_01::Models::PrivateEndpointConnection.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes the specified private endpoint connection associated with the key
    # vault.
    #
    # @param resource_group_name [String] Name of the resource group that contains
    # the key vault.
    # @param vault_name [String] The name of the key vault.
    # @param private_endpoint_connection_name [String] Name of the private endpoint
    # connection associated with the key vault.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PrivateEndpointConnection] operation results.
    #
    def begin_delete(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:nil)
      response = begin_delete_async(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes the specified private endpoint connection associated with the key
    # vault.
    #
    # @param resource_group_name [String] Name of the resource group that contains
    # the key vault.
    # @param vault_name [String] The name of the key vault.
    # @param private_endpoint_connection_name [String] Name of the private endpoint
    # connection associated with the key vault.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:nil)
      begin_delete_async(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:custom_headers).value!
    end

    #
    # Deletes the specified private endpoint connection associated with the key
    # vault.
    #
    # @param resource_group_name [String] Name of the resource group that contains
    # the key vault.
    # @param vault_name [String] The name of the key vault.
    # @param private_endpoint_connection_name [String] Name of the private endpoint
    # connection associated with the key vault.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, vault_name, private_endpoint_connection_name, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vault_name is nil' if vault_name.nil?
      fail ArgumentError, "'vault_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{3,24}$'" if !vault_name.nil? && vault_name.match(Regexp.new('^^[a-zA-Z0-9-]{3,24}$$')).nil?
      fail ArgumentError, 'private_endpoint_connection_name is nil' if private_endpoint_connection_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/privateEndpointConnections/{privateEndpointConnectionName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'vaultName' => vault_name,'privateEndpointConnectionName' => private_endpoint_connection_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2019_09_01::Models::PrivateEndpointConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
