# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::KeyVault::Mgmt::V2018_02_14_preview
  #
  # The Azure management API provides a RESTful set of web services that
  # interact with Azure Key Vault.
  #
  class Secrets
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Secrets class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [KeyVaultManagementClient] reference to the KeyVaultManagementClient
    attr_reader :client

    #
    # Create or update a secret in a key vault in the specified subscription.
    # NOTE: This API is intended for internal use in ARM deployments. Users should
    # use the data-plane REST service for interaction with vault secrets.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the vault belongs.
    # @param vault_name [String] Name of the vault
    # @param secret_name [String] Name of the secret
    # @param parameters [SecretCreateOrUpdateParameters] Parameters to create or
    # update the secret
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Secret] operation results.
    #
    def create_or_update(resource_group_name, vault_name, secret_name, parameters, custom_headers:nil)
      response = create_or_update_async(resource_group_name, vault_name, secret_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a secret in a key vault in the specified subscription.
    # NOTE: This API is intended for internal use in ARM deployments. Users should
    # use the data-plane REST service for interaction with vault secrets.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the vault belongs.
    # @param vault_name [String] Name of the vault
    # @param secret_name [String] Name of the secret
    # @param parameters [SecretCreateOrUpdateParameters] Parameters to create or
    # update the secret
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_with_http_info(resource_group_name, vault_name, secret_name, parameters, custom_headers:nil)
      create_or_update_async(resource_group_name, vault_name, secret_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Create or update a secret in a key vault in the specified subscription.
    # NOTE: This API is intended for internal use in ARM deployments. Users should
    # use the data-plane REST service for interaction with vault secrets.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the vault belongs.
    # @param vault_name [String] Name of the vault
    # @param secret_name [String] Name of the secret
    # @param parameters [SecretCreateOrUpdateParameters] Parameters to create or
    # update the secret
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_async(resource_group_name, vault_name, secret_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vault_name is nil' if vault_name.nil?
      fail ArgumentError, "'vault_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{3,24}$'" if !vault_name.nil? && vault_name.match(Regexp.new('^^[a-zA-Z0-9-]{3,24}$$')).nil?
      fail ArgumentError, 'secret_name is nil' if secret_name.nil?
      fail ArgumentError, "'secret_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{1,127}$'" if !secret_name.nil? && secret_name.match(Regexp.new('^^[a-zA-Z0-9-]{1,127}$$')).nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::KeyVault::Mgmt::V2018_02_14_preview::Models::SecretCreateOrUpdateParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{secretName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vaultName' => vault_name,'secretName' => secret_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 201 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2018_02_14_preview::Models::Secret.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2018_02_14_preview::Models::Secret.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update a secret in the specified subscription.  NOTE: This API is intended
    # for internal use in ARM deployments.  Users should use the data-plane REST
    # service for interaction with vault secrets.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the vault belongs.
    # @param vault_name [String] Name of the vault
    # @param secret_name [String] Name of the secret
    # @param parameters [SecretPatchParameters] Parameters to patch the secret
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Secret] operation results.
    #
    def update(resource_group_name, vault_name, secret_name, parameters, custom_headers:nil)
      response = update_async(resource_group_name, vault_name, secret_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update a secret in the specified subscription.  NOTE: This API is intended
    # for internal use in ARM deployments.  Users should use the data-plane REST
    # service for interaction with vault secrets.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the vault belongs.
    # @param vault_name [String] Name of the vault
    # @param secret_name [String] Name of the secret
    # @param parameters [SecretPatchParameters] Parameters to patch the secret
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_with_http_info(resource_group_name, vault_name, secret_name, parameters, custom_headers:nil)
      update_async(resource_group_name, vault_name, secret_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Update a secret in the specified subscription.  NOTE: This API is intended
    # for internal use in ARM deployments.  Users should use the data-plane REST
    # service for interaction with vault secrets.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the vault belongs.
    # @param vault_name [String] Name of the vault
    # @param secret_name [String] Name of the secret
    # @param parameters [SecretPatchParameters] Parameters to patch the secret
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_async(resource_group_name, vault_name, secret_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vault_name is nil' if vault_name.nil?
      fail ArgumentError, "'vault_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{3,24}$'" if !vault_name.nil? && vault_name.match(Regexp.new('^^[a-zA-Z0-9-]{3,24}$$')).nil?
      fail ArgumentError, 'secret_name is nil' if secret_name.nil?
      fail ArgumentError, "'secret_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{1,127}$'" if !secret_name.nil? && secret_name.match(Regexp.new('^^[a-zA-Z0-9-]{1,127}$$')).nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::KeyVault::Mgmt::V2018_02_14_preview::Models::SecretPatchParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{secretName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vaultName' => vault_name,'secretName' => secret_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 201 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2018_02_14_preview::Models::Secret.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2018_02_14_preview::Models::Secret.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the specified secret.  NOTE: This API is intended for internal use in
    # ARM deployments. Users should use the data-plane REST service for interaction
    # with vault secrets.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the vault belongs.
    # @param vault_name [String] The name of the vault.
    # @param secret_name [String] The name of the secret.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Secret] operation results.
    #
    def get(resource_group_name, vault_name, secret_name, custom_headers:nil)
      response = get_async(resource_group_name, vault_name, secret_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the specified secret.  NOTE: This API is intended for internal use in
    # ARM deployments. Users should use the data-plane REST service for interaction
    # with vault secrets.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the vault belongs.
    # @param vault_name [String] The name of the vault.
    # @param secret_name [String] The name of the secret.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, vault_name, secret_name, custom_headers:nil)
      get_async(resource_group_name, vault_name, secret_name, custom_headers:custom_headers).value!
    end

    #
    # Gets the specified secret.  NOTE: This API is intended for internal use in
    # ARM deployments. Users should use the data-plane REST service for interaction
    # with vault secrets.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the vault belongs.
    # @param vault_name [String] The name of the vault.
    # @param secret_name [String] The name of the secret.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, vault_name, secret_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vault_name is nil' if vault_name.nil?
      fail ArgumentError, 'secret_name is nil' if secret_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{secretName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vaultName' => vault_name,'secretName' => secret_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2018_02_14_preview::Models::Secret.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The List operation gets information about the secrets in a vault.  NOTE: This
    # API is intended for internal use in ARM deployments. Users should use the
    # data-plane REST service for interaction with vault secrets.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the vault belongs.
    # @param vault_name [String] The name of the vault.
    # @param top [Integer] Maximum number of results to return.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Secret>] operation results.
    #
    def list(resource_group_name, vault_name, top:nil, custom_headers:nil)
      first_page = list_as_lazy(resource_group_name, vault_name, top:top, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # The List operation gets information about the secrets in a vault.  NOTE: This
    # API is intended for internal use in ARM deployments. Users should use the
    # data-plane REST service for interaction with vault secrets.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the vault belongs.
    # @param vault_name [String] The name of the vault.
    # @param top [Integer] Maximum number of results to return.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, vault_name, top:nil, custom_headers:nil)
      list_async(resource_group_name, vault_name, top:top, custom_headers:custom_headers).value!
    end

    #
    # The List operation gets information about the secrets in a vault.  NOTE: This
    # API is intended for internal use in ARM deployments. Users should use the
    # data-plane REST service for interaction with vault secrets.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the vault belongs.
    # @param vault_name [String] The name of the vault.
    # @param top [Integer] Maximum number of results to return.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, vault_name, top:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vault_name is nil' if vault_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vaultName' => vault_name,'subscriptionId' => @client.subscription_id},
          query_params: {'$top' => top,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2018_02_14_preview::Models::SecretListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The List operation gets information about the secrets in a vault.  NOTE: This
    # API is intended for internal use in ARM deployments. Users should use the
    # data-plane REST service for interaction with vault secrets.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SecretListResult] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The List operation gets information about the secrets in a vault.  NOTE: This
    # API is intended for internal use in ARM deployments. Users should use the
    # data-plane REST service for interaction with vault secrets.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # The List operation gets information about the secrets in a vault.  NOTE: This
    # API is intended for internal use in ARM deployments. Users should use the
    # data-plane REST service for interaction with vault secrets.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2018_02_14_preview::Models::SecretListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The List operation gets information about the secrets in a vault.  NOTE: This
    # API is intended for internal use in ARM deployments. Users should use the
    # data-plane REST service for interaction with vault secrets.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the vault belongs.
    # @param vault_name [String] The name of the vault.
    # @param top [Integer] Maximum number of results to return.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SecretListResult] which provide lazy access to pages of the
    # response.
    #
    def list_as_lazy(resource_group_name, vault_name, top:nil, custom_headers:nil)
      response = list_async(resource_group_name, vault_name, top:top, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
