# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_12_01
  module Models
    #
    # Input for InstallPatches on a Windows VM, as directly received by the API
    #
    class WindowsParameters

      include MsRestAzure

      # @return [Array<VMGuestPatchClassificationWindows>] The update
      # classifications to select when installing patches for Windows.
      attr_accessor :classifications_to_include

      # @return [Array<String>] Kbs to include in the patch operation
      attr_accessor :kb_numbers_to_include

      # @return [Array<String>] Kbs to exclude in the patch operation
      attr_accessor :kb_numbers_to_exclude

      # @return [Boolean] Filters out Kbs that don't have an
      # InstallationRebootBehavior of 'NeverReboots' when this is set to true.
      attr_accessor :exclude_kbs_requiring_reboot

      # @return [DateTime] This is used to install patches that were published
      # on or before this given max published date.
      attr_accessor :max_patch_publish_date


      #
      # Mapper for WindowsParameters class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'WindowsParameters',
          type: {
            name: 'Composite',
            class_name: 'WindowsParameters',
            model_properties: {
              classifications_to_include: {
                client_side_validation: true,
                required: false,
                serialized_name: 'classificationsToInclude',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'VMGuestPatchClassificationWindowsElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              kb_numbers_to_include: {
                client_side_validation: true,
                required: false,
                serialized_name: 'kbNumbersToInclude',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              kb_numbers_to_exclude: {
                client_side_validation: true,
                required: false,
                serialized_name: 'kbNumbersToExclude',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              exclude_kbs_requiring_reboot: {
                client_side_validation: true,
                required: false,
                serialized_name: 'excludeKbsRequiringReboot',
                type: {
                  name: 'Boolean'
                }
              },
              max_patch_publish_date: {
                client_side_validation: true,
                required: false,
                serialized_name: 'maxPatchPublishDate',
                type: {
                  name: 'DateTime'
                }
              }
            }
          }
        }
      end
    end
  end
end
