# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_12_01
  module Models
    #
    # The result summary of an installation operation.
    #
    class VirtualMachineInstallPatchesResult

      include MsRestAzure

      # @return [PatchOperationStatus] The overall success or failure status of
      # the operation. It remains "InProgress" until the operation completes.
      # At that point it will become "Failed", "Succeeded", "Unknown" or
      # "CompletedWithWarnings.". Possible values include: 'Unknown',
      # 'InProgress', 'Failed', 'Succeeded', 'CompletedWithWarnings'
      attr_accessor :status

      # @return [String] The activity ID of the operation that produced this
      # result. It is used to correlate across CRP and extension logs.
      attr_accessor :installation_activity_id

      # @return [VMGuestPatchRebootStatus] The reboot state of the VM following
      # completion of the operation. Possible values include: 'Unknown',
      # 'NotNeeded', 'Required', 'Started', 'Failed', 'Completed'
      attr_accessor :reboot_status

      # @return [Boolean] Whether the operation ran out of time before it
      # completed all its intended actions.
      attr_accessor :maintenance_window_exceeded

      # @return [Integer] The number of patches that were not installed due to
      # the user blocking their installation.
      attr_accessor :excluded_patch_count

      # @return [Integer] The number of patches that were detected as available
      # for install, but did not meet the operation's criteria.
      attr_accessor :not_selected_patch_count

      # @return [Integer] The number of patches that were identified as meeting
      # the installation criteria, but were not able to be installed. Typically
      # this happens when maintenanceWindowExceeded == true.
      attr_accessor :pending_patch_count

      # @return [Integer] The number of patches successfully installed.
      attr_accessor :installed_patch_count

      # @return [Integer] The number of patches that could not be installed due
      # to some issue. See errors for details.
      attr_accessor :failed_patch_count

      # @return [Array<PatchInstallationDetail>] The patches that were
      # installed during the operation.
      attr_accessor :patches

      # @return [DateTime] The UTC timestamp when the operation began.
      attr_accessor :start_date_time

      # @return [ApiError] The errors that were encountered during execution of
      # the operation. The details array contains the list of them.
      attr_accessor :error


      #
      # Mapper for VirtualMachineInstallPatchesResult class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'VirtualMachineInstallPatchesResult',
          type: {
            name: 'Composite',
            class_name: 'VirtualMachineInstallPatchesResult',
            model_properties: {
              status: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'status',
                type: {
                  name: 'String'
                }
              },
              installation_activity_id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'installationActivityId',
                type: {
                  name: 'String'
                }
              },
              reboot_status: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'rebootStatus',
                type: {
                  name: 'String'
                }
              },
              maintenance_window_exceeded: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'maintenanceWindowExceeded',
                type: {
                  name: 'Boolean'
                }
              },
              excluded_patch_count: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'excludedPatchCount',
                type: {
                  name: 'Number'
                }
              },
              not_selected_patch_count: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'notSelectedPatchCount',
                type: {
                  name: 'Number'
                }
              },
              pending_patch_count: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'pendingPatchCount',
                type: {
                  name: 'Number'
                }
              },
              installed_patch_count: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'installedPatchCount',
                type: {
                  name: 'Number'
                }
              },
              failed_patch_count: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'failedPatchCount',
                type: {
                  name: 'Number'
                }
              },
              patches: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'patches',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'PatchInstallationDetailElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'PatchInstallationDetail'
                      }
                  }
                }
              },
              start_date_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'startDateTime',
                type: {
                  name: 'DateTime'
                }
              },
              error: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'error',
                type: {
                  name: 'Composite',
                  class_name: 'ApiError'
                }
              }
            }
          }
        }
      end
    end
  end
end
