# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_10_01_preview
  module Models
    #
    # Extension Properties.
    #
    class CloudServiceExtensionProperties

      include MsRestAzure

      # @return [String] The name of the extension handler publisher.
      attr_accessor :publisher

      # @return [String] Specifies the type of the extension.
      attr_accessor :type

      # @return [String] Specifies the version of the extension. Specifies the
      # version of the extension. If this element is not specified or an
      # asterisk (*) is used as the value, the latest version of the extension
      # is used. If the value is specified with a major version number and an
      # asterisk as the minor version number (X.), the latest minor version of
      # the specified major version is selected. If a major version number and
      # a minor version number are specified (X.Y), the specific extension
      # version is selected. If a version is specified, an auto-upgrade is
      # performed on the role instance.
      attr_accessor :type_handler_version

      # @return [Boolean] Explicitly specify whether platform can automatically
      # upgrade typeHandlerVersion to higher minor versions when they become
      # available.
      attr_accessor :auto_upgrade_minor_version

      # @return [String] Public settings for the extension. For JSON
      # extensions, this is the JSON settings for the extension. For XML
      # Extension (like RDP), this is the XML setting for the extension.
      attr_accessor :settings

      # @return [String] Protected settings for the extension which are
      # encrypted before sent to the role instance.
      attr_accessor :protected_settings

      # @return [CloudServiceVaultAndSecretReference]
      attr_accessor :protected_settings_from_key_vault

      # @return [String] Tag to force apply the provided public and protected
      # settings.
      # Changing the tag value allows for re-running the extension without
      # changing any of the public or protected settings.
      # If forceUpdateTag is not changed, updates to public or protected
      # settings would still be applied by the handler.
      # If neither forceUpdateTag nor any of public or protected settings
      # change, extension would flow to the role instance with the same
      # sequence-number, and
      # it is up to handler implementation whether to re-run it or not
      attr_accessor :force_update_tag

      # @return [String] The provisioning state, which only appears in the
      # response.
      attr_accessor :provisioning_state

      # @return [Array<String>] Optional list of roles to apply this extension.
      # If property is not specified or '*' is specified, extension is applied
      # to all roles in the cloud service.
      attr_accessor :roles_applied_to


      #
      # Mapper for CloudServiceExtensionProperties class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'CloudServiceExtensionProperties',
          type: {
            name: 'Composite',
            class_name: 'CloudServiceExtensionProperties',
            model_properties: {
              publisher: {
                client_side_validation: true,
                required: false,
                serialized_name: 'publisher',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              type_handler_version: {
                client_side_validation: true,
                required: false,
                serialized_name: 'typeHandlerVersion',
                type: {
                  name: 'String'
                }
              },
              auto_upgrade_minor_version: {
                client_side_validation: true,
                required: false,
                serialized_name: 'autoUpgradeMinorVersion',
                type: {
                  name: 'Boolean'
                }
              },
              settings: {
                client_side_validation: true,
                required: false,
                serialized_name: 'settings',
                type: {
                  name: 'String'
                }
              },
              protected_settings: {
                client_side_validation: true,
                required: false,
                serialized_name: 'protectedSettings',
                type: {
                  name: 'String'
                }
              },
              protected_settings_from_key_vault: {
                client_side_validation: true,
                required: false,
                serialized_name: 'protectedSettingsFromKeyVault',
                type: {
                  name: 'Composite',
                  class_name: 'CloudServiceVaultAndSecretReference'
                }
              },
              force_update_tag: {
                client_side_validation: true,
                required: false,
                serialized_name: 'forceUpdateTag',
                type: {
                  name: 'String'
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'provisioningState',
                type: {
                  name: 'String'
                }
              },
              roles_applied_to: {
                client_side_validation: true,
                required: false,
                serialized_name: 'rolesAppliedTo',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
