# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_09_30_preview
  module Models
    #
    # Describes the basic gallery artifact publishing profile.
    #
    class GalleryArtifactPublishingProfileBase

      include MsRestAzure

      # @return [Array<TargetRegion>] The target regions where the Image
      # Version is going to be replicated to. This property is updatable.
      attr_accessor :target_regions

      # @return [Integer] The number of replicas of the Image Version to be
      # created per region. This property would take effect for a region when
      # regionalReplicaCount is not specified. This property is updatable.
      attr_accessor :replica_count

      # @return [Boolean] If set to true, Virtual Machines deployed from the
      # latest version of the Image Definition won't use this Image Version.
      attr_accessor :exclude_from_latest

      # @return [DateTime] The timestamp for when the gallery image version is
      # published.
      attr_accessor :published_date

      # @return [DateTime] The end of life date of the gallery image version.
      # This property can be used for decommissioning purposes. This property
      # is updatable.
      attr_accessor :end_of_life_date

      # @return [StorageAccountType] Specifies the storage account type to be
      # used to store the image. This property is not updatable. Possible
      # values include: 'Standard_LRS', 'Standard_ZRS', 'Premium_LRS'
      attr_accessor :storage_account_type


      #
      # Mapper for GalleryArtifactPublishingProfileBase class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'GalleryArtifactPublishingProfileBase',
          type: {
            name: 'Composite',
            class_name: 'GalleryArtifactPublishingProfileBase',
            model_properties: {
              target_regions: {
                client_side_validation: true,
                required: false,
                serialized_name: 'targetRegions',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'TargetRegionElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'TargetRegion'
                      }
                  }
                }
              },
              replica_count: {
                client_side_validation: true,
                required: false,
                serialized_name: 'replicaCount',
                type: {
                  name: 'Number'
                }
              },
              exclude_from_latest: {
                client_side_validation: true,
                required: false,
                serialized_name: 'excludeFromLatest',
                type: {
                  name: 'Boolean'
                }
              },
              published_date: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'publishedDate',
                type: {
                  name: 'DateTime'
                }
              },
              end_of_life_date: {
                client_side_validation: true,
                required: false,
                serialized_name: 'endOfLifeDate',
                type: {
                  name: 'DateTime'
                }
              },
              storage_account_type: {
                client_side_validation: true,
                required: false,
                serialized_name: 'storageAccountType',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
