# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2019_12_01
  module Models
    #
    # The source user image virtual hard disk. The virtual hard disk will be
    # copied before being attached to the virtual machine. If SourceImage is
    # provided, the destination virtual hard drive must not exist.
    #
    class Image < Resource

      include MsRestAzure

      # @return [SubResource] The source virtual machine from which Image is
      # created.
      attr_accessor :source_virtual_machine

      # @return [ImageStorageProfile] Specifies the storage settings for the
      # virtual machine disks.
      attr_accessor :storage_profile

      # @return [String] The provisioning state.
      attr_accessor :provisioning_state

      # @return [HyperVGenerationTypes] Gets the HyperVGenerationType of the
      # VirtualMachine created from the image. Possible values include: 'V1',
      # 'V2'
      attr_accessor :hyper_vgeneration


      #
      # Mapper for Image class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'Image',
          type: {
            name: 'Composite',
            class_name: 'Image',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                client_side_validation: true,
                required: true,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                client_side_validation: true,
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              source_virtual_machine: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.sourceVirtualMachine',
                type: {
                  name: 'Composite',
                  class_name: 'SubResource'
                }
              },
              storage_profile: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.storageProfile',
                type: {
                  name: 'Composite',
                  class_name: 'ImageStorageProfile'
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              hyper_vgeneration: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.hyperVGeneration',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
