# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2018_06_01
  #
  # Compute Client
  #
  class GalleryImages
    include MsRestAzure

    #
    # Creates and initializes a new instance of the GalleryImages class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ComputeManagementClient] reference to the ComputeManagementClient
    attr_reader :client

    #
    # Create or update a gallery Image Definition.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery in which
    # the Image Definition is to be created.
    # @param gallery_image_name [String] The name of the gallery Image Definition
    # to be created or updated. The allowed characters are alphabets and numbers
    # with dots, dashes, and periods allowed in the middle. The maximum length is
    # 80 characters.
    # @param gallery_image [GalleryImage] Parameters supplied to the create or
    # update gallery image operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GalleryImage] operation results.
    #
    def create_or_update(resource_group_name, gallery_name, gallery_image_name, gallery_image, custom_headers:nil)
      response = create_or_update_async(resource_group_name, gallery_name, gallery_image_name, gallery_image, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery in which
    # the Image Definition is to be created.
    # @param gallery_image_name [String] The name of the gallery Image Definition
    # to be created or updated. The allowed characters are alphabets and numbers
    # with dots, dashes, and periods allowed in the middle. The maximum length is
    # 80 characters.
    # @param gallery_image [GalleryImage] Parameters supplied to the create or
    # update gallery image operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, gallery_name, gallery_image_name, gallery_image, custom_headers:nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, gallery_name, gallery_image_name, gallery_image, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Compute::Mgmt::V2018_06_01::Models::GalleryImage.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Retrieves information about a gallery Image Definition.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery from which
    # the Image Definitions are to be retrieved.
    # @param gallery_image_name [String] The name of the gallery Image Definition
    # to be retrieved.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GalleryImage] operation results.
    #
    def get(resource_group_name, gallery_name, gallery_image_name, custom_headers:nil)
      response = get_async(resource_group_name, gallery_name, gallery_image_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves information about a gallery Image Definition.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery from which
    # the Image Definitions are to be retrieved.
    # @param gallery_image_name [String] The name of the gallery Image Definition
    # to be retrieved.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, gallery_name, gallery_image_name, custom_headers:nil)
      get_async(resource_group_name, gallery_name, gallery_image_name, custom_headers:custom_headers).value!
    end

    #
    # Retrieves information about a gallery Image Definition.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery from which
    # the Image Definitions are to be retrieved.
    # @param gallery_image_name [String] The name of the gallery Image Definition
    # to be retrieved.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, gallery_name, gallery_image_name, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'gallery_name is nil' if gallery_name.nil?
      fail ArgumentError, 'gallery_image_name is nil' if gallery_image_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'galleryName' => gallery_name,'galleryImageName' => gallery_image_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2018_06_01::Models::GalleryImage.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a gallery image.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery in which
    # the Image Definition is to be deleted.
    # @param gallery_image_name [String] The name of the gallery Image Definition
    # to be deleted.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, gallery_name, gallery_image_name, custom_headers:nil)
      response = delete_async(resource_group_name, gallery_name, gallery_image_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery in which
    # the Image Definition is to be deleted.
    # @param gallery_image_name [String] The name of the gallery Image Definition
    # to be deleted.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, gallery_name, gallery_image_name, custom_headers:nil)
      # Send request
      promise = begin_delete_async(resource_group_name, gallery_name, gallery_image_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # List gallery Image Definitions in a gallery.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery from which
    # Image Definitions are to be listed.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<GalleryImage>] operation results.
    #
    def list_by_gallery(resource_group_name, gallery_name, custom_headers:nil)
      first_page = list_by_gallery_as_lazy(resource_group_name, gallery_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # List gallery Image Definitions in a gallery.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery from which
    # Image Definitions are to be listed.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_gallery_with_http_info(resource_group_name, gallery_name, custom_headers:nil)
      list_by_gallery_async(resource_group_name, gallery_name, custom_headers:custom_headers).value!
    end

    #
    # List gallery Image Definitions in a gallery.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery from which
    # Image Definitions are to be listed.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_gallery_async(resource_group_name, gallery_name, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'gallery_name is nil' if gallery_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'galleryName' => gallery_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2018_06_01::Models::GalleryImageList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update a gallery Image Definition.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery in which
    # the Image Definition is to be created.
    # @param gallery_image_name [String] The name of the gallery Image Definition
    # to be created or updated. The allowed characters are alphabets and numbers
    # with dots, dashes, and periods allowed in the middle. The maximum length is
    # 80 characters.
    # @param gallery_image [GalleryImage] Parameters supplied to the create or
    # update gallery image operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GalleryImage] operation results.
    #
    def begin_create_or_update(resource_group_name, gallery_name, gallery_image_name, gallery_image, custom_headers:nil)
      response = begin_create_or_update_async(resource_group_name, gallery_name, gallery_image_name, gallery_image, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a gallery Image Definition.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery in which
    # the Image Definition is to be created.
    # @param gallery_image_name [String] The name of the gallery Image Definition
    # to be created or updated. The allowed characters are alphabets and numbers
    # with dots, dashes, and periods allowed in the middle. The maximum length is
    # 80 characters.
    # @param gallery_image [GalleryImage] Parameters supplied to the create or
    # update gallery image operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, gallery_name, gallery_image_name, gallery_image, custom_headers:nil)
      begin_create_or_update_async(resource_group_name, gallery_name, gallery_image_name, gallery_image, custom_headers:custom_headers).value!
    end

    #
    # Create or update a gallery Image Definition.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery in which
    # the Image Definition is to be created.
    # @param gallery_image_name [String] The name of the gallery Image Definition
    # to be created or updated. The allowed characters are alphabets and numbers
    # with dots, dashes, and periods allowed in the middle. The maximum length is
    # 80 characters.
    # @param gallery_image [GalleryImage] Parameters supplied to the create or
    # update gallery image operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, gallery_name, gallery_image_name, gallery_image, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'gallery_name is nil' if gallery_name.nil?
      fail ArgumentError, 'gallery_image_name is nil' if gallery_image_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'gallery_image is nil' if gallery_image.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2018_06_01::Models::GalleryImage.mapper()
      request_content = @client.serialize(request_mapper,  gallery_image)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'galleryName' => gallery_name,'galleryImageName' => gallery_image_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2018_06_01::Models::GalleryImage.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2018_06_01::Models::GalleryImage.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2018_06_01::Models::GalleryImage.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a gallery image.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery in which
    # the Image Definition is to be deleted.
    # @param gallery_image_name [String] The name of the gallery Image Definition
    # to be deleted.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, gallery_name, gallery_image_name, custom_headers:nil)
      response = begin_delete_async(resource_group_name, gallery_name, gallery_image_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Delete a gallery image.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery in which
    # the Image Definition is to be deleted.
    # @param gallery_image_name [String] The name of the gallery Image Definition
    # to be deleted.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, gallery_name, gallery_image_name, custom_headers:nil)
      begin_delete_async(resource_group_name, gallery_name, gallery_image_name, custom_headers:custom_headers).value!
    end

    #
    # Delete a gallery image.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery in which
    # the Image Definition is to be deleted.
    # @param gallery_image_name [String] The name of the gallery Image Definition
    # to be deleted.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, gallery_name, gallery_image_name, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'gallery_name is nil' if gallery_name.nil?
      fail ArgumentError, 'gallery_image_name is nil' if gallery_image_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'galleryName' => gallery_name,'galleryImageName' => gallery_image_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # List gallery Image Definitions in a gallery.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GalleryImageList] operation results.
    #
    def list_by_gallery_next(next_page_link, custom_headers:nil)
      response = list_by_gallery_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List gallery Image Definitions in a gallery.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_gallery_next_with_http_info(next_page_link, custom_headers:nil)
      list_by_gallery_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # List gallery Image Definitions in a gallery.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_gallery_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2018_06_01::Models::GalleryImageList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List gallery Image Definitions in a gallery.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param gallery_name [String] The name of the Shared Image Gallery from which
    # Image Definitions are to be listed.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GalleryImageList] which provide lazy access to pages of the
    # response.
    #
    def list_by_gallery_as_lazy(resource_group_name, gallery_name, custom_headers:nil)
      response = list_by_gallery_async(resource_group_name, gallery_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_gallery_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
