# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2017_03_30
  module Models
    #
    # Describes a virtual machine scale set network profile's network
    # configurations.
    #
    class VirtualMachineScaleSetNetworkConfiguration < SubResource

      include MsRestAzure

      # @return [String] The network configuration name.
      attr_accessor :name

      # @return [Boolean] Specifies the primary network interface in case the
      # virtual machine has more than 1 network interface.
      attr_accessor :primary

      # @return [Boolean] Specifies whether the network interface is
      # accelerated networking-enabled.
      attr_accessor :enable_accelerated_networking

      # @return [SubResource] The network security group.
      attr_accessor :network_security_group

      # @return [VirtualMachineScaleSetNetworkConfigurationDnsSettings] The dns
      # settings to be applied on the network interfaces.
      attr_accessor :dns_settings

      # @return [Array<VirtualMachineScaleSetIPConfiguration>] Specifies the IP
      # configurations of the network interface.
      attr_accessor :ip_configurations


      #
      # Mapper for VirtualMachineScaleSetNetworkConfiguration class as Ruby
      # Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'VirtualMachineScaleSetNetworkConfiguration',
          type: {
            name: 'Composite',
            class_name: 'VirtualMachineScaleSetNetworkConfiguration',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              primary: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.primary',
                type: {
                  name: 'Boolean'
                }
              },
              enable_accelerated_networking: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.enableAcceleratedNetworking',
                type: {
                  name: 'Boolean'
                }
              },
              network_security_group: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.networkSecurityGroup',
                type: {
                  name: 'Composite',
                  class_name: 'SubResource'
                }
              },
              dns_settings: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.dnsSettings',
                type: {
                  name: 'Composite',
                  class_name: 'VirtualMachineScaleSetNetworkConfigurationDnsSettings'
                }
              },
              ip_configurations: {
                client_side_validation: true,
                required: true,
                serialized_name: 'properties.ipConfigurations',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'VirtualMachineScaleSetIPConfigurationElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'VirtualMachineScaleSetIPConfiguration'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
