# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::KeyVault::Mgmt::V2019_09_01
  module Models
    #
    # The properties of the key.
    #
    class KeyProperties

      include MsRestAzure

      # @return [KeyAttributes] The attributes of the key.
      attr_accessor :attributes

      # @return [JsonWebKeyType] The type of the key. For valid values, see
      # JsonWebKeyType. Possible values include: 'EC', 'EC-HSM', 'RSA',
      # 'RSA-HSM'
      attr_accessor :kty

      # @return [Array<JsonWebKeyOperation>]
      attr_accessor :key_ops

      # @return [Integer] The key size in bits. For example: 2048, 3072, or
      # 4096 for RSA.
      attr_accessor :key_size

      # @return [JsonWebKeyCurveName] The elliptic curve name. For valid
      # values, see JsonWebKeyCurveName. Possible values include: 'P-256',
      # 'P-384', 'P-521', 'P-256K'
      attr_accessor :curve_name

      # @return [String] The URI to retrieve the current version of the key.
      attr_accessor :key_uri

      # @return [String] The URI to retrieve the specific version of the key.
      attr_accessor :key_uri_with_version


      #
      # Mapper for KeyProperties class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'KeyProperties',
          type: {
            name: 'Composite',
            class_name: 'KeyProperties',
            model_properties: {
              attributes: {
                client_side_validation: true,
                required: false,
                serialized_name: 'attributes',
                type: {
                  name: 'Composite',
                  class_name: 'KeyAttributes'
                }
              },
              kty: {
                client_side_validation: true,
                required: false,
                serialized_name: 'kty',
                constraints: {
                  MinLength: 1
                },
                type: {
                  name: 'String'
                }
              },
              key_ops: {
                client_side_validation: true,
                required: false,
                serialized_name: 'keyOps',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'JsonWebKeyOperationElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              key_size: {
                client_side_validation: true,
                required: false,
                serialized_name: 'keySize',
                type: {
                  name: 'Number'
                }
              },
              curve_name: {
                client_side_validation: true,
                required: false,
                serialized_name: 'curveName',
                type: {
                  name: 'String'
                }
              },
              key_uri: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'keyUri',
                type: {
                  name: 'String'
                }
              },
              key_uri_with_version: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'keyUriWithVersion',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
