# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_12_01
  module Models
    #
    # Specifies the Security profile settings for the virtual machine or
    # virtual machine scale set.
    #
    class SecurityProfile

      include MsRestAzure

      # @return [UefiSettings] Specifies the security settings like secure boot
      # and vTPM used while creating the virtual machine. <br><br>Minimum
      # api-version: 2020-12-01
      attr_accessor :uefi_settings

      # @return [Boolean] This property can be used by user in the request to
      # enable or disable the Host Encryption for the virtual machine or
      # virtual machine scale set. This will enable the encryption for all the
      # disks including Resource/Temp disk at host itself. <br><br> Default:
      # The Encryption at host will be disabled unless this property is set to
      # true for the resource.
      attr_accessor :encryption_at_host

      # @return [SecurityTypes] Specifies the SecurityType of the virtual
      # machine. It is set as TrustedLaunch to enable UefiSettings. <br><br>
      # Default: UefiSettings will not be enabled unless this property is set
      # as TrustedLaunch. Possible values include: 'TrustedLaunch'
      attr_accessor :security_type


      #
      # Mapper for SecurityProfile class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'SecurityProfile',
          type: {
            name: 'Composite',
            class_name: 'SecurityProfile',
            model_properties: {
              uefi_settings: {
                client_side_validation: true,
                required: false,
                serialized_name: 'uefiSettings',
                type: {
                  name: 'Composite',
                  class_name: 'UefiSettings'
                }
              },
              encryption_at_host: {
                client_side_validation: true,
                required: false,
                serialized_name: 'encryptionAtHost',
                type: {
                  name: 'Boolean'
                }
              },
              security_type: {
                client_side_validation: true,
                required: false,
                serialized_name: 'securityType',
                type: {
                  name: 'Enum',
                  module: 'SecurityTypes'
                }
              }
            }
          }
        }
      end
    end
  end
end
