# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_12_01
  module Models
    #
    # Information about a specific patch that was encountered during an
    # installation action.
    #
    class PatchInstallationDetail

      include MsRestAzure

      # @return [String] A unique identifier for the patch.
      attr_accessor :patch_id

      # @return [String] The friendly name of the patch.
      attr_accessor :name

      # @return [String] The version string of the package. It may conform to
      # Semantic Versioning. Only applies to Linux.
      attr_accessor :version

      # @return [String] The KBID of the patch. Only applies to Windows
      # patches.
      attr_accessor :kb_id

      # @return [Array<String>] The classification(s) of the patch as provided
      # by the patch publisher.
      attr_accessor :classifications

      # @return [PatchInstallationState] The state of the patch after the
      # installation operation completed. Possible values include: 'Unknown',
      # 'Installed', 'Failed', 'Excluded', 'NotSelected', 'Pending'
      attr_accessor :installation_state


      #
      # Mapper for PatchInstallationDetail class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'PatchInstallationDetail',
          type: {
            name: 'Composite',
            class_name: 'PatchInstallationDetail',
            model_properties: {
              patch_id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'patchId',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              version: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'version',
                type: {
                  name: 'String'
                }
              },
              kb_id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'kbId',
                type: {
                  name: 'String'
                }
              },
              classifications: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'classifications',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              installation_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'installationState',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
