# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_12_01
  module Models
    #
    # Maintenance Operation Status.
    #
    class MaintenanceRedeployStatus

      include MsRestAzure

      # @return [Boolean] True, if customer is allowed to perform Maintenance.
      attr_accessor :is_customer_initiated_maintenance_allowed

      # @return [DateTime] Start Time for the Pre Maintenance Window.
      attr_accessor :pre_maintenance_window_start_time

      # @return [DateTime] End Time for the Pre Maintenance Window.
      attr_accessor :pre_maintenance_window_end_time

      # @return [DateTime] Start Time for the Maintenance Window.
      attr_accessor :maintenance_window_start_time

      # @return [DateTime] End Time for the Maintenance Window.
      attr_accessor :maintenance_window_end_time

      # @return [MaintenanceOperationResultCodeTypes] The Last Maintenance
      # Operation Result Code. Possible values include: 'None', 'RetryLater',
      # 'MaintenanceAborted', 'MaintenanceCompleted'
      attr_accessor :last_operation_result_code

      # @return [String] Message returned for the last Maintenance Operation.
      attr_accessor :last_operation_message


      #
      # Mapper for MaintenanceRedeployStatus class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'MaintenanceRedeployStatus',
          type: {
            name: 'Composite',
            class_name: 'MaintenanceRedeployStatus',
            model_properties: {
              is_customer_initiated_maintenance_allowed: {
                client_side_validation: true,
                required: false,
                serialized_name: 'isCustomerInitiatedMaintenanceAllowed',
                type: {
                  name: 'Boolean'
                }
              },
              pre_maintenance_window_start_time: {
                client_side_validation: true,
                required: false,
                serialized_name: 'preMaintenanceWindowStartTime',
                type: {
                  name: 'DateTime'
                }
              },
              pre_maintenance_window_end_time: {
                client_side_validation: true,
                required: false,
                serialized_name: 'preMaintenanceWindowEndTime',
                type: {
                  name: 'DateTime'
                }
              },
              maintenance_window_start_time: {
                client_side_validation: true,
                required: false,
                serialized_name: 'maintenanceWindowStartTime',
                type: {
                  name: 'DateTime'
                }
              },
              maintenance_window_end_time: {
                client_side_validation: true,
                required: false,
                serialized_name: 'maintenanceWindowEndTime',
                type: {
                  name: 'DateTime'
                }
              },
              last_operation_result_code: {
                client_side_validation: true,
                required: false,
                serialized_name: 'lastOperationResultCode',
                type: {
                  name: 'Enum',
                  module: 'MaintenanceOperationResultCodeTypes'
                }
              },
              last_operation_message: {
                client_side_validation: true,
                required: false,
                serialized_name: 'lastOperationMessage',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
