# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_10_01_preview
  #
  # Compute Client
  #
  class CloudServicesUpdateDomain
    include MsRestAzure

    #
    # Creates and initializes a new instance of the CloudServicesUpdateDomain class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ComputeManagementClient] reference to the ComputeManagementClient
    attr_reader :client

    #
    # Updates the role instances in the specified update domain.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param update_domain [Integer] Specifies an integer value that identifies the
    # update domain. Update domains are identified with a zero-based index: the
    # first update domain has an ID of 0, the second has an ID of 1, and so on.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def walk_update_domain(resource_group_name, cloud_service_name, update_domain, custom_headers:nil)
      response = walk_update_domain_async(resource_group_name, cloud_service_name, update_domain, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param update_domain [Integer] Specifies an integer value that identifies the
    # update domain. Update domains are identified with a zero-based index: the
    # first update domain has an ID of 0, the second has an ID of 1, and so on.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def walk_update_domain_async(resource_group_name, cloud_service_name, update_domain, custom_headers:nil)
      # Send request
      promise = begin_walk_update_domain_async(resource_group_name, cloud_service_name, update_domain, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets the specified update domain of a cloud service. Use nextLink property in
    # the response to get the next page of update domains. Do this till nextLink is
    # null to fetch all the update domains.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param update_domain [Integer] Specifies an integer value that identifies the
    # update domain. Update domains are identified with a zero-based index: the
    # first update domain has an ID of 0, the second has an ID of 1, and so on.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [UpdateDomain] operation results.
    #
    def get_update_domain(resource_group_name, cloud_service_name, update_domain, custom_headers:nil)
      response = get_update_domain_async(resource_group_name, cloud_service_name, update_domain, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the specified update domain of a cloud service. Use nextLink property in
    # the response to get the next page of update domains. Do this till nextLink is
    # null to fetch all the update domains.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param update_domain [Integer] Specifies an integer value that identifies the
    # update domain. Update domains are identified with a zero-based index: the
    # first update domain has an ID of 0, the second has an ID of 1, and so on.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_update_domain_with_http_info(resource_group_name, cloud_service_name, update_domain, custom_headers:nil)
      get_update_domain_async(resource_group_name, cloud_service_name, update_domain, custom_headers:custom_headers).value!
    end

    #
    # Gets the specified update domain of a cloud service. Use nextLink property in
    # the response to get the next page of update domains. Do this till nextLink is
    # null to fetch all the update domains.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param update_domain [Integer] Specifies an integer value that identifies the
    # update domain. Update domains are identified with a zero-based index: the
    # first update domain has an ID of 0, the second has an ID of 1, and so on.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_update_domain_async(resource_group_name, cloud_service_name, update_domain, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, 'update_domain is nil' if update_domain.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/updateDomains/{updateDomain}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'updateDomain' => update_domain,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::UpdateDomain.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all update domains in a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<UpdateDomain>] operation results.
    #
    def list_update_domains(resource_group_name, cloud_service_name, custom_headers:nil)
      first_page = list_update_domains_as_lazy(resource_group_name, cloud_service_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets a list of all update domains in a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_update_domains_with_http_info(resource_group_name, cloud_service_name, custom_headers:nil)
      list_update_domains_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of all update domains in a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_update_domains_async(resource_group_name, cloud_service_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/updateDomains'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::UpdateDomainListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the role instances in the specified update domain.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param update_domain [Integer] Specifies an integer value that identifies the
    # update domain. Update domains are identified with a zero-based index: the
    # first update domain has an ID of 0, the second has an ID of 1, and so on.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_walk_update_domain(resource_group_name, cloud_service_name, update_domain, custom_headers:nil)
      response = begin_walk_update_domain_async(resource_group_name, cloud_service_name, update_domain, custom_headers:custom_headers).value!
      nil
    end

    #
    # Updates the role instances in the specified update domain.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param update_domain [Integer] Specifies an integer value that identifies the
    # update domain. Update domains are identified with a zero-based index: the
    # first update domain has an ID of 0, the second has an ID of 1, and so on.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_walk_update_domain_with_http_info(resource_group_name, cloud_service_name, update_domain, custom_headers:nil)
      begin_walk_update_domain_async(resource_group_name, cloud_service_name, update_domain, custom_headers:custom_headers).value!
    end

    #
    # Updates the role instances in the specified update domain.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param update_domain [Integer] Specifies an integer value that identifies the
    # update domain. Update domains are identified with a zero-based index: the
    # first update domain has an ID of 0, the second has an ID of 1, and so on.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_walk_update_domain_async(resource_group_name, cloud_service_name, update_domain, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, 'update_domain is nil' if update_domain.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?

      parameters = nil

      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::UpdateDomain.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/updateDomains/{updateDomain}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'updateDomain' => update_domain,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets a list of all update domains in a cloud service.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [UpdateDomainListResult] operation results.
    #
    def list_update_domains_next(next_page_link, custom_headers:nil)
      response = list_update_domains_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a list of all update domains in a cloud service.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_update_domains_next_with_http_info(next_page_link, custom_headers:nil)
      list_update_domains_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of all update domains in a cloud service.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_update_domains_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::UpdateDomainListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all update domains in a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [UpdateDomainListResult] which provide lazy access to pages of the
    # response.
    #
    def list_update_domains_as_lazy(resource_group_name, cloud_service_name, custom_headers:nil)
      response = list_update_domains_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_update_domains_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
