# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2018_04_01
  module Models
    #
    # Specifies information about the proximity placement group.
    #
    class ProximityPlacementGroup < Resource

      include MsRestAzure

      # @return [ProximityPlacementGroupType] Specifies the type of the
      # proximity placement group. <br><br> Possible values are: <br><br>
      # **Standard** <br><br> **Ultra**. Possible values include: 'Standard',
      # 'Ultra'
      attr_accessor :proximity_placement_group_type

      # @return [Array<SubResource>] A list of references to all virtual
      # machines in the proximity placement group.
      attr_accessor :virtual_machines

      # @return [Array<SubResource>] A list of references to all virtual
      # machine scale sets in the proximity placement group.
      attr_accessor :virtual_machine_scale_sets

      # @return [Array<SubResource>] A list of references to all availability
      # sets in the proximity placement group.
      attr_accessor :availability_sets


      #
      # Mapper for ProximityPlacementGroup class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'ProximityPlacementGroup',
          type: {
            name: 'Composite',
            class_name: 'ProximityPlacementGroup',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                client_side_validation: true,
                required: true,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                client_side_validation: true,
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              proximity_placement_group_type: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.proximityPlacementGroupType',
                type: {
                  name: 'String'
                }
              },
              virtual_machines: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.virtualMachines',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'SubResourceElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SubResource'
                      }
                  }
                }
              },
              virtual_machine_scale_sets: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.virtualMachineScaleSets',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'SubResourceElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SubResource'
                      }
                  }
                }
              },
              availability_sets: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.availabilitySets',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'SubResourceElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SubResource'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
