# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::GraphRbac::V1_6
  module Models
    #
    # Request parameters for creating a new application.
    #
    class ApplicationCreateParameters

      include MsRestAzure

      # @return Unmatched properties from the message are deserialized this
      # collection
      attr_accessor :additional_properties

      # @return [Boolean] Whether the application is available to other
      # tenants.
      attr_accessor :available_to_other_tenants

      # @return [String] The display name of the application.
      attr_accessor :display_name

      # @return [String] The home page of the application.
      attr_accessor :homepage

      # @return [Array<String>] A collection of URIs for the application.
      attr_accessor :identifier_uris

      # @return [Array<String>] A collection of reply URLs for the application.
      attr_accessor :reply_urls

      # @return [Array<KeyCredential>] The list of KeyCredential objects.
      attr_accessor :key_credentials

      # @return [Array<PasswordCredential>] The list of PasswordCredential
      # objects.
      attr_accessor :password_credentials

      # @return [Boolean] Whether to allow implicit grant flow for OAuth2
      attr_accessor :oauth2allow_implicit_flow

      # @return [Array<RequiredResourceAccess>] Specifies resources that this
      # application requires access to and the set of OAuth permission scopes
      # and application roles that it needs under each of those resources. This
      # pre-configuration of required resource access drives the consent
      # experience.
      attr_accessor :required_resource_access


      #
      # Mapper for ApplicationCreateParameters class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'ApplicationCreateParameters',
          type: {
            name: 'Composite',
            class_name: 'ApplicationCreateParameters',
            model_properties: {
              additional_properties: {
                client_side_validation: true,
                required: false,
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'ObjectElementType',
                      type: {
                        name: 'Object'
                      }
                  }
                }
              },
              available_to_other_tenants: {
                client_side_validation: true,
                required: true,
                serialized_name: 'availableToOtherTenants',
                type: {
                  name: 'Boolean'
                }
              },
              display_name: {
                client_side_validation: true,
                required: true,
                serialized_name: 'displayName',
                type: {
                  name: 'String'
                }
              },
              homepage: {
                client_side_validation: true,
                required: false,
                serialized_name: 'homepage',
                type: {
                  name: 'String'
                }
              },
              identifier_uris: {
                client_side_validation: true,
                required: true,
                serialized_name: 'identifierUris',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              reply_urls: {
                client_side_validation: true,
                required: false,
                serialized_name: 'replyUrls',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              key_credentials: {
                client_side_validation: true,
                required: false,
                serialized_name: 'keyCredentials',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'KeyCredentialElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'KeyCredential'
                      }
                  }
                }
              },
              password_credentials: {
                client_side_validation: true,
                required: false,
                serialized_name: 'passwordCredentials',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'PasswordCredentialElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'PasswordCredential'
                      }
                  }
                }
              },
              oauth2allow_implicit_flow: {
                client_side_validation: true,
                required: false,
                serialized_name: 'oauth2AllowImplicitFlow',
                type: {
                  name: 'Boolean'
                }
              },
              required_resource_access: {
                client_side_validation: true,
                required: false,
                serialized_name: 'requiredResourceAccess',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'RequiredResourceAccessElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'RequiredResourceAccess'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
