# frozen_string_literal: true

# WARNING ABOUT GENERATED CODE
#
# This file is generated. See the contributing guide for more information:
# https://github.com/aws/aws-sdk-ruby/blob/version-3/CONTRIBUTING.md
#
# WARNING ABOUT GENERATED CODE

require 'seahorse/client/plugins/content_length'
require 'aws-sdk-core/plugins/credentials_configuration'
require 'aws-sdk-core/plugins/logging'
require 'aws-sdk-core/plugins/param_converter'
require 'aws-sdk-core/plugins/param_validator'
require 'aws-sdk-core/plugins/user_agent'
require 'aws-sdk-core/plugins/helpful_socket_errors'
require 'aws-sdk-core/plugins/retry_errors'
require 'aws-sdk-core/plugins/global_configuration'
require 'aws-sdk-core/plugins/regional_endpoint'
require 'aws-sdk-core/plugins/endpoint_discovery'
require 'aws-sdk-core/plugins/endpoint_pattern'
require 'aws-sdk-core/plugins/response_paging'
require 'aws-sdk-core/plugins/stub_responses'
require 'aws-sdk-core/plugins/idempotency_token'
require 'aws-sdk-core/plugins/invocation_id'
require 'aws-sdk-core/plugins/jsonvalue_converter'
require 'aws-sdk-core/plugins/client_metrics_plugin'
require 'aws-sdk-core/plugins/client_metrics_send_plugin'
require 'aws-sdk-core/plugins/transfer_encoding'
require 'aws-sdk-core/plugins/http_checksum'
require 'aws-sdk-core/plugins/checksum_algorithm'
require 'aws-sdk-core/plugins/request_compression'
require 'aws-sdk-core/plugins/defaults_mode'
require 'aws-sdk-core/plugins/recursion_detection'
require 'aws-sdk-core/plugins/telemetry'
require 'aws-sdk-core/plugins/sign'
require 'aws-sdk-core/plugins/protocols/query'
require 'aws-sdk-rds/plugins/cross_region_copying'

module Aws::RDS
  # An API client for RDS.  To construct a client, you need to configure a `:region` and `:credentials`.
  #
  #     client = Aws::RDS::Client.new(
  #       region: region_name,
  #       credentials: credentials,
  #       # ...
  #     )
  #
  # For details on configuring region and credentials see
  # the [developer guide](/sdk-for-ruby/v3/developer-guide/setup-config.html).
  #
  # See {#initialize} for a full list of supported configuration options.
  class Client < Seahorse::Client::Base

    include Aws::ClientStubs

    @identifier = :rds

    set_api(ClientApi::API)

    add_plugin(Seahorse::Client::Plugins::ContentLength)
    add_plugin(Aws::Plugins::CredentialsConfiguration)
    add_plugin(Aws::Plugins::Logging)
    add_plugin(Aws::Plugins::ParamConverter)
    add_plugin(Aws::Plugins::ParamValidator)
    add_plugin(Aws::Plugins::UserAgent)
    add_plugin(Aws::Plugins::HelpfulSocketErrors)
    add_plugin(Aws::Plugins::RetryErrors)
    add_plugin(Aws::Plugins::GlobalConfiguration)
    add_plugin(Aws::Plugins::RegionalEndpoint)
    add_plugin(Aws::Plugins::EndpointDiscovery)
    add_plugin(Aws::Plugins::EndpointPattern)
    add_plugin(Aws::Plugins::ResponsePaging)
    add_plugin(Aws::Plugins::StubResponses)
    add_plugin(Aws::Plugins::IdempotencyToken)
    add_plugin(Aws::Plugins::InvocationId)
    add_plugin(Aws::Plugins::JsonvalueConverter)
    add_plugin(Aws::Plugins::ClientMetricsPlugin)
    add_plugin(Aws::Plugins::ClientMetricsSendPlugin)
    add_plugin(Aws::Plugins::TransferEncoding)
    add_plugin(Aws::Plugins::HttpChecksum)
    add_plugin(Aws::Plugins::ChecksumAlgorithm)
    add_plugin(Aws::Plugins::RequestCompression)
    add_plugin(Aws::Plugins::DefaultsMode)
    add_plugin(Aws::Plugins::RecursionDetection)
    add_plugin(Aws::Plugins::Telemetry)
    add_plugin(Aws::Plugins::Sign)
    add_plugin(Aws::Plugins::Protocols::Query)
    add_plugin(Aws::RDS::Plugins::CrossRegionCopying)
    add_plugin(Aws::RDS::Plugins::Endpoints)

    # @overload initialize(options)
    #   @param [Hash] options
    #
    #   @option options [Array<Seahorse::Client::Plugin>] :plugins ([]])
    #     A list of plugins to apply to the client. Each plugin is either a
    #     class name or an instance of a plugin class.
    #
    #   @option options [required, Aws::CredentialProvider] :credentials
    #     Your AWS credentials used for authentication. This can be any class that includes and implements
    #     `Aws::CredentialProvider`, or instance of any one of the following classes:
    #
    #     * `Aws::Credentials` - Used for configuring static, non-refreshing
    #       credentials.
    #
    #     * `Aws::SharedCredentials` - Used for loading static credentials from a
    #       shared file, such as `~/.aws/config`.
    #
    #     * `Aws::AssumeRoleCredentials` - Used when you need to assume a role.
    #
    #     * `Aws::AssumeRoleWebIdentityCredentials` - Used when you need to
    #       assume a role after providing credentials via the web.
    #
    #     * `Aws::SSOCredentials` - Used for loading credentials from AWS SSO using an
    #       access token generated from `aws login`.
    #
    #     * `Aws::ProcessCredentials` - Used for loading credentials from a
    #       process that outputs to stdout.
    #
    #     * `Aws::InstanceProfileCredentials` - Used for loading credentials
    #       from an EC2 IMDS on an EC2 instance.
    #
    #     * `Aws::ECSCredentials` - Used for loading credentials from
    #       instances running in ECS.
    #
    #     * `Aws::CognitoIdentityCredentials` - Used for loading credentials
    #       from the Cognito Identity service.
    #
    #     When `:credentials` are not configured directly, the following locations will be searched for credentials:
    #
    #     * `Aws.config[:credentials]`
    #
    #     * The `:access_key_id`, `:secret_access_key`, `:session_token`, and
    #       `:account_id` options.
    #
    #     * `ENV['AWS_ACCESS_KEY_ID']`, `ENV['AWS_SECRET_ACCESS_KEY']`,
    #       `ENV['AWS_SESSION_TOKEN']`, and `ENV['AWS_ACCOUNT_ID']`.
    #
    #     * `~/.aws/credentials`
    #
    #     * `~/.aws/config`
    #
    #     * EC2/ECS IMDS instance profile - When used by default, the timeouts are very aggressive.
    #       Construct and pass an instance of `Aws::InstanceProfileCredentials` or `Aws::ECSCredentials` to
    #       enable retries and extended timeouts. Instance profile credential fetching can be disabled by
    #       setting `ENV['AWS_EC2_METADATA_DISABLED']` to `true`.
    #
    #   @option options [required, String] :region
    #     The AWS region to connect to.  The configured `:region` is
    #     used to determine the service `:endpoint`. When not passed,
    #     a default `:region` is searched for in the following locations:
    #
    #     * `Aws.config[:region]`
    #     * `ENV['AWS_REGION']`
    #     * `ENV['AMAZON_REGION']`
    #     * `ENV['AWS_DEFAULT_REGION']`
    #     * `~/.aws/credentials`
    #     * `~/.aws/config`
    #
    #   @option options [String] :access_key_id
    #
    #   @option options [String] :account_id
    #
    #   @option options [Boolean] :active_endpoint_cache (false)
    #     When set to `true`, a thread polling for endpoints will be running in
    #     the background every 60 secs (default). Defaults to `false`.
    #
    #   @option options [Boolean] :adaptive_retry_wait_to_fill (true)
    #     Used only in `adaptive` retry mode.  When true, the request will sleep
    #     until there is sufficent client side capacity to retry the request.
    #     When false, the request will raise a `RetryCapacityNotAvailableError` and will
    #     not retry instead of sleeping.
    #
    #   @option options [Array<String>] :auth_scheme_preference
    #     A list of preferred authentication schemes to use when making a request. Supported values are:
    #     `sigv4`, `sigv4a`, `httpBearerAuth`, and `noAuth`. When set using `ENV['AWS_AUTH_SCHEME_PREFERENCE']` or in
    #     shared config as `auth_scheme_preference`, the value should be a comma-separated list.
    #
    #   @option options [Boolean] :client_side_monitoring (false)
    #     When `true`, client-side metrics will be collected for all API requests from
    #     this client.
    #
    #   @option options [String] :client_side_monitoring_client_id ("")
    #     Allows you to provide an identifier for this client which will be attached to
    #     all generated client side metrics. Defaults to an empty string.
    #
    #   @option options [String] :client_side_monitoring_host ("127.0.0.1")
    #     Allows you to specify the DNS hostname or IPv4 or IPv6 address that the client
    #     side monitoring agent is running on, where client metrics will be published via UDP.
    #
    #   @option options [Integer] :client_side_monitoring_port (31000)
    #     Required for publishing client metrics. The port that the client side monitoring
    #     agent is running on, where client metrics will be published via UDP.
    #
    #   @option options [Aws::ClientSideMonitoring::Publisher] :client_side_monitoring_publisher (Aws::ClientSideMonitoring::Publisher)
    #     Allows you to provide a custom client-side monitoring publisher class. By default,
    #     will use the Client Side Monitoring Agent Publisher.
    #
    #   @option options [Boolean] :convert_params (true)
    #     When `true`, an attempt is made to coerce request parameters into
    #     the required types.
    #
    #   @option options [Boolean] :correct_clock_skew (true)
    #     Used only in `standard` and adaptive retry modes. Specifies whether to apply
    #     a clock skew correction and retry requests with skewed client clocks.
    #
    #   @option options [String] :defaults_mode ("legacy")
    #     See {Aws::DefaultsModeConfiguration} for a list of the
    #     accepted modes and the configuration defaults that are included.
    #
    #   @option options [Boolean] :disable_host_prefix_injection (false)
    #     When `true`, the SDK will not prepend the modeled host prefix to the endpoint.
    #
    #   @option options [Boolean] :disable_request_compression (false)
    #     When set to 'true' the request body will not be compressed
    #     for supported operations.
    #
    #   @option options [String, URI::HTTPS, URI::HTTP] :endpoint
    #     Normally you should not configure the `:endpoint` option
    #     directly. This is normally constructed from the `:region`
    #     option. Configuring `:endpoint` is normally reserved for
    #     connecting to test or custom endpoints. The endpoint should
    #     be a URI formatted like:
    #
    #         'http://example.com'
    #         'https://example.com'
    #         'http://example.com:123'
    #
    #   @option options [Integer] :endpoint_cache_max_entries (1000)
    #     Used for the maximum size limit of the LRU cache storing endpoints data
    #     for endpoint discovery enabled operations. Defaults to 1000.
    #
    #   @option options [Integer] :endpoint_cache_max_threads (10)
    #     Used for the maximum threads in use for polling endpoints to be cached, defaults to 10.
    #
    #   @option options [Integer] :endpoint_cache_poll_interval (60)
    #     When :endpoint_discovery and :active_endpoint_cache is enabled,
    #     Use this option to config the time interval in seconds for making
    #     requests fetching endpoints information. Defaults to 60 sec.
    #
    #   @option options [Boolean] :endpoint_discovery (false)
    #     When set to `true`, endpoint discovery will be enabled for operations when available.
    #
    #   @option options [Boolean] :ignore_configured_endpoint_urls
    #     Setting to true disables use of endpoint URLs provided via environment
    #     variables and the shared configuration file.
    #
    #   @option options [Aws::Log::Formatter] :log_formatter (Aws::Log::Formatter.default)
    #     The log formatter.
    #
    #   @option options [Symbol] :log_level (:info)
    #     The log level to send messages to the `:logger` at.
    #
    #   @option options [Logger] :logger
    #     The Logger instance to send log messages to.  If this option
    #     is not set, logging will be disabled.
    #
    #   @option options [Integer] :max_attempts (3)
    #     An integer representing the maximum number attempts that will be made for
    #     a single request, including the initial attempt.  For example,
    #     setting this value to 5 will result in a request being retried up to
    #     4 times. Used in `standard` and `adaptive` retry modes.
    #
    #   @option options [String] :profile ("default")
    #     Used when loading credentials from the shared credentials file at `HOME/.aws/credentials`.
    #     When not specified, 'default' is used.
    #
    #   @option options [String] :request_checksum_calculation ("when_supported")
    #     Determines when a checksum will be calculated for request payloads. Values are:
    #
    #     * `when_supported` - (default) When set, a checksum will be
    #       calculated for all request payloads of operations modeled with the
    #       `httpChecksum` trait where `requestChecksumRequired` is `true` and/or a
    #       `requestAlgorithmMember` is modeled.
    #     * `when_required` - When set, a checksum will only be calculated for
    #       request payloads of operations modeled with the  `httpChecksum` trait where
    #       `requestChecksumRequired` is `true` or where a `requestAlgorithmMember`
    #       is modeled and supplied.
    #
    #   @option options [Integer] :request_min_compression_size_bytes (10240)
    #     The minimum size in bytes that triggers compression for request
    #     bodies. The value must be non-negative integer value between 0
    #     and 10485780 bytes inclusive.
    #
    #   @option options [String] :response_checksum_validation ("when_supported")
    #     Determines when checksum validation will be performed on response payloads. Values are:
    #
    #     * `when_supported` - (default) When set, checksum validation is performed on all
    #       response payloads of operations modeled with the `httpChecksum` trait where
    #       `responseAlgorithms` is modeled, except when no modeled checksum algorithms
    #       are supported.
    #     * `when_required` - When set, checksum validation is not performed on
    #       response payloads of operations unless the checksum algorithm is supported and
    #       the `requestValidationModeMember` member is set to `ENABLED`.
    #
    #   @option options [Proc] :retry_backoff
    #     A proc or lambda used for backoff. Defaults to 2**retries * retry_base_delay.
    #     This option is only used in the `legacy` retry mode.
    #
    #   @option options [Float] :retry_base_delay (0.3)
    #     The base delay in seconds used by the default backoff function. This option
    #     is only used in the `legacy` retry mode.
    #
    #   @option options [Symbol] :retry_jitter (:none)
    #     A delay randomiser function used by the default backoff function.
    #     Some predefined functions can be referenced by name - :none, :equal, :full,
    #     otherwise a Proc that takes and returns a number. This option is only used
    #     in the `legacy` retry mode.
    #
    #     @see https://www.awsarchitectureblog.com/2015/03/backoff.html
    #
    #   @option options [Integer] :retry_limit (3)
    #     The maximum number of times to retry failed requests.  Only
    #     ~ 500 level server errors and certain ~ 400 level client errors
    #     are retried.  Generally, these are throttling errors, data
    #     checksum errors, networking errors, timeout errors, auth errors,
    #     endpoint discovery, and errors from expired credentials.
    #     This option is only used in the `legacy` retry mode.
    #
    #   @option options [Integer] :retry_max_delay (0)
    #     The maximum number of seconds to delay between retries (0 for no limit)
    #     used by the default backoff function. This option is only used in the
    #     `legacy` retry mode.
    #
    #   @option options [String] :retry_mode ("legacy")
    #     Specifies which retry algorithm to use. Values are:
    #
    #     * `legacy` - The pre-existing retry behavior.  This is default value if
    #       no retry mode is provided.
    #
    #     * `standard` - A standardized set of retry rules across the AWS SDKs.
    #       This includes support for retry quotas, which limit the number of
    #       unsuccessful retries a client can make.
    #
    #     * `adaptive` - An experimental retry mode that includes all the
    #       functionality of `standard` mode along with automatic client side
    #       throttling.  This is a provisional mode that may change behavior
    #       in the future.
    #
    #   @option options [String] :sdk_ua_app_id
    #     A unique and opaque application ID that is appended to the
    #     User-Agent header as app/sdk_ua_app_id. It should have a
    #     maximum length of 50. This variable is sourced from environment
    #     variable AWS_SDK_UA_APP_ID or the shared config profile attribute sdk_ua_app_id.
    #
    #   @option options [String] :secret_access_key
    #
    #   @option options [String] :session_token
    #
    #   @option options [Array] :sigv4a_signing_region_set
    #     A list of regions that should be signed with SigV4a signing. When
    #     not passed, a default `:sigv4a_signing_region_set` is searched for
    #     in the following locations:
    #
    #     * `Aws.config[:sigv4a_signing_region_set]`
    #     * `ENV['AWS_SIGV4A_SIGNING_REGION_SET']`
    #     * `~/.aws/config`
    #
    #   @option options [Boolean] :stub_responses (false)
    #     Causes the client to return stubbed responses. By default
    #     fake responses are generated and returned. You can specify
    #     the response data to return or errors to raise by calling
    #     {ClientStubs#stub_responses}. See {ClientStubs} for more information.
    #
    #     ** Please note ** When response stubbing is enabled, no HTTP
    #     requests are made, and retries are disabled.
    #
    #   @option options [Aws::Telemetry::TelemetryProviderBase] :telemetry_provider (Aws::Telemetry::NoOpTelemetryProvider)
    #     Allows you to provide a telemetry provider, which is used to
    #     emit telemetry data. By default, uses `NoOpTelemetryProvider` which
    #     will not record or emit any telemetry data. The SDK supports the
    #     following telemetry providers:
    #
    #     * OpenTelemetry (OTel) - To use the OTel provider, install and require the
    #     `opentelemetry-sdk` gem and then, pass in an instance of a
    #     `Aws::Telemetry::OTelProvider` for telemetry provider.
    #
    #   @option options [Aws::TokenProvider] :token_provider
    #     Your Bearer token used for authentication. This can be any class that includes and implements
    #     `Aws::TokenProvider`, or instance of any one of the following classes:
    #
    #     * `Aws::StaticTokenProvider` - Used for configuring static, non-refreshing
    #       tokens.
    #
    #     * `Aws::SSOTokenProvider` - Used for loading tokens from AWS SSO using an
    #       access token generated from `aws login`.
    #
    #     When `:token_provider` is not configured directly, the `Aws::TokenProviderChain`
    #     will be used to search for tokens configured for your profile in shared configuration files.
    #
    #   @option options [Boolean] :use_dualstack_endpoint
    #     When set to `true`, dualstack enabled endpoints (with `.aws` TLD)
    #     will be used if available.
    #
    #   @option options [Boolean] :use_fips_endpoint
    #     When set to `true`, fips compatible endpoints will be used if available.
    #     When a `fips` region is used, the region is normalized and this config
    #     is set to `true`.
    #
    #   @option options [Boolean] :validate_params (true)
    #     When `true`, request parameters are validated before
    #     sending the request.
    #
    #   @option options [Aws::RDS::EndpointProvider] :endpoint_provider
    #     The endpoint provider used to resolve endpoints. Any object that responds to
    #     `#resolve_endpoint(parameters)` where `parameters` is a Struct similar to
    #     `Aws::RDS::EndpointParameters`.
    #
    #   @option options [Float] :http_continue_timeout (1)
    #     The number of seconds to wait for a 100-continue response before sending the
    #     request body.  This option has no effect unless the request has "Expect"
    #     header set to "100-continue".  Defaults to `nil` which  disables this
    #     behaviour.  This value can safely be set per request on the session.
    #
    #   @option options [Float] :http_idle_timeout (5)
    #     The number of seconds a connection is allowed to sit idle before it
    #     is considered stale.  Stale connections are closed and removed from the
    #     pool before making a request.
    #
    #   @option options [Float] :http_open_timeout (15)
    #     The default number of seconds to wait for response data.
    #     This value can safely be set per-request on the session.
    #
    #   @option options [URI::HTTP,String] :http_proxy
    #     A proxy to send requests through.  Formatted like 'http://proxy.com:123'.
    #
    #   @option options [Float] :http_read_timeout (60)
    #     The default number of seconds to wait for response data.
    #     This value can safely be set per-request on the session.
    #
    #   @option options [Boolean] :http_wire_trace (false)
    #     When `true`,  HTTP debug output will be sent to the `:logger`.
    #
    #   @option options [Proc] :on_chunk_received
    #     When a Proc object is provided, it will be used as callback when each chunk
    #     of the response body is received. It provides three arguments: the chunk,
    #     the number of bytes received, and the total number of
    #     bytes in the response (or nil if the server did not send a `content-length`).
    #
    #   @option options [Proc] :on_chunk_sent
    #     When a Proc object is provided, it will be used as callback when each chunk
    #     of the request body is sent. It provides three arguments: the chunk,
    #     the number of bytes read from the body, and the total number of
    #     bytes in the body.
    #
    #   @option options [Boolean] :raise_response_errors (true)
    #     When `true`, response errors are raised.
    #
    #   @option options [String] :ssl_ca_bundle
    #     Full path to the SSL certificate authority bundle file that should be used when
    #     verifying peer certificates.  If you do not pass `:ssl_ca_bundle` or
    #     `:ssl_ca_directory` the the system default will be used if available.
    #
    #   @option options [String] :ssl_ca_directory
    #     Full path of the directory that contains the unbundled SSL certificate
    #     authority files for verifying peer certificates.  If you do
    #     not pass `:ssl_ca_bundle` or `:ssl_ca_directory` the the system
    #     default will be used if available.
    #
    #   @option options [String] :ssl_ca_store
    #     Sets the X509::Store to verify peer certificate.
    #
    #   @option options [OpenSSL::X509::Certificate] :ssl_cert
    #     Sets a client certificate when creating http connections.
    #
    #   @option options [OpenSSL::PKey] :ssl_key
    #     Sets a client key when creating http connections.
    #
    #   @option options [Float] :ssl_timeout
    #     Sets the SSL timeout in seconds
    #
    #   @option options [Boolean] :ssl_verify_peer (true)
    #     When `true`, SSL peer certificates are verified when establishing a connection.
    #
    def initialize(*args)
      super
    end

    # @!group API Operations

    # Associates an Identity and Access Management (IAM) role with a DB
    # cluster.
    #
    # @option params [required, String] :db_cluster_identifier
    #   The name of the DB cluster to associate the IAM role with.
    #
    # @option params [required, String] :role_arn
    #   The Amazon Resource Name (ARN) of the IAM role to associate with the
    #   Aurora DB cluster, for example
    #   `arn:aws:iam::123456789012:role/AuroraAccessRole`.
    #
    # @option params [String] :feature_name
    #   The name of the feature for the DB cluster that the IAM role is to be
    #   associated with. For information about supported feature names, see
    #   DBEngineVersion.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To associate an AWS Identity and Access Management (IAM) role with a DB cluster
    #
    #   # The following example associates a role with a DB cluster.
    #
    #   resp = client.add_role_to_db_cluster({
    #     db_cluster_identifier: "mydbcluster", 
    #     role_arn: "arn:aws:iam::123456789012:role/RDSLoadFromS3", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.add_role_to_db_cluster({
    #     db_cluster_identifier: "String", # required
    #     role_arn: "String", # required
    #     feature_name: "String",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBCluster AWS API Documentation
    #
    # @overload add_role_to_db_cluster(params = {})
    # @param [Hash] params ({})
    def add_role_to_db_cluster(params = {}, options = {})
      req = build_request(:add_role_to_db_cluster, params)
      req.send_request(options)
    end

    # Associates an Amazon Web Services Identity and Access Management (IAM)
    # role with a DB instance.
    #
    # <note markdown="1"> To add a role to a DB instance, the status of the DB instance must be
    # `available`.
    #
    #  </note>
    #
    # This command doesn't apply to RDS Custom.
    #
    # @option params [required, String] :db_instance_identifier
    #   The name of the DB instance to associate the IAM role with.
    #
    # @option params [required, String] :role_arn
    #   The Amazon Resource Name (ARN) of the IAM role to associate with the
    #   DB instance, for example `arn:aws:iam::123456789012:role/AccessRole`.
    #
    # @option params [required, String] :feature_name
    #   The name of the feature for the DB instance that the IAM role is to be
    #   associated with. For information about supported feature names, see
    #   DBEngineVersion.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To associate an AWS Identity and Access Management (IAM) role with a DB instance
    #
    #   # The following example adds the role to a DB instance named test-instance.
    #
    #   resp = client.add_role_to_db_instance({
    #     db_instance_identifier: "test-instance", 
    #     feature_name: "S3_INTEGRATION", 
    #     role_arn: "arn:aws:iam::111122223333:role/rds-s3-integration-role", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.add_role_to_db_instance({
    #     db_instance_identifier: "String", # required
    #     role_arn: "String", # required
    #     feature_name: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBInstance AWS API Documentation
    #
    # @overload add_role_to_db_instance(params = {})
    # @param [Hash] params ({})
    def add_role_to_db_instance(params = {}, options = {})
      req = build_request(:add_role_to_db_instance, params)
      req.send_request(options)
    end

    # Adds a source identifier to an existing RDS event notification
    # subscription.
    #
    # @option params [required, String] :subscription_name
    #   The name of the RDS event notification subscription you want to add a
    #   source identifier to.
    #
    # @option params [required, String] :source_identifier
    #   The identifier of the event source to be added.
    #
    #   Constraints:
    #
    #   * If the source type is a DB instance, a `DBInstanceIdentifier` value
    #     must be supplied.
    #
    #   * If the source type is a DB cluster, a `DBClusterIdentifier` value
    #     must be supplied.
    #
    #   * If the source type is a DB parameter group, a `DBParameterGroupName`
    #     value must be supplied.
    #
    #   * If the source type is a DB security group, a `DBSecurityGroupName`
    #     value must be supplied.
    #
    #   * If the source type is a DB snapshot, a `DBSnapshotIdentifier` value
    #     must be supplied.
    #
    #   * If the source type is a DB cluster snapshot, a
    #     `DBClusterSnapshotIdentifier` value must be supplied.
    #
    #   * If the source type is an RDS Proxy, a `DBProxyName` value must be
    #     supplied.
    #
    # @return [Types::AddSourceIdentifierToSubscriptionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AddSourceIdentifierToSubscriptionResult#event_subscription #event_subscription} => Types::EventSubscription
    #
    #
    # @example Example: To add a source identifier to a subscription
    #
    #   # The following example adds another source identifier to an existing subscription.
    #
    #   resp = client.add_source_identifier_to_subscription({
    #     source_identifier: "test-instance-repl", 
    #     subscription_name: "my-instance-events", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     event_subscription: {
    #       cust_subscription_id: "my-instance-events", 
    #       customer_aws_id: "123456789012", 
    #       enabled: false, 
    #       event_categories_list: [
    #         "backup", 
    #         "recovery", 
    #       ], 
    #       event_subscription_arn: "arn:aws:rds:us-east-1:123456789012:es:my-instance-events", 
    #       sns_topic_arn: "arn:aws:sns:us-east-1:123456789012:interesting-events", 
    #       source_ids_list: [
    #         "test-instance", 
    #         "test-instance-repl", 
    #       ], 
    #       source_type: "db-instance", 
    #       status: "modifying", 
    #       subscription_creation_time: "Tue Jul 31 23:22:01 UTC 2018", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.add_source_identifier_to_subscription({
    #     subscription_name: "String", # required
    #     source_identifier: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.event_subscription.customer_aws_id #=> String
    #   resp.event_subscription.cust_subscription_id #=> String
    #   resp.event_subscription.sns_topic_arn #=> String
    #   resp.event_subscription.status #=> String
    #   resp.event_subscription.subscription_creation_time #=> String
    #   resp.event_subscription.source_type #=> String
    #   resp.event_subscription.source_ids_list #=> Array
    #   resp.event_subscription.source_ids_list[0] #=> String
    #   resp.event_subscription.event_categories_list #=> Array
    #   resp.event_subscription.event_categories_list[0] #=> String
    #   resp.event_subscription.enabled #=> Boolean
    #   resp.event_subscription.event_subscription_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscription AWS API Documentation
    #
    # @overload add_source_identifier_to_subscription(params = {})
    # @param [Hash] params ({})
    def add_source_identifier_to_subscription(params = {}, options = {})
      req = build_request(:add_source_identifier_to_subscription, params)
      req.send_request(options)
    end

    # Adds metadata tags to an Amazon RDS resource. These tags can also be
    # used with cost allocation reporting to track cost associated with
    # Amazon RDS resources, or used in a Condition statement in an IAM
    # policy for Amazon RDS.
    #
    # For an overview on tagging your relational database resources, see
    # [Tagging Amazon RDS Resources][1] or [Tagging Amazon Aurora and Amazon
    # RDS Resources][2].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @option params [required, String] :resource_name
    #   The Amazon RDS resource that the tags are added to. This value is an
    #   Amazon Resource Name (ARN). For information about creating an ARN, see
    #   [ Constructing an RDS Amazon Resource Name (ARN)][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing
    #
    # @option params [required, Array<Types::Tag>] :tags
    #   The tags to be assigned to the Amazon RDS resource.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To add tags to a resource
    #
    #   # This example adds a tag to an option group.
    #
    #   resp = client.add_tags_to_resource({
    #     resource_name: "arn:aws:rds:us-east-1:992648334831:og:mymysqloptiongroup", 
    #     tags: [
    #       {
    #         key: "Staging", 
    #         value: "LocationDB", 
    #       }, 
    #     ], 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.add_tags_to_resource({
    #     resource_name: "String", # required
    #     tags: [ # required
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResource AWS API Documentation
    #
    # @overload add_tags_to_resource(params = {})
    # @param [Hash] params ({})
    def add_tags_to_resource(params = {}, options = {})
      req = build_request(:add_tags_to_resource, params)
      req.send_request(options)
    end

    # Applies a pending maintenance action to a resource (for example, to a
    # DB instance).
    #
    # @option params [required, String] :resource_identifier
    #   The RDS Amazon Resource Name (ARN) of the resource that the pending
    #   maintenance action applies to. For information about creating an ARN,
    #   see [ Constructing an RDS Amazon Resource Name (ARN)][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing
    #
    # @option params [required, String] :apply_action
    #   The pending maintenance action to apply to this resource.
    #
    #   Valid Values:
    #
    #   * `ca-certificate-rotation`
    #
    #   * `db-upgrade`
    #
    #   * `hardware-maintenance`
    #
    #   * `os-upgrade`
    #
    #   * `system-update`
    #
    #   For more information about these actions, see [Maintenance actions for
    #   Amazon Aurora][1] or [Maintenance actions for Amazon RDS][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#maintenance-actions-aurora
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#maintenance-actions-rds
    #
    # @option params [required, String] :opt_in_type
    #   A value that specifies the type of opt-in request, or undoes an opt-in
    #   request. An opt-in request of type `immediate` can't be undone.
    #
    #   Valid Values:
    #
    #   * `immediate` - Apply the maintenance action immediately.
    #
    #   * `next-maintenance` - Apply the maintenance action during the next
    #     maintenance window for the resource.
    #
    #   * `undo-opt-in` - Cancel any existing `next-maintenance` opt-in
    #     requests.
    #
    # @return [Types::ApplyPendingMaintenanceActionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ApplyPendingMaintenanceActionResult#resource_pending_maintenance_actions #resource_pending_maintenance_actions} => Types::ResourcePendingMaintenanceActions
    #
    #
    # @example Example: To apply pending maintenance actions
    #
    #   # The following example applies the pending maintenance actions for a DB cluster.
    #
    #   resp = client.apply_pending_maintenance_action({
    #     apply_action: "system-update", 
    #     opt_in_type: "immediate", 
    #     resource_identifier: "arn:aws:rds:us-east-1:123456789012:cluster:my-db-cluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     resource_pending_maintenance_actions: {
    #       pending_maintenance_action_details: [
    #         {
    #           action: "system-update", 
    #           current_apply_date: Time.parse("2021-01-23T01:07:36.100Z"), 
    #           description: "Upgrade to Aurora PostgreSQL 3.3.2", 
    #           opt_in_status: "immediate", 
    #         }, 
    #       ], 
    #       resource_identifier: "arn:aws:rds:us-east-1:123456789012:cluster:my-db-cluster", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.apply_pending_maintenance_action({
    #     resource_identifier: "String", # required
    #     apply_action: "String", # required
    #     opt_in_type: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.resource_pending_maintenance_actions.resource_identifier #=> String
    #   resp.resource_pending_maintenance_actions.pending_maintenance_action_details #=> Array
    #   resp.resource_pending_maintenance_actions.pending_maintenance_action_details[0].action #=> String
    #   resp.resource_pending_maintenance_actions.pending_maintenance_action_details[0].auto_applied_after_date #=> Time
    #   resp.resource_pending_maintenance_actions.pending_maintenance_action_details[0].forced_apply_date #=> Time
    #   resp.resource_pending_maintenance_actions.pending_maintenance_action_details[0].opt_in_status #=> String
    #   resp.resource_pending_maintenance_actions.pending_maintenance_action_details[0].current_apply_date #=> Time
    #   resp.resource_pending_maintenance_actions.pending_maintenance_action_details[0].description #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceAction AWS API Documentation
    #
    # @overload apply_pending_maintenance_action(params = {})
    # @param [Hash] params ({})
    def apply_pending_maintenance_action(params = {}, options = {})
      req = build_request(:apply_pending_maintenance_action, params)
      req.send_request(options)
    end

    # Enables ingress to a DBSecurityGroup using one of two forms of
    # authorization. First, EC2 or VPC security groups can be added to the
    # DBSecurityGroup if the application using the database is running on
    # EC2 or VPC instances. Second, IP ranges are available if the
    # application accessing your database is running on the internet.
    # Required parameters for this API are one of CIDR range,
    # EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either
    # EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).
    #
    # You can't authorize ingress from an EC2 security group in one Amazon
    # Web Services Region to an Amazon RDS DB instance in another. You
    # can't authorize ingress from a VPC security group in one VPC to an
    # Amazon RDS DB instance in another.
    #
    # For an overview of CIDR ranges, go to the [Wikipedia Tutorial][1].
    #
    # <note markdown="1"> EC2-Classic was retired on August 15, 2022. If you haven't migrated
    # from EC2-Classic to a VPC, we recommend that you migrate as soon as
    # possible. For more information, see [Migrate from EC2-Classic to a
    # VPC][2] in the *Amazon EC2 User Guide*, the blog [EC2-Classic
    # Networking is Retiring – Here’s How to Prepare][3], and [Moving a DB
    # instance not in a VPC into a VPC][4] in the *Amazon RDS User Guide*.
    #
    #  </note>
    #
    #
    #
    # [1]: http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html
    # [3]: http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/
    # [4]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html
    #
    # @option params [required, String] :db_security_group_name
    #   The name of the DB security group to add authorization to.
    #
    # @option params [String] :cidrip
    #   The IP range to authorize.
    #
    # @option params [String] :ec2_security_group_name
    #   Name of the EC2 security group to authorize. For VPC DB security
    #   groups, `EC2SecurityGroupId` must be provided. Otherwise,
    #   `EC2SecurityGroupOwnerId` and either `EC2SecurityGroupName` or
    #   `EC2SecurityGroupId` must be provided.
    #
    # @option params [String] :ec2_security_group_id
    #   Id of the EC2 security group to authorize. For VPC DB security groups,
    #   `EC2SecurityGroupId` must be provided. Otherwise,
    #   `EC2SecurityGroupOwnerId` and either `EC2SecurityGroupName` or
    #   `EC2SecurityGroupId` must be provided.
    #
    # @option params [String] :ec2_security_group_owner_id
    #   Amazon Web Services account number of the owner of the EC2 security
    #   group specified in the `EC2SecurityGroupName` parameter. The Amazon
    #   Web Services access key ID isn't an acceptable value. For VPC DB
    #   security groups, `EC2SecurityGroupId` must be provided. Otherwise,
    #   `EC2SecurityGroupOwnerId` and either `EC2SecurityGroupName` or
    #   `EC2SecurityGroupId` must be provided.
    #
    # @return [Types::AuthorizeDBSecurityGroupIngressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AuthorizeDBSecurityGroupIngressResult#db_security_group #db_security_group} => Types::DBSecurityGroup
    #
    #
    # @example Example: To authorize DB security group integress
    #
    #   # This example authorizes access to the specified security group by the specified CIDR block.
    #
    #   resp = client.authorize_db_security_group_ingress({
    #     cidrip: "203.0.113.5/32", 
    #     db_security_group_name: "mydbsecuritygroup", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_security_group: {
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.authorize_db_security_group_ingress({
    #     db_security_group_name: "String", # required
    #     cidrip: "String",
    #     ec2_security_group_name: "String",
    #     ec2_security_group_id: "String",
    #     ec2_security_group_owner_id: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.db_security_group.owner_id #=> String
    #   resp.db_security_group.db_security_group_name #=> String
    #   resp.db_security_group.db_security_group_description #=> String
    #   resp.db_security_group.vpc_id #=> String
    #   resp.db_security_group.ec2_security_groups #=> Array
    #   resp.db_security_group.ec2_security_groups[0].status #=> String
    #   resp.db_security_group.ec2_security_groups[0].ec2_security_group_name #=> String
    #   resp.db_security_group.ec2_security_groups[0].ec2_security_group_id #=> String
    #   resp.db_security_group.ec2_security_groups[0].ec2_security_group_owner_id #=> String
    #   resp.db_security_group.ip_ranges #=> Array
    #   resp.db_security_group.ip_ranges[0].status #=> String
    #   resp.db_security_group.ip_ranges[0].cidrip #=> String
    #   resp.db_security_group.db_security_group_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngress AWS API Documentation
    #
    # @overload authorize_db_security_group_ingress(params = {})
    # @param [Hash] params ({})
    def authorize_db_security_group_ingress(params = {}, options = {})
      req = build_request(:authorize_db_security_group_ingress, params)
      req.send_request(options)
    end

    # Backtracks a DB cluster to a specific time, without creating a new DB
    # cluster.
    #
    # For more information on backtracking, see [ Backtracking an Aurora DB
    # Cluster][1] in the *Amazon Aurora User Guide*.
    #
    # <note markdown="1"> This action applies only to Aurora MySQL DB clusters.
    #
    #  </note>
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html
    #
    # @option params [required, String] :db_cluster_identifier
    #   The DB cluster identifier of the DB cluster to be backtracked. This
    #   parameter is stored as a lowercase string.
    #
    #   Constraints:
    #
    #   * Must contain from 1 to 63 alphanumeric characters or hyphens.
    #
    #   * First character must be a letter.
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens.
    #
    #   Example: `my-cluster1`
    #
    # @option params [required, Time,DateTime,Date,Integer,String] :backtrack_to
    #   The timestamp of the time to backtrack the DB cluster to, specified in
    #   ISO 8601 format. For more information about ISO 8601, see the [ISO8601
    #   Wikipedia page.][1]
    #
    #   <note markdown="1"> If the specified time isn't a consistent time for the DB cluster,
    #   Aurora automatically chooses the nearest possible consistent time for
    #   the DB cluster.
    #
    #    </note>
    #
    #   Constraints:
    #
    #   * Must contain a valid ISO 8601 timestamp.
    #
    #   * Can't contain a timestamp set in the future.
    #
    #   Example: `2017-07-08T18:00Z`
    #
    #
    #
    #   [1]: http://en.wikipedia.org/wiki/ISO_8601
    #
    # @option params [Boolean] :force
    #   Specifies whether to force the DB cluster to backtrack when binary
    #   logging is enabled. Otherwise, an error occurs when binary logging is
    #   enabled.
    #
    # @option params [Boolean] :use_earliest_time_on_point_in_time_unavailable
    #   Specifies whether to backtrack the DB cluster to the earliest possible
    #   backtrack time when *BacktrackTo* is set to a timestamp earlier than
    #   the earliest backtrack time. When this parameter is disabled and
    #   *BacktrackTo* is set to a timestamp earlier than the earliest
    #   backtrack time, an error occurs.
    #
    # @return [Types::DBClusterBacktrack] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBClusterBacktrack#db_cluster_identifier #db_cluster_identifier} => String
    #   * {Types::DBClusterBacktrack#backtrack_identifier #backtrack_identifier} => String
    #   * {Types::DBClusterBacktrack#backtrack_to #backtrack_to} => Time
    #   * {Types::DBClusterBacktrack#backtracked_from #backtracked_from} => Time
    #   * {Types::DBClusterBacktrack#backtrack_request_creation_time #backtrack_request_creation_time} => Time
    #   * {Types::DBClusterBacktrack#status #status} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.backtrack_db_cluster({
    #     db_cluster_identifier: "String", # required
    #     backtrack_to: Time.now, # required
    #     force: false,
    #     use_earliest_time_on_point_in_time_unavailable: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_identifier #=> String
    #   resp.backtrack_identifier #=> String
    #   resp.backtrack_to #=> Time
    #   resp.backtracked_from #=> Time
    #   resp.backtrack_request_creation_time #=> Time
    #   resp.status #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/BacktrackDBCluster AWS API Documentation
    #
    # @overload backtrack_db_cluster(params = {})
    # @param [Hash] params ({})
    def backtrack_db_cluster(params = {}, options = {})
      req = build_request(:backtrack_db_cluster, params)
      req.send_request(options)
    end

    # Cancels an export task in progress that is exporting a snapshot or
    # cluster to Amazon S3. Any data that has already been written to the S3
    # bucket isn't removed.
    #
    # @option params [required, String] :export_task_identifier
    #   The identifier of the snapshot or cluster export task to cancel.
    #
    # @return [Types::ExportTask] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ExportTask#export_task_identifier #export_task_identifier} => String
    #   * {Types::ExportTask#source_arn #source_arn} => String
    #   * {Types::ExportTask#export_only #export_only} => Array&lt;String&gt;
    #   * {Types::ExportTask#snapshot_time #snapshot_time} => Time
    #   * {Types::ExportTask#task_start_time #task_start_time} => Time
    #   * {Types::ExportTask#task_end_time #task_end_time} => Time
    #   * {Types::ExportTask#s3_bucket #s3_bucket} => String
    #   * {Types::ExportTask#s3_prefix #s3_prefix} => String
    #   * {Types::ExportTask#iam_role_arn #iam_role_arn} => String
    #   * {Types::ExportTask#kms_key_id #kms_key_id} => String
    #   * {Types::ExportTask#status #status} => String
    #   * {Types::ExportTask#percent_progress #percent_progress} => Integer
    #   * {Types::ExportTask#total_extracted_data_in_gb #total_extracted_data_in_gb} => Integer
    #   * {Types::ExportTask#failure_cause #failure_cause} => String
    #   * {Types::ExportTask#warning_message #warning_message} => String
    #   * {Types::ExportTask#source_type #source_type} => String
    #
    #
    # @example Example: To cancel a snapshot export to Amazon S3
    #
    #   # The following example cancels an export task in progress that is exporting a snapshot to Amazon S3.
    #
    #   resp = client.cancel_export_task({
    #     export_task_identifier: "my-s3-export-1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     export_task_identifier: "my-s3-export-1", 
    #     iam_role_arn: "arn:aws:iam::123456789012:role/service-role/export-snap-S3-role", 
    #     kms_key_id: "arn:aws:kms:us-east-1:123456789012:key/abcd0000-7bfd-4594-af38-aabbccddeeff", 
    #     percent_progress: 0, 
    #     s3_bucket: "mybucket", 
    #     s3_prefix: "", 
    #     snapshot_time: Time.parse("2019-03-24T20:01:09.815Z"), 
    #     source_arn: "arn:aws:rds:us-east-1:123456789012:snapshot:publisher-final-snapshot", 
    #     status: "CANCELING", 
    #     total_extracted_data_in_gb: 0, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_export_task({
    #     export_task_identifier: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.export_task_identifier #=> String
    #   resp.source_arn #=> String
    #   resp.export_only #=> Array
    #   resp.export_only[0] #=> String
    #   resp.snapshot_time #=> Time
    #   resp.task_start_time #=> Time
    #   resp.task_end_time #=> Time
    #   resp.s3_bucket #=> String
    #   resp.s3_prefix #=> String
    #   resp.iam_role_arn #=> String
    #   resp.kms_key_id #=> String
    #   resp.status #=> String
    #   resp.percent_progress #=> Integer
    #   resp.total_extracted_data_in_gb #=> Integer
    #   resp.failure_cause #=> String
    #   resp.warning_message #=> String
    #   resp.source_type #=> String, one of "SNAPSHOT", "CLUSTER"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CancelExportTask AWS API Documentation
    #
    # @overload cancel_export_task(params = {})
    # @param [Hash] params ({})
    def cancel_export_task(params = {}, options = {})
      req = build_request(:cancel_export_task, params)
      req.send_request(options)
    end

    # Copies the specified DB cluster parameter group.
    #
    # <note markdown="1"> You can't copy a default DB cluster parameter group. Instead, create
    # a new custom DB cluster parameter group, which copies the default
    # parameters and values for the specified DB cluster parameter group
    # family.
    #
    #  </note>
    #
    # @option params [required, String] :source_db_cluster_parameter_group_identifier
    #   The identifier or Amazon Resource Name (ARN) for the source DB cluster
    #   parameter group. For information about creating an ARN, see [
    #   Constructing an ARN for Amazon RDS][1] in the *Amazon Aurora User
    #   Guide*.
    #
    #   Constraints:
    #
    #   * Must specify a valid DB cluster parameter group.
    #
    #   ^
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing
    #
    # @option params [required, String] :target_db_cluster_parameter_group_identifier
    #   The identifier for the copied DB cluster parameter group.
    #
    #   Constraints:
    #
    #   * Can't be null, empty, or blank
    #
    #   * Must contain from 1 to 255 letters, numbers, or hyphens
    #
    #   * First character must be a letter
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens
    #
    #   Example: `my-cluster-param-group1`
    #
    # @option params [required, String] :target_db_cluster_parameter_group_description
    #   A description for the copied DB cluster parameter group.
    #
    # @option params [Array<Types::Tag>] :tags
    #   A list of tags.
    #
    #   For more information, see [Tagging Amazon RDS resources][1] in the
    #   *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS
    #   resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @return [Types::CopyDBClusterParameterGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopyDBClusterParameterGroupResult#db_cluster_parameter_group #db_cluster_parameter_group} => Types::DBClusterParameterGroup
    #
    #
    # @example Example: To copy a DB cluster parameter group
    #
    #   # This example copies a DB cluster parameter group.
    #
    #   resp = client.copy_db_cluster_parameter_group({
    #     source_db_cluster_parameter_group_identifier: "mydbclusterparametergroup", 
    #     target_db_cluster_parameter_group_description: "My DB cluster parameter group copy", 
    #     target_db_cluster_parameter_group_identifier: "mydbclusterparametergroup-copy", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster_parameter_group: {
    #       db_cluster_parameter_group_arn: "arn:aws:rds:us-east-1:123456789012:cluster-pg:mydbclusterparametergroup-copy", 
    #       db_cluster_parameter_group_name: "mydbclusterparametergroup-copy", 
    #       db_parameter_group_family: "aurora-mysql5.7", 
    #       description: "My DB cluster parameter group copy", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_db_cluster_parameter_group({
    #     source_db_cluster_parameter_group_identifier: "String", # required
    #     target_db_cluster_parameter_group_identifier: "String", # required
    #     target_db_cluster_parameter_group_description: "String", # required
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_parameter_group.db_cluster_parameter_group_name #=> String
    #   resp.db_cluster_parameter_group.db_parameter_group_family #=> String
    #   resp.db_cluster_parameter_group.description #=> String
    #   resp.db_cluster_parameter_group.db_cluster_parameter_group_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroup AWS API Documentation
    #
    # @overload copy_db_cluster_parameter_group(params = {})
    # @param [Hash] params ({})
    def copy_db_cluster_parameter_group(params = {}, options = {})
      req = build_request(:copy_db_cluster_parameter_group, params)
      req.send_request(options)
    end

    # Copies a snapshot of a DB cluster.
    #
    # To copy a DB cluster snapshot from a shared manual DB cluster
    # snapshot, `SourceDBClusterSnapshotIdentifier` must be the Amazon
    # Resource Name (ARN) of the shared DB cluster snapshot.
    #
    # You can copy an encrypted DB cluster snapshot from another Amazon Web
    # Services Region. In that case, the Amazon Web Services Region where
    # you call the `CopyDBClusterSnapshot` operation is the destination
    # Amazon Web Services Region for the encrypted DB cluster snapshot to be
    # copied to. To copy an encrypted DB cluster snapshot from another
    # Amazon Web Services Region, you must provide the following values:
    #
    # * `KmsKeyId` - The Amazon Web Services Key Management System (Amazon
    #   Web Services KMS) key identifier for the key to use to encrypt the
    #   copy of the DB cluster snapshot in the destination Amazon Web
    #   Services Region.
    #
    # * `TargetDBClusterSnapshotIdentifier` - The identifier for the new
    #   copy of the DB cluster snapshot in the destination Amazon Web
    #   Services Region.
    #
    # * `SourceDBClusterSnapshotIdentifier` - The DB cluster snapshot
    #   identifier for the encrypted DB cluster snapshot to be copied. This
    #   identifier must be in the ARN format for the source Amazon Web
    #   Services Region and is the same value as the
    #   `SourceDBClusterSnapshotIdentifier` in the presigned URL.
    #
    # To cancel the copy operation once it is in progress, delete the target
    # DB cluster snapshot identified by `TargetDBClusterSnapshotIdentifier`
    # while that DB cluster snapshot is in "copying" status.
    #
    # For more information on copying encrypted Amazon Aurora DB cluster
    # snapshots from one Amazon Web Services Region to another, see [
    # Copying a Snapshot][1] in the *Amazon Aurora User Guide*.
    #
    # For more information on Amazon Aurora DB clusters, see [ What is
    # Amazon Aurora?][2] in the *Amazon Aurora User Guide*.
    #
    # For more information on Multi-AZ DB clusters, see [ Multi-AZ DB
    # cluster deployments][3] in the *Amazon RDS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [3]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [required, String] :source_db_cluster_snapshot_identifier
    #   The identifier of the DB cluster snapshot to copy. This parameter
    #   isn't case-sensitive.
    #
    #   You can't copy an encrypted, shared DB cluster snapshot from one
    #   Amazon Web Services Region to another.
    #
    #   Constraints:
    #
    #   * Must specify a valid system snapshot in the "available" state.
    #
    #   * If the source snapshot is in the same Amazon Web Services Region as
    #     the copy, specify a valid DB snapshot identifier.
    #
    #   * If the source snapshot is in a different Amazon Web Services Region
    #     than the copy, specify a valid DB cluster snapshot ARN. For more
    #     information, go to [ Copying Snapshots Across Amazon Web Services
    #     Regions][1] in the *Amazon Aurora User Guide*.
    #
    #   Example: `my-cluster-snapshot1`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions
    #
    # @option params [required, String] :target_db_cluster_snapshot_identifier
    #   The identifier of the new DB cluster snapshot to create from the
    #   source DB cluster snapshot. This parameter isn't case-sensitive.
    #
    #   Constraints:
    #
    #   * Must contain from 1 to 63 letters, numbers, or hyphens.
    #
    #   * First character must be a letter.
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens.
    #
    #   Example: `my-cluster-snapshot2`
    #
    # @option params [String] :kms_key_id
    #   The Amazon Web Services KMS key identifier for an encrypted DB cluster
    #   snapshot. The Amazon Web Services KMS key identifier is the key ARN,
    #   key ID, alias ARN, or alias name for the Amazon Web Services KMS key.
    #
    #   If you copy an encrypted DB cluster snapshot from your Amazon Web
    #   Services account, you can specify a value for `KmsKeyId` to encrypt
    #   the copy with a new KMS key. If you don't specify a value for
    #   `KmsKeyId`, then the copy of the DB cluster snapshot is encrypted with
    #   the same KMS key as the source DB cluster snapshot.
    #
    #   If you copy an encrypted DB cluster snapshot that is shared from
    #   another Amazon Web Services account, then you must specify a value for
    #   `KmsKeyId`.
    #
    #   To copy an encrypted DB cluster snapshot to another Amazon Web
    #   Services Region, you must set `KmsKeyId` to the Amazon Web Services
    #   KMS key identifier you want to use to encrypt the copy of the DB
    #   cluster snapshot in the destination Amazon Web Services Region. KMS
    #   keys are specific to the Amazon Web Services Region that they are
    #   created in, and you can't use KMS keys from one Amazon Web Services
    #   Region in another Amazon Web Services Region.
    #
    #   If you copy an unencrypted DB cluster snapshot and specify a value for
    #   the `KmsKeyId` parameter, an error is returned.
    #
    # @option params [String] :pre_signed_url
    #   When you are copying a DB cluster snapshot from one Amazon Web
    #   Services GovCloud (US) Region to another, the URL that contains a
    #   Signature Version 4 signed request for the `CopyDBClusterSnapshot` API
    #   operation in the Amazon Web Services Region that contains the source
    #   DB cluster snapshot to copy. Use the `PreSignedUrl` parameter when
    #   copying an encrypted DB cluster snapshot from another Amazon Web
    #   Services Region. Don't specify `PreSignedUrl` when copying an
    #   encrypted DB cluster snapshot in the same Amazon Web Services Region.
    #
    #   This setting applies only to Amazon Web Services GovCloud (US)
    #   Regions. It's ignored in other Amazon Web Services Regions.
    #
    #   The presigned URL must be a valid request for the
    #   `CopyDBClusterSnapshot` API operation that can run in the source
    #   Amazon Web Services Region that contains the encrypted DB cluster
    #   snapshot to copy. The presigned URL request must contain the following
    #   parameter values:
    #
    #   * `KmsKeyId` - The KMS key identifier for the KMS key to use to
    #     encrypt the copy of the DB cluster snapshot in the destination
    #     Amazon Web Services Region. This is the same identifier for both the
    #     `CopyDBClusterSnapshot` operation that is called in the destination
    #     Amazon Web Services Region, and the operation contained in the
    #     presigned URL.
    #
    #   * `DestinationRegion` - The name of the Amazon Web Services Region
    #     that the DB cluster snapshot is to be created in.
    #
    #   * `SourceDBClusterSnapshotIdentifier` - The DB cluster snapshot
    #     identifier for the encrypted DB cluster snapshot to be copied. This
    #     identifier must be in the Amazon Resource Name (ARN) format for the
    #     source Amazon Web Services Region. For example, if you are copying
    #     an encrypted DB cluster snapshot from the us-west-2 Amazon Web
    #     Services Region, then your `SourceDBClusterSnapshotIdentifier` looks
    #     like the following example:
    #     `arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115`.
    #
    #   To learn how to generate a Signature Version 4 signed request, see [
    #   Authenticating Requests: Using Query Parameters (Amazon Web Services
    #   Signature Version 4)][1] and [ Signature Version 4 Signing
    #   Process][2].
    #
    #   <note markdown="1"> If you are using an Amazon Web Services SDK tool or the CLI, you can
    #   specify `SourceRegion` (or `--source-region` for the CLI) instead of
    #   specifying `PreSignedUrl` manually. Specifying `SourceRegion`
    #   autogenerates a presigned URL that is a valid request for the
    #   operation that can run in the source Amazon Web Services Region.
    #
    #    </note>
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html
    #   [2]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
    #
    # @option params [Boolean] :copy_tags
    #   Specifies whether to copy all tags from the source DB cluster snapshot
    #   to the target DB cluster snapshot. By default, tags are not copied.
    #
    # @option params [Array<Types::Tag>] :tags
    #   A list of tags.
    #
    #   For more information, see [Tagging Amazon RDS resources][1] in the
    #   *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS
    #   resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @option params [String] :source_region
    #   The source region of the snapshot. This is only needed when the
    #   shapshot is encrypted and in a different region.
    #
    # @return [Types::CopyDBClusterSnapshotResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopyDBClusterSnapshotResult#db_cluster_snapshot #db_cluster_snapshot} => Types::DBClusterSnapshot
    #
    #
    # @example Example: To copy a DB cluster snapshot
    #
    #   # The following example creates a copy of a DB cluster snapshot, including its tags.
    #
    #   resp = client.copy_db_cluster_snapshot({
    #     copy_tags: true, 
    #     source_db_cluster_snapshot_identifier: "arn:aws:rds:us-east-1:123456789012:cluster-snapshot:rds:myaurora-2019-06-04-09-16", 
    #     target_db_cluster_snapshot_identifier: "myclustersnapshotcopy", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster_snapshot: {
    #       allocated_storage: 0, 
    #       availability_zones: [
    #         "us-east-1a", 
    #         "us-east-1b", 
    #         "us-east-1e", 
    #       ], 
    #       cluster_create_time: Time.parse("2019-04-15T14:18:42.785Z"), 
    #       db_cluster_identifier: "myaurora", 
    #       db_cluster_snapshot_arn: "arn:aws:rds:us-east-1:123456789012:cluster-snapshot:myclustersnapshotcopy", 
    #       db_cluster_snapshot_identifier: "myclustersnapshotcopy", 
    #       engine: "aurora-mysql", 
    #       engine_version: "5.7.mysql_aurora.2.04.2", 
    #       iam_database_authentication_enabled: false, 
    #       kms_key_id: "arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE", 
    #       license_model: "aurora-mysql", 
    #       master_username: "myadmin", 
    #       percent_progress: 100, 
    #       port: 0, 
    #       snapshot_create_time: Time.parse("2019-06-04T09:16:42.649Z"), 
    #       snapshot_type: "manual", 
    #       status: "available", 
    #       storage_encrypted: true, 
    #       vpc_id: "vpc-123example", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_db_cluster_snapshot({
    #     source_db_cluster_snapshot_identifier: "String", # required
    #     target_db_cluster_snapshot_identifier: "String", # required
    #     kms_key_id: "String",
    #     pre_signed_url: "String",
    #     copy_tags: false,
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #     source_region: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_snapshot.availability_zones #=> Array
    #   resp.db_cluster_snapshot.availability_zones[0] #=> String
    #   resp.db_cluster_snapshot.db_cluster_snapshot_identifier #=> String
    #   resp.db_cluster_snapshot.db_cluster_identifier #=> String
    #   resp.db_cluster_snapshot.snapshot_create_time #=> Time
    #   resp.db_cluster_snapshot.engine #=> String
    #   resp.db_cluster_snapshot.engine_mode #=> String
    #   resp.db_cluster_snapshot.allocated_storage #=> Integer
    #   resp.db_cluster_snapshot.status #=> String
    #   resp.db_cluster_snapshot.port #=> Integer
    #   resp.db_cluster_snapshot.vpc_id #=> String
    #   resp.db_cluster_snapshot.cluster_create_time #=> Time
    #   resp.db_cluster_snapshot.master_username #=> String
    #   resp.db_cluster_snapshot.engine_version #=> String
    #   resp.db_cluster_snapshot.license_model #=> String
    #   resp.db_cluster_snapshot.snapshot_type #=> String
    #   resp.db_cluster_snapshot.percent_progress #=> Integer
    #   resp.db_cluster_snapshot.storage_encrypted #=> Boolean
    #   resp.db_cluster_snapshot.kms_key_id #=> String
    #   resp.db_cluster_snapshot.db_cluster_snapshot_arn #=> String
    #   resp.db_cluster_snapshot.source_db_cluster_snapshot_arn #=> String
    #   resp.db_cluster_snapshot.iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster_snapshot.tag_list #=> Array
    #   resp.db_cluster_snapshot.tag_list[0].key #=> String
    #   resp.db_cluster_snapshot.tag_list[0].value #=> String
    #   resp.db_cluster_snapshot.db_system_id #=> String
    #   resp.db_cluster_snapshot.storage_type #=> String
    #   resp.db_cluster_snapshot.db_cluster_resource_id #=> String
    #   resp.db_cluster_snapshot.storage_throughput #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshot AWS API Documentation
    #
    # @overload copy_db_cluster_snapshot(params = {})
    # @param [Hash] params ({})
    def copy_db_cluster_snapshot(params = {}, options = {})
      req = build_request(:copy_db_cluster_snapshot, params)
      req.send_request(options)
    end

    # Copies the specified DB parameter group.
    #
    # <note markdown="1"> You can't copy a default DB parameter group. Instead, create a new
    # custom DB parameter group, which copies the default parameters and
    # values for the specified DB parameter group family.
    #
    #  </note>
    #
    # @option params [required, String] :source_db_parameter_group_identifier
    #   The identifier or ARN for the source DB parameter group. For
    #   information about creating an ARN, see [ Constructing an ARN for
    #   Amazon RDS][1] in the *Amazon RDS User Guide*.
    #
    #   Constraints:
    #
    #   * Must specify a valid DB parameter group.
    #
    #   ^
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing
    #
    # @option params [required, String] :target_db_parameter_group_identifier
    #   The identifier for the copied DB parameter group.
    #
    #   Constraints:
    #
    #   * Can't be null, empty, or blank
    #
    #   * Must contain from 1 to 255 letters, numbers, or hyphens
    #
    #   * First character must be a letter
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens
    #
    #   Example: `my-db-parameter-group`
    #
    # @option params [required, String] :target_db_parameter_group_description
    #   A description for the copied DB parameter group.
    #
    # @option params [Array<Types::Tag>] :tags
    #   A list of tags.
    #
    #   For more information, see [Tagging Amazon RDS resources][1] in the
    #   *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS
    #   resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @return [Types::CopyDBParameterGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopyDBParameterGroupResult#db_parameter_group #db_parameter_group} => Types::DBParameterGroup
    #
    #
    # @example Example: To copy a DB parameter group
    #
    #   # The following example makes a copy of a DB parameter group.
    #
    #   resp = client.copy_db_parameter_group({
    #     source_db_parameter_group_identifier: "mydbpg", 
    #     target_db_parameter_group_description: "Copy of mydbpg parameter group", 
    #     target_db_parameter_group_identifier: "mydbpgcopy", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_parameter_group: {
    #       db_parameter_group_arn: "arn:aws:rds:us-east-1:814387698303:pg:mydbpgcopy", 
    #       db_parameter_group_family: "mysql5.7", 
    #       db_parameter_group_name: "mydbpgcopy", 
    #       description: "Copy of mydbpg parameter group", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_db_parameter_group({
    #     source_db_parameter_group_identifier: "String", # required
    #     target_db_parameter_group_identifier: "String", # required
    #     target_db_parameter_group_description: "String", # required
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_parameter_group.db_parameter_group_name #=> String
    #   resp.db_parameter_group.db_parameter_group_family #=> String
    #   resp.db_parameter_group.description #=> String
    #   resp.db_parameter_group.db_parameter_group_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroup AWS API Documentation
    #
    # @overload copy_db_parameter_group(params = {})
    # @param [Hash] params ({})
    def copy_db_parameter_group(params = {}, options = {})
      req = build_request(:copy_db_parameter_group, params)
      req.send_request(options)
    end

    # Copies the specified DB snapshot. The source DB snapshot must be in
    # the `available` state.
    #
    # You can copy a snapshot from one Amazon Web Services Region to
    # another. In that case, the Amazon Web Services Region where you call
    # the `CopyDBSnapshot` operation is the destination Amazon Web Services
    # Region for the DB snapshot copy.
    #
    # This command doesn't apply to RDS Custom.
    #
    # For more information about copying snapshots, see [Copying a DB
    # Snapshot][1] in the *Amazon RDS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot
    #
    # @option params [required, String] :source_db_snapshot_identifier
    #   The identifier for the source DB snapshot.
    #
    #   If the source snapshot is in the same Amazon Web Services Region as
    #   the copy, specify a valid DB snapshot identifier. For example, you
    #   might specify `rds:mysql-instance1-snapshot-20130805`.
    #
    #   If the source snapshot is in a different Amazon Web Services Region
    #   than the copy, specify a valid DB snapshot ARN. For example, you might
    #   specify
    #   `arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805`.
    #
    #   If you are copying from a shared manual DB snapshot, this parameter
    #   must be the Amazon Resource Name (ARN) of the shared DB snapshot.
    #
    #   If you are copying an encrypted snapshot this parameter must be in the
    #   ARN format for the source Amazon Web Services Region.
    #
    #   Constraints:
    #
    #   * Must specify a valid system snapshot in the "available" state.
    #
    #   ^
    #
    #   Example: `rds:mydb-2012-04-02-00-01`
    #
    #   Example:
    #   `arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805`
    #
    # @option params [required, String] :target_db_snapshot_identifier
    #   The identifier for the copy of the snapshot.
    #
    #   Constraints:
    #
    #   * Can't be null, empty, or blank
    #
    #   * Must contain from 1 to 255 letters, numbers, or hyphens
    #
    #   * First character must be a letter
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens
    #
    #   Example: `my-db-snapshot`
    #
    # @option params [String] :kms_key_id
    #   The Amazon Web Services KMS key identifier for an encrypted DB
    #   snapshot. The Amazon Web Services KMS key identifier is the key ARN,
    #   key ID, alias ARN, or alias name for the KMS key.
    #
    #   If you copy an encrypted DB snapshot from your Amazon Web Services
    #   account, you can specify a value for this parameter to encrypt the
    #   copy with a new KMS key. If you don't specify a value for this
    #   parameter, then the copy of the DB snapshot is encrypted with the same
    #   Amazon Web Services KMS key as the source DB snapshot.
    #
    #   If you copy an encrypted DB snapshot that is shared from another
    #   Amazon Web Services account, then you must specify a value for this
    #   parameter.
    #
    #   If you specify this parameter when you copy an unencrypted snapshot,
    #   the copy is encrypted.
    #
    #   If you copy an encrypted snapshot to a different Amazon Web Services
    #   Region, then you must specify an Amazon Web Services KMS key
    #   identifier for the destination Amazon Web Services Region. KMS keys
    #   are specific to the Amazon Web Services Region that they are created
    #   in, and you can't use KMS keys from one Amazon Web Services Region in
    #   another Amazon Web Services Region.
    #
    # @option params [Array<Types::Tag>] :tags
    #   A list of tags.
    #
    #   For more information, see [Tagging Amazon RDS resources][1] in the
    #   *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS
    #   resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @option params [Boolean] :copy_tags
    #   Specifies whether to copy all tags from the source DB snapshot to the
    #   target DB snapshot. By default, tags aren't copied.
    #
    # @option params [String] :pre_signed_url
    #   When you are copying a snapshot from one Amazon Web Services GovCloud
    #   (US) Region to another, the URL that contains a Signature Version 4
    #   signed request for the `CopyDBSnapshot` API operation in the source
    #   Amazon Web Services Region that contains the source DB snapshot to
    #   copy.
    #
    #   This setting applies only to Amazon Web Services GovCloud (US)
    #   Regions. It's ignored in other Amazon Web Services Regions.
    #
    #   You must specify this parameter when you copy an encrypted DB snapshot
    #   from another Amazon Web Services Region by using the Amazon RDS API.
    #   Don't specify `PreSignedUrl` when you are copying an encrypted DB
    #   snapshot in the same Amazon Web Services Region.
    #
    #   The presigned URL must be a valid request for the
    #   `CopyDBClusterSnapshot` API operation that can run in the source
    #   Amazon Web Services Region that contains the encrypted DB cluster
    #   snapshot to copy. The presigned URL request must contain the following
    #   parameter values:
    #
    #   * `DestinationRegion` - The Amazon Web Services Region that the
    #     encrypted DB snapshot is copied to. This Amazon Web Services Region
    #     is the same one where the `CopyDBSnapshot` operation is called that
    #     contains this presigned URL.
    #
    #     For example, if you copy an encrypted DB snapshot from the us-west-2
    #     Amazon Web Services Region to the us-east-1 Amazon Web Services
    #     Region, then you call the `CopyDBSnapshot` operation in the
    #     us-east-1 Amazon Web Services Region and provide a presigned URL
    #     that contains a call to the `CopyDBSnapshot` operation in the
    #     us-west-2 Amazon Web Services Region. For this example, the
    #     `DestinationRegion` in the presigned URL must be set to the
    #     us-east-1 Amazon Web Services Region.
    #
    #   * `KmsKeyId` - The KMS key identifier for the KMS key to use to
    #     encrypt the copy of the DB snapshot in the destination Amazon Web
    #     Services Region. This is the same identifier for both the
    #     `CopyDBSnapshot` operation that is called in the destination Amazon
    #     Web Services Region, and the operation contained in the presigned
    #     URL.
    #
    #   * `SourceDBSnapshotIdentifier` - The DB snapshot identifier for the
    #     encrypted snapshot to be copied. This identifier must be in the
    #     Amazon Resource Name (ARN) format for the source Amazon Web Services
    #     Region. For example, if you are copying an encrypted DB snapshot
    #     from the us-west-2 Amazon Web Services Region, then your
    #     `SourceDBSnapshotIdentifier` looks like the following example:
    #     `arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115`.
    #
    #   To learn how to generate a Signature Version 4 signed request, see
    #   [Authenticating Requests: Using Query Parameters (Amazon Web Services
    #   Signature Version 4)][1] and [Signature Version 4 Signing Process][2].
    #
    #   <note markdown="1"> If you are using an Amazon Web Services SDK tool or the CLI, you can
    #   specify `SourceRegion` (or `--source-region` for the CLI) instead of
    #   specifying `PreSignedUrl` manually. Specifying `SourceRegion`
    #   autogenerates a presigned URL that is a valid request for the
    #   operation that can run in the source Amazon Web Services Region.
    #
    #    </note>
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html
    #   [2]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
    #
    # @option params [String] :option_group_name
    #   The name of an option group to associate with the copy of the
    #   snapshot.
    #
    #   Specify this option if you are copying a snapshot from one Amazon Web
    #   Services Region to another, and your DB instance uses a nondefault
    #   option group. If your source DB instance uses Transparent Data
    #   Encryption for Oracle or Microsoft SQL Server, you must specify this
    #   option when copying across Amazon Web Services Regions. For more
    #   information, see [Option group considerations][1] in the *Amazon RDS
    #   User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options
    #
    # @option params [String] :target_custom_availability_zone
    #   The external custom Availability Zone (CAZ) identifier for the target
    #   CAZ.
    #
    #   Example: `rds-caz-aiqhTgQv`.
    #
    # @option params [Boolean] :copy_option_group
    #   Specifies whether to copy the DB option group associated with the
    #   source DB snapshot to the target Amazon Web Services account and
    #   associate with the target DB snapshot. The associated option group can
    #   be copied only with cross-account snapshot copy calls.
    #
    # @option params [String] :snapshot_availability_zone
    #   Specifies the name of the Availability Zone where RDS stores the DB
    #   snapshot. This value is valid only for snapshots that RDS stores on a
    #   Dedicated Local Zone.
    #
    # @option params [String] :snapshot_target
    #   Configures the location where RDS will store copied snapshots.
    #
    #   Valid Values:
    #
    #   * `local` (Dedicated Local Zone)
    #
    #   * `outposts` (Amazon Web Services Outposts)
    #
    #   * `region` (Amazon Web Services Region)
    #
    # @option params [String] :source_region
    #   The source region of the snapshot. This is only needed when the
    #   shapshot is encrypted and in a different region.
    #
    # @return [Types::CopyDBSnapshotResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopyDBSnapshotResult#db_snapshot #db_snapshot} => Types::DBSnapshot
    #
    #
    # @example Example: To copy a DB snapshot
    #
    #   # The following example creates a copy of a DB snapshot.
    #
    #   resp = client.copy_db_snapshot({
    #     source_db_snapshot_identifier: "rds:database-mysql-2019-06-06-08-38", 
    #     target_db_snapshot_identifier: "mydbsnapshotcopy", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_snapshot: {
    #       allocated_storage: 100, 
    #       availability_zone: "us-east-1f", 
    #       db_instance_identifier: "database-mysql", 
    #       db_snapshot_arn: "arn:aws:rds:us-east-1:123456789012:snapshot:mydbsnapshotcopy", 
    #       db_snapshot_identifier: "mydbsnapshotcopy", 
    #       dbi_resource_id: "db-ZI7UJ5BLKMBYFGX7FDENCKADC4", 
    #       encrypted: true, 
    #       engine: "mysql", 
    #       engine_version: "5.6.40", 
    #       iam_database_authentication_enabled: false, 
    #       instance_create_time: Time.parse("2019-04-30T15:45:53.663Z"), 
    #       iops: 1000, 
    #       kms_key_id: "arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE", 
    #       license_model: "general-public-license", 
    #       master_username: "admin", 
    #       option_group_name: "default:mysql-5-6", 
    #       percent_progress: 0, 
    #       port: 3306, 
    #       processor_features: [
    #       ], 
    #       snapshot_type: "manual", 
    #       source_db_snapshot_identifier: "arn:aws:rds:us-east-1:123456789012:snapshot:rds:database-mysql-2019-06-06-08-38", 
    #       source_region: "us-east-1", 
    #       status: "creating", 
    #       storage_type: "io1", 
    #       vpc_id: "vpc-6594f31c", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_db_snapshot({
    #     source_db_snapshot_identifier: "String", # required
    #     target_db_snapshot_identifier: "String", # required
    #     kms_key_id: "String",
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #     copy_tags: false,
    #     pre_signed_url: "String",
    #     option_group_name: "String",
    #     target_custom_availability_zone: "String",
    #     copy_option_group: false,
    #     snapshot_availability_zone: "String",
    #     snapshot_target: "String",
    #     source_region: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.db_snapshot.db_snapshot_identifier #=> String
    #   resp.db_snapshot.db_instance_identifier #=> String
    #   resp.db_snapshot.snapshot_create_time #=> Time
    #   resp.db_snapshot.engine #=> String
    #   resp.db_snapshot.allocated_storage #=> Integer
    #   resp.db_snapshot.status #=> String
    #   resp.db_snapshot.port #=> Integer
    #   resp.db_snapshot.availability_zone #=> String
    #   resp.db_snapshot.vpc_id #=> String
    #   resp.db_snapshot.instance_create_time #=> Time
    #   resp.db_snapshot.master_username #=> String
    #   resp.db_snapshot.engine_version #=> String
    #   resp.db_snapshot.license_model #=> String
    #   resp.db_snapshot.snapshot_type #=> String
    #   resp.db_snapshot.iops #=> Integer
    #   resp.db_snapshot.option_group_name #=> String
    #   resp.db_snapshot.percent_progress #=> Integer
    #   resp.db_snapshot.source_region #=> String
    #   resp.db_snapshot.source_db_snapshot_identifier #=> String
    #   resp.db_snapshot.storage_type #=> String
    #   resp.db_snapshot.tde_credential_arn #=> String
    #   resp.db_snapshot.encrypted #=> Boolean
    #   resp.db_snapshot.kms_key_id #=> String
    #   resp.db_snapshot.db_snapshot_arn #=> String
    #   resp.db_snapshot.timezone #=> String
    #   resp.db_snapshot.iam_database_authentication_enabled #=> Boolean
    #   resp.db_snapshot.processor_features #=> Array
    #   resp.db_snapshot.processor_features[0].name #=> String
    #   resp.db_snapshot.processor_features[0].value #=> String
    #   resp.db_snapshot.dbi_resource_id #=> String
    #   resp.db_snapshot.tag_list #=> Array
    #   resp.db_snapshot.tag_list[0].key #=> String
    #   resp.db_snapshot.tag_list[0].value #=> String
    #   resp.db_snapshot.original_snapshot_create_time #=> Time
    #   resp.db_snapshot.snapshot_database_time #=> Time
    #   resp.db_snapshot.snapshot_target #=> String
    #   resp.db_snapshot.storage_throughput #=> Integer
    #   resp.db_snapshot.db_system_id #=> String
    #   resp.db_snapshot.dedicated_log_volume #=> Boolean
    #   resp.db_snapshot.multi_tenant #=> Boolean
    #   resp.db_snapshot.snapshot_availability_zone #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshot AWS API Documentation
    #
    # @overload copy_db_snapshot(params = {})
    # @param [Hash] params ({})
    def copy_db_snapshot(params = {}, options = {})
      req = build_request(:copy_db_snapshot, params)
      req.send_request(options)
    end

    # Copies the specified option group.
    #
    # @option params [required, String] :source_option_group_identifier
    #   The identifier for the source option group.
    #
    #   Constraints:
    #
    #   * Must specify a valid option group.
    #
    #   ^
    #
    # @option params [required, String] :target_option_group_identifier
    #   The identifier for the copied option group.
    #
    #   Constraints:
    #
    #   * Can't be null, empty, or blank
    #
    #   * Must contain from 1 to 255 letters, numbers, or hyphens
    #
    #   * First character must be a letter
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens
    #
    #   Example: `my-option-group`
    #
    # @option params [required, String] :target_option_group_description
    #   The description for the copied option group.
    #
    # @option params [Array<Types::Tag>] :tags
    #   A list of tags.
    #
    #   For more information, see [Tagging Amazon RDS resources][1] in the
    #   *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS
    #   resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @return [Types::CopyOptionGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopyOptionGroupResult#option_group #option_group} => Types::OptionGroup
    #
    #
    # @example Example: To copy an option group
    #
    #   # The following example makes a copy of an option group.
    #
    #   resp = client.copy_option_group({
    #     source_option_group_identifier: "myoptiongroup", 
    #     target_option_group_description: "My option group copy", 
    #     target_option_group_identifier: "new-option-group", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     option_group: {
    #       allows_vpc_and_non_vpc_instance_memberships: true, 
    #       engine_name: "oracle-ee", 
    #       major_engine_version: "11.2", 
    #       option_group_arn: "arn:aws:rds:us-east-1:123456789012:og:new-option-group", 
    #       option_group_description: "My option group copy", 
    #       option_group_name: "new-option-group", 
    #       options: [
    #       ], 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_option_group({
    #     source_option_group_identifier: "String", # required
    #     target_option_group_identifier: "String", # required
    #     target_option_group_description: "String", # required
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.option_group.option_group_name #=> String
    #   resp.option_group.option_group_description #=> String
    #   resp.option_group.engine_name #=> String
    #   resp.option_group.major_engine_version #=> String
    #   resp.option_group.options #=> Array
    #   resp.option_group.options[0].option_name #=> String
    #   resp.option_group.options[0].option_description #=> String
    #   resp.option_group.options[0].persistent #=> Boolean
    #   resp.option_group.options[0].permanent #=> Boolean
    #   resp.option_group.options[0].port #=> Integer
    #   resp.option_group.options[0].option_version #=> String
    #   resp.option_group.options[0].option_settings #=> Array
    #   resp.option_group.options[0].option_settings[0].name #=> String
    #   resp.option_group.options[0].option_settings[0].value #=> String
    #   resp.option_group.options[0].option_settings[0].default_value #=> String
    #   resp.option_group.options[0].option_settings[0].description #=> String
    #   resp.option_group.options[0].option_settings[0].apply_type #=> String
    #   resp.option_group.options[0].option_settings[0].data_type #=> String
    #   resp.option_group.options[0].option_settings[0].allowed_values #=> String
    #   resp.option_group.options[0].option_settings[0].is_modifiable #=> Boolean
    #   resp.option_group.options[0].option_settings[0].is_collection #=> Boolean
    #   resp.option_group.options[0].db_security_group_memberships #=> Array
    #   resp.option_group.options[0].db_security_group_memberships[0].db_security_group_name #=> String
    #   resp.option_group.options[0].db_security_group_memberships[0].status #=> String
    #   resp.option_group.options[0].vpc_security_group_memberships #=> Array
    #   resp.option_group.options[0].vpc_security_group_memberships[0].vpc_security_group_id #=> String
    #   resp.option_group.options[0].vpc_security_group_memberships[0].status #=> String
    #   resp.option_group.allows_vpc_and_non_vpc_instance_memberships #=> Boolean
    #   resp.option_group.vpc_id #=> String
    #   resp.option_group.option_group_arn #=> String
    #   resp.option_group.source_option_group #=> String
    #   resp.option_group.source_account_id #=> String
    #   resp.option_group.copy_timestamp #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroup AWS API Documentation
    #
    # @overload copy_option_group(params = {})
    # @param [Hash] params ({})
    def copy_option_group(params = {}, options = {})
      req = build_request(:copy_option_group, params)
      req.send_request(options)
    end

    # Creates a blue/green deployment.
    #
    # A blue/green deployment creates a staging environment that copies the
    # production environment. In a blue/green deployment, the blue
    # environment is the current production environment. The green
    # environment is the staging environment, and it stays in sync with the
    # current production environment.
    #
    # You can make changes to the databases in the green environment without
    # affecting production workloads. For example, you can upgrade the major
    # or minor DB engine version, change database parameters, or make schema
    # changes in the staging environment. You can thoroughly test changes in
    # the green environment. When ready, you can switch over the
    # environments to promote the green environment to be the new production
    # environment. The switchover typically takes under a minute.
    #
    # For more information, see [Using Amazon RDS Blue/Green Deployments for
    # database updates][1] in the *Amazon RDS User Guide* and [ Using Amazon
    # RDS Blue/Green Deployments for database updates][2] in the *Amazon
    # Aurora User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html
    #
    # @option params [required, String] :blue_green_deployment_name
    #   The name of the blue/green deployment.
    #
    #   Constraints:
    #
    #   * Can't be the same as an existing blue/green deployment name in the
    #     same account and Amazon Web Services Region.
    #
    #   ^
    #
    # @option params [required, String] :source
    #   The Amazon Resource Name (ARN) of the source production database.
    #
    #   Specify the database that you want to clone. The blue/green deployment
    #   creates this database in the green environment. You can make updates
    #   to the database in the green environment, such as an engine version
    #   upgrade. When you are ready, you can switch the database in the green
    #   environment to be the production database.
    #
    # @option params [String] :target_engine_version
    #   The engine version of the database in the green environment.
    #
    #   Specify the engine version to upgrade to in the green environment.
    #
    # @option params [String] :target_db_parameter_group_name
    #   The DB parameter group associated with the DB instance in the green
    #   environment.
    #
    #   To test parameter changes, specify a DB parameter group that is
    #   different from the one associated with the source DB instance.
    #
    # @option params [String] :target_db_cluster_parameter_group_name
    #   The DB cluster parameter group associated with the Aurora DB cluster
    #   in the green environment.
    #
    #   To test parameter changes, specify a DB cluster parameter group that
    #   is different from the one associated with the source DB cluster.
    #
    # @option params [Array<Types::Tag>] :tags
    #   Tags to assign to the blue/green deployment.
    #
    # @option params [String] :target_db_instance_class
    #   Specify the DB instance class for the databases in the green
    #   environment.
    #
    #   This parameter only applies to RDS DB instances, because DB instances
    #   within an Aurora DB cluster can have multiple different instance
    #   classes. If you're creating a blue/green deployment from an Aurora DB
    #   cluster, don't specify this parameter. After the green environment is
    #   created, you can individually modify the instance classes of the DB
    #   instances within the green DB cluster.
    #
    # @option params [Boolean] :upgrade_target_storage_config
    #   Whether to upgrade the storage file system configuration on the green
    #   database. This option migrates the green DB instance from the older
    #   32-bit file system to the preferred configuration. For more
    #   information, see [Upgrading the storage file system for a DB
    #   instance][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.UpgradeFileSystem
    #
    # @option params [Integer] :target_iops
    #   The amount of Provisioned IOPS (input/output operations per second) to
    #   allocate for the green DB instance. For information about valid IOPS
    #   values, see [Amazon RDS DB instance storage][1] in the *Amazon RDS
    #   User Guide*.
    #
    #   This setting doesn't apply to Amazon Aurora blue/green deployments.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html
    #
    # @option params [String] :target_storage_type
    #   The storage type to associate with the green DB instance.
    #
    #   Valid Values: `gp2 | gp3 | io1 | io2`
    #
    #   This setting doesn't apply to Amazon Aurora blue/green deployments.
    #
    # @option params [Integer] :target_allocated_storage
    #   The amount of storage in gibibytes (GiB) to allocate for the green DB
    #   instance. You can choose to increase or decrease the allocated storage
    #   on the green DB instance.
    #
    #   This setting doesn't apply to Amazon Aurora blue/green deployments.
    #
    # @option params [Integer] :target_storage_throughput
    #   The storage throughput value for the green DB instance.
    #
    #   This setting applies only to the `gp3` storage type.
    #
    #   This setting doesn't apply to Amazon Aurora blue/green deployments.
    #
    # @return [Types::CreateBlueGreenDeploymentResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateBlueGreenDeploymentResponse#blue_green_deployment #blue_green_deployment} => Types::BlueGreenDeployment
    #
    #
    # @example Example: To create a blue/green deployment for an RDS for MySQL DB instance
    #
    #   # The following example creates a blue/green deployment for a MySQL DB instance.
    #
    #   resp = client.create_blue_green_deployment({
    #     blue_green_deployment_name: "bgd-test-instance", 
    #     source: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance", 
    #     target_db_parameter_group_name: "mysql-80-group", 
    #     target_engine_version: "8.0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     blue_green_deployment: {
    #       blue_green_deployment_identifier: "bgd-v53303651eexfake", 
    #       blue_green_deployment_name: "bgd-cli-test-instance", 
    #       create_time: Time.parse("2022-02-25T21:18:51.183000+00:00"), 
    #       source: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance", 
    #       status: "PROVISIONING", 
    #       switchover_details: [
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-1", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-2", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-3", 
    #         }, 
    #       ], 
    #       tasks: [
    #         {
    #           name: "CREATING_READ_REPLICA_OF_SOURCE", 
    #           status: "PENDING", 
    #         }, 
    #         {
    #           name: "DB_ENGINE_VERSION_UPGRADE", 
    #           status: "PENDING", 
    #         }, 
    #         {
    #           name: "CONFIGURE_BACKUPS", 
    #           status: "PENDING", 
    #         }, 
    #         {
    #           name: "CREATING_TOPOLOGY_OF_SOURCE", 
    #           status: "PENDING", 
    #         }, 
    #       ], 
    #     }, 
    #   }
    #
    # @example Example: To create a blue/green deployment for an Aurora MySQL DB cluster
    #
    #   # The following example creates a blue/green deployment for an Aurora MySQL DB cluster.
    #
    #   resp = client.create_blue_green_deployment({
    #     blue_green_deployment_name: "my-blue-green-deployment", 
    #     source: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster", 
    #     target_db_cluster_parameter_group_name: "mysql-80-cluster-group", 
    #     target_db_parameter_group_name: "ams-80-binlog-enabled", 
    #     target_engine_version: "8.0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     blue_green_deployment: {
    #       blue_green_deployment_identifier: "bgd-wi89nwzglccsfake", 
    #       blue_green_deployment_name: "my-blue-green-deployment", 
    #       create_time: Time.parse("2022-02-25T21:12:00.288000+00:00"), 
    #       source: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster", 
    #       status: "PROVISIONING", 
    #       switchover_details: [
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster", 
    #           status: "PROVISIONING", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1", 
    #           status: "PROVISIONING", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2", 
    #           status: "PROVISIONING", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3", 
    #           status: "PROVISIONING", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint", 
    #           status: "PROVISIONING", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint", 
    #           status: "PROVISIONING", 
    #         }, 
    #       ], 
    #       tasks: [
    #         {
    #           name: "CREATING_READ_REPLICA_OF_SOURCE", 
    #           status: "PENDING", 
    #         }, 
    #         {
    #           name: "DB_ENGINE_VERSION_UPGRADE", 
    #           status: "PENDING", 
    #         }, 
    #         {
    #           name: "CREATE_DB_INSTANCES_FOR_CLUSTER", 
    #           status: "PENDING", 
    #         }, 
    #         {
    #           name: "CREATE_CUSTOM_ENDPOINTS", 
    #           status: "PENDING", 
    #         }, 
    #       ], 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_blue_green_deployment({
    #     blue_green_deployment_name: "BlueGreenDeploymentName", # required
    #     source: "DatabaseArn", # required
    #     target_engine_version: "TargetEngineVersion",
    #     target_db_parameter_group_name: "TargetDBParameterGroupName",
    #     target_db_cluster_parameter_group_name: "TargetDBClusterParameterGroupName",
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #     target_db_instance_class: "TargetDBInstanceClass",
    #     upgrade_target_storage_config: false,
    #     target_iops: 1,
    #     target_storage_type: "TargetStorageType",
    #     target_allocated_storage: 1,
    #     target_storage_throughput: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.blue_green_deployment.blue_green_deployment_identifier #=> String
    #   resp.blue_green_deployment.blue_green_deployment_name #=> String
    #   resp.blue_green_deployment.source #=> String
    #   resp.blue_green_deployment.target #=> String
    #   resp.blue_green_deployment.switchover_details #=> Array
    #   resp.blue_green_deployment.switchover_details[0].source_member #=> String
    #   resp.blue_green_deployment.switchover_details[0].target_member #=> String
    #   resp.blue_green_deployment.switchover_details[0].status #=> String
    #   resp.blue_green_deployment.tasks #=> Array
    #   resp.blue_green_deployment.tasks[0].name #=> String
    #   resp.blue_green_deployment.tasks[0].status #=> String
    #   resp.blue_green_deployment.status #=> String
    #   resp.blue_green_deployment.status_details #=> String
    #   resp.blue_green_deployment.create_time #=> Time
    #   resp.blue_green_deployment.delete_time #=> Time
    #   resp.blue_green_deployment.tag_list #=> Array
    #   resp.blue_green_deployment.tag_list[0].key #=> String
    #   resp.blue_green_deployment.tag_list[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateBlueGreenDeployment AWS API Documentation
    #
    # @overload create_blue_green_deployment(params = {})
    # @param [Hash] params ({})
    def create_blue_green_deployment(params = {}, options = {})
      req = build_request(:create_blue_green_deployment, params)
      req.send_request(options)
    end

    # Creates a custom DB engine version (CEV).
    #
    # @option params [required, String] :engine
    #   The database engine. RDS Custom for Oracle supports the following
    #   values:
    #
    #   * `custom-oracle-ee`
    #
    #   * `custom-oracle-ee-cdb`
    #
    #   * `custom-oracle-se2`
    #
    #   * `custom-oracle-se2-cdb`
    #
    # @option params [required, String] :engine_version
    #   The name of your CEV. The name format is 19.*customized\_string*. For
    #   example, a valid CEV name is `19.my_cev1`. This setting is required
    #   for RDS Custom for Oracle, but optional for Amazon RDS. The
    #   combination of `Engine` and `EngineVersion` is unique per customer per
    #   Region.
    #
    # @option params [String] :database_installation_files_s3_bucket_name
    #   The name of an Amazon S3 bucket that contains database installation
    #   files for your CEV. For example, a valid bucket name is
    #   `my-custom-installation-files`.
    #
    # @option params [String] :database_installation_files_s3_prefix
    #   The Amazon S3 directory that contains the database installation files
    #   for your CEV. For example, a valid bucket name is `123456789012/cev1`.
    #   If this setting isn't specified, no prefix is assumed.
    #
    # @option params [String] :image_id
    #   The ID of the Amazon Machine Image (AMI). For RDS Custom for SQL
    #   Server, an AMI ID is required to create a CEV. For RDS Custom for
    #   Oracle, the default is the most recent AMI available, but you can
    #   specify an AMI ID that was used in a different Oracle CEV. Find the
    #   AMIs used by your CEVs by calling the [DescribeDBEngineVersions][1]
    #   operation.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBEngineVersions.html
    #
    # @option params [String] :kms_key_id
    #   The Amazon Web Services KMS key identifier for an encrypted CEV. A
    #   symmetric encryption KMS key is required for RDS Custom, but optional
    #   for Amazon RDS.
    #
    #   If you have an existing symmetric encryption KMS key in your account,
    #   you can use it with RDS Custom. No further action is necessary. If you
    #   don't already have a symmetric encryption KMS key in your account,
    #   follow the instructions in [ Creating a symmetric encryption KMS
    #   key][1] in the *Amazon Web Services Key Management Service Developer
    #   Guide*.
    #
    #   You can choose the same symmetric encryption key when you create a CEV
    #   and a DB instance, or choose different keys.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk
    #
    # @option params [String] :description
    #   An optional description of your CEV.
    #
    # @option params [String] :manifest
    #   The CEV manifest, which is a JSON document that describes the
    #   installation .zip files stored in Amazon S3. Specify the name/value
    #   pairs in a file or a quoted string. RDS Custom applies the patches in
    #   the order in which they are listed.
    #
    #   The following JSON fields are valid:
    #
    #   MediaImportTemplateVersion
    #
    #   : Version of the CEV manifest. The date is in the format `YYYY-MM-DD`.
    #
    #   databaseInstallationFileNames
    #
    #   : Ordered list of installation files for the CEV.
    #
    #   opatchFileNames
    #
    #   : Ordered list of OPatch installers used for the Oracle DB engine.
    #
    #   psuRuPatchFileNames
    #
    #   : The PSU and RU patches for this CEV.
    #
    #   OtherPatchFileNames
    #
    #   : The patches that are not in the list of PSU and RU patches. Amazon
    #     RDS applies these patches after applying the PSU and RU patches.
    #
    #   For more information, see [ Creating the CEV manifest][1] in the
    #   *Amazon RDS User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest
    #
    # @option params [Array<Types::Tag>] :tags
    #   A list of tags.
    #
    #   For more information, see [Tagging Amazon RDS resources][1] in the
    #   *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS
    #   resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @option params [String] :source_custom_db_engine_version_identifier
    #   The ARN of a CEV to use as a source for creating a new CEV. You can
    #   specify a different Amazon Machine Imagine (AMI) by using either
    #   `Source` or `UseAwsProvidedLatestImage`. You can't specify a
    #   different JSON manifest when you specify
    #   `SourceCustomDbEngineVersionIdentifier`.
    #
    # @option params [Boolean] :use_aws_provided_latest_image
    #   Specifies whether to use the latest service-provided Amazon Machine
    #   Image (AMI) for the CEV. If you specify `UseAwsProvidedLatestImage`,
    #   you can't also specify `ImageId`.
    #
    # @return [Types::DBEngineVersion] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBEngineVersion#engine #engine} => String
    #   * {Types::DBEngineVersion#engine_version #engine_version} => String
    #   * {Types::DBEngineVersion#db_parameter_group_family #db_parameter_group_family} => String
    #   * {Types::DBEngineVersion#db_engine_description #db_engine_description} => String
    #   * {Types::DBEngineVersion#db_engine_version_description #db_engine_version_description} => String
    #   * {Types::DBEngineVersion#default_character_set #default_character_set} => Types::CharacterSet
    #   * {Types::DBEngineVersion#image #image} => Types::CustomDBEngineVersionAMI
    #   * {Types::DBEngineVersion#db_engine_media_type #db_engine_media_type} => String
    #   * {Types::DBEngineVersion#supported_character_sets #supported_character_sets} => Array&lt;Types::CharacterSet&gt;
    #   * {Types::DBEngineVersion#supported_nchar_character_sets #supported_nchar_character_sets} => Array&lt;Types::CharacterSet&gt;
    #   * {Types::DBEngineVersion#valid_upgrade_target #valid_upgrade_target} => Array&lt;Types::UpgradeTarget&gt;
    #   * {Types::DBEngineVersion#supported_timezones #supported_timezones} => Array&lt;Types::Timezone&gt;
    #   * {Types::DBEngineVersion#exportable_log_types #exportable_log_types} => Array&lt;String&gt;
    #   * {Types::DBEngineVersion#supports_log_exports_to_cloudwatch_logs #supports_log_exports_to_cloudwatch_logs} => Boolean
    #   * {Types::DBEngineVersion#supports_read_replica #supports_read_replica} => Boolean
    #   * {Types::DBEngineVersion#supported_engine_modes #supported_engine_modes} => Array&lt;String&gt;
    #   * {Types::DBEngineVersion#supported_feature_names #supported_feature_names} => Array&lt;String&gt;
    #   * {Types::DBEngineVersion#status #status} => String
    #   * {Types::DBEngineVersion#supports_parallel_query #supports_parallel_query} => Boolean
    #   * {Types::DBEngineVersion#supports_global_databases #supports_global_databases} => Boolean
    #   * {Types::DBEngineVersion#major_engine_version #major_engine_version} => String
    #   * {Types::DBEngineVersion#database_installation_files_s3_bucket_name #database_installation_files_s3_bucket_name} => String
    #   * {Types::DBEngineVersion#database_installation_files_s3_prefix #database_installation_files_s3_prefix} => String
    #   * {Types::DBEngineVersion#db_engine_version_arn #db_engine_version_arn} => String
    #   * {Types::DBEngineVersion#kms_key_id #kms_key_id} => String
    #   * {Types::DBEngineVersion#create_time #create_time} => Time
    #   * {Types::DBEngineVersion#tag_list #tag_list} => Array&lt;Types::Tag&gt;
    #   * {Types::DBEngineVersion#supports_babelfish #supports_babelfish} => Boolean
    #   * {Types::DBEngineVersion#custom_db_engine_version_manifest #custom_db_engine_version_manifest} => String
    #   * {Types::DBEngineVersion#supports_limitless_database #supports_limitless_database} => Boolean
    #   * {Types::DBEngineVersion#supports_certificate_rotation_without_restart #supports_certificate_rotation_without_restart} => Boolean
    #   * {Types::DBEngineVersion#supported_ca_certificate_identifiers #supported_ca_certificate_identifiers} => Array&lt;String&gt;
    #   * {Types::DBEngineVersion#supports_local_write_forwarding #supports_local_write_forwarding} => Boolean
    #   * {Types::DBEngineVersion#supports_integrations #supports_integrations} => Boolean
    #   * {Types::DBEngineVersion#serverless_v2_features_support #serverless_v2_features_support} => Types::ServerlessV2FeaturesSupport
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_custom_db_engine_version({
    #     engine: "CustomEngineName", # required
    #     engine_version: "CustomEngineVersion", # required
    #     database_installation_files_s3_bucket_name: "BucketName",
    #     database_installation_files_s3_prefix: "String255",
    #     image_id: "String255",
    #     kms_key_id: "KmsKeyIdOrArn",
    #     description: "Description",
    #     manifest: "CustomDBEngineVersionManifest",
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #     source_custom_db_engine_version_identifier: "String255",
    #     use_aws_provided_latest_image: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.engine #=> String
    #   resp.engine_version #=> String
    #   resp.db_parameter_group_family #=> String
    #   resp.db_engine_description #=> String
    #   resp.db_engine_version_description #=> String
    #   resp.default_character_set.character_set_name #=> String
    #   resp.default_character_set.character_set_description #=> String
    #   resp.image.image_id #=> String
    #   resp.image.status #=> String
    #   resp.db_engine_media_type #=> String
    #   resp.supported_character_sets #=> Array
    #   resp.supported_character_sets[0].character_set_name #=> String
    #   resp.supported_character_sets[0].character_set_description #=> String
    #   resp.supported_nchar_character_sets #=> Array
    #   resp.supported_nchar_character_sets[0].character_set_name #=> String
    #   resp.supported_nchar_character_sets[0].character_set_description #=> String
    #   resp.valid_upgrade_target #=> Array
    #   resp.valid_upgrade_target[0].engine #=> String
    #   resp.valid_upgrade_target[0].engine_version #=> String
    #   resp.valid_upgrade_target[0].description #=> String
    #   resp.valid_upgrade_target[0].auto_upgrade #=> Boolean
    #   resp.valid_upgrade_target[0].is_major_version_upgrade #=> Boolean
    #   resp.valid_upgrade_target[0].supported_engine_modes #=> Array
    #   resp.valid_upgrade_target[0].supported_engine_modes[0] #=> String
    #   resp.valid_upgrade_target[0].supports_parallel_query #=> Boolean
    #   resp.valid_upgrade_target[0].supports_global_databases #=> Boolean
    #   resp.valid_upgrade_target[0].supports_babelfish #=> Boolean
    #   resp.valid_upgrade_target[0].supports_limitless_database #=> Boolean
    #   resp.valid_upgrade_target[0].supports_local_write_forwarding #=> Boolean
    #   resp.valid_upgrade_target[0].supports_integrations #=> Boolean
    #   resp.supported_timezones #=> Array
    #   resp.supported_timezones[0].timezone_name #=> String
    #   resp.exportable_log_types #=> Array
    #   resp.exportable_log_types[0] #=> String
    #   resp.supports_log_exports_to_cloudwatch_logs #=> Boolean
    #   resp.supports_read_replica #=> Boolean
    #   resp.supported_engine_modes #=> Array
    #   resp.supported_engine_modes[0] #=> String
    #   resp.supported_feature_names #=> Array
    #   resp.supported_feature_names[0] #=> String
    #   resp.status #=> String
    #   resp.supports_parallel_query #=> Boolean
    #   resp.supports_global_databases #=> Boolean
    #   resp.major_engine_version #=> String
    #   resp.database_installation_files_s3_bucket_name #=> String
    #   resp.database_installation_files_s3_prefix #=> String
    #   resp.db_engine_version_arn #=> String
    #   resp.kms_key_id #=> String
    #   resp.create_time #=> Time
    #   resp.tag_list #=> Array
    #   resp.tag_list[0].key #=> String
    #   resp.tag_list[0].value #=> String
    #   resp.supports_babelfish #=> Boolean
    #   resp.custom_db_engine_version_manifest #=> String
    #   resp.supports_limitless_database #=> Boolean
    #   resp.supports_certificate_rotation_without_restart #=> Boolean
    #   resp.supported_ca_certificate_identifiers #=> Array
    #   resp.supported_ca_certificate_identifiers[0] #=> String
    #   resp.supports_local_write_forwarding #=> Boolean
    #   resp.supports_integrations #=> Boolean
    #   resp.serverless_v2_features_support.min_capacity #=> Float
    #   resp.serverless_v2_features_support.max_capacity #=> Float
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateCustomDBEngineVersion AWS API Documentation
    #
    # @overload create_custom_db_engine_version(params = {})
    # @param [Hash] params ({})
    def create_custom_db_engine_version(params = {}, options = {})
      req = build_request(:create_custom_db_engine_version, params)
      req.send_request(options)
    end

    # Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster.
    #
    # If you create an Aurora DB cluster, the request creates an empty
    # cluster. You must explicitly create the writer instance for your DB
    # cluster using the [CreateDBInstance][1] operation. If you create a
    # Multi-AZ DB cluster, the request creates a writer and two reader DB
    # instances for you, each in a different Availability Zone.
    #
    # You can use the `ReplicationSourceIdentifier` parameter to create an
    # Amazon Aurora DB cluster as a read replica of another DB cluster or
    # Amazon RDS for MySQL or PostgreSQL DB instance. For more information
    # about Amazon Aurora, see [What is Amazon Aurora?][2] in the *Amazon
    # Aurora User Guide*.
    #
    # You can also use the `ReplicationSourceIdentifier` parameter to create
    # a Multi-AZ DB cluster read replica with an RDS for MySQL or PostgreSQL
    # DB instance as the source. For more information about Multi-AZ DB
    # clusters, see [Multi-AZ DB cluster deployments][3] in the *Amazon RDS
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [3]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [Array<String>] :availability_zones
    #   A list of Availability Zones (AZs) where you specifically want to
    #   create DB instances in the DB cluster.
    #
    #   For the first three DB instances that you create, RDS distributes each
    #   DB instance to a different AZ that you specify. For additional DB
    #   instances that you create, RDS randomly distributes them to the AZs
    #   that you specified. For example, if you create a DB cluster with one
    #   writer instance and three reader instances, RDS might distribute the
    #   writer instance to AZ 1, the first reader instance to AZ 2, the second
    #   reader instance to AZ 3, and the third reader instance to either AZ 1,
    #   AZ 2, or AZ 3.
    #
    #   For more information, see [Availability Zones][1] and [High
    #   availability for Aurora DB instances][2] in the *Amazon Aurora User
    #   Guide*.
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    #   Constraints:
    #
    #   * Can't specify more than three AZs.
    #
    #   ^
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html#Concepts.RegionsAndAvailabilityZones.AvailabilityZones
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Concepts.AuroraHighAvailability.Instances
    #
    # @option params [Integer] :backup_retention_period
    #   The number of days for which automated backups are retained.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Default: `1`
    #
    #   Constraints:
    #
    #   * Must be a value from 1 to 35.
    #
    #   ^
    #
    # @option params [String] :character_set_name
    #   The name of the character set (`CharacterSet`) to associate the DB
    #   cluster with.
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    # @option params [String] :database_name
    #   The name for your database of up to 64 alphanumeric characters. A
    #   database named `postgres` is always created. If this parameter is
    #   specified, an additional database with this name is created.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [required, String] :db_cluster_identifier
    #   The identifier for this DB cluster. This parameter is stored as a
    #   lowercase string.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Constraints:
    #
    #   * Must contain from 1 to 63 (for Aurora DB clusters) or 1 to 52 (for
    #     Multi-AZ DB clusters) letters, numbers, or hyphens.
    #
    #   * First character must be a letter.
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens.
    #
    #   Example: `my-cluster1`
    #
    # @option params [String] :db_cluster_parameter_group_name
    #   The name of the DB cluster parameter group to associate with this DB
    #   cluster. If you don't specify a value, then the default DB cluster
    #   parameter group for the specified DB engine and version is used.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Constraints:
    #
    #   * If supplied, must match the name of an existing DB cluster parameter
    #     group.
    #
    #   ^
    #
    # @option params [Array<String>] :vpc_security_group_ids
    #   A list of EC2 VPC security groups to associate with this DB cluster.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [String] :db_subnet_group_name
    #   A DB subnet group to associate with this DB cluster.
    #
    #   This setting is required to create a Multi-AZ DB cluster.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Constraints:
    #
    #   * Must match the name of an existing DB subnet group.
    #
    #   ^
    #
    #   Example: `mydbsubnetgroup`
    #
    # @option params [required, String] :engine
    #   The database engine to use for this DB cluster.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Valid Values:
    #
    #   * `aurora-mysql`
    #
    #   * `aurora-postgresql`
    #
    #   * `mysql`
    #
    #   * `postgres`
    #
    #   * `neptune` - For information about using Amazon Neptune, see the [
    #     *Amazon Neptune User Guide* ][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/neptune/latest/userguide/intro.html
    #
    # @option params [String] :engine_version
    #   The version number of the database engine to use.
    #
    #   To list all of the available engine versions for Aurora MySQL version
    #   2 (5.7-compatible) and version 3 (MySQL 8.0-compatible), use the
    #   following command:
    #
    #   `aws rds describe-db-engine-versions --engine aurora-mysql --query
    #   "DBEngineVersions[].EngineVersion"`
    #
    #   You can supply either `5.7` or `8.0` to use the default engine version
    #   for Aurora MySQL version 2 or version 3, respectively.
    #
    #   To list all of the available engine versions for Aurora PostgreSQL,
    #   use the following command:
    #
    #   `aws rds describe-db-engine-versions --engine aurora-postgresql
    #   --query "DBEngineVersions[].EngineVersion"`
    #
    #   To list all of the available engine versions for RDS for MySQL, use
    #   the following command:
    #
    #   `aws rds describe-db-engine-versions --engine mysql --query
    #   "DBEngineVersions[].EngineVersion"`
    #
    #   To list all of the available engine versions for RDS for PostgreSQL,
    #   use the following command:
    #
    #   `aws rds describe-db-engine-versions --engine postgres --query
    #   "DBEngineVersions[].EngineVersion"`
    #
    #   For information about a specific engine, see the following topics:
    #
    #   * Aurora MySQL - see [Database engine updates for Amazon Aurora
    #     MySQL][1] in the *Amazon Aurora User Guide*.
    #
    #   * Aurora PostgreSQL - see [Amazon Aurora PostgreSQL releases and
    #     engine versions][2] in the *Amazon Aurora User Guide*.
    #
    #   * RDS for MySQL - see [Amazon RDS for MySQL][3] in the *Amazon RDS
    #     User Guide*.
    #
    #   * RDS for PostgreSQL - see [Amazon RDS for PostgreSQL][4] in the
    #     *Amazon RDS User Guide*.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html
    #   [3]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt
    #   [4]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts
    #
    # @option params [Integer] :port
    #   The port number on which the instances in the DB cluster accept
    #   connections.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Valid Values: `1150-65535`
    #
    #   Default:
    #
    #   * RDS for MySQL and Aurora MySQL - `3306`
    #
    #   * RDS for PostgreSQL and Aurora PostgreSQL - `5432`
    #
    # @option params [String] :master_username
    #   The name of the master user for the DB cluster.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Constraints:
    #
    #   * Must be 1 to 16 letters or numbers.
    #
    #   * First character must be a letter.
    #
    #   * Can't be a reserved word for the chosen database engine.
    #
    # @option params [String] :master_user_password
    #   The password for the master database user.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Constraints:
    #
    #   * Must contain from 8 to 41 characters.
    #
    #   * Can contain any printable ASCII character except "/", """, or
    #     "@".
    #
    #   * Can't be specified if `ManageMasterUserPassword` is turned on.
    #
    # @option params [String] :option_group_name
    #   The option group to associate the DB cluster with.
    #
    #   DB clusters are associated with a default option group that can't be
    #   modified.
    #
    # @option params [String] :preferred_backup_window
    #   The daily time range during which automated backups are created if
    #   automated backups are enabled using the `BackupRetentionPeriod`
    #   parameter.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   The default is a 30-minute window selected at random from an 8-hour
    #   block of time for each Amazon Web Services Region. To view the time
    #   blocks available, see [ Backup window][1] in the *Amazon Aurora User
    #   Guide*.
    #
    #   Constraints:
    #
    #   * Must be in the format `hh24:mi-hh24:mi`.
    #
    #   * Must be in Universal Coordinated Time (UTC).
    #
    #   * Must not conflict with the preferred maintenance window.
    #
    #   * Must be at least 30 minutes.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow
    #
    # @option params [String] :preferred_maintenance_window
    #   The weekly time range during which system maintenance can occur.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   The default is a 30-minute window selected at random from an 8-hour
    #   block of time for each Amazon Web Services Region, occurring on a
    #   random day of the week. To see the time blocks available, see [
    #   Adjusting the Preferred DB Cluster Maintenance Window][1] in the
    #   *Amazon Aurora User Guide*.
    #
    #   Constraints:
    #
    #   * Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
    #
    #   * Days must be one of `Mon | Tue | Wed | Thu | Fri | Sat | Sun`.
    #
    #   * Must be in Universal Coordinated Time (UTC).
    #
    #   * Must be at least 30 minutes.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora
    #
    # @option params [String] :replication_source_identifier
    #   The Amazon Resource Name (ARN) of the source DB instance or DB cluster
    #   if this DB cluster is created as a read replica.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [Array<Types::Tag>] :tags
    #   Tags to assign to the DB cluster.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [Boolean] :storage_encrypted
    #   Specifies whether the DB cluster is encrypted.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [String] :kms_key_id
    #   The Amazon Web Services KMS key identifier for an encrypted DB
    #   cluster.
    #
    #   The Amazon Web Services KMS key identifier is the key ARN, key ID,
    #   alias ARN, or alias name for the KMS key. To use a KMS key in a
    #   different Amazon Web Services account, specify the key ARN or alias
    #   ARN.
    #
    #   When a KMS key isn't specified in `KmsKeyId`:
    #
    #   * If `ReplicationSourceIdentifier` identifies an encrypted source,
    #     then Amazon RDS uses the KMS key used to encrypt the source.
    #     Otherwise, Amazon RDS uses your default KMS key.
    #
    #   * If the `StorageEncrypted` parameter is enabled and
    #     `ReplicationSourceIdentifier` isn't specified, then Amazon RDS uses
    #     your default KMS key.
    #
    #   There is a default KMS key for your Amazon Web Services account. Your
    #   Amazon Web Services account has a different default KMS key for each
    #   Amazon Web Services Region.
    #
    #   If you create a read replica of an encrypted DB cluster in another
    #   Amazon Web Services Region, make sure to set `KmsKeyId` to a KMS key
    #   identifier that is valid in the destination Amazon Web Services
    #   Region. This KMS key is used to encrypt the read replica in that
    #   Amazon Web Services Region.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [String] :pre_signed_url
    #   When you are replicating a DB cluster from one Amazon Web Services
    #   GovCloud (US) Region to another, an URL that contains a Signature
    #   Version 4 signed request for the `CreateDBCluster` operation to be
    #   called in the source Amazon Web Services Region where the DB cluster
    #   is replicated from. Specify `PreSignedUrl` only when you are
    #   performing cross-Region replication from an encrypted DB cluster.
    #
    #   The presigned URL must be a valid request for the `CreateDBCluster`
    #   API operation that can run in the source Amazon Web Services Region
    #   that contains the encrypted DB cluster to copy.
    #
    #   The presigned URL request must contain the following parameter values:
    #
    #   * `KmsKeyId` - The KMS key identifier for the KMS key to use to
    #     encrypt the copy of the DB cluster in the destination Amazon Web
    #     Services Region. This should refer to the same KMS key for both the
    #     `CreateDBCluster` operation that is called in the destination Amazon
    #     Web Services Region, and the operation contained in the presigned
    #     URL.
    #
    #   * `DestinationRegion` - The name of the Amazon Web Services Region
    #     that Aurora read replica will be created in.
    #
    #   * `ReplicationSourceIdentifier` - The DB cluster identifier for the
    #     encrypted DB cluster to be copied. This identifier must be in the
    #     Amazon Resource Name (ARN) format for the source Amazon Web Services
    #     Region. For example, if you are copying an encrypted DB cluster from
    #     the us-west-2 Amazon Web Services Region, then your
    #     `ReplicationSourceIdentifier` would look like Example:
    #     `arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1`.
    #
    #   To learn how to generate a Signature Version 4 signed request, see [
    #   Authenticating Requests: Using Query Parameters (Amazon Web Services
    #   Signature Version 4)][1] and [ Signature Version 4 Signing
    #   Process][2].
    #
    #   <note markdown="1"> If you are using an Amazon Web Services SDK tool or the CLI, you can
    #   specify `SourceRegion` (or `--source-region` for the CLI) instead of
    #   specifying `PreSignedUrl` manually. Specifying `SourceRegion`
    #   autogenerates a presigned URL that is a valid request for the
    #   operation that can run in the source Amazon Web Services Region.
    #
    #    </note>
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html
    #   [2]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
    #
    # @option params [Boolean] :enable_iam_database_authentication
    #   Specifies whether to enable mapping of Amazon Web Services Identity
    #   and Access Management (IAM) accounts to database accounts. By default,
    #   mapping isn't enabled.
    #
    #   For more information, see [ IAM Database Authentication][1] in the
    #   *Amazon Aurora User Guide* or [IAM database authentication for
    #   MariaDB, MySQL, and PostgreSQL][2] in the *Amazon RDS User Guide*.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html
    #
    # @option params [Integer] :backtrack_window
    #   The target backtrack window, in seconds. To disable backtracking, set
    #   this value to `0`.
    #
    #   Valid for Cluster Type: Aurora MySQL DB clusters only
    #
    #   Default: `0`
    #
    #   Constraints:
    #
    #   * If specified, this value must be set to a number from 0 to 259,200
    #     (72 hours).
    #
    #   ^
    #
    # @option params [Array<String>] :enable_cloudwatch_logs_exports
    #   The list of log types that need to be enabled for exporting to
    #   CloudWatch Logs.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   The following values are valid for each DB engine:
    #
    #   * Aurora MySQL - `audit | error | general | instance | slowquery |
    #     iam-db-auth-error`
    #
    #   * Aurora PostgreSQL - `instance | postgresql | iam-db-auth-error`
    #
    #   * RDS for MySQL - `error | general | slowquery | iam-db-auth-error`
    #
    #   * RDS for PostgreSQL - `postgresql | upgrade | iam-db-auth-error`
    #
    #   For more information about exporting CloudWatch Logs for Amazon RDS,
    #   see [Publishing Database Logs to Amazon CloudWatch Logs][1] in the
    #   *Amazon RDS User Guide*.
    #
    #   For more information about exporting CloudWatch Logs for Amazon
    #   Aurora, see [Publishing Database Logs to Amazon CloudWatch Logs][2] in
    #   the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch
    #
    # @option params [String] :engine_mode
    #   The DB engine mode of the DB cluster, either `provisioned` or
    #   `serverless`.
    #
    #   The `serverless` engine mode only applies for Aurora Serverless v1 DB
    #   clusters. Aurora Serverless v2 DB clusters use the `provisioned`
    #   engine mode.
    #
    #   For information about limitations and requirements for Serverless DB
    #   clusters, see the following sections in the *Amazon Aurora User
    #   Guide*:
    #
    #   * [Limitations of Aurora Serverless v1][1]
    #
    #   * [Requirements for Aurora Serverless v2][2]
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html
    #
    # @option params [Types::ScalingConfiguration] :scaling_configuration
    #   For DB clusters in `serverless` DB engine mode, the scaling properties
    #   of the DB cluster.
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    # @option params [Types::RdsCustomClusterConfiguration] :rds_custom_cluster_configuration
    #   Reserved for future use.
    #
    # @option params [Boolean] :deletion_protection
    #   Specifies whether the DB cluster has deletion protection enabled. The
    #   database can't be deleted when deletion protection is enabled. By
    #   default, deletion protection isn't enabled.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [String] :global_cluster_identifier
    #   The global cluster ID of an Aurora cluster that becomes the primary
    #   cluster in the new global database cluster.
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    # @option params [Boolean] :enable_http_endpoint
    #   Specifies whether to enable the HTTP endpoint for the DB cluster. By
    #   default, the HTTP endpoint isn't enabled.
    #
    #   When enabled, the HTTP endpoint provides a connectionless web service
    #   API (RDS Data API) for running SQL queries on the DB cluster. You can
    #   also query your database from inside the RDS console with the RDS
    #   query editor.
    #
    #   For more information, see [Using RDS Data API][1] in the *Amazon
    #   Aurora User Guide*.
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html
    #
    # @option params [Boolean] :copy_tags_to_snapshot
    #   Specifies whether to copy all tags from the DB cluster to snapshots of
    #   the DB cluster. The default is not to copy them.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [String] :domain
    #   The Active Directory directory ID to create the DB cluster in.
    #
    #   For Amazon Aurora DB clusters, Amazon RDS can use Kerberos
    #   authentication to authenticate users that connect to the DB cluster.
    #
    #   For more information, see [Kerberos authentication][1] in the *Amazon
    #   Aurora User Guide*.
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html
    #
    # @option params [String] :domain_iam_role_name
    #   The name of the IAM role to use when making API calls to the Directory
    #   Service.
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    # @option params [Boolean] :enable_global_write_forwarding
    #   Specifies whether to enable this DB cluster to forward write
    #   operations to the primary cluster of a global cluster (Aurora global
    #   database). By default, write operations are not allowed on Aurora DB
    #   clusters that are secondary clusters in an Aurora global database.
    #
    #   You can set this value only on Aurora DB clusters that are members of
    #   an Aurora global database. With this parameter enabled, a secondary
    #   cluster can forward writes to the current primary cluster, and the
    #   resulting changes are replicated back to this cluster. For the primary
    #   DB cluster of an Aurora global database, this value is used
    #   immediately if the primary is demoted by a global cluster API
    #   operation, but it does nothing until then.
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    # @option params [String] :db_cluster_instance_class
    #   The compute and memory capacity of each DB instance in the Multi-AZ DB
    #   cluster, for example `db.m6gd.xlarge`. Not all DB instance classes are
    #   available in all Amazon Web Services Regions, or for all database
    #   engines.
    #
    #   For the full list of DB instance classes and availability for your
    #   engine, see [DB instance class][1] in the *Amazon RDS User Guide*.
    #
    #   This setting is required to create a Multi-AZ DB cluster.
    #
    #   Valid for Cluster Type: Multi-AZ DB clusters only
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html
    #
    # @option params [Integer] :allocated_storage
    #   The amount of storage in gibibytes (GiB) to allocate to each DB
    #   instance in the Multi-AZ DB cluster.
    #
    #   Valid for Cluster Type: Multi-AZ DB clusters only
    #
    #   This setting is required to create a Multi-AZ DB cluster.
    #
    # @option params [String] :storage_type
    #   The storage type to associate with the DB cluster.
    #
    #   For information on storage types for Aurora DB clusters, see [Storage
    #   configurations for Amazon Aurora DB clusters][1]. For information on
    #   storage types for Multi-AZ DB clusters, see [Settings for creating
    #   Multi-AZ DB clusters][2].
    #
    #   This setting is required to create a Multi-AZ DB cluster.
    #
    #   When specified for a Multi-AZ DB cluster, a value for the `Iops`
    #   parameter is required.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Valid Values:
    #
    #   * Aurora DB clusters - `aurora | aurora-iopt1`
    #
    #   * Multi-AZ DB clusters - `io1 | io2 | gp3`
    #
    #   Default:
    #
    #   * Aurora DB clusters - `aurora`
    #
    #   * Multi-AZ DB clusters - `io1`
    #
    #   <note markdown="1"> When you create an Aurora DB cluster with the storage type set to
    #   `aurora-iopt1`, the storage type is returned in the response. The
    #   storage type isn't returned when you set it to `aurora`.
    #
    #    </note>
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings
    #
    # @option params [Integer] :iops
    #   The amount of Provisioned IOPS (input/output operations per second) to
    #   be initially allocated for each DB instance in the Multi-AZ DB
    #   cluster.
    #
    #   For information about valid IOPS values, see [Provisioned IOPS
    #   storage][1] in the *Amazon RDS User Guide*.
    #
    #   This setting is required to create a Multi-AZ DB cluster.
    #
    #   Valid for Cluster Type: Multi-AZ DB clusters only
    #
    #   Constraints:
    #
    #   * Must be a multiple between .5 and 50 of the storage amount for the
    #     DB cluster.
    #
    #   ^
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS
    #
    # @option params [Boolean] :publicly_accessible
    #   Specifies whether the DB cluster is publicly accessible.
    #
    #   When the DB cluster is publicly accessible and you connect from
    #   outside of the DB cluster's virtual private cloud (VPC), its Domain
    #   Name System (DNS) endpoint resolves to the public IP address. When you
    #   connect from within the same VPC as the DB cluster, the endpoint
    #   resolves to the private IP address. Access to the DB cluster is
    #   ultimately controlled by the security group it uses. That public
    #   access isn't permitted if the security group assigned to the DB
    #   cluster doesn't permit it.
    #
    #   When the DB cluster isn't publicly accessible, it is an internal DB
    #   cluster with a DNS name that resolves to a private IP address.
    #
    #   Valid for Cluster Type: Multi-AZ DB clusters only
    #
    #   Default: The default behavior varies depending on whether
    #   `DBSubnetGroupName` is specified.
    #
    #   If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible`
    #   isn't specified, the following applies:
    #
    #   * If the default VPC in the target Region doesn’t have an internet
    #     gateway attached to it, the DB cluster is private.
    #
    #   * If the default VPC in the target Region has an internet gateway
    #     attached to it, the DB cluster is public.
    #
    #   If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't
    #   specified, the following applies:
    #
    #   * If the subnets are part of a VPC that doesn’t have an internet
    #     gateway attached to it, the DB cluster is private.
    #
    #   * If the subnets are part of a VPC that has an internet gateway
    #     attached to it, the DB cluster is public.
    #
    # @option params [Boolean] :auto_minor_version_upgrade
    #   Specifies whether minor engine upgrades are applied automatically to
    #   the DB cluster during the maintenance window. By default, minor engine
    #   upgrades are applied automatically.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB cluster.
    #
    #   For more information about automatic minor version upgrades, see
    #   [Automatically upgrading the minor engine version][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades
    #
    # @option params [Integer] :monitoring_interval
    #   The interval, in seconds, between points when Enhanced Monitoring
    #   metrics are collected for the DB cluster. To turn off collecting
    #   Enhanced Monitoring metrics, specify `0`.
    #
    #   If `MonitoringRoleArn` is specified, also set `MonitoringInterval` to
    #   a value other than `0`.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
    #
    #   Default: `0`
    #
    # @option params [String] :monitoring_role_arn
    #   The Amazon Resource Name (ARN) for the IAM role that permits RDS to
    #   send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example
    #   is `arn:aws:iam:123456789012:role/emaccess`. For information on
    #   creating a monitoring role, see [Setting up and enabling Enhanced
    #   Monitoring][1] in the *Amazon RDS User Guide*.
    #
    #   If `MonitoringInterval` is set to a value other than `0`, supply a
    #   `MonitoringRoleArn` value.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling
    #
    # @option params [String] :database_insights_mode
    #   The mode of Database Insights to enable for the DB cluster.
    #
    #   If you set this value to `advanced`, you must also set the
    #   `PerformanceInsightsEnabled` parameter to `true` and the
    #   `PerformanceInsightsRetentionPeriod` parameter to 465.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [Boolean] :enable_performance_insights
    #   Specifies whether to turn on Performance Insights for the DB cluster.
    #
    #   For more information, see [ Using Amazon Performance Insights][1] in
    #   the *Amazon RDS User Guide*.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html
    #
    # @option params [String] :performance_insights_kms_key_id
    #   The Amazon Web Services KMS key identifier for encryption of
    #   Performance Insights data.
    #
    #   The Amazon Web Services KMS key identifier is the key ARN, key ID,
    #   alias ARN, or alias name for the KMS key.
    #
    #   If you don't specify a value for `PerformanceInsightsKMSKeyId`, then
    #   Amazon RDS uses your default KMS key. There is a default KMS key for
    #   your Amazon Web Services account. Your Amazon Web Services account has
    #   a different default KMS key for each Amazon Web Services Region.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [Integer] :performance_insights_retention_period
    #   The number of days to retain Performance Insights data.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Valid Values:
    #
    #   * `7`
    #
    #   * *month* * 31, where *month* is a number of months from 1-23.
    #     Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19
    #     months * 31)
    #
    #   * `731`
    #
    #   Default: `7` days
    #
    #   If you specify a retention period that isn't valid, such as `94`,
    #   Amazon RDS issues an error.
    #
    # @option params [Boolean] :enable_limitless_database
    #   Specifies whether to enable Aurora Limitless Database. You must enable
    #   Aurora Limitless Database to create a DB shard group.
    #
    #   Valid for: Aurora DB clusters only
    #
    #   <note markdown="1"> This setting is no longer used. Instead use the
    #   `ClusterScalabilityType` setting.
    #
    #    </note>
    #
    # @option params [Types::ServerlessV2ScalingConfiguration] :serverless_v2_scaling_configuration
    #   Contains the scaling configuration of an Aurora Serverless v2 DB
    #   cluster.
    #
    #   For more information, see [Using Amazon Aurora Serverless v2][1] in
    #   the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html
    #
    # @option params [String] :network_type
    #   The network type of the DB cluster.
    #
    #   The network type is determined by the `DBSubnetGroup` specified for
    #   the DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol
    #   or the IPv4 and the IPv6 protocols (`DUAL`).
    #
    #   For more information, see [ Working with a DB instance in a VPC][1] in
    #   the *Amazon Aurora User Guide.*
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    #   Valid Values: `IPV4 | DUAL`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html
    #
    # @option params [String] :cluster_scalability_type
    #   Specifies the scalability mode of the Aurora DB cluster. When set to
    #   `limitless`, the cluster operates as an Aurora Limitless Database.
    #   When set to `standard` (the default), the cluster uses normal DB
    #   instance creation.
    #
    #   Valid for: Aurora DB clusters only
    #
    #   <note markdown="1"> You can't modify this setting after you create the DB cluster.
    #
    #    </note>
    #
    # @option params [String] :db_system_id
    #   Reserved for future use.
    #
    # @option params [Boolean] :manage_master_user_password
    #   Specifies whether to manage the master user password with Amazon Web
    #   Services Secrets Manager.
    #
    #   For more information, see [Password management with Amazon Web
    #   Services Secrets Manager][1] in the *Amazon RDS User Guide* and
    #   [Password management with Amazon Web Services Secrets Manager][2] in
    #   the *Amazon Aurora User Guide.*
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Constraints:
    #
    #   * Can't manage the master user password with Amazon Web Services
    #     Secrets Manager if `MasterUserPassword` is specified.
    #
    #   ^
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html
    #
    # @option params [String] :master_user_secret_kms_key_id
    #   The Amazon Web Services KMS key identifier to encrypt a secret that is
    #   automatically generated and managed in Amazon Web Services Secrets
    #   Manager.
    #
    #   This setting is valid only if the master user password is managed by
    #   RDS in Amazon Web Services Secrets Manager for the DB cluster.
    #
    #   The Amazon Web Services KMS key identifier is the key ARN, key ID,
    #   alias ARN, or alias name for the KMS key. To use a KMS key in a
    #   different Amazon Web Services account, specify the key ARN or alias
    #   ARN.
    #
    #   If you don't specify `MasterUserSecretKmsKeyId`, then the
    #   `aws/secretsmanager` KMS key is used to encrypt the secret. If the
    #   secret is in a different Amazon Web Services account, then you can't
    #   use the `aws/secretsmanager` KMS key to encrypt the secret, and you
    #   must use a customer managed KMS key.
    #
    #   There is a default KMS key for your Amazon Web Services account. Your
    #   Amazon Web Services account has a different default KMS key for each
    #   Amazon Web Services Region.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [Boolean] :enable_local_write_forwarding
    #   Specifies whether read replicas can forward write operations to the
    #   writer DB instance in the DB cluster. By default, write operations
    #   aren't allowed on reader DB instances.
    #
    #   Valid for: Aurora DB clusters only
    #
    # @option params [String] :ca_certificate_identifier
    #   The CA certificate identifier to use for the DB cluster's server
    #   certificate.
    #
    #   For more information, see [Using SSL/TLS to encrypt a connection to a
    #   DB instance][1] in the *Amazon RDS User Guide*.
    #
    #   Valid for Cluster Type: Multi-AZ DB clusters
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html
    #
    # @option params [String] :engine_lifecycle_support
    #   The life cycle type for this DB cluster.
    #
    #   <note markdown="1"> By default, this value is set to `open-source-rds-extended-support`,
    #   which enrolls your DB cluster into Amazon RDS Extended Support. At the
    #   end of standard support, you can avoid charges for Extended Support by
    #   setting the value to `open-source-rds-extended-support-disabled`. In
    #   this case, creating the DB cluster will fail if the DB major version
    #   is past its end of standard support date.
    #
    #    </note>
    #
    #   You can use this setting to enroll your DB cluster into Amazon RDS
    #   Extended Support. With RDS Extended Support, you can run the selected
    #   major engine version on your DB cluster past the end of standard
    #   support for that engine version. For more information, see the
    #   following sections:
    #
    #   * Amazon Aurora - [Amazon RDS Extended Support with Amazon Aurora][1]
    #     in the *Amazon Aurora User Guide*
    #
    #   * Amazon RDS - [Amazon RDS Extended Support with Amazon RDS][2] in the
    #     *Amazon RDS User Guide*
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Valid Values: `open-source-rds-extended-support |
    #   open-source-rds-extended-support-disabled`
    #
    #   Default: `open-source-rds-extended-support`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
    #
    # @option params [String] :source_region
    #   The source region of the snapshot. This is only needed when the
    #   shapshot is encrypted and in a different region.
    #
    # @return [Types::CreateDBClusterResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDBClusterResult#db_cluster #db_cluster} => Types::DBCluster
    #
    #
    # @example Example: To create a MySQL 5.7-compatible DB cluster
    #
    #   # The following example creates a MySQL 5.7-compatible Aurora DB cluster.
    #
    #   resp = client.create_db_cluster({
    #     db_cluster_identifier: "sample-cluster", 
    #     db_subnet_group_name: "default", 
    #     engine: "aurora-mysql", 
    #     engine_version: "5.7.12", 
    #     master_user_password: "mypassword", 
    #     master_username: "admin", 
    #     vpc_security_group_ids: [
    #       "sg-0b91305example", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster: {
    #       allocated_storage: 1, 
    #       associated_roles: [
    #       ], 
    #       availability_zones: [
    #         "us-east-1a", 
    #         "us-east-1b", 
    #         "us-east-1e", 
    #       ], 
    #       backup_retention_period: 1, 
    #       cluster_create_time: Time.parse("2019-06-07T23:21:33.048Z"), 
    #       copy_tags_to_snapshot: false, 
    #       db_cluster_arn: "arn:aws:rds:us-east-1:123456789012:cluster:sample-cluster", 
    #       db_cluster_identifier: "sample-cluster", 
    #       db_cluster_members: [
    #       ], 
    #       db_cluster_parameter_group: "default.aurora-mysql5.7", 
    #       db_subnet_group: "default", 
    #       db_cluster_resource_id: "cluster-ANPAJ4AE5446DAEXAMPLE", 
    #       deletion_protection: false, 
    #       endpoint: "sample-cluster.cluster-cnpexample.us-east-1.rds.amazonaws.com", 
    #       engine: "aurora-mysql", 
    #       engine_mode: "provisioned", 
    #       engine_version: "5.7.12", 
    #       hosted_zone_id: "Z2R2ITUGPM61AM", 
    #       http_endpoint_enabled: false, 
    #       iam_database_authentication_enabled: false, 
    #       master_username: "master", 
    #       multi_az: false, 
    #       port: 3306, 
    #       preferred_backup_window: "09:12-09:42", 
    #       preferred_maintenance_window: "mon:04:31-mon:05:01", 
    #       read_replica_identifiers: [
    #       ], 
    #       reader_endpoint: "sample-cluster.cluster-ro-cnpexample.us-east-1.rds.amazonaws.com", 
    #       status: "creating", 
    #       storage_encrypted: false, 
    #       vpc_security_groups: [
    #         {
    #           status: "active", 
    #           vpc_security_group_id: "sg-0b91305example", 
    #         }, 
    #       ], 
    #     }, 
    #   }
    #
    # @example Example: To create a PostgreSQL-compatible DB cluster
    #
    #   # The following example creates a PostgreSQL-compatible Aurora DB cluster.
    #
    #   resp = client.create_db_cluster({
    #     db_cluster_identifier: "sample-pg-cluster", 
    #     db_subnet_group_name: "default", 
    #     engine: "aurora-postgresql", 
    #     master_user_password: "mypassword", 
    #     master_username: "admin", 
    #     vpc_security_group_ids: [
    #       "sg-0b91305example", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster: {
    #       allocated_storage: 1, 
    #       associated_roles: [
    #       ], 
    #       availability_zones: [
    #         "us-east-1a", 
    #         "us-east-1b", 
    #         "us-east-1c", 
    #       ], 
    #       backup_retention_period: 1, 
    #       cluster_create_time: Time.parse("2019-06-07T23:26:08.371Z"), 
    #       copy_tags_to_snapshot: false, 
    #       db_cluster_arn: "arn:aws:rds:us-east-1:123456789012:cluster:sample-pg-cluster", 
    #       db_cluster_identifier: "sample-pg-cluster", 
    #       db_cluster_members: [
    #       ], 
    #       db_cluster_parameter_group: "default.aurora-postgresql9.6", 
    #       db_subnet_group: "default", 
    #       db_cluster_resource_id: "cluster-ANPAJ4AE5446DAEXAMPLE", 
    #       deletion_protection: false, 
    #       endpoint: "sample-pg-cluster.cluster-cnpexample.us-east-1.rds.amazonaws.com", 
    #       engine: "aurora-postgresql", 
    #       engine_mode: "provisioned", 
    #       engine_version: "9.6.9", 
    #       hosted_zone_id: "Z2R2ITUGPM61AM", 
    #       http_endpoint_enabled: false, 
    #       iam_database_authentication_enabled: false, 
    #       master_username: "master", 
    #       multi_az: false, 
    #       port: 5432, 
    #       preferred_backup_window: "09:56-10:26", 
    #       preferred_maintenance_window: "wed:03:33-wed:04:03", 
    #       read_replica_identifiers: [
    #       ], 
    #       reader_endpoint: "sample-pg-cluster.cluster-ro-cnpexample.us-east-1.rds.amazonaws.com", 
    #       status: "creating", 
    #       storage_encrypted: false, 
    #       vpc_security_groups: [
    #         {
    #           status: "active", 
    #           vpc_security_group_id: "sg-0b91305example", 
    #         }, 
    #       ], 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_db_cluster({
    #     availability_zones: ["String"],
    #     backup_retention_period: 1,
    #     character_set_name: "String",
    #     database_name: "String",
    #     db_cluster_identifier: "String", # required
    #     db_cluster_parameter_group_name: "String",
    #     vpc_security_group_ids: ["String"],
    #     db_subnet_group_name: "String",
    #     engine: "String", # required
    #     engine_version: "String",
    #     port: 1,
    #     master_username: "String",
    #     master_user_password: "String",
    #     option_group_name: "String",
    #     preferred_backup_window: "String",
    #     preferred_maintenance_window: "String",
    #     replication_source_identifier: "String",
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #     storage_encrypted: false,
    #     kms_key_id: "String",
    #     pre_signed_url: "String",
    #     enable_iam_database_authentication: false,
    #     backtrack_window: 1,
    #     enable_cloudwatch_logs_exports: ["String"],
    #     engine_mode: "String",
    #     scaling_configuration: {
    #       min_capacity: 1,
    #       max_capacity: 1,
    #       auto_pause: false,
    #       seconds_until_auto_pause: 1,
    #       timeout_action: "String",
    #       seconds_before_timeout: 1,
    #     },
    #     rds_custom_cluster_configuration: {
    #       interconnect_subnet_id: "String",
    #       transit_gateway_multicast_domain_id: "String",
    #       replica_mode: "open-read-only", # accepts open-read-only, mounted
    #     },
    #     deletion_protection: false,
    #     global_cluster_identifier: "String",
    #     enable_http_endpoint: false,
    #     copy_tags_to_snapshot: false,
    #     domain: "String",
    #     domain_iam_role_name: "String",
    #     enable_global_write_forwarding: false,
    #     db_cluster_instance_class: "String",
    #     allocated_storage: 1,
    #     storage_type: "String",
    #     iops: 1,
    #     publicly_accessible: false,
    #     auto_minor_version_upgrade: false,
    #     monitoring_interval: 1,
    #     monitoring_role_arn: "String",
    #     database_insights_mode: "standard", # accepts standard, advanced
    #     enable_performance_insights: false,
    #     performance_insights_kms_key_id: "String",
    #     performance_insights_retention_period: 1,
    #     enable_limitless_database: false,
    #     serverless_v2_scaling_configuration: {
    #       min_capacity: 1.0,
    #       max_capacity: 1.0,
    #       seconds_until_auto_pause: 1,
    #     },
    #     network_type: "String",
    #     cluster_scalability_type: "standard", # accepts standard, limitless
    #     db_system_id: "String",
    #     manage_master_user_password: false,
    #     master_user_secret_kms_key_id: "String",
    #     enable_local_write_forwarding: false,
    #     ca_certificate_identifier: "String",
    #     engine_lifecycle_support: "String",
    #     source_region: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster.allocated_storage #=> Integer
    #   resp.db_cluster.availability_zones #=> Array
    #   resp.db_cluster.availability_zones[0] #=> String
    #   resp.db_cluster.backup_retention_period #=> Integer
    #   resp.db_cluster.character_set_name #=> String
    #   resp.db_cluster.database_name #=> String
    #   resp.db_cluster.db_cluster_identifier #=> String
    #   resp.db_cluster.db_cluster_parameter_group #=> String
    #   resp.db_cluster.db_subnet_group #=> String
    #   resp.db_cluster.status #=> String
    #   resp.db_cluster.automatic_restart_time #=> Time
    #   resp.db_cluster.percent_progress #=> String
    #   resp.db_cluster.earliest_restorable_time #=> Time
    #   resp.db_cluster.endpoint #=> String
    #   resp.db_cluster.reader_endpoint #=> String
    #   resp.db_cluster.custom_endpoints #=> Array
    #   resp.db_cluster.custom_endpoints[0] #=> String
    #   resp.db_cluster.multi_az #=> Boolean
    #   resp.db_cluster.engine #=> String
    #   resp.db_cluster.engine_version #=> String
    #   resp.db_cluster.latest_restorable_time #=> Time
    #   resp.db_cluster.port #=> Integer
    #   resp.db_cluster.master_username #=> String
    #   resp.db_cluster.db_cluster_option_group_memberships #=> Array
    #   resp.db_cluster.db_cluster_option_group_memberships[0].db_cluster_option_group_name #=> String
    #   resp.db_cluster.db_cluster_option_group_memberships[0].status #=> String
    #   resp.db_cluster.preferred_backup_window #=> String
    #   resp.db_cluster.preferred_maintenance_window #=> String
    #   resp.db_cluster.replication_source_identifier #=> String
    #   resp.db_cluster.read_replica_identifiers #=> Array
    #   resp.db_cluster.read_replica_identifiers[0] #=> String
    #   resp.db_cluster.status_infos #=> Array
    #   resp.db_cluster.status_infos[0].status_type #=> String
    #   resp.db_cluster.status_infos[0].normal #=> Boolean
    #   resp.db_cluster.status_infos[0].status #=> String
    #   resp.db_cluster.status_infos[0].message #=> String
    #   resp.db_cluster.db_cluster_members #=> Array
    #   resp.db_cluster.db_cluster_members[0].db_instance_identifier #=> String
    #   resp.db_cluster.db_cluster_members[0].is_cluster_writer #=> Boolean
    #   resp.db_cluster.db_cluster_members[0].db_cluster_parameter_group_status #=> String
    #   resp.db_cluster.db_cluster_members[0].promotion_tier #=> Integer
    #   resp.db_cluster.vpc_security_groups #=> Array
    #   resp.db_cluster.vpc_security_groups[0].vpc_security_group_id #=> String
    #   resp.db_cluster.vpc_security_groups[0].status #=> String
    #   resp.db_cluster.hosted_zone_id #=> String
    #   resp.db_cluster.storage_encrypted #=> Boolean
    #   resp.db_cluster.kms_key_id #=> String
    #   resp.db_cluster.db_cluster_resource_id #=> String
    #   resp.db_cluster.db_cluster_arn #=> String
    #   resp.db_cluster.associated_roles #=> Array
    #   resp.db_cluster.associated_roles[0].role_arn #=> String
    #   resp.db_cluster.associated_roles[0].status #=> String
    #   resp.db_cluster.associated_roles[0].feature_name #=> String
    #   resp.db_cluster.iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster.clone_group_id #=> String
    #   resp.db_cluster.cluster_create_time #=> Time
    #   resp.db_cluster.earliest_backtrack_time #=> Time
    #   resp.db_cluster.backtrack_window #=> Integer
    #   resp.db_cluster.backtrack_consumed_change_records #=> Integer
    #   resp.db_cluster.enabled_cloudwatch_logs_exports #=> Array
    #   resp.db_cluster.enabled_cloudwatch_logs_exports[0] #=> String
    #   resp.db_cluster.capacity #=> Integer
    #   resp.db_cluster.engine_mode #=> String
    #   resp.db_cluster.scaling_configuration_info.min_capacity #=> Integer
    #   resp.db_cluster.scaling_configuration_info.max_capacity #=> Integer
    #   resp.db_cluster.scaling_configuration_info.auto_pause #=> Boolean
    #   resp.db_cluster.scaling_configuration_info.seconds_until_auto_pause #=> Integer
    #   resp.db_cluster.scaling_configuration_info.timeout_action #=> String
    #   resp.db_cluster.scaling_configuration_info.seconds_before_timeout #=> Integer
    #   resp.db_cluster.rds_custom_cluster_configuration.interconnect_subnet_id #=> String
    #   resp.db_cluster.rds_custom_cluster_configuration.transit_gateway_multicast_domain_id #=> String
    #   resp.db_cluster.rds_custom_cluster_configuration.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_cluster.deletion_protection #=> Boolean
    #   resp.db_cluster.http_endpoint_enabled #=> Boolean
    #   resp.db_cluster.activity_stream_mode #=> String, one of "sync", "async"
    #   resp.db_cluster.activity_stream_status #=> String, one of "stopped", "starting", "started", "stopping"
    #   resp.db_cluster.activity_stream_kms_key_id #=> String
    #   resp.db_cluster.activity_stream_kinesis_stream_name #=> String
    #   resp.db_cluster.copy_tags_to_snapshot #=> Boolean
    #   resp.db_cluster.cross_account_clone #=> Boolean
    #   resp.db_cluster.domain_memberships #=> Array
    #   resp.db_cluster.domain_memberships[0].domain #=> String
    #   resp.db_cluster.domain_memberships[0].status #=> String
    #   resp.db_cluster.domain_memberships[0].fqdn #=> String
    #   resp.db_cluster.domain_memberships[0].iam_role_name #=> String
    #   resp.db_cluster.domain_memberships[0].ou #=> String
    #   resp.db_cluster.domain_memberships[0].auth_secret_arn #=> String
    #   resp.db_cluster.domain_memberships[0].dns_ips #=> Array
    #   resp.db_cluster.domain_memberships[0].dns_ips[0] #=> String
    #   resp.db_cluster.tag_list #=> Array
    #   resp.db_cluster.tag_list[0].key #=> String
    #   resp.db_cluster.tag_list[0].value #=> String
    #   resp.db_cluster.global_cluster_identifier #=> String
    #   resp.db_cluster.global_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "unknown"
    #   resp.db_cluster.global_write_forwarding_requested #=> Boolean
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable #=> Array
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable[0] #=> String
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable #=> Array
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable[0] #=> String
    #   resp.db_cluster.pending_modified_values.db_cluster_identifier #=> String
    #   resp.db_cluster.pending_modified_values.master_user_password #=> String
    #   resp.db_cluster.pending_modified_values.iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster.pending_modified_values.engine_version #=> String
    #   resp.db_cluster.pending_modified_values.backup_retention_period #=> Integer
    #   resp.db_cluster.pending_modified_values.allocated_storage #=> Integer
    #   resp.db_cluster.pending_modified_values.rds_custom_cluster_configuration.interconnect_subnet_id #=> String
    #   resp.db_cluster.pending_modified_values.rds_custom_cluster_configuration.transit_gateway_multicast_domain_id #=> String
    #   resp.db_cluster.pending_modified_values.rds_custom_cluster_configuration.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_cluster.pending_modified_values.iops #=> Integer
    #   resp.db_cluster.pending_modified_values.storage_type #=> String
    #   resp.db_cluster.pending_modified_values.certificate_details.ca_identifier #=> String
    #   resp.db_cluster.pending_modified_values.certificate_details.valid_till #=> Time
    #   resp.db_cluster.db_cluster_instance_class #=> String
    #   resp.db_cluster.storage_type #=> String
    #   resp.db_cluster.iops #=> Integer
    #   resp.db_cluster.publicly_accessible #=> Boolean
    #   resp.db_cluster.auto_minor_version_upgrade #=> Boolean
    #   resp.db_cluster.monitoring_interval #=> Integer
    #   resp.db_cluster.monitoring_role_arn #=> String
    #   resp.db_cluster.database_insights_mode #=> String, one of "standard", "advanced"
    #   resp.db_cluster.performance_insights_enabled #=> Boolean
    #   resp.db_cluster.performance_insights_kms_key_id #=> String
    #   resp.db_cluster.performance_insights_retention_period #=> Integer
    #   resp.db_cluster.serverless_v2_scaling_configuration.min_capacity #=> Float
    #   resp.db_cluster.serverless_v2_scaling_configuration.max_capacity #=> Float
    #   resp.db_cluster.serverless_v2_scaling_configuration.seconds_until_auto_pause #=> Integer
    #   resp.db_cluster.serverless_v2_platform_version #=> String
    #   resp.db_cluster.network_type #=> String
    #   resp.db_cluster.db_system_id #=> String
    #   resp.db_cluster.master_user_secret.secret_arn #=> String
    #   resp.db_cluster.master_user_secret.secret_status #=> String
    #   resp.db_cluster.master_user_secret.kms_key_id #=> String
    #   resp.db_cluster.io_optimized_next_allowed_modification_time #=> Time
    #   resp.db_cluster.local_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "requested"
    #   resp.db_cluster.aws_backup_recovery_point_arn #=> String
    #   resp.db_cluster.limitless_database.status #=> String, one of "active", "not-in-use", "enabled", "disabled", "enabling", "disabling", "modifying-max-capacity", "error"
    #   resp.db_cluster.limitless_database.min_required_acu #=> Float
    #   resp.db_cluster.storage_throughput #=> Integer
    #   resp.db_cluster.cluster_scalability_type #=> String, one of "standard", "limitless"
    #   resp.db_cluster.certificate_details.ca_identifier #=> String
    #   resp.db_cluster.certificate_details.valid_till #=> Time
    #   resp.db_cluster.engine_lifecycle_support #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBCluster AWS API Documentation
    #
    # @overload create_db_cluster(params = {})
    # @param [Hash] params ({})
    def create_db_cluster(params = {}, options = {})
      req = build_request(:create_db_cluster, params)
      req.send_request(options)
    end

    # Creates a new custom endpoint and associates it with an Amazon Aurora
    # DB cluster.
    #
    # <note markdown="1"> This action applies only to Aurora DB clusters.
    #
    #  </note>
    #
    # @option params [required, String] :db_cluster_identifier
    #   The DB cluster identifier of the DB cluster associated with the
    #   endpoint. This parameter is stored as a lowercase string.
    #
    # @option params [required, String] :db_cluster_endpoint_identifier
    #   The identifier to use for the new endpoint. This parameter is stored
    #   as a lowercase string.
    #
    # @option params [required, String] :endpoint_type
    #   The type of the endpoint, one of: `READER`, `WRITER`, `ANY`.
    #
    # @option params [Array<String>] :static_members
    #   List of DB instance identifiers that are part of the custom endpoint
    #   group.
    #
    # @option params [Array<String>] :excluded_members
    #   List of DB instance identifiers that aren't part of the custom
    #   endpoint group. All other eligible instances are reachable through the
    #   custom endpoint. This parameter is relevant only if the list of static
    #   members is empty.
    #
    # @option params [Array<Types::Tag>] :tags
    #   The tags to be assigned to the Amazon RDS resource.
    #
    # @return [Types::DBClusterEndpoint] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBClusterEndpoint#db_cluster_endpoint_identifier #db_cluster_endpoint_identifier} => String
    #   * {Types::DBClusterEndpoint#db_cluster_identifier #db_cluster_identifier} => String
    #   * {Types::DBClusterEndpoint#db_cluster_endpoint_resource_identifier #db_cluster_endpoint_resource_identifier} => String
    #   * {Types::DBClusterEndpoint#endpoint #endpoint} => String
    #   * {Types::DBClusterEndpoint#status #status} => String
    #   * {Types::DBClusterEndpoint#endpoint_type #endpoint_type} => String
    #   * {Types::DBClusterEndpoint#custom_endpoint_type #custom_endpoint_type} => String
    #   * {Types::DBClusterEndpoint#static_members #static_members} => Array&lt;String&gt;
    #   * {Types::DBClusterEndpoint#excluded_members #excluded_members} => Array&lt;String&gt;
    #   * {Types::DBClusterEndpoint#db_cluster_endpoint_arn #db_cluster_endpoint_arn} => String
    #
    #
    # @example Example: To create a custom DB cluster endpoint
    #
    #   # The following example creates a custom DB cluster endpoint and associate it with the specified Aurora DB cluster.
    #
    #   resp = client.create_db_cluster_endpoint({
    #     db_cluster_endpoint_identifier: "mycustomendpoint", 
    #     db_cluster_identifier: "mydbcluster", 
    #     endpoint_type: "reader", 
    #     static_members: [
    #       "dbinstance1", 
    #       "dbinstance2", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     custom_endpoint_type: "READER", 
    #     db_cluster_endpoint_arn: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:mycustomendpoint", 
    #     db_cluster_endpoint_identifier: "mycustomendpoint", 
    #     db_cluster_endpoint_resource_identifier: "cluster-endpoint-ANPAJ4AE5446DAEXAMPLE", 
    #     db_cluster_identifier: "mydbcluster", 
    #     endpoint: "mycustomendpoint.cluster-custom-cnpexample.us-east-1.rds.amazonaws.com", 
    #     endpoint_type: "CUSTOM", 
    #     excluded_members: [
    #     ], 
    #     static_members: [
    #       "dbinstance1", 
    #       "dbinstance2", 
    #     ], 
    #     status: "creating", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_db_cluster_endpoint({
    #     db_cluster_identifier: "String", # required
    #     db_cluster_endpoint_identifier: "String", # required
    #     endpoint_type: "String", # required
    #     static_members: ["String"],
    #     excluded_members: ["String"],
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_endpoint_identifier #=> String
    #   resp.db_cluster_identifier #=> String
    #   resp.db_cluster_endpoint_resource_identifier #=> String
    #   resp.endpoint #=> String
    #   resp.status #=> String
    #   resp.endpoint_type #=> String
    #   resp.custom_endpoint_type #=> String
    #   resp.static_members #=> Array
    #   resp.static_members[0] #=> String
    #   resp.excluded_members #=> Array
    #   resp.excluded_members[0] #=> String
    #   resp.db_cluster_endpoint_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterEndpoint AWS API Documentation
    #
    # @overload create_db_cluster_endpoint(params = {})
    # @param [Hash] params ({})
    def create_db_cluster_endpoint(params = {}, options = {})
      req = build_request(:create_db_cluster_endpoint, params)
      req.send_request(options)
    end

    # Creates a new DB cluster parameter group.
    #
    # Parameters in a DB cluster parameter group apply to all of the
    # instances in a DB cluster.
    #
    # A DB cluster parameter group is initially created with the default
    # parameters for the database engine used by instances in the DB
    # cluster. To provide custom values for any of the parameters, you must
    # modify the group after creating it using
    # `ModifyDBClusterParameterGroup`. Once you've created a DB cluster
    # parameter group, you need to associate it with your DB cluster using
    # `ModifyDBCluster`.
    #
    # When you associate a new DB cluster parameter group with a running
    # Aurora DB cluster, reboot the DB instances in the DB cluster without
    # failover for the new DB cluster parameter group and associated
    # settings to take effect.
    #
    # When you associate a new DB cluster parameter group with a running
    # Multi-AZ DB cluster, reboot the DB cluster without failover for the
    # new DB cluster parameter group and associated settings to take effect.
    #
    # After you create a DB cluster parameter group, you should wait at
    # least 5 minutes before creating your first DB cluster that uses that
    # DB cluster parameter group as the default parameter group. This allows
    # Amazon RDS to fully complete the create action before the DB cluster
    # parameter group is used as the default for a new DB cluster. This is
    # especially important for parameters that are critical when creating
    # the default database for a DB cluster, such as the character set for
    # the default database defined by the `character_set_database`
    # parameter. You can use the *Parameter Groups* option of the [Amazon
    # RDS console][1] or the `DescribeDBClusterParameters` operation to
    # verify that your DB cluster parameter group has been created or
    # modified.
    #
    # For more information on Amazon Aurora, see [ What is Amazon
    # Aurora?][2] in the *Amazon Aurora User Guide*.
    #
    # For more information on Multi-AZ DB clusters, see [ Multi-AZ DB
    # cluster deployments][3] in the *Amazon RDS User Guide*.
    #
    #
    #
    # [1]: https://console.aws.amazon.com/rds/
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [3]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [required, String] :db_cluster_parameter_group_name
    #   The name of the DB cluster parameter group.
    #
    #   Constraints:
    #
    #   * Must not match the name of an existing DB cluster parameter group.
    #
    #   ^
    #
    #   <note markdown="1"> This value is stored as a lowercase string.
    #
    #    </note>
    #
    # @option params [required, String] :db_parameter_group_family
    #   The DB cluster parameter group family name. A DB cluster parameter
    #   group can be associated with one and only one DB cluster parameter
    #   group family, and can be applied only to a DB cluster running a
    #   database engine and engine version compatible with that DB cluster
    #   parameter group family.
    #
    #   **Aurora MySQL**
    #
    #   Example: `aurora-mysql5.7`, `aurora-mysql8.0`
    #
    #   **Aurora PostgreSQL**
    #
    #   Example: `aurora-postgresql14`
    #
    #   **RDS for MySQL**
    #
    #   Example: `mysql8.0`
    #
    #   **RDS for PostgreSQL**
    #
    #   Example: `postgres13`
    #
    #   To list all of the available parameter group families for a DB engine,
    #   use the following command:
    #
    #   `aws rds describe-db-engine-versions --query
    #   "DBEngineVersions[].DBParameterGroupFamily" --engine <engine>`
    #
    #   For example, to list all of the available parameter group families for
    #   the Aurora PostgreSQL DB engine, use the following command:
    #
    #   `aws rds describe-db-engine-versions --query
    #   "DBEngineVersions[].DBParameterGroupFamily" --engine
    #   aurora-postgresql`
    #
    #   <note markdown="1"> The output contains duplicates.
    #
    #    </note>
    #
    #   The following are the valid DB engine values:
    #
    #   * `aurora-mysql`
    #
    #   * `aurora-postgresql`
    #
    #   * `mysql`
    #
    #   * `postgres`
    #
    # @option params [required, String] :description
    #   The description for the DB cluster parameter group.
    #
    # @option params [Array<Types::Tag>] :tags
    #   Tags to assign to the DB cluster parameter group.
    #
    # @return [Types::CreateDBClusterParameterGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDBClusterParameterGroupResult#db_cluster_parameter_group #db_cluster_parameter_group} => Types::DBClusterParameterGroup
    #
    #
    # @example Example: To create a DB cluster parameter group
    #
    #   # The following example creates a DB cluster parameter group.
    #
    #   resp = client.create_db_cluster_parameter_group({
    #     db_cluster_parameter_group_name: "mydbclusterparametergroup", 
    #     db_parameter_group_family: "aurora5.6", 
    #     description: "My new cluster parameter group", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster_parameter_group: {
    #       db_cluster_parameter_group_arn: "arn:aws:rds:us-east-1:123456789012:cluster-pg:mydbclusterparametergroup", 
    #       db_cluster_parameter_group_name: "mydbclusterparametergroup", 
    #       db_parameter_group_family: "aurora5.6", 
    #       description: "My new cluster parameter group", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_db_cluster_parameter_group({
    #     db_cluster_parameter_group_name: "String", # required
    #     db_parameter_group_family: "String", # required
    #     description: "String", # required
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_parameter_group.db_cluster_parameter_group_name #=> String
    #   resp.db_cluster_parameter_group.db_parameter_group_family #=> String
    #   resp.db_cluster_parameter_group.description #=> String
    #   resp.db_cluster_parameter_group.db_cluster_parameter_group_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroup AWS API Documentation
    #
    # @overload create_db_cluster_parameter_group(params = {})
    # @param [Hash] params ({})
    def create_db_cluster_parameter_group(params = {}, options = {})
      req = build_request(:create_db_cluster_parameter_group, params)
      req.send_request(options)
    end

    # Creates a snapshot of a DB cluster.
    #
    # For more information on Amazon Aurora, see [ What is Amazon
    # Aurora?][1] in the *Amazon Aurora User Guide*.
    #
    # For more information on Multi-AZ DB clusters, see [ Multi-AZ DB
    # cluster deployments][2] in the *Amazon RDS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [required, String] :db_cluster_snapshot_identifier
    #   The identifier of the DB cluster snapshot. This parameter is stored as
    #   a lowercase string.
    #
    #   Constraints:
    #
    #   * Must contain from 1 to 63 letters, numbers, or hyphens.
    #
    #   * First character must be a letter.
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens.
    #
    #   Example: `my-cluster1-snapshot1`
    #
    # @option params [required, String] :db_cluster_identifier
    #   The identifier of the DB cluster to create a snapshot for. This
    #   parameter isn't case-sensitive.
    #
    #   Constraints:
    #
    #   * Must match the identifier of an existing DBCluster.
    #
    #   ^
    #
    #   Example: `my-cluster1`
    #
    # @option params [Array<Types::Tag>] :tags
    #   The tags to be assigned to the DB cluster snapshot.
    #
    # @return [Types::CreateDBClusterSnapshotResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDBClusterSnapshotResult#db_cluster_snapshot #db_cluster_snapshot} => Types::DBClusterSnapshot
    #
    #
    # @example Example: To create a DB cluster snapshot
    #
    #   # The following example creates a DB cluster snapshot.
    #
    #   resp = client.create_db_cluster_snapshot({
    #     db_cluster_identifier: "mydbclustersnapshot", 
    #     db_cluster_snapshot_identifier: "mydbcluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster_snapshot: {
    #       allocated_storage: 1, 
    #       availability_zones: [
    #         "us-east-1a", 
    #         "us-east-1b", 
    #         "us-east-1e", 
    #       ], 
    #       cluster_create_time: Time.parse("2019-04-15T14:18:42.785Z"), 
    #       db_cluster_identifier: "mydbcluster", 
    #       db_cluster_snapshot_arn: "arn:aws:rds:us-east-1:123456789012:cluster-snapshot:mydbclustersnapshot", 
    #       db_cluster_snapshot_identifier: "mydbclustersnapshot", 
    #       engine: "aurora-mysql", 
    #       engine_version: "5.7.mysql_aurora.2.04.2", 
    #       iam_database_authentication_enabled: false, 
    #       kms_key_id: "arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE", 
    #       license_model: "aurora-mysql", 
    #       master_username: "myadmin", 
    #       percent_progress: 0, 
    #       port: 0, 
    #       snapshot_create_time: Time.parse("2019-06-18T21:21:00.469Z"), 
    #       snapshot_type: "manual", 
    #       status: "creating", 
    #       storage_encrypted: true, 
    #       vpc_id: "vpc-6594f31c", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_db_cluster_snapshot({
    #     db_cluster_snapshot_identifier: "String", # required
    #     db_cluster_identifier: "String", # required
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_snapshot.availability_zones #=> Array
    #   resp.db_cluster_snapshot.availability_zones[0] #=> String
    #   resp.db_cluster_snapshot.db_cluster_snapshot_identifier #=> String
    #   resp.db_cluster_snapshot.db_cluster_identifier #=> String
    #   resp.db_cluster_snapshot.snapshot_create_time #=> Time
    #   resp.db_cluster_snapshot.engine #=> String
    #   resp.db_cluster_snapshot.engine_mode #=> String
    #   resp.db_cluster_snapshot.allocated_storage #=> Integer
    #   resp.db_cluster_snapshot.status #=> String
    #   resp.db_cluster_snapshot.port #=> Integer
    #   resp.db_cluster_snapshot.vpc_id #=> String
    #   resp.db_cluster_snapshot.cluster_create_time #=> Time
    #   resp.db_cluster_snapshot.master_username #=> String
    #   resp.db_cluster_snapshot.engine_version #=> String
    #   resp.db_cluster_snapshot.license_model #=> String
    #   resp.db_cluster_snapshot.snapshot_type #=> String
    #   resp.db_cluster_snapshot.percent_progress #=> Integer
    #   resp.db_cluster_snapshot.storage_encrypted #=> Boolean
    #   resp.db_cluster_snapshot.kms_key_id #=> String
    #   resp.db_cluster_snapshot.db_cluster_snapshot_arn #=> String
    #   resp.db_cluster_snapshot.source_db_cluster_snapshot_arn #=> String
    #   resp.db_cluster_snapshot.iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster_snapshot.tag_list #=> Array
    #   resp.db_cluster_snapshot.tag_list[0].key #=> String
    #   resp.db_cluster_snapshot.tag_list[0].value #=> String
    #   resp.db_cluster_snapshot.db_system_id #=> String
    #   resp.db_cluster_snapshot.storage_type #=> String
    #   resp.db_cluster_snapshot.db_cluster_resource_id #=> String
    #   resp.db_cluster_snapshot.storage_throughput #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshot AWS API Documentation
    #
    # @overload create_db_cluster_snapshot(params = {})
    # @param [Hash] params ({})
    def create_db_cluster_snapshot(params = {}, options = {})
      req = build_request(:create_db_cluster_snapshot, params)
      req.send_request(options)
    end

    # Creates a new DB instance.
    #
    # The new DB instance can be an RDS DB instance, or it can be a DB
    # instance in an Aurora DB cluster. For an Aurora DB cluster, you can
    # call this operation multiple times to add more than one DB instance to
    # the cluster.
    #
    # For more information about creating an RDS DB instance, see [ Creating
    # an Amazon RDS DB instance][1] in the *Amazon RDS User Guide*.
    #
    # For more information about creating a DB instance in an Aurora DB
    # cluster, see [ Creating an Amazon Aurora DB cluster][2] in the *Amazon
    # Aurora User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html
    #
    # @option params [String] :db_name
    #   The meaning of this parameter differs according to the database engine
    #   you use.
    #
    #   Amazon Aurora MySQL
    #
    #   : The name of the database to create when the primary DB instance of
    #     the Aurora MySQL DB cluster is created. If this parameter isn't
    #     specified for an Aurora MySQL DB cluster, no database is created in
    #     the DB cluster.
    #
    #     Constraints:
    #
    #     * Must contain 1 to 64 alphanumeric characters.
    #
    #     * Must begin with a letter. Subsequent characters can be letters,
    #       underscores, or digits (0-9).
    #
    #     * Can't be a word reserved by the database engine.
    #
    #   Amazon Aurora PostgreSQL
    #
    #   : The name of the database to create when the primary DB instance of
    #     the Aurora PostgreSQL DB cluster is created. A database named
    #     `postgres` is always created. If this parameter is specified, an
    #     additional database with this name is created.
    #
    #     Constraints:
    #
    #     * It must contain 1 to 63 alphanumeric characters.
    #
    #     * Must begin with a letter. Subsequent characters can be letters,
    #       underscores, or digits (0 to 9).
    #
    #     * Can't be a word reserved by the database engine.
    #
    #   Amazon RDS Custom for Oracle
    #
    #   : The Oracle System ID (SID) of the created RDS Custom DB instance. If
    #     you don't specify a value, the default value is `ORCL` for non-CDBs
    #     and `RDSCDB` for CDBs.
    #
    #     Default: `ORCL`
    #
    #     Constraints:
    #
    #     * Must contain 1 to 8 alphanumeric characters.
    #
    #     * Must contain a letter.
    #
    #     * Can't be a word reserved by the database engine.
    #
    #   Amazon RDS Custom for SQL Server
    #
    #   : Not applicable. Must be null.
    #
    #   RDS for Db2
    #
    #   : The name of the database to create when the DB instance is created.
    #     If this parameter isn't specified, no database is created in the DB
    #     instance. In some cases, we recommend that you don't add a database
    #     name. For more information, see [Additional considerations][1] in
    #     the *Amazon RDS User Guide*.
    #
    #     Constraints:
    #
    #     * Must contain 1 to 64 letters or numbers.
    #
    #     * Must begin with a letter. Subsequent characters can be letters,
    #       underscores, or digits (0-9).
    #
    #     * Can't be a word reserved by the specified database engine.
    #
    #   RDS for MariaDB
    #
    #   : The name of the database to create when the DB instance is created.
    #     If this parameter isn't specified, no database is created in the DB
    #     instance.
    #
    #     Constraints:
    #
    #     * Must contain 1 to 64 letters or numbers.
    #
    #     * Must begin with a letter. Subsequent characters can be letters,
    #       underscores, or digits (0-9).
    #
    #     * Can't be a word reserved by the specified database engine.
    #
    #   RDS for MySQL
    #
    #   : The name of the database to create when the DB instance is created.
    #     If this parameter isn't specified, no database is created in the DB
    #     instance.
    #
    #     Constraints:
    #
    #     * Must contain 1 to 64 letters or numbers.
    #
    #     * Must begin with a letter. Subsequent characters can be letters,
    #       underscores, or digits (0-9).
    #
    #     * Can't be a word reserved by the specified database engine.
    #
    #   RDS for Oracle
    #
    #   : The Oracle System ID (SID) of the created DB instance. If you don't
    #     specify a value, the default value is `ORCL`. You can't specify the
    #     string `null`, or any other reserved word, for `DBName`.
    #
    #     Default: `ORCL`
    #
    #     Constraints:
    #
    #     * Can't be longer than 8 characters.
    #
    #     ^
    #
    #   RDS for PostgreSQL
    #
    #   : The name of the database to create when the DB instance is created.
    #     A database named `postgres` is always created. If this parameter is
    #     specified, an additional database with this name is created.
    #
    #     Constraints:
    #
    #     * Must contain 1 to 63 letters, numbers, or underscores.
    #
    #     * Must begin with a letter. Subsequent characters can be letters,
    #       underscores, or digits (0-9).
    #
    #     * Can't be a word reserved by the specified database engine.
    #
    #   RDS for SQL Server
    #
    #   : Not applicable. Must be null.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-db-instance-prereqs.html#db2-prereqs-additional-considerations
    #
    # @option params [required, String] :db_instance_identifier
    #   The identifier for this DB instance. This parameter is stored as a
    #   lowercase string.
    #
    #   Constraints:
    #
    #   * Must contain from 1 to 63 letters, numbers, or hyphens.
    #
    #   * First character must be a letter.
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens.
    #
    #   Example: `mydbinstance`
    #
    # @option params [Integer] :allocated_storage
    #   The amount of storage in gibibytes (GiB) to allocate for the DB
    #   instance.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. Aurora
    #   cluster volumes automatically grow as the amount of data in your
    #   database increases, though you are only charged for the space that you
    #   use in an Aurora cluster volume.
    #
    #   Amazon RDS Custom
    #
    #   : Constraints to the amount of storage for each storage type are the
    #     following:
    #
    #     * General Purpose (SSD) storage (gp2, gp3): Must be an integer from
    #       40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for
    #       SQL Server.
    #
    #     * Provisioned IOPS storage (io1, io2): Must be an integer from 40 to
    #       65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL
    #       Server.
    #
    #   RDS for Db2
    #
    #   : Constraints to the amount of storage for each storage type are the
    #     following:
    #
    #     * General Purpose (SSD) storage (gp3): Must be an integer from 20 to
    #       65536.
    #
    #     * Provisioned IOPS storage (io1, io2): Must be an integer from 100
    #       to 65536.
    #
    #   RDS for MariaDB
    #
    #   : Constraints to the amount of storage for each storage type are the
    #     following:
    #
    #     * General Purpose (SSD) storage (gp2, gp3): Must be an integer from
    #       20 to 65536.
    #
    #     * Provisioned IOPS storage (io1, io2): Must be an integer from 100
    #       to 65536.
    #
    #     * Magnetic storage (standard): Must be an integer from 5 to 3072.
    #
    #   RDS for MySQL
    #
    #   : Constraints to the amount of storage for each storage type are the
    #     following:
    #
    #     * General Purpose (SSD) storage (gp2, gp3): Must be an integer from
    #       20 to 65536.
    #
    #     * Provisioned IOPS storage (io1, io2): Must be an integer from 100
    #       to 65536.
    #
    #     * Magnetic storage (standard): Must be an integer from 5 to 3072.
    #
    #   RDS for Oracle
    #
    #   : Constraints to the amount of storage for each storage type are the
    #     following:
    #
    #     * General Purpose (SSD) storage (gp2, gp3): Must be an integer from
    #       20 to 65536.
    #
    #     * Provisioned IOPS storage (io1, io2): Must be an integer from 100
    #       to 65536.
    #
    #     * Magnetic storage (standard): Must be an integer from 10 to 3072.
    #
    #   RDS for PostgreSQL
    #
    #   : Constraints to the amount of storage for each storage type are the
    #     following:
    #
    #     * General Purpose (SSD) storage (gp2, gp3): Must be an integer from
    #       20 to 65536.
    #
    #     * Provisioned IOPS storage (io1, io2): Must be an integer from 100
    #       to 65536.
    #
    #     * Magnetic storage (standard): Must be an integer from 5 to 3072.
    #
    #   RDS for SQL Server
    #
    #   : Constraints to the amount of storage for each storage type are the
    #     following:
    #
    #     * General Purpose (SSD) storage (gp2, gp3):
    #
    #       * Enterprise and Standard editions: Must be an integer from 20 to
    #         16384.
    #
    #       * Web and Express editions: Must be an integer from 20 to 16384.
    #     * Provisioned IOPS storage (io1, io2):
    #
    #       * Enterprise and Standard editions: Must be an integer from 100 to
    #         16384.
    #
    #       * Web and Express editions: Must be an integer from 100 to 16384.
    #     * Magnetic storage (standard):
    #
    #       * Enterprise and Standard editions: Must be an integer from 20 to
    #         1024.
    #
    #       * Web and Express editions: Must be an integer from 20 to 1024.
    #
    # @option params [required, String] :db_instance_class
    #   The compute and memory capacity of the DB instance, for example
    #   `db.m5.large`. Not all DB instance classes are available in all Amazon
    #   Web Services Regions, or for all database engines. For the full list
    #   of DB instance classes, and availability for your engine, see [DB
    #   instance classes][1] in the *Amazon RDS User Guide* or [Aurora DB
    #   instance classes][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html
    #
    # @option params [required, String] :engine
    #   The database engine to use for this DB instance.
    #
    #   Not every database engine is available in every Amazon Web Services
    #   Region.
    #
    #   Valid Values:
    #
    #   * `aurora-mysql` (for Aurora MySQL DB instances)
    #
    #   * `aurora-postgresql` (for Aurora PostgreSQL DB instances)
    #
    #   * `custom-oracle-ee` (for RDS Custom for Oracle DB instances)
    #
    #   * `custom-oracle-ee-cdb` (for RDS Custom for Oracle DB instances)
    #
    #   * `custom-oracle-se2` (for RDS Custom for Oracle DB instances)
    #
    #   * `custom-oracle-se2-cdb` (for RDS Custom for Oracle DB instances)
    #
    #   * `custom-sqlserver-ee` (for RDS Custom for SQL Server DB instances)
    #
    #   * `custom-sqlserver-se` (for RDS Custom for SQL Server DB instances)
    #
    #   * `custom-sqlserver-web` (for RDS Custom for SQL Server DB instances)
    #
    #   * `custom-sqlserver-dev` (for RDS Custom for SQL Server DB instances)
    #
    #   * `db2-ae`
    #
    #   * `db2-se`
    #
    #   * `mariadb`
    #
    #   * `mysql`
    #
    #   * `oracle-ee`
    #
    #   * `oracle-ee-cdb`
    #
    #   * `oracle-se2`
    #
    #   * `oracle-se2-cdb`
    #
    #   * `postgres`
    #
    #   * `sqlserver-ee`
    #
    #   * `sqlserver-se`
    #
    #   * `sqlserver-ex`
    #
    #   * `sqlserver-web`
    #
    # @option params [String] :master_username
    #   The name for the master user.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. The name
    #   for the master user is managed by the DB cluster.
    #
    #   This setting is required for RDS DB instances.
    #
    #   Constraints:
    #
    #   * Must be 1 to 16 letters, numbers, or underscores.
    #
    #   * First character must be a letter.
    #
    #   * Can't be a reserved word for the chosen database engine.
    #
    # @option params [String] :master_user_password
    #   The password for the master user.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. The
    #   password for the master user is managed by the DB cluster.
    #
    #   Constraints:
    #
    #   * Can't be specified if `ManageMasterUserPassword` is turned on.
    #
    #   * Can include any printable ASCII character except "/", """, or
    #     "@". For RDS for Oracle, can't include the "&amp;" (ampersand)
    #     or the "'" (single quotes) character.
    #
    #   Length Constraints:
    #
    #   * RDS for Db2 - Must contain from 8 to 255 characters.
    #
    #   * RDS for MariaDB - Must contain from 8 to 41 characters.
    #
    #   * RDS for Microsoft SQL Server - Must contain from 8 to 128
    #     characters.
    #
    #   * RDS for MySQL - Must contain from 8 to 41 characters.
    #
    #   * RDS for Oracle - Must contain from 8 to 30 characters.
    #
    #   * RDS for PostgreSQL - Must contain from 8 to 128 characters.
    #
    # @option params [Array<String>] :db_security_groups
    #   A list of DB security groups to associate with this DB instance.
    #
    #   This setting applies to the legacy EC2-Classic platform, which is no
    #   longer used to create new DB instances. Use the `VpcSecurityGroupIds`
    #   setting instead.
    #
    # @option params [Array<String>] :vpc_security_group_ids
    #   A list of Amazon EC2 VPC security groups to associate with this DB
    #   instance.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. The
    #   associated list of EC2 VPC security groups is managed by the DB
    #   cluster.
    #
    #   Default: The default EC2 VPC security group for the DB subnet group's
    #   VPC.
    #
    # @option params [String] :availability_zone
    #   The Availability Zone (AZ) where the database will be created. For
    #   information on Amazon Web Services Regions and Availability Zones, see
    #   [Regions and Availability Zones][1].
    #
    #   For Amazon Aurora, each Aurora DB cluster hosts copies of its storage
    #   in three separate Availability Zones. Specify one of these
    #   Availability Zones. Aurora automatically chooses an appropriate
    #   Availability Zone if you don't specify one.
    #
    #   Default: A random, system-chosen Availability Zone in the endpoint's
    #   Amazon Web Services Region.
    #
    #   Constraints:
    #
    #   * The `AvailabilityZone` parameter can't be specified if the DB
    #     instance is a Multi-AZ deployment.
    #
    #   * The specified Availability Zone must be in the same Amazon Web
    #     Services Region as the current endpoint.
    #
    #   Example: `us-east-1d`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html
    #
    # @option params [String] :db_subnet_group_name
    #   A DB subnet group to associate with this DB instance.
    #
    #   Constraints:
    #
    #   * Must match the name of an existing DB subnet group.
    #
    #   ^
    #
    #   Example: `mydbsubnetgroup`
    #
    # @option params [String] :preferred_maintenance_window
    #   The time range each week during which system maintenance can occur.
    #   For more information, see [Amazon RDS Maintenance Window][1] in the
    #   *Amazon RDS User Guide.*
    #
    #   The default is a 30-minute window selected at random from an 8-hour
    #   block of time for each Amazon Web Services Region, occurring on a
    #   random day of the week.
    #
    #   Constraints:
    #
    #   * Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
    #
    #   * The day values must be `mon | tue | wed | thu | fri | sat | sun`.
    #
    #   * Must be in Universal Coordinated Time (UTC).
    #
    #   * Must not conflict with the preferred backup window.
    #
    #   * Must be at least 30 minutes.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance
    #
    # @option params [String] :db_parameter_group_name
    #   The name of the DB parameter group to associate with this DB instance.
    #   If you don't specify a value, then Amazon RDS uses the default DB
    #   parameter group for the specified DB engine and version.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Constraints:
    #
    #   * Must be 1 to 255 letters, numbers, or hyphens.
    #
    #   * The first character must be a letter.
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens.
    #
    # @option params [Integer] :backup_retention_period
    #   The number of days for which automated backups are retained. Setting
    #   this parameter to a positive number enables backups. Setting this
    #   parameter to `0` disables automated backups.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. The
    #   retention period for automated backups is managed by the DB cluster.
    #
    #   Default: `1`
    #
    #   Constraints:
    #
    #   * Must be a value from 0 to 35.
    #
    #   * Can't be set to 0 if the DB instance is a source to read replicas.
    #
    #   * Can't be set to 0 for an RDS Custom for Oracle DB instance.
    #
    # @option params [String] :preferred_backup_window
    #   The daily time range during which automated backups are created if
    #   automated backups are enabled, using the `BackupRetentionPeriod`
    #   parameter. The default is a 30-minute window selected at random from
    #   an 8-hour block of time for each Amazon Web Services Region. For more
    #   information, see [Backup window][1] in the *Amazon RDS User Guide*.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. The daily
    #   time range for creating automated backups is managed by the DB
    #   cluster.
    #
    #   Constraints:
    #
    #   * Must be in the format `hh24:mi-hh24:mi`.
    #
    #   * Must be in Universal Coordinated Time (UTC).
    #
    #   * Must not conflict with the preferred maintenance window.
    #
    #   * Must be at least 30 minutes.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow
    #
    # @option params [Integer] :port
    #   The port number on which the database accepts connections.
    #
    #   This setting doesn't apply to Aurora DB instances. The port number is
    #   managed by the cluster.
    #
    #   Valid Values: `1150-65535`
    #
    #   Default:
    #
    #   * RDS for Db2 - `50000`
    #
    #   * RDS for MariaDB - `3306`
    #
    #   * RDS for Microsoft SQL Server - `1433`
    #
    #   * RDS for MySQL - `3306`
    #
    #   * RDS for Oracle - `1521`
    #
    #   * RDS for PostgreSQL - `5432`
    #
    #   Constraints:
    #
    #   * For RDS for Microsoft SQL Server, the value can't be `1234`,
    #     `1434`, `3260`, `3343`, `3389`, `47001`, or `49152-49156`.
    #
    #   ^
    #
    # @option params [Boolean] :multi_az
    #   Specifies whether the DB instance is a Multi-AZ deployment. You can't
    #   set the `AvailabilityZone` parameter if the DB instance is a Multi-AZ
    #   deployment.
    #
    #   This setting doesn't apply to Amazon Aurora because the DB instance
    #   Availability Zones (AZs) are managed by the DB cluster.
    #
    # @option params [String] :engine_version
    #   The version number of the database engine to use.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. The version
    #   number of the database engine the DB instance uses is managed by the
    #   DB cluster.
    #
    #   For a list of valid engine versions, use the
    #   `DescribeDBEngineVersions` operation.
    #
    #   The following are the database engines and links to information about
    #   the major and minor versions that are available with Amazon RDS. Not
    #   every database engine is available for every Amazon Web Services
    #   Region.
    #
    #   Amazon RDS Custom for Oracle
    #
    #   : A custom engine version (CEV) that you have previously created. This
    #     setting is required for RDS Custom for Oracle. The CEV name has the
    #     following format: 19.*customized\_string*. A valid CEV name is
    #     `19.my_cev1`. For more information, see [ Creating an RDS Custom for
    #     Oracle DB instance][1] in the *Amazon RDS User Guide*.
    #
    #   Amazon RDS Custom for SQL Server
    #
    #   : See [RDS Custom for SQL Server general requirements][2] in the
    #     *Amazon RDS User Guide*.
    #
    #   RDS for Db2
    #
    #   : For information, see [Db2 on Amazon RDS versions][3] in the *Amazon
    #     RDS User Guide*.
    #
    #   RDS for MariaDB
    #
    #   : For information, see [MariaDB on Amazon RDS versions][4] in the
    #     *Amazon RDS User Guide*.
    #
    #   RDS for Microsoft SQL Server
    #
    #   : For information, see [Microsoft SQL Server versions on Amazon
    #     RDS][5] in the *Amazon RDS User Guide*.
    #
    #   RDS for MySQL
    #
    #   : For information, see [MySQL on Amazon RDS versions][6] in the
    #     *Amazon RDS User Guide*.
    #
    #   RDS for Oracle
    #
    #   : For information, see [Oracle Database Engine release notes][7] in
    #     the *Amazon RDS User Guide*.
    #
    #   RDS for PostgreSQL
    #
    #   : For information, see [Amazon RDS for PostgreSQL versions and
    #     extensions][8] in the *Amazon RDS User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html
    #   [3]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt
    #   [4]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt
    #   [5]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport
    #   [6]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt
    #   [7]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html
    #   [8]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts
    #
    # @option params [Boolean] :auto_minor_version_upgrade
    #   Specifies whether minor engine upgrades are applied automatically to
    #   the DB instance during the maintenance window. By default, minor
    #   engine upgrades are applied automatically.
    #
    #   If you create an RDS Custom DB instance, you must set
    #   `AutoMinorVersionUpgrade` to `false`.
    #
    #   For more information about automatic minor version upgrades, see
    #   [Automatically upgrading the minor engine version][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades
    #
    # @option params [String] :license_model
    #   The license model information for this DB instance.
    #
    #   <note markdown="1"> License models for RDS for Db2 require additional configuration. The
    #   bring your own license (BYOL) model requires a custom parameter group
    #   and an Amazon Web Services License Manager self-managed license. The
    #   Db2 license through Amazon Web Services Marketplace model requires an
    #   Amazon Web Services Marketplace subscription. For more information,
    #   see [Amazon RDS for Db2 licensing options][1] in the *Amazon RDS User
    #   Guide*.
    #
    #    The default for RDS for Db2 is `bring-your-own-license`.
    #
    #    </note>
    #
    #   This setting doesn't apply to Amazon Aurora or RDS Custom DB
    #   instances.
    #
    #   Valid Values:
    #
    #   * RDS for Db2 - `bring-your-own-license | marketplace-license`
    #
    #   * RDS for MariaDB - `general-public-license`
    #
    #   * RDS for Microsoft SQL Server - `license-included`
    #
    #   * RDS for MySQL - `general-public-license`
    #
    #   * RDS for Oracle - `bring-your-own-license | license-included`
    #
    #   * RDS for PostgreSQL - `postgresql-license`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html
    #
    # @option params [Integer] :iops
    #   The amount of Provisioned IOPS (input/output operations per second) to
    #   initially allocate for the DB instance. For information about valid
    #   IOPS values, see [Amazon RDS DB instance storage][1] in the *Amazon
    #   RDS User Guide*.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. Storage is
    #   managed by the DB cluster.
    #
    #   Constraints:
    #
    #   * For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a
    #     multiple between .5 and 50 of the storage amount for the DB
    #     instance.
    #
    #   * For RDS for SQL Server - Must be a multiple between 1 and 50 of the
    #     storage amount for the DB instance.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html
    #
    # @option params [String] :option_group_name
    #   The option group to associate the DB instance with.
    #
    #   Permanent options, such as the TDE option for Oracle Advanced Security
    #   TDE, can't be removed from an option group. Also, that option group
    #   can't be removed from a DB instance after it is associated with a DB
    #   instance.
    #
    #   This setting doesn't apply to Amazon Aurora or RDS Custom DB
    #   instances.
    #
    # @option params [String] :character_set_name
    #   For supported engines, the character set (`CharacterSet`) to associate
    #   the DB instance with.
    #
    #   This setting doesn't apply to the following DB instances:
    #
    #   * Amazon Aurora - The character set is managed by the DB cluster. For
    #     more information, see `CreateDBCluster`.
    #
    #   * RDS Custom - However, if you need to change the character set, you
    #     can change it on the database itself.
    #
    # @option params [String] :nchar_character_set_name
    #   The name of the NCHAR character set for the Oracle DB instance.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [Boolean] :publicly_accessible
    #   Specifies whether the DB instance is publicly accessible.
    #
    #   When the DB instance is publicly accessible and you connect from
    #   outside of the DB instance's virtual private cloud (VPC), its Domain
    #   Name System (DNS) endpoint resolves to the public IP address. When you
    #   connect from within the same VPC as the DB instance, the endpoint
    #   resolves to the private IP address. Access to the DB instance is
    #   ultimately controlled by the security group it uses. That public
    #   access is not permitted if the security group assigned to the DB
    #   instance doesn't permit it.
    #
    #   When the DB instance isn't publicly accessible, it is an internal DB
    #   instance with a DNS name that resolves to a private IP address.
    #
    #   Default: The default behavior varies depending on whether
    #   `DBSubnetGroupName` is specified.
    #
    #   If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible`
    #   isn't specified, the following applies:
    #
    #   * If the default VPC in the target Region doesn’t have an internet
    #     gateway attached to it, the DB instance is private.
    #
    #   * If the default VPC in the target Region has an internet gateway
    #     attached to it, the DB instance is public.
    #
    #   If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't
    #   specified, the following applies:
    #
    #   * If the subnets are part of a VPC that doesn’t have an internet
    #     gateway attached to it, the DB instance is private.
    #
    #   * If the subnets are part of a VPC that has an internet gateway
    #     attached to it, the DB instance is public.
    #
    # @option params [Array<Types::Tag>] :tags
    #   Tags to assign to the DB instance.
    #
    # @option params [String] :db_cluster_identifier
    #   The identifier of the DB cluster that this DB instance will belong to.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [String] :storage_type
    #   The storage type to associate with the DB instance.
    #
    #   If you specify `io1`, `io2`, or `gp3`, you must also include a value
    #   for the `Iops` parameter.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. Storage is
    #   managed by the DB cluster.
    #
    #   Valid Values: `gp2 | gp3 | io1 | io2 | standard`
    #
    #   Default: `io1`, if the `Iops` parameter is specified. Otherwise,
    #   `gp3`.
    #
    # @option params [String] :tde_credential_arn
    #   The ARN from the key store with which to associate the instance for
    #   TDE encryption.
    #
    #   This setting doesn't apply to Amazon Aurora or RDS Custom DB
    #   instances.
    #
    # @option params [String] :tde_credential_password
    #   The password for the given ARN from the key store in order to access
    #   the device.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [Boolean] :storage_encrypted
    #   Specifes whether the DB instance is encrypted. By default, it isn't
    #   encrypted.
    #
    #   For RDS Custom DB instances, either enable this setting or leave it
    #   unset. Otherwise, Amazon RDS reports an error.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. The
    #   encryption for DB instances is managed by the DB cluster.
    #
    # @option params [String] :kms_key_id
    #   The Amazon Web Services KMS key identifier for an encrypted DB
    #   instance.
    #
    #   The Amazon Web Services KMS key identifier is the key ARN, key ID,
    #   alias ARN, or alias name for the KMS key. To use a KMS key in a
    #   different Amazon Web Services account, specify the key ARN or alias
    #   ARN.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. The Amazon
    #   Web Services KMS key identifier is managed by the DB cluster. For more
    #   information, see `CreateDBCluster`.
    #
    #   If `StorageEncrypted` is enabled, and you do not specify a value for
    #   the `KmsKeyId` parameter, then Amazon RDS uses your default KMS key.
    #   There is a default KMS key for your Amazon Web Services account. Your
    #   Amazon Web Services account has a different default KMS key for each
    #   Amazon Web Services Region.
    #
    #   For Amazon RDS Custom, a KMS key is required for DB instances. For
    #   most RDS engines, if you leave this parameter empty while enabling
    #   `StorageEncrypted`, the engine uses the default KMS key. However, RDS
    #   Custom doesn't use the default key when this parameter is empty. You
    #   must explicitly specify a key.
    #
    # @option params [String] :domain
    #   The Active Directory directory ID to create the DB instance in.
    #   Currently, you can create only Db2, MySQL, Microsoft SQL Server,
    #   Oracle, and PostgreSQL DB instances in an Active Directory Domain.
    #
    #   For more information, see [ Kerberos Authentication][1] in the *Amazon
    #   RDS User Guide*.
    #
    #   This setting doesn't apply to the following DB instances:
    #
    #   * Amazon Aurora (The domain is managed by the DB cluster.)
    #
    #   * RDS Custom
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html
    #
    # @option params [String] :domain_fqdn
    #   The fully qualified domain name (FQDN) of an Active Directory domain.
    #
    #   Constraints:
    #
    #   * Can't be longer than 64 characters.
    #
    #   ^
    #
    #   Example: `mymanagedADtest.mymanagedAD.mydomain`
    #
    # @option params [String] :domain_ou
    #   The Active Directory organizational unit for your DB instance to join.
    #
    #   Constraints:
    #
    #   * Must be in the distinguished name format.
    #
    #   * Can't be longer than 64 characters.
    #
    #   Example:
    #   `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
    #
    # @option params [String] :domain_auth_secret_arn
    #   The ARN for the Secrets Manager secret with the credentials for the
    #   user joining the domain.
    #
    #   Example:
    #   `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
    #
    # @option params [Array<String>] :domain_dns_ips
    #   The IPv4 DNS IP addresses of your primary and secondary Active
    #   Directory domain controllers.
    #
    #   Constraints:
    #
    #   * Two IP addresses must be provided. If there isn't a secondary
    #     domain controller, use the IP address of the primary domain
    #     controller for both entries in the list.
    #
    #   ^
    #
    #   Example: `123.124.125.126,234.235.236.237`
    #
    # @option params [Boolean] :copy_tags_to_snapshot
    #   Specifies whether to copy tags from the DB instance to snapshots of
    #   the DB instance. By default, tags are not copied.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. Copying
    #   tags to snapshots is managed by the DB cluster. Setting this value for
    #   an Aurora DB instance has no effect on the DB cluster setting.
    #
    # @option params [Integer] :monitoring_interval
    #   The interval, in seconds, between points when Enhanced Monitoring
    #   metrics are collected for the DB instance. To disable collection of
    #   Enhanced Monitoring metrics, specify `0`.
    #
    #   If `MonitoringRoleArn` is specified, then you must set
    #   `MonitoringInterval` to a value other than `0`.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
    #
    #   Default: `0`
    #
    # @option params [String] :monitoring_role_arn
    #   The ARN for the IAM role that permits RDS to send enhanced monitoring
    #   metrics to Amazon CloudWatch Logs. For example,
    #   `arn:aws:iam:123456789012:role/emaccess`. For information on creating
    #   a monitoring role, see [Setting Up and Enabling Enhanced
    #   Monitoring][1] in the *Amazon RDS User Guide*.
    #
    #   If `MonitoringInterval` is set to a value other than `0`, then you
    #   must supply a `MonitoringRoleArn` value.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling
    #
    # @option params [String] :domain_iam_role_name
    #   The name of the IAM role to use when making API calls to the Directory
    #   Service.
    #
    #   This setting doesn't apply to the following DB instances:
    #
    #   * Amazon Aurora (The domain is managed by the DB cluster.)
    #
    #   * RDS Custom
    #
    # @option params [Integer] :promotion_tier
    #   The order of priority in which an Aurora Replica is promoted to the
    #   primary instance after a failure of the existing primary instance. For
    #   more information, see [ Fault Tolerance for an Aurora DB Cluster][1]
    #   in the *Amazon Aurora User Guide*.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Default: `1`
    #
    #   Valid Values: `0 - 15`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance
    #
    # @option params [String] :timezone
    #   The time zone of the DB instance. The time zone parameter is currently
    #   supported only by [RDS for Db2][1] and [RDS for SQL Server][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone
    #
    # @option params [Boolean] :enable_iam_database_authentication
    #   Specifies whether to enable mapping of Amazon Web Services Identity
    #   and Access Management (IAM) accounts to database accounts. By default,
    #   mapping isn't enabled.
    #
    #   For more information, see [ IAM Database Authentication for MySQL and
    #   PostgreSQL][1] in the *Amazon RDS User Guide*.
    #
    #   This setting doesn't apply to the following DB instances:
    #
    #   * Amazon Aurora (Mapping Amazon Web Services IAM accounts to database
    #     accounts is managed by the DB cluster.)
    #
    #   * RDS Custom
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html
    #
    # @option params [String] :database_insights_mode
    #   The mode of Database Insights to enable for the DB instance.
    #
    #   <note markdown="1"> Aurora DB instances inherit this value from the DB cluster, so you
    #   can't change this value.
    #
    #    </note>
    #
    # @option params [Boolean] :enable_performance_insights
    #   Specifies whether to enable Performance Insights for the DB instance.
    #   For more information, see [Using Amazon Performance Insights][1] in
    #   the *Amazon RDS User Guide*.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html
    #
    # @option params [String] :performance_insights_kms_key_id
    #   The Amazon Web Services KMS key identifier for encryption of
    #   Performance Insights data.
    #
    #   The Amazon Web Services KMS key identifier is the key ARN, key ID,
    #   alias ARN, or alias name for the KMS key.
    #
    #   If you don't specify a value for `PerformanceInsightsKMSKeyId`, then
    #   Amazon RDS uses your default KMS key. There is a default KMS key for
    #   your Amazon Web Services account. Your Amazon Web Services account has
    #   a different default KMS key for each Amazon Web Services Region.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [Integer] :performance_insights_retention_period
    #   The number of days to retain Performance Insights data.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Valid Values:
    #
    #   * `7`
    #
    #   * *month* * 31, where *month* is a number of months from 1-23.
    #     Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19
    #     months * 31)
    #
    #   * `731`
    #
    #   Default: `7` days
    #
    #   If you specify a retention period that isn't valid, such as `94`,
    #   Amazon RDS returns an error.
    #
    # @option params [Array<String>] :enable_cloudwatch_logs_exports
    #   The list of log types to enable for exporting to CloudWatch Logs. For
    #   more information, see [ Publishing Database Logs to Amazon CloudWatch
    #   Logs][1] in the *Amazon RDS User Guide*.
    #
    #   This setting doesn't apply to the following DB instances:
    #
    #   * Amazon Aurora (CloudWatch Logs exports are managed by the DB
    #     cluster.)
    #
    #   * RDS Custom
    #
    #   The following values are valid for each DB engine:
    #
    #   * RDS for Db2 - `diag.log | notify.log | iam-db-auth-error`
    #
    #   * RDS for MariaDB - `audit | error | general | slowquery |
    #     iam-db-auth-error`
    #
    #   * RDS for Microsoft SQL Server - `agent | error`
    #
    #   * RDS for MySQL - `audit | error | general | slowquery |
    #     iam-db-auth-error`
    #
    #   * RDS for Oracle - `alert | audit | listener | trace | oemagent`
    #
    #   * RDS for PostgreSQL - `postgresql | upgrade | iam-db-auth-error`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch
    #
    # @option params [Array<Types::ProcessorFeature>] :processor_features
    #   The number of CPU cores and the number of threads per core for the DB
    #   instance class of the DB instance.
    #
    #   This setting doesn't apply to Amazon Aurora or RDS Custom DB
    #   instances.
    #
    # @option params [Boolean] :deletion_protection
    #   Specifies whether the DB instance has deletion protection enabled. The
    #   database can't be deleted when deletion protection is enabled. By
    #   default, deletion protection isn't enabled. For more information, see
    #   [ Deleting a DB Instance][1].
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. You can
    #   enable or disable deletion protection for the DB cluster. For more
    #   information, see `CreateDBCluster`. DB instances in a DB cluster can
    #   be deleted even when deletion protection is enabled for the DB
    #   cluster.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html
    #
    # @option params [Integer] :max_allocated_storage
    #   The upper limit in gibibytes (GiB) to which Amazon RDS can
    #   automatically scale the storage of the DB instance.
    #
    #   For more information about this setting, including limitations that
    #   apply to it, see [ Managing capacity automatically with Amazon RDS
    #   storage autoscaling][1] in the *Amazon RDS User Guide*.
    #
    #   This setting doesn't apply to the following DB instances:
    #
    #   * Amazon Aurora (Storage is managed by the DB cluster.)
    #
    #   * RDS Custom
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling
    #
    # @option params [Boolean] :enable_customer_owned_ip
    #   Specifies whether to enable a customer-owned IP address (CoIP) for an
    #   RDS on Outposts DB instance.
    #
    #   A *CoIP* provides local or external connectivity to resources in your
    #   Outpost subnets through your on-premises network. For some use cases,
    #   a CoIP can provide lower latency for connections to the DB instance
    #   from outside of its virtual private cloud (VPC) on your local network.
    #
    #   For more information about RDS on Outposts, see [Working with Amazon
    #   RDS on Amazon Web Services Outposts][1] in the *Amazon RDS User
    #   Guide*.
    #
    #   For more information about CoIPs, see [Customer-owned IP addresses][2]
    #   in the *Amazon Web Services Outposts User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html
    #   [2]: https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing
    #
    # @option params [String] :custom_iam_instance_profile
    #   The instance profile associated with the underlying Amazon EC2
    #   instance of an RDS Custom DB instance.
    #
    #   This setting is required for RDS Custom.
    #
    #   Constraints:
    #
    #   * The profile must exist in your account.
    #
    #   * The profile must have an IAM role that Amazon EC2 has permissions to
    #     assume.
    #
    #   * The instance profile name and the associated IAM role name must
    #     start with the prefix `AWSRDSCustom`.
    #
    #   For the list of permissions required for the IAM role, see [ Configure
    #   IAM and your VPC][1] in the *Amazon RDS User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc
    #
    # @option params [String] :backup_target
    #   The location for storing automated backups and manual snapshots.
    #
    #   Valid Values:
    #
    #   * `local` (Dedicated Local Zone)
    #
    #   * `outposts` (Amazon Web Services Outposts)
    #
    #   * `region` (Amazon Web Services Region)
    #
    #   Default: `region`
    #
    #   For more information, see [Working with Amazon RDS on Amazon Web
    #   Services Outposts][1] in the *Amazon RDS User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html
    #
    # @option params [String] :network_type
    #   The network type of the DB instance.
    #
    #   The network type is determined by the `DBSubnetGroup` specified for
    #   the DB instance. A `DBSubnetGroup` can support only the IPv4 protocol
    #   or the IPv4 and the IPv6 protocols (`DUAL`).
    #
    #   For more information, see [ Working with a DB instance in a VPC][1] in
    #   the *Amazon RDS User Guide.*
    #
    #   Valid Values: `IPV4 | DUAL`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html
    #
    # @option params [Integer] :storage_throughput
    #   The storage throughput value, in mebibyte per second (MiBps), for the
    #   DB instance.
    #
    #   This setting applies only to the `gp3` storage type.
    #
    #   This setting doesn't apply to Amazon Aurora or RDS Custom DB
    #   instances.
    #
    # @option params [Boolean] :manage_master_user_password
    #   Specifies whether to manage the master user password with Amazon Web
    #   Services Secrets Manager.
    #
    #   For more information, see [Password management with Amazon Web
    #   Services Secrets Manager][1] in the *Amazon RDS User Guide.*
    #
    #   Constraints:
    #
    #   * Can't manage the master user password with Amazon Web Services
    #     Secrets Manager if `MasterUserPassword` is specified.
    #
    #   ^
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html
    #
    # @option params [String] :master_user_secret_kms_key_id
    #   The Amazon Web Services KMS key identifier to encrypt a secret that is
    #   automatically generated and managed in Amazon Web Services Secrets
    #   Manager.
    #
    #   This setting is valid only if the master user password is managed by
    #   RDS in Amazon Web Services Secrets Manager for the DB instance.
    #
    #   The Amazon Web Services KMS key identifier is the key ARN, key ID,
    #   alias ARN, or alias name for the KMS key. To use a KMS key in a
    #   different Amazon Web Services account, specify the key ARN or alias
    #   ARN.
    #
    #   If you don't specify `MasterUserSecretKmsKeyId`, then the
    #   `aws/secretsmanager` KMS key is used to encrypt the secret. If the
    #   secret is in a different Amazon Web Services account, then you can't
    #   use the `aws/secretsmanager` KMS key to encrypt the secret, and you
    #   must use a customer managed KMS key.
    #
    #   There is a default KMS key for your Amazon Web Services account. Your
    #   Amazon Web Services account has a different default KMS key for each
    #   Amazon Web Services Region.
    #
    # @option params [String] :ca_certificate_identifier
    #   The CA certificate identifier to use for the DB instance's server
    #   certificate.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   For more information, see [Using SSL/TLS to encrypt a connection to a
    #   DB instance][1] in the *Amazon RDS User Guide* and [ Using SSL/TLS to
    #   encrypt a connection to a DB cluster][2] in the *Amazon Aurora User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html
    #
    # @option params [String] :db_system_id
    #   The Oracle system identifier (SID), which is the name of the Oracle
    #   database instance that manages your database files. In this context,
    #   the term "Oracle database instance" refers exclusively to the system
    #   global area (SGA) and Oracle background processes. If you don't
    #   specify a SID, the value defaults to `RDSCDB`. The Oracle SID is also
    #   the name of your CDB.
    #
    # @option params [Boolean] :dedicated_log_volume
    #   Indicates whether the DB instance has a dedicated log volume (DLV)
    #   enabled.
    #
    # @option params [Boolean] :multi_tenant
    #   Specifies whether to use the multi-tenant configuration or the
    #   single-tenant configuration (default). This parameter only applies to
    #   RDS for Oracle container database (CDB) engines.
    #
    #   Note the following restrictions:
    #
    #   * The DB engine that you specify in the request must support the
    #     multi-tenant configuration. If you attempt to enable the
    #     multi-tenant configuration on a DB engine that doesn't support it,
    #     the request fails.
    #
    #   * If you specify the multi-tenant configuration when you create your
    #     DB instance, you can't later modify this DB instance to use the
    #     single-tenant configuration.
    #
    # @option params [String] :engine_lifecycle_support
    #   The life cycle type for this DB instance.
    #
    #   <note markdown="1"> By default, this value is set to `open-source-rds-extended-support`,
    #   which enrolls your DB instance into Amazon RDS Extended Support. At
    #   the end of standard support, you can avoid charges for Extended
    #   Support by setting the value to
    #   `open-source-rds-extended-support-disabled`. In this case, creating
    #   the DB instance will fail if the DB major version is past its end of
    #   standard support date.
    #
    #    </note>
    #
    #   This setting applies only to RDS for MySQL and RDS for PostgreSQL. For
    #   Amazon Aurora DB instances, the life cycle type is managed by the DB
    #   cluster.
    #
    #   You can use this setting to enroll your DB instance into Amazon RDS
    #   Extended Support. With RDS Extended Support, you can run the selected
    #   major engine version on your DB instance past the end of standard
    #   support for that engine version. For more information, see [Amazon RDS
    #   Extended Support with Amazon RDS][1] in the *Amazon RDS User Guide*.
    #
    #   Valid Values: `open-source-rds-extended-support |
    #   open-source-rds-extended-support-disabled`
    #
    #   Default: `open-source-rds-extended-support`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
    #
    # @return [Types::CreateDBInstanceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDBInstanceResult#db_instance #db_instance} => Types::DBInstance
    #
    #
    # @example Example: To create a DB instance
    #
    #   # The following example uses the required options to launch a new DB instance.
    #
    #   resp = client.create_db_instance({
    #     allocated_storage: 20, 
    #     db_instance_class: "db.t3.micro", 
    #     db_instance_identifier: "test-mysql-instance", 
    #     engine: "mysql", 
    #     master_user_password: "secret99", 
    #     master_username: "admin", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_instance: {
    #       allocated_storage: 20, 
    #       associated_roles: [
    #       ], 
    #       auto_minor_version_upgrade: true, 
    #       backup_retention_period: 1, 
    #       ca_certificate_identifier: "rds-ca-2019", 
    #       copy_tags_to_snapshot: false, 
    #       db_instance_arn: "arn:aws:rds:us-west-2:123456789012:db:test-mysql-instance", 
    #       db_instance_class: "db.t3.micro", 
    #       db_instance_identifier: "test-mysql-instance", 
    #       db_instance_status: "creating", 
    #       db_parameter_groups: [
    #         {
    #           db_parameter_group_name: "default.mysql5.7", 
    #           parameter_apply_status: "in-sync", 
    #         }, 
    #       ], 
    #       db_security_groups: [
    #       ], 
    #       db_subnet_group: {
    #         db_subnet_group_description: "default", 
    #         db_subnet_group_name: "default", 
    #         subnet_group_status: "Complete", 
    #         subnets: [
    #           {
    #             subnet_availability_zone: {
    #               name: "us-west-2c", 
    #             }, 
    #             subnet_identifier: "subnet-########", 
    #             subnet_status: "Active", 
    #           }, 
    #           {
    #             subnet_availability_zone: {
    #               name: "us-west-2d", 
    #             }, 
    #             subnet_identifier: "subnet-########", 
    #             subnet_status: "Active", 
    #           }, 
    #           {
    #             subnet_availability_zone: {
    #               name: "us-west-2a", 
    #             }, 
    #             subnet_identifier: "subnet-########", 
    #             subnet_status: "Active", 
    #           }, 
    #           {
    #             subnet_availability_zone: {
    #               name: "us-west-2b", 
    #             }, 
    #             subnet_identifier: "subnet-########", 
    #             subnet_status: "Active", 
    #           }, 
    #         ], 
    #         vpc_id: "vpc-2ff2ff2f", 
    #       }, 
    #       db_instance_port: 0, 
    #       dbi_resource_id: "db-5555EXAMPLE44444444EXAMPLE", 
    #       deletion_protection: false, 
    #       domain_memberships: [
    #       ], 
    #       engine: "mysql", 
    #       engine_version: "5.7.22", 
    #       iam_database_authentication_enabled: false, 
    #       license_model: "general-public-license", 
    #       master_username: "admin", 
    #       monitoring_interval: 0, 
    #       multi_az: false, 
    #       option_group_memberships: [
    #         {
    #           option_group_name: "default:mysql-5-7", 
    #           status: "in-sync", 
    #         }, 
    #       ], 
    #       pending_modified_values: {
    #         master_user_password: "****", 
    #       }, 
    #       performance_insights_enabled: false, 
    #       preferred_backup_window: "12:55-13:25", 
    #       preferred_maintenance_window: "sun:08:07-sun:08:37", 
    #       publicly_accessible: true, 
    #       read_replica_db_instance_identifiers: [
    #       ], 
    #       storage_encrypted: false, 
    #       storage_type: "gp2", 
    #       vpc_security_groups: [
    #         {
    #           status: "active", 
    #           vpc_security_group_id: "sg-12345abc", 
    #         }, 
    #       ], 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_db_instance({
    #     db_name: "String",
    #     db_instance_identifier: "String", # required
    #     allocated_storage: 1,
    #     db_instance_class: "String", # required
    #     engine: "String", # required
    #     master_username: "String",
    #     master_user_password: "String",
    #     db_security_groups: ["String"],
    #     vpc_security_group_ids: ["String"],
    #     availability_zone: "String",
    #     db_subnet_group_name: "String",
    #     preferred_maintenance_window: "String",
    #     db_parameter_group_name: "String",
    #     backup_retention_period: 1,
    #     preferred_backup_window: "String",
    #     port: 1,
    #     multi_az: false,
    #     engine_version: "String",
    #     auto_minor_version_upgrade: false,
    #     license_model: "String",
    #     iops: 1,
    #     option_group_name: "String",
    #     character_set_name: "String",
    #     nchar_character_set_name: "String",
    #     publicly_accessible: false,
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #     db_cluster_identifier: "String",
    #     storage_type: "String",
    #     tde_credential_arn: "String",
    #     tde_credential_password: "String",
    #     storage_encrypted: false,
    #     kms_key_id: "String",
    #     domain: "String",
    #     domain_fqdn: "String",
    #     domain_ou: "String",
    #     domain_auth_secret_arn: "String",
    #     domain_dns_ips: ["String"],
    #     copy_tags_to_snapshot: false,
    #     monitoring_interval: 1,
    #     monitoring_role_arn: "String",
    #     domain_iam_role_name: "String",
    #     promotion_tier: 1,
    #     timezone: "String",
    #     enable_iam_database_authentication: false,
    #     database_insights_mode: "standard", # accepts standard, advanced
    #     enable_performance_insights: false,
    #     performance_insights_kms_key_id: "String",
    #     performance_insights_retention_period: 1,
    #     enable_cloudwatch_logs_exports: ["String"],
    #     processor_features: [
    #       {
    #         name: "String",
    #         value: "String",
    #       },
    #     ],
    #     deletion_protection: false,
    #     max_allocated_storage: 1,
    #     enable_customer_owned_ip: false,
    #     custom_iam_instance_profile: "String",
    #     backup_target: "String",
    #     network_type: "String",
    #     storage_throughput: 1,
    #     manage_master_user_password: false,
    #     master_user_secret_kms_key_id: "String",
    #     ca_certificate_identifier: "String",
    #     db_system_id: "String",
    #     dedicated_log_volume: false,
    #     multi_tenant: false,
    #     engine_lifecycle_support: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.db_instance.db_instance_identifier #=> String
    #   resp.db_instance.db_instance_class #=> String
    #   resp.db_instance.engine #=> String
    #   resp.db_instance.db_instance_status #=> String
    #   resp.db_instance.automatic_restart_time #=> Time
    #   resp.db_instance.master_username #=> String
    #   resp.db_instance.db_name #=> String
    #   resp.db_instance.endpoint.address #=> String
    #   resp.db_instance.endpoint.port #=> Integer
    #   resp.db_instance.endpoint.hosted_zone_id #=> String
    #   resp.db_instance.allocated_storage #=> Integer
    #   resp.db_instance.instance_create_time #=> Time
    #   resp.db_instance.preferred_backup_window #=> String
    #   resp.db_instance.backup_retention_period #=> Integer
    #   resp.db_instance.db_security_groups #=> Array
    #   resp.db_instance.db_security_groups[0].db_security_group_name #=> String
    #   resp.db_instance.db_security_groups[0].status #=> String
    #   resp.db_instance.vpc_security_groups #=> Array
    #   resp.db_instance.vpc_security_groups[0].vpc_security_group_id #=> String
    #   resp.db_instance.vpc_security_groups[0].status #=> String
    #   resp.db_instance.db_parameter_groups #=> Array
    #   resp.db_instance.db_parameter_groups[0].db_parameter_group_name #=> String
    #   resp.db_instance.db_parameter_groups[0].parameter_apply_status #=> String
    #   resp.db_instance.availability_zone #=> String
    #   resp.db_instance.db_subnet_group.db_subnet_group_name #=> String
    #   resp.db_instance.db_subnet_group.db_subnet_group_description #=> String
    #   resp.db_instance.db_subnet_group.vpc_id #=> String
    #   resp.db_instance.db_subnet_group.subnet_group_status #=> String
    #   resp.db_instance.db_subnet_group.subnets #=> Array
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_identifier #=> String
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_availability_zone.name #=> String
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_outpost.arn #=> String
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_status #=> String
    #   resp.db_instance.db_subnet_group.db_subnet_group_arn #=> String
    #   resp.db_instance.db_subnet_group.supported_network_types #=> Array
    #   resp.db_instance.db_subnet_group.supported_network_types[0] #=> String
    #   resp.db_instance.preferred_maintenance_window #=> String
    #   resp.db_instance.pending_modified_values.db_instance_class #=> String
    #   resp.db_instance.pending_modified_values.allocated_storage #=> Integer
    #   resp.db_instance.pending_modified_values.master_user_password #=> String
    #   resp.db_instance.pending_modified_values.port #=> Integer
    #   resp.db_instance.pending_modified_values.backup_retention_period #=> Integer
    #   resp.db_instance.pending_modified_values.multi_az #=> Boolean
    #   resp.db_instance.pending_modified_values.engine_version #=> String
    #   resp.db_instance.pending_modified_values.license_model #=> String
    #   resp.db_instance.pending_modified_values.iops #=> Integer
    #   resp.db_instance.pending_modified_values.db_instance_identifier #=> String
    #   resp.db_instance.pending_modified_values.storage_type #=> String
    #   resp.db_instance.pending_modified_values.ca_certificate_identifier #=> String
    #   resp.db_instance.pending_modified_values.db_subnet_group_name #=> String
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable #=> Array
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable[0] #=> String
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable #=> Array
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable[0] #=> String
    #   resp.db_instance.pending_modified_values.processor_features #=> Array
    #   resp.db_instance.pending_modified_values.processor_features[0].name #=> String
    #   resp.db_instance.pending_modified_values.processor_features[0].value #=> String
    #   resp.db_instance.pending_modified_values.iam_database_authentication_enabled #=> Boolean
    #   resp.db_instance.pending_modified_values.automation_mode #=> String, one of "full", "all-paused"
    #   resp.db_instance.pending_modified_values.resume_full_automation_mode_time #=> Time
    #   resp.db_instance.pending_modified_values.storage_throughput #=> Integer
    #   resp.db_instance.pending_modified_values.engine #=> String
    #   resp.db_instance.pending_modified_values.dedicated_log_volume #=> Boolean
    #   resp.db_instance.pending_modified_values.multi_tenant #=> Boolean
    #   resp.db_instance.latest_restorable_time #=> Time
    #   resp.db_instance.multi_az #=> Boolean
    #   resp.db_instance.engine_version #=> String
    #   resp.db_instance.auto_minor_version_upgrade #=> Boolean
    #   resp.db_instance.read_replica_source_db_instance_identifier #=> String
    #   resp.db_instance.read_replica_db_instance_identifiers #=> Array
    #   resp.db_instance.read_replica_db_instance_identifiers[0] #=> String
    #   resp.db_instance.read_replica_db_cluster_identifiers #=> Array
    #   resp.db_instance.read_replica_db_cluster_identifiers[0] #=> String
    #   resp.db_instance.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_instance.license_model #=> String
    #   resp.db_instance.iops #=> Integer
    #   resp.db_instance.option_group_memberships #=> Array
    #   resp.db_instance.option_group_memberships[0].option_group_name #=> String
    #   resp.db_instance.option_group_memberships[0].status #=> String
    #   resp.db_instance.character_set_name #=> String
    #   resp.db_instance.nchar_character_set_name #=> String
    #   resp.db_instance.secondary_availability_zone #=> String
    #   resp.db_instance.publicly_accessible #=> Boolean
    #   resp.db_instance.status_infos #=> Array
    #   resp.db_instance.status_infos[0].status_type #=> String
    #   resp.db_instance.status_infos[0].normal #=> Boolean
    #   resp.db_instance.status_infos[0].status #=> String
    #   resp.db_instance.status_infos[0].message #=> String
    #   resp.db_instance.storage_type #=> String
    #   resp.db_instance.tde_credential_arn #=> String
    #   resp.db_instance.db_instance_port #=> Integer
    #   resp.db_instance.db_cluster_identifier #=> String
    #   resp.db_instance.storage_encrypted #=> Boolean
    #   resp.db_instance.kms_key_id #=> String
    #   resp.db_instance.dbi_resource_id #=> String
    #   resp.db_instance.ca_certificate_identifier #=> String
    #   resp.db_instance.domain_memberships #=> Array
    #   resp.db_instance.domain_memberships[0].domain #=> String
    #   resp.db_instance.domain_memberships[0].status #=> String
    #   resp.db_instance.domain_memberships[0].fqdn #=> String
    #   resp.db_instance.domain_memberships[0].iam_role_name #=> String
    #   resp.db_instance.domain_memberships[0].ou #=> String
    #   resp.db_instance.domain_memberships[0].auth_secret_arn #=> String
    #   resp.db_instance.domain_memberships[0].dns_ips #=> Array
    #   resp.db_instance.domain_memberships[0].dns_ips[0] #=> String
    #   resp.db_instance.copy_tags_to_snapshot #=> Boolean
    #   resp.db_instance.monitoring_interval #=> Integer
    #   resp.db_instance.enhanced_monitoring_resource_arn #=> String
    #   resp.db_instance.monitoring_role_arn #=> String
    #   resp.db_instance.promotion_tier #=> Integer
    #   resp.db_instance.db_instance_arn #=> String
    #   resp.db_instance.timezone #=> String
    #   resp.db_instance.iam_database_authentication_enabled #=> Boolean
    #   resp.db_instance.database_insights_mode #=> String, one of "standard", "advanced"
    #   resp.db_instance.performance_insights_enabled #=> Boolean
    #   resp.db_instance.performance_insights_kms_key_id #=> String
    #   resp.db_instance.performance_insights_retention_period #=> Integer
    #   resp.db_instance.enabled_cloudwatch_logs_exports #=> Array
    #   resp.db_instance.enabled_cloudwatch_logs_exports[0] #=> String
    #   resp.db_instance.processor_features #=> Array
    #   resp.db_instance.processor_features[0].name #=> String
    #   resp.db_instance.processor_features[0].value #=> String
    #   resp.db_instance.deletion_protection #=> Boolean
    #   resp.db_instance.associated_roles #=> Array
    #   resp.db_instance.associated_roles[0].role_arn #=> String
    #   resp.db_instance.associated_roles[0].feature_name #=> String
    #   resp.db_instance.associated_roles[0].status #=> String
    #   resp.db_instance.listener_endpoint.address #=> String
    #   resp.db_instance.listener_endpoint.port #=> Integer
    #   resp.db_instance.listener_endpoint.hosted_zone_id #=> String
    #   resp.db_instance.max_allocated_storage #=> Integer
    #   resp.db_instance.tag_list #=> Array
    #   resp.db_instance.tag_list[0].key #=> String
    #   resp.db_instance.tag_list[0].value #=> String
    #   resp.db_instance.db_instance_automated_backups_replications #=> Array
    #   resp.db_instance.db_instance_automated_backups_replications[0].db_instance_automated_backups_arn #=> String
    #   resp.db_instance.customer_owned_ip_enabled #=> Boolean
    #   resp.db_instance.aws_backup_recovery_point_arn #=> String
    #   resp.db_instance.activity_stream_status #=> String, one of "stopped", "starting", "started", "stopping"
    #   resp.db_instance.activity_stream_kms_key_id #=> String
    #   resp.db_instance.activity_stream_kinesis_stream_name #=> String
    #   resp.db_instance.activity_stream_mode #=> String, one of "sync", "async"
    #   resp.db_instance.activity_stream_engine_native_audit_fields_included #=> Boolean
    #   resp.db_instance.automation_mode #=> String, one of "full", "all-paused"
    #   resp.db_instance.resume_full_automation_mode_time #=> Time
    #   resp.db_instance.custom_iam_instance_profile #=> String
    #   resp.db_instance.backup_target #=> String
    #   resp.db_instance.network_type #=> String
    #   resp.db_instance.activity_stream_policy_status #=> String, one of "locked", "unlocked", "locking-policy", "unlocking-policy"
    #   resp.db_instance.storage_throughput #=> Integer
    #   resp.db_instance.db_system_id #=> String
    #   resp.db_instance.master_user_secret.secret_arn #=> String
    #   resp.db_instance.master_user_secret.secret_status #=> String
    #   resp.db_instance.master_user_secret.kms_key_id #=> String
    #   resp.db_instance.certificate_details.ca_identifier #=> String
    #   resp.db_instance.certificate_details.valid_till #=> Time
    #   resp.db_instance.read_replica_source_db_cluster_identifier #=> String
    #   resp.db_instance.percent_progress #=> String
    #   resp.db_instance.dedicated_log_volume #=> Boolean
    #   resp.db_instance.is_storage_config_upgrade_available #=> Boolean
    #   resp.db_instance.multi_tenant #=> Boolean
    #   resp.db_instance.engine_lifecycle_support #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstance AWS API Documentation
    #
    # @overload create_db_instance(params = {})
    # @param [Hash] params ({})
    def create_db_instance(params = {}, options = {})
      req = build_request(:create_db_instance, params)
      req.send_request(options)
    end

    # Creates a new DB instance that acts as a read replica for an existing
    # source DB instance or Multi-AZ DB cluster. You can create a read
    # replica for a DB instance running Db2, MariaDB, MySQL, Oracle,
    # PostgreSQL, or SQL Server. You can create a read replica for a
    # Multi-AZ DB cluster running MySQL or PostgreSQL. For more information,
    # see [Working with read replicas][1] and [Migrating from a Multi-AZ DB
    # cluster to a DB instance using a read replica][2] in the *Amazon RDS
    # User Guide*.
    #
    # Amazon Aurora doesn't support this operation. To create a DB instance
    # for an Aurora DB cluster, use the `CreateDBInstance` operation.
    #
    # RDS creates read replicas with backups disabled. All other attributes
    # (including DB security groups and DB parameter groups) are inherited
    # from the source DB instance or cluster, except as specified.
    #
    # Your source DB instance or cluster must have backup retention enabled.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html#multi-az-db-clusters-migrating-to-instance-with-read-replica
    #
    # @option params [required, String] :db_instance_identifier
    #   The DB instance identifier of the read replica. This identifier is the
    #   unique key that identifies a DB instance. This parameter is stored as
    #   a lowercase string.
    #
    # @option params [String] :source_db_instance_identifier
    #   The identifier of the DB instance that will act as the source for the
    #   read replica. Each DB instance can have up to 15 read replicas, except
    #   for the following engines:
    #
    #   * Db2 - Can have up to three replicas.
    #
    #   * Oracle - Can have up to five read replicas.
    #
    #   * SQL Server - Can have up to five read replicas.
    #
    #   Constraints:
    #
    #   * Must be the identifier of an existing Db2, MariaDB, MySQL, Oracle,
    #     PostgreSQL, or SQL Server DB instance.
    #
    #   * Can't be specified if the `SourceDBClusterIdentifier` parameter is
    #     also specified.
    #
    #   * For the limitations of Oracle read replicas, see [Version and
    #     licensing considerations for RDS for Oracle replicas][1] in the
    #     *Amazon RDS User Guide*.
    #
    #   * For the limitations of SQL Server read replicas, see [Read replica
    #     limitations with SQL Server][2] in the *Amazon RDS User Guide*.
    #
    #   * The specified DB instance must have automatic backups enabled, that
    #     is, its backup retention period must be greater than 0.
    #
    #   * If the source DB instance is in the same Amazon Web Services Region
    #     as the read replica, specify a valid DB instance identifier.
    #
    #   * If the source DB instance is in a different Amazon Web Services
    #     Region from the read replica, specify a valid DB instance ARN. For
    #     more information, see [Constructing an ARN for Amazon RDS][3] in the
    #     *Amazon RDS User Guide*. This doesn't apply to SQL Server or RDS
    #     Custom, which don't support cross-Region replicas.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.limitations.html#oracle-read-replicas.limitations.versions-and-licenses
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.html#SQLServer.ReadReplicas.Limitations
    #   [3]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing
    #
    # @option params [String] :db_instance_class
    #   The compute and memory capacity of the read replica, for example
    #   db.m4.large. Not all DB instance classes are available in all Amazon
    #   Web Services Regions, or for all database engines. For the full list
    #   of DB instance classes, and availability for your engine, see [DB
    #   Instance Class][1] in the *Amazon RDS User Guide*.
    #
    #   Default: Inherits the value from the source DB instance.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html
    #
    # @option params [String] :availability_zone
    #   The Availability Zone (AZ) where the read replica will be created.
    #
    #   Default: A random, system-chosen Availability Zone in the endpoint's
    #   Amazon Web Services Region.
    #
    #   Example: `us-east-1d`
    #
    # @option params [Integer] :port
    #   The port number that the DB instance uses for connections.
    #
    #   Valid Values: `1150-65535`
    #
    #   Default: Inherits the value from the source DB instance.
    #
    # @option params [Boolean] :multi_az
    #   Specifies whether the read replica is in a Multi-AZ deployment.
    #
    #   You can create a read replica as a Multi-AZ DB instance. RDS creates a
    #   standby of your replica in another Availability Zone for failover
    #   support for the replica. Creating your read replica as a Multi-AZ DB
    #   instance is independent of whether the source is a Multi-AZ DB
    #   instance or a Multi-AZ DB cluster.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [Boolean] :auto_minor_version_upgrade
    #   Specifies whether to automatically apply minor engine upgrades to the
    #   read replica during the maintenance window.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Default: Inherits the value from the source DB instance.
    #
    #   For more information about automatic minor version upgrades, see
    #   [Automatically upgrading the minor engine version][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades
    #
    # @option params [Integer] :iops
    #   The amount of Provisioned IOPS (input/output operations per second) to
    #   initially allocate for the DB instance.
    #
    # @option params [String] :option_group_name
    #   The option group to associate the DB instance with. If not specified,
    #   RDS uses the option group associated with the source DB instance or
    #   cluster.
    #
    #   <note markdown="1"> For SQL Server, you must use the option group associated with the
    #   source.
    #
    #    </note>
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [String] :db_parameter_group_name
    #   The name of the DB parameter group to associate with this read replica
    #   DB instance.
    #
    #   For the Db2 DB engine, if your source DB instance uses the bring your
    #   own license (BYOL) model, then a custom parameter group must be
    #   associated with the replica. For a same Amazon Web Services Region
    #   replica, if you don't specify a custom parameter group, Amazon RDS
    #   associates the custom parameter group associated with the source DB
    #   instance. For a cross-Region replica, you must specify a custom
    #   parameter group. This custom parameter group must include your IBM
    #   Site ID and IBM Customer ID. For more information, see [IBM IDs for
    #   bring your own license (BYOL) for Db2][1].
    #
    #   For Single-AZ or Multi-AZ DB instance read replica instances, if you
    #   don't specify a value for `DBParameterGroupName`, then Amazon RDS
    #   uses the `DBParameterGroup` of the source DB instance for a same
    #   Region read replica, or the default `DBParameterGroup` for the
    #   specified DB engine for a cross-Region read replica.
    #
    #   For Multi-AZ DB cluster same Region read replica instances, if you
    #   don't specify a value for `DBParameterGroupName`, then Amazon RDS
    #   uses the default `DBParameterGroup`.
    #
    #   Specifying a parameter group for this operation is only supported for
    #   MySQL DB instances for cross-Region read replicas, for Multi-AZ DB
    #   cluster read replica instances, for Db2 DB instances, and for Oracle
    #   DB instances. It isn't supported for MySQL DB instances for same
    #   Region read replicas or for RDS Custom.
    #
    #   Constraints:
    #
    #   * Must be 1 to 255 letters, numbers, or hyphens.
    #
    #   * First character must be a letter.
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html#db2-prereqs-ibm-info
    #
    # @option params [Boolean] :publicly_accessible
    #   Specifies whether the DB instance is publicly accessible.
    #
    #   When the DB cluster is publicly accessible, its Domain Name System
    #   (DNS) endpoint resolves to the private IP address from within the DB
    #   cluster's virtual private cloud (VPC). It resolves to the public IP
    #   address from outside of the DB cluster's VPC. Access to the DB
    #   cluster is ultimately controlled by the security group it uses. That
    #   public access isn't permitted if the security group assigned to the
    #   DB cluster doesn't permit it.
    #
    #   When the DB instance isn't publicly accessible, it is an internal DB
    #   instance with a DNS name that resolves to a private IP address.
    #
    #   For more information, see CreateDBInstance.
    #
    # @option params [Array<Types::Tag>] :tags
    #   A list of tags.
    #
    #   For more information, see [Tagging Amazon RDS resources][1] in the
    #   *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS
    #   resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @option params [String] :db_subnet_group_name
    #   A DB subnet group for the DB instance. The new DB instance is created
    #   in the VPC associated with the DB subnet group. If no DB subnet group
    #   is specified, then the new DB instance isn't created in a VPC.
    #
    #   Constraints:
    #
    #   * If supplied, must match the name of an existing DB subnet group.
    #
    #   * The specified DB subnet group must be in the same Amazon Web
    #     Services Region in which the operation is running.
    #
    #   * All read replicas in one Amazon Web Services Region that are created
    #     from the same source DB instance must either:
    #
    #     * Specify DB subnet groups from the same VPC. All these read
    #       replicas are created in the same VPC.
    #
    #     * Not specify a DB subnet group. All these read replicas are created
    #       outside of any VPC.
    #
    #   Example: `mydbsubnetgroup`
    #
    # @option params [Array<String>] :vpc_security_group_ids
    #   A list of Amazon EC2 VPC security groups to associate with the read
    #   replica.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Default: The default EC2 VPC security group for the DB subnet group's
    #   VPC.
    #
    # @option params [String] :storage_type
    #   The storage type to associate with the read replica.
    #
    #   If you specify `io1`, `io2`, or `gp3`, you must also include a value
    #   for the `Iops` parameter.
    #
    #   Valid Values: `gp2 | gp3 | io1 | io2 | standard`
    #
    #   Default: `io1` if the `Iops` parameter is specified. Otherwise, `gp3`.
    #
    # @option params [Boolean] :copy_tags_to_snapshot
    #   Specifies whether to copy all tags from the read replica to snapshots
    #   of the read replica. By default, tags aren't copied.
    #
    # @option params [Integer] :monitoring_interval
    #   The interval, in seconds, between points when Enhanced Monitoring
    #   metrics are collected for the read replica. To disable collection of
    #   Enhanced Monitoring metrics, specify `0`. The default is `0`.
    #
    #   If `MonitoringRoleArn` is specified, then you must set
    #   `MonitoringInterval` to a value other than `0`.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Valid Values: `0, 1, 5, 10, 15, 30, 60`
    #
    #   Default: `0`
    #
    # @option params [String] :monitoring_role_arn
    #   The ARN for the IAM role that permits RDS to send enhanced monitoring
    #   metrics to Amazon CloudWatch Logs. For example,
    #   `arn:aws:iam:123456789012:role/emaccess`. For information on creating
    #   a monitoring role, go to [To create an IAM role for Amazon RDS
    #   Enhanced Monitoring][1] in the *Amazon RDS User Guide*.
    #
    #   If `MonitoringInterval` is set to a value other than 0, then you must
    #   supply a `MonitoringRoleArn` value.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole
    #
    # @option params [String] :kms_key_id
    #   The Amazon Web Services KMS key identifier for an encrypted read
    #   replica.
    #
    #   The Amazon Web Services KMS key identifier is the key ARN, key ID,
    #   alias ARN, or alias name for the KMS key.
    #
    #   If you create an encrypted read replica in the same Amazon Web
    #   Services Region as the source DB instance or Multi-AZ DB cluster,
    #   don't specify a value for this parameter. A read replica in the same
    #   Amazon Web Services Region is always encrypted with the same KMS key
    #   as the source DB instance or cluster.
    #
    #   If you create an encrypted read replica in a different Amazon Web
    #   Services Region, then you must specify a KMS key identifier for the
    #   destination Amazon Web Services Region. KMS keys are specific to the
    #   Amazon Web Services Region that they are created in, and you can't
    #   use KMS keys from one Amazon Web Services Region in another Amazon Web
    #   Services Region.
    #
    #   You can't create an encrypted read replica from an unencrypted DB
    #   instance or Multi-AZ DB cluster.
    #
    #   This setting doesn't apply to RDS Custom, which uses the same KMS key
    #   as the primary replica.
    #
    # @option params [String] :pre_signed_url
    #   When you are creating a read replica from one Amazon Web Services
    #   GovCloud (US) Region to another or from one China Amazon Web Services
    #   Region to another, the URL that contains a Signature Version 4 signed
    #   request for the `CreateDBInstanceReadReplica` API operation in the
    #   source Amazon Web Services Region that contains the source DB
    #   instance.
    #
    #   This setting applies only to Amazon Web Services GovCloud (US) Regions
    #   and China Amazon Web Services Regions. It's ignored in other Amazon
    #   Web Services Regions.
    #
    #   This setting applies only when replicating from a source DB
    #   *instance*. Source DB clusters aren't supported in Amazon Web
    #   Services GovCloud (US) Regions and China Amazon Web Services Regions.
    #
    #   You must specify this parameter when you create an encrypted read
    #   replica from another Amazon Web Services Region by using the Amazon
    #   RDS API. Don't specify `PreSignedUrl` when you are creating an
    #   encrypted read replica in the same Amazon Web Services Region.
    #
    #   The presigned URL must be a valid request for the
    #   `CreateDBInstanceReadReplica` API operation that can run in the source
    #   Amazon Web Services Region that contains the encrypted source DB
    #   instance. The presigned URL request must contain the following
    #   parameter values:
    #
    #   * `DestinationRegion` - The Amazon Web Services Region that the
    #     encrypted read replica is created in. This Amazon Web Services
    #     Region is the same one where the `CreateDBInstanceReadReplica`
    #     operation is called that contains this presigned URL.
    #
    #     For example, if you create an encrypted DB instance in the us-west-1
    #     Amazon Web Services Region, from a source DB instance in the
    #     us-east-2 Amazon Web Services Region, then you call the
    #     `CreateDBInstanceReadReplica` operation in the us-east-1 Amazon Web
    #     Services Region and provide a presigned URL that contains a call to
    #     the `CreateDBInstanceReadReplica` operation in the us-west-2 Amazon
    #     Web Services Region. For this example, the `DestinationRegion` in
    #     the presigned URL must be set to the us-east-1 Amazon Web Services
    #     Region.
    #
    #   * `KmsKeyId` - The KMS key identifier for the key to use to encrypt
    #     the read replica in the destination Amazon Web Services Region. This
    #     is the same identifier for both the `CreateDBInstanceReadReplica`
    #     operation that is called in the destination Amazon Web Services
    #     Region, and the operation contained in the presigned URL.
    #
    #   * `SourceDBInstanceIdentifier` - The DB instance identifier for the
    #     encrypted DB instance to be replicated. This identifier must be in
    #     the Amazon Resource Name (ARN) format for the source Amazon Web
    #     Services Region. For example, if you are creating an encrypted read
    #     replica from a DB instance in the us-west-2 Amazon Web Services
    #     Region, then your `SourceDBInstanceIdentifier` looks like the
    #     following example:
    #     `arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115`.
    #
    #   To learn how to generate a Signature Version 4 signed request, see
    #   [Authenticating Requests: Using Query Parameters (Amazon Web Services
    #   Signature Version 4)][1] and [Signature Version 4 Signing Process][2].
    #
    #   <note markdown="1"> If you are using an Amazon Web Services SDK tool or the CLI, you can
    #   specify `SourceRegion` (or `--source-region` for the CLI) instead of
    #   specifying `PreSignedUrl` manually. Specifying `SourceRegion`
    #   autogenerates a presigned URL that is a valid request for the
    #   operation that can run in the source Amazon Web Services Region.
    #
    #    </note>
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html
    #   [2]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
    #
    # @option params [Boolean] :enable_iam_database_authentication
    #   Specifies whether to enable mapping of Amazon Web Services Identity
    #   and Access Management (IAM) accounts to database accounts. By default,
    #   mapping isn't enabled.
    #
    #   For more information about IAM database authentication, see [ IAM
    #   Database Authentication for MySQL and PostgreSQL][1] in the *Amazon
    #   RDS User Guide*.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html
    #
    # @option params [String] :database_insights_mode
    #   The mode of Database Insights to enable for the read replica.
    #
    #   <note markdown="1"> This setting isn't supported.
    #
    #    </note>
    #
    # @option params [Boolean] :enable_performance_insights
    #   Specifies whether to enable Performance Insights for the read replica.
    #
    #   For more information, see [Using Amazon Performance Insights][1] in
    #   the *Amazon RDS User Guide*.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html
    #
    # @option params [String] :performance_insights_kms_key_id
    #   The Amazon Web Services KMS key identifier for encryption of
    #   Performance Insights data.
    #
    #   The Amazon Web Services KMS key identifier is the key ARN, key ID,
    #   alias ARN, or alias name for the KMS key.
    #
    #   If you do not specify a value for `PerformanceInsightsKMSKeyId`, then
    #   Amazon RDS uses your default KMS key. There is a default KMS key for
    #   your Amazon Web Services account. Your Amazon Web Services account has
    #   a different default KMS key for each Amazon Web Services Region.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [Integer] :performance_insights_retention_period
    #   The number of days to retain Performance Insights data.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Valid Values:
    #
    #   * `7`
    #
    #   * *month* * 31, where *month* is a number of months from 1-23.
    #     Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19
    #     months * 31)
    #
    #   * `731`
    #
    #   Default: `7` days
    #
    #   If you specify a retention period that isn't valid, such as `94`,
    #   Amazon RDS returns an error.
    #
    # @option params [Array<String>] :enable_cloudwatch_logs_exports
    #   The list of logs that the new DB instance is to export to CloudWatch
    #   Logs. The values in the list depend on the DB engine being used. For
    #   more information, see [Publishing Database Logs to Amazon CloudWatch
    #   Logs ][1] in the *Amazon RDS User Guide*.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch
    #
    # @option params [Array<Types::ProcessorFeature>] :processor_features
    #   The number of CPU cores and the number of threads per core for the DB
    #   instance class of the DB instance.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [Boolean] :use_default_processor_features
    #   Specifies whether the DB instance class of the DB instance uses its
    #   default processor features.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [Boolean] :deletion_protection
    #   Specifies whether to enable deletion protection for the DB instance.
    #   The database can't be deleted when deletion protection is enabled. By
    #   default, deletion protection isn't enabled. For more information, see
    #   [ Deleting a DB Instance][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html
    #
    # @option params [String] :domain
    #   The Active Directory directory ID to create the DB instance in.
    #   Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB
    #   instances can be created in an Active Directory Domain.
    #
    #   For more information, see [ Kerberos Authentication][1] in the *Amazon
    #   RDS User Guide*.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html
    #
    # @option params [String] :domain_iam_role_name
    #   The name of the IAM role to use when making API calls to the Directory
    #   Service.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [String] :domain_fqdn
    #   The fully qualified domain name (FQDN) of an Active Directory domain.
    #
    #   Constraints:
    #
    #   * Can't be longer than 64 characters.
    #
    #   ^
    #
    #   Example: `mymanagedADtest.mymanagedAD.mydomain`
    #
    # @option params [String] :domain_ou
    #   The Active Directory organizational unit for your DB instance to join.
    #
    #   Constraints:
    #
    #   * Must be in the distinguished name format.
    #
    #   * Can't be longer than 64 characters.
    #
    #   Example:
    #   `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
    #
    # @option params [String] :domain_auth_secret_arn
    #   The ARN for the Secrets Manager secret with the credentials for the
    #   user joining the domain.
    #
    #   Example:
    #   `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
    #
    # @option params [Array<String>] :domain_dns_ips
    #   The IPv4 DNS IP addresses of your primary and secondary Active
    #   Directory domain controllers.
    #
    #   Constraints:
    #
    #   * Two IP addresses must be provided. If there isn't a secondary
    #     domain controller, use the IP address of the primary domain
    #     controller for both entries in the list.
    #
    #   ^
    #
    #   Example: `123.124.125.126,234.235.236.237`
    #
    # @option params [String] :replica_mode
    #   The open mode of the replica database.
    #
    #   This parameter is only supported for Db2 DB instances and Oracle DB
    #   instances.
    #
    #   Db2
    #
    #   : Standby DB replicas are included in Db2 Advanced Edition (AE) and
    #     Db2 Standard Edition (SE). The main use case for standby replicas is
    #     cross-Region disaster recovery. Because it doesn't accept user
    #     connections, a standby replica can't serve a read-only workload.
    #
    #     You can create a combination of standby and read-only DB replicas
    #     for the same primary DB instance. For more information, see [Working
    #     with replicas for Amazon RDS for Db2][1] in the *Amazon RDS User
    #     Guide*.
    #
    #     To create standby DB replicas for RDS for Db2, set this parameter to
    #     `mounted`.
    #
    #   Oracle
    #
    #   : Mounted DB replicas are included in Oracle Database Enterprise
    #     Edition. The main use case for mounted replicas is cross-Region
    #     disaster recovery. The primary database doesn't use Active Data
    #     Guard to transmit information to the mounted replica. Because it
    #     doesn't accept user connections, a mounted replica can't serve a
    #     read-only workload.
    #
    #     You can create a combination of mounted and read-only DB replicas
    #     for the same primary DB instance. For more information, see [Working
    #     with read replicas for Amazon RDS for Oracle][2] in the *Amazon RDS
    #     User Guide*.
    #
    #     For RDS Custom, you must specify this parameter and set it to
    #     `mounted`. The value won't be set by default. After replica
    #     creation, you can manage the open mode manually.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-replication.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html
    #
    # @option params [Integer] :max_allocated_storage
    #   The upper limit in gibibytes (GiB) to which Amazon RDS can
    #   automatically scale the storage of the DB instance.
    #
    #   For more information about this setting, including limitations that
    #   apply to it, see [ Managing capacity automatically with Amazon RDS
    #   storage autoscaling][1] in the *Amazon RDS User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling
    #
    # @option params [String] :custom_iam_instance_profile
    #   The instance profile associated with the underlying Amazon EC2
    #   instance of an RDS Custom DB instance. The instance profile must meet
    #   the following requirements:
    #
    #   * The profile must exist in your account.
    #
    #   * The profile must have an IAM role that Amazon EC2 has permissions to
    #     assume.
    #
    #   * The instance profile name and the associated IAM role name must
    #     start with the prefix `AWSRDSCustom`.
    #
    #   For the list of permissions required for the IAM role, see [ Configure
    #   IAM and your VPC][1] in the *Amazon RDS User Guide*.
    #
    #   This setting is required for RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc
    #
    # @option params [String] :network_type
    #   The network type of the DB instance.
    #
    #   Valid Values:
    #
    #   * `IPV4`
    #
    #   * `DUAL`
    #
    #   The network type is determined by the `DBSubnetGroup` specified for
    #   read replica. A `DBSubnetGroup` can support only the IPv4 protocol or
    #   the IPv4 and the IPv6 protocols (`DUAL`).
    #
    #   For more information, see [ Working with a DB instance in a VPC][1] in
    #   the *Amazon RDS User Guide.*
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html
    #
    # @option params [Integer] :storage_throughput
    #   Specifies the storage throughput value for the read replica.
    #
    #   This setting doesn't apply to RDS Custom or Amazon Aurora DB
    #   instances.
    #
    # @option params [Boolean] :enable_customer_owned_ip
    #   Specifies whether to enable a customer-owned IP address (CoIP) for an
    #   RDS on Outposts read replica.
    #
    #   A *CoIP* provides local or external connectivity to resources in your
    #   Outpost subnets through your on-premises network. For some use cases,
    #   a CoIP can provide lower latency for connections to the read replica
    #   from outside of its virtual private cloud (VPC) on your local network.
    #
    #   For more information about RDS on Outposts, see [Working with Amazon
    #   RDS on Amazon Web Services Outposts][1] in the *Amazon RDS User
    #   Guide*.
    #
    #   For more information about CoIPs, see [Customer-owned IP addresses][2]
    #   in the *Amazon Web Services Outposts User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html
    #   [2]: https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing
    #
    # @option params [String] :backup_target
    #   The location where RDS stores automated backups and manual snapshots.
    #
    #   Valid Values:
    #
    #   * `local` for Dedicated Local Zones
    #
    #   * `region` for Amazon Web Services Region
    #
    # @option params [Integer] :allocated_storage
    #   The amount of storage (in gibibytes) to allocate initially for the
    #   read replica. Follow the allocation rules specified in
    #   `CreateDBInstance`.
    #
    #   This setting isn't valid for RDS for SQL Server.
    #
    #   <note markdown="1"> Be sure to allocate enough storage for your read replica so that the
    #   create operation can succeed. You can also allocate additional storage
    #   for future growth.
    #
    #    </note>
    #
    # @option params [String] :source_db_cluster_identifier
    #   The identifier of the Multi-AZ DB cluster that will act as the source
    #   for the read replica. Each DB cluster can have up to 15 read replicas.
    #
    #   Constraints:
    #
    #   * Must be the identifier of an existing Multi-AZ DB cluster.
    #
    #   * Can't be specified if the `SourceDBInstanceIdentifier` parameter is
    #     also specified.
    #
    #   * The specified DB cluster must have automatic backups enabled, that
    #     is, its backup retention period must be greater than 0.
    #
    #   * The source DB cluster must be in the same Amazon Web Services Region
    #     as the read replica. Cross-Region replication isn't supported.
    #
    # @option params [Boolean] :dedicated_log_volume
    #   Indicates whether the DB instance has a dedicated log volume (DLV)
    #   enabled.
    #
    # @option params [Boolean] :upgrade_storage_config
    #   Whether to upgrade the storage file system configuration on the read
    #   replica. This option migrates the read replica from the old storage
    #   file system layout to the preferred layout.
    #
    # @option params [String] :ca_certificate_identifier
    #   The CA certificate identifier to use for the read replica's server
    #   certificate.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   For more information, see [Using SSL/TLS to encrypt a connection to a
    #   DB instance][1] in the *Amazon RDS User Guide* and [ Using SSL/TLS to
    #   encrypt a connection to a DB cluster][2] in the *Amazon Aurora User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html
    #
    # @option params [String] :source_region
    #   The source region of the snapshot. This is only needed when the
    #   shapshot is encrypted and in a different region.
    #
    # @return [Types::CreateDBInstanceReadReplicaResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDBInstanceReadReplicaResult#db_instance #db_instance} => Types::DBInstance
    #
    #
    # @example Example: To create a DB instance read replica
    #
    #   # This example creates a read replica of an existing DB instance named test-instance. The read replica is named
    #   # test-instance-repl.
    #
    #   resp = client.create_db_instance_read_replica({
    #     db_instance_identifier: "test-instance-repl", 
    #     source_db_instance_identifier: "test-instance", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_instance: {
    #       db_instance_arn: "arn:aws:rds:us-east-1:123456789012:db:test-instance-repl", 
    #       db_instance_identifier: "test-instance-repl", 
    #       iam_database_authentication_enabled: false, 
    #       monitoring_interval: 0, 
    #       read_replica_source_db_instance_identifier: "test-instance", 
    #     }, # Some output ommitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_db_instance_read_replica({
    #     db_instance_identifier: "String", # required
    #     source_db_instance_identifier: "String",
    #     db_instance_class: "String",
    #     availability_zone: "String",
    #     port: 1,
    #     multi_az: false,
    #     auto_minor_version_upgrade: false,
    #     iops: 1,
    #     option_group_name: "String",
    #     db_parameter_group_name: "String",
    #     publicly_accessible: false,
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #     db_subnet_group_name: "String",
    #     vpc_security_group_ids: ["String"],
    #     storage_type: "String",
    #     copy_tags_to_snapshot: false,
    #     monitoring_interval: 1,
    #     monitoring_role_arn: "String",
    #     kms_key_id: "String",
    #     pre_signed_url: "String",
    #     enable_iam_database_authentication: false,
    #     database_insights_mode: "standard", # accepts standard, advanced
    #     enable_performance_insights: false,
    #     performance_insights_kms_key_id: "String",
    #     performance_insights_retention_period: 1,
    #     enable_cloudwatch_logs_exports: ["String"],
    #     processor_features: [
    #       {
    #         name: "String",
    #         value: "String",
    #       },
    #     ],
    #     use_default_processor_features: false,
    #     deletion_protection: false,
    #     domain: "String",
    #     domain_iam_role_name: "String",
    #     domain_fqdn: "String",
    #     domain_ou: "String",
    #     domain_auth_secret_arn: "String",
    #     domain_dns_ips: ["String"],
    #     replica_mode: "open-read-only", # accepts open-read-only, mounted
    #     max_allocated_storage: 1,
    #     custom_iam_instance_profile: "String",
    #     network_type: "String",
    #     storage_throughput: 1,
    #     enable_customer_owned_ip: false,
    #     backup_target: "String",
    #     allocated_storage: 1,
    #     source_db_cluster_identifier: "String",
    #     dedicated_log_volume: false,
    #     upgrade_storage_config: false,
    #     ca_certificate_identifier: "String",
    #     source_region: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.db_instance.db_instance_identifier #=> String
    #   resp.db_instance.db_instance_class #=> String
    #   resp.db_instance.engine #=> String
    #   resp.db_instance.db_instance_status #=> String
    #   resp.db_instance.automatic_restart_time #=> Time
    #   resp.db_instance.master_username #=> String
    #   resp.db_instance.db_name #=> String
    #   resp.db_instance.endpoint.address #=> String
    #   resp.db_instance.endpoint.port #=> Integer
    #   resp.db_instance.endpoint.hosted_zone_id #=> String
    #   resp.db_instance.allocated_storage #=> Integer
    #   resp.db_instance.instance_create_time #=> Time
    #   resp.db_instance.preferred_backup_window #=> String
    #   resp.db_instance.backup_retention_period #=> Integer
    #   resp.db_instance.db_security_groups #=> Array
    #   resp.db_instance.db_security_groups[0].db_security_group_name #=> String
    #   resp.db_instance.db_security_groups[0].status #=> String
    #   resp.db_instance.vpc_security_groups #=> Array
    #   resp.db_instance.vpc_security_groups[0].vpc_security_group_id #=> String
    #   resp.db_instance.vpc_security_groups[0].status #=> String
    #   resp.db_instance.db_parameter_groups #=> Array
    #   resp.db_instance.db_parameter_groups[0].db_parameter_group_name #=> String
    #   resp.db_instance.db_parameter_groups[0].parameter_apply_status #=> String
    #   resp.db_instance.availability_zone #=> String
    #   resp.db_instance.db_subnet_group.db_subnet_group_name #=> String
    #   resp.db_instance.db_subnet_group.db_subnet_group_description #=> String
    #   resp.db_instance.db_subnet_group.vpc_id #=> String
    #   resp.db_instance.db_subnet_group.subnet_group_status #=> String
    #   resp.db_instance.db_subnet_group.subnets #=> Array
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_identifier #=> String
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_availability_zone.name #=> String
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_outpost.arn #=> String
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_status #=> String
    #   resp.db_instance.db_subnet_group.db_subnet_group_arn #=> String
    #   resp.db_instance.db_subnet_group.supported_network_types #=> Array
    #   resp.db_instance.db_subnet_group.supported_network_types[0] #=> String
    #   resp.db_instance.preferred_maintenance_window #=> String
    #   resp.db_instance.pending_modified_values.db_instance_class #=> String
    #   resp.db_instance.pending_modified_values.allocated_storage #=> Integer
    #   resp.db_instance.pending_modified_values.master_user_password #=> String
    #   resp.db_instance.pending_modified_values.port #=> Integer
    #   resp.db_instance.pending_modified_values.backup_retention_period #=> Integer
    #   resp.db_instance.pending_modified_values.multi_az #=> Boolean
    #   resp.db_instance.pending_modified_values.engine_version #=> String
    #   resp.db_instance.pending_modified_values.license_model #=> String
    #   resp.db_instance.pending_modified_values.iops #=> Integer
    #   resp.db_instance.pending_modified_values.db_instance_identifier #=> String
    #   resp.db_instance.pending_modified_values.storage_type #=> String
    #   resp.db_instance.pending_modified_values.ca_certificate_identifier #=> String
    #   resp.db_instance.pending_modified_values.db_subnet_group_name #=> String
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable #=> Array
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable[0] #=> String
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable #=> Array
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable[0] #=> String
    #   resp.db_instance.pending_modified_values.processor_features #=> Array
    #   resp.db_instance.pending_modified_values.processor_features[0].name #=> String
    #   resp.db_instance.pending_modified_values.processor_features[0].value #=> String
    #   resp.db_instance.pending_modified_values.iam_database_authentication_enabled #=> Boolean
    #   resp.db_instance.pending_modified_values.automation_mode #=> String, one of "full", "all-paused"
    #   resp.db_instance.pending_modified_values.resume_full_automation_mode_time #=> Time
    #   resp.db_instance.pending_modified_values.storage_throughput #=> Integer
    #   resp.db_instance.pending_modified_values.engine #=> String
    #   resp.db_instance.pending_modified_values.dedicated_log_volume #=> Boolean
    #   resp.db_instance.pending_modified_values.multi_tenant #=> Boolean
    #   resp.db_instance.latest_restorable_time #=> Time
    #   resp.db_instance.multi_az #=> Boolean
    #   resp.db_instance.engine_version #=> String
    #   resp.db_instance.auto_minor_version_upgrade #=> Boolean
    #   resp.db_instance.read_replica_source_db_instance_identifier #=> String
    #   resp.db_instance.read_replica_db_instance_identifiers #=> Array
    #   resp.db_instance.read_replica_db_instance_identifiers[0] #=> String
    #   resp.db_instance.read_replica_db_cluster_identifiers #=> Array
    #   resp.db_instance.read_replica_db_cluster_identifiers[0] #=> String
    #   resp.db_instance.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_instance.license_model #=> String
    #   resp.db_instance.iops #=> Integer
    #   resp.db_instance.option_group_memberships #=> Array
    #   resp.db_instance.option_group_memberships[0].option_group_name #=> String
    #   resp.db_instance.option_group_memberships[0].status #=> String
    #   resp.db_instance.character_set_name #=> String
    #   resp.db_instance.nchar_character_set_name #=> String
    #   resp.db_instance.secondary_availability_zone #=> String
    #   resp.db_instance.publicly_accessible #=> Boolean
    #   resp.db_instance.status_infos #=> Array
    #   resp.db_instance.status_infos[0].status_type #=> String
    #   resp.db_instance.status_infos[0].normal #=> Boolean
    #   resp.db_instance.status_infos[0].status #=> String
    #   resp.db_instance.status_infos[0].message #=> String
    #   resp.db_instance.storage_type #=> String
    #   resp.db_instance.tde_credential_arn #=> String
    #   resp.db_instance.db_instance_port #=> Integer
    #   resp.db_instance.db_cluster_identifier #=> String
    #   resp.db_instance.storage_encrypted #=> Boolean
    #   resp.db_instance.kms_key_id #=> String
    #   resp.db_instance.dbi_resource_id #=> String
    #   resp.db_instance.ca_certificate_identifier #=> String
    #   resp.db_instance.domain_memberships #=> Array
    #   resp.db_instance.domain_memberships[0].domain #=> String
    #   resp.db_instance.domain_memberships[0].status #=> String
    #   resp.db_instance.domain_memberships[0].fqdn #=> String
    #   resp.db_instance.domain_memberships[0].iam_role_name #=> String
    #   resp.db_instance.domain_memberships[0].ou #=> String
    #   resp.db_instance.domain_memberships[0].auth_secret_arn #=> String
    #   resp.db_instance.domain_memberships[0].dns_ips #=> Array
    #   resp.db_instance.domain_memberships[0].dns_ips[0] #=> String
    #   resp.db_instance.copy_tags_to_snapshot #=> Boolean
    #   resp.db_instance.monitoring_interval #=> Integer
    #   resp.db_instance.enhanced_monitoring_resource_arn #=> String
    #   resp.db_instance.monitoring_role_arn #=> String
    #   resp.db_instance.promotion_tier #=> Integer
    #   resp.db_instance.db_instance_arn #=> String
    #   resp.db_instance.timezone #=> String
    #   resp.db_instance.iam_database_authentication_enabled #=> Boolean
    #   resp.db_instance.database_insights_mode #=> String, one of "standard", "advanced"
    #   resp.db_instance.performance_insights_enabled #=> Boolean
    #   resp.db_instance.performance_insights_kms_key_id #=> String
    #   resp.db_instance.performance_insights_retention_period #=> Integer
    #   resp.db_instance.enabled_cloudwatch_logs_exports #=> Array
    #   resp.db_instance.enabled_cloudwatch_logs_exports[0] #=> String
    #   resp.db_instance.processor_features #=> Array
    #   resp.db_instance.processor_features[0].name #=> String
    #   resp.db_instance.processor_features[0].value #=> String
    #   resp.db_instance.deletion_protection #=> Boolean
    #   resp.db_instance.associated_roles #=> Array
    #   resp.db_instance.associated_roles[0].role_arn #=> String
    #   resp.db_instance.associated_roles[0].feature_name #=> String
    #   resp.db_instance.associated_roles[0].status #=> String
    #   resp.db_instance.listener_endpoint.address #=> String
    #   resp.db_instance.listener_endpoint.port #=> Integer
    #   resp.db_instance.listener_endpoint.hosted_zone_id #=> String
    #   resp.db_instance.max_allocated_storage #=> Integer
    #   resp.db_instance.tag_list #=> Array
    #   resp.db_instance.tag_list[0].key #=> String
    #   resp.db_instance.tag_list[0].value #=> String
    #   resp.db_instance.db_instance_automated_backups_replications #=> Array
    #   resp.db_instance.db_instance_automated_backups_replications[0].db_instance_automated_backups_arn #=> String
    #   resp.db_instance.customer_owned_ip_enabled #=> Boolean
    #   resp.db_instance.aws_backup_recovery_point_arn #=> String
    #   resp.db_instance.activity_stream_status #=> String, one of "stopped", "starting", "started", "stopping"
    #   resp.db_instance.activity_stream_kms_key_id #=> String
    #   resp.db_instance.activity_stream_kinesis_stream_name #=> String
    #   resp.db_instance.activity_stream_mode #=> String, one of "sync", "async"
    #   resp.db_instance.activity_stream_engine_native_audit_fields_included #=> Boolean
    #   resp.db_instance.automation_mode #=> String, one of "full", "all-paused"
    #   resp.db_instance.resume_full_automation_mode_time #=> Time
    #   resp.db_instance.custom_iam_instance_profile #=> String
    #   resp.db_instance.backup_target #=> String
    #   resp.db_instance.network_type #=> String
    #   resp.db_instance.activity_stream_policy_status #=> String, one of "locked", "unlocked", "locking-policy", "unlocking-policy"
    #   resp.db_instance.storage_throughput #=> Integer
    #   resp.db_instance.db_system_id #=> String
    #   resp.db_instance.master_user_secret.secret_arn #=> String
    #   resp.db_instance.master_user_secret.secret_status #=> String
    #   resp.db_instance.master_user_secret.kms_key_id #=> String
    #   resp.db_instance.certificate_details.ca_identifier #=> String
    #   resp.db_instance.certificate_details.valid_till #=> Time
    #   resp.db_instance.read_replica_source_db_cluster_identifier #=> String
    #   resp.db_instance.percent_progress #=> String
    #   resp.db_instance.dedicated_log_volume #=> Boolean
    #   resp.db_instance.is_storage_config_upgrade_available #=> Boolean
    #   resp.db_instance.multi_tenant #=> Boolean
    #   resp.db_instance.engine_lifecycle_support #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplica AWS API Documentation
    #
    # @overload create_db_instance_read_replica(params = {})
    # @param [Hash] params ({})
    def create_db_instance_read_replica(params = {}, options = {})
      req = build_request(:create_db_instance_read_replica, params)
      req.send_request(options)
    end

    # Creates a new DB parameter group.
    #
    # A DB parameter group is initially created with the default parameters
    # for the database engine used by the DB instance. To provide custom
    # values for any of the parameters, you must modify the group after
    # creating it using `ModifyDBParameterGroup`. Once you've created a DB
    # parameter group, you need to associate it with your DB instance using
    # `ModifyDBInstance`. When you associate a new DB parameter group with a
    # running DB instance, you need to reboot the DB instance without
    # failover for the new DB parameter group and associated settings to
    # take effect.
    #
    # This command doesn't apply to RDS Custom.
    #
    # @option params [required, String] :db_parameter_group_name
    #   The name of the DB parameter group.
    #
    #   Constraints:
    #
    #   * Must be 1 to 255 letters, numbers, or hyphens.
    #
    #   * First character must be a letter
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens
    #
    #   <note markdown="1"> This value is stored as a lowercase string.
    #
    #    </note>
    #
    # @option params [required, String] :db_parameter_group_family
    #   The DB parameter group family name. A DB parameter group can be
    #   associated with one and only one DB parameter group family, and can be
    #   applied only to a DB instance running a database engine and engine
    #   version compatible with that DB parameter group family.
    #
    #   To list all of the available parameter group families for a DB engine,
    #   use the following command:
    #
    #   `aws rds describe-db-engine-versions --query
    #   "DBEngineVersions[].DBParameterGroupFamily" --engine <engine>`
    #
    #   For example, to list all of the available parameter group families for
    #   the MySQL DB engine, use the following command:
    #
    #   `aws rds describe-db-engine-versions --query
    #   "DBEngineVersions[].DBParameterGroupFamily" --engine mysql`
    #
    #   <note markdown="1"> The output contains duplicates.
    #
    #    </note>
    #
    #   The following are the valid DB engine values:
    #
    #   * `aurora-mysql`
    #
    #   * `aurora-postgresql`
    #
    #   * `db2-ae`
    #
    #   * `db2-se`
    #
    #   * `mysql`
    #
    #   * `oracle-ee`
    #
    #   * `oracle-ee-cdb`
    #
    #   * `oracle-se2`
    #
    #   * `oracle-se2-cdb`
    #
    #   * `postgres`
    #
    #   * `sqlserver-ee`
    #
    #   * `sqlserver-se`
    #
    #   * `sqlserver-ex`
    #
    #   * `sqlserver-web`
    #
    # @option params [required, String] :description
    #   The description for the DB parameter group.
    #
    # @option params [Array<Types::Tag>] :tags
    #   Tags to assign to the DB parameter group.
    #
    # @return [Types::CreateDBParameterGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDBParameterGroupResult#db_parameter_group #db_parameter_group} => Types::DBParameterGroup
    #
    #
    # @example Example: To create a DB parameter group
    #
    #   # The following example creates a DB parameter group.
    #
    #   resp = client.create_db_parameter_group({
    #     db_parameter_group_family: "MySQL8.0", 
    #     db_parameter_group_name: "mydbparametergroup", 
    #     description: "My new parameter group", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_parameter_group: {
    #       db_parameter_group_arn: "arn:aws:rds:us-east-1:123456789012:pg:mydbparametergroup", 
    #       db_parameter_group_family: "mysql8.0", 
    #       db_parameter_group_name: "mydbparametergroup", 
    #       description: "My new parameter group", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_db_parameter_group({
    #     db_parameter_group_name: "String", # required
    #     db_parameter_group_family: "String", # required
    #     description: "String", # required
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_parameter_group.db_parameter_group_name #=> String
    #   resp.db_parameter_group.db_parameter_group_family #=> String
    #   resp.db_parameter_group.description #=> String
    #   resp.db_parameter_group.db_parameter_group_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroup AWS API Documentation
    #
    # @overload create_db_parameter_group(params = {})
    # @param [Hash] params ({})
    def create_db_parameter_group(params = {}, options = {})
      req = build_request(:create_db_parameter_group, params)
      req.send_request(options)
    end

    # Creates a new DB proxy.
    #
    # @option params [required, String] :db_proxy_name
    #   The identifier for the proxy. This name must be unique for all proxies
    #   owned by your Amazon Web Services account in the specified Amazon Web
    #   Services Region. An identifier must begin with a letter and must
    #   contain only ASCII letters, digits, and hyphens; it can't end with a
    #   hyphen or contain two consecutive hyphens.
    #
    # @option params [required, String] :engine_family
    #   The kinds of databases that the proxy can connect to. This value
    #   determines which database network protocol the proxy recognizes when
    #   it interprets network traffic to and from the database. For Aurora
    #   MySQL, RDS for MariaDB, and RDS for MySQL databases, specify `MYSQL`.
    #   For Aurora PostgreSQL and RDS for PostgreSQL databases, specify
    #   `POSTGRESQL`. For RDS for Microsoft SQL Server, specify `SQLSERVER`.
    #
    # @option params [required, Array<Types::UserAuthConfig>] :auth
    #   The authorization mechanism that the proxy uses.
    #
    # @option params [required, String] :role_arn
    #   The Amazon Resource Name (ARN) of the IAM role that the proxy uses to
    #   access secrets in Amazon Web Services Secrets Manager.
    #
    # @option params [required, Array<String>] :vpc_subnet_ids
    #   One or more VPC subnet IDs to associate with the new proxy.
    #
    # @option params [Array<String>] :vpc_security_group_ids
    #   One or more VPC security group IDs to associate with the new proxy.
    #
    # @option params [Boolean] :require_tls
    #   Specifies whether Transport Layer Security (TLS) encryption is
    #   required for connections to the proxy. By enabling this setting, you
    #   can enforce encrypted TLS connections to the proxy.
    #
    # @option params [Integer] :idle_client_timeout
    #   The number of seconds that a connection to the proxy can be inactive
    #   before the proxy disconnects it. You can set this value higher or
    #   lower than the connection timeout limit for the associated database.
    #
    # @option params [Boolean] :debug_logging
    #   Specifies whether the proxy logs detailed connection and query
    #   information. When you enable `DebugLogging`, the proxy captures
    #   connection details and connection pool behavior from your queries.
    #   Debug logging increases CloudWatch costs and can impact proxy
    #   performance. Enable this option only when you need to troubleshoot
    #   connection or performance issues.
    #
    # @option params [Array<Types::Tag>] :tags
    #   An optional set of key-value pairs to associate arbitrary data of your
    #   choosing with the proxy.
    #
    # @return [Types::CreateDBProxyResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDBProxyResponse#db_proxy #db_proxy} => Types::DBProxy
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_db_proxy({
    #     db_proxy_name: "String", # required
    #     engine_family: "MYSQL", # required, accepts MYSQL, POSTGRESQL, SQLSERVER
    #     auth: [ # required
    #       {
    #         description: "String",
    #         user_name: "String",
    #         auth_scheme: "SECRETS", # accepts SECRETS
    #         secret_arn: "String",
    #         iam_auth: "DISABLED", # accepts DISABLED, REQUIRED, ENABLED
    #         client_password_auth_type: "MYSQL_NATIVE_PASSWORD", # accepts MYSQL_NATIVE_PASSWORD, MYSQL_CACHING_SHA2_PASSWORD, POSTGRES_SCRAM_SHA_256, POSTGRES_MD5, SQL_SERVER_AUTHENTICATION
    #       },
    #     ],
    #     role_arn: "String", # required
    #     vpc_subnet_ids: ["String"], # required
    #     vpc_security_group_ids: ["String"],
    #     require_tls: false,
    #     idle_client_timeout: 1,
    #     debug_logging: false,
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_proxy.db_proxy_name #=> String
    #   resp.db_proxy.db_proxy_arn #=> String
    #   resp.db_proxy.status #=> String, one of "available", "modifying", "incompatible-network", "insufficient-resource-limits", "creating", "deleting", "suspended", "suspending", "reactivating"
    #   resp.db_proxy.engine_family #=> String
    #   resp.db_proxy.vpc_id #=> String
    #   resp.db_proxy.vpc_security_group_ids #=> Array
    #   resp.db_proxy.vpc_security_group_ids[0] #=> String
    #   resp.db_proxy.vpc_subnet_ids #=> Array
    #   resp.db_proxy.vpc_subnet_ids[0] #=> String
    #   resp.db_proxy.auth #=> Array
    #   resp.db_proxy.auth[0].description #=> String
    #   resp.db_proxy.auth[0].user_name #=> String
    #   resp.db_proxy.auth[0].auth_scheme #=> String, one of "SECRETS"
    #   resp.db_proxy.auth[0].secret_arn #=> String
    #   resp.db_proxy.auth[0].iam_auth #=> String, one of "DISABLED", "REQUIRED", "ENABLED"
    #   resp.db_proxy.auth[0].client_password_auth_type #=> String, one of "MYSQL_NATIVE_PASSWORD", "MYSQL_CACHING_SHA2_PASSWORD", "POSTGRES_SCRAM_SHA_256", "POSTGRES_MD5", "SQL_SERVER_AUTHENTICATION"
    #   resp.db_proxy.role_arn #=> String
    #   resp.db_proxy.endpoint #=> String
    #   resp.db_proxy.require_tls #=> Boolean
    #   resp.db_proxy.idle_client_timeout #=> Integer
    #   resp.db_proxy.debug_logging #=> Boolean
    #   resp.db_proxy.created_date #=> Time
    #   resp.db_proxy.updated_date #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxy AWS API Documentation
    #
    # @overload create_db_proxy(params = {})
    # @param [Hash] params ({})
    def create_db_proxy(params = {}, options = {})
      req = build_request(:create_db_proxy, params)
      req.send_request(options)
    end

    # Creates a `DBProxyEndpoint`. Only applies to proxies that are
    # associated with Aurora DB clusters. You can use DB proxy endpoints to
    # specify read/write or read-only access to the DB cluster. You can also
    # use DB proxy endpoints to access a DB proxy through a different VPC
    # than the proxy's default VPC.
    #
    # @option params [required, String] :db_proxy_name
    #   The name of the DB proxy associated with the DB proxy endpoint that
    #   you create.
    #
    # @option params [required, String] :db_proxy_endpoint_name
    #   The name of the DB proxy endpoint to create.
    #
    # @option params [required, Array<String>] :vpc_subnet_ids
    #   The VPC subnet IDs for the DB proxy endpoint that you create. You can
    #   specify a different set of subnet IDs than for the original DB proxy.
    #
    # @option params [Array<String>] :vpc_security_group_ids
    #   The VPC security group IDs for the DB proxy endpoint that you create.
    #   You can specify a different set of security group IDs than for the
    #   original DB proxy. The default is the default security group for the
    #   VPC.
    #
    # @option params [String] :target_role
    #   The role of the DB proxy endpoint. The role determines whether the
    #   endpoint can be used for read/write or only read operations. The
    #   default is `READ_WRITE`. The only role that proxies for RDS for
    #   Microsoft SQL Server support is `READ_WRITE`.
    #
    # @option params [Array<Types::Tag>] :tags
    #   A list of tags.
    #
    #   For more information, see [Tagging Amazon RDS resources][1] in the
    #   *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS
    #   resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @return [Types::CreateDBProxyEndpointResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDBProxyEndpointResponse#db_proxy_endpoint #db_proxy_endpoint} => Types::DBProxyEndpoint
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_db_proxy_endpoint({
    #     db_proxy_name: "DBProxyName", # required
    #     db_proxy_endpoint_name: "DBProxyEndpointName", # required
    #     vpc_subnet_ids: ["String"], # required
    #     vpc_security_group_ids: ["String"],
    #     target_role: "READ_WRITE", # accepts READ_WRITE, READ_ONLY
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_proxy_endpoint.db_proxy_endpoint_name #=> String
    #   resp.db_proxy_endpoint.db_proxy_endpoint_arn #=> String
    #   resp.db_proxy_endpoint.db_proxy_name #=> String
    #   resp.db_proxy_endpoint.status #=> String, one of "available", "modifying", "incompatible-network", "insufficient-resource-limits", "creating", "deleting"
    #   resp.db_proxy_endpoint.vpc_id #=> String
    #   resp.db_proxy_endpoint.vpc_security_group_ids #=> Array
    #   resp.db_proxy_endpoint.vpc_security_group_ids[0] #=> String
    #   resp.db_proxy_endpoint.vpc_subnet_ids #=> Array
    #   resp.db_proxy_endpoint.vpc_subnet_ids[0] #=> String
    #   resp.db_proxy_endpoint.endpoint #=> String
    #   resp.db_proxy_endpoint.created_date #=> Time
    #   resp.db_proxy_endpoint.target_role #=> String, one of "READ_WRITE", "READ_ONLY"
    #   resp.db_proxy_endpoint.is_default #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxyEndpoint AWS API Documentation
    #
    # @overload create_db_proxy_endpoint(params = {})
    # @param [Hash] params ({})
    def create_db_proxy_endpoint(params = {}, options = {})
      req = build_request(:create_db_proxy_endpoint, params)
      req.send_request(options)
    end

    # Creates a new DB security group. DB security groups control access to
    # a DB instance.
    #
    # A DB security group controls access to EC2-Classic DB instances that
    # are not in a VPC.
    #
    # <note markdown="1"> EC2-Classic was retired on August 15, 2022. If you haven't migrated
    # from EC2-Classic to a VPC, we recommend that you migrate as soon as
    # possible. For more information, see [Migrate from EC2-Classic to a
    # VPC][1] in the *Amazon EC2 User Guide*, the blog [EC2-Classic
    # Networking is Retiring – Here’s How to Prepare][2], and [Moving a DB
    # instance not in a VPC into a VPC][3] in the *Amazon RDS User Guide*.
    #
    #  </note>
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html
    # [2]: http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/
    # [3]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html
    #
    # @option params [required, String] :db_security_group_name
    #   The name for the DB security group. This value is stored as a
    #   lowercase string.
    #
    #   Constraints:
    #
    #   * Must be 1 to 255 letters, numbers, or hyphens.
    #
    #   * First character must be a letter
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens
    #
    #   * Must not be "Default"
    #
    #   Example: `mysecuritygroup`
    #
    # @option params [required, String] :db_security_group_description
    #   The description for the DB security group.
    #
    # @option params [Array<Types::Tag>] :tags
    #   Tags to assign to the DB security group.
    #
    # @return [Types::CreateDBSecurityGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDBSecurityGroupResult#db_security_group #db_security_group} => Types::DBSecurityGroup
    #
    #
    # @example Example: To create a DB security group.
    #
    #   # This example creates a DB security group.
    #
    #   resp = client.create_db_security_group({
    #     db_security_group_description: "My DB security group", 
    #     db_security_group_name: "mydbsecuritygroup", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_security_group: {
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_db_security_group({
    #     db_security_group_name: "String", # required
    #     db_security_group_description: "String", # required
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_security_group.owner_id #=> String
    #   resp.db_security_group.db_security_group_name #=> String
    #   resp.db_security_group.db_security_group_description #=> String
    #   resp.db_security_group.vpc_id #=> String
    #   resp.db_security_group.ec2_security_groups #=> Array
    #   resp.db_security_group.ec2_security_groups[0].status #=> String
    #   resp.db_security_group.ec2_security_groups[0].ec2_security_group_name #=> String
    #   resp.db_security_group.ec2_security_groups[0].ec2_security_group_id #=> String
    #   resp.db_security_group.ec2_security_groups[0].ec2_security_group_owner_id #=> String
    #   resp.db_security_group.ip_ranges #=> Array
    #   resp.db_security_group.ip_ranges[0].status #=> String
    #   resp.db_security_group.ip_ranges[0].cidrip #=> String
    #   resp.db_security_group.db_security_group_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroup AWS API Documentation
    #
    # @overload create_db_security_group(params = {})
    # @param [Hash] params ({})
    def create_db_security_group(params = {}, options = {})
      req = build_request(:create_db_security_group, params)
      req.send_request(options)
    end

    # Creates a new DB shard group for Aurora Limitless Database. You must
    # enable Aurora Limitless Database to create a DB shard group.
    #
    # Valid for: Aurora DB clusters only
    #
    # @option params [required, String] :db_shard_group_identifier
    #   The name of the DB shard group.
    #
    # @option params [required, String] :db_cluster_identifier
    #   The name of the primary DB cluster for the DB shard group.
    #
    # @option params [Integer] :compute_redundancy
    #   Specifies whether to create standby standby DB data access shard for
    #   the DB shard group. Valid values are the following:
    #
    #   * 0 - Creates a DB shard group without a standby DB data access shard.
    #     This is the default value.
    #
    #   * 1 - Creates a DB shard group with a standby DB data access shard in
    #     a different Availability Zone (AZ).
    #
    #   * 2 - Creates a DB shard group with two standby DB data access shard
    #     in two different AZs.
    #
    # @option params [required, Float] :max_acu
    #   The maximum capacity of the DB shard group in Aurora capacity units
    #   (ACUs).
    #
    # @option params [Float] :min_acu
    #   The minimum capacity of the DB shard group in Aurora capacity units
    #   (ACUs).
    #
    # @option params [Boolean] :publicly_accessible
    #   Specifies whether the DB shard group is publicly accessible.
    #
    #   When the DB shard group is publicly accessible, its Domain Name System
    #   (DNS) endpoint resolves to the private IP address from within the DB
    #   shard group's virtual private cloud (VPC). It resolves to the public
    #   IP address from outside of the DB shard group's VPC. Access to the DB
    #   shard group is ultimately controlled by the security group it uses.
    #   That public access is not permitted if the security group assigned to
    #   the DB shard group doesn't permit it.
    #
    #   When the DB shard group isn't publicly accessible, it is an internal
    #   DB shard group with a DNS name that resolves to a private IP address.
    #
    #   Default: The default behavior varies depending on whether
    #   `DBSubnetGroupName` is specified.
    #
    #   If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible`
    #   isn't specified, the following applies:
    #
    #   * If the default VPC in the target Region doesn’t have an internet
    #     gateway attached to it, the DB shard group is private.
    #
    #   * If the default VPC in the target Region has an internet gateway
    #     attached to it, the DB shard group is public.
    #
    #   If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't
    #   specified, the following applies:
    #
    #   * If the subnets are part of a VPC that doesn’t have an internet
    #     gateway attached to it, the DB shard group is private.
    #
    #   * If the subnets are part of a VPC that has an internet gateway
    #     attached to it, the DB shard group is public.
    #
    # @option params [Array<Types::Tag>] :tags
    #   A list of tags.
    #
    #   For more information, see [Tagging Amazon RDS resources][1] in the
    #   *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS
    #   resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @return [Types::DBShardGroup] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBShardGroup#db_shard_group_resource_id #db_shard_group_resource_id} => String
    #   * {Types::DBShardGroup#db_shard_group_identifier #db_shard_group_identifier} => String
    #   * {Types::DBShardGroup#db_cluster_identifier #db_cluster_identifier} => String
    #   * {Types::DBShardGroup#max_acu #max_acu} => Float
    #   * {Types::DBShardGroup#min_acu #min_acu} => Float
    #   * {Types::DBShardGroup#compute_redundancy #compute_redundancy} => Integer
    #   * {Types::DBShardGroup#status #status} => String
    #   * {Types::DBShardGroup#publicly_accessible #publicly_accessible} => Boolean
    #   * {Types::DBShardGroup#endpoint #endpoint} => String
    #   * {Types::DBShardGroup#db_shard_group_arn #db_shard_group_arn} => String
    #   * {Types::DBShardGroup#tag_list #tag_list} => Array&lt;Types::Tag&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_db_shard_group({
    #     db_shard_group_identifier: "String", # required
    #     db_cluster_identifier: "String", # required
    #     compute_redundancy: 1,
    #     max_acu: 1.0, # required
    #     min_acu: 1.0,
    #     publicly_accessible: false,
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_shard_group_resource_id #=> String
    #   resp.db_shard_group_identifier #=> String
    #   resp.db_cluster_identifier #=> String
    #   resp.max_acu #=> Float
    #   resp.min_acu #=> Float
    #   resp.compute_redundancy #=> Integer
    #   resp.status #=> String
    #   resp.publicly_accessible #=> Boolean
    #   resp.endpoint #=> String
    #   resp.db_shard_group_arn #=> String
    #   resp.tag_list #=> Array
    #   resp.tag_list[0].key #=> String
    #   resp.tag_list[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBShardGroup AWS API Documentation
    #
    # @overload create_db_shard_group(params = {})
    # @param [Hash] params ({})
    def create_db_shard_group(params = {}, options = {})
      req = build_request(:create_db_shard_group, params)
      req.send_request(options)
    end

    # Creates a snapshot of a DB instance. The source DB instance must be in
    # the `available` or `storage-optimization` state.
    #
    # @option params [required, String] :db_snapshot_identifier
    #   The identifier for the DB snapshot.
    #
    #   Constraints:
    #
    #   * Can't be null, empty, or blank
    #
    #   * Must contain from 1 to 255 letters, numbers, or hyphens
    #
    #   * First character must be a letter
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens
    #
    #   Example: `my-snapshot-id`
    #
    # @option params [required, String] :db_instance_identifier
    #   The identifier of the DB instance that you want to create the snapshot
    #   of.
    #
    #   Constraints:
    #
    #   * Must match the identifier of an existing DBInstance.
    #
    #   ^
    #
    # @option params [Array<Types::Tag>] :tags
    #   A list of tags.
    #
    #   For more information, see [Tagging Amazon RDS resources][1] in the
    #   *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS
    #   resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @return [Types::CreateDBSnapshotResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDBSnapshotResult#db_snapshot #db_snapshot} => Types::DBSnapshot
    #
    #
    # @example Example: To create a DB snapshot
    #
    #   # The following example creates a DB snapshot.
    #
    #   resp = client.create_db_snapshot({
    #     db_instance_identifier: "mydbsnapshot", 
    #     db_snapshot_identifier: "database-mysql", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_snapshot: {
    #       allocated_storage: 100, 
    #       availability_zone: "us-east-1b", 
    #       db_instance_identifier: "database-mysql", 
    #       db_snapshot_arn: "arn:aws:rds:us-east-1:123456789012:snapshot:mydbsnapshot", 
    #       db_snapshot_identifier: "mydbsnapshot", 
    #       dbi_resource_id: "db-AKIAIOSFODNN7EXAMPLE", 
    #       encrypted: true, 
    #       engine: "mysql", 
    #       engine_version: "8.0.32", 
    #       iam_database_authentication_enabled: false, 
    #       instance_create_time: Time.parse("2019-04-30T15:45:53.663Z"), 
    #       iops: 1000, 
    #       kms_key_id: "arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE", 
    #       license_model: "general-public-license", 
    #       master_username: "admin", 
    #       option_group_name: "default:mysql-8-0", 
    #       percent_progress: 0, 
    #       port: 3306, 
    #       processor_features: [
    #       ], 
    #       snapshot_type: "manual", 
    #       status: "creating", 
    #       storage_type: "io1", 
    #       vpc_id: "vpc-6594f31c", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_db_snapshot({
    #     db_snapshot_identifier: "String", # required
    #     db_instance_identifier: "String", # required
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_snapshot.db_snapshot_identifier #=> String
    #   resp.db_snapshot.db_instance_identifier #=> String
    #   resp.db_snapshot.snapshot_create_time #=> Time
    #   resp.db_snapshot.engine #=> String
    #   resp.db_snapshot.allocated_storage #=> Integer
    #   resp.db_snapshot.status #=> String
    #   resp.db_snapshot.port #=> Integer
    #   resp.db_snapshot.availability_zone #=> String
    #   resp.db_snapshot.vpc_id #=> String
    #   resp.db_snapshot.instance_create_time #=> Time
    #   resp.db_snapshot.master_username #=> String
    #   resp.db_snapshot.engine_version #=> String
    #   resp.db_snapshot.license_model #=> String
    #   resp.db_snapshot.snapshot_type #=> String
    #   resp.db_snapshot.iops #=> Integer
    #   resp.db_snapshot.option_group_name #=> String
    #   resp.db_snapshot.percent_progress #=> Integer
    #   resp.db_snapshot.source_region #=> String
    #   resp.db_snapshot.source_db_snapshot_identifier #=> String
    #   resp.db_snapshot.storage_type #=> String
    #   resp.db_snapshot.tde_credential_arn #=> String
    #   resp.db_snapshot.encrypted #=> Boolean
    #   resp.db_snapshot.kms_key_id #=> String
    #   resp.db_snapshot.db_snapshot_arn #=> String
    #   resp.db_snapshot.timezone #=> String
    #   resp.db_snapshot.iam_database_authentication_enabled #=> Boolean
    #   resp.db_snapshot.processor_features #=> Array
    #   resp.db_snapshot.processor_features[0].name #=> String
    #   resp.db_snapshot.processor_features[0].value #=> String
    #   resp.db_snapshot.dbi_resource_id #=> String
    #   resp.db_snapshot.tag_list #=> Array
    #   resp.db_snapshot.tag_list[0].key #=> String
    #   resp.db_snapshot.tag_list[0].value #=> String
    #   resp.db_snapshot.original_snapshot_create_time #=> Time
    #   resp.db_snapshot.snapshot_database_time #=> Time
    #   resp.db_snapshot.snapshot_target #=> String
    #   resp.db_snapshot.storage_throughput #=> Integer
    #   resp.db_snapshot.db_system_id #=> String
    #   resp.db_snapshot.dedicated_log_volume #=> Boolean
    #   resp.db_snapshot.multi_tenant #=> Boolean
    #   resp.db_snapshot.snapshot_availability_zone #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshot AWS API Documentation
    #
    # @overload create_db_snapshot(params = {})
    # @param [Hash] params ({})
    def create_db_snapshot(params = {}, options = {})
      req = build_request(:create_db_snapshot, params)
      req.send_request(options)
    end

    # Creates a new DB subnet group. DB subnet groups must contain at least
    # one subnet in at least two AZs in the Amazon Web Services Region.
    #
    # @option params [required, String] :db_subnet_group_name
    #   The name for the DB subnet group. This value is stored as a lowercase
    #   string.
    #
    #   Constraints:
    #
    #   * Must contain no more than 255 letters, numbers, periods,
    #     underscores, spaces, or hyphens.
    #
    #   * Must not be default.
    #
    #   * First character must be a letter.
    #
    #   Example: `mydbsubnetgroup`
    #
    # @option params [required, String] :db_subnet_group_description
    #   The description for the DB subnet group.
    #
    # @option params [required, Array<String>] :subnet_ids
    #   The EC2 Subnet IDs for the DB subnet group.
    #
    # @option params [Array<Types::Tag>] :tags
    #   Tags to assign to the DB subnet group.
    #
    # @return [Types::CreateDBSubnetGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDBSubnetGroupResult#db_subnet_group #db_subnet_group} => Types::DBSubnetGroup
    #
    #
    # @example Example: To create a DB subnet group
    #
    #   # The following example creates a DB subnet group called mysubnetgroup using existing subnets.
    #
    #   resp = client.create_db_subnet_group({
    #     db_subnet_group_description: "test DB subnet group", 
    #     db_subnet_group_name: "mysubnetgroup", 
    #     subnet_ids: [
    #       "subnet-0a1dc4e1a6f123456", 
    #       "subnet-070dd7ecb3aaaaaaa", 
    #       "subnet-00f5b198bc0abcdef", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_subnet_group: {
    #       db_subnet_group_arn: "arn:aws:rds:us-west-2:0123456789012:subgrp:mysubnetgroup", 
    #       db_subnet_group_description: "test DB subnet group", 
    #       db_subnet_group_name: "mysubnetgroup", 
    #       subnet_group_status: "Complete", 
    #       subnets: [
    #         {
    #           subnet_availability_zone: {
    #             name: "us-west-2b", 
    #           }, 
    #           subnet_identifier: "subnet-070dd7ecb3aaaaaaa", 
    #           subnet_status: "Active", 
    #         }, 
    #         {
    #           subnet_availability_zone: {
    #             name: "us-west-2d", 
    #           }, 
    #           subnet_identifier: "subnet-00f5b198bc0abcdef", 
    #           subnet_status: "Active", 
    #         }, 
    #         {
    #           subnet_availability_zone: {
    #             name: "us-west-2b", 
    #           }, 
    #           subnet_identifier: "subnet-0a1dc4e1a6f123456", 
    #           subnet_status: "Active", 
    #         }, 
    #       ], 
    #       vpc_id: "vpc-0f08e7610a1b2c3d4", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_db_subnet_group({
    #     db_subnet_group_name: "String", # required
    #     db_subnet_group_description: "String", # required
    #     subnet_ids: ["String"], # required
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_subnet_group.db_subnet_group_name #=> String
    #   resp.db_subnet_group.db_subnet_group_description #=> String
    #   resp.db_subnet_group.vpc_id #=> String
    #   resp.db_subnet_group.subnet_group_status #=> String
    #   resp.db_subnet_group.subnets #=> Array
    #   resp.db_subnet_group.subnets[0].subnet_identifier #=> String
    #   resp.db_subnet_group.subnets[0].subnet_availability_zone.name #=> String
    #   resp.db_subnet_group.subnets[0].subnet_outpost.arn #=> String
    #   resp.db_subnet_group.subnets[0].subnet_status #=> String
    #   resp.db_subnet_group.db_subnet_group_arn #=> String
    #   resp.db_subnet_group.supported_network_types #=> Array
    #   resp.db_subnet_group.supported_network_types[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroup AWS API Documentation
    #
    # @overload create_db_subnet_group(params = {})
    # @param [Hash] params ({})
    def create_db_subnet_group(params = {}, options = {})
      req = build_request(:create_db_subnet_group, params)
      req.send_request(options)
    end

    # Creates an RDS event notification subscription. This operation
    # requires a topic Amazon Resource Name (ARN) created by either the RDS
    # console, the SNS console, or the SNS API. To obtain an ARN with SNS,
    # you must create a topic in Amazon SNS and subscribe to the topic. The
    # ARN is displayed in the SNS console.
    #
    # You can specify the type of source (`SourceType`) that you want to be
    # notified of and provide a list of RDS sources (`SourceIds`) that
    # triggers the events. You can also provide a list of event categories
    # (`EventCategories`) for events that you want to be notified of. For
    # example, you can specify `SourceType` = `db-instance`, `SourceIds` =
    # `mydbinstance1`, `mydbinstance2` and `EventCategories` =
    # `Availability`, `Backup`.
    #
    # If you specify both the `SourceType` and `SourceIds`, such as
    # `SourceType` = `db-instance` and `SourceIds` = `myDBInstance1`, you
    # are notified of all the `db-instance` events for the specified source.
    # If you specify a `SourceType` but do not specify `SourceIds`, you
    # receive notice of the events for that source type for all your RDS
    # sources. If you don't specify either the SourceType or the
    # `SourceIds`, you are notified of events generated from all RDS sources
    # belonging to your customer account.
    #
    # For more information about subscribing to an event for RDS DB engines,
    # see [ Subscribing to Amazon RDS event notification][1] in the *Amazon
    # RDS User Guide*.
    #
    # For more information about subscribing to an event for Aurora DB
    # engines, see [ Subscribing to Amazon RDS event notification][2] in the
    # *Amazon Aurora User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Subscribing.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Subscribing.html
    #
    # @option params [required, String] :subscription_name
    #   The name of the subscription.
    #
    #   Constraints: The name must be less than 255 characters.
    #
    # @option params [required, String] :sns_topic_arn
    #   The Amazon Resource Name (ARN) of the SNS topic created for event
    #   notification. SNS automatically creates the ARN when you create a
    #   topic and subscribe to it.
    #
    #   <note markdown="1"> RDS doesn't support FIFO (first in, first out) topics. For more
    #   information, see [Message ordering and deduplication (FIFO topics)][1]
    #   in the *Amazon Simple Notification Service Developer Guide*.
    #
    #    </note>
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html
    #
    # @option params [String] :source_type
    #   The type of source that is generating the events. For example, if you
    #   want to be notified of events generated by a DB instance, you set this
    #   parameter to `db-instance`. For RDS Proxy events, specify `db-proxy`.
    #   If this value isn't specified, all events are returned.
    #
    #   Valid Values:` db-instance | db-cluster | db-parameter-group |
    #   db-security-group | db-snapshot | db-cluster-snapshot | db-proxy |
    #   zero-etl | custom-engine-version | blue-green-deployment `
    #
    # @option params [Array<String>] :event_categories
    #   A list of event categories for a particular source type (`SourceType`)
    #   that you want to subscribe to. You can see a list of the categories
    #   for a given source type in the "Amazon RDS event categories and event
    #   messages" section of the [ *Amazon RDS User Guide* ][1] or the [
    #   *Amazon Aurora User Guide* ][2]. You can also see this list by using
    #   the `DescribeEventCategories` operation.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html
    #
    # @option params [Array<String>] :source_ids
    #   The list of identifiers of the event sources for which events are
    #   returned. If not specified, then all sources are included in the
    #   response. An identifier must begin with a letter and must contain only
    #   ASCII letters, digits, and hyphens. It can't end with a hyphen or
    #   contain two consecutive hyphens.
    #
    #   Constraints:
    #
    #   * If `SourceIds` are supplied, `SourceType` must also be provided.
    #
    #   * If the source type is a DB instance, a `DBInstanceIdentifier` value
    #     must be supplied.
    #
    #   * If the source type is a DB cluster, a `DBClusterIdentifier` value
    #     must be supplied.
    #
    #   * If the source type is a DB parameter group, a `DBParameterGroupName`
    #     value must be supplied.
    #
    #   * If the source type is a DB security group, a `DBSecurityGroupName`
    #     value must be supplied.
    #
    #   * If the source type is a DB snapshot, a `DBSnapshotIdentifier` value
    #     must be supplied.
    #
    #   * If the source type is a DB cluster snapshot, a
    #     `DBClusterSnapshotIdentifier` value must be supplied.
    #
    #   * If the source type is an RDS Proxy, a `DBProxyName` value must be
    #     supplied.
    #
    # @option params [Boolean] :enabled
    #   Specifies whether to activate the subscription. If the event
    #   notification subscription isn't activated, the subscription is
    #   created but not active.
    #
    # @option params [Array<Types::Tag>] :tags
    #   A list of tags.
    #
    #   For more information, see [Tagging Amazon RDS resources][1] in the
    #   *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS
    #   resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @return [Types::CreateEventSubscriptionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateEventSubscriptionResult#event_subscription #event_subscription} => Types::EventSubscription
    #
    #
    # @example Example: To create an event subscription
    #
    #   # The following example creates a subscription for backup and recovery events for DB instances in the current AWS account.
    #   # Notifications are sent to an Amazon Simple Notification Service topic.
    #
    #   resp = client.create_event_subscription({
    #     event_categories: [
    #       "backup", 
    #       "recovery", 
    #     ], 
    #     sns_topic_arn: "arn:aws:sns:us-east-1:123456789012:interesting-events", 
    #     source_type: "db-instance", 
    #     subscription_name: "my-instance-events", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     event_subscription: {
    #       cust_subscription_id: "my-instance-events", 
    #       customer_aws_id: "123456789012", 
    #       enabled: true, 
    #       event_categories_list: [
    #         "backup", 
    #         "recovery", 
    #       ], 
    #       event_subscription_arn: "arn:aws:rds:us-east-1:123456789012:es:my-instance-events", 
    #       sns_topic_arn: "arn:aws:sns:us-east-1:123456789012:interesting-events", 
    #       source_type: "db-instance", 
    #       status: "creating", 
    #       subscription_creation_time: "Tue Jul 31 23:22:01 UTC 2018", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_event_subscription({
    #     subscription_name: "String", # required
    #     sns_topic_arn: "String", # required
    #     source_type: "String",
    #     event_categories: ["String"],
    #     source_ids: ["String"],
    #     enabled: false,
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.event_subscription.customer_aws_id #=> String
    #   resp.event_subscription.cust_subscription_id #=> String
    #   resp.event_subscription.sns_topic_arn #=> String
    #   resp.event_subscription.status #=> String
    #   resp.event_subscription.subscription_creation_time #=> String
    #   resp.event_subscription.source_type #=> String
    #   resp.event_subscription.source_ids_list #=> Array
    #   resp.event_subscription.source_ids_list[0] #=> String
    #   resp.event_subscription.event_categories_list #=> Array
    #   resp.event_subscription.event_categories_list[0] #=> String
    #   resp.event_subscription.enabled #=> Boolean
    #   resp.event_subscription.event_subscription_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscription AWS API Documentation
    #
    # @overload create_event_subscription(params = {})
    # @param [Hash] params ({})
    def create_event_subscription(params = {}, options = {})
      req = build_request(:create_event_subscription, params)
      req.send_request(options)
    end

    # Creates an Aurora global database spread across multiple Amazon Web
    # Services Regions. The global database contains a single primary
    # cluster with read-write capability, and a read-only secondary cluster
    # that receives data from the primary cluster through high-speed
    # replication performed by the Aurora storage subsystem.
    #
    # You can create a global database that is initially empty, and then
    # create the primary and secondary DB clusters in the global database.
    # Or you can specify an existing Aurora cluster during the create
    # operation, and this cluster becomes the primary cluster of the global
    # database.
    #
    # <note markdown="1"> This operation applies only to Aurora DB clusters.
    #
    #  </note>
    #
    # @option params [String] :global_cluster_identifier
    #   The cluster identifier for this global database cluster. This
    #   parameter is stored as a lowercase string.
    #
    # @option params [String] :source_db_cluster_identifier
    #   The Amazon Resource Name (ARN) to use as the primary cluster of the
    #   global database.
    #
    #   If you provide a value for this parameter, don't specify values for
    #   the following settings because Amazon Aurora uses the values from the
    #   specified source DB cluster:
    #
    #   * `DatabaseName`
    #
    #   * `Engine`
    #
    #   * `EngineVersion`
    #
    #   * `StorageEncrypted`
    #
    # @option params [String] :engine
    #   The database engine to use for this global database cluster.
    #
    #   Valid Values: `aurora-mysql | aurora-postgresql`
    #
    #   Constraints:
    #
    #   * Can't be specified if `SourceDBClusterIdentifier` is specified. In
    #     this case, Amazon Aurora uses the engine of the source DB cluster.
    #
    #   ^
    #
    # @option params [String] :engine_version
    #   The engine version to use for this global database cluster.
    #
    #   Constraints:
    #
    #   * Can't be specified if `SourceDBClusterIdentifier` is specified. In
    #     this case, Amazon Aurora uses the engine version of the source DB
    #     cluster.
    #
    #   ^
    #
    # @option params [String] :engine_lifecycle_support
    #   The life cycle type for this global database cluster.
    #
    #   <note markdown="1"> By default, this value is set to `open-source-rds-extended-support`,
    #   which enrolls your global cluster into Amazon RDS Extended Support. At
    #   the end of standard support, you can avoid charges for Extended
    #   Support by setting the value to
    #   `open-source-rds-extended-support-disabled`. In this case, creating
    #   the global cluster will fail if the DB major version is past its end
    #   of standard support date.
    #
    #    </note>
    #
    #   This setting only applies to Aurora PostgreSQL-based global databases.
    #
    #   You can use this setting to enroll your global cluster into Amazon RDS
    #   Extended Support. With RDS Extended Support, you can run the selected
    #   major engine version on your global cluster past the end of standard
    #   support for that engine version. For more information, see [Amazon RDS
    #   Extended Support with Amazon Aurora][1] in the *Amazon Aurora User
    #   Guide*.
    #
    #   Valid Values: `open-source-rds-extended-support |
    #   open-source-rds-extended-support-disabled`
    #
    #   Default: `open-source-rds-extended-support`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html
    #
    # @option params [Boolean] :deletion_protection
    #   Specifies whether to enable deletion protection for the new global
    #   database cluster. The global database can't be deleted when deletion
    #   protection is enabled.
    #
    # @option params [String] :database_name
    #   The name for your database of up to 64 alphanumeric characters. If you
    #   don't specify a name, Amazon Aurora doesn't create a database in the
    #   global database cluster.
    #
    #   Constraints:
    #
    #   * Can't be specified if `SourceDBClusterIdentifier` is specified. In
    #     this case, Amazon Aurora uses the database name from the source DB
    #     cluster.
    #
    #   ^
    #
    # @option params [Boolean] :storage_encrypted
    #   Specifies whether to enable storage encryption for the new global
    #   database cluster.
    #
    #   Constraints:
    #
    #   * Can't be specified if `SourceDBClusterIdentifier` is specified. In
    #     this case, Amazon Aurora uses the setting from the source DB
    #     cluster.
    #
    #   ^
    #
    # @option params [Array<Types::Tag>] :tags
    #   Tags to assign to the global cluster.
    #
    # @return [Types::CreateGlobalClusterResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateGlobalClusterResult#global_cluster #global_cluster} => Types::GlobalCluster
    #
    #
    # @example Example: To create a global DB cluster
    #
    #   # The following example creates a new Aurora MySQL-compatible global DB cluster.
    #
    #   resp = client.create_global_cluster({
    #     engine: "aurora-mysql", 
    #     global_cluster_identifier: "myglobalcluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     global_cluster: {
    #       deletion_protection: false, 
    #       engine: "aurora-mysql", 
    #       engine_version: "5.7.mysql_aurora.2.07.2", 
    #       global_cluster_arn: "arn:aws:rds::123456789012:global-cluster:myglobalcluster", 
    #       global_cluster_identifier: "myglobalcluster", 
    #       global_cluster_members: [
    #       ], 
    #       global_cluster_resource_id: "cluster-f0e523bfe07aabb", 
    #       status: "available", 
    #       storage_encrypted: false, 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_global_cluster({
    #     global_cluster_identifier: "String",
    #     source_db_cluster_identifier: "String",
    #     engine: "String",
    #     engine_version: "String",
    #     engine_lifecycle_support: "String",
    #     deletion_protection: false,
    #     database_name: "String",
    #     storage_encrypted: false,
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.global_cluster.global_cluster_identifier #=> String
    #   resp.global_cluster.global_cluster_resource_id #=> String
    #   resp.global_cluster.global_cluster_arn #=> String
    #   resp.global_cluster.status #=> String
    #   resp.global_cluster.engine #=> String
    #   resp.global_cluster.engine_version #=> String
    #   resp.global_cluster.engine_lifecycle_support #=> String
    #   resp.global_cluster.database_name #=> String
    #   resp.global_cluster.storage_encrypted #=> Boolean
    #   resp.global_cluster.deletion_protection #=> Boolean
    #   resp.global_cluster.global_cluster_members #=> Array
    #   resp.global_cluster.global_cluster_members[0].db_cluster_arn #=> String
    #   resp.global_cluster.global_cluster_members[0].readers #=> Array
    #   resp.global_cluster.global_cluster_members[0].readers[0] #=> String
    #   resp.global_cluster.global_cluster_members[0].is_writer #=> Boolean
    #   resp.global_cluster.global_cluster_members[0].global_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "unknown"
    #   resp.global_cluster.global_cluster_members[0].synchronization_status #=> String, one of "connected", "pending-resync"
    #   resp.global_cluster.endpoint #=> String
    #   resp.global_cluster.failover_state.status #=> String, one of "pending", "failing-over", "cancelling"
    #   resp.global_cluster.failover_state.from_db_cluster_arn #=> String
    #   resp.global_cluster.failover_state.to_db_cluster_arn #=> String
    #   resp.global_cluster.failover_state.is_data_loss_allowed #=> Boolean
    #   resp.global_cluster.tag_list #=> Array
    #   resp.global_cluster.tag_list[0].key #=> String
    #   resp.global_cluster.tag_list[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateGlobalCluster AWS API Documentation
    #
    # @overload create_global_cluster(params = {})
    # @param [Hash] params ({})
    def create_global_cluster(params = {}, options = {})
      req = build_request(:create_global_cluster, params)
      req.send_request(options)
    end

    # Creates a zero-ETL integration with Amazon Redshift.
    #
    # @option params [required, String] :source_arn
    #   The Amazon Resource Name (ARN) of the database to use as the source
    #   for replication.
    #
    # @option params [required, String] :target_arn
    #   The ARN of the Redshift data warehouse to use as the target for
    #   replication.
    #
    # @option params [required, String] :integration_name
    #   The name of the integration.
    #
    # @option params [String] :kms_key_id
    #   The Amazon Web Services Key Management System (Amazon Web Services
    #   KMS) key identifier for the key to use to encrypt the integration. If
    #   you don't specify an encryption key, RDS uses a default Amazon Web
    #   Services owned key.
    #
    # @option params [Hash<String,String>] :additional_encryption_context
    #   An optional set of non-secret key–value pairs that contains additional
    #   contextual information about the data. For more information, see
    #   [Encryption context][1] in the *Amazon Web Services Key Management
    #   Service Developer Guide*.
    #
    #   You can only include this parameter if you specify the `KMSKeyId`
    #   parameter.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context
    #
    # @option params [Array<Types::Tag>] :tags
    #   A list of tags.
    #
    #   For more information, see [Tagging Amazon RDS resources][1] in the
    #   *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS
    #   resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @option params [String] :data_filter
    #   Data filtering options for the integration. For more information, see
    #   [Data filtering for Aurora zero-ETL integrations with Amazon
    #   Redshift][1] or [Data filtering for Amazon RDS zero-ETL integrations
    #   with Amazon Redshift][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/zero-etl.filtering.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/zero-etl.filtering.html
    #
    # @option params [String] :description
    #   A description of the integration.
    #
    # @return [Types::Integration] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::Integration#source_arn #source_arn} => String
    #   * {Types::Integration#target_arn #target_arn} => String
    #   * {Types::Integration#integration_name #integration_name} => String
    #   * {Types::Integration#integration_arn #integration_arn} => String
    #   * {Types::Integration#kms_key_id #kms_key_id} => String
    #   * {Types::Integration#additional_encryption_context #additional_encryption_context} => Hash&lt;String,String&gt;
    #   * {Types::Integration#status #status} => String
    #   * {Types::Integration#tags #tags} => Array&lt;Types::Tag&gt;
    #   * {Types::Integration#create_time #create_time} => Time
    #   * {Types::Integration#errors #errors} => Array&lt;Types::IntegrationError&gt;
    #   * {Types::Integration#data_filter #data_filter} => String
    #   * {Types::Integration#description #description} => String
    #
    #
    # @example Example: To create a zero-ETL integration
    #
    #   # The following example creates a zero-ETL integration with Amazon Redshift.
    #
    #   resp = client.create_integration({
    #     integration_name: "my-integration", 
    #     source_arn: "arn:aws:rds:us-east-1:123456789012:cluster:my-cluster", 
    #     target_arn: "arn:aws:redshift-serverless:us-east-1:123456789012:namespace/62c70612-0302-4db7-8414-b5e3e049f0d8", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     create_time: Time.parse("2023-12-28T17:20:20.629Z"), 
    #     integration_arn: "arn:aws:rds:us-east-1:123456789012:integration:5b9f3d79-7392-4a3e-896c-58eaa1b53231", 
    #     integration_name: "my-integration", 
    #     kms_key_id: "arn:aws:kms:us-east-1:123456789012:key/a1b2c3d4-5678-90ab-cdef-EXAMPLEaaaaa", 
    #     source_arn: "arn:aws:rds:us-east-1:123456789012:cluster:my-cluster", 
    #     status: "creating", 
    #     tags: [
    #     ], 
    #     target_arn: "arn:aws:redshift-serverless:us-east-1:123456789012:namespace/62c70612-0302-4db7-8414-b5e3e049f0d8", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_integration({
    #     source_arn: "SourceArn", # required
    #     target_arn: "Arn", # required
    #     integration_name: "IntegrationName", # required
    #     kms_key_id: "String",
    #     additional_encryption_context: {
    #       "String" => "String",
    #     },
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #     data_filter: "DataFilter",
    #     description: "IntegrationDescription",
    #   })
    #
    # @example Response structure
    #
    #   resp.source_arn #=> String
    #   resp.target_arn #=> String
    #   resp.integration_name #=> String
    #   resp.integration_arn #=> String
    #   resp.kms_key_id #=> String
    #   resp.additional_encryption_context #=> Hash
    #   resp.additional_encryption_context["String"] #=> String
    #   resp.status #=> String, one of "creating", "active", "modifying", "failed", "deleting", "syncing", "needs_attention"
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #   resp.create_time #=> Time
    #   resp.errors #=> Array
    #   resp.errors[0].error_code #=> String
    #   resp.errors[0].error_message #=> String
    #   resp.data_filter #=> String
    #   resp.description #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateIntegration AWS API Documentation
    #
    # @overload create_integration(params = {})
    # @param [Hash] params ({})
    def create_integration(params = {}, options = {})
      req = build_request(:create_integration, params)
      req.send_request(options)
    end

    # Creates a new option group. You can create up to 20 option groups.
    #
    # This command doesn't apply to RDS Custom.
    #
    # @option params [required, String] :option_group_name
    #   Specifies the name of the option group to be created.
    #
    #   Constraints:
    #
    #   * Must be 1 to 255 letters, numbers, or hyphens
    #
    #   * First character must be a letter
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens
    #
    #   Example: `myoptiongroup`
    #
    # @option params [required, String] :engine_name
    #   The name of the engine to associate this option group with.
    #
    #   Valid Values:
    #
    #   * `db2-ae`
    #
    #   * `db2-se`
    #
    #   * `mariadb`
    #
    #   * `mysql`
    #
    #   * `oracle-ee`
    #
    #   * `oracle-ee-cdb`
    #
    #   * `oracle-se2`
    #
    #   * `oracle-se2-cdb`
    #
    #   * `postgres`
    #
    #   * `sqlserver-ee`
    #
    #   * `sqlserver-se`
    #
    #   * `sqlserver-ex`
    #
    #   * `sqlserver-web`
    #
    # @option params [required, String] :major_engine_version
    #   Specifies the major version of the engine that this option group
    #   should be associated with.
    #
    # @option params [required, String] :option_group_description
    #   The description of the option group.
    #
    # @option params [Array<Types::Tag>] :tags
    #   Tags to assign to the option group.
    #
    # @return [Types::CreateOptionGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateOptionGroupResult#option_group #option_group} => Types::OptionGroup
    #
    #
    # @example Example: To Create an Amazon RDS option group
    #
    #   # The following example creates a new Amazon RDS option group for Oracle MySQL version 8,0 named MyOptionGroup.
    #
    #   resp = client.create_option_group({
    #     engine_name: "mysql", 
    #     major_engine_version: "8.0", 
    #     option_group_description: "MySQL 8.0 option group", 
    #     option_group_name: "MyOptionGroup", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     option_group: {
    #       allows_vpc_and_non_vpc_instance_memberships: true, 
    #       engine_name: "mysql", 
    #       major_engine_version: "8.0", 
    #       option_group_arn: "arn:aws:rds:us-east-1:123456789012:og:myoptiongroup", 
    #       option_group_description: "MySQL 8.0 option group", 
    #       option_group_name: "myoptiongroup", 
    #       options: [
    #       ], 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_option_group({
    #     option_group_name: "String", # required
    #     engine_name: "String", # required
    #     major_engine_version: "String", # required
    #     option_group_description: "String", # required
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.option_group.option_group_name #=> String
    #   resp.option_group.option_group_description #=> String
    #   resp.option_group.engine_name #=> String
    #   resp.option_group.major_engine_version #=> String
    #   resp.option_group.options #=> Array
    #   resp.option_group.options[0].option_name #=> String
    #   resp.option_group.options[0].option_description #=> String
    #   resp.option_group.options[0].persistent #=> Boolean
    #   resp.option_group.options[0].permanent #=> Boolean
    #   resp.option_group.options[0].port #=> Integer
    #   resp.option_group.options[0].option_version #=> String
    #   resp.option_group.options[0].option_settings #=> Array
    #   resp.option_group.options[0].option_settings[0].name #=> String
    #   resp.option_group.options[0].option_settings[0].value #=> String
    #   resp.option_group.options[0].option_settings[0].default_value #=> String
    #   resp.option_group.options[0].option_settings[0].description #=> String
    #   resp.option_group.options[0].option_settings[0].apply_type #=> String
    #   resp.option_group.options[0].option_settings[0].data_type #=> String
    #   resp.option_group.options[0].option_settings[0].allowed_values #=> String
    #   resp.option_group.options[0].option_settings[0].is_modifiable #=> Boolean
    #   resp.option_group.options[0].option_settings[0].is_collection #=> Boolean
    #   resp.option_group.options[0].db_security_group_memberships #=> Array
    #   resp.option_group.options[0].db_security_group_memberships[0].db_security_group_name #=> String
    #   resp.option_group.options[0].db_security_group_memberships[0].status #=> String
    #   resp.option_group.options[0].vpc_security_group_memberships #=> Array
    #   resp.option_group.options[0].vpc_security_group_memberships[0].vpc_security_group_id #=> String
    #   resp.option_group.options[0].vpc_security_group_memberships[0].status #=> String
    #   resp.option_group.allows_vpc_and_non_vpc_instance_memberships #=> Boolean
    #   resp.option_group.vpc_id #=> String
    #   resp.option_group.option_group_arn #=> String
    #   resp.option_group.source_option_group #=> String
    #   resp.option_group.source_account_id #=> String
    #   resp.option_group.copy_timestamp #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroup AWS API Documentation
    #
    # @overload create_option_group(params = {})
    # @param [Hash] params ({})
    def create_option_group(params = {}, options = {})
      req = build_request(:create_option_group, params)
      req.send_request(options)
    end

    # Creates a tenant database in a DB instance that uses the multi-tenant
    # configuration. Only RDS for Oracle container database (CDB) instances
    # are supported.
    #
    # @option params [required, String] :db_instance_identifier
    #   The user-supplied DB instance identifier. RDS creates your tenant
    #   database in this DB instance. This parameter isn't case-sensitive.
    #
    # @option params [required, String] :tenant_db_name
    #   The user-supplied name of the tenant database that you want to create
    #   in your DB instance. This parameter has the same constraints as
    #   `DBName` in `CreateDBInstance`.
    #
    # @option params [required, String] :master_username
    #   The name for the master user account in your tenant database. RDS
    #   creates this user account in the tenant database and grants privileges
    #   to the master user. This parameter is case-sensitive.
    #
    #   Constraints:
    #
    #   * Must be 1 to 16 letters, numbers, or underscores.
    #
    #   * First character must be a letter.
    #
    #   * Can't be a reserved word for the chosen database engine.
    #
    # @option params [String] :master_user_password
    #   The password for the master user in your tenant database.
    #
    #   Constraints:
    #
    #   * Must be 8 to 30 characters.
    #
    #   * Can include any printable ASCII character except forward slash
    #     (`/`), double quote (`"`), at symbol (`@`), ampersand (`&`), or
    #     single quote (`'`).
    #
    #   * Can't be specified when `ManageMasterUserPassword` is enabled.
    #
    # @option params [String] :character_set_name
    #   The character set for your tenant database. If you don't specify a
    #   value, the character set name defaults to `AL32UTF8`.
    #
    # @option params [String] :nchar_character_set_name
    #   The `NCHAR` value for the tenant database.
    #
    # @option params [Boolean] :manage_master_user_password
    #   Specifies whether to manage the master user password with Amazon Web
    #   Services Secrets Manager.
    #
    #   For more information, see [Password management with Amazon Web
    #   Services Secrets Manager][1] in the *Amazon RDS User Guide.*
    #
    #   Constraints:
    #
    #   * Can't manage the master user password with Amazon Web Services
    #     Secrets Manager if `MasterUserPassword` is specified.
    #
    #   ^
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html
    #
    # @option params [String] :master_user_secret_kms_key_id
    #   The Amazon Web Services KMS key identifier to encrypt a secret that is
    #   automatically generated and managed in Amazon Web Services Secrets
    #   Manager.
    #
    #   This setting is valid only if the master user password is managed by
    #   RDS in Amazon Web Services Secrets Manager for the DB instance.
    #
    #   The Amazon Web Services KMS key identifier is the key ARN, key ID,
    #   alias ARN, or alias name for the KMS key. To use a KMS key in a
    #   different Amazon Web Services account, specify the key ARN or alias
    #   ARN.
    #
    #   If you don't specify `MasterUserSecretKmsKeyId`, then the
    #   `aws/secretsmanager` KMS key is used to encrypt the secret. If the
    #   secret is in a different Amazon Web Services account, then you can't
    #   use the `aws/secretsmanager` KMS key to encrypt the secret, and you
    #   must use a customer managed KMS key.
    #
    #   There is a default KMS key for your Amazon Web Services account. Your
    #   Amazon Web Services account has a different default KMS key for each
    #   Amazon Web Services Region.
    #
    # @option params [Array<Types::Tag>] :tags
    #   A list of tags.
    #
    #   For more information, see [Tagging Amazon RDS resources][1] in the
    #   *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS
    #   resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @return [Types::CreateTenantDatabaseResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTenantDatabaseResult#tenant_database #tenant_database} => Types::TenantDatabase
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_tenant_database({
    #     db_instance_identifier: "String", # required
    #     tenant_db_name: "String", # required
    #     master_username: "String", # required
    #     master_user_password: "SensitiveString",
    #     character_set_name: "String",
    #     nchar_character_set_name: "String",
    #     manage_master_user_password: false,
    #     master_user_secret_kms_key_id: "String",
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.tenant_database.tenant_database_create_time #=> Time
    #   resp.tenant_database.db_instance_identifier #=> String
    #   resp.tenant_database.tenant_db_name #=> String
    #   resp.tenant_database.status #=> String
    #   resp.tenant_database.master_username #=> String
    #   resp.tenant_database.dbi_resource_id #=> String
    #   resp.tenant_database.tenant_database_resource_id #=> String
    #   resp.tenant_database.tenant_database_arn #=> String
    #   resp.tenant_database.character_set_name #=> String
    #   resp.tenant_database.nchar_character_set_name #=> String
    #   resp.tenant_database.deletion_protection #=> Boolean
    #   resp.tenant_database.pending_modified_values.master_user_password #=> String
    #   resp.tenant_database.pending_modified_values.tenant_db_name #=> String
    #   resp.tenant_database.master_user_secret.secret_arn #=> String
    #   resp.tenant_database.master_user_secret.secret_status #=> String
    #   resp.tenant_database.master_user_secret.kms_key_id #=> String
    #   resp.tenant_database.tag_list #=> Array
    #   resp.tenant_database.tag_list[0].key #=> String
    #   resp.tenant_database.tag_list[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateTenantDatabase AWS API Documentation
    #
    # @overload create_tenant_database(params = {})
    # @param [Hash] params ({})
    def create_tenant_database(params = {}, options = {})
      req = build_request(:create_tenant_database, params)
      req.send_request(options)
    end

    # Deletes a blue/green deployment.
    #
    # For more information, see [Using Amazon RDS Blue/Green Deployments for
    # database updates][1] in the *Amazon RDS User Guide* and [Using Amazon
    # RDS Blue/Green Deployments for database updates][2] in the *Amazon
    # Aurora User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html
    #
    # @option params [required, String] :blue_green_deployment_identifier
    #   The unique identifier of the blue/green deployment to delete. This
    #   parameter isn't case-sensitive.
    #
    #   Constraints:
    #
    #   * Must match an existing blue/green deployment identifier.
    #
    #   ^
    #
    # @option params [Boolean] :delete_target
    #   Specifies whether to delete the resources in the green environment.
    #   You can't specify this option if the blue/green deployment
    #   [status][1] is `SWITCHOVER_COMPLETED`.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_BlueGreenDeployment.html
    #
    # @return [Types::DeleteBlueGreenDeploymentResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteBlueGreenDeploymentResponse#blue_green_deployment #blue_green_deployment} => Types::BlueGreenDeployment
    #
    #
    # @example Example: To delete resources in green environment for an RDS for MySQL DB instance
    #
    #   # The following example deletes the resources in a green environment for an RDS for MySQL DB instance.
    #
    #   resp = client.delete_blue_green_deployment({
    #     blue_green_deployment_identifier: "bgd-v53303651eexfake", 
    #     delete_target: true, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     blue_green_deployment: {
    #       blue_green_deployment_identifier: "bgd-v53303651eexfake", 
    #       blue_green_deployment_name: "bgd-cli-test-instance", 
    #       create_time: Time.parse("2022-02-25T21:18:51.183000+00:00"), 
    #       delete_time: Time.parse("2022-02-25T22:25:31.331000+00:00"), 
    #       source: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance", 
    #       status: "DELETING", 
    #       switchover_details: [
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance", 
    #           status: "AVAILABLE", 
    #           target_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-green-rkfbpe", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-1", 
    #           status: "AVAILABLE", 
    #           target_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-1-green-j382ha", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-2", 
    #           status: "AVAILABLE", 
    #           target_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-2-green-ejv4ao", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-3", 
    #           status: "AVAILABLE", 
    #           target_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-3-green-vlpz3t", 
    #         }, 
    #       ], 
    #       target: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-green-rkfbpe", 
    #       tasks: [
    #         {
    #           name: "CREATING_READ_REPLICA_OF_SOURCE", 
    #           status: "COMPLETED", 
    #         }, 
    #         {
    #           name: "DB_ENGINE_VERSION_UPGRADE", 
    #           status: "COMPLETED", 
    #         }, 
    #         {
    #           name: "CONFIGURE_BACKUPS", 
    #           status: "COMPLETED", 
    #         }, 
    #         {
    #           name: "CREATING_TOPOLOGY_OF_SOURCE", 
    #           status: "COMPLETED", 
    #         }, 
    #       ], 
    #     }, 
    #   }
    #
    # @example Example: To delete resources in green environment for an Aurora MySQL DB cluster
    #
    #   # The following example deletes the resources in a green environment for an Aurora MySQL DB cluster.
    #
    #   resp = client.delete_blue_green_deployment({
    #     blue_green_deployment_identifier: "bgd-wi89nwzglccsfake", 
    #     delete_target: true, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     blue_green_deployment: {
    #       blue_green_deployment_identifier: "bgd-wi89nwzglccsfake", 
    #       blue_green_deployment_name: "my-blue-green-deployment", 
    #       create_time: Time.parse("2022-02-25T21:12:00.288000+00:00"), 
    #       delete_time: Time.parse("2022-02-25T22:29:11.336000+00:00"), 
    #       source: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster", 
    #       status: "DELETING", 
    #       switchover_details: [
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster", 
    #           status: "AVAILABLE", 
    #           target_member: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-green-3rnukl", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1", 
    #           status: "AVAILABLE", 
    #           target_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1-green-gpmaxf", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2", 
    #           status: "AVAILABLE", 
    #           target_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2-green-j2oajq", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3", 
    #           status: "AVAILABLE", 
    #           target_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3-green-mkxies", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint", 
    #           status: "AVAILABLE", 
    #           target_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint-green-4sqjrq", 
    #         }, 
    #         {
    #           source_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint", 
    #           status: "AVAILABLE", 
    #           target_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint-green-gwwzlg", 
    #         }, 
    #       ], 
    #       target: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-green-3rnukl", 
    #       tasks: [
    #         {
    #           name: "CREATING_READ_REPLICA_OF_SOURCE", 
    #           status: "COMPLETED", 
    #         }, 
    #         {
    #           name: "DB_ENGINE_VERSION_UPGRADE", 
    #           status: "COMPLETED", 
    #         }, 
    #         {
    #           name: "CREATE_DB_INSTANCES_FOR_CLUSTER", 
    #           status: "COMPLETED", 
    #         }, 
    #         {
    #           name: "CREATE_CUSTOM_ENDPOINTS", 
    #           status: "COMPLETED", 
    #         }, 
    #       ], 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_blue_green_deployment({
    #     blue_green_deployment_identifier: "BlueGreenDeploymentIdentifier", # required
    #     delete_target: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.blue_green_deployment.blue_green_deployment_identifier #=> String
    #   resp.blue_green_deployment.blue_green_deployment_name #=> String
    #   resp.blue_green_deployment.source #=> String
    #   resp.blue_green_deployment.target #=> String
    #   resp.blue_green_deployment.switchover_details #=> Array
    #   resp.blue_green_deployment.switchover_details[0].source_member #=> String
    #   resp.blue_green_deployment.switchover_details[0].target_member #=> String
    #   resp.blue_green_deployment.switchover_details[0].status #=> String
    #   resp.blue_green_deployment.tasks #=> Array
    #   resp.blue_green_deployment.tasks[0].name #=> String
    #   resp.blue_green_deployment.tasks[0].status #=> String
    #   resp.blue_green_deployment.status #=> String
    #   resp.blue_green_deployment.status_details #=> String
    #   resp.blue_green_deployment.create_time #=> Time
    #   resp.blue_green_deployment.delete_time #=> Time
    #   resp.blue_green_deployment.tag_list #=> Array
    #   resp.blue_green_deployment.tag_list[0].key #=> String
    #   resp.blue_green_deployment.tag_list[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteBlueGreenDeployment AWS API Documentation
    #
    # @overload delete_blue_green_deployment(params = {})
    # @param [Hash] params ({})
    def delete_blue_green_deployment(params = {}, options = {})
      req = build_request(:delete_blue_green_deployment, params)
      req.send_request(options)
    end

    # Deletes a custom engine version. To run this command, make sure you
    # meet the following prerequisites:
    #
    # * The CEV must not be the default for RDS Custom. If it is, change the
    #   default before running this command.
    #
    # * The CEV must not be associated with an RDS Custom DB instance, RDS
    #   Custom instance snapshot, or automated backup of your RDS Custom
    #   instance.
    #
    # Typically, deletion takes a few minutes.
    #
    # <note markdown="1"> The MediaImport service that imports files from Amazon S3 to create
    # CEVs isn't integrated with Amazon Web Services CloudTrail. If you
    # turn on data logging for Amazon RDS in CloudTrail, calls to the
    # `DeleteCustomDbEngineVersion` event aren't logged. However, you might
    # see calls from the API gateway that accesses your Amazon S3 bucket.
    # These calls originate from the MediaImport service for the
    # `DeleteCustomDbEngineVersion` event.
    #
    #  </note>
    #
    # For more information, see [Deleting a CEV][1] in the *Amazon RDS User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.delete
    #
    # @option params [required, String] :engine
    #   The database engine. RDS Custom for Oracle supports the following
    #   values:
    #
    #   * `custom-oracle-ee`
    #
    #   * `custom-oracle-ee-cdb`
    #
    #   * `custom-oracle-se2`
    #
    #   * `custom-oracle-se2-cdb`
    #
    # @option params [required, String] :engine_version
    #   The custom engine version (CEV) for your DB instance. This option is
    #   required for RDS Custom, but optional for Amazon RDS. The combination
    #   of `Engine` and `EngineVersion` is unique per customer per Amazon Web
    #   Services Region.
    #
    # @return [Types::DBEngineVersion] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBEngineVersion#engine #engine} => String
    #   * {Types::DBEngineVersion#engine_version #engine_version} => String
    #   * {Types::DBEngineVersion#db_parameter_group_family #db_parameter_group_family} => String
    #   * {Types::DBEngineVersion#db_engine_description #db_engine_description} => String
    #   * {Types::DBEngineVersion#db_engine_version_description #db_engine_version_description} => String
    #   * {Types::DBEngineVersion#default_character_set #default_character_set} => Types::CharacterSet
    #   * {Types::DBEngineVersion#image #image} => Types::CustomDBEngineVersionAMI
    #   * {Types::DBEngineVersion#db_engine_media_type #db_engine_media_type} => String
    #   * {Types::DBEngineVersion#supported_character_sets #supported_character_sets} => Array&lt;Types::CharacterSet&gt;
    #   * {Types::DBEngineVersion#supported_nchar_character_sets #supported_nchar_character_sets} => Array&lt;Types::CharacterSet&gt;
    #   * {Types::DBEngineVersion#valid_upgrade_target #valid_upgrade_target} => Array&lt;Types::UpgradeTarget&gt;
    #   * {Types::DBEngineVersion#supported_timezones #supported_timezones} => Array&lt;Types::Timezone&gt;
    #   * {Types::DBEngineVersion#exportable_log_types #exportable_log_types} => Array&lt;String&gt;
    #   * {Types::DBEngineVersion#supports_log_exports_to_cloudwatch_logs #supports_log_exports_to_cloudwatch_logs} => Boolean
    #   * {Types::DBEngineVersion#supports_read_replica #supports_read_replica} => Boolean
    #   * {Types::DBEngineVersion#supported_engine_modes #supported_engine_modes} => Array&lt;String&gt;
    #   * {Types::DBEngineVersion#supported_feature_names #supported_feature_names} => Array&lt;String&gt;
    #   * {Types::DBEngineVersion#status #status} => String
    #   * {Types::DBEngineVersion#supports_parallel_query #supports_parallel_query} => Boolean
    #   * {Types::DBEngineVersion#supports_global_databases #supports_global_databases} => Boolean
    #   * {Types::DBEngineVersion#major_engine_version #major_engine_version} => String
    #   * {Types::DBEngineVersion#database_installation_files_s3_bucket_name #database_installation_files_s3_bucket_name} => String
    #   * {Types::DBEngineVersion#database_installation_files_s3_prefix #database_installation_files_s3_prefix} => String
    #   * {Types::DBEngineVersion#db_engine_version_arn #db_engine_version_arn} => String
    #   * {Types::DBEngineVersion#kms_key_id #kms_key_id} => String
    #   * {Types::DBEngineVersion#create_time #create_time} => Time
    #   * {Types::DBEngineVersion#tag_list #tag_list} => Array&lt;Types::Tag&gt;
    #   * {Types::DBEngineVersion#supports_babelfish #supports_babelfish} => Boolean
    #   * {Types::DBEngineVersion#custom_db_engine_version_manifest #custom_db_engine_version_manifest} => String
    #   * {Types::DBEngineVersion#supports_limitless_database #supports_limitless_database} => Boolean
    #   * {Types::DBEngineVersion#supports_certificate_rotation_without_restart #supports_certificate_rotation_without_restart} => Boolean
    #   * {Types::DBEngineVersion#supported_ca_certificate_identifiers #supported_ca_certificate_identifiers} => Array&lt;String&gt;
    #   * {Types::DBEngineVersion#supports_local_write_forwarding #supports_local_write_forwarding} => Boolean
    #   * {Types::DBEngineVersion#supports_integrations #supports_integrations} => Boolean
    #   * {Types::DBEngineVersion#serverless_v2_features_support #serverless_v2_features_support} => Types::ServerlessV2FeaturesSupport
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_custom_db_engine_version({
    #     engine: "CustomEngineName", # required
    #     engine_version: "CustomEngineVersion", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.engine #=> String
    #   resp.engine_version #=> String
    #   resp.db_parameter_group_family #=> String
    #   resp.db_engine_description #=> String
    #   resp.db_engine_version_description #=> String
    #   resp.default_character_set.character_set_name #=> String
    #   resp.default_character_set.character_set_description #=> String
    #   resp.image.image_id #=> String
    #   resp.image.status #=> String
    #   resp.db_engine_media_type #=> String
    #   resp.supported_character_sets #=> Array
    #   resp.supported_character_sets[0].character_set_name #=> String
    #   resp.supported_character_sets[0].character_set_description #=> String
    #   resp.supported_nchar_character_sets #=> Array
    #   resp.supported_nchar_character_sets[0].character_set_name #=> String
    #   resp.supported_nchar_character_sets[0].character_set_description #=> String
    #   resp.valid_upgrade_target #=> Array
    #   resp.valid_upgrade_target[0].engine #=> String
    #   resp.valid_upgrade_target[0].engine_version #=> String
    #   resp.valid_upgrade_target[0].description #=> String
    #   resp.valid_upgrade_target[0].auto_upgrade #=> Boolean
    #   resp.valid_upgrade_target[0].is_major_version_upgrade #=> Boolean
    #   resp.valid_upgrade_target[0].supported_engine_modes #=> Array
    #   resp.valid_upgrade_target[0].supported_engine_modes[0] #=> String
    #   resp.valid_upgrade_target[0].supports_parallel_query #=> Boolean
    #   resp.valid_upgrade_target[0].supports_global_databases #=> Boolean
    #   resp.valid_upgrade_target[0].supports_babelfish #=> Boolean
    #   resp.valid_upgrade_target[0].supports_limitless_database #=> Boolean
    #   resp.valid_upgrade_target[0].supports_local_write_forwarding #=> Boolean
    #   resp.valid_upgrade_target[0].supports_integrations #=> Boolean
    #   resp.supported_timezones #=> Array
    #   resp.supported_timezones[0].timezone_name #=> String
    #   resp.exportable_log_types #=> Array
    #   resp.exportable_log_types[0] #=> String
    #   resp.supports_log_exports_to_cloudwatch_logs #=> Boolean
    #   resp.supports_read_replica #=> Boolean
    #   resp.supported_engine_modes #=> Array
    #   resp.supported_engine_modes[0] #=> String
    #   resp.supported_feature_names #=> Array
    #   resp.supported_feature_names[0] #=> String
    #   resp.status #=> String
    #   resp.supports_parallel_query #=> Boolean
    #   resp.supports_global_databases #=> Boolean
    #   resp.major_engine_version #=> String
    #   resp.database_installation_files_s3_bucket_name #=> String
    #   resp.database_installation_files_s3_prefix #=> String
    #   resp.db_engine_version_arn #=> String
    #   resp.kms_key_id #=> String
    #   resp.create_time #=> Time
    #   resp.tag_list #=> Array
    #   resp.tag_list[0].key #=> String
    #   resp.tag_list[0].value #=> String
    #   resp.supports_babelfish #=> Boolean
    #   resp.custom_db_engine_version_manifest #=> String
    #   resp.supports_limitless_database #=> Boolean
    #   resp.supports_certificate_rotation_without_restart #=> Boolean
    #   resp.supported_ca_certificate_identifiers #=> Array
    #   resp.supported_ca_certificate_identifiers[0] #=> String
    #   resp.supports_local_write_forwarding #=> Boolean
    #   resp.supports_integrations #=> Boolean
    #   resp.serverless_v2_features_support.min_capacity #=> Float
    #   resp.serverless_v2_features_support.max_capacity #=> Float
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteCustomDBEngineVersion AWS API Documentation
    #
    # @overload delete_custom_db_engine_version(params = {})
    # @param [Hash] params ({})
    def delete_custom_db_engine_version(params = {}, options = {})
      req = build_request(:delete_custom_db_engine_version, params)
      req.send_request(options)
    end

    # The DeleteDBCluster action deletes a previously provisioned DB
    # cluster. When you delete a DB cluster, all automated backups for that
    # DB cluster are deleted and can't be recovered. Manual DB cluster
    # snapshots of the specified DB cluster are not deleted.
    #
    # If you're deleting a Multi-AZ DB cluster with read replicas, all
    # cluster members are terminated and read replicas are promoted to
    # standalone instances.
    #
    # For more information on Amazon Aurora, see [ What is Amazon
    # Aurora?][1] in the *Amazon Aurora User Guide*.
    #
    # For more information on Multi-AZ DB clusters, see [ Multi-AZ DB
    # cluster deployments][2] in the *Amazon RDS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [required, String] :db_cluster_identifier
    #   The DB cluster identifier for the DB cluster to be deleted. This
    #   parameter isn't case-sensitive.
    #
    #   Constraints:
    #
    #   * Must match an existing DBClusterIdentifier.
    #
    #   ^
    #
    # @option params [Boolean] :skip_final_snapshot
    #   Specifies whether to skip the creation of a final DB cluster snapshot
    #   before RDS deletes the DB cluster. If you set this value to `true`,
    #   RDS doesn't create a final DB cluster snapshot. If you set this value
    #   to `false` or don't specify it, RDS creates a DB cluster snapshot
    #   before it deletes the DB cluster. By default, this parameter is
    #   disabled, so RDS creates a final DB cluster snapshot.
    #
    #   <note markdown="1"> If `SkipFinalSnapshot` is disabled, you must specify a value for the
    #   `FinalDBSnapshotIdentifier` parameter.
    #
    #    </note>
    #
    # @option params [String] :final_db_snapshot_identifier
    #   The DB cluster snapshot identifier of the new DB cluster snapshot
    #   created when `SkipFinalSnapshot` is disabled.
    #
    #   <note markdown="1"> If you specify this parameter and also skip the creation of a final DB
    #   cluster snapshot with the `SkipFinalShapshot` parameter, the request
    #   results in an error.
    #
    #    </note>
    #
    #   Constraints:
    #
    #   * Must be 1 to 255 letters, numbers, or hyphens.
    #
    #   * First character must be a letter
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens
    #
    # @option params [Boolean] :delete_automated_backups
    #   Specifies whether to remove automated backups immediately after the DB
    #   cluster is deleted. This parameter isn't case-sensitive. The default
    #   is to remove automated backups immediately after the DB cluster is
    #   deleted, unless the Amazon Web Services Backup policy specifies a
    #   point-in-time restore rule.
    #
    # @return [Types::DeleteDBClusterResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteDBClusterResult#db_cluster #db_cluster} => Types::DBCluster
    #
    #
    # @example Example: To delete a DB cluster
    #
    #   # The following example deletes the DB cluster named mycluster and takes a final snapshot named mycluster-final-snapshot.
    #   # The status of the DB cluster is available while the snapshot is being taken. 
    #
    #   resp = client.delete_db_cluster({
    #     db_cluster_identifier: "mycluster", 
    #     final_db_snapshot_identifier: "mycluster-final-snapshot", 
    #     skip_final_snapshot: false, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster: {
    #       allocated_storage: 20, 
    #       availability_zones: [
    #         "eu-central-1b", 
    #         "eu-central-1c", 
    #         "eu-central-1a", 
    #       ], 
    #       backup_retention_period: 7, 
    #       db_cluster_identifier: "mycluster", 
    #       db_cluster_parameter_group: "default.aurora-postgresql10", 
    #       db_subnet_group: "default-vpc-aa11bb22", 
    #       status: "available", 
    #     }, # Some output ommitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_cluster({
    #     db_cluster_identifier: "String", # required
    #     skip_final_snapshot: false,
    #     final_db_snapshot_identifier: "String",
    #     delete_automated_backups: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster.allocated_storage #=> Integer
    #   resp.db_cluster.availability_zones #=> Array
    #   resp.db_cluster.availability_zones[0] #=> String
    #   resp.db_cluster.backup_retention_period #=> Integer
    #   resp.db_cluster.character_set_name #=> String
    #   resp.db_cluster.database_name #=> String
    #   resp.db_cluster.db_cluster_identifier #=> String
    #   resp.db_cluster.db_cluster_parameter_group #=> String
    #   resp.db_cluster.db_subnet_group #=> String
    #   resp.db_cluster.status #=> String
    #   resp.db_cluster.automatic_restart_time #=> Time
    #   resp.db_cluster.percent_progress #=> String
    #   resp.db_cluster.earliest_restorable_time #=> Time
    #   resp.db_cluster.endpoint #=> String
    #   resp.db_cluster.reader_endpoint #=> String
    #   resp.db_cluster.custom_endpoints #=> Array
    #   resp.db_cluster.custom_endpoints[0] #=> String
    #   resp.db_cluster.multi_az #=> Boolean
    #   resp.db_cluster.engine #=> String
    #   resp.db_cluster.engine_version #=> String
    #   resp.db_cluster.latest_restorable_time #=> Time
    #   resp.db_cluster.port #=> Integer
    #   resp.db_cluster.master_username #=> String
    #   resp.db_cluster.db_cluster_option_group_memberships #=> Array
    #   resp.db_cluster.db_cluster_option_group_memberships[0].db_cluster_option_group_name #=> String
    #   resp.db_cluster.db_cluster_option_group_memberships[0].status #=> String
    #   resp.db_cluster.preferred_backup_window #=> String
    #   resp.db_cluster.preferred_maintenance_window #=> String
    #   resp.db_cluster.replication_source_identifier #=> String
    #   resp.db_cluster.read_replica_identifiers #=> Array
    #   resp.db_cluster.read_replica_identifiers[0] #=> String
    #   resp.db_cluster.status_infos #=> Array
    #   resp.db_cluster.status_infos[0].status_type #=> String
    #   resp.db_cluster.status_infos[0].normal #=> Boolean
    #   resp.db_cluster.status_infos[0].status #=> String
    #   resp.db_cluster.status_infos[0].message #=> String
    #   resp.db_cluster.db_cluster_members #=> Array
    #   resp.db_cluster.db_cluster_members[0].db_instance_identifier #=> String
    #   resp.db_cluster.db_cluster_members[0].is_cluster_writer #=> Boolean
    #   resp.db_cluster.db_cluster_members[0].db_cluster_parameter_group_status #=> String
    #   resp.db_cluster.db_cluster_members[0].promotion_tier #=> Integer
    #   resp.db_cluster.vpc_security_groups #=> Array
    #   resp.db_cluster.vpc_security_groups[0].vpc_security_group_id #=> String
    #   resp.db_cluster.vpc_security_groups[0].status #=> String
    #   resp.db_cluster.hosted_zone_id #=> String
    #   resp.db_cluster.storage_encrypted #=> Boolean
    #   resp.db_cluster.kms_key_id #=> String
    #   resp.db_cluster.db_cluster_resource_id #=> String
    #   resp.db_cluster.db_cluster_arn #=> String
    #   resp.db_cluster.associated_roles #=> Array
    #   resp.db_cluster.associated_roles[0].role_arn #=> String
    #   resp.db_cluster.associated_roles[0].status #=> String
    #   resp.db_cluster.associated_roles[0].feature_name #=> String
    #   resp.db_cluster.iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster.clone_group_id #=> String
    #   resp.db_cluster.cluster_create_time #=> Time
    #   resp.db_cluster.earliest_backtrack_time #=> Time
    #   resp.db_cluster.backtrack_window #=> Integer
    #   resp.db_cluster.backtrack_consumed_change_records #=> Integer
    #   resp.db_cluster.enabled_cloudwatch_logs_exports #=> Array
    #   resp.db_cluster.enabled_cloudwatch_logs_exports[0] #=> String
    #   resp.db_cluster.capacity #=> Integer
    #   resp.db_cluster.engine_mode #=> String
    #   resp.db_cluster.scaling_configuration_info.min_capacity #=> Integer
    #   resp.db_cluster.scaling_configuration_info.max_capacity #=> Integer
    #   resp.db_cluster.scaling_configuration_info.auto_pause #=> Boolean
    #   resp.db_cluster.scaling_configuration_info.seconds_until_auto_pause #=> Integer
    #   resp.db_cluster.scaling_configuration_info.timeout_action #=> String
    #   resp.db_cluster.scaling_configuration_info.seconds_before_timeout #=> Integer
    #   resp.db_cluster.rds_custom_cluster_configuration.interconnect_subnet_id #=> String
    #   resp.db_cluster.rds_custom_cluster_configuration.transit_gateway_multicast_domain_id #=> String
    #   resp.db_cluster.rds_custom_cluster_configuration.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_cluster.deletion_protection #=> Boolean
    #   resp.db_cluster.http_endpoint_enabled #=> Boolean
    #   resp.db_cluster.activity_stream_mode #=> String, one of "sync", "async"
    #   resp.db_cluster.activity_stream_status #=> String, one of "stopped", "starting", "started", "stopping"
    #   resp.db_cluster.activity_stream_kms_key_id #=> String
    #   resp.db_cluster.activity_stream_kinesis_stream_name #=> String
    #   resp.db_cluster.copy_tags_to_snapshot #=> Boolean
    #   resp.db_cluster.cross_account_clone #=> Boolean
    #   resp.db_cluster.domain_memberships #=> Array
    #   resp.db_cluster.domain_memberships[0].domain #=> String
    #   resp.db_cluster.domain_memberships[0].status #=> String
    #   resp.db_cluster.domain_memberships[0].fqdn #=> String
    #   resp.db_cluster.domain_memberships[0].iam_role_name #=> String
    #   resp.db_cluster.domain_memberships[0].ou #=> String
    #   resp.db_cluster.domain_memberships[0].auth_secret_arn #=> String
    #   resp.db_cluster.domain_memberships[0].dns_ips #=> Array
    #   resp.db_cluster.domain_memberships[0].dns_ips[0] #=> String
    #   resp.db_cluster.tag_list #=> Array
    #   resp.db_cluster.tag_list[0].key #=> String
    #   resp.db_cluster.tag_list[0].value #=> String
    #   resp.db_cluster.global_cluster_identifier #=> String
    #   resp.db_cluster.global_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "unknown"
    #   resp.db_cluster.global_write_forwarding_requested #=> Boolean
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable #=> Array
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable[0] #=> String
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable #=> Array
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable[0] #=> String
    #   resp.db_cluster.pending_modified_values.db_cluster_identifier #=> String
    #   resp.db_cluster.pending_modified_values.master_user_password #=> String
    #   resp.db_cluster.pending_modified_values.iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster.pending_modified_values.engine_version #=> String
    #   resp.db_cluster.pending_modified_values.backup_retention_period #=> Integer
    #   resp.db_cluster.pending_modified_values.allocated_storage #=> Integer
    #   resp.db_cluster.pending_modified_values.rds_custom_cluster_configuration.interconnect_subnet_id #=> String
    #   resp.db_cluster.pending_modified_values.rds_custom_cluster_configuration.transit_gateway_multicast_domain_id #=> String
    #   resp.db_cluster.pending_modified_values.rds_custom_cluster_configuration.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_cluster.pending_modified_values.iops #=> Integer
    #   resp.db_cluster.pending_modified_values.storage_type #=> String
    #   resp.db_cluster.pending_modified_values.certificate_details.ca_identifier #=> String
    #   resp.db_cluster.pending_modified_values.certificate_details.valid_till #=> Time
    #   resp.db_cluster.db_cluster_instance_class #=> String
    #   resp.db_cluster.storage_type #=> String
    #   resp.db_cluster.iops #=> Integer
    #   resp.db_cluster.publicly_accessible #=> Boolean
    #   resp.db_cluster.auto_minor_version_upgrade #=> Boolean
    #   resp.db_cluster.monitoring_interval #=> Integer
    #   resp.db_cluster.monitoring_role_arn #=> String
    #   resp.db_cluster.database_insights_mode #=> String, one of "standard", "advanced"
    #   resp.db_cluster.performance_insights_enabled #=> Boolean
    #   resp.db_cluster.performance_insights_kms_key_id #=> String
    #   resp.db_cluster.performance_insights_retention_period #=> Integer
    #   resp.db_cluster.serverless_v2_scaling_configuration.min_capacity #=> Float
    #   resp.db_cluster.serverless_v2_scaling_configuration.max_capacity #=> Float
    #   resp.db_cluster.serverless_v2_scaling_configuration.seconds_until_auto_pause #=> Integer
    #   resp.db_cluster.serverless_v2_platform_version #=> String
    #   resp.db_cluster.network_type #=> String
    #   resp.db_cluster.db_system_id #=> String
    #   resp.db_cluster.master_user_secret.secret_arn #=> String
    #   resp.db_cluster.master_user_secret.secret_status #=> String
    #   resp.db_cluster.master_user_secret.kms_key_id #=> String
    #   resp.db_cluster.io_optimized_next_allowed_modification_time #=> Time
    #   resp.db_cluster.local_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "requested"
    #   resp.db_cluster.aws_backup_recovery_point_arn #=> String
    #   resp.db_cluster.limitless_database.status #=> String, one of "active", "not-in-use", "enabled", "disabled", "enabling", "disabling", "modifying-max-capacity", "error"
    #   resp.db_cluster.limitless_database.min_required_acu #=> Float
    #   resp.db_cluster.storage_throughput #=> Integer
    #   resp.db_cluster.cluster_scalability_type #=> String, one of "standard", "limitless"
    #   resp.db_cluster.certificate_details.ca_identifier #=> String
    #   resp.db_cluster.certificate_details.valid_till #=> Time
    #   resp.db_cluster.engine_lifecycle_support #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBCluster AWS API Documentation
    #
    # @overload delete_db_cluster(params = {})
    # @param [Hash] params ({})
    def delete_db_cluster(params = {}, options = {})
      req = build_request(:delete_db_cluster, params)
      req.send_request(options)
    end

    # Deletes automated backups using the `DbClusterResourceId` value of the
    # source DB cluster or the Amazon Resource Name (ARN) of the automated
    # backups.
    #
    # @option params [required, String] :db_cluster_resource_id
    #   The identifier for the source DB cluster, which can't be changed and
    #   which is unique to an Amazon Web Services Region.
    #
    # @return [Types::DeleteDBClusterAutomatedBackupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteDBClusterAutomatedBackupResult#db_cluster_automated_backup #db_cluster_automated_backup} => Types::DBClusterAutomatedBackup
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_cluster_automated_backup({
    #     db_cluster_resource_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_automated_backup.engine #=> String
    #   resp.db_cluster_automated_backup.vpc_id #=> String
    #   resp.db_cluster_automated_backup.db_cluster_automated_backups_arn #=> String
    #   resp.db_cluster_automated_backup.db_cluster_identifier #=> String
    #   resp.db_cluster_automated_backup.restore_window.earliest_time #=> Time
    #   resp.db_cluster_automated_backup.restore_window.latest_time #=> Time
    #   resp.db_cluster_automated_backup.master_username #=> String
    #   resp.db_cluster_automated_backup.db_cluster_resource_id #=> String
    #   resp.db_cluster_automated_backup.region #=> String
    #   resp.db_cluster_automated_backup.license_model #=> String
    #   resp.db_cluster_automated_backup.status #=> String
    #   resp.db_cluster_automated_backup.iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster_automated_backup.cluster_create_time #=> Time
    #   resp.db_cluster_automated_backup.storage_encrypted #=> Boolean
    #   resp.db_cluster_automated_backup.allocated_storage #=> Integer
    #   resp.db_cluster_automated_backup.engine_version #=> String
    #   resp.db_cluster_automated_backup.db_cluster_arn #=> String
    #   resp.db_cluster_automated_backup.backup_retention_period #=> Integer
    #   resp.db_cluster_automated_backup.engine_mode #=> String
    #   resp.db_cluster_automated_backup.availability_zones #=> Array
    #   resp.db_cluster_automated_backup.availability_zones[0] #=> String
    #   resp.db_cluster_automated_backup.port #=> Integer
    #   resp.db_cluster_automated_backup.kms_key_id #=> String
    #   resp.db_cluster_automated_backup.storage_type #=> String
    #   resp.db_cluster_automated_backup.iops #=> Integer
    #   resp.db_cluster_automated_backup.aws_backup_recovery_point_arn #=> String
    #   resp.db_cluster_automated_backup.storage_throughput #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterAutomatedBackup AWS API Documentation
    #
    # @overload delete_db_cluster_automated_backup(params = {})
    # @param [Hash] params ({})
    def delete_db_cluster_automated_backup(params = {}, options = {})
      req = build_request(:delete_db_cluster_automated_backup, params)
      req.send_request(options)
    end

    # Deletes a custom endpoint and removes it from an Amazon Aurora DB
    # cluster.
    #
    # <note markdown="1"> This action only applies to Aurora DB clusters.
    #
    #  </note>
    #
    # @option params [required, String] :db_cluster_endpoint_identifier
    #   The identifier associated with the custom endpoint. This parameter is
    #   stored as a lowercase string.
    #
    # @return [Types::DBClusterEndpoint] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBClusterEndpoint#db_cluster_endpoint_identifier #db_cluster_endpoint_identifier} => String
    #   * {Types::DBClusterEndpoint#db_cluster_identifier #db_cluster_identifier} => String
    #   * {Types::DBClusterEndpoint#db_cluster_endpoint_resource_identifier #db_cluster_endpoint_resource_identifier} => String
    #   * {Types::DBClusterEndpoint#endpoint #endpoint} => String
    #   * {Types::DBClusterEndpoint#status #status} => String
    #   * {Types::DBClusterEndpoint#endpoint_type #endpoint_type} => String
    #   * {Types::DBClusterEndpoint#custom_endpoint_type #custom_endpoint_type} => String
    #   * {Types::DBClusterEndpoint#static_members #static_members} => Array&lt;String&gt;
    #   * {Types::DBClusterEndpoint#excluded_members #excluded_members} => Array&lt;String&gt;
    #   * {Types::DBClusterEndpoint#db_cluster_endpoint_arn #db_cluster_endpoint_arn} => String
    #
    #
    # @example Example: To delete a custom DB cluster endpoint
    #
    #   # The following example deletes the specified custom DB cluster endpoint.
    #
    #   resp = client.delete_db_cluster_endpoint({
    #     db_cluster_endpoint_identifier: "mycustomendpoint", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     custom_endpoint_type: "READER", 
    #     db_cluster_endpoint_arn: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:mycustomendpoint", 
    #     db_cluster_endpoint_identifier: "mycustomendpoint", 
    #     db_cluster_endpoint_resource_identifier: "cluster-endpoint-ANPAJ4AE5446DAEXAMPLE", 
    #     db_cluster_identifier: "mydbcluster", 
    #     endpoint: "mycustomendpoint.cluster-custom-cnpexample.us-east-1.rds.amazonaws.com", 
    #     endpoint_type: "CUSTOM", 
    #     excluded_members: [
    #     ], 
    #     static_members: [
    #       "dbinstance1", 
    #       "dbinstance2", 
    #       "dbinstance3", 
    #     ], 
    #     status: "deleting", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_cluster_endpoint({
    #     db_cluster_endpoint_identifier: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_endpoint_identifier #=> String
    #   resp.db_cluster_identifier #=> String
    #   resp.db_cluster_endpoint_resource_identifier #=> String
    #   resp.endpoint #=> String
    #   resp.status #=> String
    #   resp.endpoint_type #=> String
    #   resp.custom_endpoint_type #=> String
    #   resp.static_members #=> Array
    #   resp.static_members[0] #=> String
    #   resp.excluded_members #=> Array
    #   resp.excluded_members[0] #=> String
    #   resp.db_cluster_endpoint_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterEndpoint AWS API Documentation
    #
    # @overload delete_db_cluster_endpoint(params = {})
    # @param [Hash] params ({})
    def delete_db_cluster_endpoint(params = {}, options = {})
      req = build_request(:delete_db_cluster_endpoint, params)
      req.send_request(options)
    end

    # Deletes a specified DB cluster parameter group. The DB cluster
    # parameter group to be deleted can't be associated with any DB
    # clusters.
    #
    # For more information on Amazon Aurora, see [ What is Amazon
    # Aurora?][1] in the *Amazon Aurora User Guide*.
    #
    # For more information on Multi-AZ DB clusters, see [ Multi-AZ DB
    # cluster deployments][2] in the *Amazon RDS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [required, String] :db_cluster_parameter_group_name
    #   The name of the DB cluster parameter group.
    #
    #   Constraints:
    #
    #   * Must be the name of an existing DB cluster parameter group.
    #
    #   * You can't delete a default DB cluster parameter group.
    #
    #   * Can't be associated with any DB clusters.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a DB cluster parameter group
    #
    #   # The following example deletes the specified DB cluster parameter group.
    #
    #   resp = client.delete_db_cluster_parameter_group({
    #     db_cluster_parameter_group_name: "mydbclusterparametergroup", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_cluster_parameter_group({
    #     db_cluster_parameter_group_name: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroup AWS API Documentation
    #
    # @overload delete_db_cluster_parameter_group(params = {})
    # @param [Hash] params ({})
    def delete_db_cluster_parameter_group(params = {}, options = {})
      req = build_request(:delete_db_cluster_parameter_group, params)
      req.send_request(options)
    end

    # Deletes a DB cluster snapshot. If the snapshot is being copied, the
    # copy operation is terminated.
    #
    # <note markdown="1"> The DB cluster snapshot must be in the `available` state to be
    # deleted.
    #
    #  </note>
    #
    # For more information on Amazon Aurora, see [ What is Amazon
    # Aurora?][1] in the *Amazon Aurora User Guide*.
    #
    # For more information on Multi-AZ DB clusters, see [ Multi-AZ DB
    # cluster deployments][2] in the *Amazon RDS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [required, String] :db_cluster_snapshot_identifier
    #   The identifier of the DB cluster snapshot to delete.
    #
    #   Constraints: Must be the name of an existing DB cluster snapshot in
    #   the `available` state.
    #
    # @return [Types::DeleteDBClusterSnapshotResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteDBClusterSnapshotResult#db_cluster_snapshot #db_cluster_snapshot} => Types::DBClusterSnapshot
    #
    #
    # @example Example: To delete a DB cluster snapshot
    #
    #   resp = client.delete_db_cluster_snapshot({
    #     db_cluster_snapshot_identifier: "mydbclustersnapshot", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster_snapshot: {
    #       allocated_storage: 0, 
    #       availability_zones: [
    #         "us-east-1a", 
    #         "us-east-1b", 
    #         "us-east-1e", 
    #       ], 
    #       cluster_create_time: Time.parse("2019-04-15T14:18:42.785Z"), 
    #       db_cluster_identifier: "mydbcluster", 
    #       db_cluster_snapshot_arn: "arn:aws:rds:us-east-1:123456789012:cluster-snapshot:mydbclustersnapshot", 
    #       db_cluster_snapshot_identifier: "mydbclustersnapshot", 
    #       engine: "aurora-mysql", 
    #       engine_version: "5.7.mysql_aurora.2.04.2", 
    #       iam_database_authentication_enabled: false, 
    #       kms_key_id: "arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE", 
    #       license_model: "aurora-mysql", 
    #       master_username: "myadmin", 
    #       percent_progress: 100, 
    #       port: 0, 
    #       snapshot_create_time: Time.parse("2019-06-18T21:21:00.469Z"), 
    #       snapshot_type: "manual", 
    #       status: "available", 
    #       storage_encrypted: true, 
    #       vpc_id: "vpc-6594f31c", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_cluster_snapshot({
    #     db_cluster_snapshot_identifier: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_snapshot.availability_zones #=> Array
    #   resp.db_cluster_snapshot.availability_zones[0] #=> String
    #   resp.db_cluster_snapshot.db_cluster_snapshot_identifier #=> String
    #   resp.db_cluster_snapshot.db_cluster_identifier #=> String
    #   resp.db_cluster_snapshot.snapshot_create_time #=> Time
    #   resp.db_cluster_snapshot.engine #=> String
    #   resp.db_cluster_snapshot.engine_mode #=> String
    #   resp.db_cluster_snapshot.allocated_storage #=> Integer
    #   resp.db_cluster_snapshot.status #=> String
    #   resp.db_cluster_snapshot.port #=> Integer
    #   resp.db_cluster_snapshot.vpc_id #=> String
    #   resp.db_cluster_snapshot.cluster_create_time #=> Time
    #   resp.db_cluster_snapshot.master_username #=> String
    #   resp.db_cluster_snapshot.engine_version #=> String
    #   resp.db_cluster_snapshot.license_model #=> String
    #   resp.db_cluster_snapshot.snapshot_type #=> String
    #   resp.db_cluster_snapshot.percent_progress #=> Integer
    #   resp.db_cluster_snapshot.storage_encrypted #=> Boolean
    #   resp.db_cluster_snapshot.kms_key_id #=> String
    #   resp.db_cluster_snapshot.db_cluster_snapshot_arn #=> String
    #   resp.db_cluster_snapshot.source_db_cluster_snapshot_arn #=> String
    #   resp.db_cluster_snapshot.iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster_snapshot.tag_list #=> Array
    #   resp.db_cluster_snapshot.tag_list[0].key #=> String
    #   resp.db_cluster_snapshot.tag_list[0].value #=> String
    #   resp.db_cluster_snapshot.db_system_id #=> String
    #   resp.db_cluster_snapshot.storage_type #=> String
    #   resp.db_cluster_snapshot.db_cluster_resource_id #=> String
    #   resp.db_cluster_snapshot.storage_throughput #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshot AWS API Documentation
    #
    # @overload delete_db_cluster_snapshot(params = {})
    # @param [Hash] params ({})
    def delete_db_cluster_snapshot(params = {}, options = {})
      req = build_request(:delete_db_cluster_snapshot, params)
      req.send_request(options)
    end

    # Deletes a previously provisioned DB instance. When you delete a DB
    # instance, all automated backups for that instance are deleted and
    # can't be recovered. However, manual DB snapshots of the DB instance
    # aren't deleted.
    #
    # If you request a final DB snapshot, the status of the Amazon RDS DB
    # instance is `deleting` until the DB snapshot is created. This
    # operation can't be canceled or reverted after it begins. To monitor
    # the status of this operation, use `DescribeDBInstance`.
    #
    # When a DB instance is in a failure state and has a status of `failed`,
    # `incompatible-restore`, or `incompatible-network`, you can only delete
    # it when you skip creation of the final snapshot with the
    # `SkipFinalSnapshot` parameter.
    #
    # If the specified DB instance is part of an Amazon Aurora DB cluster,
    # you can't delete the DB instance if both of the following conditions
    # are true:
    #
    # * The DB cluster is a read replica of another Amazon Aurora DB
    #   cluster.
    #
    # * The DB instance is the only instance in the DB cluster.
    #
    # To delete a DB instance in this case, first use the
    # `PromoteReadReplicaDBCluster` operation to promote the DB cluster so
    # that it's no longer a read replica. After the promotion completes,
    # use the `DeleteDBInstance` operation to delete the final instance in
    # the DB cluster.
    #
    # For RDS Custom DB instances, deleting the DB instance permanently
    # deletes the EC2 instance and the associated EBS volumes. Make sure
    # that you don't terminate or delete these resources before you delete
    # the DB instance. Otherwise, deleting the DB instance and creation of
    # the final snapshot might fail.
    #
    # @option params [required, String] :db_instance_identifier
    #   The DB instance identifier for the DB instance to be deleted. This
    #   parameter isn't case-sensitive.
    #
    #   Constraints:
    #
    #   * Must match the name of an existing DB instance.
    #
    #   ^
    #
    # @option params [Boolean] :skip_final_snapshot
    #   Specifies whether to skip the creation of a final DB snapshot before
    #   deleting the instance. If you enable this parameter, RDS doesn't
    #   create a DB snapshot. If you don't enable this parameter, RDS creates
    #   a DB snapshot before the DB instance is deleted. By default, skip
    #   isn't enabled, and the DB snapshot is created.
    #
    #   <note markdown="1"> If you don't enable this parameter, you must specify the
    #   `FinalDBSnapshotIdentifier` parameter.
    #
    #    </note>
    #
    #   When a DB instance is in a failure state and has a status of `failed`,
    #   `incompatible-restore`, or `incompatible-network`, RDS can delete the
    #   instance only if you enable this parameter.
    #
    #   If you delete a read replica or an RDS Custom instance, you must
    #   enable this setting.
    #
    #   This setting is required for RDS Custom.
    #
    # @option params [String] :final_db_snapshot_identifier
    #   The `DBSnapshotIdentifier` of the new `DBSnapshot` created when the
    #   `SkipFinalSnapshot` parameter is disabled.
    #
    #   <note markdown="1"> If you enable this parameter and also enable SkipFinalShapshot, the
    #   command results in an error.
    #
    #    </note>
    #
    #   This setting doesn't apply to RDS Custom.
    #
    #   Constraints:
    #
    #   * Must be 1 to 255 letters or numbers.
    #
    #   * First character must be a letter.
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens.
    #
    #   * Can't be specified when deleting a read replica.
    #
    # @option params [Boolean] :delete_automated_backups
    #   Specifies whether to remove automated backups immediately after the DB
    #   instance is deleted. This parameter isn't case-sensitive. The default
    #   is to remove automated backups immediately after the DB instance is
    #   deleted.
    #
    # @return [Types::DeleteDBInstanceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteDBInstanceResult#db_instance #db_instance} => Types::DBInstance
    #
    #
    # @example Example: To delete a DB instance
    #
    #   # The following example deletes the specified DB instance after creating a final DB snapshot named
    #   # test-instance-final-snap.
    #
    #   resp = client.delete_db_instance({
    #     db_instance_identifier: "test-instance", 
    #     final_db_snapshot_identifier: "test-instance-final-snap", 
    #     skip_final_snapshot: false, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_instance: {
    #       db_instance_identifier: "test-instance", 
    #       db_instance_status: "deleting", 
    #     }, # Some output ommitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_instance({
    #     db_instance_identifier: "String", # required
    #     skip_final_snapshot: false,
    #     final_db_snapshot_identifier: "String",
    #     delete_automated_backups: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.db_instance.db_instance_identifier #=> String
    #   resp.db_instance.db_instance_class #=> String
    #   resp.db_instance.engine #=> String
    #   resp.db_instance.db_instance_status #=> String
    #   resp.db_instance.automatic_restart_time #=> Time
    #   resp.db_instance.master_username #=> String
    #   resp.db_instance.db_name #=> String
    #   resp.db_instance.endpoint.address #=> String
    #   resp.db_instance.endpoint.port #=> Integer
    #   resp.db_instance.endpoint.hosted_zone_id #=> String
    #   resp.db_instance.allocated_storage #=> Integer
    #   resp.db_instance.instance_create_time #=> Time
    #   resp.db_instance.preferred_backup_window #=> String
    #   resp.db_instance.backup_retention_period #=> Integer
    #   resp.db_instance.db_security_groups #=> Array
    #   resp.db_instance.db_security_groups[0].db_security_group_name #=> String
    #   resp.db_instance.db_security_groups[0].status #=> String
    #   resp.db_instance.vpc_security_groups #=> Array
    #   resp.db_instance.vpc_security_groups[0].vpc_security_group_id #=> String
    #   resp.db_instance.vpc_security_groups[0].status #=> String
    #   resp.db_instance.db_parameter_groups #=> Array
    #   resp.db_instance.db_parameter_groups[0].db_parameter_group_name #=> String
    #   resp.db_instance.db_parameter_groups[0].parameter_apply_status #=> String
    #   resp.db_instance.availability_zone #=> String
    #   resp.db_instance.db_subnet_group.db_subnet_group_name #=> String
    #   resp.db_instance.db_subnet_group.db_subnet_group_description #=> String
    #   resp.db_instance.db_subnet_group.vpc_id #=> String
    #   resp.db_instance.db_subnet_group.subnet_group_status #=> String
    #   resp.db_instance.db_subnet_group.subnets #=> Array
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_identifier #=> String
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_availability_zone.name #=> String
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_outpost.arn #=> String
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_status #=> String
    #   resp.db_instance.db_subnet_group.db_subnet_group_arn #=> String
    #   resp.db_instance.db_subnet_group.supported_network_types #=> Array
    #   resp.db_instance.db_subnet_group.supported_network_types[0] #=> String
    #   resp.db_instance.preferred_maintenance_window #=> String
    #   resp.db_instance.pending_modified_values.db_instance_class #=> String
    #   resp.db_instance.pending_modified_values.allocated_storage #=> Integer
    #   resp.db_instance.pending_modified_values.master_user_password #=> String
    #   resp.db_instance.pending_modified_values.port #=> Integer
    #   resp.db_instance.pending_modified_values.backup_retention_period #=> Integer
    #   resp.db_instance.pending_modified_values.multi_az #=> Boolean
    #   resp.db_instance.pending_modified_values.engine_version #=> String
    #   resp.db_instance.pending_modified_values.license_model #=> String
    #   resp.db_instance.pending_modified_values.iops #=> Integer
    #   resp.db_instance.pending_modified_values.db_instance_identifier #=> String
    #   resp.db_instance.pending_modified_values.storage_type #=> String
    #   resp.db_instance.pending_modified_values.ca_certificate_identifier #=> String
    #   resp.db_instance.pending_modified_values.db_subnet_group_name #=> String
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable #=> Array
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable[0] #=> String
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable #=> Array
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable[0] #=> String
    #   resp.db_instance.pending_modified_values.processor_features #=> Array
    #   resp.db_instance.pending_modified_values.processor_features[0].name #=> String
    #   resp.db_instance.pending_modified_values.processor_features[0].value #=> String
    #   resp.db_instance.pending_modified_values.iam_database_authentication_enabled #=> Boolean
    #   resp.db_instance.pending_modified_values.automation_mode #=> String, one of "full", "all-paused"
    #   resp.db_instance.pending_modified_values.resume_full_automation_mode_time #=> Time
    #   resp.db_instance.pending_modified_values.storage_throughput #=> Integer
    #   resp.db_instance.pending_modified_values.engine #=> String
    #   resp.db_instance.pending_modified_values.dedicated_log_volume #=> Boolean
    #   resp.db_instance.pending_modified_values.multi_tenant #=> Boolean
    #   resp.db_instance.latest_restorable_time #=> Time
    #   resp.db_instance.multi_az #=> Boolean
    #   resp.db_instance.engine_version #=> String
    #   resp.db_instance.auto_minor_version_upgrade #=> Boolean
    #   resp.db_instance.read_replica_source_db_instance_identifier #=> String
    #   resp.db_instance.read_replica_db_instance_identifiers #=> Array
    #   resp.db_instance.read_replica_db_instance_identifiers[0] #=> String
    #   resp.db_instance.read_replica_db_cluster_identifiers #=> Array
    #   resp.db_instance.read_replica_db_cluster_identifiers[0] #=> String
    #   resp.db_instance.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_instance.license_model #=> String
    #   resp.db_instance.iops #=> Integer
    #   resp.db_instance.option_group_memberships #=> Array
    #   resp.db_instance.option_group_memberships[0].option_group_name #=> String
    #   resp.db_instance.option_group_memberships[0].status #=> String
    #   resp.db_instance.character_set_name #=> String
    #   resp.db_instance.nchar_character_set_name #=> String
    #   resp.db_instance.secondary_availability_zone #=> String
    #   resp.db_instance.publicly_accessible #=> Boolean
    #   resp.db_instance.status_infos #=> Array
    #   resp.db_instance.status_infos[0].status_type #=> String
    #   resp.db_instance.status_infos[0].normal #=> Boolean
    #   resp.db_instance.status_infos[0].status #=> String
    #   resp.db_instance.status_infos[0].message #=> String
    #   resp.db_instance.storage_type #=> String
    #   resp.db_instance.tde_credential_arn #=> String
    #   resp.db_instance.db_instance_port #=> Integer
    #   resp.db_instance.db_cluster_identifier #=> String
    #   resp.db_instance.storage_encrypted #=> Boolean
    #   resp.db_instance.kms_key_id #=> String
    #   resp.db_instance.dbi_resource_id #=> String
    #   resp.db_instance.ca_certificate_identifier #=> String
    #   resp.db_instance.domain_memberships #=> Array
    #   resp.db_instance.domain_memberships[0].domain #=> String
    #   resp.db_instance.domain_memberships[0].status #=> String
    #   resp.db_instance.domain_memberships[0].fqdn #=> String
    #   resp.db_instance.domain_memberships[0].iam_role_name #=> String
    #   resp.db_instance.domain_memberships[0].ou #=> String
    #   resp.db_instance.domain_memberships[0].auth_secret_arn #=> String
    #   resp.db_instance.domain_memberships[0].dns_ips #=> Array
    #   resp.db_instance.domain_memberships[0].dns_ips[0] #=> String
    #   resp.db_instance.copy_tags_to_snapshot #=> Boolean
    #   resp.db_instance.monitoring_interval #=> Integer
    #   resp.db_instance.enhanced_monitoring_resource_arn #=> String
    #   resp.db_instance.monitoring_role_arn #=> String
    #   resp.db_instance.promotion_tier #=> Integer
    #   resp.db_instance.db_instance_arn #=> String
    #   resp.db_instance.timezone #=> String
    #   resp.db_instance.iam_database_authentication_enabled #=> Boolean
    #   resp.db_instance.database_insights_mode #=> String, one of "standard", "advanced"
    #   resp.db_instance.performance_insights_enabled #=> Boolean
    #   resp.db_instance.performance_insights_kms_key_id #=> String
    #   resp.db_instance.performance_insights_retention_period #=> Integer
    #   resp.db_instance.enabled_cloudwatch_logs_exports #=> Array
    #   resp.db_instance.enabled_cloudwatch_logs_exports[0] #=> String
    #   resp.db_instance.processor_features #=> Array
    #   resp.db_instance.processor_features[0].name #=> String
    #   resp.db_instance.processor_features[0].value #=> String
    #   resp.db_instance.deletion_protection #=> Boolean
    #   resp.db_instance.associated_roles #=> Array
    #   resp.db_instance.associated_roles[0].role_arn #=> String
    #   resp.db_instance.associated_roles[0].feature_name #=> String
    #   resp.db_instance.associated_roles[0].status #=> String
    #   resp.db_instance.listener_endpoint.address #=> String
    #   resp.db_instance.listener_endpoint.port #=> Integer
    #   resp.db_instance.listener_endpoint.hosted_zone_id #=> String
    #   resp.db_instance.max_allocated_storage #=> Integer
    #   resp.db_instance.tag_list #=> Array
    #   resp.db_instance.tag_list[0].key #=> String
    #   resp.db_instance.tag_list[0].value #=> String
    #   resp.db_instance.db_instance_automated_backups_replications #=> Array
    #   resp.db_instance.db_instance_automated_backups_replications[0].db_instance_automated_backups_arn #=> String
    #   resp.db_instance.customer_owned_ip_enabled #=> Boolean
    #   resp.db_instance.aws_backup_recovery_point_arn #=> String
    #   resp.db_instance.activity_stream_status #=> String, one of "stopped", "starting", "started", "stopping"
    #   resp.db_instance.activity_stream_kms_key_id #=> String
    #   resp.db_instance.activity_stream_kinesis_stream_name #=> String
    #   resp.db_instance.activity_stream_mode #=> String, one of "sync", "async"
    #   resp.db_instance.activity_stream_engine_native_audit_fields_included #=> Boolean
    #   resp.db_instance.automation_mode #=> String, one of "full", "all-paused"
    #   resp.db_instance.resume_full_automation_mode_time #=> Time
    #   resp.db_instance.custom_iam_instance_profile #=> String
    #   resp.db_instance.backup_target #=> String
    #   resp.db_instance.network_type #=> String
    #   resp.db_instance.activity_stream_policy_status #=> String, one of "locked", "unlocked", "locking-policy", "unlocking-policy"
    #   resp.db_instance.storage_throughput #=> Integer
    #   resp.db_instance.db_system_id #=> String
    #   resp.db_instance.master_user_secret.secret_arn #=> String
    #   resp.db_instance.master_user_secret.secret_status #=> String
    #   resp.db_instance.master_user_secret.kms_key_id #=> String
    #   resp.db_instance.certificate_details.ca_identifier #=> String
    #   resp.db_instance.certificate_details.valid_till #=> Time
    #   resp.db_instance.read_replica_source_db_cluster_identifier #=> String
    #   resp.db_instance.percent_progress #=> String
    #   resp.db_instance.dedicated_log_volume #=> Boolean
    #   resp.db_instance.is_storage_config_upgrade_available #=> Boolean
    #   resp.db_instance.multi_tenant #=> Boolean
    #   resp.db_instance.engine_lifecycle_support #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstance AWS API Documentation
    #
    # @overload delete_db_instance(params = {})
    # @param [Hash] params ({})
    def delete_db_instance(params = {}, options = {})
      req = build_request(:delete_db_instance, params)
      req.send_request(options)
    end

    # Deletes automated backups using the `DbiResourceId` value of the
    # source DB instance or the Amazon Resource Name (ARN) of the automated
    # backups.
    #
    # @option params [String] :dbi_resource_id
    #   The identifier for the source DB instance, which can't be changed and
    #   which is unique to an Amazon Web Services Region.
    #
    # @option params [String] :db_instance_automated_backups_arn
    #   The Amazon Resource Name (ARN) of the automated backups to delete, for
    #   example,
    #   `arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE`.
    #
    #   This setting doesn't apply to RDS Custom.
    #
    # @return [Types::DeleteDBInstanceAutomatedBackupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteDBInstanceAutomatedBackupResult#db_instance_automated_backup #db_instance_automated_backup} => Types::DBInstanceAutomatedBackup
    #
    #
    # @example Example: To delete a replicated automated backup from a Region
    #
    #   # The following example deletes the automated backup with the specified Amazon Resource Name (ARN).
    #
    #   resp = client.delete_db_instance_automated_backup({
    #     db_instance_automated_backups_arn: "arn:aws:rds:us-west-2:123456789012:auto-backup:ab-jkib2gfq5rv7replzadausbrktni2bn4example", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_instance_automated_backup: {
    #       allocated_storage: 20, 
    #       availability_zone: "us-east-1b", 
    #       backup_retention_period: 7, 
    #       db_instance_arn: "arn:aws:rds:us-east-1:123456789012:db:new-orcl-db", 
    #       db_instance_automated_backups_arn: "arn:aws:rds:us-west-2:123456789012:auto-backup:ab-jkib2gfq5rv7replzadausbrktni2bn4example", 
    #       db_instance_identifier: "new-orcl-db", 
    #       dbi_resource_id: "db-JKIB2GFQ5RV7REPLZA4EXAMPLE", 
    #       encrypted: false, 
    #       engine: "oracle-se2", 
    #       engine_version: "12.1.0.2.v21", 
    #       iam_database_authentication_enabled: false, 
    #       instance_create_time: Time.parse("2020-12-04T15:28:31Z"), 
    #       license_model: "bring-your-own-license", 
    #       master_username: "admin", 
    #       option_group_name: "default:oracle-se2-12-1", 
    #       port: 1521, 
    #       region: "us-east-1", 
    #       restore_window: {
    #       }, 
    #       status: "deleting", 
    #       storage_type: "gp2", 
    #       vpc_id: "vpc-########", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_instance_automated_backup({
    #     dbi_resource_id: "String",
    #     db_instance_automated_backups_arn: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.db_instance_automated_backup.db_instance_arn #=> String
    #   resp.db_instance_automated_backup.dbi_resource_id #=> String
    #   resp.db_instance_automated_backup.region #=> String
    #   resp.db_instance_automated_backup.db_instance_identifier #=> String
    #   resp.db_instance_automated_backup.restore_window.earliest_time #=> Time
    #   resp.db_instance_automated_backup.restore_window.latest_time #=> Time
    #   resp.db_instance_automated_backup.allocated_storage #=> Integer
    #   resp.db_instance_automated_backup.status #=> String
    #   resp.db_instance_automated_backup.port #=> Integer
    #   resp.db_instance_automated_backup.availability_zone #=> String
    #   resp.db_instance_automated_backup.vpc_id #=> String
    #   resp.db_instance_automated_backup.instance_create_time #=> Time
    #   resp.db_instance_automated_backup.master_username #=> String
    #   resp.db_instance_automated_backup.engine #=> String
    #   resp.db_instance_automated_backup.engine_version #=> String
    #   resp.db_instance_automated_backup.license_model #=> String
    #   resp.db_instance_automated_backup.iops #=> Integer
    #   resp.db_instance_automated_backup.option_group_name #=> String
    #   resp.db_instance_automated_backup.tde_credential_arn #=> String
    #   resp.db_instance_automated_backup.encrypted #=> Boolean
    #   resp.db_instance_automated_backup.storage_type #=> String
    #   resp.db_instance_automated_backup.kms_key_id #=> String
    #   resp.db_instance_automated_backup.timezone #=> String
    #   resp.db_instance_automated_backup.iam_database_authentication_enabled #=> Boolean
    #   resp.db_instance_automated_backup.backup_retention_period #=> Integer
    #   resp.db_instance_automated_backup.db_instance_automated_backups_arn #=> String
    #   resp.db_instance_automated_backup.db_instance_automated_backups_replications #=> Array
    #   resp.db_instance_automated_backup.db_instance_automated_backups_replications[0].db_instance_automated_backups_arn #=> String
    #   resp.db_instance_automated_backup.backup_target #=> String
    #   resp.db_instance_automated_backup.storage_throughput #=> Integer
    #   resp.db_instance_automated_backup.aws_backup_recovery_point_arn #=> String
    #   resp.db_instance_automated_backup.dedicated_log_volume #=> Boolean
    #   resp.db_instance_automated_backup.multi_tenant #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstanceAutomatedBackup AWS API Documentation
    #
    # @overload delete_db_instance_automated_backup(params = {})
    # @param [Hash] params ({})
    def delete_db_instance_automated_backup(params = {}, options = {})
      req = build_request(:delete_db_instance_automated_backup, params)
      req.send_request(options)
    end

    # Deletes a specified DB parameter group. The DB parameter group to be
    # deleted can't be associated with any DB instances.
    #
    # @option params [required, String] :db_parameter_group_name
    #   The name of the DB parameter group.
    #
    #   Constraints:
    #
    #   * Must be the name of an existing DB parameter group
    #
    #   * You can't delete a default DB parameter group
    #
    #   * Can't be associated with any DB instances
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a DB parameter group
    #
    #   # The following example deletes a DB parameter group.
    #
    #   resp = client.delete_db_parameter_group({
    #     db_parameter_group_name: "mydbparametergroup", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_parameter_group({
    #     db_parameter_group_name: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroup AWS API Documentation
    #
    # @overload delete_db_parameter_group(params = {})
    # @param [Hash] params ({})
    def delete_db_parameter_group(params = {}, options = {})
      req = build_request(:delete_db_parameter_group, params)
      req.send_request(options)
    end

    # Deletes an existing DB proxy.
    #
    # @option params [required, String] :db_proxy_name
    #   The name of the DB proxy to delete.
    #
    # @return [Types::DeleteDBProxyResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteDBProxyResponse#db_proxy #db_proxy} => Types::DBProxy
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_proxy({
    #     db_proxy_name: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.db_proxy.db_proxy_name #=> String
    #   resp.db_proxy.db_proxy_arn #=> String
    #   resp.db_proxy.status #=> String, one of "available", "modifying", "incompatible-network", "insufficient-resource-limits", "creating", "deleting", "suspended", "suspending", "reactivating"
    #   resp.db_proxy.engine_family #=> String
    #   resp.db_proxy.vpc_id #=> String
    #   resp.db_proxy.vpc_security_group_ids #=> Array
    #   resp.db_proxy.vpc_security_group_ids[0] #=> String
    #   resp.db_proxy.vpc_subnet_ids #=> Array
    #   resp.db_proxy.vpc_subnet_ids[0] #=> String
    #   resp.db_proxy.auth #=> Array
    #   resp.db_proxy.auth[0].description #=> String
    #   resp.db_proxy.auth[0].user_name #=> String
    #   resp.db_proxy.auth[0].auth_scheme #=> String, one of "SECRETS"
    #   resp.db_proxy.auth[0].secret_arn #=> String
    #   resp.db_proxy.auth[0].iam_auth #=> String, one of "DISABLED", "REQUIRED", "ENABLED"
    #   resp.db_proxy.auth[0].client_password_auth_type #=> String, one of "MYSQL_NATIVE_PASSWORD", "MYSQL_CACHING_SHA2_PASSWORD", "POSTGRES_SCRAM_SHA_256", "POSTGRES_MD5", "SQL_SERVER_AUTHENTICATION"
    #   resp.db_proxy.role_arn #=> String
    #   resp.db_proxy.endpoint #=> String
    #   resp.db_proxy.require_tls #=> Boolean
    #   resp.db_proxy.idle_client_timeout #=> Integer
    #   resp.db_proxy.debug_logging #=> Boolean
    #   resp.db_proxy.created_date #=> Time
    #   resp.db_proxy.updated_date #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxy AWS API Documentation
    #
    # @overload delete_db_proxy(params = {})
    # @param [Hash] params ({})
    def delete_db_proxy(params = {}, options = {})
      req = build_request(:delete_db_proxy, params)
      req.send_request(options)
    end

    # Deletes a `DBProxyEndpoint`. Doing so removes the ability to access
    # the DB proxy using the endpoint that you defined. The endpoint that
    # you delete might have provided capabilities such as read/write or
    # read-only operations, or using a different VPC than the DB proxy's
    # default VPC.
    #
    # @option params [required, String] :db_proxy_endpoint_name
    #   The name of the DB proxy endpoint to delete.
    #
    # @return [Types::DeleteDBProxyEndpointResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteDBProxyEndpointResponse#db_proxy_endpoint #db_proxy_endpoint} => Types::DBProxyEndpoint
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_proxy_endpoint({
    #     db_proxy_endpoint_name: "DBProxyEndpointName", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.db_proxy_endpoint.db_proxy_endpoint_name #=> String
    #   resp.db_proxy_endpoint.db_proxy_endpoint_arn #=> String
    #   resp.db_proxy_endpoint.db_proxy_name #=> String
    #   resp.db_proxy_endpoint.status #=> String, one of "available", "modifying", "incompatible-network", "insufficient-resource-limits", "creating", "deleting"
    #   resp.db_proxy_endpoint.vpc_id #=> String
    #   resp.db_proxy_endpoint.vpc_security_group_ids #=> Array
    #   resp.db_proxy_endpoint.vpc_security_group_ids[0] #=> String
    #   resp.db_proxy_endpoint.vpc_subnet_ids #=> Array
    #   resp.db_proxy_endpoint.vpc_subnet_ids[0] #=> String
    #   resp.db_proxy_endpoint.endpoint #=> String
    #   resp.db_proxy_endpoint.created_date #=> Time
    #   resp.db_proxy_endpoint.target_role #=> String, one of "READ_WRITE", "READ_ONLY"
    #   resp.db_proxy_endpoint.is_default #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxyEndpoint AWS API Documentation
    #
    # @overload delete_db_proxy_endpoint(params = {})
    # @param [Hash] params ({})
    def delete_db_proxy_endpoint(params = {}, options = {})
      req = build_request(:delete_db_proxy_endpoint, params)
      req.send_request(options)
    end

    # Deletes a DB security group.
    #
    # The specified DB security group must not be associated with any DB
    # instances.
    #
    # <note markdown="1"> EC2-Classic was retired on August 15, 2022. If you haven't migrated
    # from EC2-Classic to a VPC, we recommend that you migrate as soon as
    # possible. For more information, see [Migrate from EC2-Classic to a
    # VPC][1] in the *Amazon EC2 User Guide*, the blog [EC2-Classic
    # Networking is Retiring – Here’s How to Prepare][2], and [Moving a DB
    # instance not in a VPC into a VPC][3] in the *Amazon RDS User Guide*.
    #
    #  </note>
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html
    # [2]: http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/
    # [3]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html
    #
    # @option params [required, String] :db_security_group_name
    #   The name of the DB security group to delete.
    #
    #   <note markdown="1"> You can't delete the default DB security group.
    #
    #    </note>
    #
    #   Constraints:
    #
    #   * Must be 1 to 255 letters, numbers, or hyphens.
    #
    #   * First character must be a letter
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens
    #
    #   * Must not be "Default"
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a DB security group
    #
    #   # The following example deletes a DB security group.
    #
    #   resp = client.delete_db_security_group({
    #     db_security_group_name: "mysecgroup", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_security_group({
    #     db_security_group_name: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroup AWS API Documentation
    #
    # @overload delete_db_security_group(params = {})
    # @param [Hash] params ({})
    def delete_db_security_group(params = {}, options = {})
      req = build_request(:delete_db_security_group, params)
      req.send_request(options)
    end

    # Deletes an Aurora Limitless Database DB shard group.
    #
    # @option params [required, String] :db_shard_group_identifier
    #   The name of the DB shard group to delete.
    #
    # @return [Types::DBShardGroup] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBShardGroup#db_shard_group_resource_id #db_shard_group_resource_id} => String
    #   * {Types::DBShardGroup#db_shard_group_identifier #db_shard_group_identifier} => String
    #   * {Types::DBShardGroup#db_cluster_identifier #db_cluster_identifier} => String
    #   * {Types::DBShardGroup#max_acu #max_acu} => Float
    #   * {Types::DBShardGroup#min_acu #min_acu} => Float
    #   * {Types::DBShardGroup#compute_redundancy #compute_redundancy} => Integer
    #   * {Types::DBShardGroup#status #status} => String
    #   * {Types::DBShardGroup#publicly_accessible #publicly_accessible} => Boolean
    #   * {Types::DBShardGroup#endpoint #endpoint} => String
    #   * {Types::DBShardGroup#db_shard_group_arn #db_shard_group_arn} => String
    #   * {Types::DBShardGroup#tag_list #tag_list} => Array&lt;Types::Tag&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_shard_group({
    #     db_shard_group_identifier: "DBShardGroupIdentifier", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.db_shard_group_resource_id #=> String
    #   resp.db_shard_group_identifier #=> String
    #   resp.db_cluster_identifier #=> String
    #   resp.max_acu #=> Float
    #   resp.min_acu #=> Float
    #   resp.compute_redundancy #=> Integer
    #   resp.status #=> String
    #   resp.publicly_accessible #=> Boolean
    #   resp.endpoint #=> String
    #   resp.db_shard_group_arn #=> String
    #   resp.tag_list #=> Array
    #   resp.tag_list[0].key #=> String
    #   resp.tag_list[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBShardGroup AWS API Documentation
    #
    # @overload delete_db_shard_group(params = {})
    # @param [Hash] params ({})
    def delete_db_shard_group(params = {}, options = {})
      req = build_request(:delete_db_shard_group, params)
      req.send_request(options)
    end

    # Deletes a DB snapshot. If the snapshot is being copied, the copy
    # operation is terminated.
    #
    # <note markdown="1"> The DB snapshot must be in the `available` state to be deleted.
    #
    #  </note>
    #
    # @option params [required, String] :db_snapshot_identifier
    #   The DB snapshot identifier.
    #
    #   Constraints: Must be the name of an existing DB snapshot in the
    #   `available` state.
    #
    # @return [Types::DeleteDBSnapshotResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteDBSnapshotResult#db_snapshot #db_snapshot} => Types::DBSnapshot
    #
    #
    # @example Example: To delete a DB snapshot
    #
    #   # The following example deletes the specified DB snapshot.
    #
    #   resp = client.delete_db_snapshot({
    #     db_snapshot_identifier: "mydbsnapshot", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_snapshot: {
    #       allocated_storage: 100, 
    #       availability_zone: "us-east-1b", 
    #       db_instance_identifier: "database-mysql", 
    #       db_snapshot_arn: "arn:aws:rds:us-east-1:123456789012:snapshot:mydbsnapshot", 
    #       db_snapshot_identifier: "mydbsnapshot", 
    #       dbi_resource_id: "db-AKIAIOSFODNN7EXAMPLE", 
    #       encrypted: true, 
    #       engine: "mysql", 
    #       engine_version: "5.6.40", 
    #       iam_database_authentication_enabled: false, 
    #       instance_create_time: Time.parse("2019-04-30T15:45:53.663Z"), 
    #       iops: 1000, 
    #       kms_key_id: "arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE", 
    #       license_model: "general-public-license", 
    #       master_username: "admin", 
    #       option_group_name: "default:mysql-5-6", 
    #       percent_progress: 100, 
    #       port: 3306, 
    #       processor_features: [
    #       ], 
    #       snapshot_create_time: Time.parse("2019-06-18T22:08:40.702Z"), 
    #       snapshot_type: "manual", 
    #       status: "deleted", 
    #       storage_type: "io1", 
    #       vpc_id: "vpc-6594f31c", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_snapshot({
    #     db_snapshot_identifier: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.db_snapshot.db_snapshot_identifier #=> String
    #   resp.db_snapshot.db_instance_identifier #=> String
    #   resp.db_snapshot.snapshot_create_time #=> Time
    #   resp.db_snapshot.engine #=> String
    #   resp.db_snapshot.allocated_storage #=> Integer
    #   resp.db_snapshot.status #=> String
    #   resp.db_snapshot.port #=> Integer
    #   resp.db_snapshot.availability_zone #=> String
    #   resp.db_snapshot.vpc_id #=> String
    #   resp.db_snapshot.instance_create_time #=> Time
    #   resp.db_snapshot.master_username #=> String
    #   resp.db_snapshot.engine_version #=> String
    #   resp.db_snapshot.license_model #=> String
    #   resp.db_snapshot.snapshot_type #=> String
    #   resp.db_snapshot.iops #=> Integer
    #   resp.db_snapshot.option_group_name #=> String
    #   resp.db_snapshot.percent_progress #=> Integer
    #   resp.db_snapshot.source_region #=> String
    #   resp.db_snapshot.source_db_snapshot_identifier #=> String
    #   resp.db_snapshot.storage_type #=> String
    #   resp.db_snapshot.tde_credential_arn #=> String
    #   resp.db_snapshot.encrypted #=> Boolean
    #   resp.db_snapshot.kms_key_id #=> String
    #   resp.db_snapshot.db_snapshot_arn #=> String
    #   resp.db_snapshot.timezone #=> String
    #   resp.db_snapshot.iam_database_authentication_enabled #=> Boolean
    #   resp.db_snapshot.processor_features #=> Array
    #   resp.db_snapshot.processor_features[0].name #=> String
    #   resp.db_snapshot.processor_features[0].value #=> String
    #   resp.db_snapshot.dbi_resource_id #=> String
    #   resp.db_snapshot.tag_list #=> Array
    #   resp.db_snapshot.tag_list[0].key #=> String
    #   resp.db_snapshot.tag_list[0].value #=> String
    #   resp.db_snapshot.original_snapshot_create_time #=> Time
    #   resp.db_snapshot.snapshot_database_time #=> Time
    #   resp.db_snapshot.snapshot_target #=> String
    #   resp.db_snapshot.storage_throughput #=> Integer
    #   resp.db_snapshot.db_system_id #=> String
    #   resp.db_snapshot.dedicated_log_volume #=> Boolean
    #   resp.db_snapshot.multi_tenant #=> Boolean
    #   resp.db_snapshot.snapshot_availability_zone #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshot AWS API Documentation
    #
    # @overload delete_db_snapshot(params = {})
    # @param [Hash] params ({})
    def delete_db_snapshot(params = {}, options = {})
      req = build_request(:delete_db_snapshot, params)
      req.send_request(options)
    end

    # Deletes a DB subnet group.
    #
    # <note markdown="1"> The specified database subnet group must not be associated with any DB
    # instances.
    #
    #  </note>
    #
    # @option params [required, String] :db_subnet_group_name
    #   The name of the database subnet group to delete.
    #
    #   <note markdown="1"> You can't delete the default subnet group.
    #
    #    </note>
    #
    #   Constraints: Must match the name of an existing DBSubnetGroup. Must
    #   not be default.
    #
    #   Example: `mydbsubnetgroup`
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a DB subnet group
    #
    #   # The following example deletes the DB subnet group called mysubnetgroup.
    #
    #   resp = client.delete_db_subnet_group({
    #     db_subnet_group_name: "mysubnetgroup", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_db_subnet_group({
    #     db_subnet_group_name: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroup AWS API Documentation
    #
    # @overload delete_db_subnet_group(params = {})
    # @param [Hash] params ({})
    def delete_db_subnet_group(params = {}, options = {})
      req = build_request(:delete_db_subnet_group, params)
      req.send_request(options)
    end

    # Deletes an RDS event notification subscription.
    #
    # @option params [required, String] :subscription_name
    #   The name of the RDS event notification subscription you want to
    #   delete.
    #
    # @return [Types::DeleteEventSubscriptionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteEventSubscriptionResult#event_subscription #event_subscription} => Types::EventSubscription
    #
    #
    # @example Example: To delete an event subscription
    #
    #   # The following example deletes the specified event subscription.
    #
    #   resp = client.delete_event_subscription({
    #     subscription_name: "my-instance-events", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     event_subscription: {
    #       cust_subscription_id: "my-instance-events", 
    #       customer_aws_id: "123456789012", 
    #       enabled: false, 
    #       event_categories_list: [
    #         "backup", 
    #         "recovery", 
    #       ], 
    #       event_subscription_arn: "arn:aws:rds:us-east-1:123456789012:es:my-instance-events", 
    #       sns_topic_arn: "arn:aws:sns:us-east-1:123456789012:interesting-events", 
    #       source_ids_list: [
    #         "test-instance", 
    #       ], 
    #       source_type: "db-instance", 
    #       status: "deleting", 
    #       subscription_creation_time: "2018-07-31 23:22:01.893", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_event_subscription({
    #     subscription_name: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.event_subscription.customer_aws_id #=> String
    #   resp.event_subscription.cust_subscription_id #=> String
    #   resp.event_subscription.sns_topic_arn #=> String
    #   resp.event_subscription.status #=> String
    #   resp.event_subscription.subscription_creation_time #=> String
    #   resp.event_subscription.source_type #=> String
    #   resp.event_subscription.source_ids_list #=> Array
    #   resp.event_subscription.source_ids_list[0] #=> String
    #   resp.event_subscription.event_categories_list #=> Array
    #   resp.event_subscription.event_categories_list[0] #=> String
    #   resp.event_subscription.enabled #=> Boolean
    #   resp.event_subscription.event_subscription_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscription AWS API Documentation
    #
    # @overload delete_event_subscription(params = {})
    # @param [Hash] params ({})
    def delete_event_subscription(params = {}, options = {})
      req = build_request(:delete_event_subscription, params)
      req.send_request(options)
    end

    # Deletes a global database cluster. The primary and secondary clusters
    # must already be detached or destroyed first.
    #
    # <note markdown="1"> This action only applies to Aurora DB clusters.
    #
    #  </note>
    #
    # @option params [required, String] :global_cluster_identifier
    #   The cluster identifier of the global database cluster being deleted.
    #
    # @return [Types::DeleteGlobalClusterResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteGlobalClusterResult#global_cluster #global_cluster} => Types::GlobalCluster
    #
    #
    # @example Example: To delete a global DB cluster
    #
    #   # The following example deletes an Aurora MySQL-compatible global DB cluster.
    #
    #   resp = client.delete_global_cluster({
    #     global_cluster_identifier: "myglobalcluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     global_cluster: {
    #       deletion_protection: false, 
    #       engine: "aurora-mysql", 
    #       engine_version: "5.7.mysql_aurora.2.07.2", 
    #       global_cluster_arn: "arn:aws:rds::123456789012:global-cluster:myglobalcluster", 
    #       global_cluster_identifier: "myglobalcluster", 
    #       global_cluster_members: [
    #       ], 
    #       global_cluster_resource_id: "cluster-f0e523bfe07aabb", 
    #       status: "available", 
    #       storage_encrypted: false, 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_global_cluster({
    #     global_cluster_identifier: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.global_cluster.global_cluster_identifier #=> String
    #   resp.global_cluster.global_cluster_resource_id #=> String
    #   resp.global_cluster.global_cluster_arn #=> String
    #   resp.global_cluster.status #=> String
    #   resp.global_cluster.engine #=> String
    #   resp.global_cluster.engine_version #=> String
    #   resp.global_cluster.engine_lifecycle_support #=> String
    #   resp.global_cluster.database_name #=> String
    #   resp.global_cluster.storage_encrypted #=> Boolean
    #   resp.global_cluster.deletion_protection #=> Boolean
    #   resp.global_cluster.global_cluster_members #=> Array
    #   resp.global_cluster.global_cluster_members[0].db_cluster_arn #=> String
    #   resp.global_cluster.global_cluster_members[0].readers #=> Array
    #   resp.global_cluster.global_cluster_members[0].readers[0] #=> String
    #   resp.global_cluster.global_cluster_members[0].is_writer #=> Boolean
    #   resp.global_cluster.global_cluster_members[0].global_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "unknown"
    #   resp.global_cluster.global_cluster_members[0].synchronization_status #=> String, one of "connected", "pending-resync"
    #   resp.global_cluster.endpoint #=> String
    #   resp.global_cluster.failover_state.status #=> String, one of "pending", "failing-over", "cancelling"
    #   resp.global_cluster.failover_state.from_db_cluster_arn #=> String
    #   resp.global_cluster.failover_state.to_db_cluster_arn #=> String
    #   resp.global_cluster.failover_state.is_data_loss_allowed #=> Boolean
    #   resp.global_cluster.tag_list #=> Array
    #   resp.global_cluster.tag_list[0].key #=> String
    #   resp.global_cluster.tag_list[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteGlobalCluster AWS API Documentation
    #
    # @overload delete_global_cluster(params = {})
    # @param [Hash] params ({})
    def delete_global_cluster(params = {}, options = {})
      req = build_request(:delete_global_cluster, params)
      req.send_request(options)
    end

    # Deletes a zero-ETL integration with Amazon Redshift.
    #
    # @option params [required, String] :integration_identifier
    #   The unique identifier of the integration.
    #
    # @return [Types::Integration] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::Integration#source_arn #source_arn} => String
    #   * {Types::Integration#target_arn #target_arn} => String
    #   * {Types::Integration#integration_name #integration_name} => String
    #   * {Types::Integration#integration_arn #integration_arn} => String
    #   * {Types::Integration#kms_key_id #kms_key_id} => String
    #   * {Types::Integration#additional_encryption_context #additional_encryption_context} => Hash&lt;String,String&gt;
    #   * {Types::Integration#status #status} => String
    #   * {Types::Integration#tags #tags} => Array&lt;Types::Tag&gt;
    #   * {Types::Integration#create_time #create_time} => Time
    #   * {Types::Integration#errors #errors} => Array&lt;Types::IntegrationError&gt;
    #   * {Types::Integration#data_filter #data_filter} => String
    #   * {Types::Integration#description #description} => String
    #
    #
    # @example Example: To delete a zero-ETL integration
    #
    #   # The following example deletes a zero-ETL integration with Amazon Redshift.
    #
    #   resp = client.delete_integration({
    #     integration_identifier: "5b9f3d79-7392-4a3e-896c-58eaa1b53231", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     create_time: Time.parse("2023-12-28T17:20:20.629Z"), 
    #     integration_arn: "arn:aws:rds:us-east-1:123456789012:integration:5b9f3d79-7392-4a3e-896c-58eaa1b53231", 
    #     integration_name: "my-integration", 
    #     kms_key_id: "arn:aws:kms:us-east-1:123456789012:key/a1b2c3d4-5678-90ab-cdef-EXAMPLEaaaaa", 
    #     source_arn: "arn:aws:rds:us-east-1:123456789012:cluster:my-cluster", 
    #     status: "deleting", 
    #     tags: [
    #     ], 
    #     target_arn: "arn:aws:redshift-serverless:us-east-1:123456789012:namespace/62c70612-0302-4db7-8414-b5e3e049f0d8", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_integration({
    #     integration_identifier: "IntegrationIdentifier", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.source_arn #=> String
    #   resp.target_arn #=> String
    #   resp.integration_name #=> String
    #   resp.integration_arn #=> String
    #   resp.kms_key_id #=> String
    #   resp.additional_encryption_context #=> Hash
    #   resp.additional_encryption_context["String"] #=> String
    #   resp.status #=> String, one of "creating", "active", "modifying", "failed", "deleting", "syncing", "needs_attention"
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #   resp.create_time #=> Time
    #   resp.errors #=> Array
    #   resp.errors[0].error_code #=> String
    #   resp.errors[0].error_message #=> String
    #   resp.data_filter #=> String
    #   resp.description #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteIntegration AWS API Documentation
    #
    # @overload delete_integration(params = {})
    # @param [Hash] params ({})
    def delete_integration(params = {}, options = {})
      req = build_request(:delete_integration, params)
      req.send_request(options)
    end

    # Deletes an existing option group.
    #
    # @option params [required, String] :option_group_name
    #   The name of the option group to be deleted.
    #
    #   <note markdown="1"> You can't delete default option groups.
    #
    #    </note>
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete an option group
    #
    #   # The following example deletes the specified option group.
    #
    #   resp = client.delete_option_group({
    #     option_group_name: "myoptiongroup", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_option_group({
    #     option_group_name: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroup AWS API Documentation
    #
    # @overload delete_option_group(params = {})
    # @param [Hash] params ({})
    def delete_option_group(params = {}, options = {})
      req = build_request(:delete_option_group, params)
      req.send_request(options)
    end

    # Deletes a tenant database from your DB instance. This command only
    # applies to RDS for Oracle container database (CDB) instances.
    #
    # You can't delete a tenant database when it is the only tenant in the
    # DB instance.
    #
    # @option params [required, String] :db_instance_identifier
    #   The user-supplied identifier for the DB instance that contains the
    #   tenant database that you want to delete.
    #
    # @option params [required, String] :tenant_db_name
    #   The user-supplied name of the tenant database that you want to remove
    #   from your DB instance. Amazon RDS deletes the tenant database with
    #   this name. This parameter isn’t case-sensitive.
    #
    # @option params [Boolean] :skip_final_snapshot
    #   Specifies whether to skip the creation of a final DB snapshot before
    #   removing the tenant database from your DB instance. If you enable this
    #   parameter, RDS doesn't create a DB snapshot. If you don't enable
    #   this parameter, RDS creates a DB snapshot before it deletes the tenant
    #   database. By default, RDS doesn't skip the final snapshot. If you
    #   don't enable this parameter, you must specify the
    #   `FinalDBSnapshotIdentifier` parameter.
    #
    # @option params [String] :final_db_snapshot_identifier
    #   The `DBSnapshotIdentifier` of the new `DBSnapshot` created when the
    #   `SkipFinalSnapshot` parameter is disabled.
    #
    #   <note markdown="1"> If you enable this parameter and also enable `SkipFinalShapshot`, the
    #   command results in an error.
    #
    #    </note>
    #
    # @return [Types::DeleteTenantDatabaseResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTenantDatabaseResult#tenant_database #tenant_database} => Types::TenantDatabase
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_tenant_database({
    #     db_instance_identifier: "String", # required
    #     tenant_db_name: "String", # required
    #     skip_final_snapshot: false,
    #     final_db_snapshot_identifier: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.tenant_database.tenant_database_create_time #=> Time
    #   resp.tenant_database.db_instance_identifier #=> String
    #   resp.tenant_database.tenant_db_name #=> String
    #   resp.tenant_database.status #=> String
    #   resp.tenant_database.master_username #=> String
    #   resp.tenant_database.dbi_resource_id #=> String
    #   resp.tenant_database.tenant_database_resource_id #=> String
    #   resp.tenant_database.tenant_database_arn #=> String
    #   resp.tenant_database.character_set_name #=> String
    #   resp.tenant_database.nchar_character_set_name #=> String
    #   resp.tenant_database.deletion_protection #=> Boolean
    #   resp.tenant_database.pending_modified_values.master_user_password #=> String
    #   resp.tenant_database.pending_modified_values.tenant_db_name #=> String
    #   resp.tenant_database.master_user_secret.secret_arn #=> String
    #   resp.tenant_database.master_user_secret.secret_status #=> String
    #   resp.tenant_database.master_user_secret.kms_key_id #=> String
    #   resp.tenant_database.tag_list #=> Array
    #   resp.tenant_database.tag_list[0].key #=> String
    #   resp.tenant_database.tag_list[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteTenantDatabase AWS API Documentation
    #
    # @overload delete_tenant_database(params = {})
    # @param [Hash] params ({})
    def delete_tenant_database(params = {}, options = {})
      req = build_request(:delete_tenant_database, params)
      req.send_request(options)
    end

    # Remove the association between one or more `DBProxyTarget` data
    # structures and a `DBProxyTargetGroup`.
    #
    # @option params [required, String] :db_proxy_name
    #   The identifier of the `DBProxy` that is associated with the
    #   `DBProxyTargetGroup`.
    #
    # @option params [String] :target_group_name
    #   The identifier of the `DBProxyTargetGroup`.
    #
    # @option params [Array<String>] :db_instance_identifiers
    #   One or more DB instance identifiers.
    #
    # @option params [Array<String>] :db_cluster_identifiers
    #   One or more DB cluster identifiers.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.deregister_db_proxy_targets({
    #     db_proxy_name: "String", # required
    #     target_group_name: "String",
    #     db_instance_identifiers: ["String"],
    #     db_cluster_identifiers: ["String"],
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeregisterDBProxyTargets AWS API Documentation
    #
    # @overload deregister_db_proxy_targets(params = {})
    # @param [Hash] params ({})
    def deregister_db_proxy_targets(params = {}, options = {})
      req = build_request(:deregister_db_proxy_targets, params)
      req.send_request(options)
    end

    # Lists all of the attributes for a customer account. The attributes
    # include Amazon RDS quotas for the account, such as the number of DB
    # instances allowed. The description for a quota includes the quota
    # name, current usage toward that quota, and the quota's maximum value.
    #
    # This command doesn't take any parameters.
    #
    # @return [Types::AccountAttributesMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AccountAttributesMessage#account_quotas #account_quotas} => Array&lt;Types::AccountQuota&gt;
    #
    #
    # @example Example: To describe account attributes
    #
    #   # The following example retrieves the attributes for the current AWS account.
    #
    #   resp = client.describe_account_attributes({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     account_quotas: [
    #       {
    #         account_quota_name: "DBInstances", 
    #         max: 40, 
    #         used: 4, 
    #       }, 
    #       {
    #         account_quota_name: "ReservedDBInstances", 
    #         max: 40, 
    #         used: 0, 
    #       }, 
    #       {
    #         account_quota_name: "AllocatedStorage", 
    #         max: 100000, 
    #         used: 40, 
    #       }, 
    #       {
    #         account_quota_name: "DBSecurityGroups", 
    #         max: 25, 
    #         used: 0, 
    #       }, 
    #       {
    #         account_quota_name: "AuthorizationsPerDBSecurityGroup", 
    #         max: 20, 
    #         used: 0, 
    #       }, 
    #       {
    #         account_quota_name: "DBParameterGroups", 
    #         max: 50, 
    #         used: 1, 
    #       }, 
    #       {
    #         account_quota_name: "ManualSnapshots", 
    #         max: 100, 
    #         used: 3, 
    #       }, 
    #       {
    #         account_quota_name: "EventSubscriptions", 
    #         max: 20, 
    #         used: 0, 
    #       }, 
    #       {
    #         account_quota_name: "DBSubnetGroups", 
    #         max: 50, 
    #         used: 1, 
    #       }, 
    #       {
    #         account_quota_name: "OptionGroups", 
    #         max: 20, 
    #         used: 1, 
    #       }, 
    #       {
    #         account_quota_name: "SubnetsPerDBSubnetGroup", 
    #         max: 20, 
    #         used: 6, 
    #       }, 
    #       {
    #         account_quota_name: "ReadReplicasPerMaster", 
    #         max: 5, 
    #         used: 0, 
    #       }, 
    #       {
    #         account_quota_name: "DBClusters", 
    #         max: 40, 
    #         used: 1, 
    #       }, 
    #       {
    #         account_quota_name: "DBClusterParameterGroups", 
    #         max: 50, 
    #         used: 0, 
    #       }, 
    #       {
    #         account_quota_name: "DBClusterRoles", 
    #         max: 5, 
    #         used: 0, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Response structure
    #
    #   resp.account_quotas #=> Array
    #   resp.account_quotas[0].account_quota_name #=> String
    #   resp.account_quotas[0].used #=> Integer
    #   resp.account_quotas[0].max #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes AWS API Documentation
    #
    # @overload describe_account_attributes(params = {})
    # @param [Hash] params ({})
    def describe_account_attributes(params = {}, options = {})
      req = build_request(:describe_account_attributes, params)
      req.send_request(options)
    end

    # Describes one or more blue/green deployments.
    #
    # For more information, see [Using Amazon RDS Blue/Green Deployments for
    # database updates][1] in the *Amazon RDS User Guide* and [ Using Amazon
    # RDS Blue/Green Deployments for database updates][2] in the *Amazon
    # Aurora User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html
    #
    # @option params [String] :blue_green_deployment_identifier
    #   The blue/green deployment identifier. If you specify this parameter,
    #   the response only includes information about the specific blue/green
    #   deployment. This parameter isn't case-sensitive.
    #
    #   Constraints:
    #
    #   * Must match an existing blue/green deployment identifier.
    #
    #   ^
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more blue/green deployments to
    #   describe.
    #
    #   Valid Values:
    #
    #   * `blue-green-deployment-identifier` - Accepts system-generated
    #     identifiers for blue/green deployments. The results list only
    #     includes information about the blue/green deployments with the
    #     specified identifiers.
    #
    #   * `blue-green-deployment-name` - Accepts user-supplied names for
    #     blue/green deployments. The results list only includes information
    #     about the blue/green deployments with the specified names.
    #
    #   * `source` - Accepts source databases for a blue/green deployment. The
    #     results list only includes information about the blue/green
    #     deployments with the specified source databases.
    #
    #   * `target` - Accepts target databases for a blue/green deployment. The
    #     results list only includes information about the blue/green
    #     deployments with the specified target databases.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeBlueGreenDeployments` request. If you specify this parameter,
    #   the response only includes records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so you can retrieve
    #   the remaining results.
    #
    #   Default: 100
    #
    #   Constraints:
    #
    #   * Must be a minimum of 20.
    #
    #   * Can't exceed 100.
    #
    # @return [Types::DescribeBlueGreenDeploymentsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeBlueGreenDeploymentsResponse#blue_green_deployments #blue_green_deployments} => Array&lt;Types::BlueGreenDeployment&gt;
    #   * {Types::DescribeBlueGreenDeploymentsResponse#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe a blue/green deployment of an RDS DB instance after creation completes
    #
    #   # The following example retrieves the details of a blue/green deployment after creation completes.
    #
    #   resp = client.describe_blue_green_deployments({
    #     blue_green_deployment_identifier: "bgd-v53303651eexfake", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     blue_green_deployments: [
    #       {
    #         blue_green_deployment_identifier: "bgd-v53303651eexfake", 
    #         blue_green_deployment_name: "bgd-cli-test-instance", 
    #         create_time: Time.parse("2022-02-25T21:18:51.183000+00:00"), 
    #         source: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance", 
    #         status: "AVAILABLE", 
    #         switchover_details: [
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance", 
    #             status: "AVAILABLE", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-green-rkfbpe", 
    #           }, 
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-1", 
    #             status: "AVAILABLE", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-1-green-j382ha", 
    #           }, 
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-2", 
    #             status: "AVAILABLE", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-2-green-ejv4ao", 
    #           }, 
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-3", 
    #             status: "AVAILABLE", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-3-green-vlpz3t", 
    #           }, 
    #         ], 
    #         target: "arn:aws:rds:us-east-1:123456789012:db:my-db-instance-green-rkfbpe", 
    #         tasks: [
    #           {
    #             name: "CREATING_READ_REPLICA_OF_SOURCE", 
    #             status: "COMPLETED", 
    #           }, 
    #           {
    #             name: "DB_ENGINE_VERSION_UPGRADE", 
    #             status: "COMPLETED", 
    #           }, 
    #           {
    #             name: "CONFIGURE_BACKUPS", 
    #             status: "COMPLETED", 
    #           }, 
    #           {
    #             name: "CREATING_TOPOLOGY_OF_SOURCE", 
    #             status: "COMPLETED", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To describe a blue/green deployment for an Aurora MySQL DB cluster
    #
    #   # The following example retrieves the details of a blue/green deployment.
    #
    #   resp = client.describe_blue_green_deployments({
    #     blue_green_deployment_identifier: "bgd-wi89nwzglccsfake", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     blue_green_deployments: [
    #       {
    #         blue_green_deployment_identifier: "bgd-wi89nwzglccsfake", 
    #         blue_green_deployment_name: "my-blue-green-deployment", 
    #         create_time: Time.parse("2022-02-25T21:12:00.288000+00:00"), 
    #         source: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster", 
    #         status: "AVAILABLE", 
    #         switchover_details: [
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster", 
    #             status: "AVAILABLE", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-green-3rnukl", 
    #           }, 
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1", 
    #             status: "AVAILABLE", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1-green-gpmaxf", 
    #           }, 
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2", 
    #             status: "AVAILABLE", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2-green-j2oajq", 
    #           }, 
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3", 
    #             status: "AVAILABLE", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3-green-mkxies", 
    #           }, 
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint", 
    #             status: "AVAILABLE", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint-green-4sqjrq", 
    #           }, 
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint", 
    #             status: "AVAILABLE", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint-green-gwwzlg", 
    #           }, 
    #         ], 
    #         target: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-green-3rnukl", 
    #         tasks: [
    #           {
    #             name: "CREATING_READ_REPLICA_OF_SOURCE", 
    #             status: "COMPLETED", 
    #           }, 
    #           {
    #             name: "DB_ENGINE_VERSION_UPGRADE", 
    #             status: "COMPLETED", 
    #           }, 
    #           {
    #             name: "CREATE_DB_INSTANCES_FOR_CLUSTER", 
    #             status: "COMPLETED", 
    #           }, 
    #           {
    #             name: "CREATE_CUSTOM_ENDPOINTS", 
    #             status: "COMPLETED", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To describe a blue/green deployment for an Aurora MySQL cluster after switchover
    #
    #   # The following example retrieves the details about a blue/green deployment after the green environment is promoted to be
    #   # the production environment.
    #
    #   resp = client.describe_blue_green_deployments({
    #     blue_green_deployment_identifier: "bgd-wi89nwzglccsfake", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     blue_green_deployments: [
    #       {
    #         blue_green_deployment_identifier: "bgd-wi89nwzglccsfake", 
    #         blue_green_deployment_name: "my-blue-green-deployment", 
    #         create_time: Time.parse("2022-02-25T22:38:49.522000+00:00"), 
    #         source: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-old1", 
    #         status: "SWITCHOVER_COMPLETED", 
    #         switchover_details: [
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-old1", 
    #             status: "SWITCHOVER_COMPLETED", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster", 
    #           }, 
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1-old1", 
    #             status: "SWITCHOVER_COMPLETED", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1", 
    #           }, 
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2-old1", 
    #             status: "SWITCHOVER_COMPLETED", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2", 
    #           }, 
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3-old1", 
    #             status: "SWITCHOVER_COMPLETED", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3", 
    #           }, 
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint-old1", 
    #             status: "SWITCHOVER_COMPLETED", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint", 
    #           }, 
    #           {
    #             source_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint-old1", 
    #             status: "SWITCHOVER_COMPLETED", 
    #             target_member: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint", 
    #           }, 
    #         ], 
    #         target: "arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster", 
    #         tasks: [
    #           {
    #             name: "CREATING_READ_REPLICA_OF_SOURCE", 
    #             status: "COMPLETED", 
    #           }, 
    #           {
    #             name: "DB_ENGINE_VERSION_UPGRADE", 
    #             status: "COMPLETED", 
    #           }, 
    #           {
    #             name: "CREATE_DB_INSTANCES_FOR_CLUSTER", 
    #             status: "COMPLETED", 
    #           }, 
    #           {
    #             name: "CREATE_CUSTOM_ENDPOINTS", 
    #             status: "COMPLETED", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_blue_green_deployments({
    #     blue_green_deployment_identifier: "BlueGreenDeploymentIdentifier",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     marker: "String",
    #     max_records: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.blue_green_deployments #=> Array
    #   resp.blue_green_deployments[0].blue_green_deployment_identifier #=> String
    #   resp.blue_green_deployments[0].blue_green_deployment_name #=> String
    #   resp.blue_green_deployments[0].source #=> String
    #   resp.blue_green_deployments[0].target #=> String
    #   resp.blue_green_deployments[0].switchover_details #=> Array
    #   resp.blue_green_deployments[0].switchover_details[0].source_member #=> String
    #   resp.blue_green_deployments[0].switchover_details[0].target_member #=> String
    #   resp.blue_green_deployments[0].switchover_details[0].status #=> String
    #   resp.blue_green_deployments[0].tasks #=> Array
    #   resp.blue_green_deployments[0].tasks[0].name #=> String
    #   resp.blue_green_deployments[0].tasks[0].status #=> String
    #   resp.blue_green_deployments[0].status #=> String
    #   resp.blue_green_deployments[0].status_details #=> String
    #   resp.blue_green_deployments[0].create_time #=> Time
    #   resp.blue_green_deployments[0].delete_time #=> Time
    #   resp.blue_green_deployments[0].tag_list #=> Array
    #   resp.blue_green_deployments[0].tag_list[0].key #=> String
    #   resp.blue_green_deployments[0].tag_list[0].value #=> String
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeBlueGreenDeployments AWS API Documentation
    #
    # @overload describe_blue_green_deployments(params = {})
    # @param [Hash] params ({})
    def describe_blue_green_deployments(params = {}, options = {})
      req = build_request(:describe_blue_green_deployments, params)
      req.send_request(options)
    end

    # Lists the set of certificate authority (CA) certificates provided by
    # Amazon RDS for this Amazon Web Services account.
    #
    # For more information, see [Using SSL/TLS to encrypt a connection to a
    # DB instance][1] in the *Amazon RDS User Guide* and [ Using SSL/TLS to
    # encrypt a connection to a DB cluster][2] in the *Amazon Aurora User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html
    #
    # @option params [String] :certificate_identifier
    #   The user-supplied certificate identifier. If this parameter is
    #   specified, information for only the identified certificate is
    #   returned. This parameter isn't case-sensitive.
    #
    #   Constraints:
    #
    #   * Must match an existing CertificateIdentifier.
    #
    #   ^
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so you can retrieve
    #   the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeCertificates` request. If this parameter is specified, the
    #   response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @return [Types::CertificateMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CertificateMessage#default_certificate_for_new_launches #default_certificate_for_new_launches} => String
    #   * {Types::CertificateMessage#certificates #certificates} => Array&lt;Types::Certificate&gt;
    #   * {Types::CertificateMessage#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe certificates
    #
    #   # The following example retrieves the details of the certificate associated with the user's default region.
    #
    #   resp = client.describe_certificates({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     certificates: [
    #       {
    #         certificate_arn: "arn:aws:rds:us-east-1::cert:rds-ca-ecc384-g1", 
    #         certificate_identifier: "rds-ca-ecc384-g1", 
    #         certificate_type: "CA", 
    #         customer_override: false, 
    #         thumbprint: "24a97b91cbe86911190576c35c36aab4fEXAMPLE", 
    #         valid_from: Time.parse("2021-05-25T22:41:55+00:00"), 
    #         valid_till: Time.parse("2121-05-25T23:41:55+00:00"), 
    #       }, 
    #       {
    #         certificate_arn: "arn:aws:rds:us-east-1::cert:rds-ca-rsa4096-g1", 
    #         certificate_identifier: "rds-ca-rsa4096-g1", 
    #         certificate_type: "CA", 
    #         customer_override: false, 
    #         thumbprint: "9da6fa7fd2ec09c569a400d876b01b0c1EXAMPLE", 
    #         valid_from: Time.parse("2021-05-25T22:38:35+00:00"), 
    #         valid_till: Time.parse("2121-05-25T23:38:35+00:00"), 
    #       }, 
    #       {
    #         certificate_arn: "arn:aws:rds:us-east-1::cert:rds-ca-rsa2048-g1", 
    #         certificate_identifier: "rds-ca-rsa2048-g1", 
    #         certificate_type: "CA", 
    #         customer_override: true, 
    #         customer_override_valid_till: Time.parse("2061-05-25T23:34:57+00:00"), 
    #         thumbprint: "2fa77ef894d983ba9d37ad699c84ab0f6EXAMPLE", 
    #         valid_from: Time.parse("2021-05-25T22:34:57+00:00"), 
    #         valid_till: Time.parse("2061-05-25T23:34:57+00:00"), 
    #       }, 
    #       {
    #         certificate_arn: "arn:aws:rds:us-east-1::cert:rds-ca-2019", 
    #         certificate_identifier: "rds-ca-2019", 
    #         certificate_type: "CA", 
    #         customer_override: false, 
    #         thumbprint: "f0ed823ed14447bab557fdf3e49274669EXAMPLE", 
    #         valid_from: Time.parse("2019-09-19T18:16:53+00:00"), 
    #         valid_till: Time.parse("2024-08-22T17:08:50+00:00"), 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_certificates({
    #     certificate_identifier: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.default_certificate_for_new_launches #=> String
    #   resp.certificates #=> Array
    #   resp.certificates[0].certificate_identifier #=> String
    #   resp.certificates[0].certificate_type #=> String
    #   resp.certificates[0].thumbprint #=> String
    #   resp.certificates[0].valid_from #=> Time
    #   resp.certificates[0].valid_till #=> Time
    #   resp.certificates[0].certificate_arn #=> String
    #   resp.certificates[0].customer_override #=> Boolean
    #   resp.certificates[0].customer_override_valid_till #=> Time
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates AWS API Documentation
    #
    # @overload describe_certificates(params = {})
    # @param [Hash] params ({})
    def describe_certificates(params = {}, options = {})
      req = build_request(:describe_certificates, params)
      req.send_request(options)
    end

    # Displays backups for both current and deleted DB clusters. For
    # example, use this operation to find details about automated backups
    # for previously deleted clusters. Current clusters are returned for
    # both the `DescribeDBClusterAutomatedBackups` and `DescribeDBClusters`
    # operations.
    #
    # All parameters are optional.
    #
    # @option params [String] :db_cluster_resource_id
    #   The resource ID of the DB cluster that is the source of the automated
    #   backup. This parameter isn't case-sensitive.
    #
    # @option params [String] :db_cluster_identifier
    #   (Optional) The user-supplied DB cluster identifier. If this parameter
    #   is specified, it must match the identifier of an existing DB cluster.
    #   It returns information from the specific DB cluster's automated
    #   backup. This parameter isn't case-sensitive.
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies which resources to return based on status.
    #
    #   Supported filters are the following:
    #
    #   * `status`
    #
    #     * `retained` - Automated backups for deleted clusters and after
    #       backup replication is stopped.
    #
    #     ^
    #   * `db-cluster-id` - Accepts DB cluster identifiers and Amazon Resource
    #     Names (ARNs). The results list includes only information about the
    #     DB cluster automated backups identified by these ARNs.
    #
    #   * `db-cluster-resource-id` - Accepts DB resource identifiers and
    #     Amazon Resource Names (ARNs). The results list includes only
    #     information about the DB cluster resources identified by these ARNs.
    #
    #   Returns all resources by default. The status for each resource is
    #   specified in the response.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    # @option params [String] :marker
    #   The pagination token provided in the previous request. If this
    #   parameter is specified the response includes only records beyond the
    #   marker, up to `MaxRecords`.
    #
    # @return [Types::DBClusterAutomatedBackupMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBClusterAutomatedBackupMessage#marker #marker} => String
    #   * {Types::DBClusterAutomatedBackupMessage#db_cluster_automated_backups #db_cluster_automated_backups} => Array&lt;Types::DBClusterAutomatedBackup&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_cluster_automated_backups({
    #     db_cluster_resource_id: "String",
    #     db_cluster_identifier: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_cluster_automated_backups #=> Array
    #   resp.db_cluster_automated_backups[0].engine #=> String
    #   resp.db_cluster_automated_backups[0].vpc_id #=> String
    #   resp.db_cluster_automated_backups[0].db_cluster_automated_backups_arn #=> String
    #   resp.db_cluster_automated_backups[0].db_cluster_identifier #=> String
    #   resp.db_cluster_automated_backups[0].restore_window.earliest_time #=> Time
    #   resp.db_cluster_automated_backups[0].restore_window.latest_time #=> Time
    #   resp.db_cluster_automated_backups[0].master_username #=> String
    #   resp.db_cluster_automated_backups[0].db_cluster_resource_id #=> String
    #   resp.db_cluster_automated_backups[0].region #=> String
    #   resp.db_cluster_automated_backups[0].license_model #=> String
    #   resp.db_cluster_automated_backups[0].status #=> String
    #   resp.db_cluster_automated_backups[0].iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster_automated_backups[0].cluster_create_time #=> Time
    #   resp.db_cluster_automated_backups[0].storage_encrypted #=> Boolean
    #   resp.db_cluster_automated_backups[0].allocated_storage #=> Integer
    #   resp.db_cluster_automated_backups[0].engine_version #=> String
    #   resp.db_cluster_automated_backups[0].db_cluster_arn #=> String
    #   resp.db_cluster_automated_backups[0].backup_retention_period #=> Integer
    #   resp.db_cluster_automated_backups[0].engine_mode #=> String
    #   resp.db_cluster_automated_backups[0].availability_zones #=> Array
    #   resp.db_cluster_automated_backups[0].availability_zones[0] #=> String
    #   resp.db_cluster_automated_backups[0].port #=> Integer
    #   resp.db_cluster_automated_backups[0].kms_key_id #=> String
    #   resp.db_cluster_automated_backups[0].storage_type #=> String
    #   resp.db_cluster_automated_backups[0].iops #=> Integer
    #   resp.db_cluster_automated_backups[0].aws_backup_recovery_point_arn #=> String
    #   resp.db_cluster_automated_backups[0].storage_throughput #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterAutomatedBackups AWS API Documentation
    #
    # @overload describe_db_cluster_automated_backups(params = {})
    # @param [Hash] params ({})
    def describe_db_cluster_automated_backups(params = {}, options = {})
      req = build_request(:describe_db_cluster_automated_backups, params)
      req.send_request(options)
    end

    # Returns information about backtracks for a DB cluster.
    #
    # For more information on Amazon Aurora, see [ What is Amazon
    # Aurora?][1] in the *Amazon Aurora User Guide*.
    #
    # <note markdown="1"> This action only applies to Aurora MySQL DB clusters.
    #
    #  </note>
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    #
    # @option params [required, String] :db_cluster_identifier
    #   The DB cluster identifier of the DB cluster to be described. This
    #   parameter is stored as a lowercase string.
    #
    #   Constraints:
    #
    #   * Must contain from 1 to 63 alphanumeric characters or hyphens.
    #
    #   * First character must be a letter.
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens.
    #
    #   Example: `my-cluster1`
    #
    # @option params [String] :backtrack_identifier
    #   If specified, this value is the backtrack identifier of the backtrack
    #   to be described.
    #
    #   Constraints:
    #
    #   * Must contain a valid universally unique identifier (UUID). For more
    #     information about UUIDs, see [Universally unique identifier][1].
    #
    #   ^
    #
    #   Example: `123e4567-e89b-12d3-a456-426655440000`
    #
    #
    #
    #   [1]: https://en.wikipedia.org/wiki/Universally_unique_identifier
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more DB clusters to describe. Supported
    #   filters include the following:
    #
    #   * `db-cluster-backtrack-id` - Accepts backtrack identifiers. The
    #     results list includes information about only the backtracks
    #     identified by these identifiers.
    #
    #   * `db-cluster-backtrack-status` - Accepts any of the following
    #     backtrack status values:
    #
    #     * `applying`
    #
    #     * `completed`
    #
    #     * `failed`
    #
    #     * `pending`
    #     The results list includes information about only the backtracks
    #     identified by these values.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so you can retrieve
    #   the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBClusterBacktracks` request. If this parameter is specified,
    #   the response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @return [Types::DBClusterBacktrackMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBClusterBacktrackMessage#marker #marker} => String
    #   * {Types::DBClusterBacktrackMessage#db_cluster_backtracks #db_cluster_backtracks} => Array&lt;Types::DBClusterBacktrack&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe backtracks for a DB cluster
    #
    #   # The following example retrieves details about the specified DB cluster.
    #
    #   resp = client.describe_db_cluster_backtracks({
    #     db_cluster_identifier: "mydbcluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster_backtracks: [
    #       {
    #         backtrack_identifier: "2f5f5294-0dd2-44c9-9f50-EXAMPLE", 
    #         backtrack_request_creation_time: Time.parse("2021-02-12T14:36:18.819Z"), 
    #         backtrack_to: Time.parse("2021-02-12T04:59:22Z"), 
    #         backtracked_from: Time.parse("2021-02-12T14:37:31.640Z"), 
    #         db_cluster_identifier: "mydbcluster", 
    #         status: "COMPLETED", 
    #       }, 
    #       {
    #         backtrack_identifier: "3c7a6421-af2a-4ea3-ae95-EXAMPLE", 
    #         backtrack_request_creation_time: Time.parse("2021-02-12T00:07:53.487Z"), 
    #         backtrack_to: Time.parse("2021-02-11T22:53:46Z"), 
    #         backtracked_from: Time.parse("2021-02-12T00:09:27.006Z"), 
    #         db_cluster_identifier: "mydbcluster", 
    #         status: "COMPLETED", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_cluster_backtracks({
    #     db_cluster_identifier: "String", # required
    #     backtrack_identifier: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_cluster_backtracks #=> Array
    #   resp.db_cluster_backtracks[0].db_cluster_identifier #=> String
    #   resp.db_cluster_backtracks[0].backtrack_identifier #=> String
    #   resp.db_cluster_backtracks[0].backtrack_to #=> Time
    #   resp.db_cluster_backtracks[0].backtracked_from #=> Time
    #   resp.db_cluster_backtracks[0].backtrack_request_creation_time #=> Time
    #   resp.db_cluster_backtracks[0].status #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks AWS API Documentation
    #
    # @overload describe_db_cluster_backtracks(params = {})
    # @param [Hash] params ({})
    def describe_db_cluster_backtracks(params = {}, options = {})
      req = build_request(:describe_db_cluster_backtracks, params)
      req.send_request(options)
    end

    # Returns information about endpoints for an Amazon Aurora DB cluster.
    #
    # <note markdown="1"> This action only applies to Aurora DB clusters.
    #
    #  </note>
    #
    # @option params [String] :db_cluster_identifier
    #   The DB cluster identifier of the DB cluster associated with the
    #   endpoint. This parameter is stored as a lowercase string.
    #
    # @option params [String] :db_cluster_endpoint_identifier
    #   The identifier of the endpoint to describe. This parameter is stored
    #   as a lowercase string.
    #
    # @option params [Array<Types::Filter>] :filters
    #   A set of name-value pairs that define which endpoints to include in
    #   the output. The filters are specified as name-value pairs, in the
    #   format `Name=endpoint_type,Values=endpoint_type1,endpoint_type2,...`.
    #   `Name` can be one of: `db-cluster-endpoint-type`,
    #   `db-cluster-endpoint-custom-type`, `db-cluster-endpoint-id`,
    #   `db-cluster-endpoint-status`. `Values` for the `
    #   db-cluster-endpoint-type` filter can be one or more of: `reader`,
    #   `writer`, `custom`. `Values` for the `db-cluster-endpoint-custom-type`
    #   filter can be one or more of: `reader`, `any`. `Values` for the
    #   `db-cluster-endpoint-status` filter can be one or more of:
    #   `available`, `creating`, `deleting`, `inactive`, `modifying`.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so you can retrieve
    #   the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBClusterEndpoints` request. If this parameter is specified,
    #   the response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @return [Types::DBClusterEndpointMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBClusterEndpointMessage#marker #marker} => String
    #   * {Types::DBClusterEndpointMessage#db_cluster_endpoints #db_cluster_endpoints} => Array&lt;Types::DBClusterEndpoint&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe DB cluster endpoints
    #
    #   # The following example retrieves details for your DB cluster endpoints. The most common kinds of Aurora clusters have two
    #   # endpoints. One endpoint has type WRITER. You can use this endpoint for all SQL statements. The other endpoint has type
    #   # READER. You can use this endpoint only for SELECT and other read-only SQL statements.
    #
    #   resp = client.describe_db_cluster_endpoints({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster_endpoints: [
    #       {
    #         db_cluster_identifier: "my-database-1", 
    #         endpoint: "my-database-1.cluster-cnpexample.us-east-1.rds.amazonaws.com", 
    #         endpoint_type: "WRITER", 
    #         status: "creating", 
    #       }, 
    #       {
    #         db_cluster_identifier: "my-database-1", 
    #         endpoint: "my-database-1.cluster-ro-cnpexample.us-east-1.rds.amazonaws.com", 
    #         endpoint_type: "READER", 
    #         status: "creating", 
    #       }, 
    #       {
    #         db_cluster_identifier: "mydbcluster", 
    #         endpoint: "mydbcluster.cluster-cnpexamle.us-east-1.rds.amazonaws.com", 
    #         endpoint_type: "WRITER", 
    #         status: "available", 
    #       }, 
    #       {
    #         db_cluster_identifier: "mydbcluster", 
    #         endpoint: "mydbcluster.cluster-ro-cnpexample.us-east-1.rds.amazonaws.com", 
    #         endpoint_type: "READER", 
    #         status: "available", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To describe DB cluster endpoints of a single DB cluster
    #
    #   # The following example retrieves details for the DB cluster endpoints of a single specified DB cluster. Aurora Serverless
    #   # clusters have only a single endpoint with a type of WRITER.
    #
    #   resp = client.describe_db_cluster_endpoints({
    #     db_cluster_identifier: "serverless-cluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster_endpoints: [
    #       {
    #         db_cluster_identifier: "serverless-cluster", 
    #         endpoint: "serverless-cluster.cluster-cnpexample.us-east-1.rds.amazonaws.com", 
    #         endpoint_type: "WRITER", 
    #         status: "available", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_cluster_endpoints({
    #     db_cluster_identifier: "String",
    #     db_cluster_endpoint_identifier: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_cluster_endpoints #=> Array
    #   resp.db_cluster_endpoints[0].db_cluster_endpoint_identifier #=> String
    #   resp.db_cluster_endpoints[0].db_cluster_identifier #=> String
    #   resp.db_cluster_endpoints[0].db_cluster_endpoint_resource_identifier #=> String
    #   resp.db_cluster_endpoints[0].endpoint #=> String
    #   resp.db_cluster_endpoints[0].status #=> String
    #   resp.db_cluster_endpoints[0].endpoint_type #=> String
    #   resp.db_cluster_endpoints[0].custom_endpoint_type #=> String
    #   resp.db_cluster_endpoints[0].static_members #=> Array
    #   resp.db_cluster_endpoints[0].static_members[0] #=> String
    #   resp.db_cluster_endpoints[0].excluded_members #=> Array
    #   resp.db_cluster_endpoints[0].excluded_members[0] #=> String
    #   resp.db_cluster_endpoints[0].db_cluster_endpoint_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints AWS API Documentation
    #
    # @overload describe_db_cluster_endpoints(params = {})
    # @param [Hash] params ({})
    def describe_db_cluster_endpoints(params = {}, options = {})
      req = build_request(:describe_db_cluster_endpoints, params)
      req.send_request(options)
    end

    # Returns a list of `DBClusterParameterGroup` descriptions. If a
    # `DBClusterParameterGroupName` parameter is specified, the list will
    # contain only the description of the specified DB cluster parameter
    # group.
    #
    # For more information on Amazon Aurora, see [ What is Amazon
    # Aurora?][1] in the *Amazon Aurora User Guide*.
    #
    # For more information on Multi-AZ DB clusters, see [ Multi-AZ DB
    # cluster deployments][2] in the *Amazon RDS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [String] :db_cluster_parameter_group_name
    #   The name of a specific DB cluster parameter group to return details
    #   for.
    #
    #   Constraints:
    #
    #   * If supplied, must match the name of an existing
    #     DBClusterParameterGroup.
    #
    #   ^
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so you can retrieve
    #   the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBClusterParameterGroups` request. If this parameter is
    #   specified, the response includes only records beyond the marker, up to
    #   the value specified by `MaxRecords`.
    #
    # @return [Types::DBClusterParameterGroupsMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBClusterParameterGroupsMessage#marker #marker} => String
    #   * {Types::DBClusterParameterGroupsMessage#db_cluster_parameter_groups #db_cluster_parameter_groups} => Array&lt;Types::DBClusterParameterGroup&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe DB cluster parameter groups
    #
    #   # The following example retrieves details for your DB cluster parameter groups.
    #
    #   resp = client.describe_db_cluster_parameter_groups({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster_parameter_groups: [
    #       {
    #         db_cluster_parameter_group_arn: "arn:aws:rds:us-east-1:123456789012:cluster-pg:default.aurora-mysql5.7", 
    #         db_cluster_parameter_group_name: "default.aurora-mysql5.7", 
    #         db_parameter_group_family: "aurora-mysql5.7", 
    #         description: "Default cluster parameter group for aurora-mysql5.7", 
    #       }, 
    #       {
    #         db_cluster_parameter_group_arn: "arn:aws:rds:us-east-1:123456789012:cluster-pg:default.aurora-postgresql9.6", 
    #         db_cluster_parameter_group_name: "default.aurora-postgresql9.6", 
    #         db_parameter_group_family: "aurora-postgresql9.6", 
    #         description: "Default cluster parameter group for aurora-postgresql9.6", 
    #       }, 
    #       {
    #         db_cluster_parameter_group_arn: "arn:aws:rds:us-east-1:123456789012:cluster-pg:default.aurora5.6", 
    #         db_cluster_parameter_group_name: "default.aurora5.6", 
    #         db_parameter_group_family: "aurora5.6", 
    #         description: "Default cluster parameter group for aurora5.6", 
    #       }, 
    #       {
    #         db_cluster_parameter_group_arn: "arn:aws:rds:us-east-1:123456789012:cluster-pg:mydbclusterpg", 
    #         db_cluster_parameter_group_name: "mydbclusterpg", 
    #         db_parameter_group_family: "aurora-mysql5.7", 
    #         description: "My DB cluster parameter group", 
    #       }, 
    #       {
    #         db_cluster_parameter_group_arn: "arn:aws:rds:us-east-1:123456789012:cluster-pg:mydbclusterpgcopy", 
    #         db_cluster_parameter_group_name: "mydbclusterpgcopy", 
    #         db_parameter_group_family: "aurora-mysql5.7", 
    #         description: "Copy of mydbclusterpg parameter group", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_cluster_parameter_groups({
    #     db_cluster_parameter_group_name: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_cluster_parameter_groups #=> Array
    #   resp.db_cluster_parameter_groups[0].db_cluster_parameter_group_name #=> String
    #   resp.db_cluster_parameter_groups[0].db_parameter_group_family #=> String
    #   resp.db_cluster_parameter_groups[0].description #=> String
    #   resp.db_cluster_parameter_groups[0].db_cluster_parameter_group_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups AWS API Documentation
    #
    # @overload describe_db_cluster_parameter_groups(params = {})
    # @param [Hash] params ({})
    def describe_db_cluster_parameter_groups(params = {}, options = {})
      req = build_request(:describe_db_cluster_parameter_groups, params)
      req.send_request(options)
    end

    # Returns the detailed parameter list for a particular DB cluster
    # parameter group.
    #
    # For more information on Amazon Aurora, see [ What is Amazon
    # Aurora?][1] in the *Amazon Aurora User Guide*.
    #
    # For more information on Multi-AZ DB clusters, see [ Multi-AZ DB
    # cluster deployments][2] in the *Amazon RDS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [required, String] :db_cluster_parameter_group_name
    #   The name of a specific DB cluster parameter group to return parameter
    #   details for.
    #
    #   Constraints:
    #
    #   * If supplied, must match the name of an existing
    #     DBClusterParameterGroup.
    #
    #   ^
    #
    # @option params [String] :source
    #   A specific source to return parameters for.
    #
    #   Valid Values:
    #
    #   * `engine-default`
    #
    #   * `system`
    #
    #   * `user`
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more DB cluster parameters to describe.
    #
    #   The only supported filter is `parameter-name`. The results list only
    #   includes information about the DB cluster parameters with these names.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so you can retrieve
    #   the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBClusterParameters` request. If this parameter is specified,
    #   the response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @return [Types::DBClusterParameterGroupDetails] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBClusterParameterGroupDetails#parameters #parameters} => Array&lt;Types::Parameter&gt;
    #   * {Types::DBClusterParameterGroupDetails#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe the parameters in a DB cluster parameter group
    #
    #   # The following example retrieves details about the parameters in a DB cluster parameter group.
    #
    #   resp = client.describe_db_cluster_parameters({
    #     db_cluster_parameter_group_name: "mydbclusterpg", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     parameters: [
    #       {
    #         allowed_values: "0,1", 
    #         apply_method: "pending-reboot", 
    #         apply_type: "static", 
    #         data_type: "boolean", 
    #         description: "Controls whether user-defined functions that have only an xxx symbol for the main function can be loaded", 
    #         is_modifiable: false, 
    #         parameter_name: "allow-suspicious-udfs", 
    #         source: "engine-default", 
    #         supported_engine_modes: [
    #           "provisioned", 
    #         ], 
    #       }, 
    #       {
    #         allowed_values: "0,1", 
    #         apply_method: "pending-reboot", 
    #         apply_type: "static", 
    #         data_type: "boolean", 
    #         description: "Enables new features in the Aurora engine.", 
    #         is_modifiable: true, 
    #         parameter_name: "aurora_lab_mode", 
    #         parameter_value: "0", 
    #         source: "engine-default", 
    #         supported_engine_modes: [
    #           "provisioned", 
    #         ], 
    #       }, 
    #     ], # Some output ommitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_cluster_parameters({
    #     db_cluster_parameter_group_name: "String", # required
    #     source: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.parameters #=> Array
    #   resp.parameters[0].parameter_name #=> String
    #   resp.parameters[0].parameter_value #=> String
    #   resp.parameters[0].description #=> String
    #   resp.parameters[0].source #=> String
    #   resp.parameters[0].apply_type #=> String
    #   resp.parameters[0].data_type #=> String
    #   resp.parameters[0].allowed_values #=> String
    #   resp.parameters[0].is_modifiable #=> Boolean
    #   resp.parameters[0].minimum_engine_version #=> String
    #   resp.parameters[0].apply_method #=> String, one of "immediate", "pending-reboot"
    #   resp.parameters[0].supported_engine_modes #=> Array
    #   resp.parameters[0].supported_engine_modes[0] #=> String
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters AWS API Documentation
    #
    # @overload describe_db_cluster_parameters(params = {})
    # @param [Hash] params ({})
    def describe_db_cluster_parameters(params = {}, options = {})
      req = build_request(:describe_db_cluster_parameters, params)
      req.send_request(options)
    end

    # Returns a list of DB cluster snapshot attribute names and values for a
    # manual DB cluster snapshot.
    #
    # When sharing snapshots with other Amazon Web Services accounts,
    # `DescribeDBClusterSnapshotAttributes` returns the `restore` attribute
    # and a list of IDs for the Amazon Web Services accounts that are
    # authorized to copy or restore the manual DB cluster snapshot. If `all`
    # is included in the list of values for the `restore` attribute, then
    # the manual DB cluster snapshot is public and can be copied or restored
    # by all Amazon Web Services accounts.
    #
    # To add or remove access for an Amazon Web Services account to copy or
    # restore a manual DB cluster snapshot, or to make the manual DB cluster
    # snapshot public or private, use the `ModifyDBClusterSnapshotAttribute`
    # API action.
    #
    # @option params [required, String] :db_cluster_snapshot_identifier
    #   The identifier for the DB cluster snapshot to describe the attributes
    #   for.
    #
    # @return [Types::DescribeDBClusterSnapshotAttributesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeDBClusterSnapshotAttributesResult#db_cluster_snapshot_attributes_result #db_cluster_snapshot_attributes_result} => Types::DBClusterSnapshotAttributesResult
    #
    #
    # @example Example: To describe the attribute names and values for a DB cluster snapshot
    #
    #   # The following example retrieves details of the attribute names and values for the specified DB cluster snapshot.
    #
    #   resp = client.describe_db_cluster_snapshot_attributes({
    #     db_cluster_snapshot_identifier: "myclustersnapshot", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster_snapshot_attributes_result: {
    #       db_cluster_snapshot_attributes: [
    #         {
    #           attribute_name: "restore", 
    #           attribute_values: [
    #             "123456789012", 
    #           ], 
    #         }, 
    #       ], 
    #       db_cluster_snapshot_identifier: "myclustersnapshot", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_cluster_snapshot_attributes({
    #     db_cluster_snapshot_identifier: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_snapshot_attributes_result.db_cluster_snapshot_identifier #=> String
    #   resp.db_cluster_snapshot_attributes_result.db_cluster_snapshot_attributes #=> Array
    #   resp.db_cluster_snapshot_attributes_result.db_cluster_snapshot_attributes[0].attribute_name #=> String
    #   resp.db_cluster_snapshot_attributes_result.db_cluster_snapshot_attributes[0].attribute_values #=> Array
    #   resp.db_cluster_snapshot_attributes_result.db_cluster_snapshot_attributes[0].attribute_values[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributes AWS API Documentation
    #
    # @overload describe_db_cluster_snapshot_attributes(params = {})
    # @param [Hash] params ({})
    def describe_db_cluster_snapshot_attributes(params = {}, options = {})
      req = build_request(:describe_db_cluster_snapshot_attributes, params)
      req.send_request(options)
    end

    # Returns information about DB cluster snapshots. This API action
    # supports pagination.
    #
    # For more information on Amazon Aurora DB clusters, see [ What is
    # Amazon Aurora?][1] in the *Amazon Aurora User Guide*.
    #
    # For more information on Multi-AZ DB clusters, see [ Multi-AZ DB
    # cluster deployments][2] in the *Amazon RDS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [String] :db_cluster_identifier
    #   The ID of the DB cluster to retrieve the list of DB cluster snapshots
    #   for. This parameter can't be used in conjunction with the
    #   `DBClusterSnapshotIdentifier` parameter. This parameter isn't
    #   case-sensitive.
    #
    #   Constraints:
    #
    #   * If supplied, must match the identifier of an existing DBCluster.
    #
    #   ^
    #
    # @option params [String] :db_cluster_snapshot_identifier
    #   A specific DB cluster snapshot identifier to describe. This parameter
    #   can't be used in conjunction with the `DBClusterIdentifier`
    #   parameter. This value is stored as a lowercase string.
    #
    #   Constraints:
    #
    #   * If supplied, must match the identifier of an existing
    #     DBClusterSnapshot.
    #
    #   * If this identifier is for an automated snapshot, the `SnapshotType`
    #     parameter must also be specified.
    #
    # @option params [String] :snapshot_type
    #   The type of DB cluster snapshots to be returned. You can specify one
    #   of the following values:
    #
    #   * `automated` - Return all DB cluster snapshots that have been
    #     automatically taken by Amazon RDS for my Amazon Web Services
    #     account.
    #
    #   * `manual` - Return all DB cluster snapshots that have been taken by
    #     my Amazon Web Services account.
    #
    #   * `shared` - Return all manual DB cluster snapshots that have been
    #     shared to my Amazon Web Services account.
    #
    #   * `public` - Return all DB cluster snapshots that have been marked as
    #     public.
    #
    #   If you don't specify a `SnapshotType` value, then both automated and
    #   manual DB cluster snapshots are returned. You can include shared DB
    #   cluster snapshots with these results by enabling the `IncludeShared`
    #   parameter. You can include public DB cluster snapshots with these
    #   results by enabling the `IncludePublic` parameter.
    #
    #   The `IncludeShared` and `IncludePublic` parameters don't apply for
    #   `SnapshotType` values of `manual` or `automated`. The `IncludePublic`
    #   parameter doesn't apply when `SnapshotType` is set to `shared`. The
    #   `IncludeShared` parameter doesn't apply when `SnapshotType` is set to
    #   `public`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more DB cluster snapshots to describe.
    #
    #   Supported filters:
    #
    #   * `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
    #     Amazon Resource Names (ARNs).
    #
    #   * `db-cluster-snapshot-id` - Accepts DB cluster snapshot identifiers.
    #
    #   * `snapshot-type` - Accepts types of DB cluster snapshots.
    #
    #   * `engine` - Accepts names of database engines.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so you can retrieve
    #   the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBClusterSnapshots` request. If this parameter is specified,
    #   the response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @option params [Boolean] :include_shared
    #   Specifies whether to include shared manual DB cluster snapshots from
    #   other Amazon Web Services accounts that this Amazon Web Services
    #   account has been given permission to copy or restore. By default,
    #   these snapshots are not included.
    #
    #   You can give an Amazon Web Services account permission to restore a
    #   manual DB cluster snapshot from another Amazon Web Services account by
    #   the `ModifyDBClusterSnapshotAttribute` API action.
    #
    # @option params [Boolean] :include_public
    #   Specifies whether to include manual DB cluster snapshots that are
    #   public and can be copied or restored by any Amazon Web Services
    #   account. By default, the public snapshots are not included.
    #
    #   You can share a manual DB cluster snapshot as public by using the
    #   ModifyDBClusterSnapshotAttribute API action.
    #
    # @option params [String] :db_cluster_resource_id
    #   A specific DB cluster resource ID to describe.
    #
    # @return [Types::DBClusterSnapshotMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBClusterSnapshotMessage#marker #marker} => String
    #   * {Types::DBClusterSnapshotMessage#db_cluster_snapshots #db_cluster_snapshots} => Array&lt;Types::DBClusterSnapshot&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe a DB cluster snapshot for a DB cluster
    #
    #   # The following example retrieves the details for the DB cluster snapshots for the specified DB cluster.
    #
    #   resp = client.describe_db_cluster_snapshots({
    #     db_cluster_identifier: "mydbcluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster_snapshots: [
    #       {
    #         allocated_storage: 0, 
    #         availability_zones: [
    #           "us-east-1a", 
    #           "us-east-1b", 
    #           "us-east-1e", 
    #         ], 
    #         cluster_create_time: Time.parse("2019-04-15T14:18:42.785Z"), 
    #         db_cluster_identifier: "mydbcluster", 
    #         db_cluster_snapshot_arn: "arn:aws:rds:us-east-1:814387698303:cluster-snapshot:myclustersnapshotcopy", 
    #         db_cluster_snapshot_identifier: "myclustersnapshotcopy", 
    #         engine: "aurora-mysql", 
    #         engine_version: "5.7.mysql_aurora.2.04.2", 
    #         iam_database_authentication_enabled: false, 
    #         kms_key_id: "arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE", 
    #         license_model: "aurora-mysql", 
    #         master_username: "myadmin", 
    #         percent_progress: 100, 
    #         port: 0, 
    #         snapshot_create_time: Time.parse("2019-06-04T09:16:42.649Z"), 
    #         snapshot_type: "manual", 
    #         status: "available", 
    #         storage_encrypted: true, 
    #         vpc_id: "vpc-6594f31c", 
    #       }, 
    #       {
    #         allocated_storage: 0, 
    #         availability_zones: [
    #           "us-east-1a", 
    #           "us-east-1b", 
    #           "us-east-1e", 
    #         ], 
    #         cluster_create_time: Time.parse("2019-04-15T14:18:42.785Z"), 
    #         db_cluster_identifier: "mydbcluster", 
    #         db_cluster_snapshot_arn: "arn:aws:rds:us-east-1:123456789012:cluster-snapshot:rds:mydbcluster-2019-06-20-09-16", 
    #         db_cluster_snapshot_identifier: "rds:mydbcluster-2019-06-20-09-16", 
    #         engine: "aurora-mysql", 
    #         engine_version: "5.7.mysql_aurora.2.04.2", 
    #         iam_database_authentication_enabled: false, 
    #         kms_key_id: "arn:aws:kms:us-east-1:814387698303:key/AKIAIOSFODNN7EXAMPLE", 
    #         license_model: "aurora-mysql", 
    #         master_username: "myadmin", 
    #         percent_progress: 100, 
    #         port: 0, 
    #         snapshot_create_time: Time.parse("2019-06-20T09:16:26.569Z"), 
    #         snapshot_type: "automated", 
    #         status: "available", 
    #         storage_encrypted: true, 
    #         vpc_id: "vpc-6594f31c", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_cluster_snapshots({
    #     db_cluster_identifier: "String",
    #     db_cluster_snapshot_identifier: "String",
    #     snapshot_type: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #     include_shared: false,
    #     include_public: false,
    #     db_cluster_resource_id: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_cluster_snapshots #=> Array
    #   resp.db_cluster_snapshots[0].availability_zones #=> Array
    #   resp.db_cluster_snapshots[0].availability_zones[0] #=> String
    #   resp.db_cluster_snapshots[0].db_cluster_snapshot_identifier #=> String
    #   resp.db_cluster_snapshots[0].db_cluster_identifier #=> String
    #   resp.db_cluster_snapshots[0].snapshot_create_time #=> Time
    #   resp.db_cluster_snapshots[0].engine #=> String
    #   resp.db_cluster_snapshots[0].engine_mode #=> String
    #   resp.db_cluster_snapshots[0].allocated_storage #=> Integer
    #   resp.db_cluster_snapshots[0].status #=> String
    #   resp.db_cluster_snapshots[0].port #=> Integer
    #   resp.db_cluster_snapshots[0].vpc_id #=> String
    #   resp.db_cluster_snapshots[0].cluster_create_time #=> Time
    #   resp.db_cluster_snapshots[0].master_username #=> String
    #   resp.db_cluster_snapshots[0].engine_version #=> String
    #   resp.db_cluster_snapshots[0].license_model #=> String
    #   resp.db_cluster_snapshots[0].snapshot_type #=> String
    #   resp.db_cluster_snapshots[0].percent_progress #=> Integer
    #   resp.db_cluster_snapshots[0].storage_encrypted #=> Boolean
    #   resp.db_cluster_snapshots[0].kms_key_id #=> String
    #   resp.db_cluster_snapshots[0].db_cluster_snapshot_arn #=> String
    #   resp.db_cluster_snapshots[0].source_db_cluster_snapshot_arn #=> String
    #   resp.db_cluster_snapshots[0].iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster_snapshots[0].tag_list #=> Array
    #   resp.db_cluster_snapshots[0].tag_list[0].key #=> String
    #   resp.db_cluster_snapshots[0].tag_list[0].value #=> String
    #   resp.db_cluster_snapshots[0].db_system_id #=> String
    #   resp.db_cluster_snapshots[0].storage_type #=> String
    #   resp.db_cluster_snapshots[0].db_cluster_resource_id #=> String
    #   resp.db_cluster_snapshots[0].storage_throughput #=> Integer
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * db_cluster_snapshot_available
    #   * db_cluster_snapshot_deleted
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots AWS API Documentation
    #
    # @overload describe_db_cluster_snapshots(params = {})
    # @param [Hash] params ({})
    def describe_db_cluster_snapshots(params = {}, options = {})
      req = build_request(:describe_db_cluster_snapshots, params)
      req.send_request(options)
    end

    # Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters.
    # This API supports pagination.
    #
    # For more information on Amazon Aurora DB clusters, see [ What is
    # Amazon Aurora?][1] in the *Amazon Aurora User Guide*.
    #
    # For more information on Multi-AZ DB clusters, see [ Multi-AZ DB
    # cluster deployments][2] in the *Amazon RDS User Guide*.
    #
    # This operation can also return information for Amazon Neptune DB
    # instances and Amazon DocumentDB instances.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [String] :db_cluster_identifier
    #   The user-supplied DB cluster identifier or the Amazon Resource Name
    #   (ARN) of the DB cluster. If this parameter is specified, information
    #   for only the specific DB cluster is returned. This parameter isn't
    #   case-sensitive.
    #
    #   Constraints:
    #
    #   * If supplied, must match an existing DB cluster identifier.
    #
    #   ^
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more DB clusters to describe.
    #
    #   Supported Filters:
    #
    #   * `clone-group-id` - Accepts clone group identifiers. The results list
    #     only includes information about the DB clusters associated with
    #     these clone groups.
    #
    #   * `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
    #     Amazon Resource Names (ARNs). The results list only includes
    #     information about the DB clusters identified by these ARNs.
    #
    #   * `db-cluster-resource-id` - Accepts DB cluster resource identifiers.
    #     The results list will only include information about the DB clusters
    #     identified by these DB cluster resource identifiers.
    #
    #   * `domain` - Accepts Active Directory directory IDs. The results list
    #     only includes information about the DB clusters associated with
    #     these domains.
    #
    #   * `engine` - Accepts engine names. The results list only includes
    #     information about the DB clusters for these engines.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so you can retrieve
    #   the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBClusters` request. If this parameter is specified, the
    #   response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @option params [Boolean] :include_shared
    #   Specifies whether the output includes information about clusters
    #   shared from other Amazon Web Services accounts.
    #
    # @return [Types::DBClusterMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBClusterMessage#marker #marker} => String
    #   * {Types::DBClusterMessage#db_clusters #db_clusters} => Array&lt;Types::DBCluster&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe a DB cluster
    #
    #   # The following example retrieves the details of the specified DB cluster.
    #
    #   resp = client.describe_db_clusters({
    #     db_cluster_identifier: "mydbcluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_clusters: [
    #       {
    #         allocated_storage: 1, 
    #         associated_roles: [
    #         ], 
    #         availability_zones: [
    #           "us-east-1a", 
    #           "us-east-1b", 
    #           "us-east-1e", 
    #         ], 
    #         backup_retention_period: 1, 
    #         cluster_create_time: Time.parse("2019-04-15T14:18:42.785Z"), 
    #         db_cluster_arn: "arn:aws:rds:us-east-1:123456789012:cluster:mydbcluster", 
    #         db_cluster_identifier: "mydbcluster", 
    #         db_cluster_members: [
    #           {
    #             db_cluster_parameter_group_status: "in-sync", 
    #             db_instance_identifier: "dbinstance3", 
    #             is_cluster_writer: false, 
    #             promotion_tier: 1, 
    #           }, 
    #           {
    #             db_cluster_parameter_group_status: "in-sync", 
    #             db_instance_identifier: "dbinstance1", 
    #             is_cluster_writer: false, 
    #             promotion_tier: 1, 
    #           }, 
    #           {
    #             db_cluster_parameter_group_status: "in-sync", 
    #             db_instance_identifier: "dbinstance2", 
    #             is_cluster_writer: false, 
    #             promotion_tier: 1, 
    #           }, 
    #           {
    #             db_cluster_parameter_group_status: "in-sync", 
    #             db_instance_identifier: "mydbcluster", 
    #             is_cluster_writer: false, 
    #             promotion_tier: 1, 
    #           }, 
    #           {
    #             db_cluster_parameter_group_status: "in-sync", 
    #             db_instance_identifier: "mydbcluster-us-east-1b", 
    #             is_cluster_writer: false, 
    #             promotion_tier: 1, 
    #           }, 
    #           {
    #             db_cluster_parameter_group_status: "in-sync", 
    #             db_instance_identifier: "mydbcluster", 
    #             is_cluster_writer: true, 
    #             promotion_tier: 1, 
    #           }, 
    #         ], 
    #         db_cluster_parameter_group: "default.aurora-mysql5.7", 
    #         db_subnet_group: "default", 
    #         database_name: "mydbcluster", 
    #         db_cluster_resource_id: "cluster-AKIAIOSFODNN7EXAMPLE", 
    #         deletion_protection: false, 
    #         earliest_restorable_time: Time.parse("2019-06-19T09:16:28.210Z"), 
    #         endpoint: "mydbcluster.cluster-cnpexample.us-east-1.rds.amazonaws.com", 
    #         engine: "aurora-mysql", 
    #         engine_mode: "provisioned", 
    #         engine_version: "5.7.mysql_aurora.2.04.2", 
    #         hosted_zone_id: "Z2R2ITUGPM61AM", 
    #         http_endpoint_enabled: false, 
    #         iam_database_authentication_enabled: false, 
    #         kms_key_id: "arn:aws:kms:us-east-1:814387698303:key/AKIAIOSFODNN7EXAMPLE", 
    #         latest_restorable_time: Time.parse("2019-06-20T22:38:14.908Z"), 
    #         master_username: "myadmin", 
    #         multi_az: true, 
    #         port: 3306, 
    #         preferred_backup_window: "09:09-09:39", 
    #         preferred_maintenance_window: "sat:04:09-sat:04:39", 
    #         read_replica_identifiers: [
    #         ], 
    #         reader_endpoint: "mydbcluster.cluster-ro-cnpexample.us-east-1.rds.amazonaws.com", 
    #         status: "available", 
    #         storage_encrypted: true, 
    #         vpc_security_groups: [
    #           {
    #             status: "active", 
    #             vpc_security_group_id: "sg-0b9130572daf3dc16", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_clusters({
    #     db_cluster_identifier: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #     include_shared: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_clusters #=> Array
    #   resp.db_clusters[0].allocated_storage #=> Integer
    #   resp.db_clusters[0].availability_zones #=> Array
    #   resp.db_clusters[0].availability_zones[0] #=> String
    #   resp.db_clusters[0].backup_retention_period #=> Integer
    #   resp.db_clusters[0].character_set_name #=> String
    #   resp.db_clusters[0].database_name #=> String
    #   resp.db_clusters[0].db_cluster_identifier #=> String
    #   resp.db_clusters[0].db_cluster_parameter_group #=> String
    #   resp.db_clusters[0].db_subnet_group #=> String
    #   resp.db_clusters[0].status #=> String
    #   resp.db_clusters[0].automatic_restart_time #=> Time
    #   resp.db_clusters[0].percent_progress #=> String
    #   resp.db_clusters[0].earliest_restorable_time #=> Time
    #   resp.db_clusters[0].endpoint #=> String
    #   resp.db_clusters[0].reader_endpoint #=> String
    #   resp.db_clusters[0].custom_endpoints #=> Array
    #   resp.db_clusters[0].custom_endpoints[0] #=> String
    #   resp.db_clusters[0].multi_az #=> Boolean
    #   resp.db_clusters[0].engine #=> String
    #   resp.db_clusters[0].engine_version #=> String
    #   resp.db_clusters[0].latest_restorable_time #=> Time
    #   resp.db_clusters[0].port #=> Integer
    #   resp.db_clusters[0].master_username #=> String
    #   resp.db_clusters[0].db_cluster_option_group_memberships #=> Array
    #   resp.db_clusters[0].db_cluster_option_group_memberships[0].db_cluster_option_group_name #=> String
    #   resp.db_clusters[0].db_cluster_option_group_memberships[0].status #=> String
    #   resp.db_clusters[0].preferred_backup_window #=> String
    #   resp.db_clusters[0].preferred_maintenance_window #=> String
    #   resp.db_clusters[0].replication_source_identifier #=> String
    #   resp.db_clusters[0].read_replica_identifiers #=> Array
    #   resp.db_clusters[0].read_replica_identifiers[0] #=> String
    #   resp.db_clusters[0].status_infos #=> Array
    #   resp.db_clusters[0].status_infos[0].status_type #=> String
    #   resp.db_clusters[0].status_infos[0].normal #=> Boolean
    #   resp.db_clusters[0].status_infos[0].status #=> String
    #   resp.db_clusters[0].status_infos[0].message #=> String
    #   resp.db_clusters[0].db_cluster_members #=> Array
    #   resp.db_clusters[0].db_cluster_members[0].db_instance_identifier #=> String
    #   resp.db_clusters[0].db_cluster_members[0].is_cluster_writer #=> Boolean
    #   resp.db_clusters[0].db_cluster_members[0].db_cluster_parameter_group_status #=> String
    #   resp.db_clusters[0].db_cluster_members[0].promotion_tier #=> Integer
    #   resp.db_clusters[0].vpc_security_groups #=> Array
    #   resp.db_clusters[0].vpc_security_groups[0].vpc_security_group_id #=> String
    #   resp.db_clusters[0].vpc_security_groups[0].status #=> String
    #   resp.db_clusters[0].hosted_zone_id #=> String
    #   resp.db_clusters[0].storage_encrypted #=> Boolean
    #   resp.db_clusters[0].kms_key_id #=> String
    #   resp.db_clusters[0].db_cluster_resource_id #=> String
    #   resp.db_clusters[0].db_cluster_arn #=> String
    #   resp.db_clusters[0].associated_roles #=> Array
    #   resp.db_clusters[0].associated_roles[0].role_arn #=> String
    #   resp.db_clusters[0].associated_roles[0].status #=> String
    #   resp.db_clusters[0].associated_roles[0].feature_name #=> String
    #   resp.db_clusters[0].iam_database_authentication_enabled #=> Boolean
    #   resp.db_clusters[0].clone_group_id #=> String
    #   resp.db_clusters[0].cluster_create_time #=> Time
    #   resp.db_clusters[0].earliest_backtrack_time #=> Time
    #   resp.db_clusters[0].backtrack_window #=> Integer
    #   resp.db_clusters[0].backtrack_consumed_change_records #=> Integer
    #   resp.db_clusters[0].enabled_cloudwatch_logs_exports #=> Array
    #   resp.db_clusters[0].enabled_cloudwatch_logs_exports[0] #=> String
    #   resp.db_clusters[0].capacity #=> Integer
    #   resp.db_clusters[0].engine_mode #=> String
    #   resp.db_clusters[0].scaling_configuration_info.min_capacity #=> Integer
    #   resp.db_clusters[0].scaling_configuration_info.max_capacity #=> Integer
    #   resp.db_clusters[0].scaling_configuration_info.auto_pause #=> Boolean
    #   resp.db_clusters[0].scaling_configuration_info.seconds_until_auto_pause #=> Integer
    #   resp.db_clusters[0].scaling_configuration_info.timeout_action #=> String
    #   resp.db_clusters[0].scaling_configuration_info.seconds_before_timeout #=> Integer
    #   resp.db_clusters[0].rds_custom_cluster_configuration.interconnect_subnet_id #=> String
    #   resp.db_clusters[0].rds_custom_cluster_configuration.transit_gateway_multicast_domain_id #=> String
    #   resp.db_clusters[0].rds_custom_cluster_configuration.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_clusters[0].deletion_protection #=> Boolean
    #   resp.db_clusters[0].http_endpoint_enabled #=> Boolean
    #   resp.db_clusters[0].activity_stream_mode #=> String, one of "sync", "async"
    #   resp.db_clusters[0].activity_stream_status #=> String, one of "stopped", "starting", "started", "stopping"
    #   resp.db_clusters[0].activity_stream_kms_key_id #=> String
    #   resp.db_clusters[0].activity_stream_kinesis_stream_name #=> String
    #   resp.db_clusters[0].copy_tags_to_snapshot #=> Boolean
    #   resp.db_clusters[0].cross_account_clone #=> Boolean
    #   resp.db_clusters[0].domain_memberships #=> Array
    #   resp.db_clusters[0].domain_memberships[0].domain #=> String
    #   resp.db_clusters[0].domain_memberships[0].status #=> String
    #   resp.db_clusters[0].domain_memberships[0].fqdn #=> String
    #   resp.db_clusters[0].domain_memberships[0].iam_role_name #=> String
    #   resp.db_clusters[0].domain_memberships[0].ou #=> String
    #   resp.db_clusters[0].domain_memberships[0].auth_secret_arn #=> String
    #   resp.db_clusters[0].domain_memberships[0].dns_ips #=> Array
    #   resp.db_clusters[0].domain_memberships[0].dns_ips[0] #=> String
    #   resp.db_clusters[0].tag_list #=> Array
    #   resp.db_clusters[0].tag_list[0].key #=> String
    #   resp.db_clusters[0].tag_list[0].value #=> String
    #   resp.db_clusters[0].global_cluster_identifier #=> String
    #   resp.db_clusters[0].global_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "unknown"
    #   resp.db_clusters[0].global_write_forwarding_requested #=> Boolean
    #   resp.db_clusters[0].pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable #=> Array
    #   resp.db_clusters[0].pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable[0] #=> String
    #   resp.db_clusters[0].pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable #=> Array
    #   resp.db_clusters[0].pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable[0] #=> String
    #   resp.db_clusters[0].pending_modified_values.db_cluster_identifier #=> String
    #   resp.db_clusters[0].pending_modified_values.master_user_password #=> String
    #   resp.db_clusters[0].pending_modified_values.iam_database_authentication_enabled #=> Boolean
    #   resp.db_clusters[0].pending_modified_values.engine_version #=> String
    #   resp.db_clusters[0].pending_modified_values.backup_retention_period #=> Integer
    #   resp.db_clusters[0].pending_modified_values.allocated_storage #=> Integer
    #   resp.db_clusters[0].pending_modified_values.rds_custom_cluster_configuration.interconnect_subnet_id #=> String
    #   resp.db_clusters[0].pending_modified_values.rds_custom_cluster_configuration.transit_gateway_multicast_domain_id #=> String
    #   resp.db_clusters[0].pending_modified_values.rds_custom_cluster_configuration.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_clusters[0].pending_modified_values.iops #=> Integer
    #   resp.db_clusters[0].pending_modified_values.storage_type #=> String
    #   resp.db_clusters[0].pending_modified_values.certificate_details.ca_identifier #=> String
    #   resp.db_clusters[0].pending_modified_values.certificate_details.valid_till #=> Time
    #   resp.db_clusters[0].db_cluster_instance_class #=> String
    #   resp.db_clusters[0].storage_type #=> String
    #   resp.db_clusters[0].iops #=> Integer
    #   resp.db_clusters[0].publicly_accessible #=> Boolean
    #   resp.db_clusters[0].auto_minor_version_upgrade #=> Boolean
    #   resp.db_clusters[0].monitoring_interval #=> Integer
    #   resp.db_clusters[0].monitoring_role_arn #=> String
    #   resp.db_clusters[0].database_insights_mode #=> String, one of "standard", "advanced"
    #   resp.db_clusters[0].performance_insights_enabled #=> Boolean
    #   resp.db_clusters[0].performance_insights_kms_key_id #=> String
    #   resp.db_clusters[0].performance_insights_retention_period #=> Integer
    #   resp.db_clusters[0].serverless_v2_scaling_configuration.min_capacity #=> Float
    #   resp.db_clusters[0].serverless_v2_scaling_configuration.max_capacity #=> Float
    #   resp.db_clusters[0].serverless_v2_scaling_configuration.seconds_until_auto_pause #=> Integer
    #   resp.db_clusters[0].serverless_v2_platform_version #=> String
    #   resp.db_clusters[0].network_type #=> String
    #   resp.db_clusters[0].db_system_id #=> String
    #   resp.db_clusters[0].master_user_secret.secret_arn #=> String
    #   resp.db_clusters[0].master_user_secret.secret_status #=> String
    #   resp.db_clusters[0].master_user_secret.kms_key_id #=> String
    #   resp.db_clusters[0].io_optimized_next_allowed_modification_time #=> Time
    #   resp.db_clusters[0].local_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "requested"
    #   resp.db_clusters[0].aws_backup_recovery_point_arn #=> String
    #   resp.db_clusters[0].limitless_database.status #=> String, one of "active", "not-in-use", "enabled", "disabled", "enabling", "disabling", "modifying-max-capacity", "error"
    #   resp.db_clusters[0].limitless_database.min_required_acu #=> Float
    #   resp.db_clusters[0].storage_throughput #=> Integer
    #   resp.db_clusters[0].cluster_scalability_type #=> String, one of "standard", "limitless"
    #   resp.db_clusters[0].certificate_details.ca_identifier #=> String
    #   resp.db_clusters[0].certificate_details.valid_till #=> Time
    #   resp.db_clusters[0].engine_lifecycle_support #=> String
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * db_cluster_available
    #   * db_cluster_deleted
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters AWS API Documentation
    #
    # @overload describe_db_clusters(params = {})
    # @param [Hash] params ({})
    def describe_db_clusters(params = {}, options = {})
      req = build_request(:describe_db_clusters, params)
      req.send_request(options)
    end

    # Describes the properties of specific versions of DB engines.
    #
    # @option params [String] :engine
    #   The database engine to return version details for.
    #
    #   Valid Values:
    #
    #   * `aurora-mysql`
    #
    #   * `aurora-postgresql`
    #
    #   * `custom-oracle-ee`
    #
    #   * `custom-oracle-ee-cdb`
    #
    #   * `custom-oracle-se2`
    #
    #   * `custom-oracle-se2-cdb`
    #
    #   * `db2-ae`
    #
    #   * `db2-se`
    #
    #   * `mariadb`
    #
    #   * `mysql`
    #
    #   * `oracle-ee`
    #
    #   * `oracle-ee-cdb`
    #
    #   * `oracle-se2`
    #
    #   * `oracle-se2-cdb`
    #
    #   * `postgres`
    #
    #   * `sqlserver-ee`
    #
    #   * `sqlserver-se`
    #
    #   * `sqlserver-ex`
    #
    #   * `sqlserver-web`
    #
    # @option params [String] :engine_version
    #   A specific database engine version to return details for.
    #
    #   Example: `5.1.49`
    #
    # @option params [String] :db_parameter_group_family
    #   The name of a specific DB parameter group family to return details
    #   for.
    #
    #   Constraints:
    #
    #   * If supplied, must match an existing DB parameter group family.
    #
    #   ^
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more DB engine versions to describe.
    #
    #   Supported filters:
    #
    #   * `db-parameter-group-family` - Accepts parameter groups family names.
    #     The results list only includes information about the DB engine
    #     versions for these parameter group families.
    #
    #   * `engine` - Accepts engine names. The results list only includes
    #     information about the DB engine versions for these engines.
    #
    #   * `engine-mode` - Accepts DB engine modes. The results list only
    #     includes information about the DB engine versions for these engine
    #     modes. Valid DB engine modes are the following:
    #
    #     * `global`
    #
    #     * `multimaster`
    #
    #     * `parallelquery`
    #
    #     * `provisioned`
    #
    #     * `serverless`
    #   * `engine-version` - Accepts engine versions. The results list only
    #     includes information about the DB engine versions for these engine
    #     versions.
    #
    #   * `status` - Accepts engine version statuses. The results list only
    #     includes information about the DB engine versions for these
    #     statuses. Valid statuses are the following:
    #
    #     * `available`
    #
    #     * `deprecated`
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more than
    #   the `MaxRecords` value is available, a pagination token called a
    #   marker is included in the response so you can retrieve the remaining
    #   results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous request. If this
    #   parameter is specified, the response includes only records beyond the
    #   marker, up to the value specified by `MaxRecords`.
    #
    # @option params [Boolean] :default_only
    #   Specifies whether to return only the default version of the specified
    #   engine or the engine and major version combination.
    #
    # @option params [Boolean] :list_supported_character_sets
    #   Specifies whether to list the supported character sets for each engine
    #   version.
    #
    #   If this parameter is enabled and the requested engine supports the
    #   `CharacterSetName` parameter for `CreateDBInstance`, the response
    #   includes a list of supported character sets for each engine version.
    #
    #   For RDS Custom, the default is not to list supported character sets.
    #   If you enable this parameter, RDS Custom returns no results.
    #
    # @option params [Boolean] :list_supported_timezones
    #   Specifies whether to list the supported time zones for each engine
    #   version.
    #
    #   If this parameter is enabled and the requested engine supports the
    #   `TimeZone` parameter for `CreateDBInstance`, the response includes a
    #   list of supported time zones for each engine version.
    #
    #   For RDS Custom, the default is not to list supported time zones. If
    #   you enable this parameter, RDS Custom returns no results.
    #
    # @option params [Boolean] :include_all
    #   Specifies whether to also list the engine versions that aren't
    #   available. The default is to list only available engine versions.
    #
    # @return [Types::DBEngineVersionMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBEngineVersionMessage#marker #marker} => String
    #   * {Types::DBEngineVersionMessage#db_engine_versions #db_engine_versions} => Array&lt;Types::DBEngineVersion&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe the DB engine versions for the MySQL DB engine
    #
    #   # The following example displays details about each of the DB engine versions for the specified DB engine.
    #
    #   resp = client.describe_db_engine_versions({
    #     engine: "mysql", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_engine_versions: [
    #       {
    #         db_engine_description: "MySQL Community Edition", 
    #         db_engine_version_description: "MySQL 5.7.33", 
    #         db_parameter_group_family: "mysql5.7", 
    #         engine: "mysql", 
    #         engine_version: "5.7.33", 
    #         valid_upgrade_target: [
    #           {
    #             auto_upgrade: false, 
    #             description: "MySQL 5.7.34", 
    #             engine: "mysql", 
    #             engine_version: "5.7.34", 
    #             is_major_version_upgrade: false, 
    #           }, 
    #           {
    #             auto_upgrade: false, 
    #             description: "MySQL 5.7.36", 
    #             engine: "mysql", 
    #             engine_version: "5.7.36", 
    #             is_major_version_upgrade: false, 
    #           }, 
    #         ], 
    #       }, 
    #     ], # Some output ommitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_engine_versions({
    #     engine: "String",
    #     engine_version: "String",
    #     db_parameter_group_family: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #     default_only: false,
    #     list_supported_character_sets: false,
    #     list_supported_timezones: false,
    #     include_all: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_engine_versions #=> Array
    #   resp.db_engine_versions[0].engine #=> String
    #   resp.db_engine_versions[0].engine_version #=> String
    #   resp.db_engine_versions[0].db_parameter_group_family #=> String
    #   resp.db_engine_versions[0].db_engine_description #=> String
    #   resp.db_engine_versions[0].db_engine_version_description #=> String
    #   resp.db_engine_versions[0].default_character_set.character_set_name #=> String
    #   resp.db_engine_versions[0].default_character_set.character_set_description #=> String
    #   resp.db_engine_versions[0].image.image_id #=> String
    #   resp.db_engine_versions[0].image.status #=> String
    #   resp.db_engine_versions[0].db_engine_media_type #=> String
    #   resp.db_engine_versions[0].supported_character_sets #=> Array
    #   resp.db_engine_versions[0].supported_character_sets[0].character_set_name #=> String
    #   resp.db_engine_versions[0].supported_character_sets[0].character_set_description #=> String
    #   resp.db_engine_versions[0].supported_nchar_character_sets #=> Array
    #   resp.db_engine_versions[0].supported_nchar_character_sets[0].character_set_name #=> String
    #   resp.db_engine_versions[0].supported_nchar_character_sets[0].character_set_description #=> String
    #   resp.db_engine_versions[0].valid_upgrade_target #=> Array
    #   resp.db_engine_versions[0].valid_upgrade_target[0].engine #=> String
    #   resp.db_engine_versions[0].valid_upgrade_target[0].engine_version #=> String
    #   resp.db_engine_versions[0].valid_upgrade_target[0].description #=> String
    #   resp.db_engine_versions[0].valid_upgrade_target[0].auto_upgrade #=> Boolean
    #   resp.db_engine_versions[0].valid_upgrade_target[0].is_major_version_upgrade #=> Boolean
    #   resp.db_engine_versions[0].valid_upgrade_target[0].supported_engine_modes #=> Array
    #   resp.db_engine_versions[0].valid_upgrade_target[0].supported_engine_modes[0] #=> String
    #   resp.db_engine_versions[0].valid_upgrade_target[0].supports_parallel_query #=> Boolean
    #   resp.db_engine_versions[0].valid_upgrade_target[0].supports_global_databases #=> Boolean
    #   resp.db_engine_versions[0].valid_upgrade_target[0].supports_babelfish #=> Boolean
    #   resp.db_engine_versions[0].valid_upgrade_target[0].supports_limitless_database #=> Boolean
    #   resp.db_engine_versions[0].valid_upgrade_target[0].supports_local_write_forwarding #=> Boolean
    #   resp.db_engine_versions[0].valid_upgrade_target[0].supports_integrations #=> Boolean
    #   resp.db_engine_versions[0].supported_timezones #=> Array
    #   resp.db_engine_versions[0].supported_timezones[0].timezone_name #=> String
    #   resp.db_engine_versions[0].exportable_log_types #=> Array
    #   resp.db_engine_versions[0].exportable_log_types[0] #=> String
    #   resp.db_engine_versions[0].supports_log_exports_to_cloudwatch_logs #=> Boolean
    #   resp.db_engine_versions[0].supports_read_replica #=> Boolean
    #   resp.db_engine_versions[0].supported_engine_modes #=> Array
    #   resp.db_engine_versions[0].supported_engine_modes[0] #=> String
    #   resp.db_engine_versions[0].supported_feature_names #=> Array
    #   resp.db_engine_versions[0].supported_feature_names[0] #=> String
    #   resp.db_engine_versions[0].status #=> String
    #   resp.db_engine_versions[0].supports_parallel_query #=> Boolean
    #   resp.db_engine_versions[0].supports_global_databases #=> Boolean
    #   resp.db_engine_versions[0].major_engine_version #=> String
    #   resp.db_engine_versions[0].database_installation_files_s3_bucket_name #=> String
    #   resp.db_engine_versions[0].database_installation_files_s3_prefix #=> String
    #   resp.db_engine_versions[0].db_engine_version_arn #=> String
    #   resp.db_engine_versions[0].kms_key_id #=> String
    #   resp.db_engine_versions[0].create_time #=> Time
    #   resp.db_engine_versions[0].tag_list #=> Array
    #   resp.db_engine_versions[0].tag_list[0].key #=> String
    #   resp.db_engine_versions[0].tag_list[0].value #=> String
    #   resp.db_engine_versions[0].supports_babelfish #=> Boolean
    #   resp.db_engine_versions[0].custom_db_engine_version_manifest #=> String
    #   resp.db_engine_versions[0].supports_limitless_database #=> Boolean
    #   resp.db_engine_versions[0].supports_certificate_rotation_without_restart #=> Boolean
    #   resp.db_engine_versions[0].supported_ca_certificate_identifiers #=> Array
    #   resp.db_engine_versions[0].supported_ca_certificate_identifiers[0] #=> String
    #   resp.db_engine_versions[0].supports_local_write_forwarding #=> Boolean
    #   resp.db_engine_versions[0].supports_integrations #=> Boolean
    #   resp.db_engine_versions[0].serverless_v2_features_support.min_capacity #=> Float
    #   resp.db_engine_versions[0].serverless_v2_features_support.max_capacity #=> Float
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions AWS API Documentation
    #
    # @overload describe_db_engine_versions(params = {})
    # @param [Hash] params ({})
    def describe_db_engine_versions(params = {}, options = {})
      req = build_request(:describe_db_engine_versions, params)
      req.send_request(options)
    end

    # Displays backups for both current and deleted instances. For example,
    # use this operation to find details about automated backups for
    # previously deleted instances. Current instances with retention periods
    # greater than zero (0) are returned for both the
    # `DescribeDBInstanceAutomatedBackups` and `DescribeDBInstances`
    # operations.
    #
    # All parameters are optional.
    #
    # @option params [String] :dbi_resource_id
    #   The resource ID of the DB instance that is the source of the automated
    #   backup. This parameter isn't case-sensitive.
    #
    # @option params [String] :db_instance_identifier
    #   (Optional) The user-supplied instance identifier. If this parameter is
    #   specified, it must match the identifier of an existing DB instance. It
    #   returns information from the specific DB instance's automated backup.
    #   This parameter isn't case-sensitive.
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies which resources to return based on status.
    #
    #   Supported filters are the following:
    #
    #   * `status`
    #
    #     * `active` - Automated backups for current instances.
    #
    #     * `creating` - Automated backups that are waiting for the first
    #       automated snapshot to be available.
    #
    #     * `retained` - Automated backups for deleted instances and after
    #       backup replication is stopped.
    #   * `db-instance-id` - Accepts DB instance identifiers and Amazon
    #     Resource Names (ARNs). The results list includes only information
    #     about the DB instance automated backups identified by these ARNs.
    #
    #   * `dbi-resource-id` - Accepts DB resource identifiers and Amazon
    #     Resource Names (ARNs). The results list includes only information
    #     about the DB instance resources identified by these ARNs.
    #
    #   Returns all resources by default. The status for each resource is
    #   specified in the response.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    # @option params [String] :marker
    #   The pagination token provided in the previous request. If this
    #   parameter is specified the response includes only records beyond the
    #   marker, up to `MaxRecords`.
    #
    # @option params [String] :db_instance_automated_backups_arn
    #   The Amazon Resource Name (ARN) of the replicated automated backups,
    #   for example,
    #   `arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE`.
    #
    #   This setting doesn't apply to RDS Custom.
    #
    # @return [Types::DBInstanceAutomatedBackupMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBInstanceAutomatedBackupMessage#marker #marker} => String
    #   * {Types::DBInstanceAutomatedBackupMessage#db_instance_automated_backups #db_instance_automated_backups} => Array&lt;Types::DBInstanceAutomatedBackup&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe the automated backups for a DB instance
    #
    #   # The following example displays details about the automated backups for the specified DB instance. The details include
    #   # replicated automated backups in other AWS Regions.
    #
    #   resp = client.describe_db_instance_automated_backups({
    #     db_instance_identifier: "new-orcl-db", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_instance_automated_backups: [
    #       {
    #         allocated_storage: 20, 
    #         backup_retention_period: 14, 
    #         db_instance_arn: "arn:aws:rds:us-east-1:123456789012:db:new-orcl-db", 
    #         db_instance_automated_backups_arn: "arn:aws:rds:us-west-2:123456789012:auto-backup:ab-jkib2gfq5rv7replzadausbrktni2bn4example", 
    #         db_instance_identifier: "new-orcl-db", 
    #         dbi_resource_id: "db-JKIB2GFQ5RV7REPLZA4EXAMPLE", 
    #         encrypted: false, 
    #         engine: "oracle-se2", 
    #         engine_version: "12.1.0.2.v21", 
    #         iam_database_authentication_enabled: false, 
    #         instance_create_time: Time.parse("2020-12-04T15:28:31Z"), 
    #         license_model: "bring-your-own-license", 
    #         master_username: "admin", 
    #         option_group_name: "default:oracle-se2-12-1", 
    #         port: 1521, 
    #         region: "us-east-1", 
    #         restore_window: {
    #           earliest_time: Time.parse("2020-12-07T21:05:20.939Z"), 
    #           latest_time: Time.parse("2020-12-07T21:05:20.939Z"), 
    #         }, 
    #         status: "replicating", 
    #         storage_type: "gp2", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_instance_automated_backups({
    #     dbi_resource_id: "String",
    #     db_instance_identifier: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #     db_instance_automated_backups_arn: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_instance_automated_backups #=> Array
    #   resp.db_instance_automated_backups[0].db_instance_arn #=> String
    #   resp.db_instance_automated_backups[0].dbi_resource_id #=> String
    #   resp.db_instance_automated_backups[0].region #=> String
    #   resp.db_instance_automated_backups[0].db_instance_identifier #=> String
    #   resp.db_instance_automated_backups[0].restore_window.earliest_time #=> Time
    #   resp.db_instance_automated_backups[0].restore_window.latest_time #=> Time
    #   resp.db_instance_automated_backups[0].allocated_storage #=> Integer
    #   resp.db_instance_automated_backups[0].status #=> String
    #   resp.db_instance_automated_backups[0].port #=> Integer
    #   resp.db_instance_automated_backups[0].availability_zone #=> String
    #   resp.db_instance_automated_backups[0].vpc_id #=> String
    #   resp.db_instance_automated_backups[0].instance_create_time #=> Time
    #   resp.db_instance_automated_backups[0].master_username #=> String
    #   resp.db_instance_automated_backups[0].engine #=> String
    #   resp.db_instance_automated_backups[0].engine_version #=> String
    #   resp.db_instance_automated_backups[0].license_model #=> String
    #   resp.db_instance_automated_backups[0].iops #=> Integer
    #   resp.db_instance_automated_backups[0].option_group_name #=> String
    #   resp.db_instance_automated_backups[0].tde_credential_arn #=> String
    #   resp.db_instance_automated_backups[0].encrypted #=> Boolean
    #   resp.db_instance_automated_backups[0].storage_type #=> String
    #   resp.db_instance_automated_backups[0].kms_key_id #=> String
    #   resp.db_instance_automated_backups[0].timezone #=> String
    #   resp.db_instance_automated_backups[0].iam_database_authentication_enabled #=> Boolean
    #   resp.db_instance_automated_backups[0].backup_retention_period #=> Integer
    #   resp.db_instance_automated_backups[0].db_instance_automated_backups_arn #=> String
    #   resp.db_instance_automated_backups[0].db_instance_automated_backups_replications #=> Array
    #   resp.db_instance_automated_backups[0].db_instance_automated_backups_replications[0].db_instance_automated_backups_arn #=> String
    #   resp.db_instance_automated_backups[0].backup_target #=> String
    #   resp.db_instance_automated_backups[0].storage_throughput #=> Integer
    #   resp.db_instance_automated_backups[0].aws_backup_recovery_point_arn #=> String
    #   resp.db_instance_automated_backups[0].dedicated_log_volume #=> Boolean
    #   resp.db_instance_automated_backups[0].multi_tenant #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups AWS API Documentation
    #
    # @overload describe_db_instance_automated_backups(params = {})
    # @param [Hash] params ({})
    def describe_db_instance_automated_backups(params = {}, options = {})
      req = build_request(:describe_db_instance_automated_backups, params)
      req.send_request(options)
    end

    # Describes provisioned RDS instances. This API supports pagination.
    #
    # <note markdown="1"> This operation can also return information for Amazon Neptune DB
    # instances and Amazon DocumentDB instances.
    #
    #  </note>
    #
    # @option params [String] :db_instance_identifier
    #   The user-supplied instance identifier or the Amazon Resource Name
    #   (ARN) of the DB instance. If this parameter is specified, information
    #   from only the specific DB instance is returned. This parameter isn't
    #   case-sensitive.
    #
    #   Constraints:
    #
    #   * If supplied, must match the identifier of an existing DB instance.
    #
    #   ^
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more DB instances to describe.
    #
    #   Supported Filters:
    #
    #   * `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
    #     Amazon Resource Names (ARNs). The results list only includes
    #     information about the DB instances associated with the DB clusters
    #     identified by these ARNs.
    #
    #   * `db-instance-id` - Accepts DB instance identifiers and DB instance
    #     Amazon Resource Names (ARNs). The results list only includes
    #     information about the DB instances identified by these ARNs.
    #
    #   * `dbi-resource-id` - Accepts DB instance resource identifiers. The
    #     results list only includes information about the DB instances
    #     identified by these DB instance resource identifiers.
    #
    #   * `domain` - Accepts Active Directory directory IDs. The results list
    #     only includes information about the DB instances associated with
    #     these domains.
    #
    #   * `engine` - Accepts engine names. The results list only includes
    #     information about the DB instances for these engines.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBInstances` request. If this parameter is specified, the
    #   response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @return [Types::DBInstanceMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBInstanceMessage#marker #marker} => String
    #   * {Types::DBInstanceMessage#db_instances #db_instances} => Array&lt;Types::DBInstance&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe a DB instance
    #
    #   # The following example retrieves details about the specified DB instance.
    #
    #   resp = client.describe_db_instances({
    #     db_instance_identifier: "mydbinstancecf", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_instances: [
    #       {
    #         db_instance_class: "db.t3.small", 
    #         db_instance_identifier: "mydbinstancecf", 
    #         db_instance_status: "available", 
    #         endpoint: {
    #           address: "mydbinstancecf.abcexample.us-east-1.rds.amazonaws.com", 
    #           hosted_zone_id: "Z2R2ITUGPM61AM", 
    #           port: 3306, 
    #         }, 
    #         engine: "mysql", 
    #         master_username: "admin", 
    #       }, 
    #     ], # Some output ommitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_instances({
    #     db_instance_identifier: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_instances #=> Array
    #   resp.db_instances[0].db_instance_identifier #=> String
    #   resp.db_instances[0].db_instance_class #=> String
    #   resp.db_instances[0].engine #=> String
    #   resp.db_instances[0].db_instance_status #=> String
    #   resp.db_instances[0].automatic_restart_time #=> Time
    #   resp.db_instances[0].master_username #=> String
    #   resp.db_instances[0].db_name #=> String
    #   resp.db_instances[0].endpoint.address #=> String
    #   resp.db_instances[0].endpoint.port #=> Integer
    #   resp.db_instances[0].endpoint.hosted_zone_id #=> String
    #   resp.db_instances[0].allocated_storage #=> Integer
    #   resp.db_instances[0].instance_create_time #=> Time
    #   resp.db_instances[0].preferred_backup_window #=> String
    #   resp.db_instances[0].backup_retention_period #=> Integer
    #   resp.db_instances[0].db_security_groups #=> Array
    #   resp.db_instances[0].db_security_groups[0].db_security_group_name #=> String
    #   resp.db_instances[0].db_security_groups[0].status #=> String
    #   resp.db_instances[0].vpc_security_groups #=> Array
    #   resp.db_instances[0].vpc_security_groups[0].vpc_security_group_id #=> String
    #   resp.db_instances[0].vpc_security_groups[0].status #=> String
    #   resp.db_instances[0].db_parameter_groups #=> Array
    #   resp.db_instances[0].db_parameter_groups[0].db_parameter_group_name #=> String
    #   resp.db_instances[0].db_parameter_groups[0].parameter_apply_status #=> String
    #   resp.db_instances[0].availability_zone #=> String
    #   resp.db_instances[0].db_subnet_group.db_subnet_group_name #=> String
    #   resp.db_instances[0].db_subnet_group.db_subnet_group_description #=> String
    #   resp.db_instances[0].db_subnet_group.vpc_id #=> String
    #   resp.db_instances[0].db_subnet_group.subnet_group_status #=> String
    #   resp.db_instances[0].db_subnet_group.subnets #=> Array
    #   resp.db_instances[0].db_subnet_group.subnets[0].subnet_identifier #=> String
    #   resp.db_instances[0].db_subnet_group.subnets[0].subnet_availability_zone.name #=> String
    #   resp.db_instances[0].db_subnet_group.subnets[0].subnet_outpost.arn #=> String
    #   resp.db_instances[0].db_subnet_group.subnets[0].subnet_status #=> String
    #   resp.db_instances[0].db_subnet_group.db_subnet_group_arn #=> String
    #   resp.db_instances[0].db_subnet_group.supported_network_types #=> Array
    #   resp.db_instances[0].db_subnet_group.supported_network_types[0] #=> String
    #   resp.db_instances[0].preferred_maintenance_window #=> String
    #   resp.db_instances[0].pending_modified_values.db_instance_class #=> String
    #   resp.db_instances[0].pending_modified_values.allocated_storage #=> Integer
    #   resp.db_instances[0].pending_modified_values.master_user_password #=> String
    #   resp.db_instances[0].pending_modified_values.port #=> Integer
    #   resp.db_instances[0].pending_modified_values.backup_retention_period #=> Integer
    #   resp.db_instances[0].pending_modified_values.multi_az #=> Boolean
    #   resp.db_instances[0].pending_modified_values.engine_version #=> String
    #   resp.db_instances[0].pending_modified_values.license_model #=> String
    #   resp.db_instances[0].pending_modified_values.iops #=> Integer
    #   resp.db_instances[0].pending_modified_values.db_instance_identifier #=> String
    #   resp.db_instances[0].pending_modified_values.storage_type #=> String
    #   resp.db_instances[0].pending_modified_values.ca_certificate_identifier #=> String
    #   resp.db_instances[0].pending_modified_values.db_subnet_group_name #=> String
    #   resp.db_instances[0].pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable #=> Array
    #   resp.db_instances[0].pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable[0] #=> String
    #   resp.db_instances[0].pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable #=> Array
    #   resp.db_instances[0].pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable[0] #=> String
    #   resp.db_instances[0].pending_modified_values.processor_features #=> Array
    #   resp.db_instances[0].pending_modified_values.processor_features[0].name #=> String
    #   resp.db_instances[0].pending_modified_values.processor_features[0].value #=> String
    #   resp.db_instances[0].pending_modified_values.iam_database_authentication_enabled #=> Boolean
    #   resp.db_instances[0].pending_modified_values.automation_mode #=> String, one of "full", "all-paused"
    #   resp.db_instances[0].pending_modified_values.resume_full_automation_mode_time #=> Time
    #   resp.db_instances[0].pending_modified_values.storage_throughput #=> Integer
    #   resp.db_instances[0].pending_modified_values.engine #=> String
    #   resp.db_instances[0].pending_modified_values.dedicated_log_volume #=> Boolean
    #   resp.db_instances[0].pending_modified_values.multi_tenant #=> Boolean
    #   resp.db_instances[0].latest_restorable_time #=> Time
    #   resp.db_instances[0].multi_az #=> Boolean
    #   resp.db_instances[0].engine_version #=> String
    #   resp.db_instances[0].auto_minor_version_upgrade #=> Boolean
    #   resp.db_instances[0].read_replica_source_db_instance_identifier #=> String
    #   resp.db_instances[0].read_replica_db_instance_identifiers #=> Array
    #   resp.db_instances[0].read_replica_db_instance_identifiers[0] #=> String
    #   resp.db_instances[0].read_replica_db_cluster_identifiers #=> Array
    #   resp.db_instances[0].read_replica_db_cluster_identifiers[0] #=> String
    #   resp.db_instances[0].replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_instances[0].license_model #=> String
    #   resp.db_instances[0].iops #=> Integer
    #   resp.db_instances[0].option_group_memberships #=> Array
    #   resp.db_instances[0].option_group_memberships[0].option_group_name #=> String
    #   resp.db_instances[0].option_group_memberships[0].status #=> String
    #   resp.db_instances[0].character_set_name #=> String
    #   resp.db_instances[0].nchar_character_set_name #=> String
    #   resp.db_instances[0].secondary_availability_zone #=> String
    #   resp.db_instances[0].publicly_accessible #=> Boolean
    #   resp.db_instances[0].status_infos #=> Array
    #   resp.db_instances[0].status_infos[0].status_type #=> String
    #   resp.db_instances[0].status_infos[0].normal #=> Boolean
    #   resp.db_instances[0].status_infos[0].status #=> String
    #   resp.db_instances[0].status_infos[0].message #=> String
    #   resp.db_instances[0].storage_type #=> String
    #   resp.db_instances[0].tde_credential_arn #=> String
    #   resp.db_instances[0].db_instance_port #=> Integer
    #   resp.db_instances[0].db_cluster_identifier #=> String
    #   resp.db_instances[0].storage_encrypted #=> Boolean
    #   resp.db_instances[0].kms_key_id #=> String
    #   resp.db_instances[0].dbi_resource_id #=> String
    #   resp.db_instances[0].ca_certificate_identifier #=> String
    #   resp.db_instances[0].domain_memberships #=> Array
    #   resp.db_instances[0].domain_memberships[0].domain #=> String
    #   resp.db_instances[0].domain_memberships[0].status #=> String
    #   resp.db_instances[0].domain_memberships[0].fqdn #=> String
    #   resp.db_instances[0].domain_memberships[0].iam_role_name #=> String
    #   resp.db_instances[0].domain_memberships[0].ou #=> String
    #   resp.db_instances[0].domain_memberships[0].auth_secret_arn #=> String
    #   resp.db_instances[0].domain_memberships[0].dns_ips #=> Array
    #   resp.db_instances[0].domain_memberships[0].dns_ips[0] #=> String
    #   resp.db_instances[0].copy_tags_to_snapshot #=> Boolean
    #   resp.db_instances[0].monitoring_interval #=> Integer
    #   resp.db_instances[0].enhanced_monitoring_resource_arn #=> String
    #   resp.db_instances[0].monitoring_role_arn #=> String
    #   resp.db_instances[0].promotion_tier #=> Integer
    #   resp.db_instances[0].db_instance_arn #=> String
    #   resp.db_instances[0].timezone #=> String
    #   resp.db_instances[0].iam_database_authentication_enabled #=> Boolean
    #   resp.db_instances[0].database_insights_mode #=> String, one of "standard", "advanced"
    #   resp.db_instances[0].performance_insights_enabled #=> Boolean
    #   resp.db_instances[0].performance_insights_kms_key_id #=> String
    #   resp.db_instances[0].performance_insights_retention_period #=> Integer
    #   resp.db_instances[0].enabled_cloudwatch_logs_exports #=> Array
    #   resp.db_instances[0].enabled_cloudwatch_logs_exports[0] #=> String
    #   resp.db_instances[0].processor_features #=> Array
    #   resp.db_instances[0].processor_features[0].name #=> String
    #   resp.db_instances[0].processor_features[0].value #=> String
    #   resp.db_instances[0].deletion_protection #=> Boolean
    #   resp.db_instances[0].associated_roles #=> Array
    #   resp.db_instances[0].associated_roles[0].role_arn #=> String
    #   resp.db_instances[0].associated_roles[0].feature_name #=> String
    #   resp.db_instances[0].associated_roles[0].status #=> String
    #   resp.db_instances[0].listener_endpoint.address #=> String
    #   resp.db_instances[0].listener_endpoint.port #=> Integer
    #   resp.db_instances[0].listener_endpoint.hosted_zone_id #=> String
    #   resp.db_instances[0].max_allocated_storage #=> Integer
    #   resp.db_instances[0].tag_list #=> Array
    #   resp.db_instances[0].tag_list[0].key #=> String
    #   resp.db_instances[0].tag_list[0].value #=> String
    #   resp.db_instances[0].db_instance_automated_backups_replications #=> Array
    #   resp.db_instances[0].db_instance_automated_backups_replications[0].db_instance_automated_backups_arn #=> String
    #   resp.db_instances[0].customer_owned_ip_enabled #=> Boolean
    #   resp.db_instances[0].aws_backup_recovery_point_arn #=> String
    #   resp.db_instances[0].activity_stream_status #=> String, one of "stopped", "starting", "started", "stopping"
    #   resp.db_instances[0].activity_stream_kms_key_id #=> String
    #   resp.db_instances[0].activity_stream_kinesis_stream_name #=> String
    #   resp.db_instances[0].activity_stream_mode #=> String, one of "sync", "async"
    #   resp.db_instances[0].activity_stream_engine_native_audit_fields_included #=> Boolean
    #   resp.db_instances[0].automation_mode #=> String, one of "full", "all-paused"
    #   resp.db_instances[0].resume_full_automation_mode_time #=> Time
    #   resp.db_instances[0].custom_iam_instance_profile #=> String
    #   resp.db_instances[0].backup_target #=> String
    #   resp.db_instances[0].network_type #=> String
    #   resp.db_instances[0].activity_stream_policy_status #=> String, one of "locked", "unlocked", "locking-policy", "unlocking-policy"
    #   resp.db_instances[0].storage_throughput #=> Integer
    #   resp.db_instances[0].db_system_id #=> String
    #   resp.db_instances[0].master_user_secret.secret_arn #=> String
    #   resp.db_instances[0].master_user_secret.secret_status #=> String
    #   resp.db_instances[0].master_user_secret.kms_key_id #=> String
    #   resp.db_instances[0].certificate_details.ca_identifier #=> String
    #   resp.db_instances[0].certificate_details.valid_till #=> Time
    #   resp.db_instances[0].read_replica_source_db_cluster_identifier #=> String
    #   resp.db_instances[0].percent_progress #=> String
    #   resp.db_instances[0].dedicated_log_volume #=> Boolean
    #   resp.db_instances[0].is_storage_config_upgrade_available #=> Boolean
    #   resp.db_instances[0].multi_tenant #=> Boolean
    #   resp.db_instances[0].engine_lifecycle_support #=> String
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * db_instance_available
    #   * db_instance_deleted
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances AWS API Documentation
    #
    # @overload describe_db_instances(params = {})
    # @param [Hash] params ({})
    def describe_db_instances(params = {}, options = {})
      req = build_request(:describe_db_instances, params)
      req.send_request(options)
    end

    # Returns a list of DB log files for the DB instance.
    #
    # This command doesn't apply to RDS Custom.
    #
    # @option params [required, String] :db_instance_identifier
    #   The customer-assigned name of the DB instance that contains the log
    #   files you want to list.
    #
    #   Constraints:
    #
    #   * Must match the identifier of an existing DBInstance.
    #
    #   ^
    #
    # @option params [String] :filename_contains
    #   Filters the available log files for log file names that contain the
    #   specified string.
    #
    # @option params [Integer] :file_last_written
    #   Filters the available log files for files written since the specified
    #   date, in POSIX timestamp format with milliseconds.
    #
    # @option params [Integer] :file_size
    #   Filters the available log files for files larger than the specified
    #   size.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified MaxRecords value, a pagination token
    #   called a marker is included in the response so you can retrieve the
    #   remaining results.
    #
    # @option params [String] :marker
    #   The pagination token provided in the previous request. If this
    #   parameter is specified the response includes only records beyond the
    #   marker, up to MaxRecords.
    #
    # @return [Types::DescribeDBLogFilesResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeDBLogFilesResponse#describe_db_log_files #describe_db_log_files} => Array&lt;Types::DescribeDBLogFilesDetails&gt;
    #   * {Types::DescribeDBLogFilesResponse#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe the log files for a DB instance
    #
    #   # The following example retrieves details about the log files for the specified DB instance.
    #
    #   resp = client.describe_db_log_files({
    #     db_instance_identifier: "test-instance", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     describe_db_log_files: [
    #       {
    #         last_written: 1533060000000, 
    #         log_file_name: "error/mysql-error-running.log", 
    #         size: 0, 
    #       }, 
    #       {
    #         last_written: 1532994300000, 
    #         log_file_name: "error/mysql-error-running.log.0", 
    #         size: 2683, 
    #       }, 
    #       {
    #         last_written: 1533057300000, 
    #         log_file_name: "error/mysql-error-running.log.18", 
    #         size: 107, 
    #       }, 
    #       {
    #         last_written: 1532991000000, 
    #         log_file_name: "error/mysql-error-running.log.23", 
    #         size: 13105, 
    #       }, 
    #       {
    #         last_written: 1533061200000, 
    #         log_file_name: "error/mysql-error.log", 
    #         size: 0, 
    #       }, 
    #       {
    #         last_written: 1532989252000, 
    #         log_file_name: "mysqlUpgrade", 
    #         size: 3519, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_log_files({
    #     db_instance_identifier: "String", # required
    #     filename_contains: "String",
    #     file_last_written: 1,
    #     file_size: 1,
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.describe_db_log_files #=> Array
    #   resp.describe_db_log_files[0].log_file_name #=> String
    #   resp.describe_db_log_files[0].last_written #=> Integer
    #   resp.describe_db_log_files[0].size #=> Integer
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles AWS API Documentation
    #
    # @overload describe_db_log_files(params = {})
    # @param [Hash] params ({})
    def describe_db_log_files(params = {}, options = {})
      req = build_request(:describe_db_log_files, params)
      req.send_request(options)
    end

    # Describes the properties of specific major versions of DB engines.
    #
    # @option params [String] :engine
    #   The database engine to return major version details for.
    #
    #   Valid Values:
    #
    #   * `aurora-mysql`
    #
    #   * `aurora-postgresql`
    #
    #   * `custom-sqlserver-ee`
    #
    #   * `custom-sqlserver-se`
    #
    #   * `custom-sqlserver-web`
    #
    #   * `db2-ae`
    #
    #   * `db2-se`
    #
    #   * `mariadb`
    #
    #   * `mysql`
    #
    #   * `oracle-ee`
    #
    #   * `oracle-ee-cdb`
    #
    #   * `oracle-se2`
    #
    #   * `oracle-se2-cdb`
    #
    #   * `postgres`
    #
    #   * `sqlserver-ee`
    #
    #   * `sqlserver-se`
    #
    #   * `sqlserver-ex`
    #
    #   * `sqlserver-web`
    #
    # @option params [String] :major_engine_version
    #   A specific database major engine version to return details for.
    #
    #   Example: `8.4`
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous request. If this
    #   parameter is specified, the response includes only records beyond the
    #   marker, up to the value specified by `MaxRecords`.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more than
    #   the `MaxRecords` value is available, a pagination token called a
    #   marker is included in the response so you can retrieve the remaining
    #   results.
    #
    #   Default: 100
    #
    # @return [Types::DescribeDBMajorEngineVersionsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeDBMajorEngineVersionsResponse#db_major_engine_versions #db_major_engine_versions} => Array&lt;Types::DBMajorEngineVersion&gt;
    #   * {Types::DescribeDBMajorEngineVersionsResponse#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_major_engine_versions({
    #     engine: "Engine",
    #     major_engine_version: "MajorEngineVersion",
    #     marker: "Marker",
    #     max_records: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.db_major_engine_versions #=> Array
    #   resp.db_major_engine_versions[0].engine #=> String
    #   resp.db_major_engine_versions[0].major_engine_version #=> String
    #   resp.db_major_engine_versions[0].supported_engine_lifecycles #=> Array
    #   resp.db_major_engine_versions[0].supported_engine_lifecycles[0].lifecycle_support_name #=> String, one of "open-source-rds-standard-support", "open-source-rds-extended-support"
    #   resp.db_major_engine_versions[0].supported_engine_lifecycles[0].lifecycle_support_start_date #=> Time
    #   resp.db_major_engine_versions[0].supported_engine_lifecycles[0].lifecycle_support_end_date #=> Time
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBMajorEngineVersions AWS API Documentation
    #
    # @overload describe_db_major_engine_versions(params = {})
    # @param [Hash] params ({})
    def describe_db_major_engine_versions(params = {}, options = {})
      req = build_request(:describe_db_major_engine_versions, params)
      req.send_request(options)
    end

    # Returns a list of `DBParameterGroup` descriptions. If a
    # `DBParameterGroupName` is specified, the list will contain only the
    # description of the specified DB parameter group.
    #
    # @option params [String] :db_parameter_group_name
    #   The name of a specific DB parameter group to return details for.
    #
    #   Constraints:
    #
    #   * If supplied, must match the name of an existing
    #     DBClusterParameterGroup.
    #
    #   ^
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBParameterGroups` request. If this parameter is specified,
    #   the response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @return [Types::DBParameterGroupsMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBParameterGroupsMessage#marker #marker} => String
    #   * {Types::DBParameterGroupsMessage#db_parameter_groups #db_parameter_groups} => Array&lt;Types::DBParameterGroup&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe your DB parameter groups
    #
    #   # The following example retrieves details about your DB parameter groups.
    #
    #   resp = client.describe_db_parameter_groups({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_parameter_groups: [
    #       {
    #         db_parameter_group_arn: "arn:aws:rds:us-east-1:123456789012:pg:default.aurora-mysql5.7", 
    #         db_parameter_group_family: "aurora-mysql5.7", 
    #         db_parameter_group_name: "default.aurora-mysql5.7", 
    #         description: "Default parameter group for aurora-mysql5.7", 
    #       }, 
    #       {
    #         db_parameter_group_arn: "arn:aws:rds:us-east-1:123456789012:pg:default.aurora-postgresql9.6", 
    #         db_parameter_group_family: "aurora-postgresql9.6", 
    #         db_parameter_group_name: "default.aurora-postgresql9.6", 
    #         description: "Default parameter group for aurora-postgresql9.6", 
    #       }, 
    #       {
    #         db_parameter_group_arn: "arn:aws:rds:us-east-1:123456789012:pg:default.aurora5.6", 
    #         db_parameter_group_family: "aurora5.6", 
    #         db_parameter_group_name: "default.aurora5.6", 
    #         description: "Default parameter group for aurora5.6", 
    #       }, 
    #       {
    #         db_parameter_group_arn: "arn:aws:rds:us-east-1:123456789012:pg:default.mariadb10.1", 
    #         db_parameter_group_family: "mariadb10.1", 
    #         db_parameter_group_name: "default.mariadb10.1", 
    #         description: "Default parameter group for mariadb10.1", 
    #       }, 
    #     ], # Some output ommitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_parameter_groups({
    #     db_parameter_group_name: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_parameter_groups #=> Array
    #   resp.db_parameter_groups[0].db_parameter_group_name #=> String
    #   resp.db_parameter_groups[0].db_parameter_group_family #=> String
    #   resp.db_parameter_groups[0].description #=> String
    #   resp.db_parameter_groups[0].db_parameter_group_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups AWS API Documentation
    #
    # @overload describe_db_parameter_groups(params = {})
    # @param [Hash] params ({})
    def describe_db_parameter_groups(params = {}, options = {})
      req = build_request(:describe_db_parameter_groups, params)
      req.send_request(options)
    end

    # Returns the detailed parameter list for a particular DB parameter
    # group.
    #
    # @option params [required, String] :db_parameter_group_name
    #   The name of a specific DB parameter group to return details for.
    #
    #   Constraints:
    #
    #   * If supplied, must match the name of an existing DBParameterGroup.
    #
    #   ^
    #
    # @option params [String] :source
    #   The parameter types to return.
    #
    #   Default: All parameter types returned
    #
    #   Valid Values: `user | system | engine-default`
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more DB parameters to describe.
    #
    #   The only supported filter is `parameter-name`. The results list only
    #   includes information about the DB parameters with these names.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBParameters` request. If this parameter is specified, the
    #   response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @return [Types::DBParameterGroupDetails] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBParameterGroupDetails#parameters #parameters} => Array&lt;Types::Parameter&gt;
    #   * {Types::DBParameterGroupDetails#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe the parameters in a DB parameter group
    #
    #   # The following example retrieves the details of the specified DB parameter group.
    #
    #   resp = client.describe_db_parameters({
    #     db_parameter_group_name: "mydbpg", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     parameters: [
    #       {
    #         allowed_values: "0,1", 
    #         apply_method: "pending-reboot", 
    #         apply_type: "static", 
    #         data_type: "boolean", 
    #         description: "Controls whether user-defined functions that have only an xxx symbol for the main function can be loaded", 
    #         is_modifiable: false, 
    #         parameter_name: "allow-suspicious-udfs", 
    #         source: "engine-default", 
    #       }, 
    #       {
    #         allowed_values: "0,1", 
    #         apply_method: "pending-reboot", 
    #         apply_type: "static", 
    #         data_type: "boolean", 
    #         description: "Controls whether the server autogenerates SSL key and certificate files in the data directory, if they do not already exist.", 
    #         is_modifiable: false, 
    #         parameter_name: "auto_generate_certs", 
    #         source: "engine-default", 
    #       }, 
    #     ], # Some output omitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_parameters({
    #     db_parameter_group_name: "String", # required
    #     source: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.parameters #=> Array
    #   resp.parameters[0].parameter_name #=> String
    #   resp.parameters[0].parameter_value #=> String
    #   resp.parameters[0].description #=> String
    #   resp.parameters[0].source #=> String
    #   resp.parameters[0].apply_type #=> String
    #   resp.parameters[0].data_type #=> String
    #   resp.parameters[0].allowed_values #=> String
    #   resp.parameters[0].is_modifiable #=> Boolean
    #   resp.parameters[0].minimum_engine_version #=> String
    #   resp.parameters[0].apply_method #=> String, one of "immediate", "pending-reboot"
    #   resp.parameters[0].supported_engine_modes #=> Array
    #   resp.parameters[0].supported_engine_modes[0] #=> String
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters AWS API Documentation
    #
    # @overload describe_db_parameters(params = {})
    # @param [Hash] params ({})
    def describe_db_parameters(params = {}, options = {})
      req = build_request(:describe_db_parameters, params)
      req.send_request(options)
    end

    # Returns information about DB proxies.
    #
    # @option params [String] :db_proxy_name
    #   The name of the DB proxy. If you omit this parameter, the output
    #   includes information about all DB proxies owned by your Amazon Web
    #   Services account ID.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter is not currently supported.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous request. If this
    #   parameter is specified, the response includes only records beyond the
    #   marker, up to the value specified by `MaxRecords`.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that the
    #   remaining results can be retrieved.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @return [Types::DescribeDBProxiesResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeDBProxiesResponse#db_proxies #db_proxies} => Array&lt;Types::DBProxy&gt;
    #   * {Types::DescribeDBProxiesResponse#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_proxies({
    #     db_proxy_name: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     marker: "String",
    #     max_records: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.db_proxies #=> Array
    #   resp.db_proxies[0].db_proxy_name #=> String
    #   resp.db_proxies[0].db_proxy_arn #=> String
    #   resp.db_proxies[0].status #=> String, one of "available", "modifying", "incompatible-network", "insufficient-resource-limits", "creating", "deleting", "suspended", "suspending", "reactivating"
    #   resp.db_proxies[0].engine_family #=> String
    #   resp.db_proxies[0].vpc_id #=> String
    #   resp.db_proxies[0].vpc_security_group_ids #=> Array
    #   resp.db_proxies[0].vpc_security_group_ids[0] #=> String
    #   resp.db_proxies[0].vpc_subnet_ids #=> Array
    #   resp.db_proxies[0].vpc_subnet_ids[0] #=> String
    #   resp.db_proxies[0].auth #=> Array
    #   resp.db_proxies[0].auth[0].description #=> String
    #   resp.db_proxies[0].auth[0].user_name #=> String
    #   resp.db_proxies[0].auth[0].auth_scheme #=> String, one of "SECRETS"
    #   resp.db_proxies[0].auth[0].secret_arn #=> String
    #   resp.db_proxies[0].auth[0].iam_auth #=> String, one of "DISABLED", "REQUIRED", "ENABLED"
    #   resp.db_proxies[0].auth[0].client_password_auth_type #=> String, one of "MYSQL_NATIVE_PASSWORD", "MYSQL_CACHING_SHA2_PASSWORD", "POSTGRES_SCRAM_SHA_256", "POSTGRES_MD5", "SQL_SERVER_AUTHENTICATION"
    #   resp.db_proxies[0].role_arn #=> String
    #   resp.db_proxies[0].endpoint #=> String
    #   resp.db_proxies[0].require_tls #=> Boolean
    #   resp.db_proxies[0].idle_client_timeout #=> Integer
    #   resp.db_proxies[0].debug_logging #=> Boolean
    #   resp.db_proxies[0].created_date #=> Time
    #   resp.db_proxies[0].updated_date #=> Time
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxies AWS API Documentation
    #
    # @overload describe_db_proxies(params = {})
    # @param [Hash] params ({})
    def describe_db_proxies(params = {}, options = {})
      req = build_request(:describe_db_proxies, params)
      req.send_request(options)
    end

    # Returns information about DB proxy endpoints.
    #
    # @option params [String] :db_proxy_name
    #   The name of the DB proxy whose endpoints you want to describe. If you
    #   omit this parameter, the output includes information about all DB
    #   proxy endpoints associated with all your DB proxies.
    #
    # @option params [String] :db_proxy_endpoint_name
    #   The name of a DB proxy endpoint to describe. If you omit this
    #   parameter, the output includes information about all DB proxy
    #   endpoints associated with the specified proxy.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter is not currently supported.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous request. If this
    #   parameter is specified, the response includes only records beyond the
    #   marker, up to the value specified by `MaxRecords`.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that the
    #   remaining results can be retrieved.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @return [Types::DescribeDBProxyEndpointsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeDBProxyEndpointsResponse#db_proxy_endpoints #db_proxy_endpoints} => Array&lt;Types::DBProxyEndpoint&gt;
    #   * {Types::DescribeDBProxyEndpointsResponse#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_proxy_endpoints({
    #     db_proxy_name: "DBProxyName",
    #     db_proxy_endpoint_name: "DBProxyEndpointName",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     marker: "String",
    #     max_records: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.db_proxy_endpoints #=> Array
    #   resp.db_proxy_endpoints[0].db_proxy_endpoint_name #=> String
    #   resp.db_proxy_endpoints[0].db_proxy_endpoint_arn #=> String
    #   resp.db_proxy_endpoints[0].db_proxy_name #=> String
    #   resp.db_proxy_endpoints[0].status #=> String, one of "available", "modifying", "incompatible-network", "insufficient-resource-limits", "creating", "deleting"
    #   resp.db_proxy_endpoints[0].vpc_id #=> String
    #   resp.db_proxy_endpoints[0].vpc_security_group_ids #=> Array
    #   resp.db_proxy_endpoints[0].vpc_security_group_ids[0] #=> String
    #   resp.db_proxy_endpoints[0].vpc_subnet_ids #=> Array
    #   resp.db_proxy_endpoints[0].vpc_subnet_ids[0] #=> String
    #   resp.db_proxy_endpoints[0].endpoint #=> String
    #   resp.db_proxy_endpoints[0].created_date #=> Time
    #   resp.db_proxy_endpoints[0].target_role #=> String, one of "READ_WRITE", "READ_ONLY"
    #   resp.db_proxy_endpoints[0].is_default #=> Boolean
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyEndpoints AWS API Documentation
    #
    # @overload describe_db_proxy_endpoints(params = {})
    # @param [Hash] params ({})
    def describe_db_proxy_endpoints(params = {}, options = {})
      req = build_request(:describe_db_proxy_endpoints, params)
      req.send_request(options)
    end

    # Returns information about DB proxy target groups, represented by
    # `DBProxyTargetGroup` data structures.
    #
    # @option params [required, String] :db_proxy_name
    #   The identifier of the `DBProxy` associated with the target group.
    #
    # @option params [String] :target_group_name
    #   The identifier of the `DBProxyTargetGroup` to describe.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter is not currently supported.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous request. If this
    #   parameter is specified, the response includes only records beyond the
    #   marker, up to the value specified by `MaxRecords`.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that the
    #   remaining results can be retrieved.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @return [Types::DescribeDBProxyTargetGroupsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeDBProxyTargetGroupsResponse#target_groups #target_groups} => Array&lt;Types::DBProxyTargetGroup&gt;
    #   * {Types::DescribeDBProxyTargetGroupsResponse#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_proxy_target_groups({
    #     db_proxy_name: "String", # required
    #     target_group_name: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     marker: "String",
    #     max_records: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.target_groups #=> Array
    #   resp.target_groups[0].db_proxy_name #=> String
    #   resp.target_groups[0].target_group_name #=> String
    #   resp.target_groups[0].target_group_arn #=> String
    #   resp.target_groups[0].is_default #=> Boolean
    #   resp.target_groups[0].status #=> String
    #   resp.target_groups[0].connection_pool_config.max_connections_percent #=> Integer
    #   resp.target_groups[0].connection_pool_config.max_idle_connections_percent #=> Integer
    #   resp.target_groups[0].connection_pool_config.connection_borrow_timeout #=> Integer
    #   resp.target_groups[0].connection_pool_config.session_pinning_filters #=> Array
    #   resp.target_groups[0].connection_pool_config.session_pinning_filters[0] #=> String
    #   resp.target_groups[0].connection_pool_config.init_query #=> String
    #   resp.target_groups[0].created_date #=> Time
    #   resp.target_groups[0].updated_date #=> Time
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargetGroups AWS API Documentation
    #
    # @overload describe_db_proxy_target_groups(params = {})
    # @param [Hash] params ({})
    def describe_db_proxy_target_groups(params = {}, options = {})
      req = build_request(:describe_db_proxy_target_groups, params)
      req.send_request(options)
    end

    # Returns information about `DBProxyTarget` objects. This API supports
    # pagination.
    #
    # @option params [required, String] :db_proxy_name
    #   The identifier of the `DBProxyTarget` to describe.
    #
    # @option params [String] :target_group_name
    #   The identifier of the `DBProxyTargetGroup` to describe.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter is not currently supported.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous request. If this
    #   parameter is specified, the response includes only records beyond the
    #   marker, up to the value specified by `MaxRecords`.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that the
    #   remaining results can be retrieved.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @return [Types::DescribeDBProxyTargetsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeDBProxyTargetsResponse#targets #targets} => Array&lt;Types::DBProxyTarget&gt;
    #   * {Types::DescribeDBProxyTargetsResponse#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_proxy_targets({
    #     db_proxy_name: "String", # required
    #     target_group_name: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     marker: "String",
    #     max_records: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.targets #=> Array
    #   resp.targets[0].target_arn #=> String
    #   resp.targets[0].endpoint #=> String
    #   resp.targets[0].tracked_cluster_id #=> String
    #   resp.targets[0].rds_resource_id #=> String
    #   resp.targets[0].port #=> Integer
    #   resp.targets[0].type #=> String, one of "RDS_INSTANCE", "RDS_SERVERLESS_ENDPOINT", "TRACKED_CLUSTER"
    #   resp.targets[0].role #=> String, one of "READ_WRITE", "READ_ONLY", "UNKNOWN"
    #   resp.targets[0].target_health.state #=> String, one of "REGISTERING", "AVAILABLE", "UNAVAILABLE"
    #   resp.targets[0].target_health.reason #=> String, one of "UNREACHABLE", "CONNECTION_FAILED", "AUTH_FAILURE", "PENDING_PROXY_CAPACITY", "INVALID_REPLICATION_STATE"
    #   resp.targets[0].target_health.description #=> String
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargets AWS API Documentation
    #
    # @overload describe_db_proxy_targets(params = {})
    # @param [Hash] params ({})
    def describe_db_proxy_targets(params = {}, options = {})
      req = build_request(:describe_db_proxy_targets, params)
      req.send_request(options)
    end

    # Describes the recommendations to resolve the issues for your DB
    # instances, DB clusters, and DB parameter groups.
    #
    # @option params [Time,DateTime,Date,Integer,String] :last_updated_after
    #   A filter to include only the recommendations that were updated after
    #   this specified time.
    #
    # @option params [Time,DateTime,Date,Integer,String] :last_updated_before
    #   A filter to include only the recommendations that were updated before
    #   this specified time.
    #
    # @option params [String] :locale
    #   The language that you choose to return the list of recommendations.
    #
    #   Valid values:
    #
    #   * `en`
    #
    #   * `en_UK`
    #
    #   * `de`
    #
    #   * `es`
    #
    #   * `fr`
    #
    #   * `id`
    #
    #   * `it`
    #
    #   * `ja`
    #
    #   * `ko`
    #
    #   * `pt_BR`
    #
    #   * `zh_TW`
    #
    #   * `zh_CN`
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more recommendations to describe.
    #
    #   Supported Filters:
    #
    #   * `recommendation-id` - Accepts a list of recommendation identifiers.
    #     The results list only includes the recommendations whose identifier
    #     is one of the specified filter values.
    #
    #   * `status` - Accepts a list of recommendation statuses.
    #
    #     Valid values:
    #
    #     * `active` - The recommendations which are ready for you to apply.
    #
    #     * `pending` - The applied or scheduled recommendations which are in
    #       progress.
    #
    #     * `resolved` - The recommendations which are completed.
    #
    #     * `dismissed` - The recommendations that you dismissed.
    #     The results list only includes the recommendations whose status is
    #     one of the specified filter values.
    #
    #   * `severity` - Accepts a list of recommendation severities. The
    #     results list only includes the recommendations whose severity is one
    #     of the specified filter values.
    #
    #     Valid values:
    #
    #     * `high`
    #
    #     * `medium`
    #
    #     * `low`
    #
    #     * `informational`
    #   * `type-id` - Accepts a list of recommendation type identifiers. The
    #     results list only includes the recommendations whose type is one of
    #     the specified filter values.
    #
    #   * `dbi-resource-id` - Accepts a list of database resource identifiers.
    #     The results list only includes the recommendations that generated
    #     for the specified databases.
    #
    #   * `cluster-resource-id` - Accepts a list of cluster resource
    #     identifiers. The results list only includes the recommendations that
    #     generated for the specified clusters.
    #
    #   * `pg-arn` - Accepts a list of parameter group ARNs. The results list
    #     only includes the recommendations that generated for the specified
    #     parameter groups.
    #
    #   * `cluster-pg-arn` - Accepts a list of cluster parameter group ARNs.
    #     The results list only includes the recommendations that generated
    #     for the specified cluster parameter groups.
    #
    # @option params [Integer] :max_records
    #   The maximum number of recommendations to include in the response. If
    #   more records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBRecommendations` request. If this parameter is specified,
    #   the response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @return [Types::DBRecommendationsMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBRecommendationsMessage#db_recommendations #db_recommendations} => Array&lt;Types::DBRecommendation&gt;
    #   * {Types::DBRecommendationsMessage#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_recommendations({
    #     last_updated_after: Time.now,
    #     last_updated_before: Time.now,
    #     locale: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.db_recommendations #=> Array
    #   resp.db_recommendations[0].recommendation_id #=> String
    #   resp.db_recommendations[0].type_id #=> String
    #   resp.db_recommendations[0].severity #=> String
    #   resp.db_recommendations[0].resource_arn #=> String
    #   resp.db_recommendations[0].status #=> String
    #   resp.db_recommendations[0].created_time #=> Time
    #   resp.db_recommendations[0].updated_time #=> Time
    #   resp.db_recommendations[0].detection #=> String
    #   resp.db_recommendations[0].recommendation #=> String
    #   resp.db_recommendations[0].description #=> String
    #   resp.db_recommendations[0].reason #=> String
    #   resp.db_recommendations[0].recommended_actions #=> Array
    #   resp.db_recommendations[0].recommended_actions[0].action_id #=> String
    #   resp.db_recommendations[0].recommended_actions[0].title #=> String
    #   resp.db_recommendations[0].recommended_actions[0].description #=> String
    #   resp.db_recommendations[0].recommended_actions[0].operation #=> String
    #   resp.db_recommendations[0].recommended_actions[0].parameters #=> Array
    #   resp.db_recommendations[0].recommended_actions[0].parameters[0].key #=> String
    #   resp.db_recommendations[0].recommended_actions[0].parameters[0].value #=> String
    #   resp.db_recommendations[0].recommended_actions[0].apply_modes #=> Array
    #   resp.db_recommendations[0].recommended_actions[0].apply_modes[0] #=> String
    #   resp.db_recommendations[0].recommended_actions[0].status #=> String
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.start_time #=> Time
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.end_time #=> Time
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.metrics #=> Array
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.metrics[0].name #=> String
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.metrics[0].references #=> Array
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.metrics[0].references[0].name #=> String
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.metrics[0].references[0].reference_details.scalar_reference_details.value #=> Float
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.metrics[0].statistics_details #=> String
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.metrics[0].metric_query.performance_insights_metric_query.group_by.dimensions #=> Array
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.metrics[0].metric_query.performance_insights_metric_query.group_by.dimensions[0] #=> String
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.metrics[0].metric_query.performance_insights_metric_query.group_by.group #=> String
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.metrics[0].metric_query.performance_insights_metric_query.group_by.limit #=> Integer
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.metrics[0].metric_query.performance_insights_metric_query.metric #=> String
    #   resp.db_recommendations[0].recommended_actions[0].issue_details.performance_issue_details.analysis #=> String
    #   resp.db_recommendations[0].recommended_actions[0].context_attributes #=> Array
    #   resp.db_recommendations[0].recommended_actions[0].context_attributes[0].key #=> String
    #   resp.db_recommendations[0].recommended_actions[0].context_attributes[0].value #=> String
    #   resp.db_recommendations[0].category #=> String
    #   resp.db_recommendations[0].source #=> String
    #   resp.db_recommendations[0].type_detection #=> String
    #   resp.db_recommendations[0].type_recommendation #=> String
    #   resp.db_recommendations[0].impact #=> String
    #   resp.db_recommendations[0].additional_info #=> String
    #   resp.db_recommendations[0].links #=> Array
    #   resp.db_recommendations[0].links[0].text #=> String
    #   resp.db_recommendations[0].links[0].url #=> String
    #   resp.db_recommendations[0].issue_details.performance_issue_details.start_time #=> Time
    #   resp.db_recommendations[0].issue_details.performance_issue_details.end_time #=> Time
    #   resp.db_recommendations[0].issue_details.performance_issue_details.metrics #=> Array
    #   resp.db_recommendations[0].issue_details.performance_issue_details.metrics[0].name #=> String
    #   resp.db_recommendations[0].issue_details.performance_issue_details.metrics[0].references #=> Array
    #   resp.db_recommendations[0].issue_details.performance_issue_details.metrics[0].references[0].name #=> String
    #   resp.db_recommendations[0].issue_details.performance_issue_details.metrics[0].references[0].reference_details.scalar_reference_details.value #=> Float
    #   resp.db_recommendations[0].issue_details.performance_issue_details.metrics[0].statistics_details #=> String
    #   resp.db_recommendations[0].issue_details.performance_issue_details.metrics[0].metric_query.performance_insights_metric_query.group_by.dimensions #=> Array
    #   resp.db_recommendations[0].issue_details.performance_issue_details.metrics[0].metric_query.performance_insights_metric_query.group_by.dimensions[0] #=> String
    #   resp.db_recommendations[0].issue_details.performance_issue_details.metrics[0].metric_query.performance_insights_metric_query.group_by.group #=> String
    #   resp.db_recommendations[0].issue_details.performance_issue_details.metrics[0].metric_query.performance_insights_metric_query.group_by.limit #=> Integer
    #   resp.db_recommendations[0].issue_details.performance_issue_details.metrics[0].metric_query.performance_insights_metric_query.metric #=> String
    #   resp.db_recommendations[0].issue_details.performance_issue_details.analysis #=> String
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBRecommendations AWS API Documentation
    #
    # @overload describe_db_recommendations(params = {})
    # @param [Hash] params ({})
    def describe_db_recommendations(params = {}, options = {})
      req = build_request(:describe_db_recommendations, params)
      req.send_request(options)
    end

    # Returns a list of `DBSecurityGroup` descriptions. If a
    # `DBSecurityGroupName` is specified, the list will contain only the
    # descriptions of the specified DB security group.
    #
    # <note markdown="1"> EC2-Classic was retired on August 15, 2022. If you haven't migrated
    # from EC2-Classic to a VPC, we recommend that you migrate as soon as
    # possible. For more information, see [Migrate from EC2-Classic to a
    # VPC][1] in the *Amazon EC2 User Guide*, the blog [EC2-Classic
    # Networking is Retiring – Here’s How to Prepare][2], and [Moving a DB
    # instance not in a VPC into a VPC][3] in the *Amazon RDS User Guide*.
    #
    #  </note>
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html
    # [2]: http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/
    # [3]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html
    #
    # @option params [String] :db_security_group_name
    #   The name of the DB security group to return details for.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBSecurityGroups` request. If this parameter is specified,
    #   the response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @return [Types::DBSecurityGroupMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBSecurityGroupMessage#marker #marker} => String
    #   * {Types::DBSecurityGroupMessage#db_security_groups #db_security_groups} => Array&lt;Types::DBSecurityGroup&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To list DB security group settings
    #
    #   # This example lists settings for the specified security group.
    #
    #   resp = client.describe_db_security_groups({
    #     db_security_group_name: "mydbsecuritygroup", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_security_groups({
    #     db_security_group_name: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_security_groups #=> Array
    #   resp.db_security_groups[0].owner_id #=> String
    #   resp.db_security_groups[0].db_security_group_name #=> String
    #   resp.db_security_groups[0].db_security_group_description #=> String
    #   resp.db_security_groups[0].vpc_id #=> String
    #   resp.db_security_groups[0].ec2_security_groups #=> Array
    #   resp.db_security_groups[0].ec2_security_groups[0].status #=> String
    #   resp.db_security_groups[0].ec2_security_groups[0].ec2_security_group_name #=> String
    #   resp.db_security_groups[0].ec2_security_groups[0].ec2_security_group_id #=> String
    #   resp.db_security_groups[0].ec2_security_groups[0].ec2_security_group_owner_id #=> String
    #   resp.db_security_groups[0].ip_ranges #=> Array
    #   resp.db_security_groups[0].ip_ranges[0].status #=> String
    #   resp.db_security_groups[0].ip_ranges[0].cidrip #=> String
    #   resp.db_security_groups[0].db_security_group_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups AWS API Documentation
    #
    # @overload describe_db_security_groups(params = {})
    # @param [Hash] params ({})
    def describe_db_security_groups(params = {}, options = {})
      req = build_request(:describe_db_security_groups, params)
      req.send_request(options)
    end

    # Describes existing Aurora Limitless Database DB shard groups.
    #
    # @option params [String] :db_shard_group_identifier
    #   The user-supplied DB shard group identifier. If this parameter is
    #   specified, information for only the specific DB shard group is
    #   returned. This parameter isn't case-sensitive.
    #
    #   Constraints:
    #
    #   * If supplied, must match an existing DB shard group identifier.
    #
    #   ^
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more DB shard groups to describe.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBShardGroups` request. If this parameter is specified, the
    #   response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so you can retrieve
    #   the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100
    #
    # @return [Types::DescribeDBShardGroupsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeDBShardGroupsResponse#db_shard_groups #db_shard_groups} => Array&lt;Types::DBShardGroup&gt;
    #   * {Types::DescribeDBShardGroupsResponse#marker #marker} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_shard_groups({
    #     db_shard_group_identifier: "DBShardGroupIdentifier",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     marker: "String",
    #     max_records: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.db_shard_groups #=> Array
    #   resp.db_shard_groups[0].db_shard_group_resource_id #=> String
    #   resp.db_shard_groups[0].db_shard_group_identifier #=> String
    #   resp.db_shard_groups[0].db_cluster_identifier #=> String
    #   resp.db_shard_groups[0].max_acu #=> Float
    #   resp.db_shard_groups[0].min_acu #=> Float
    #   resp.db_shard_groups[0].compute_redundancy #=> Integer
    #   resp.db_shard_groups[0].status #=> String
    #   resp.db_shard_groups[0].publicly_accessible #=> Boolean
    #   resp.db_shard_groups[0].endpoint #=> String
    #   resp.db_shard_groups[0].db_shard_group_arn #=> String
    #   resp.db_shard_groups[0].tag_list #=> Array
    #   resp.db_shard_groups[0].tag_list[0].key #=> String
    #   resp.db_shard_groups[0].tag_list[0].value #=> String
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBShardGroups AWS API Documentation
    #
    # @overload describe_db_shard_groups(params = {})
    # @param [Hash] params ({})
    def describe_db_shard_groups(params = {}, options = {})
      req = build_request(:describe_db_shard_groups, params)
      req.send_request(options)
    end

    # Returns a list of DB snapshot attribute names and values for a manual
    # DB snapshot.
    #
    # When sharing snapshots with other Amazon Web Services accounts,
    # `DescribeDBSnapshotAttributes` returns the `restore` attribute and a
    # list of IDs for the Amazon Web Services accounts that are authorized
    # to copy or restore the manual DB snapshot. If `all` is included in the
    # list of values for the `restore` attribute, then the manual DB
    # snapshot is public and can be copied or restored by all Amazon Web
    # Services accounts.
    #
    # To add or remove access for an Amazon Web Services account to copy or
    # restore a manual DB snapshot, or to make the manual DB snapshot public
    # or private, use the `ModifyDBSnapshotAttribute` API action.
    #
    # @option params [required, String] :db_snapshot_identifier
    #   The identifier for the DB snapshot to describe the attributes for.
    #
    # @return [Types::DescribeDBSnapshotAttributesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeDBSnapshotAttributesResult#db_snapshot_attributes_result #db_snapshot_attributes_result} => Types::DBSnapshotAttributesResult
    #
    #
    # @example Example: To describe the attribute names and values for a DB snapshot
    #
    #   # The following example describes the attribute names and values for a DB snapshot.
    #
    #   resp = client.describe_db_snapshot_attributes({
    #     db_snapshot_identifier: "mydbsnapshot", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_snapshot_attributes_result: {
    #       db_snapshot_attributes: [
    #         {
    #           attribute_name: "restore", 
    #           attribute_values: [
    #             "123456789012", 
    #             "210987654321", 
    #           ], 
    #         }, 
    #       ], 
    #       db_snapshot_identifier: "mydbsnapshot", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_snapshot_attributes({
    #     db_snapshot_identifier: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.db_snapshot_attributes_result.db_snapshot_identifier #=> String
    #   resp.db_snapshot_attributes_result.db_snapshot_attributes #=> Array
    #   resp.db_snapshot_attributes_result.db_snapshot_attributes[0].attribute_name #=> String
    #   resp.db_snapshot_attributes_result.db_snapshot_attributes[0].attribute_values #=> Array
    #   resp.db_snapshot_attributes_result.db_snapshot_attributes[0].attribute_values[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributes AWS API Documentation
    #
    # @overload describe_db_snapshot_attributes(params = {})
    # @param [Hash] params ({})
    def describe_db_snapshot_attributes(params = {}, options = {})
      req = build_request(:describe_db_snapshot_attributes, params)
      req.send_request(options)
    end

    # Describes the tenant databases that exist in a DB snapshot. This
    # command only applies to RDS for Oracle DB instances in the
    # multi-tenant configuration.
    #
    # You can use this command to inspect the tenant databases within a
    # snapshot before restoring it. You can't directly interact with the
    # tenant databases in a DB snapshot. If you restore a snapshot that was
    # taken from DB instance using the multi-tenant configuration, you
    # restore all its tenant databases.
    #
    # @option params [String] :db_instance_identifier
    #   The ID of the DB instance used to create the DB snapshots. This
    #   parameter isn't case-sensitive.
    #
    #   Constraints:
    #
    #   * If supplied, must match the identifier of an existing `DBInstance`.
    #
    #   ^
    #
    # @option params [String] :db_snapshot_identifier
    #   The ID of a DB snapshot that contains the tenant databases to
    #   describe. This value is stored as a lowercase string.
    #
    #   Constraints:
    #
    #   * If you specify this parameter, the value must match the ID of an
    #     existing DB snapshot.
    #
    #   * If you specify an automatic snapshot, you must also specify
    #     `SnapshotType`.
    #
    # @option params [String] :snapshot_type
    #   The type of DB snapshots to be returned. You can specify one of the
    #   following values:
    #
    #   * `automated` – All DB snapshots that have been automatically taken by
    #     Amazon RDS for my Amazon Web Services account.
    #
    #   * `manual` – All DB snapshots that have been taken by my Amazon Web
    #     Services account.
    #
    #   * `shared` – All manual DB snapshots that have been shared to my
    #     Amazon Web Services account.
    #
    #   * `public` – All DB snapshots that have been marked as public.
    #
    #   * `awsbackup` – All DB snapshots managed by the Amazon Web Services
    #     Backup service.
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more tenant databases to describe.
    #
    #   Supported filters:
    #
    #   * `tenant-db-name` - Tenant database names. The results list only
    #     includes information about the tenant databases that match these
    #     tenant DB names.
    #
    #   * `tenant-database-resource-id` - Tenant database resource
    #     identifiers. The results list only includes information about the
    #     tenant databases contained within the DB snapshots.
    #
    #   * `dbi-resource-id` - DB instance resource identifiers. The results
    #     list only includes information about snapshots containing tenant
    #     databases contained within the DB instances identified by these
    #     resource identifiers.
    #
    #   * `db-instance-id` - Accepts DB instance identifiers and DB instance
    #     Amazon Resource Names (ARNs).
    #
    #   * `db-snapshot-id` - Accepts DB snapshot identifiers.
    #
    #   * `snapshot-type` - Accepts types of DB snapshots.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBSnapshotTenantDatabases` request. If this parameter is
    #   specified, the response includes only records beyond the marker, up to
    #   the value specified by `MaxRecords`.
    #
    # @option params [String] :dbi_resource_id
    #   A specific DB resource identifier to describe.
    #
    # @return [Types::DBSnapshotTenantDatabasesMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBSnapshotTenantDatabasesMessage#marker #marker} => String
    #   * {Types::DBSnapshotTenantDatabasesMessage#db_snapshot_tenant_databases #db_snapshot_tenant_databases} => Array&lt;Types::DBSnapshotTenantDatabase&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_snapshot_tenant_databases({
    #     db_instance_identifier: "String",
    #     db_snapshot_identifier: "String",
    #     snapshot_type: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #     dbi_resource_id: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_snapshot_tenant_databases #=> Array
    #   resp.db_snapshot_tenant_databases[0].db_snapshot_identifier #=> String
    #   resp.db_snapshot_tenant_databases[0].db_instance_identifier #=> String
    #   resp.db_snapshot_tenant_databases[0].dbi_resource_id #=> String
    #   resp.db_snapshot_tenant_databases[0].engine_name #=> String
    #   resp.db_snapshot_tenant_databases[0].snapshot_type #=> String
    #   resp.db_snapshot_tenant_databases[0].tenant_database_create_time #=> Time
    #   resp.db_snapshot_tenant_databases[0].tenant_db_name #=> String
    #   resp.db_snapshot_tenant_databases[0].master_username #=> String
    #   resp.db_snapshot_tenant_databases[0].tenant_database_resource_id #=> String
    #   resp.db_snapshot_tenant_databases[0].character_set_name #=> String
    #   resp.db_snapshot_tenant_databases[0].db_snapshot_tenant_database_arn #=> String
    #   resp.db_snapshot_tenant_databases[0].nchar_character_set_name #=> String
    #   resp.db_snapshot_tenant_databases[0].tag_list #=> Array
    #   resp.db_snapshot_tenant_databases[0].tag_list[0].key #=> String
    #   resp.db_snapshot_tenant_databases[0].tag_list[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotTenantDatabases AWS API Documentation
    #
    # @overload describe_db_snapshot_tenant_databases(params = {})
    # @param [Hash] params ({})
    def describe_db_snapshot_tenant_databases(params = {}, options = {})
      req = build_request(:describe_db_snapshot_tenant_databases, params)
      req.send_request(options)
    end

    # Returns information about DB snapshots. This API action supports
    # pagination.
    #
    # @option params [String] :db_instance_identifier
    #   The ID of the DB instance to retrieve the list of DB snapshots for.
    #   This parameter isn't case-sensitive.
    #
    #   Constraints:
    #
    #   * If supplied, must match the identifier of an existing DBInstance.
    #
    #   ^
    #
    # @option params [String] :db_snapshot_identifier
    #   A specific DB snapshot identifier to describe. This value is stored as
    #   a lowercase string.
    #
    #   Constraints:
    #
    #   * If supplied, must match the identifier of an existing DBSnapshot.
    #
    #   * If this identifier is for an automated snapshot, the `SnapshotType`
    #     parameter must also be specified.
    #
    # @option params [String] :snapshot_type
    #   The type of snapshots to be returned. You can specify one of the
    #   following values:
    #
    #   * `automated` - Return all DB snapshots that have been automatically
    #     taken by Amazon RDS for my Amazon Web Services account.
    #
    #   * `manual` - Return all DB snapshots that have been taken by my Amazon
    #     Web Services account.
    #
    #   * `shared` - Return all manual DB snapshots that have been shared to
    #     my Amazon Web Services account.
    #
    #   * `public` - Return all DB snapshots that have been marked as public.
    #
    #   * `awsbackup` - Return the DB snapshots managed by the Amazon Web
    #     Services Backup service.
    #
    #     For information about Amazon Web Services Backup, see the [ *Amazon
    #     Web Services Backup Developer Guide.* ][1]
    #
    #     The `awsbackup` type does not apply to Aurora.
    #
    #   If you don't specify a `SnapshotType` value, then both automated and
    #   manual snapshots are returned. Shared and public DB snapshots are not
    #   included in the returned results by default. You can include shared
    #   snapshots with these results by enabling the `IncludeShared`
    #   parameter. You can include public snapshots with these results by
    #   enabling the `IncludePublic` parameter.
    #
    #   The `IncludeShared` and `IncludePublic` parameters don't apply for
    #   `SnapshotType` values of `manual` or `automated`. The `IncludePublic`
    #   parameter doesn't apply when `SnapshotType` is set to `shared`. The
    #   `IncludeShared` parameter doesn't apply when `SnapshotType` is set to
    #   `public`.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more DB snapshots to describe.
    #
    #   Supported filters:
    #
    #   * `db-instance-id` - Accepts DB instance identifiers and DB instance
    #     Amazon Resource Names (ARNs).
    #
    #   * `db-snapshot-id` - Accepts DB snapshot identifiers.
    #
    #   * `dbi-resource-id` - Accepts identifiers of source DB instances.
    #
    #   * `snapshot-type` - Accepts types of DB snapshots.
    #
    #   * `engine` - Accepts names of database engines.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeDBSnapshots` request. If this parameter is specified, the
    #   response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @option params [Boolean] :include_shared
    #   Specifies whether to include shared manual DB cluster snapshots from
    #   other Amazon Web Services accounts that this Amazon Web Services
    #   account has been given permission to copy or restore. By default,
    #   these snapshots are not included.
    #
    #   You can give an Amazon Web Services account permission to restore a
    #   manual DB snapshot from another Amazon Web Services account by using
    #   the `ModifyDBSnapshotAttribute` API action.
    #
    #   This setting doesn't apply to RDS Custom.
    #
    # @option params [Boolean] :include_public
    #   Specifies whether to include manual DB cluster snapshots that are
    #   public and can be copied or restored by any Amazon Web Services
    #   account. By default, the public snapshots are not included.
    #
    #   You can share a manual DB snapshot as public by using the
    #   ModifyDBSnapshotAttribute API.
    #
    #   This setting doesn't apply to RDS Custom.
    #
    # @option params [String] :dbi_resource_id
    #   A specific DB resource ID to describe.
    #
    # @return [Types::DBSnapshotMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBSnapshotMessage#marker #marker} => String
    #   * {Types::DBSnapshotMessage#db_snapshots #db_snapshots} => Array&lt;Types::DBSnapshot&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe a DB snapshot for a DB instance
    #
    #   # The following example retrieves the details of a DB snapshot for a DB instance.
    #
    #   resp = client.describe_db_snapshots({
    #     db_snapshot_identifier: "mydbsnapshot", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_snapshots: [
    #       {
    #         allocated_storage: 20, 
    #         availability_zone: "us-east-1f", 
    #         db_instance_identifier: "mysqldb", 
    #         db_snapshot_arn: "arn:aws:rds:us-east-1:123456789012:snapshot:mydbsnapshot", 
    #         db_snapshot_identifier: "mydbsnapshot", 
    #         dbi_resource_id: "db-AKIAIOSFODNN7EXAMPLE", 
    #         encrypted: false, 
    #         engine: "mysql", 
    #         engine_version: "5.6.37", 
    #         iam_database_authentication_enabled: false, 
    #         instance_create_time: Time.parse("2018-02-08T22:24:55.973Z"), 
    #         license_model: "general-public-license", 
    #         master_username: "mysqladmin", 
    #         option_group_name: "default:mysql-5-6", 
    #         percent_progress: 100, 
    #         port: 3306, 
    #         processor_features: [
    #         ], 
    #         snapshot_create_time: Time.parse("2018-02-08T22:28:08.598Z"), 
    #         snapshot_type: "manual", 
    #         status: "available", 
    #         storage_type: "gp2", 
    #         vpc_id: "vpc-6594f31c", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_snapshots({
    #     db_instance_identifier: "String",
    #     db_snapshot_identifier: "String",
    #     snapshot_type: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #     include_shared: false,
    #     include_public: false,
    #     dbi_resource_id: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_snapshots #=> Array
    #   resp.db_snapshots[0].db_snapshot_identifier #=> String
    #   resp.db_snapshots[0].db_instance_identifier #=> String
    #   resp.db_snapshots[0].snapshot_create_time #=> Time
    #   resp.db_snapshots[0].engine #=> String
    #   resp.db_snapshots[0].allocated_storage #=> Integer
    #   resp.db_snapshots[0].status #=> String
    #   resp.db_snapshots[0].port #=> Integer
    #   resp.db_snapshots[0].availability_zone #=> String
    #   resp.db_snapshots[0].vpc_id #=> String
    #   resp.db_snapshots[0].instance_create_time #=> Time
    #   resp.db_snapshots[0].master_username #=> String
    #   resp.db_snapshots[0].engine_version #=> String
    #   resp.db_snapshots[0].license_model #=> String
    #   resp.db_snapshots[0].snapshot_type #=> String
    #   resp.db_snapshots[0].iops #=> Integer
    #   resp.db_snapshots[0].option_group_name #=> String
    #   resp.db_snapshots[0].percent_progress #=> Integer
    #   resp.db_snapshots[0].source_region #=> String
    #   resp.db_snapshots[0].source_db_snapshot_identifier #=> String
    #   resp.db_snapshots[0].storage_type #=> String
    #   resp.db_snapshots[0].tde_credential_arn #=> String
    #   resp.db_snapshots[0].encrypted #=> Boolean
    #   resp.db_snapshots[0].kms_key_id #=> String
    #   resp.db_snapshots[0].db_snapshot_arn #=> String
    #   resp.db_snapshots[0].timezone #=> String
    #   resp.db_snapshots[0].iam_database_authentication_enabled #=> Boolean
    #   resp.db_snapshots[0].processor_features #=> Array
    #   resp.db_snapshots[0].processor_features[0].name #=> String
    #   resp.db_snapshots[0].processor_features[0].value #=> String
    #   resp.db_snapshots[0].dbi_resource_id #=> String
    #   resp.db_snapshots[0].tag_list #=> Array
    #   resp.db_snapshots[0].tag_list[0].key #=> String
    #   resp.db_snapshots[0].tag_list[0].value #=> String
    #   resp.db_snapshots[0].original_snapshot_create_time #=> Time
    #   resp.db_snapshots[0].snapshot_database_time #=> Time
    #   resp.db_snapshots[0].snapshot_target #=> String
    #   resp.db_snapshots[0].storage_throughput #=> Integer
    #   resp.db_snapshots[0].db_system_id #=> String
    #   resp.db_snapshots[0].dedicated_log_volume #=> Boolean
    #   resp.db_snapshots[0].multi_tenant #=> Boolean
    #   resp.db_snapshots[0].snapshot_availability_zone #=> String
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * db_snapshot_available
    #   * db_snapshot_deleted
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots AWS API Documentation
    #
    # @overload describe_db_snapshots(params = {})
    # @param [Hash] params ({})
    def describe_db_snapshots(params = {}, options = {})
      req = build_request(:describe_db_snapshots, params)
      req.send_request(options)
    end

    # Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName
    # is specified, the list will contain only the descriptions of the
    # specified DBSubnetGroup.
    #
    # For an overview of CIDR ranges, go to the [Wikipedia Tutorial][1].
    #
    #
    #
    # [1]: http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing
    #
    # @option params [String] :db_subnet_group_name
    #   The name of the DB subnet group to return details for.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   DescribeDBSubnetGroups request. If this parameter is specified, the
    #   response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @return [Types::DBSubnetGroupMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBSubnetGroupMessage#marker #marker} => String
    #   * {Types::DBSubnetGroupMessage#db_subnet_groups #db_subnet_groups} => Array&lt;Types::DBSubnetGroup&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe a DB subnet group
    #
    #   # The following example retrieves the details of the specified DB subnet group.
    #
    #   resp = client.describe_db_subnet_groups({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_subnet_groups: [
    #       {
    #         db_subnet_group_arn: "arn:aws:rds:us-east-1:123456789012:subgrp:mydbsubnetgroup", 
    #         db_subnet_group_description: "My DB Subnet Group", 
    #         db_subnet_group_name: "mydbsubnetgroup", 
    #         subnet_group_status: "Complete", 
    #         subnets: [
    #           {
    #             subnet_availability_zone: {
    #               name: "us-east-1a", 
    #             }, 
    #             subnet_identifier: "subnet-d8c8e7f4", 
    #             subnet_status: "Active", 
    #           }, 
    #           {
    #             subnet_availability_zone: {
    #               name: "us-east-1f", 
    #             }, 
    #             subnet_identifier: "subnet-718fdc7d", 
    #             subnet_status: "Active", 
    #           }, 
    #           {
    #             subnet_availability_zone: {
    #               name: "us-east-1a", 
    #             }, 
    #             subnet_identifier: "subnet-cbc8e7e7", 
    #             subnet_status: "Active", 
    #           }, 
    #           {
    #             subnet_availability_zone: {
    #               name: "us-east-1a", 
    #             }, 
    #             subnet_identifier: "subnet-0ccde220", 
    #             subnet_status: "Active", 
    #           }, 
    #         ], 
    #         vpc_id: "vpc-971c12ee", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_db_subnet_groups({
    #     db_subnet_group_name: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.db_subnet_groups #=> Array
    #   resp.db_subnet_groups[0].db_subnet_group_name #=> String
    #   resp.db_subnet_groups[0].db_subnet_group_description #=> String
    #   resp.db_subnet_groups[0].vpc_id #=> String
    #   resp.db_subnet_groups[0].subnet_group_status #=> String
    #   resp.db_subnet_groups[0].subnets #=> Array
    #   resp.db_subnet_groups[0].subnets[0].subnet_identifier #=> String
    #   resp.db_subnet_groups[0].subnets[0].subnet_availability_zone.name #=> String
    #   resp.db_subnet_groups[0].subnets[0].subnet_outpost.arn #=> String
    #   resp.db_subnet_groups[0].subnets[0].subnet_status #=> String
    #   resp.db_subnet_groups[0].db_subnet_group_arn #=> String
    #   resp.db_subnet_groups[0].supported_network_types #=> Array
    #   resp.db_subnet_groups[0].supported_network_types[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups AWS API Documentation
    #
    # @overload describe_db_subnet_groups(params = {})
    # @param [Hash] params ({})
    def describe_db_subnet_groups(params = {}, options = {})
      req = build_request(:describe_db_subnet_groups, params)
      req.send_request(options)
    end

    # Returns the default engine and system parameter information for the
    # cluster database engine.
    #
    # For more information on Amazon Aurora, see [ What is Amazon
    # Aurora?][1] in the *Amazon Aurora User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    #
    # @option params [required, String] :db_parameter_group_family
    #   The name of the DB cluster parameter group family to return engine
    #   parameter information for.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so you can retrieve
    #   the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeEngineDefaultClusterParameters` request. If this parameter is
    #   specified, the response includes only records beyond the marker, up to
    #   the value specified by `MaxRecords`.
    #
    # @return [Types::DescribeEngineDefaultClusterParametersResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeEngineDefaultClusterParametersResult#engine_defaults #engine_defaults} => Types::EngineDefaults
    #
    #
    # @example Example: To describe the default engine and system parameter information for the Aurora database engine
    #
    #   # The following example retrieves the details of the default engine and system parameter information for Aurora DB
    #   # clusters with MySQL 5.7 compatibility.
    #
    #   resp = client.describe_engine_default_cluster_parameters({
    #     db_parameter_group_family: "aurora-mysql5.7", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     engine_defaults: {
    #       parameters: [
    #         {
    #           apply_type: "dynamic", 
    #           data_type: "string", 
    #           description: "IAM role ARN used to load data from AWS S3", 
    #           is_modifiable: true, 
    #           parameter_name: "aurora_load_from_s3_role", 
    #           source: "engine-default", 
    #           supported_engine_modes: [
    #             "provisioned", 
    #           ], 
    #         }, 
    #       ], 
    #     }, # Some output omitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_engine_default_cluster_parameters({
    #     db_parameter_group_family: "String", # required
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.engine_defaults.db_parameter_group_family #=> String
    #   resp.engine_defaults.marker #=> String
    #   resp.engine_defaults.parameters #=> Array
    #   resp.engine_defaults.parameters[0].parameter_name #=> String
    #   resp.engine_defaults.parameters[0].parameter_value #=> String
    #   resp.engine_defaults.parameters[0].description #=> String
    #   resp.engine_defaults.parameters[0].source #=> String
    #   resp.engine_defaults.parameters[0].apply_type #=> String
    #   resp.engine_defaults.parameters[0].data_type #=> String
    #   resp.engine_defaults.parameters[0].allowed_values #=> String
    #   resp.engine_defaults.parameters[0].is_modifiable #=> Boolean
    #   resp.engine_defaults.parameters[0].minimum_engine_version #=> String
    #   resp.engine_defaults.parameters[0].apply_method #=> String, one of "immediate", "pending-reboot"
    #   resp.engine_defaults.parameters[0].supported_engine_modes #=> Array
    #   resp.engine_defaults.parameters[0].supported_engine_modes[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParameters AWS API Documentation
    #
    # @overload describe_engine_default_cluster_parameters(params = {})
    # @param [Hash] params ({})
    def describe_engine_default_cluster_parameters(params = {}, options = {})
      req = build_request(:describe_engine_default_cluster_parameters, params)
      req.send_request(options)
    end

    # Returns the default engine and system parameter information for the
    # specified database engine.
    #
    # @option params [required, String] :db_parameter_group_family
    #   The name of the DB parameter group family.
    #
    #   Valid Values:
    #
    #   * `aurora-mysql5.7`
    #
    #   * `aurora-mysql8.0`
    #
    #   * `aurora-postgresql10`
    #
    #   * `aurora-postgresql11`
    #
    #   * `aurora-postgresql12`
    #
    #   * `aurora-postgresql13`
    #
    #   * `aurora-postgresql14`
    #
    #   * `custom-oracle-ee-19`
    #
    #   * `custom-oracle-ee-cdb-19`
    #
    #   * `db2-ae`
    #
    #   * `db2-se`
    #
    #   * `mariadb10.2`
    #
    #   * `mariadb10.3`
    #
    #   * `mariadb10.4`
    #
    #   * `mariadb10.5`
    #
    #   * `mariadb10.6`
    #
    #   * `mysql5.7`
    #
    #   * `mysql8.0`
    #
    #   * `oracle-ee-19`
    #
    #   * `oracle-ee-cdb-19`
    #
    #   * `oracle-ee-cdb-21`
    #
    #   * `oracle-se2-19`
    #
    #   * `oracle-se2-cdb-19`
    #
    #   * `oracle-se2-cdb-21`
    #
    #   * `postgres10`
    #
    #   * `postgres11`
    #
    #   * `postgres12`
    #
    #   * `postgres13`
    #
    #   * `postgres14`
    #
    #   * `sqlserver-ee-11.0`
    #
    #   * `sqlserver-ee-12.0`
    #
    #   * `sqlserver-ee-13.0`
    #
    #   * `sqlserver-ee-14.0`
    #
    #   * `sqlserver-ee-15.0`
    #
    #   * `sqlserver-ex-11.0`
    #
    #   * `sqlserver-ex-12.0`
    #
    #   * `sqlserver-ex-13.0`
    #
    #   * `sqlserver-ex-14.0`
    #
    #   * `sqlserver-ex-15.0`
    #
    #   * `sqlserver-se-11.0`
    #
    #   * `sqlserver-se-12.0`
    #
    #   * `sqlserver-se-13.0`
    #
    #   * `sqlserver-se-14.0`
    #
    #   * `sqlserver-se-15.0`
    #
    #   * `sqlserver-web-11.0`
    #
    #   * `sqlserver-web-12.0`
    #
    #   * `sqlserver-web-13.0`
    #
    #   * `sqlserver-web-14.0`
    #
    #   * `sqlserver-web-15.0`
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more parameters to describe.
    #
    #   The only supported filter is `parameter-name`. The results list only
    #   includes information about the parameters with these names.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so you can retrieve
    #   the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeEngineDefaultParameters` request. If this parameter is
    #   specified, the response includes only records beyond the marker, up to
    #   the value specified by `MaxRecords`.
    #
    # @return [Types::DescribeEngineDefaultParametersResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeEngineDefaultParametersResult#engine_defaults #engine_defaults} => Types::EngineDefaults
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe the default engine and system parameter information for the database engine
    #
    #   # The following example retrieves details for the default engine and system parameter information for MySQL 5.7 DB
    #   # instances.
    #
    #   resp = client.describe_engine_default_parameters({
    #     db_parameter_group_family: "mysql5.7", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     engine_defaults: {
    #       parameters: [
    #         {
    #           allowed_values: "0,1", 
    #           apply_type: "static", 
    #           data_type: "boolean", 
    #           description: "Controls whether user-defined functions that have only an xxx symbol for the main function can be loaded", 
    #           is_modifiable: false, 
    #           parameter_name: "allow-suspicious-udfs", 
    #           source: "engine-default", 
    #         }, 
    #       ], 
    #     }, # Some output omitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_engine_default_parameters({
    #     db_parameter_group_family: "String", # required
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.engine_defaults.db_parameter_group_family #=> String
    #   resp.engine_defaults.marker #=> String
    #   resp.engine_defaults.parameters #=> Array
    #   resp.engine_defaults.parameters[0].parameter_name #=> String
    #   resp.engine_defaults.parameters[0].parameter_value #=> String
    #   resp.engine_defaults.parameters[0].description #=> String
    #   resp.engine_defaults.parameters[0].source #=> String
    #   resp.engine_defaults.parameters[0].apply_type #=> String
    #   resp.engine_defaults.parameters[0].data_type #=> String
    #   resp.engine_defaults.parameters[0].allowed_values #=> String
    #   resp.engine_defaults.parameters[0].is_modifiable #=> Boolean
    #   resp.engine_defaults.parameters[0].minimum_engine_version #=> String
    #   resp.engine_defaults.parameters[0].apply_method #=> String, one of "immediate", "pending-reboot"
    #   resp.engine_defaults.parameters[0].supported_engine_modes #=> Array
    #   resp.engine_defaults.parameters[0].supported_engine_modes[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters AWS API Documentation
    #
    # @overload describe_engine_default_parameters(params = {})
    # @param [Hash] params ({})
    def describe_engine_default_parameters(params = {}, options = {})
      req = build_request(:describe_engine_default_parameters, params)
      req.send_request(options)
    end

    # Displays a list of categories for all event source types, or, if
    # specified, for a specified source type. You can also see this list in
    # the "Amazon RDS event categories and event messages" section of the
    # [ *Amazon RDS User Guide* ][1] or the [ *Amazon Aurora User Guide*
    # ][2].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html
    #
    # @option params [String] :source_type
    #   The type of source that is generating the events. For RDS Proxy
    #   events, specify `db-proxy`.
    #
    #   Valid Values: `db-instance` \| `db-cluster` \| `db-parameter-group` \|
    #   `db-security-group` \| `db-snapshot` \| `db-cluster-snapshot` \|
    #   `db-proxy`
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @return [Types::EventCategoriesMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::EventCategoriesMessage#event_categories_map_list #event_categories_map_list} => Array&lt;Types::EventCategoriesMap&gt;
    #
    #
    # @example Example: To describe event categories
    #
    #   # The following example retrieves details about the event categories for all available event sources.
    #
    #   resp = client.describe_event_categories({
    #     filters: [
    #     ], 
    #     source_type: "", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     event_categories_map_list: [
    #       {
    #         event_categories: [
    #           "deletion", 
    #           "read replica", 
    #           "failover", 
    #           "restoration", 
    #           "maintenance", 
    #           "low storage", 
    #           "configuration change", 
    #           "backup", 
    #           "creation", 
    #           "availability", 
    #           "recovery", 
    #           "failure", 
    #           "backtrack", 
    #           "notification", 
    #         ], 
    #         source_type: "db-instance", 
    #       }, 
    #       {
    #         event_categories: [
    #           "configuration change", 
    #           "failure", 
    #         ], 
    #         source_type: "db-security-group", 
    #       }, 
    #       {
    #         event_categories: [
    #           "configuration change", 
    #         ], 
    #         source_type: "db-parameter-group", 
    #       }, 
    #       {
    #         event_categories: [
    #           "deletion", 
    #           "creation", 
    #           "restoration", 
    #           "notification", 
    #         ], 
    #         source_type: "db-snapshot", 
    #       }, 
    #       {
    #         event_categories: [
    #           "failover", 
    #           "failure", 
    #           "notification", 
    #         ], 
    #         source_type: "db-cluster", 
    #       }, 
    #       {
    #         event_categories: [
    #           "backup", 
    #         ], 
    #         source_type: "db-cluster-snapshot", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_event_categories({
    #     source_type: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.event_categories_map_list #=> Array
    #   resp.event_categories_map_list[0].source_type #=> String
    #   resp.event_categories_map_list[0].event_categories #=> Array
    #   resp.event_categories_map_list[0].event_categories[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories AWS API Documentation
    #
    # @overload describe_event_categories(params = {})
    # @param [Hash] params ({})
    def describe_event_categories(params = {}, options = {})
      req = build_request(:describe_event_categories, params)
      req.send_request(options)
    end

    # Lists all the subscription descriptions for a customer account. The
    # description for a subscription includes `SubscriptionName`,
    # `SNSTopicARN`, `CustomerID`, `SourceType`, `SourceID`, `CreationTime`,
    # and `Status`.
    #
    # If you specify a `SubscriptionName`, lists the description for that
    # subscription.
    #
    # @option params [String] :subscription_name
    #   The name of the RDS event notification subscription you want to
    #   describe.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   DescribeOrderableDBInstanceOptions request. If this parameter is
    #   specified, the response includes only records beyond the marker, up to
    #   the value specified by `MaxRecords` .
    #
    # @return [Types::EventSubscriptionsMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::EventSubscriptionsMessage#marker #marker} => String
    #   * {Types::EventSubscriptionsMessage#event_subscriptions_list #event_subscriptions_list} => Array&lt;Types::EventSubscription&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe event subscriptions
    #
    #   # This example describes all of the Amazon RDS event subscriptions for the current AWS account.
    #
    #   resp = client.describe_event_subscriptions({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     event_subscriptions_list: [
    #       {
    #         cust_subscription_id: "my-instance-events", 
    #         customer_aws_id: "123456789012", 
    #         enabled: true, 
    #         event_categories_list: [
    #           "backup", 
    #           "recovery", 
    #         ], 
    #         event_subscription_arn: "arn:aws:rds:us-east-1:123456789012:es:my-instance-events", 
    #         sns_topic_arn: "arn:aws:sns:us-east-1:123456789012:interesting-events", 
    #         source_type: "db-instance", 
    #         status: "creating", 
    #         subscription_creation_time: "2018-07-31 23:22:01.893", 
    #       }, 
    #     ], # Some output omitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_event_subscriptions({
    #     subscription_name: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.event_subscriptions_list #=> Array
    #   resp.event_subscriptions_list[0].customer_aws_id #=> String
    #   resp.event_subscriptions_list[0].cust_subscription_id #=> String
    #   resp.event_subscriptions_list[0].sns_topic_arn #=> String
    #   resp.event_subscriptions_list[0].status #=> String
    #   resp.event_subscriptions_list[0].subscription_creation_time #=> String
    #   resp.event_subscriptions_list[0].source_type #=> String
    #   resp.event_subscriptions_list[0].source_ids_list #=> Array
    #   resp.event_subscriptions_list[0].source_ids_list[0] #=> String
    #   resp.event_subscriptions_list[0].event_categories_list #=> Array
    #   resp.event_subscriptions_list[0].event_categories_list[0] #=> String
    #   resp.event_subscriptions_list[0].enabled #=> Boolean
    #   resp.event_subscriptions_list[0].event_subscription_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions AWS API Documentation
    #
    # @overload describe_event_subscriptions(params = {})
    # @param [Hash] params ({})
    def describe_event_subscriptions(params = {}, options = {})
      req = build_request(:describe_event_subscriptions, params)
      req.send_request(options)
    end

    # Returns events related to DB instances, DB clusters, DB parameter
    # groups, DB security groups, DB snapshots, DB cluster snapshots, and
    # RDS Proxies for the past 14 days. Events specific to a particular DB
    # instance, DB cluster, DB parameter group, DB security group, DB
    # snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by
    # providing the name as a parameter.
    #
    # For more information on working with events, see [Monitoring Amazon
    # RDS events][1] in the *Amazon RDS User Guide* and [Monitoring Amazon
    # Aurora events][2] in the *Amazon Aurora User Guide*.
    #
    # <note markdown="1"> By default, RDS returns events that were generated in the past hour.
    #
    #  </note>
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html
    #
    # @option params [String] :source_identifier
    #   The identifier of the event source for which events are returned. If
    #   not specified, then all sources are included in the response.
    #
    #   Constraints:
    #
    #   * If `SourceIdentifier` is supplied, `SourceType` must also be
    #     provided.
    #
    #   * If the source type is a DB instance, a `DBInstanceIdentifier` value
    #     must be supplied.
    #
    #   * If the source type is a DB cluster, a `DBClusterIdentifier` value
    #     must be supplied.
    #
    #   * If the source type is a DB parameter group, a `DBParameterGroupName`
    #     value must be supplied.
    #
    #   * If the source type is a DB security group, a `DBSecurityGroupName`
    #     value must be supplied.
    #
    #   * If the source type is a DB snapshot, a `DBSnapshotIdentifier` value
    #     must be supplied.
    #
    #   * If the source type is a DB cluster snapshot, a
    #     `DBClusterSnapshotIdentifier` value must be supplied.
    #
    #   * If the source type is an RDS Proxy, a `DBProxyName` value must be
    #     supplied.
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens.
    #
    # @option params [String] :source_type
    #   The event source to retrieve events for. If no value is specified, all
    #   events are returned.
    #
    # @option params [Time,DateTime,Date,Integer,String] :start_time
    #   The beginning of the time interval to retrieve events for, specified
    #   in ISO 8601 format. For more information about ISO 8601, go to the
    #   [ISO8601 Wikipedia page.][1]
    #
    #   Example: 2009-07-08T18:00Z
    #
    #
    #
    #   [1]: http://en.wikipedia.org/wiki/ISO_8601
    #
    # @option params [Time,DateTime,Date,Integer,String] :end_time
    #   The end of the time interval for which to retrieve events, specified
    #   in ISO 8601 format. For more information about ISO 8601, go to the
    #   [ISO8601 Wikipedia page.][1]
    #
    #   Example: 2009-07-08T18:00Z
    #
    #
    #
    #   [1]: http://en.wikipedia.org/wiki/ISO_8601
    #
    # @option params [Integer] :duration
    #   The number of minutes to retrieve events for.
    #
    #   Default: 60
    #
    # @option params [Array<String>] :event_categories
    #   A list of event categories that trigger notifications for a event
    #   notification subscription.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous DescribeEvents
    #   request. If this parameter is specified, the response includes only
    #   records beyond the marker, up to the value specified by `MaxRecords`.
    #
    # @return [Types::EventsMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::EventsMessage#marker #marker} => String
    #   * {Types::EventsMessage#events #events} => Array&lt;Types::Event&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe events
    #
    #   # The following retrieves details for the events that have occurred for the specified DB instance.
    #
    #   resp = client.describe_events({
    #     source_identifier: "test-instance", 
    #     source_type: "db-instance", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     events: [
    #       {
    #         date: Time.parse("2018-07-31T23:09:23.983Z"), 
    #         event_categories: [
    #           "backup", 
    #         ], 
    #         message: "Backing up DB instance", 
    #         source_arn: "arn:aws:rds:us-east-1:123456789012:db:test-instance", 
    #         source_identifier: "test-instance", 
    #         source_type: "db-instance", 
    #       }, 
    #       {
    #         date: Time.parse("2018-07-31T23:15:13.049Z"), 
    #         event_categories: [
    #           "backup", 
    #         ], 
    #         message: "Finished DB Instance backup", 
    #         source_arn: "arn:aws:rds:us-east-1:123456789012:db:test-instance", 
    #         source_identifier: "test-instance", 
    #         source_type: "db-instance", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_events({
    #     source_identifier: "String",
    #     source_type: "db-instance", # accepts db-instance, db-parameter-group, db-security-group, db-snapshot, db-cluster, db-cluster-snapshot, custom-engine-version, db-proxy, blue-green-deployment
    #     start_time: Time.now,
    #     end_time: Time.now,
    #     duration: 1,
    #     event_categories: ["String"],
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.events #=> Array
    #   resp.events[0].source_identifier #=> String
    #   resp.events[0].source_type #=> String, one of "db-instance", "db-parameter-group", "db-security-group", "db-snapshot", "db-cluster", "db-cluster-snapshot", "custom-engine-version", "db-proxy", "blue-green-deployment"
    #   resp.events[0].message #=> String
    #   resp.events[0].event_categories #=> Array
    #   resp.events[0].event_categories[0] #=> String
    #   resp.events[0].date #=> Time
    #   resp.events[0].source_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents AWS API Documentation
    #
    # @overload describe_events(params = {})
    # @param [Hash] params ({})
    def describe_events(params = {}, options = {})
      req = build_request(:describe_events, params)
      req.send_request(options)
    end

    # Returns information about a snapshot or cluster export to Amazon S3.
    # This API operation supports pagination.
    #
    # @option params [String] :export_task_identifier
    #   The identifier of the snapshot or cluster export task to be described.
    #
    # @option params [String] :source_arn
    #   The Amazon Resource Name (ARN) of the snapshot or cluster exported to
    #   Amazon S3.
    #
    # @option params [Array<Types::Filter>] :filters
    #   Filters specify one or more snapshot or cluster exports to describe.
    #   The filters are specified as name-value pairs that define what to
    #   include in the output. Filter names and values are case-sensitive.
    #
    #   Supported filters include the following:
    #
    #   * `export-task-identifier` - An identifier for the snapshot or cluster
    #     export task.
    #
    #   * `s3-bucket` - The Amazon S3 bucket the data is exported to.
    #
    #   * `source-arn` - The Amazon Resource Name (ARN) of the snapshot or
    #     cluster exported to Amazon S3.
    #
    #   * `status` - The status of the export task. Must be lowercase. Valid
    #     statuses are the following:
    #
    #     * `canceled`
    #
    #     * `canceling`
    #
    #     * `complete`
    #
    #     * `failed`
    #
    #     * `in_progress`
    #
    #     * `starting`
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeExportTasks` request. If you specify this parameter, the
    #   response includes only records beyond the marker, up to the value
    #   specified by the `MaxRecords` parameter.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified value, a pagination token called a
    #   marker is included in the response. You can use the marker in a later
    #   `DescribeExportTasks` request to retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :source_type
    #   The type of source for the export.
    #
    # @return [Types::ExportTasksMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ExportTasksMessage#marker #marker} => String
    #   * {Types::ExportTasksMessage#export_tasks #export_tasks} => Array&lt;Types::ExportTask&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe snapshot export tasks
    #
    #   # The following example returns information about snapshot exports to Amazon S3.
    #
    #   resp = client.describe_export_tasks({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     export_tasks: [
    #       {
    #         export_task_identifier: "test-snapshot-export", 
    #         iam_role_arn: "arn:aws:iam::123456789012:role/service-role/ExportRole", 
    #         kms_key_id: "arn:aws:kms:us-west-2:123456789012:key/abcd0000-7fca-4128-82f2-aabbccddeeff", 
    #         percent_progress: 100, 
    #         s3_bucket: "mybucket", 
    #         s3_prefix: "", 
    #         snapshot_time: Time.parse("2020-03-02T18:26:28.163Z"), 
    #         source_arn: "arn:aws:rds:us-west-2:123456789012:snapshot:test-snapshot", 
    #         status: "COMPLETE", 
    #         task_end_time: Time.parse("2020-03-02T19:10:31.985Z"), 
    #         task_start_time: Time.parse("2020-03-02T18:57:56.896Z"), 
    #         total_extracted_data_in_gb: 0, 
    #       }, 
    #       {
    #         export_task_identifier: "my-s3-export", 
    #         iam_role_arn: "arn:aws:iam::123456789012:role/service-role/ExportRole", 
    #         kms_key_id: "arn:aws:kms:us-west-2:123456789012:key/abcd0000-7fca-4128-82f2-aabbccddeeff", 
    #         percent_progress: 0, 
    #         s3_bucket: "mybucket", 
    #         s3_prefix: "", 
    #         snapshot_time: Time.parse("2020-03-27T20:48:42.023Z"), 
    #         source_arn: "arn:aws:rds:us-west-2:123456789012:snapshot:db5-snapshot-test", 
    #         status: "STARTING", 
    #         total_extracted_data_in_gb: 0, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_export_tasks({
    #     export_task_identifier: "String",
    #     source_arn: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     marker: "String",
    #     max_records: 1,
    #     source_type: "SNAPSHOT", # accepts SNAPSHOT, CLUSTER
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.export_tasks #=> Array
    #   resp.export_tasks[0].export_task_identifier #=> String
    #   resp.export_tasks[0].source_arn #=> String
    #   resp.export_tasks[0].export_only #=> Array
    #   resp.export_tasks[0].export_only[0] #=> String
    #   resp.export_tasks[0].snapshot_time #=> Time
    #   resp.export_tasks[0].task_start_time #=> Time
    #   resp.export_tasks[0].task_end_time #=> Time
    #   resp.export_tasks[0].s3_bucket #=> String
    #   resp.export_tasks[0].s3_prefix #=> String
    #   resp.export_tasks[0].iam_role_arn #=> String
    #   resp.export_tasks[0].kms_key_id #=> String
    #   resp.export_tasks[0].status #=> String
    #   resp.export_tasks[0].percent_progress #=> Integer
    #   resp.export_tasks[0].total_extracted_data_in_gb #=> Integer
    #   resp.export_tasks[0].failure_cause #=> String
    #   resp.export_tasks[0].warning_message #=> String
    #   resp.export_tasks[0].source_type #=> String, one of "SNAPSHOT", "CLUSTER"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks AWS API Documentation
    #
    # @overload describe_export_tasks(params = {})
    # @param [Hash] params ({})
    def describe_export_tasks(params = {}, options = {})
      req = build_request(:describe_export_tasks, params)
      req.send_request(options)
    end

    # Returns information about Aurora global database clusters. This API
    # supports pagination.
    #
    # For more information on Amazon Aurora, see [ What is Amazon
    # Aurora?][1] in the *Amazon Aurora User Guide*.
    #
    # <note markdown="1"> This action only applies to Aurora DB clusters.
    #
    #  </note>
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    #
    # @option params [String] :global_cluster_identifier
    #   The user-supplied DB cluster identifier. If this parameter is
    #   specified, information from only the specific DB cluster is returned.
    #   This parameter isn't case-sensitive.
    #
    #   Constraints:
    #
    #   * If supplied, must match an existing DBClusterIdentifier.
    #
    #   ^
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more global database clusters to
    #   describe. This parameter is case-sensitive.
    #
    #   Currently, the only supported filter is `region`.
    #
    #   If used, the request returns information about any global cluster with
    #   at least one member (primary or secondary) in the specified Amazon Web
    #   Services Regions.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeGlobalClusters` request. If this parameter is specified, the
    #   response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @return [Types::GlobalClustersMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::GlobalClustersMessage#marker #marker} => String
    #   * {Types::GlobalClustersMessage#global_clusters #global_clusters} => Array&lt;Types::GlobalCluster&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe global DB clusters
    #
    #   # The following example lists Aurora global DB clusters in the current AWS Region.
    #
    #   resp = client.describe_global_clusters({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     global_clusters: [
    #       {
    #         deletion_protection: false, 
    #         engine: "aurora-mysql", 
    #         engine_version: "5.7.mysql_aurora.2.07.2", 
    #         global_cluster_arn: "arn:aws:rds::123456789012:global-cluster:myglobalcluster", 
    #         global_cluster_identifier: "myglobalcluster", 
    #         global_cluster_members: [
    #         ], 
    #         global_cluster_resource_id: "cluster-f5982077e3b5aabb", 
    #         status: "available", 
    #         storage_encrypted: false, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_global_clusters({
    #     global_cluster_identifier: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.global_clusters #=> Array
    #   resp.global_clusters[0].global_cluster_identifier #=> String
    #   resp.global_clusters[0].global_cluster_resource_id #=> String
    #   resp.global_clusters[0].global_cluster_arn #=> String
    #   resp.global_clusters[0].status #=> String
    #   resp.global_clusters[0].engine #=> String
    #   resp.global_clusters[0].engine_version #=> String
    #   resp.global_clusters[0].engine_lifecycle_support #=> String
    #   resp.global_clusters[0].database_name #=> String
    #   resp.global_clusters[0].storage_encrypted #=> Boolean
    #   resp.global_clusters[0].deletion_protection #=> Boolean
    #   resp.global_clusters[0].global_cluster_members #=> Array
    #   resp.global_clusters[0].global_cluster_members[0].db_cluster_arn #=> String
    #   resp.global_clusters[0].global_cluster_members[0].readers #=> Array
    #   resp.global_clusters[0].global_cluster_members[0].readers[0] #=> String
    #   resp.global_clusters[0].global_cluster_members[0].is_writer #=> Boolean
    #   resp.global_clusters[0].global_cluster_members[0].global_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "unknown"
    #   resp.global_clusters[0].global_cluster_members[0].synchronization_status #=> String, one of "connected", "pending-resync"
    #   resp.global_clusters[0].endpoint #=> String
    #   resp.global_clusters[0].failover_state.status #=> String, one of "pending", "failing-over", "cancelling"
    #   resp.global_clusters[0].failover_state.from_db_cluster_arn #=> String
    #   resp.global_clusters[0].failover_state.to_db_cluster_arn #=> String
    #   resp.global_clusters[0].failover_state.is_data_loss_allowed #=> Boolean
    #   resp.global_clusters[0].tag_list #=> Array
    #   resp.global_clusters[0].tag_list[0].key #=> String
    #   resp.global_clusters[0].tag_list[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters AWS API Documentation
    #
    # @overload describe_global_clusters(params = {})
    # @param [Hash] params ({})
    def describe_global_clusters(params = {}, options = {})
      req = build_request(:describe_global_clusters, params)
      req.send_request(options)
    end

    # Describe one or more zero-ETL integrations with Amazon Redshift.
    #
    # @option params [String] :integration_identifier
    #   The unique identifier of the integration.
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more resources to return.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeIntegrations` request. If this parameter is specified, the
    #   response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @return [Types::DescribeIntegrationsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeIntegrationsResponse#marker #marker} => String
    #   * {Types::DescribeIntegrationsResponse#integrations #integrations} => Array&lt;Types::Integration&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe a zero-ETL integration
    #
    #   # The following example retrieves information about a zero-ETL integration with Amazon Redshift.
    #
    #   resp = client.describe_integrations({
    #     integration_identifier: "5b9f3d79-7392-4a3e-896c-58eaa1b53231", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     integrations: [
    #       {
    #         create_time: Time.parse("2023-12-28T17:20:20.629Z"), 
    #         integration_arn: "arn:aws:rds:us-east-1:123456789012:integration:5b9f3d79-7392-4a3e-896c-58eaa1b53231", 
    #         integration_name: "my-integration", 
    #         kms_key_id: "arn:aws:kms:us-east-1:123456789012:key/a1b2c3d4-5678-90ab-cdef-EXAMPLEaaaaa", 
    #         source_arn: "arn:aws:rds:us-east-1:123456789012:cluster:my-cluster", 
    #         status: "active", 
    #         tags: [
    #         ], 
    #         target_arn: "arn:aws:redshift-serverless:us-east-1:123456789012:namespace/62c70612-0302-4db7-8414-b5e3e049f0d8", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_integrations({
    #     integration_identifier: "IntegrationIdentifier",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "Marker",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.integrations #=> Array
    #   resp.integrations[0].source_arn #=> String
    #   resp.integrations[0].target_arn #=> String
    #   resp.integrations[0].integration_name #=> String
    #   resp.integrations[0].integration_arn #=> String
    #   resp.integrations[0].kms_key_id #=> String
    #   resp.integrations[0].additional_encryption_context #=> Hash
    #   resp.integrations[0].additional_encryption_context["String"] #=> String
    #   resp.integrations[0].status #=> String, one of "creating", "active", "modifying", "failed", "deleting", "syncing", "needs_attention"
    #   resp.integrations[0].tags #=> Array
    #   resp.integrations[0].tags[0].key #=> String
    #   resp.integrations[0].tags[0].value #=> String
    #   resp.integrations[0].create_time #=> Time
    #   resp.integrations[0].errors #=> Array
    #   resp.integrations[0].errors[0].error_code #=> String
    #   resp.integrations[0].errors[0].error_message #=> String
    #   resp.integrations[0].data_filter #=> String
    #   resp.integrations[0].description #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeIntegrations AWS API Documentation
    #
    # @overload describe_integrations(params = {})
    # @param [Hash] params ({})
    def describe_integrations(params = {}, options = {})
      req = build_request(:describe_integrations, params)
      req.send_request(options)
    end

    # Describes all available options for the specified engine.
    #
    # @option params [required, String] :engine_name
    #   The name of the engine to describe options for.
    #
    #   Valid Values:
    #
    #   * `db2-ae`
    #
    #   * `db2-se`
    #
    #   * `mariadb`
    #
    #   * `mysql`
    #
    #   * `oracle-ee`
    #
    #   * `oracle-ee-cdb`
    #
    #   * `oracle-se2`
    #
    #   * `oracle-se2-cdb`
    #
    #   * `postgres`
    #
    #   * `sqlserver-ee`
    #
    #   * `sqlserver-se`
    #
    #   * `sqlserver-ex`
    #
    #   * `sqlserver-web`
    #
    # @option params [String] :major_engine_version
    #   If specified, filters the results to include only options for the
    #   specified major engine version.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous request. If this
    #   parameter is specified, the response includes only records beyond the
    #   marker, up to the value specified by `MaxRecords`.
    #
    # @return [Types::OptionGroupOptionsMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::OptionGroupOptionsMessage#option_group_options #option_group_options} => Array&lt;Types::OptionGroupOption&gt;
    #   * {Types::OptionGroupOptionsMessage#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe all available options
    #
    #   # The following example lists the options for an RDS for MySQL version 8.0 DB instance.
    #
    #   resp = client.describe_option_group_options({
    #     engine_name: "mysql", 
    #     major_engine_version: "8.0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     option_group_options: [
    #       {
    #         description: "MariaDB Audit Plugin", 
    #         engine_name: "mysql", 
    #         major_engine_version: "8.0", 
    #         minimum_required_minor_engine_version: "25", 
    #         name: "MARIADB_AUDIT_PLUGIN", 
    #         option_group_option_settings: [
    #           {
    #             apply_type: "DYNAMIC", 
    #             is_modifiable: true, 
    #             is_required: false, 
    #             minimum_engine_version_per_allowed_value: [
    #             ], 
    #             setting_description: "Include specified users", 
    #             setting_name: "SERVER_AUDIT_INCL_USERS", 
    #           }, 
    #           {
    #             apply_type: "DYNAMIC", 
    #             is_modifiable: true, 
    #             is_required: false, 
    #             minimum_engine_version_per_allowed_value: [
    #             ], 
    #             setting_description: "Exclude specified users", 
    #             setting_name: "SERVER_AUDIT_EXCL_USERS", 
    #           }, 
    #         ], 
    #         options_conflicts_with: [
    #         ], 
    #         options_depended_on: [
    #         ], 
    #         permanent: false, 
    #         persistent: false, 
    #         port_required: false, 
    #         requires_auto_minor_engine_version_upgrade: false, 
    #         vpc_only: false, 
    #       }, 
    #     ], # Some output omitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_option_group_options({
    #     engine_name: "String", # required
    #     major_engine_version: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.option_group_options #=> Array
    #   resp.option_group_options[0].name #=> String
    #   resp.option_group_options[0].description #=> String
    #   resp.option_group_options[0].engine_name #=> String
    #   resp.option_group_options[0].major_engine_version #=> String
    #   resp.option_group_options[0].minimum_required_minor_engine_version #=> String
    #   resp.option_group_options[0].port_required #=> Boolean
    #   resp.option_group_options[0].default_port #=> Integer
    #   resp.option_group_options[0].options_depended_on #=> Array
    #   resp.option_group_options[0].options_depended_on[0] #=> String
    #   resp.option_group_options[0].options_conflicts_with #=> Array
    #   resp.option_group_options[0].options_conflicts_with[0] #=> String
    #   resp.option_group_options[0].persistent #=> Boolean
    #   resp.option_group_options[0].permanent #=> Boolean
    #   resp.option_group_options[0].requires_auto_minor_engine_version_upgrade #=> Boolean
    #   resp.option_group_options[0].vpc_only #=> Boolean
    #   resp.option_group_options[0].supports_option_version_downgrade #=> Boolean
    #   resp.option_group_options[0].option_group_option_settings #=> Array
    #   resp.option_group_options[0].option_group_option_settings[0].setting_name #=> String
    #   resp.option_group_options[0].option_group_option_settings[0].setting_description #=> String
    #   resp.option_group_options[0].option_group_option_settings[0].default_value #=> String
    #   resp.option_group_options[0].option_group_option_settings[0].apply_type #=> String
    #   resp.option_group_options[0].option_group_option_settings[0].allowed_values #=> String
    #   resp.option_group_options[0].option_group_option_settings[0].is_modifiable #=> Boolean
    #   resp.option_group_options[0].option_group_option_settings[0].is_required #=> Boolean
    #   resp.option_group_options[0].option_group_option_settings[0].minimum_engine_version_per_allowed_value #=> Array
    #   resp.option_group_options[0].option_group_option_settings[0].minimum_engine_version_per_allowed_value[0].allowed_value #=> String
    #   resp.option_group_options[0].option_group_option_settings[0].minimum_engine_version_per_allowed_value[0].minimum_engine_version #=> String
    #   resp.option_group_options[0].option_group_option_versions #=> Array
    #   resp.option_group_options[0].option_group_option_versions[0].version #=> String
    #   resp.option_group_options[0].option_group_option_versions[0].is_default #=> Boolean
    #   resp.option_group_options[0].copyable_cross_account #=> Boolean
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions AWS API Documentation
    #
    # @overload describe_option_group_options(params = {})
    # @param [Hash] params ({})
    def describe_option_group_options(params = {}, options = {})
      req = build_request(:describe_option_group_options, params)
      req.send_request(options)
    end

    # Describes the available option groups.
    #
    # @option params [String] :option_group_name
    #   The name of the option group to describe. Can't be supplied together
    #   with EngineName or MajorEngineVersion.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   DescribeOptionGroups request. If this parameter is specified, the
    #   response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :engine_name
    #   A filter to only include option groups associated with this database
    #   engine.
    #
    #   Valid Values:
    #
    #   * `db2-ae`
    #
    #   * `db2-se`
    #
    #   * `mariadb`
    #
    #   * `mysql`
    #
    #   * `oracle-ee`
    #
    #   * `oracle-ee-cdb`
    #
    #   * `oracle-se2`
    #
    #   * `oracle-se2-cdb`
    #
    #   * `postgres`
    #
    #   * `sqlserver-ee`
    #
    #   * `sqlserver-se`
    #
    #   * `sqlserver-ex`
    #
    #   * `sqlserver-web`
    #
    # @option params [String] :major_engine_version
    #   Filters the list of option groups to only include groups associated
    #   with a specific database engine version. If specified, then EngineName
    #   must also be specified.
    #
    # @return [Types::OptionGroups] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::OptionGroups#option_groups_list #option_groups_list} => Array&lt;Types::OptionGroup&gt;
    #   * {Types::OptionGroups#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe the available option groups
    #
    #   # The following example lists the options groups for an Oracle Database 19c instance.
    #
    #   resp = client.describe_option_groups({
    #     engine_name: "oracle-ee", 
    #     major_engine_version: "19", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     option_groups_list: [
    #       {
    #         allows_vpc_and_non_vpc_instance_memberships: true, 
    #         engine_name: "oracle-ee", 
    #         major_engine_version: "19", 
    #         option_group_arn: "arn:aws:rds:us-west-1:111122223333:og:default:oracle-ee-19", 
    #         option_group_description: "Default option group for oracle-ee 19", 
    #         option_group_name: "default:oracle-ee-19", 
    #         options: [
    #         ], 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_option_groups({
    #     option_group_name: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     marker: "String",
    #     max_records: 1,
    #     engine_name: "String",
    #     major_engine_version: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.option_groups_list #=> Array
    #   resp.option_groups_list[0].option_group_name #=> String
    #   resp.option_groups_list[0].option_group_description #=> String
    #   resp.option_groups_list[0].engine_name #=> String
    #   resp.option_groups_list[0].major_engine_version #=> String
    #   resp.option_groups_list[0].options #=> Array
    #   resp.option_groups_list[0].options[0].option_name #=> String
    #   resp.option_groups_list[0].options[0].option_description #=> String
    #   resp.option_groups_list[0].options[0].persistent #=> Boolean
    #   resp.option_groups_list[0].options[0].permanent #=> Boolean
    #   resp.option_groups_list[0].options[0].port #=> Integer
    #   resp.option_groups_list[0].options[0].option_version #=> String
    #   resp.option_groups_list[0].options[0].option_settings #=> Array
    #   resp.option_groups_list[0].options[0].option_settings[0].name #=> String
    #   resp.option_groups_list[0].options[0].option_settings[0].value #=> String
    #   resp.option_groups_list[0].options[0].option_settings[0].default_value #=> String
    #   resp.option_groups_list[0].options[0].option_settings[0].description #=> String
    #   resp.option_groups_list[0].options[0].option_settings[0].apply_type #=> String
    #   resp.option_groups_list[0].options[0].option_settings[0].data_type #=> String
    #   resp.option_groups_list[0].options[0].option_settings[0].allowed_values #=> String
    #   resp.option_groups_list[0].options[0].option_settings[0].is_modifiable #=> Boolean
    #   resp.option_groups_list[0].options[0].option_settings[0].is_collection #=> Boolean
    #   resp.option_groups_list[0].options[0].db_security_group_memberships #=> Array
    #   resp.option_groups_list[0].options[0].db_security_group_memberships[0].db_security_group_name #=> String
    #   resp.option_groups_list[0].options[0].db_security_group_memberships[0].status #=> String
    #   resp.option_groups_list[0].options[0].vpc_security_group_memberships #=> Array
    #   resp.option_groups_list[0].options[0].vpc_security_group_memberships[0].vpc_security_group_id #=> String
    #   resp.option_groups_list[0].options[0].vpc_security_group_memberships[0].status #=> String
    #   resp.option_groups_list[0].allows_vpc_and_non_vpc_instance_memberships #=> Boolean
    #   resp.option_groups_list[0].vpc_id #=> String
    #   resp.option_groups_list[0].option_group_arn #=> String
    #   resp.option_groups_list[0].source_option_group #=> String
    #   resp.option_groups_list[0].source_account_id #=> String
    #   resp.option_groups_list[0].copy_timestamp #=> Time
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups AWS API Documentation
    #
    # @overload describe_option_groups(params = {})
    # @param [Hash] params ({})
    def describe_option_groups(params = {}, options = {})
      req = build_request(:describe_option_groups, params)
      req.send_request(options)
    end

    # Describes the orderable DB instance options for a specified DB engine.
    #
    # @option params [required, String] :engine
    #   The name of the database engine to describe DB instance options for.
    #
    #   Valid Values:
    #
    #   * `aurora-mysql`
    #
    #   * `aurora-postgresql`
    #
    #   * `custom-oracle-ee`
    #
    #   * `custom-oracle-ee-cdb`
    #
    #   * `custom-oracle-se2`
    #
    #   * `custom-oracle-se2-cdb`
    #
    #   * `db2-ae`
    #
    #   * `db2-se`
    #
    #   * `mariadb`
    #
    #   * `mysql`
    #
    #   * `oracle-ee`
    #
    #   * `oracle-ee-cdb`
    #
    #   * `oracle-se2`
    #
    #   * `oracle-se2-cdb`
    #
    #   * `postgres`
    #
    #   * `sqlserver-ee`
    #
    #   * `sqlserver-se`
    #
    #   * `sqlserver-ex`
    #
    #   * `sqlserver-web`
    #
    # @option params [String] :engine_version
    #   A filter to include only the available options for the specified
    #   engine version.
    #
    # @option params [String] :db_instance_class
    #   A filter to include only the available options for the specified DB
    #   instance class.
    #
    # @option params [String] :license_model
    #   A filter to include only the available options for the specified
    #   license model.
    #
    #   RDS Custom supports only the BYOL licensing model.
    #
    # @option params [String] :availability_zone_group
    #   The Availability Zone group associated with a Local Zone. Specify this
    #   parameter to retrieve available options for the Local Zones in the
    #   group.
    #
    #   Omit this parameter to show the available options in the specified
    #   Amazon Web Services Region.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [Boolean] :vpc
    #   Specifies whether to show only VPC or non-VPC offerings. RDS Custom
    #   supports only VPC offerings.
    #
    #   RDS Custom supports only VPC offerings. If you describe non-VPC
    #   offerings for RDS Custom, the output shows VPC offerings.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 1000.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   DescribeOrderableDBInstanceOptions request. If this parameter is
    #   specified, the response includes only records beyond the marker, up to
    #   the value specified by `MaxRecords`.
    #
    # @return [Types::OrderableDBInstanceOptionsMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::OrderableDBInstanceOptionsMessage#orderable_db_instance_options #orderable_db_instance_options} => Array&lt;Types::OrderableDBInstanceOption&gt;
    #   * {Types::OrderableDBInstanceOptionsMessage#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe orderable DB instance options
    #
    #   # The following example retrieves details about the orderable options for a DB instances running the MySQL DB engine.
    #
    #   resp = client.describe_orderable_db_instance_options({
    #     engine: "mysql", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     orderable_db_instance_options: [
    #       {
    #         availability_zones: [
    #           {
    #             name: "us-east-1a", 
    #           }, 
    #           {
    #             name: "us-east-1b", 
    #           }, 
    #           {
    #             name: "us-east-1c", 
    #           }, 
    #           {
    #             name: "us-east-1d", 
    #           }, 
    #           {
    #             name: "us-east-1e", 
    #           }, 
    #           {
    #             name: "us-east-1f", 
    #           }, 
    #         ], 
    #         db_instance_class: "db.m4.10xlarge", 
    #         engine: "mysql", 
    #         engine_version: "5.7.33", 
    #         license_model: "general-public-license", 
    #         multi_az_capable: true, 
    #         read_replica_capable: true, 
    #         storage_type: "gp2", 
    #         supports_storage_encryption: true, 
    #         vpc: true, 
    #       }, 
    #     ], # Some output omitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_orderable_db_instance_options({
    #     engine: "String", # required
    #     engine_version: "String",
    #     db_instance_class: "String",
    #     license_model: "String",
    #     availability_zone_group: "String",
    #     vpc: false,
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.orderable_db_instance_options #=> Array
    #   resp.orderable_db_instance_options[0].engine #=> String
    #   resp.orderable_db_instance_options[0].engine_version #=> String
    #   resp.orderable_db_instance_options[0].db_instance_class #=> String
    #   resp.orderable_db_instance_options[0].license_model #=> String
    #   resp.orderable_db_instance_options[0].availability_zone_group #=> String
    #   resp.orderable_db_instance_options[0].availability_zones #=> Array
    #   resp.orderable_db_instance_options[0].availability_zones[0].name #=> String
    #   resp.orderable_db_instance_options[0].multi_az_capable #=> Boolean
    #   resp.orderable_db_instance_options[0].read_replica_capable #=> Boolean
    #   resp.orderable_db_instance_options[0].vpc #=> Boolean
    #   resp.orderable_db_instance_options[0].supports_storage_encryption #=> Boolean
    #   resp.orderable_db_instance_options[0].storage_type #=> String
    #   resp.orderable_db_instance_options[0].supports_iops #=> Boolean
    #   resp.orderable_db_instance_options[0].supports_enhanced_monitoring #=> Boolean
    #   resp.orderable_db_instance_options[0].supports_iam_database_authentication #=> Boolean
    #   resp.orderable_db_instance_options[0].supports_performance_insights #=> Boolean
    #   resp.orderable_db_instance_options[0].min_storage_size #=> Integer
    #   resp.orderable_db_instance_options[0].max_storage_size #=> Integer
    #   resp.orderable_db_instance_options[0].min_iops_per_db_instance #=> Integer
    #   resp.orderable_db_instance_options[0].max_iops_per_db_instance #=> Integer
    #   resp.orderable_db_instance_options[0].min_iops_per_gib #=> Float
    #   resp.orderable_db_instance_options[0].max_iops_per_gib #=> Float
    #   resp.orderable_db_instance_options[0].available_processor_features #=> Array
    #   resp.orderable_db_instance_options[0].available_processor_features[0].name #=> String
    #   resp.orderable_db_instance_options[0].available_processor_features[0].default_value #=> String
    #   resp.orderable_db_instance_options[0].available_processor_features[0].allowed_values #=> String
    #   resp.orderable_db_instance_options[0].supported_engine_modes #=> Array
    #   resp.orderable_db_instance_options[0].supported_engine_modes[0] #=> String
    #   resp.orderable_db_instance_options[0].supports_storage_autoscaling #=> Boolean
    #   resp.orderable_db_instance_options[0].supports_kerberos_authentication #=> Boolean
    #   resp.orderable_db_instance_options[0].outpost_capable #=> Boolean
    #   resp.orderable_db_instance_options[0].supported_activity_stream_modes #=> Array
    #   resp.orderable_db_instance_options[0].supported_activity_stream_modes[0] #=> String
    #   resp.orderable_db_instance_options[0].supports_global_databases #=> Boolean
    #   resp.orderable_db_instance_options[0].supports_clusters #=> Boolean
    #   resp.orderable_db_instance_options[0].supported_network_types #=> Array
    #   resp.orderable_db_instance_options[0].supported_network_types[0] #=> String
    #   resp.orderable_db_instance_options[0].supports_storage_throughput #=> Boolean
    #   resp.orderable_db_instance_options[0].min_storage_throughput_per_db_instance #=> Integer
    #   resp.orderable_db_instance_options[0].max_storage_throughput_per_db_instance #=> Integer
    #   resp.orderable_db_instance_options[0].min_storage_throughput_per_iops #=> Float
    #   resp.orderable_db_instance_options[0].max_storage_throughput_per_iops #=> Float
    #   resp.orderable_db_instance_options[0].supports_dedicated_log_volume #=> Boolean
    #   resp.orderable_db_instance_options[0].supports_http_endpoint #=> Boolean
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions AWS API Documentation
    #
    # @overload describe_orderable_db_instance_options(params = {})
    # @param [Hash] params ({})
    def describe_orderable_db_instance_options(params = {}, options = {})
      req = build_request(:describe_orderable_db_instance_options, params)
      req.send_request(options)
    end

    # Returns a list of resources (for example, DB instances) that have at
    # least one pending maintenance action.
    #
    # This API follows an eventual consistency model. This means that the
    # result of the `DescribePendingMaintenanceActions` command might not be
    # immediately visible to all subsequent RDS commands. Keep this in mind
    # when you use `DescribePendingMaintenanceActions` immediately after
    # using a previous API command such as `ApplyPendingMaintenanceActions`.
    #
    # @option params [String] :resource_identifier
    #   The ARN of a resource to return pending maintenance actions for.
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more resources to return pending
    #   maintenance actions for.
    #
    #   Supported filters:
    #
    #   * `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
    #     Amazon Resource Names (ARNs). The results list only includes pending
    #     maintenance actions for the DB clusters identified by these ARNs.
    #
    #   * `db-instance-id` - Accepts DB instance identifiers and DB instance
    #     ARNs. The results list only includes pending maintenance actions for
    #     the DB instances identified by these ARNs.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribePendingMaintenanceActions` request. If this parameter is
    #   specified, the response includes only records beyond the marker, up to
    #   a number of records specified by `MaxRecords`.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @return [Types::PendingMaintenanceActionsMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::PendingMaintenanceActionsMessage#pending_maintenance_actions #pending_maintenance_actions} => Array&lt;Types::ResourcePendingMaintenanceActions&gt;
    #   * {Types::PendingMaintenanceActionsMessage#marker #marker} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To list resources with at least one pending maintenance action
    #
    #   # The following example lists the pending maintenace action for a DB instance.
    #
    #   resp = client.describe_pending_maintenance_actions({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     pending_maintenance_actions: [
    #       {
    #         pending_maintenance_action_details: [
    #           {
    #             action: "system-update", 
    #             description: "Upgrade to Aurora PostgreSQL 2.4.2", 
    #           }, 
    #         ], 
    #         resource_identifier: "arn:aws:rds:us-west-2:123456789012:cluster:global-db1-cl1", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_pending_maintenance_actions({
    #     resource_identifier: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     marker: "String",
    #     max_records: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.pending_maintenance_actions #=> Array
    #   resp.pending_maintenance_actions[0].resource_identifier #=> String
    #   resp.pending_maintenance_actions[0].pending_maintenance_action_details #=> Array
    #   resp.pending_maintenance_actions[0].pending_maintenance_action_details[0].action #=> String
    #   resp.pending_maintenance_actions[0].pending_maintenance_action_details[0].auto_applied_after_date #=> Time
    #   resp.pending_maintenance_actions[0].pending_maintenance_action_details[0].forced_apply_date #=> Time
    #   resp.pending_maintenance_actions[0].pending_maintenance_action_details[0].opt_in_status #=> String
    #   resp.pending_maintenance_actions[0].pending_maintenance_action_details[0].current_apply_date #=> Time
    #   resp.pending_maintenance_actions[0].pending_maintenance_action_details[0].description #=> String
    #   resp.marker #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions AWS API Documentation
    #
    # @overload describe_pending_maintenance_actions(params = {})
    # @param [Hash] params ({})
    def describe_pending_maintenance_actions(params = {}, options = {})
      req = build_request(:describe_pending_maintenance_actions, params)
      req.send_request(options)
    end

    # Returns information about reserved DB instances for this account, or
    # about a specified reserved DB instance.
    #
    # @option params [String] :reserved_db_instance_id
    #   The reserved DB instance identifier filter value. Specify this
    #   parameter to show only the reservation that matches the specified
    #   reservation ID.
    #
    # @option params [String] :reserved_db_instances_offering_id
    #   The offering identifier filter value. Specify this parameter to show
    #   only purchased reservations matching the specified offering
    #   identifier.
    #
    # @option params [String] :db_instance_class
    #   The DB instance class filter value. Specify this parameter to show
    #   only those reservations matching the specified DB instances class.
    #
    # @option params [String] :duration
    #   The duration filter value, specified in years or seconds. Specify this
    #   parameter to show only reservations for this duration.
    #
    #   Valid Values: `1 | 3 | 31536000 | 94608000`
    #
    # @option params [String] :product_description
    #   The product description filter value. Specify this parameter to show
    #   only those reservations matching the specified product description.
    #
    # @option params [String] :offering_type
    #   The offering type filter value. Specify this parameter to show only
    #   the available offerings matching the specified offering type.
    #
    #   Valid Values: `"Partial Upfront" | "All Upfront" | "No Upfront" `
    #
    # @option params [Boolean] :multi_az
    #   Specifies whether to show only those reservations that support
    #   Multi-AZ.
    #
    # @option params [String] :lease_id
    #   The lease identifier filter value. Specify this parameter to show only
    #   the reservation that matches the specified lease ID.
    #
    #   <note markdown="1"> Amazon Web Services Support might request the lease ID for an issue
    #   related to a reserved DB instance.
    #
    #    </note>
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more than
    #   the `MaxRecords` value is available, a pagination token called a
    #   marker is included in the response so you can retrieve the remaining
    #   results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous request. If this
    #   parameter is specified, the response includes only records beyond the
    #   marker, up to the value specified by `MaxRecords`.
    #
    # @return [Types::ReservedDBInstanceMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ReservedDBInstanceMessage#marker #marker} => String
    #   * {Types::ReservedDBInstanceMessage#reserved_db_instances #reserved_db_instances} => Array&lt;Types::ReservedDBInstance&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe reserved DB instances
    #
    #   # The following example retrieves details about any reserved DB instances in the current AWS account.
    #
    #   resp = client.describe_reserved_db_instances({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     reserved_db_instances: [
    #       {
    #         currency_code: "USD", 
    #         db_instance_class: "db.t3.micro", 
    #         db_instance_count: 1, 
    #         duration: 31536000, 
    #         fixed_price: 0, 
    #         lease_id: "a1b2c3d4-6b69-4a59-be89-5e11aa446666", 
    #         multi_az: false, 
    #         offering_type: "No Upfront", 
    #         product_description: "sqlserver-ex(li)", 
    #         recurring_charges: [
    #           {
    #             recurring_charge_amount: 0.014, 
    #             recurring_charge_frequency: "Hourly", 
    #           }, 
    #         ], 
    #         reserved_db_instance_arn: "arn:aws:rds:us-west-2:123456789012:ri:myreservedinstance", 
    #         reserved_db_instance_id: "myreservedinstance", 
    #         reserved_db_instances_offering_id: "12ab34cd-59af-4b2c-a660-1abcdef23456", 
    #         start_time: Time.parse("2020-06-01T13:44:21.436Z"), 
    #         state: "payment-pending", 
    #         usage_price: 0, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_reserved_db_instances({
    #     reserved_db_instance_id: "String",
    #     reserved_db_instances_offering_id: "String",
    #     db_instance_class: "String",
    #     duration: "String",
    #     product_description: "String",
    #     offering_type: "String",
    #     multi_az: false,
    #     lease_id: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.reserved_db_instances #=> Array
    #   resp.reserved_db_instances[0].reserved_db_instance_id #=> String
    #   resp.reserved_db_instances[0].reserved_db_instances_offering_id #=> String
    #   resp.reserved_db_instances[0].db_instance_class #=> String
    #   resp.reserved_db_instances[0].start_time #=> Time
    #   resp.reserved_db_instances[0].duration #=> Integer
    #   resp.reserved_db_instances[0].fixed_price #=> Float
    #   resp.reserved_db_instances[0].usage_price #=> Float
    #   resp.reserved_db_instances[0].currency_code #=> String
    #   resp.reserved_db_instances[0].db_instance_count #=> Integer
    #   resp.reserved_db_instances[0].product_description #=> String
    #   resp.reserved_db_instances[0].offering_type #=> String
    #   resp.reserved_db_instances[0].multi_az #=> Boolean
    #   resp.reserved_db_instances[0].state #=> String
    #   resp.reserved_db_instances[0].recurring_charges #=> Array
    #   resp.reserved_db_instances[0].recurring_charges[0].recurring_charge_amount #=> Float
    #   resp.reserved_db_instances[0].recurring_charges[0].recurring_charge_frequency #=> String
    #   resp.reserved_db_instances[0].reserved_db_instance_arn #=> String
    #   resp.reserved_db_instances[0].lease_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances AWS API Documentation
    #
    # @overload describe_reserved_db_instances(params = {})
    # @param [Hash] params ({})
    def describe_reserved_db_instances(params = {}, options = {})
      req = build_request(:describe_reserved_db_instances, params)
      req.send_request(options)
    end

    # Lists available reserved DB instance offerings.
    #
    # @option params [String] :reserved_db_instances_offering_id
    #   The offering identifier filter value. Specify this parameter to show
    #   only the available offering that matches the specified reservation
    #   identifier.
    #
    #   Example: `438012d3-4052-4cc7-b2e3-8d3372e0e706`
    #
    # @option params [String] :db_instance_class
    #   The DB instance class filter value. Specify this parameter to show
    #   only the available offerings matching the specified DB instance class.
    #
    # @option params [String] :duration
    #   Duration filter value, specified in years or seconds. Specify this
    #   parameter to show only reservations for this duration.
    #
    #   Valid Values: `1 | 3 | 31536000 | 94608000`
    #
    # @option params [String] :product_description
    #   Product description filter value. Specify this parameter to show only
    #   the available offerings that contain the specified product
    #   description.
    #
    #   <note markdown="1"> The results show offerings that partially match the filter value.
    #
    #    </note>
    #
    # @option params [String] :offering_type
    #   The offering type filter value. Specify this parameter to show only
    #   the available offerings matching the specified offering type.
    #
    #   Valid Values: `"Partial Upfront" | "All Upfront" | "No Upfront" `
    #
    # @option params [Boolean] :multi_az
    #   Specifies whether to show only those reservations that support
    #   Multi-AZ.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more than
    #   the `MaxRecords` value is available, a pagination token called a
    #   marker is included in the response so you can retrieve the remaining
    #   results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous request. If this
    #   parameter is specified, the response includes only records beyond the
    #   marker, up to the value specified by `MaxRecords`.
    #
    # @return [Types::ReservedDBInstancesOfferingMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ReservedDBInstancesOfferingMessage#marker #marker} => String
    #   * {Types::ReservedDBInstancesOfferingMessage#reserved_db_instances_offerings #reserved_db_instances_offerings} => Array&lt;Types::ReservedDBInstancesOffering&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe reserved DB instance offerings
    #
    #   # The following example retrieves details about reserved DB instance options for RDS for Oracle.
    #
    #   resp = client.describe_reserved_db_instances_offerings({
    #     product_description: "oracle", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     reserved_db_instances_offerings: [
    #       {
    #         currency_code: "USD", 
    #         db_instance_class: "db.m4.xlarge", 
    #         duration: 31536000, 
    #         fixed_price: 4089, 
    #         multi_az: true, 
    #         offering_type: "Partial Upfront", 
    #         product_description: "oracle-se2(li)", 
    #         recurring_charges: [
    #           {
    #             recurring_charge_amount: 0.594, 
    #             recurring_charge_frequency: "Hourly", 
    #           }, 
    #         ], 
    #         reserved_db_instances_offering_id: "005bdee3-9ef4-4182-aa0c-58ef7cb6c2f8", 
    #         usage_price: 0, 
    #       }, 
    #     ], # Some output omitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_reserved_db_instances_offerings({
    #     reserved_db_instances_offering_id: "String",
    #     db_instance_class: "String",
    #     duration: "String",
    #     product_description: "String",
    #     offering_type: "String",
    #     multi_az: false,
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     max_records: 1,
    #     marker: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.reserved_db_instances_offerings #=> Array
    #   resp.reserved_db_instances_offerings[0].reserved_db_instances_offering_id #=> String
    #   resp.reserved_db_instances_offerings[0].db_instance_class #=> String
    #   resp.reserved_db_instances_offerings[0].duration #=> Integer
    #   resp.reserved_db_instances_offerings[0].fixed_price #=> Float
    #   resp.reserved_db_instances_offerings[0].usage_price #=> Float
    #   resp.reserved_db_instances_offerings[0].currency_code #=> String
    #   resp.reserved_db_instances_offerings[0].product_description #=> String
    #   resp.reserved_db_instances_offerings[0].offering_type #=> String
    #   resp.reserved_db_instances_offerings[0].multi_az #=> Boolean
    #   resp.reserved_db_instances_offerings[0].recurring_charges #=> Array
    #   resp.reserved_db_instances_offerings[0].recurring_charges[0].recurring_charge_amount #=> Float
    #   resp.reserved_db_instances_offerings[0].recurring_charges[0].recurring_charge_frequency #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings AWS API Documentation
    #
    # @overload describe_reserved_db_instances_offerings(params = {})
    # @param [Hash] params ({})
    def describe_reserved_db_instances_offerings(params = {}, options = {})
      req = build_request(:describe_reserved_db_instances_offerings, params)
      req.send_request(options)
    end

    # Returns a list of the source Amazon Web Services Regions where the
    # current Amazon Web Services Region can create a read replica, copy a
    # DB snapshot from, or replicate automated backups from.
    #
    # Use this operation to determine whether cross-Region features are
    # supported between other Regions and your current Region. This
    # operation supports pagination.
    #
    # To return information about the Regions that are enabled for your
    # account, or all Regions, use the EC2 operation `DescribeRegions`. For
    # more information, see [ DescribeRegions][1] in the *Amazon EC2 API
    # Reference*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html
    #
    # @option params [String] :region_name
    #   The source Amazon Web Services Region name. For example, `us-east-1`.
    #
    #   Constraints:
    #
    #   * Must specify a valid Amazon Web Services Region name.
    #
    #   ^
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so you can retrieve
    #   the remaining results.
    #
    #   Default: 100
    #
    #   Constraints: Minimum 20, maximum 100.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeSourceRegions` request. If this parameter is specified, the
    #   response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @return [Types::SourceRegionMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::SourceRegionMessage#marker #marker} => String
    #   * {Types::SourceRegionMessage#source_regions #source_regions} => Array&lt;Types::SourceRegion&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe source Regions
    #
    #   # The following example retrieves details about all source AWS Regions where the current AWS Region can create a read
    #   # replica, copy a DB snapshot from, or replicate automated backups from. It also shows that automated backups can be
    #   # replicated only from US West (Oregon) to the destination AWS Region, US East (N. Virginia).
    #
    #   resp = client.describe_source_regions({
    #     region_name: "us-east-1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     source_regions: [
    #       {
    #         endpoint: "https://rds.af-south-1.amazonaws.com", 
    #         region_name: "af-south-1", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: false, 
    #       }, 
    #       {
    #         endpoint: "https://rds.ap-east-1.amazonaws.com", 
    #         region_name: "ap-east-1", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: false, 
    #       }, 
    #       {
    #         endpoint: "https://rds.ap-northeast-1.amazonaws.com", 
    #         region_name: "ap-northeast-1", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #       {
    #         endpoint: "https://rds.ap-northeast-2.amazonaws.com", 
    #         region_name: "ap-northeast-2", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #       {
    #         endpoint: "https://rds.ap-northeast-3.amazonaws.com", 
    #         region_name: "ap-northeast-3", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: false, 
    #       }, 
    #       {
    #         endpoint: "https://rds.ap-south-1.amazonaws.com", 
    #         region_name: "ap-south-1", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #       {
    #         endpoint: "https://rds.ap-southeast-1.amazonaws.com", 
    #         region_name: "ap-southeast-1", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #       {
    #         endpoint: "https://rds.ap-southeast-2.amazonaws.com", 
    #         region_name: "ap-southeast-2", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #       {
    #         endpoint: "https://rds.ap-southeast-3.amazonaws.com", 
    #         region_name: "ap-southeast-3", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: false, 
    #       }, 
    #       {
    #         endpoint: "https://rds.ca-central-1.amazonaws.com", 
    #         region_name: "ca-central-1", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #       {
    #         endpoint: "https://rds.eu-north-1.amazonaws.com", 
    #         region_name: "eu-north-1", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #       {
    #         endpoint: "https://rds.eu-south-1.amazonaws.com", 
    #         region_name: "eu-south-1", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: false, 
    #       }, 
    #       {
    #         endpoint: "https://rds.eu-west-1.amazonaws.com", 
    #         region_name: "eu-west-1", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #       {
    #         endpoint: "https://rds.eu-west-2.amazonaws.com", 
    #         region_name: "eu-west-2", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #       {
    #         endpoint: "https://rds.eu-west-3.amazonaws.com", 
    #         region_name: "eu-west-3", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #       {
    #         endpoint: "https://rds.me-central-1.amazonaws.com", 
    #         region_name: "me-central-1", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: false, 
    #       }, 
    #       {
    #         endpoint: "https://rds.me-south-1.amazonaws.com", 
    #         region_name: "me-south-1", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: false, 
    #       }, 
    #       {
    #         endpoint: "https://rds.sa-east-1.amazonaws.com", 
    #         region_name: "sa-east-1", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #       {
    #         endpoint: "https://rds.us-east-2.amazonaws.com", 
    #         region_name: "us-east-2", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #       {
    #         endpoint: "https://rds.us-west-1.amazonaws.com", 
    #         region_name: "us-west-1", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #       {
    #         endpoint: "https://rds.us-west-2.amazonaws.com", 
    #         region_name: "us-west-2", 
    #         status: "available", 
    #         supports_db_instance_automated_backups_replication: true, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_source_regions({
    #     region_name: "String",
    #     max_records: 1,
    #     marker: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.source_regions #=> Array
    #   resp.source_regions[0].region_name #=> String
    #   resp.source_regions[0].endpoint #=> String
    #   resp.source_regions[0].status #=> String
    #   resp.source_regions[0].supports_db_instance_automated_backups_replication #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions AWS API Documentation
    #
    # @overload describe_source_regions(params = {})
    # @param [Hash] params ({})
    def describe_source_regions(params = {}, options = {})
      req = build_request(:describe_source_regions, params)
      req.send_request(options)
    end

    # Describes the tenant databases in a DB instance that uses the
    # multi-tenant configuration. Only RDS for Oracle CDB instances are
    # supported.
    #
    # @option params [String] :db_instance_identifier
    #   The user-supplied DB instance identifier, which must match the
    #   identifier of an existing instance owned by the Amazon Web Services
    #   account. This parameter isn't case-sensitive.
    #
    # @option params [String] :tenant_db_name
    #   The user-supplied tenant database name, which must match the name of
    #   an existing tenant database on the specified DB instance owned by your
    #   Amazon Web Services account. This parameter isn’t case-sensitive.
    #
    # @option params [Array<Types::Filter>] :filters
    #   A filter that specifies one or more database tenants to describe.
    #
    #   Supported filters:
    #
    #   * `tenant-db-name` - Tenant database names. The results list only
    #     includes information about the tenant databases that match these
    #     tenant DB names.
    #
    #   * `tenant-database-resource-id` - Tenant database resource
    #     identifiers.
    #
    #   * `dbi-resource-id` - DB instance resource identifiers. The results
    #     list only includes information about the tenants contained within
    #     the DB instances identified by these resource identifiers.
    #
    # @option params [String] :marker
    #   An optional pagination token provided by a previous
    #   `DescribeTenantDatabases` request. If this parameter is specified, the
    #   response includes only records beyond the marker, up to the value
    #   specified by `MaxRecords`.
    #
    # @option params [Integer] :max_records
    #   The maximum number of records to include in the response. If more
    #   records exist than the specified `MaxRecords` value, a pagination
    #   token called a marker is included in the response so that you can
    #   retrieve the remaining results.
    #
    # @return [Types::TenantDatabasesMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::TenantDatabasesMessage#marker #marker} => String
    #   * {Types::TenantDatabasesMessage#tenant_databases #tenant_databases} => Array&lt;Types::TenantDatabase&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_tenant_databases({
    #     db_instance_identifier: "String",
    #     tenant_db_name: "String",
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #     marker: "String",
    #     max_records: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.marker #=> String
    #   resp.tenant_databases #=> Array
    #   resp.tenant_databases[0].tenant_database_create_time #=> Time
    #   resp.tenant_databases[0].db_instance_identifier #=> String
    #   resp.tenant_databases[0].tenant_db_name #=> String
    #   resp.tenant_databases[0].status #=> String
    #   resp.tenant_databases[0].master_username #=> String
    #   resp.tenant_databases[0].dbi_resource_id #=> String
    #   resp.tenant_databases[0].tenant_database_resource_id #=> String
    #   resp.tenant_databases[0].tenant_database_arn #=> String
    #   resp.tenant_databases[0].character_set_name #=> String
    #   resp.tenant_databases[0].nchar_character_set_name #=> String
    #   resp.tenant_databases[0].deletion_protection #=> Boolean
    #   resp.tenant_databases[0].pending_modified_values.master_user_password #=> String
    #   resp.tenant_databases[0].pending_modified_values.tenant_db_name #=> String
    #   resp.tenant_databases[0].master_user_secret.secret_arn #=> String
    #   resp.tenant_databases[0].master_user_secret.secret_status #=> String
    #   resp.tenant_databases[0].master_user_secret.kms_key_id #=> String
    #   resp.tenant_databases[0].tag_list #=> Array
    #   resp.tenant_databases[0].tag_list[0].key #=> String
    #   resp.tenant_databases[0].tag_list[0].value #=> String
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * tenant_database_available
    #   * tenant_database_deleted
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeTenantDatabases AWS API Documentation
    #
    # @overload describe_tenant_databases(params = {})
    # @param [Hash] params ({})
    def describe_tenant_databases(params = {}, options = {})
      req = build_request(:describe_tenant_databases, params)
      req.send_request(options)
    end

    # You can call `DescribeValidDBInstanceModifications` to learn what
    # modifications you can make to your DB instance. You can use this
    # information when you call `ModifyDBInstance`.
    #
    # This command doesn't apply to RDS Custom.
    #
    # @option params [required, String] :db_instance_identifier
    #   The customer identifier or the ARN of your DB instance.
    #
    # @return [Types::DescribeValidDBInstanceModificationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeValidDBInstanceModificationsResult#valid_db_instance_modifications_message #valid_db_instance_modifications_message} => Types::ValidDBInstanceModificationsMessage
    #
    #
    # @example Example: To describe valid modifications for a DB instance
    #
    #   # The following example retrieves details about the valid modifications for the specified DB instance.
    #
    #   resp = client.describe_valid_db_instance_modifications({
    #     db_instance_identifier: "database-test1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     valid_db_instance_modifications_message: {
    #       storage: [
    #         {
    #           storage_size: [
    #             {
    #               from: 20, 
    #               step: 1, 
    #               to: 20, 
    #             }, 
    #             {
    #               from: 22, 
    #               step: 1, 
    #               to: 6144, 
    #             }, 
    #           ], 
    #           storage_type: "gp2", 
    #         }, 
    #       ], 
    #     }, # Some output omitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_valid_db_instance_modifications({
    #     db_instance_identifier: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.valid_db_instance_modifications_message.storage #=> Array
    #   resp.valid_db_instance_modifications_message.storage[0].storage_type #=> String
    #   resp.valid_db_instance_modifications_message.storage[0].storage_size #=> Array
    #   resp.valid_db_instance_modifications_message.storage[0].storage_size[0].from #=> Integer
    #   resp.valid_db_instance_modifications_message.storage[0].storage_size[0].to #=> Integer
    #   resp.valid_db_instance_modifications_message.storage[0].storage_size[0].step #=> Integer
    #   resp.valid_db_instance_modifications_message.storage[0].provisioned_iops #=> Array
    #   resp.valid_db_instance_modifications_message.storage[0].provisioned_iops[0].from #=> Integer
    #   resp.valid_db_instance_modifications_message.storage[0].provisioned_iops[0].to #=> Integer
    #   resp.valid_db_instance_modifications_message.storage[0].provisioned_iops[0].step #=> Integer
    #   resp.valid_db_instance_modifications_message.storage[0].iops_to_storage_ratio #=> Array
    #   resp.valid_db_instance_modifications_message.storage[0].iops_to_storage_ratio[0].from #=> Float
    #   resp.valid_db_instance_modifications_message.storage[0].iops_to_storage_ratio[0].to #=> Float
    #   resp.valid_db_instance_modifications_message.storage[0].supports_storage_autoscaling #=> Boolean
    #   resp.valid_db_instance_modifications_message.storage[0].provisioned_storage_throughput #=> Array
    #   resp.valid_db_instance_modifications_message.storage[0].provisioned_storage_throughput[0].from #=> Integer
    #   resp.valid_db_instance_modifications_message.storage[0].provisioned_storage_throughput[0].to #=> Integer
    #   resp.valid_db_instance_modifications_message.storage[0].provisioned_storage_throughput[0].step #=> Integer
    #   resp.valid_db_instance_modifications_message.storage[0].storage_throughput_to_iops_ratio #=> Array
    #   resp.valid_db_instance_modifications_message.storage[0].storage_throughput_to_iops_ratio[0].from #=> Float
    #   resp.valid_db_instance_modifications_message.storage[0].storage_throughput_to_iops_ratio[0].to #=> Float
    #   resp.valid_db_instance_modifications_message.valid_processor_features #=> Array
    #   resp.valid_db_instance_modifications_message.valid_processor_features[0].name #=> String
    #   resp.valid_db_instance_modifications_message.valid_processor_features[0].default_value #=> String
    #   resp.valid_db_instance_modifications_message.valid_processor_features[0].allowed_values #=> String
    #   resp.valid_db_instance_modifications_message.supports_dedicated_log_volume #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeValidDBInstanceModifications AWS API Documentation
    #
    # @overload describe_valid_db_instance_modifications(params = {})
    # @param [Hash] params ({})
    def describe_valid_db_instance_modifications(params = {}, options = {})
      req = build_request(:describe_valid_db_instance_modifications, params)
      req.send_request(options)
    end

    # Disables the HTTP endpoint for the specified DB cluster. Disabling
    # this endpoint disables RDS Data API.
    #
    # For more information, see [Using RDS Data API][1] in the *Amazon
    # Aurora User Guide*.
    #
    # <note markdown="1"> This operation applies only to Aurora Serverless v2 and provisioned DB
    # clusters. To disable the HTTP endpoint for Aurora Serverless v1 DB
    # clusters, use the `EnableHttpEndpoint` parameter of the
    # `ModifyDBCluster` operation.
    #
    #  </note>
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html
    #
    # @option params [required, String] :resource_arn
    #   The Amazon Resource Name (ARN) of the DB cluster.
    #
    # @return [Types::DisableHttpEndpointResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DisableHttpEndpointResponse#resource_arn #resource_arn} => String
    #   * {Types::DisableHttpEndpointResponse#http_endpoint_enabled #http_endpoint_enabled} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.disable_http_endpoint({
    #     resource_arn: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.resource_arn #=> String
    #   resp.http_endpoint_enabled #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DisableHttpEndpoint AWS API Documentation
    #
    # @overload disable_http_endpoint(params = {})
    # @param [Hash] params ({})
    def disable_http_endpoint(params = {}, options = {})
      req = build_request(:disable_http_endpoint, params)
      req.send_request(options)
    end

    # Downloads all or a portion of the specified log file, up to 1 MB in
    # size.
    #
    # This command doesn't apply to RDS Custom.
    #
    # <note markdown="1"> This operation uses resources on database instances. Because of this,
    # we recommend publishing database logs to CloudWatch and then using the
    # GetLogEvents operation. For more information, see [GetLogEvents][1] in
    # the *Amazon CloudWatch Logs API Reference*.
    #
    #  </note>
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogEvents.html
    #
    # @option params [required, String] :db_instance_identifier
    #   The customer-assigned name of the DB instance that contains the log
    #   files you want to list.
    #
    #   Constraints:
    #
    #   * Must match the identifier of an existing DBInstance.
    #
    #   ^
    #
    # @option params [required, String] :log_file_name
    #   The name of the log file to be downloaded.
    #
    # @option params [String] :marker
    #   The pagination token provided in the previous request or "0". If the
    #   Marker parameter is specified the response includes only records
    #   beyond the marker until the end of the file or up to NumberOfLines.
    #
    # @option params [Integer] :number_of_lines
    #   The number of lines to download. If the number of lines specified
    #   results in a file over 1 MB in size, the file is truncated at 1 MB in
    #   size.
    #
    #   If the NumberOfLines parameter is specified, then the block of lines
    #   returned can be from the beginning or the end of the log file,
    #   depending on the value of the Marker parameter.
    #
    #   * If neither Marker or NumberOfLines are specified, the entire log
    #     file is returned up to a maximum of 10000 lines, starting with the
    #     most recent log entries first.
    #
    #   * If NumberOfLines is specified and Marker isn't specified, then the
    #     most recent lines from the end of the log file are returned.
    #
    #   * If Marker is specified as "0", then the specified number of lines
    #     from the beginning of the log file are returned.
    #
    #   * You can download the log file in blocks of lines by specifying the
    #     size of the block using the NumberOfLines parameter, and by
    #     specifying a value of "0" for the Marker parameter in your first
    #     request. Include the Marker value returned in the response as the
    #     Marker value for the next request, continuing until the
    #     AdditionalDataPending response element returns false.
    #
    # @return [Types::DownloadDBLogFilePortionDetails] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DownloadDBLogFilePortionDetails#log_file_data #log_file_data} => String
    #   * {Types::DownloadDBLogFilePortionDetails#marker #marker} => String
    #   * {Types::DownloadDBLogFilePortionDetails#additional_data_pending #additional_data_pending} => Boolean
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To download a DB log file
    #
    #   # The following example downloads only the latest part of your log file.
    #
    #   resp = client.download_db_log_file_portion({
    #     db_instance_identifier: "test-instance", 
    #     log_file_name: "log.txt", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.download_db_log_file_portion({
    #     db_instance_identifier: "String", # required
    #     log_file_name: "String", # required
    #     marker: "String",
    #     number_of_lines: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.log_file_data #=> String
    #   resp.marker #=> String
    #   resp.additional_data_pending #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortion AWS API Documentation
    #
    # @overload download_db_log_file_portion(params = {})
    # @param [Hash] params ({})
    def download_db_log_file_portion(params = {}, options = {})
      req = build_request(:download_db_log_file_portion, params)
      req.send_request(options)
    end

    # Enables the HTTP endpoint for the DB cluster. By default, the HTTP
    # endpoint isn't enabled.
    #
    # When enabled, this endpoint provides a connectionless web service API
    # (RDS Data API) for running SQL queries on the Aurora DB cluster. You
    # can also query your database from inside the RDS console with the RDS
    # query editor.
    #
    # For more information, see [Using RDS Data API][1] in the *Amazon
    # Aurora User Guide*.
    #
    # <note markdown="1"> This operation applies only to Aurora Serverless v2 and provisioned DB
    # clusters. To enable the HTTP endpoint for Aurora Serverless v1 DB
    # clusters, use the `EnableHttpEndpoint` parameter of the
    # `ModifyDBCluster` operation.
    #
    #  </note>
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html
    #
    # @option params [required, String] :resource_arn
    #   The Amazon Resource Name (ARN) of the DB cluster.
    #
    # @return [Types::EnableHttpEndpointResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::EnableHttpEndpointResponse#resource_arn #resource_arn} => String
    #   * {Types::EnableHttpEndpointResponse#http_endpoint_enabled #http_endpoint_enabled} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.enable_http_endpoint({
    #     resource_arn: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.resource_arn #=> String
    #   resp.http_endpoint_enabled #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/EnableHttpEndpoint AWS API Documentation
    #
    # @overload enable_http_endpoint(params = {})
    # @param [Hash] params ({})
    def enable_http_endpoint(params = {}, options = {})
      req = build_request(:enable_http_endpoint, params)
      req.send_request(options)
    end

    # Forces a failover for a DB cluster.
    #
    # For an Aurora DB cluster, failover for a DB cluster promotes one of
    # the Aurora Replicas (read-only instances) in the DB cluster to be the
    # primary DB instance (the cluster writer).
    #
    # For a Multi-AZ DB cluster, after RDS terminates the primary DB
    # instance, the internal monitoring system detects that the primary DB
    # instance is unhealthy and promotes a readable standby (read-only
    # instances) in the DB cluster to be the primary DB instance (the
    # cluster writer). Failover times are typically less than 35 seconds.
    #
    # An Amazon Aurora DB cluster automatically fails over to an Aurora
    # Replica, if one exists, when the primary DB instance fails. A Multi-AZ
    # DB cluster automatically fails over to a readable standby DB instance
    # when the primary DB instance fails.
    #
    # To simulate a failure of a primary instance for testing, you can force
    # a failover. Because each instance in a DB cluster has its own endpoint
    # address, make sure to clean up and re-establish any existing
    # connections that use those endpoint addresses when the failover is
    # complete.
    #
    # For more information on Amazon Aurora DB clusters, see [ What is
    # Amazon Aurora?][1] in the *Amazon Aurora User Guide*.
    #
    # For more information on Multi-AZ DB clusters, see [ Multi-AZ DB
    # cluster deployments][2] in the *Amazon RDS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [required, String] :db_cluster_identifier
    #   The identifier of the DB cluster to force a failover for. This
    #   parameter isn't case-sensitive.
    #
    #   Constraints:
    #
    #   * Must match the identifier of an existing DB cluster.
    #
    #   ^
    #
    # @option params [String] :target_db_instance_identifier
    #   The name of the DB instance to promote to the primary DB instance.
    #
    #   Specify the DB instance identifier for an Aurora Replica or a Multi-AZ
    #   readable standby in the DB cluster, for example
    #   `mydbcluster-replica1`.
    #
    #   This setting isn't supported for RDS for MySQL Multi-AZ DB clusters.
    #
    # @return [Types::FailoverDBClusterResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::FailoverDBClusterResult#db_cluster #db_cluster} => Types::DBCluster
    #
    #
    # @example Example: To perform a failover for a DB cluster
    #
    #   # This example performs a failover for the specified DB cluster to the specified DB instance.
    #
    #   resp = client.failover_db_cluster({
    #     db_cluster_identifier: "myaurorainstance-cluster", 
    #     target_db_instance_identifier: "myaurorareplica", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster: {
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.failover_db_cluster({
    #     db_cluster_identifier: "String", # required
    #     target_db_instance_identifier: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster.allocated_storage #=> Integer
    #   resp.db_cluster.availability_zones #=> Array
    #   resp.db_cluster.availability_zones[0] #=> String
    #   resp.db_cluster.backup_retention_period #=> Integer
    #   resp.db_cluster.character_set_name #=> String
    #   resp.db_cluster.database_name #=> String
    #   resp.db_cluster.db_cluster_identifier #=> String
    #   resp.db_cluster.db_cluster_parameter_group #=> String
    #   resp.db_cluster.db_subnet_group #=> String
    #   resp.db_cluster.status #=> String
    #   resp.db_cluster.automatic_restart_time #=> Time
    #   resp.db_cluster.percent_progress #=> String
    #   resp.db_cluster.earliest_restorable_time #=> Time
    #   resp.db_cluster.endpoint #=> String
    #   resp.db_cluster.reader_endpoint #=> String
    #   resp.db_cluster.custom_endpoints #=> Array
    #   resp.db_cluster.custom_endpoints[0] #=> String
    #   resp.db_cluster.multi_az #=> Boolean
    #   resp.db_cluster.engine #=> String
    #   resp.db_cluster.engine_version #=> String
    #   resp.db_cluster.latest_restorable_time #=> Time
    #   resp.db_cluster.port #=> Integer
    #   resp.db_cluster.master_username #=> String
    #   resp.db_cluster.db_cluster_option_group_memberships #=> Array
    #   resp.db_cluster.db_cluster_option_group_memberships[0].db_cluster_option_group_name #=> String
    #   resp.db_cluster.db_cluster_option_group_memberships[0].status #=> String
    #   resp.db_cluster.preferred_backup_window #=> String
    #   resp.db_cluster.preferred_maintenance_window #=> String
    #   resp.db_cluster.replication_source_identifier #=> String
    #   resp.db_cluster.read_replica_identifiers #=> Array
    #   resp.db_cluster.read_replica_identifiers[0] #=> String
    #   resp.db_cluster.status_infos #=> Array
    #   resp.db_cluster.status_infos[0].status_type #=> String
    #   resp.db_cluster.status_infos[0].normal #=> Boolean
    #   resp.db_cluster.status_infos[0].status #=> String
    #   resp.db_cluster.status_infos[0].message #=> String
    #   resp.db_cluster.db_cluster_members #=> Array
    #   resp.db_cluster.db_cluster_members[0].db_instance_identifier #=> String
    #   resp.db_cluster.db_cluster_members[0].is_cluster_writer #=> Boolean
    #   resp.db_cluster.db_cluster_members[0].db_cluster_parameter_group_status #=> String
    #   resp.db_cluster.db_cluster_members[0].promotion_tier #=> Integer
    #   resp.db_cluster.vpc_security_groups #=> Array
    #   resp.db_cluster.vpc_security_groups[0].vpc_security_group_id #=> String
    #   resp.db_cluster.vpc_security_groups[0].status #=> String
    #   resp.db_cluster.hosted_zone_id #=> String
    #   resp.db_cluster.storage_encrypted #=> Boolean
    #   resp.db_cluster.kms_key_id #=> String
    #   resp.db_cluster.db_cluster_resource_id #=> String
    #   resp.db_cluster.db_cluster_arn #=> String
    #   resp.db_cluster.associated_roles #=> Array
    #   resp.db_cluster.associated_roles[0].role_arn #=> String
    #   resp.db_cluster.associated_roles[0].status #=> String
    #   resp.db_cluster.associated_roles[0].feature_name #=> String
    #   resp.db_cluster.iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster.clone_group_id #=> String
    #   resp.db_cluster.cluster_create_time #=> Time
    #   resp.db_cluster.earliest_backtrack_time #=> Time
    #   resp.db_cluster.backtrack_window #=> Integer
    #   resp.db_cluster.backtrack_consumed_change_records #=> Integer
    #   resp.db_cluster.enabled_cloudwatch_logs_exports #=> Array
    #   resp.db_cluster.enabled_cloudwatch_logs_exports[0] #=> String
    #   resp.db_cluster.capacity #=> Integer
    #   resp.db_cluster.engine_mode #=> String
    #   resp.db_cluster.scaling_configuration_info.min_capacity #=> Integer
    #   resp.db_cluster.scaling_configuration_info.max_capacity #=> Integer
    #   resp.db_cluster.scaling_configuration_info.auto_pause #=> Boolean
    #   resp.db_cluster.scaling_configuration_info.seconds_until_auto_pause #=> Integer
    #   resp.db_cluster.scaling_configuration_info.timeout_action #=> String
    #   resp.db_cluster.scaling_configuration_info.seconds_before_timeout #=> Integer
    #   resp.db_cluster.rds_custom_cluster_configuration.interconnect_subnet_id #=> String
    #   resp.db_cluster.rds_custom_cluster_configuration.transit_gateway_multicast_domain_id #=> String
    #   resp.db_cluster.rds_custom_cluster_configuration.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_cluster.deletion_protection #=> Boolean
    #   resp.db_cluster.http_endpoint_enabled #=> Boolean
    #   resp.db_cluster.activity_stream_mode #=> String, one of "sync", "async"
    #   resp.db_cluster.activity_stream_status #=> String, one of "stopped", "starting", "started", "stopping"
    #   resp.db_cluster.activity_stream_kms_key_id #=> String
    #   resp.db_cluster.activity_stream_kinesis_stream_name #=> String
    #   resp.db_cluster.copy_tags_to_snapshot #=> Boolean
    #   resp.db_cluster.cross_account_clone #=> Boolean
    #   resp.db_cluster.domain_memberships #=> Array
    #   resp.db_cluster.domain_memberships[0].domain #=> String
    #   resp.db_cluster.domain_memberships[0].status #=> String
    #   resp.db_cluster.domain_memberships[0].fqdn #=> String
    #   resp.db_cluster.domain_memberships[0].iam_role_name #=> String
    #   resp.db_cluster.domain_memberships[0].ou #=> String
    #   resp.db_cluster.domain_memberships[0].auth_secret_arn #=> String
    #   resp.db_cluster.domain_memberships[0].dns_ips #=> Array
    #   resp.db_cluster.domain_memberships[0].dns_ips[0] #=> String
    #   resp.db_cluster.tag_list #=> Array
    #   resp.db_cluster.tag_list[0].key #=> String
    #   resp.db_cluster.tag_list[0].value #=> String
    #   resp.db_cluster.global_cluster_identifier #=> String
    #   resp.db_cluster.global_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "unknown"
    #   resp.db_cluster.global_write_forwarding_requested #=> Boolean
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable #=> Array
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable[0] #=> String
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable #=> Array
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable[0] #=> String
    #   resp.db_cluster.pending_modified_values.db_cluster_identifier #=> String
    #   resp.db_cluster.pending_modified_values.master_user_password #=> String
    #   resp.db_cluster.pending_modified_values.iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster.pending_modified_values.engine_version #=> String
    #   resp.db_cluster.pending_modified_values.backup_retention_period #=> Integer
    #   resp.db_cluster.pending_modified_values.allocated_storage #=> Integer
    #   resp.db_cluster.pending_modified_values.rds_custom_cluster_configuration.interconnect_subnet_id #=> String
    #   resp.db_cluster.pending_modified_values.rds_custom_cluster_configuration.transit_gateway_multicast_domain_id #=> String
    #   resp.db_cluster.pending_modified_values.rds_custom_cluster_configuration.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_cluster.pending_modified_values.iops #=> Integer
    #   resp.db_cluster.pending_modified_values.storage_type #=> String
    #   resp.db_cluster.pending_modified_values.certificate_details.ca_identifier #=> String
    #   resp.db_cluster.pending_modified_values.certificate_details.valid_till #=> Time
    #   resp.db_cluster.db_cluster_instance_class #=> String
    #   resp.db_cluster.storage_type #=> String
    #   resp.db_cluster.iops #=> Integer
    #   resp.db_cluster.publicly_accessible #=> Boolean
    #   resp.db_cluster.auto_minor_version_upgrade #=> Boolean
    #   resp.db_cluster.monitoring_interval #=> Integer
    #   resp.db_cluster.monitoring_role_arn #=> String
    #   resp.db_cluster.database_insights_mode #=> String, one of "standard", "advanced"
    #   resp.db_cluster.performance_insights_enabled #=> Boolean
    #   resp.db_cluster.performance_insights_kms_key_id #=> String
    #   resp.db_cluster.performance_insights_retention_period #=> Integer
    #   resp.db_cluster.serverless_v2_scaling_configuration.min_capacity #=> Float
    #   resp.db_cluster.serverless_v2_scaling_configuration.max_capacity #=> Float
    #   resp.db_cluster.serverless_v2_scaling_configuration.seconds_until_auto_pause #=> Integer
    #   resp.db_cluster.serverless_v2_platform_version #=> String
    #   resp.db_cluster.network_type #=> String
    #   resp.db_cluster.db_system_id #=> String
    #   resp.db_cluster.master_user_secret.secret_arn #=> String
    #   resp.db_cluster.master_user_secret.secret_status #=> String
    #   resp.db_cluster.master_user_secret.kms_key_id #=> String
    #   resp.db_cluster.io_optimized_next_allowed_modification_time #=> Time
    #   resp.db_cluster.local_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "requested"
    #   resp.db_cluster.aws_backup_recovery_point_arn #=> String
    #   resp.db_cluster.limitless_database.status #=> String, one of "active", "not-in-use", "enabled", "disabled", "enabling", "disabling", "modifying-max-capacity", "error"
    #   resp.db_cluster.limitless_database.min_required_acu #=> Float
    #   resp.db_cluster.storage_throughput #=> Integer
    #   resp.db_cluster.cluster_scalability_type #=> String, one of "standard", "limitless"
    #   resp.db_cluster.certificate_details.ca_identifier #=> String
    #   resp.db_cluster.certificate_details.valid_till #=> Time
    #   resp.db_cluster.engine_lifecycle_support #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverDBCluster AWS API Documentation
    #
    # @overload failover_db_cluster(params = {})
    # @param [Hash] params ({})
    def failover_db_cluster(params = {}, options = {})
      req = build_request(:failover_db_cluster, params)
      req.send_request(options)
    end

    # Promotes the specified secondary DB cluster to be the primary DB
    # cluster in the global database cluster to fail over or switch over a
    # global database. Switchover operations were previously called
    # "managed planned failovers."
    #
    # <note markdown="1"> Although this operation can be used either to fail over or to switch
    # over a global database cluster, its intended use is for global
    # database failover. To switch over a global database cluster, we
    # recommend that you use the SwitchoverGlobalCluster operation instead.
    #
    #  </note>
    #
    # How you use this operation depends on whether you are failing over or
    # switching over your global database cluster:
    #
    # * Failing over - Specify the `AllowDataLoss` parameter and don't
    #   specify the `Switchover` parameter.
    #
    # * Switching over - Specify the `Switchover` parameter or omit it, but
    #   don't specify the `AllowDataLoss` parameter.
    #
    # **About failing over and switching over**
    #
    # While failing over and switching over a global database cluster both
    # change the primary DB cluster, you use these operations for different
    # reasons:
    #
    # * *Failing over* - Use this operation to respond to an unplanned
    #   event, such as a Regional disaster in the primary Region. Failing
    #   over can result in a loss of write transaction data that wasn't
    #   replicated to the chosen secondary before the failover event
    #   occurred. However, the recovery process that promotes a DB instance
    #   on the chosen seconday DB cluster to be the primary writer DB
    #   instance guarantees that the data is in a transactionally consistent
    #   state.
    #
    #   For more information about failing over an Amazon Aurora global
    #   database, see [Performing managed failovers for Aurora global
    #   databases][1] in the *Amazon Aurora User Guide*.
    #
    # * *Switching over* - Use this operation on a healthy global database
    #   cluster for planned events, such as Regional rotation or to fail
    #   back to the original primary DB cluster after a failover operation.
    #   With this operation, there is no data loss.
    #
    #   For more information about switching over an Amazon Aurora global
    #   database, see [Performing switchovers for Aurora global
    #   databases][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-failover.managed-unplanned
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover
    #
    # @option params [required, String] :global_cluster_identifier
    #   The identifier of the global database cluster (Aurora global database)
    #   this operation should apply to. The identifier is the unique key
    #   assigned by the user when the Aurora global database is created. In
    #   other words, it's the name of the Aurora global database.
    #
    #   Constraints:
    #
    #   * Must match the identifier of an existing global database cluster.
    #
    #   ^
    #
    # @option params [required, String] :target_db_cluster_identifier
    #   The identifier of the secondary Aurora DB cluster that you want to
    #   promote to the primary for the global database cluster. Use the Amazon
    #   Resource Name (ARN) for the identifier so that Aurora can locate the
    #   cluster in its Amazon Web Services Region.
    #
    # @option params [Boolean] :allow_data_loss
    #   Specifies whether to allow data loss for this global database cluster
    #   operation. Allowing data loss triggers a global failover operation.
    #
    #   If you don't specify `AllowDataLoss`, the global database cluster
    #   operation defaults to a switchover.
    #
    #   Constraints:
    #
    #   * Can't be specified together with the `Switchover` parameter.
    #
    #   ^
    #
    # @option params [Boolean] :switchover
    #   Specifies whether to switch over this global database cluster.
    #
    #   Constraints:
    #
    #   * Can't be specified together with the `AllowDataLoss` parameter.
    #
    #   ^
    #
    # @return [Types::FailoverGlobalClusterResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::FailoverGlobalClusterResult#global_cluster #global_cluster} => Types::GlobalCluster
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.failover_global_cluster({
    #     global_cluster_identifier: "GlobalClusterIdentifier", # required
    #     target_db_cluster_identifier: "DBClusterIdentifier", # required
    #     allow_data_loss: false,
    #     switchover: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.global_cluster.global_cluster_identifier #=> String
    #   resp.global_cluster.global_cluster_resource_id #=> String
    #   resp.global_cluster.global_cluster_arn #=> String
    #   resp.global_cluster.status #=> String
    #   resp.global_cluster.engine #=> String
    #   resp.global_cluster.engine_version #=> String
    #   resp.global_cluster.engine_lifecycle_support #=> String
    #   resp.global_cluster.database_name #=> String
    #   resp.global_cluster.storage_encrypted #=> Boolean
    #   resp.global_cluster.deletion_protection #=> Boolean
    #   resp.global_cluster.global_cluster_members #=> Array
    #   resp.global_cluster.global_cluster_members[0].db_cluster_arn #=> String
    #   resp.global_cluster.global_cluster_members[0].readers #=> Array
    #   resp.global_cluster.global_cluster_members[0].readers[0] #=> String
    #   resp.global_cluster.global_cluster_members[0].is_writer #=> Boolean
    #   resp.global_cluster.global_cluster_members[0].global_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "unknown"
    #   resp.global_cluster.global_cluster_members[0].synchronization_status #=> String, one of "connected", "pending-resync"
    #   resp.global_cluster.endpoint #=> String
    #   resp.global_cluster.failover_state.status #=> String, one of "pending", "failing-over", "cancelling"
    #   resp.global_cluster.failover_state.from_db_cluster_arn #=> String
    #   resp.global_cluster.failover_state.to_db_cluster_arn #=> String
    #   resp.global_cluster.failover_state.is_data_loss_allowed #=> Boolean
    #   resp.global_cluster.tag_list #=> Array
    #   resp.global_cluster.tag_list[0].key #=> String
    #   resp.global_cluster.tag_list[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverGlobalCluster AWS API Documentation
    #
    # @overload failover_global_cluster(params = {})
    # @param [Hash] params ({})
    def failover_global_cluster(params = {}, options = {})
      req = build_request(:failover_global_cluster, params)
      req.send_request(options)
    end

    # Lists all tags on an Amazon RDS resource.
    #
    # For an overview on tagging an Amazon RDS resource, see [Tagging Amazon
    # RDS Resources][1] in the *Amazon RDS User Guide* or [Tagging Amazon
    # Aurora and Amazon RDS Resources][2] in the *Amazon Aurora User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html
    #
    # @option params [required, String] :resource_name
    #   The Amazon RDS resource with tags to be listed. This value is an
    #   Amazon Resource Name (ARN). For information about creating an ARN, see
    #   [ Constructing an ARN for Amazon RDS][1] in the *Amazon RDS User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing
    #
    # @option params [Array<Types::Filter>] :filters
    #   This parameter isn't currently supported.
    #
    # @return [Types::TagListMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::TagListMessage#tag_list #tag_list} => Array&lt;Types::Tag&gt;
    #
    #
    # @example Example: To list tags on an Amazon RDS resource
    #
    #   # The following example lists all tags on a DB instance.
    #
    #   resp = client.list_tags_for_resource({
    #     resource_name: "arn:aws:rds:us-east-1:123456789012:db:orcl1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     tag_list: [
    #       {
    #         key: "Environment", 
    #         value: "test", 
    #       }, 
    #       {
    #         key: "Name", 
    #         value: "MyDatabase", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.list_tags_for_resource({
    #     resource_name: "String", # required
    #     filters: [
    #       {
    #         name: "String", # required
    #         values: ["String"], # required
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.tag_list #=> Array
    #   resp.tag_list[0].key #=> String
    #   resp.tag_list[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ListTagsForResource AWS API Documentation
    #
    # @overload list_tags_for_resource(params = {})
    # @param [Hash] params ({})
    def list_tags_for_resource(params = {}, options = {})
      req = build_request(:list_tags_for_resource, params)
      req.send_request(options)
    end

    # Changes the audit policy state of a database activity stream to either
    # locked (default) or unlocked. A locked policy is read-only, whereas an
    # unlocked policy is read/write. If your activity stream is started and
    # locked, you can unlock it, customize your audit policy, and then lock
    # your activity stream. Restarting the activity stream isn't required.
    # For more information, see [ Modifying a database activity stream][1]
    # in the *Amazon RDS User Guide*.
    #
    # This operation is supported for RDS for Oracle and Microsoft SQL
    # Server.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.Modifying.html
    #
    # @option params [String] :resource_arn
    #   The Amazon Resource Name (ARN) of the RDS for Oracle or Microsoft SQL
    #   Server DB instance. For example,
    #   `arn:aws:rds:us-east-1:12345667890:db:my-orcl-db`.
    #
    # @option params [String] :audit_policy_state
    #   The audit policy state. When a policy is unlocked, it is read/write.
    #   When it is locked, it is read-only. You can edit your audit policy
    #   only when the activity stream is unlocked or stopped.
    #
    # @return [Types::ModifyActivityStreamResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ModifyActivityStreamResponse#kms_key_id #kms_key_id} => String
    #   * {Types::ModifyActivityStreamResponse#kinesis_stream_name #kinesis_stream_name} => String
    #   * {Types::ModifyActivityStreamResponse#status #status} => String
    #   * {Types::ModifyActivityStreamResponse#mode #mode} => String
    #   * {Types::ModifyActivityStreamResponse#engine_native_audit_fields_included #engine_native_audit_fields_included} => Boolean
    #   * {Types::ModifyActivityStreamResponse#policy_status #policy_status} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_activity_stream({
    #     resource_arn: "String",
    #     audit_policy_state: "locked", # accepts locked, unlocked
    #   })
    #
    # @example Response structure
    #
    #   resp.kms_key_id #=> String
    #   resp.kinesis_stream_name #=> String
    #   resp.status #=> String, one of "stopped", "starting", "started", "stopping"
    #   resp.mode #=> String, one of "sync", "async"
    #   resp.engine_native_audit_fields_included #=> Boolean
    #   resp.policy_status #=> String, one of "locked", "unlocked", "locking-policy", "unlocking-policy"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyActivityStream AWS API Documentation
    #
    # @overload modify_activity_stream(params = {})
    # @param [Hash] params ({})
    def modify_activity_stream(params = {}, options = {})
      req = build_request(:modify_activity_stream, params)
      req.send_request(options)
    end

    # Override the system-default Secure Sockets Layer/Transport Layer
    # Security (SSL/TLS) certificate for Amazon RDS for new DB instances, or
    # remove the override.
    #
    # By using this operation, you can specify an RDS-approved SSL/TLS
    # certificate for new DB instances that is different from the default
    # certificate provided by RDS. You can also use this operation to remove
    # the override, so that new DB instances use the default certificate
    # provided by RDS.
    #
    # You might need to override the default certificate in the following
    # situations:
    #
    # * You already migrated your applications to support the latest
    #   certificate authority (CA) certificate, but the new CA certificate
    #   is not yet the RDS default CA certificate for the specified Amazon
    #   Web Services Region.
    #
    # * RDS has already moved to a new default CA certificate for the
    #   specified Amazon Web Services Region, but you are still in the
    #   process of supporting the new CA certificate. In this case, you
    #   temporarily need additional time to finish your application changes.
    #
    # For more information about rotating your SSL/TLS certificate for RDS
    # DB engines, see [ Rotating Your SSL/TLS Certificate][1] in the *Amazon
    # RDS User Guide*.
    #
    # For more information about rotating your SSL/TLS certificate for
    # Aurora DB engines, see [ Rotating Your SSL/TLS Certificate][2] in the
    # *Amazon Aurora User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html
    #
    # @option params [String] :certificate_identifier
    #   The new default certificate identifier to override the current one
    #   with.
    #
    #   To determine the valid values, use the `describe-certificates` CLI
    #   command or the `DescribeCertificates` API operation.
    #
    # @option params [Boolean] :remove_customer_override
    #   Specifies whether to remove the override for the default certificate.
    #   If the override is removed, the default certificate is the system
    #   default.
    #
    # @return [Types::ModifyCertificatesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ModifyCertificatesResult#certificate #certificate} => Types::Certificate
    #
    #
    # @example Example: To temporarily override the system-default SSL/TLS certificate for new DB instances
    #
    #   # The following example temporarily overrides the system-default SSL/TLS certificate for new DB instances.
    #
    #   resp = client.modify_certificates({
    #     certificate_identifier: "rds-ca-2019", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     certificate: {
    #       certificate_arn: "arn:aws:rds:us-east-1::cert:rds-ca-2019", 
    #       certificate_identifier: "rds-ca-2019", 
    #       certificate_type: "CA", 
    #       customer_override: true, 
    #       customer_override_valid_till: Time.parse("2024-08-22T17:08:50Z"), 
    #       thumbprint: "EXAMPLE123456789012", 
    #       valid_from: Time.parse("2019-09-19T18:16:53Z"), 
    #       valid_till: Time.parse("2024-08-22T17:08:50Z"), 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_certificates({
    #     certificate_identifier: "String",
    #     remove_customer_override: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.certificate.certificate_identifier #=> String
    #   resp.certificate.certificate_type #=> String
    #   resp.certificate.thumbprint #=> String
    #   resp.certificate.valid_from #=> Time
    #   resp.certificate.valid_till #=> Time
    #   resp.certificate.certificate_arn #=> String
    #   resp.certificate.customer_override #=> Boolean
    #   resp.certificate.customer_override_valid_till #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCertificates AWS API Documentation
    #
    # @overload modify_certificates(params = {})
    # @param [Hash] params ({})
    def modify_certificates(params = {}, options = {})
      req = build_request(:modify_certificates, params)
      req.send_request(options)
    end

    # Set the capacity of an Aurora Serverless v1 DB cluster to a specific
    # value.
    #
    # Aurora Serverless v1 scales seamlessly based on the workload on the DB
    # cluster. In some cases, the capacity might not scale fast enough to
    # meet a sudden change in workload, such as a large number of new
    # transactions. Call `ModifyCurrentDBClusterCapacity` to set the
    # capacity explicitly.
    #
    # After this call sets the DB cluster capacity, Aurora Serverless v1 can
    # automatically scale the DB cluster based on the cooldown period for
    # scaling up and the cooldown period for scaling down.
    #
    # For more information about Aurora Serverless v1, see [Using Amazon
    # Aurora Serverless v1][1] in the *Amazon Aurora User Guide*.
    #
    # If you call `ModifyCurrentDBClusterCapacity` with the default
    # `TimeoutAction`, connections that prevent Aurora Serverless v1 from
    # finding a scaling point might be dropped. For more information about
    # scaling points, see [ Autoscaling for Aurora Serverless v1][2] in the
    # *Amazon Aurora User Guide*.
    #
    # <note markdown="1"> This operation only applies to Aurora Serverless v1 DB clusters.
    #
    #  </note>
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling
    #
    # @option params [required, String] :db_cluster_identifier
    #   The DB cluster identifier for the cluster being modified. This
    #   parameter isn't case-sensitive.
    #
    #   Constraints:
    #
    #   * Must match the identifier of an existing DB cluster.
    #
    #   ^
    #
    # @option params [Integer] :capacity
    #   The DB cluster capacity.
    #
    #   When you change the capacity of a paused Aurora Serverless v1 DB
    #   cluster, it automatically resumes.
    #
    #   Constraints:
    #
    #   * For Aurora MySQL, valid capacity values are `1`, `2`, `4`, `8`,
    #     `16`, `32`, `64`, `128`, and `256`.
    #
    #   * For Aurora PostgreSQL, valid capacity values are `2`, `4`, `8`,
    #     `16`, `32`, `64`, `192`, and `384`.
    #
    # @option params [Integer] :seconds_before_timeout
    #   The amount of time, in seconds, that Aurora Serverless v1 tries to
    #   find a scaling point to perform seamless scaling before enforcing the
    #   timeout action. The default is 300.
    #
    #   Specify a value between 10 and 600 seconds.
    #
    # @option params [String] :timeout_action
    #   The action to take when the timeout is reached, either
    #   `ForceApplyCapacityChange` or `RollbackCapacityChange`.
    #
    #   `ForceApplyCapacityChange`, the default, sets the capacity to the
    #   specified value as soon as possible.
    #
    #   `RollbackCapacityChange` ignores the capacity change if a scaling
    #   point isn't found in the timeout period.
    #
    # @return [Types::DBClusterCapacityInfo] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBClusterCapacityInfo#db_cluster_identifier #db_cluster_identifier} => String
    #   * {Types::DBClusterCapacityInfo#pending_capacity #pending_capacity} => Integer
    #   * {Types::DBClusterCapacityInfo#current_capacity #current_capacity} => Integer
    #   * {Types::DBClusterCapacityInfo#seconds_before_timeout #seconds_before_timeout} => Integer
    #   * {Types::DBClusterCapacityInfo#timeout_action #timeout_action} => String
    #
    #
    # @example Example: To scale the capacity of an Aurora Serverless DB cluster
    #
    #   # The following example scales the capacity of an Aurora Serverless DB cluster to 8.
    #
    #   resp = client.modify_current_db_cluster_capacity({
    #     capacity: 8, 
    #     db_cluster_identifier: "mydbcluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     current_capacity: 1, 
    #     db_cluster_identifier: "mydbcluster", 
    #     pending_capacity: 8, 
    #     seconds_before_timeout: 300, 
    #     timeout_action: "ForceApplyCapacityChange", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_current_db_cluster_capacity({
    #     db_cluster_identifier: "String", # required
    #     capacity: 1,
    #     seconds_before_timeout: 1,
    #     timeout_action: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_identifier #=> String
    #   resp.pending_capacity #=> Integer
    #   resp.current_capacity #=> Integer
    #   resp.seconds_before_timeout #=> Integer
    #   resp.timeout_action #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCurrentDBClusterCapacity AWS API Documentation
    #
    # @overload modify_current_db_cluster_capacity(params = {})
    # @param [Hash] params ({})
    def modify_current_db_cluster_capacity(params = {}, options = {})
      req = build_request(:modify_current_db_cluster_capacity, params)
      req.send_request(options)
    end

    # Modifies the status of a custom engine version (CEV). You can find
    # CEVs to modify by calling `DescribeDBEngineVersions`.
    #
    # <note markdown="1"> The MediaImport service that imports files from Amazon S3 to create
    # CEVs isn't integrated with Amazon Web Services CloudTrail. If you
    # turn on data logging for Amazon RDS in CloudTrail, calls to the
    # `ModifyCustomDbEngineVersion` event aren't logged. However, you might
    # see calls from the API gateway that accesses your Amazon S3 bucket.
    # These calls originate from the MediaImport service for the
    # `ModifyCustomDbEngineVersion` event.
    #
    #  </note>
    #
    # For more information, see [Modifying CEV status][1] in the *Amazon RDS
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.modify
    #
    # @option params [required, String] :engine
    #   The database engine. RDS Custom for Oracle supports the following
    #   values:
    #
    #   * `custom-oracle-ee`
    #
    #   * `custom-oracle-ee-cdb`
    #
    #   * `custom-oracle-se2`
    #
    #   * `custom-oracle-se2-cdb`
    #
    # @option params [required, String] :engine_version
    #   The custom engine version (CEV) that you want to modify. This option
    #   is required for RDS Custom for Oracle, but optional for Amazon RDS.
    #   The combination of `Engine` and `EngineVersion` is unique per customer
    #   per Amazon Web Services Region.
    #
    # @option params [String] :description
    #   An optional description of your CEV.
    #
    # @option params [String] :status
    #   The availability status to be assigned to the CEV. Valid values are as
    #   follows:
    #
    #   available
    #
    #   : You can use this CEV to create a new RDS Custom DB instance.
    #
    #   inactive
    #
    #   : You can create a new RDS Custom instance by restoring a DB snapshot
    #     with this CEV. You can't patch or create new instances with this
    #     CEV.
    #
    #   You can change any status to any status. A typical reason to change
    #   status is to prevent the accidental use of a CEV, or to make a
    #   deprecated CEV eligible for use again. For example, you might change
    #   the status of your CEV from `available` to `inactive`, and from
    #   `inactive` back to `available`. To change the availability status of
    #   the CEV, it must not currently be in use by an RDS Custom instance,
    #   snapshot, or automated backup.
    #
    # @return [Types::DBEngineVersion] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBEngineVersion#engine #engine} => String
    #   * {Types::DBEngineVersion#engine_version #engine_version} => String
    #   * {Types::DBEngineVersion#db_parameter_group_family #db_parameter_group_family} => String
    #   * {Types::DBEngineVersion#db_engine_description #db_engine_description} => String
    #   * {Types::DBEngineVersion#db_engine_version_description #db_engine_version_description} => String
    #   * {Types::DBEngineVersion#default_character_set #default_character_set} => Types::CharacterSet
    #   * {Types::DBEngineVersion#image #image} => Types::CustomDBEngineVersionAMI
    #   * {Types::DBEngineVersion#db_engine_media_type #db_engine_media_type} => String
    #   * {Types::DBEngineVersion#supported_character_sets #supported_character_sets} => Array&lt;Types::CharacterSet&gt;
    #   * {Types::DBEngineVersion#supported_nchar_character_sets #supported_nchar_character_sets} => Array&lt;Types::CharacterSet&gt;
    #   * {Types::DBEngineVersion#valid_upgrade_target #valid_upgrade_target} => Array&lt;Types::UpgradeTarget&gt;
    #   * {Types::DBEngineVersion#supported_timezones #supported_timezones} => Array&lt;Types::Timezone&gt;
    #   * {Types::DBEngineVersion#exportable_log_types #exportable_log_types} => Array&lt;String&gt;
    #   * {Types::DBEngineVersion#supports_log_exports_to_cloudwatch_logs #supports_log_exports_to_cloudwatch_logs} => Boolean
    #   * {Types::DBEngineVersion#supports_read_replica #supports_read_replica} => Boolean
    #   * {Types::DBEngineVersion#supported_engine_modes #supported_engine_modes} => Array&lt;String&gt;
    #   * {Types::DBEngineVersion#supported_feature_names #supported_feature_names} => Array&lt;String&gt;
    #   * {Types::DBEngineVersion#status #status} => String
    #   * {Types::DBEngineVersion#supports_parallel_query #supports_parallel_query} => Boolean
    #   * {Types::DBEngineVersion#supports_global_databases #supports_global_databases} => Boolean
    #   * {Types::DBEngineVersion#major_engine_version #major_engine_version} => String
    #   * {Types::DBEngineVersion#database_installation_files_s3_bucket_name #database_installation_files_s3_bucket_name} => String
    #   * {Types::DBEngineVersion#database_installation_files_s3_prefix #database_installation_files_s3_prefix} => String
    #   * {Types::DBEngineVersion#db_engine_version_arn #db_engine_version_arn} => String
    #   * {Types::DBEngineVersion#kms_key_id #kms_key_id} => String
    #   * {Types::DBEngineVersion#create_time #create_time} => Time
    #   * {Types::DBEngineVersion#tag_list #tag_list} => Array&lt;Types::Tag&gt;
    #   * {Types::DBEngineVersion#supports_babelfish #supports_babelfish} => Boolean
    #   * {Types::DBEngineVersion#custom_db_engine_version_manifest #custom_db_engine_version_manifest} => String
    #   * {Types::DBEngineVersion#supports_limitless_database #supports_limitless_database} => Boolean
    #   * {Types::DBEngineVersion#supports_certificate_rotation_without_restart #supports_certificate_rotation_without_restart} => Boolean
    #   * {Types::DBEngineVersion#supported_ca_certificate_identifiers #supported_ca_certificate_identifiers} => Array&lt;String&gt;
    #   * {Types::DBEngineVersion#supports_local_write_forwarding #supports_local_write_forwarding} => Boolean
    #   * {Types::DBEngineVersion#supports_integrations #supports_integrations} => Boolean
    #   * {Types::DBEngineVersion#serverless_v2_features_support #serverless_v2_features_support} => Types::ServerlessV2FeaturesSupport
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_custom_db_engine_version({
    #     engine: "CustomEngineName", # required
    #     engine_version: "CustomEngineVersion", # required
    #     description: "Description",
    #     status: "available", # accepts available, inactive, inactive-except-restore
    #   })
    #
    # @example Response structure
    #
    #   resp.engine #=> String
    #   resp.engine_version #=> String
    #   resp.db_parameter_group_family #=> String
    #   resp.db_engine_description #=> String
    #   resp.db_engine_version_description #=> String
    #   resp.default_character_set.character_set_name #=> String
    #   resp.default_character_set.character_set_description #=> String
    #   resp.image.image_id #=> String
    #   resp.image.status #=> String
    #   resp.db_engine_media_type #=> String
    #   resp.supported_character_sets #=> Array
    #   resp.supported_character_sets[0].character_set_name #=> String
    #   resp.supported_character_sets[0].character_set_description #=> String
    #   resp.supported_nchar_character_sets #=> Array
    #   resp.supported_nchar_character_sets[0].character_set_name #=> String
    #   resp.supported_nchar_character_sets[0].character_set_description #=> String
    #   resp.valid_upgrade_target #=> Array
    #   resp.valid_upgrade_target[0].engine #=> String
    #   resp.valid_upgrade_target[0].engine_version #=> String
    #   resp.valid_upgrade_target[0].description #=> String
    #   resp.valid_upgrade_target[0].auto_upgrade #=> Boolean
    #   resp.valid_upgrade_target[0].is_major_version_upgrade #=> Boolean
    #   resp.valid_upgrade_target[0].supported_engine_modes #=> Array
    #   resp.valid_upgrade_target[0].supported_engine_modes[0] #=> String
    #   resp.valid_upgrade_target[0].supports_parallel_query #=> Boolean
    #   resp.valid_upgrade_target[0].supports_global_databases #=> Boolean
    #   resp.valid_upgrade_target[0].supports_babelfish #=> Boolean
    #   resp.valid_upgrade_target[0].supports_limitless_database #=> Boolean
    #   resp.valid_upgrade_target[0].supports_local_write_forwarding #=> Boolean
    #   resp.valid_upgrade_target[0].supports_integrations #=> Boolean
    #   resp.supported_timezones #=> Array
    #   resp.supported_timezones[0].timezone_name #=> String
    #   resp.exportable_log_types #=> Array
    #   resp.exportable_log_types[0] #=> String
    #   resp.supports_log_exports_to_cloudwatch_logs #=> Boolean
    #   resp.supports_read_replica #=> Boolean
    #   resp.supported_engine_modes #=> Array
    #   resp.supported_engine_modes[0] #=> String
    #   resp.supported_feature_names #=> Array
    #   resp.supported_feature_names[0] #=> String
    #   resp.status #=> String
    #   resp.supports_parallel_query #=> Boolean
    #   resp.supports_global_databases #=> Boolean
    #   resp.major_engine_version #=> String
    #   resp.database_installation_files_s3_bucket_name #=> String
    #   resp.database_installation_files_s3_prefix #=> String
    #   resp.db_engine_version_arn #=> String
    #   resp.kms_key_id #=> String
    #   resp.create_time #=> Time
    #   resp.tag_list #=> Array
    #   resp.tag_list[0].key #=> String
    #   resp.tag_list[0].value #=> String
    #   resp.supports_babelfish #=> Boolean
    #   resp.custom_db_engine_version_manifest #=> String
    #   resp.supports_limitless_database #=> Boolean
    #   resp.supports_certificate_rotation_without_restart #=> Boolean
    #   resp.supported_ca_certificate_identifiers #=> Array
    #   resp.supported_ca_certificate_identifiers[0] #=> String
    #   resp.supports_local_write_forwarding #=> Boolean
    #   resp.supports_integrations #=> Boolean
    #   resp.serverless_v2_features_support.min_capacity #=> Float
    #   resp.serverless_v2_features_support.max_capacity #=> Float
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCustomDBEngineVersion AWS API Documentation
    #
    # @overload modify_custom_db_engine_version(params = {})
    # @param [Hash] params ({})
    def modify_custom_db_engine_version(params = {}, options = {})
      req = build_request(:modify_custom_db_engine_version, params)
      req.send_request(options)
    end

    # Modifies the settings of an Amazon Aurora DB cluster or a Multi-AZ DB
    # cluster. You can change one or more settings by specifying these
    # parameters and the new values in the request.
    #
    # For more information on Amazon Aurora DB clusters, see [ What is
    # Amazon Aurora?][1] in the *Amazon Aurora User Guide*.
    #
    # For more information on Multi-AZ DB clusters, see [ Multi-AZ DB
    # cluster deployments][2] in the *Amazon RDS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [required, String] :db_cluster_identifier
    #   The DB cluster identifier for the cluster being modified. This
    #   parameter isn't case-sensitive.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Constraints:
    #
    #   * Must match the identifier of an existing DB cluster.
    #
    #   ^
    #
    # @option params [String] :new_db_cluster_identifier
    #   The new DB cluster identifier for the DB cluster when renaming a DB
    #   cluster. This value is stored as a lowercase string.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Constraints:
    #
    #   * Must contain from 1 to 63 letters, numbers, or hyphens.
    #
    #   * The first character must be a letter.
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens.
    #
    #   Example: `my-cluster2`
    #
    # @option params [Boolean] :apply_immediately
    #   Specifies whether the modifications in this request are asynchronously
    #   applied as soon as possible, regardless of the
    #   `PreferredMaintenanceWindow` setting for the DB cluster. If this
    #   parameter is disabled, changes to the DB cluster are applied during
    #   the next maintenance window.
    #
    #   Most modifications can be applied immediately or during the next
    #   scheduled maintenance window. Some modifications, such as turning on
    #   deletion protection and changing the master password, are applied
    #   immediately—regardless of when you choose to apply them.
    #
    #   By default, this parameter is disabled.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [Integer] :backup_retention_period
    #   The number of days for which automated backups are retained. Specify a
    #   minimum value of `1`.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Default: `1`
    #
    #   Constraints:
    #
    #   * Must be a value from 1 to 35.
    #
    #   ^
    #
    # @option params [String] :db_cluster_parameter_group_name
    #   The name of the DB cluster parameter group to use for the DB cluster.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [Array<String>] :vpc_security_group_ids
    #   A list of EC2 VPC security groups to associate with this DB cluster.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [Integer] :port
    #   The port number on which the DB cluster accepts connections.
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    #   Valid Values: `1150-65535`
    #
    #   Default: The same port as the original DB cluster.
    #
    # @option params [String] :master_user_password
    #   The new password for the master database user.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Constraints:
    #
    #   * Must contain from 8 to 41 characters.
    #
    #   * Can contain any printable ASCII character except "/", """, or
    #     "@".
    #
    #   * Can't be specified if `ManageMasterUserPassword` is turned on.
    #
    # @option params [String] :option_group_name
    #   The option group to associate the DB cluster with.
    #
    #   DB clusters are associated with a default option group that can't be
    #   modified.
    #
    # @option params [String] :preferred_backup_window
    #   The daily time range during which automated backups are created if
    #   automated backups are enabled, using the `BackupRetentionPeriod`
    #   parameter.
    #
    #   The default is a 30-minute window selected at random from an 8-hour
    #   block of time for each Amazon Web Services Region. To view the time
    #   blocks available, see [ Backup window][1] in the *Amazon Aurora User
    #   Guide*.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Constraints:
    #
    #   * Must be in the format `hh24:mi-hh24:mi`.
    #
    #   * Must be in Universal Coordinated Time (UTC).
    #
    #   * Must not conflict with the preferred maintenance window.
    #
    #   * Must be at least 30 minutes.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow
    #
    # @option params [String] :preferred_maintenance_window
    #   The weekly time range during which system maintenance can occur, in
    #   Universal Coordinated Time (UTC).
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   The default is a 30-minute window selected at random from an 8-hour
    #   block of time for each Amazon Web Services Region, occurring on a
    #   random day of the week. To see the time blocks available, see [
    #   Adjusting the Preferred DB Cluster Maintenance Window][1] in the
    #   *Amazon Aurora User Guide*.
    #
    #   Constraints:
    #
    #   * Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
    #
    #   * Days must be one of `Mon | Tue | Wed | Thu | Fri | Sat | Sun`.
    #
    #   * Must be in Universal Coordinated Time (UTC).
    #
    #   * Must be at least 30 minutes.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora
    #
    # @option params [Boolean] :enable_iam_database_authentication
    #   Specifies whether to enable mapping of Amazon Web Services Identity
    #   and Access Management (IAM) accounts to database accounts. By default,
    #   mapping isn't enabled.
    #
    #   For more information, see [ IAM Database Authentication][1] in the
    #   *Amazon Aurora User Guide* or [IAM database authentication for
    #   MariaDB, MySQL, and PostgreSQL][2] in the *Amazon RDS User Guide*.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html
    #
    # @option params [Integer] :backtrack_window
    #   The target backtrack window, in seconds. To disable backtracking, set
    #   this value to `0`.
    #
    #   Valid for Cluster Type: Aurora MySQL DB clusters only
    #
    #   Default: `0`
    #
    #   Constraints:
    #
    #   * If specified, this value must be set to a number from 0 to 259,200
    #     (72 hours).
    #
    #   ^
    #
    # @option params [Types::CloudwatchLogsExportConfiguration] :cloudwatch_logs_export_configuration
    #   The configuration setting for the log types to be enabled for export
    #   to CloudWatch Logs for a specific DB cluster.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   The following values are valid for each DB engine:
    #
    #   * Aurora MySQL - `audit | error | general | instance | slowquery |
    #     iam-db-auth-error`
    #
    #   * Aurora PostgreSQL - `instance | postgresql | iam-db-auth-error`
    #
    #   * RDS for MySQL - `error | general | slowquery | iam-db-auth-error`
    #
    #   * RDS for PostgreSQL - `postgresql | upgrade | iam-db-auth-error`
    #
    #   For more information about exporting CloudWatch Logs for Amazon RDS,
    #   see [ Publishing Database Logs to Amazon CloudWatch Logs][1] in the
    #   *Amazon RDS User Guide*.
    #
    #   For more information about exporting CloudWatch Logs for Amazon
    #   Aurora, see [Publishing Database Logs to Amazon CloudWatch Logs][2] in
    #   the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch
    #
    # @option params [String] :engine_version
    #   The version number of the database engine to which you want to
    #   upgrade. Changing this parameter results in an outage. The change is
    #   applied during the next maintenance window unless `ApplyImmediately`
    #   is enabled.
    #
    #   If the cluster that you're modifying has one or more read replicas,
    #   all replicas must be running an engine version that's the same or
    #   later than the version you specify.
    #
    #   To list all of the available engine versions for Aurora MySQL, use the
    #   following command:
    #
    #   `aws rds describe-db-engine-versions --engine aurora-mysql --query
    #   "DBEngineVersions[].EngineVersion"`
    #
    #   To list all of the available engine versions for Aurora PostgreSQL,
    #   use the following command:
    #
    #   `aws rds describe-db-engine-versions --engine aurora-postgresql
    #   --query "DBEngineVersions[].EngineVersion"`
    #
    #   To list all of the available engine versions for RDS for MySQL, use
    #   the following command:
    #
    #   `aws rds describe-db-engine-versions --engine mysql --query
    #   "DBEngineVersions[].EngineVersion"`
    #
    #   To list all of the available engine versions for RDS for PostgreSQL,
    #   use the following command:
    #
    #   `aws rds describe-db-engine-versions --engine postgres --query
    #   "DBEngineVersions[].EngineVersion"`
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [Boolean] :allow_major_version_upgrade
    #   Specifies whether major version upgrades are allowed.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Constraints:
    #
    #   * You must allow major version upgrades when specifying a value for
    #     the `EngineVersion` parameter that is a different major version than
    #     the DB cluster's current version.
    #
    #   ^
    #
    # @option params [String] :db_instance_parameter_group_name
    #   The name of the DB parameter group to apply to all instances of the DB
    #   cluster.
    #
    #   <note markdown="1"> When you apply a parameter group using the
    #   `DBInstanceParameterGroupName` parameter, the DB cluster isn't
    #   rebooted automatically. Also, parameter changes are applied
    #   immediately rather than during the next maintenance window.
    #
    #    </note>
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    #   Default: The existing name setting
    #
    #   Constraints:
    #
    #   * The DB parameter group must be in the same DB parameter group family
    #     as this DB cluster.
    #
    #   * The `DBInstanceParameterGroupName` parameter is valid in combination
    #     with the `AllowMajorVersionUpgrade` parameter for a major version
    #     upgrade only.
    #
    # @option params [String] :domain
    #   The Active Directory directory ID to move the DB cluster to. Specify
    #   `none` to remove the cluster from its current domain. The domain must
    #   be created prior to this operation.
    #
    #   For more information, see [Kerberos Authentication][1] in the *Amazon
    #   Aurora User Guide*.
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html
    #
    # @option params [String] :domain_iam_role_name
    #   The name of the IAM role to use when making API calls to the Directory
    #   Service.
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    # @option params [Types::ScalingConfiguration] :scaling_configuration
    #   The scaling properties of the DB cluster. You can only modify scaling
    #   properties for DB clusters in `serverless` DB engine mode.
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    # @option params [Boolean] :deletion_protection
    #   Specifies whether the DB cluster has deletion protection enabled. The
    #   database can't be deleted when deletion protection is enabled. By
    #   default, deletion protection isn't enabled.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [Boolean] :enable_http_endpoint
    #   Specifies whether to enable the HTTP endpoint for an Aurora Serverless
    #   v1 DB cluster. By default, the HTTP endpoint isn't enabled.
    #
    #   When enabled, the HTTP endpoint provides a connectionless web service
    #   API (RDS Data API) for running SQL queries on the Aurora Serverless v1
    #   DB cluster. You can also query your database from inside the RDS
    #   console with the RDS query editor.
    #
    #   For more information, see [Using RDS Data API][1] in the *Amazon
    #   Aurora User Guide*.
    #
    #   <note markdown="1"> This parameter applies only to Aurora Serverless v1 DB clusters. To
    #   enable or disable the HTTP endpoint for an Aurora Serverless v2 or
    #   provisioned DB cluster, use the `EnableHttpEndpoint` and
    #   `DisableHttpEndpoint` operations.
    #
    #    </note>
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html
    #
    # @option params [Boolean] :copy_tags_to_snapshot
    #   Specifies whether to copy all tags from the DB cluster to snapshots of
    #   the DB cluster. The default is not to copy them.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [Boolean] :enable_global_write_forwarding
    #   Specifies whether to enable this DB cluster to forward write
    #   operations to the primary cluster of a global cluster (Aurora global
    #   database). By default, write operations are not allowed on Aurora DB
    #   clusters that are secondary clusters in an Aurora global database.
    #
    #   You can set this value only on Aurora DB clusters that are members of
    #   an Aurora global database. With this parameter enabled, a secondary
    #   cluster can forward writes to the current primary cluster, and the
    #   resulting changes are replicated back to this cluster. For the primary
    #   DB cluster of an Aurora global database, this value is used
    #   immediately if the primary is demoted by a global cluster API
    #   operation, but it does nothing until then.
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    # @option params [String] :db_cluster_instance_class
    #   The compute and memory capacity of each DB instance in the Multi-AZ DB
    #   cluster, for example `db.m6gd.xlarge`. Not all DB instance classes are
    #   available in all Amazon Web Services Regions, or for all database
    #   engines.
    #
    #   For the full list of DB instance classes and availability for your
    #   engine, see [ DB Instance Class][1] in the *Amazon RDS User Guide*.
    #
    #   Valid for Cluster Type: Multi-AZ DB clusters only
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html
    #
    # @option params [Integer] :allocated_storage
    #   The amount of storage in gibibytes (GiB) to allocate to each DB
    #   instance in the Multi-AZ DB cluster.
    #
    #   Valid for Cluster Type: Multi-AZ DB clusters only
    #
    # @option params [String] :storage_type
    #   The storage type to associate with the DB cluster.
    #
    #   For information on storage types for Aurora DB clusters, see [Storage
    #   configurations for Amazon Aurora DB clusters][1]. For information on
    #   storage types for Multi-AZ DB clusters, see [Settings for creating
    #   Multi-AZ DB clusters][2].
    #
    #   When specified for a Multi-AZ DB cluster, a value for the `Iops`
    #   parameter is required.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Valid Values:
    #
    #   * Aurora DB clusters - `aurora | aurora-iopt1`
    #
    #   * Multi-AZ DB clusters - `io1 | io2 | gp3`
    #
    #   Default:
    #
    #   * Aurora DB clusters - `aurora`
    #
    #   * Multi-AZ DB clusters - `io1`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings
    #
    # @option params [Integer] :iops
    #   The amount of Provisioned IOPS (input/output operations per second) to
    #   be initially allocated for each DB instance in the Multi-AZ DB
    #   cluster.
    #
    #   For information about valid IOPS values, see [Amazon RDS Provisioned
    #   IOPS storage][1] in the *Amazon RDS User Guide*.
    #
    #   Valid for Cluster Type: Multi-AZ DB clusters only
    #
    #   Constraints:
    #
    #   * Must be a multiple between .5 and 50 of the storage amount for the
    #     DB cluster.
    #
    #   ^
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS
    #
    # @option params [Boolean] :auto_minor_version_upgrade
    #   Specifies whether minor engine upgrades are applied automatically to
    #   the DB cluster during the maintenance window. By default, minor engine
    #   upgrades are applied automatically.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters.
    #
    #   For more information about automatic minor version upgrades, see
    #   [Automatically upgrading the minor engine version][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades
    #
    # @option params [Integer] :monitoring_interval
    #   The interval, in seconds, between points when Enhanced Monitoring
    #   metrics are collected for the DB cluster. To turn off collecting
    #   Enhanced Monitoring metrics, specify `0`.
    #
    #   If `MonitoringRoleArn` is specified, also set `MonitoringInterval` to
    #   a value other than `0`.
    #
    #   Valid for Cluster Type: Multi-AZ DB clusters only
    #
    #   Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
    #
    #   Default: `0`
    #
    # @option params [String] :monitoring_role_arn
    #   The Amazon Resource Name (ARN) for the IAM role that permits RDS to
    #   send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example
    #   is `arn:aws:iam:123456789012:role/emaccess`. For information on
    #   creating a monitoring role, see [To create an IAM role for Amazon RDS
    #   Enhanced Monitoring][1] in the *Amazon RDS User Guide.*
    #
    #   If `MonitoringInterval` is set to a value other than `0`, supply a
    #   `MonitoringRoleArn` value.
    #
    #   Valid for Cluster Type: Multi-AZ DB clusters only
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole
    #
    # @option params [String] :database_insights_mode
    #   Specifies the mode of Database Insights to enable for the DB cluster.
    #
    #   If you change the value from `standard` to `advanced`, you must set
    #   the `PerformanceInsightsEnabled` parameter to `true` and the
    #   `PerformanceInsightsRetentionPeriod` parameter to 465.
    #
    #   If you change the value from `advanced` to `standard`, you must set
    #   the `PerformanceInsightsEnabled` parameter to `false`.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [Boolean] :enable_performance_insights
    #   Specifies whether to turn on Performance Insights for the DB cluster.
    #
    #   For more information, see [ Using Amazon Performance Insights][1] in
    #   the *Amazon RDS User Guide*.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html
    #
    # @option params [String] :performance_insights_kms_key_id
    #   The Amazon Web Services KMS key identifier for encryption of
    #   Performance Insights data.
    #
    #   The Amazon Web Services KMS key identifier is the key ARN, key ID,
    #   alias ARN, or alias name for the KMS key.
    #
    #   If you don't specify a value for `PerformanceInsightsKMSKeyId`, then
    #   Amazon RDS uses your default KMS key. There is a default KMS key for
    #   your Amazon Web Services account. Your Amazon Web Services account has
    #   a different default KMS key for each Amazon Web Services Region.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [Integer] :performance_insights_retention_period
    #   The number of days to retain Performance Insights data.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Valid Values:
    #
    #   * `7`
    #
    #   * *month* * 31, where *month* is a number of months from 1-23.
    #     Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19
    #     months * 31)
    #
    #   * `731`
    #
    #   Default: `7` days
    #
    #   If you specify a retention period that isn't valid, such as `94`,
    #   Amazon RDS issues an error.
    #
    # @option params [Types::ServerlessV2ScalingConfiguration] :serverless_v2_scaling_configuration
    #   Contains the scaling configuration of an Aurora Serverless v2 DB
    #   cluster.
    #
    #   For more information, see [Using Amazon Aurora Serverless v2][1] in
    #   the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html
    #
    # @option params [String] :network_type
    #   The network type of the DB cluster.
    #
    #   The network type is determined by the `DBSubnetGroup` specified for
    #   the DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol
    #   or the IPv4 and the IPv6 protocols (`DUAL`).
    #
    #   For more information, see [ Working with a DB instance in a VPC][1] in
    #   the *Amazon Aurora User Guide.*
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    #   Valid Values: `IPV4 | DUAL`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html
    #
    # @option params [Boolean] :manage_master_user_password
    #   Specifies whether to manage the master user password with Amazon Web
    #   Services Secrets Manager.
    #
    #   If the DB cluster doesn't manage the master user password with Amazon
    #   Web Services Secrets Manager, you can turn on this management. In this
    #   case, you can't specify `MasterUserPassword`.
    #
    #   If the DB cluster already manages the master user password with Amazon
    #   Web Services Secrets Manager, and you specify that the master user
    #   password is not managed with Amazon Web Services Secrets Manager, then
    #   you must specify `MasterUserPassword`. In this case, RDS deletes the
    #   secret and uses the new password for the master user specified by
    #   `MasterUserPassword`.
    #
    #   For more information, see [Password management with Amazon Web
    #   Services Secrets Manager][1] in the *Amazon RDS User Guide* and
    #   [Password management with Amazon Web Services Secrets Manager][2] in
    #   the *Amazon Aurora User Guide.*
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html
    #
    # @option params [Boolean] :rotate_master_user_password
    #   Specifies whether to rotate the secret managed by Amazon Web Services
    #   Secrets Manager for the master user password.
    #
    #   This setting is valid only if the master user password is managed by
    #   RDS in Amazon Web Services Secrets Manager for the DB cluster. The
    #   secret value contains the updated password.
    #
    #   For more information, see [Password management with Amazon Web
    #   Services Secrets Manager][1] in the *Amazon RDS User Guide* and
    #   [Password management with Amazon Web Services Secrets Manager][2] in
    #   the *Amazon Aurora User Guide.*
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    #   Constraints:
    #
    #   * You must apply the change immediately when rotating the master user
    #     password.
    #
    #   ^
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html
    #
    # @option params [String] :master_user_secret_kms_key_id
    #   The Amazon Web Services KMS key identifier to encrypt a secret that is
    #   automatically generated and managed in Amazon Web Services Secrets
    #   Manager.
    #
    #   This setting is valid only if both of the following conditions are
    #   met:
    #
    #   * The DB cluster doesn't manage the master user password in Amazon
    #     Web Services Secrets Manager.
    #
    #     If the DB cluster already manages the master user password in Amazon
    #     Web Services Secrets Manager, you can't change the KMS key that is
    #     used to encrypt the secret.
    #
    #   * You are turning on `ManageMasterUserPassword` to manage the master
    #     user password in Amazon Web Services Secrets Manager.
    #
    #     If you are turning on `ManageMasterUserPassword` and don't specify
    #     `MasterUserSecretKmsKeyId`, then the `aws/secretsmanager` KMS key is
    #     used to encrypt the secret. If the secret is in a different Amazon
    #     Web Services account, then you can't use the `aws/secretsmanager`
    #     KMS key to encrypt the secret, and you must use a customer managed
    #     KMS key.
    #
    #   The Amazon Web Services KMS key identifier is the key ARN, key ID,
    #   alias ARN, or alias name for the KMS key. To use a KMS key in a
    #   different Amazon Web Services account, specify the key ARN or alias
    #   ARN.
    #
    #   There is a default KMS key for your Amazon Web Services account. Your
    #   Amazon Web Services account has a different default KMS key for each
    #   Amazon Web Services Region.
    #
    #   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
    #
    # @option params [String] :engine_mode
    #   The DB engine mode of the DB cluster, either `provisioned` or
    #   `serverless`.
    #
    #   <note markdown="1"> The DB engine mode can be modified only from `serverless` to
    #   `provisioned`.
    #
    #    </note>
    #
    #   For more information, see [ CreateDBCluster][1].
    #
    #   Valid for Cluster Type: Aurora DB clusters only
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html
    #
    # @option params [Boolean] :allow_engine_mode_change
    #   Specifies whether engine mode changes from `serverless` to
    #   `provisioned` are allowed.
    #
    #   Valid for Cluster Type: Aurora Serverless v1 DB clusters only
    #
    #   Constraints:
    #
    #   * You must allow engine mode changes when specifying a different value
    #     for the `EngineMode` parameter from the DB cluster's current engine
    #     mode.
    #
    #   ^
    #
    # @option params [Boolean] :enable_local_write_forwarding
    #   Specifies whether read replicas can forward write operations to the
    #   writer DB instance in the DB cluster. By default, write operations
    #   aren't allowed on reader DB instances.
    #
    #   Valid for: Aurora DB clusters only
    #
    # @option params [String] :aws_backup_recovery_point_arn
    #   The Amazon Resource Name (ARN) of the recovery point in Amazon Web
    #   Services Backup.
    #
    # @option params [Boolean] :enable_limitless_database
    #   Specifies whether to enable Aurora Limitless Database. You must enable
    #   Aurora Limitless Database to create a DB shard group.
    #
    #   Valid for: Aurora DB clusters only
    #
    #   <note markdown="1"> This setting is no longer used. Instead use the
    #   `ClusterScalabilityType` setting when you create your Aurora Limitless
    #   Database DB cluster.
    #
    #    </note>
    #
    # @option params [String] :ca_certificate_identifier
    #   The CA certificate identifier to use for the DB cluster's server
    #   certificate.
    #
    #   For more information, see [Using SSL/TLS to encrypt a connection to a
    #   DB instance][1] in the *Amazon RDS User Guide*.
    #
    #   Valid for Cluster Type: Multi-AZ DB clusters
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html
    #
    # @return [Types::ModifyDBClusterResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ModifyDBClusterResult#db_cluster #db_cluster} => Types::DBCluster
    #
    #
    # @example Example: To modify a DB cluster
    #
    #   # The following example changes the master user password for the DB cluster named cluster-2 and sets the backup retention
    #   # period to 14 days. The ApplyImmediately parameter causes the changes to be made immediately, instead of waiting until
    #   # the next maintenance window.
    #
    #   resp = client.modify_db_cluster({
    #     apply_immediately: true, 
    #     backup_retention_period: 14, 
    #     db_cluster_identifier: "cluster-2", 
    #     master_user_password: "newpassword99", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster: {
    #       allocated_storage: 1, 
    #       associated_roles: [
    #       ], 
    #       availability_zones: [
    #         "eu-central-1b", 
    #         "eu-central-1c", 
    #         "eu-central-1a", 
    #       ], 
    #       backup_retention_period: 14, 
    #       cluster_create_time: Time.parse("2020-04-03T14:44:02.764Z"), 
    #       copy_tags_to_snapshot: true, 
    #       cross_account_clone: false, 
    #       db_cluster_arn: "arn:aws:rds:eu-central-1:123456789012:cluster:cluster-2", 
    #       db_cluster_identifier: "cluster-2", 
    #       db_cluster_members: [
    #         {
    #           db_cluster_parameter_group_status: "in-sync", 
    #           db_instance_identifier: "cluster-2-instance-1", 
    #           is_cluster_writer: true, 
    #           promotion_tier: 1, 
    #         }, 
    #       ], 
    #       db_cluster_parameter_group: "default.aurora5.6", 
    #       db_subnet_group: "default-vpc-2305ca49", 
    #       database_name: "", 
    #       db_cluster_resource_id: "cluster-AGJ7XI77XVIS6FUXHU1EXAMPLE", 
    #       deletion_protection: false, 
    #       domain_memberships: [
    #       ], 
    #       earliest_restorable_time: Time.parse("2020-06-03T02:07:29.637Z"), 
    #       endpoint: "cluster-2.cluster-############.eu-central-1.rds.amazonaws.com", 
    #       engine: "aurora", 
    #       engine_mode: "provisioned", 
    #       engine_version: "5.6.10a", 
    #       hosted_zone_id: "Z1RLNU0EXAMPLE", 
    #       http_endpoint_enabled: false, 
    #       iam_database_authentication_enabled: false, 
    #       kms_key_id: "arn:aws:kms:eu-central-1:123456789012:key/d1bd7c8f-5cdb-49ca-8a62-a1b2c3d4e5f6", 
    #       latest_restorable_time: Time.parse("2020-06-04T15:11:25.748Z"), 
    #       master_username: "admin", 
    #       multi_az: false, 
    #       port: 3306, 
    #       preferred_backup_window: "01:55-02:25", 
    #       preferred_maintenance_window: "thu:21:14-thu:21:44", 
    #       read_replica_identifiers: [
    #       ], 
    #       reader_endpoint: "cluster-2.cluster-ro-############.eu-central-1.rds.amazonaws.com", 
    #       status: "available", 
    #       storage_encrypted: true, 
    #       vpc_security_groups: [
    #         {
    #           status: "active", 
    #           vpc_security_group_id: "sg-20a5c047", 
    #         }, 
    #       ], 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_db_cluster({
    #     db_cluster_identifier: "String", # required
    #     new_db_cluster_identifier: "String",
    #     apply_immediately: false,
    #     backup_retention_period: 1,
    #     db_cluster_parameter_group_name: "String",
    #     vpc_security_group_ids: ["String"],
    #     port: 1,
    #     master_user_password: "String",
    #     option_group_name: "String",
    #     preferred_backup_window: "String",
    #     preferred_maintenance_window: "String",
    #     enable_iam_database_authentication: false,
    #     backtrack_window: 1,
    #     cloudwatch_logs_export_configuration: {
    #       enable_log_types: ["String"],
    #       disable_log_types: ["String"],
    #     },
    #     engine_version: "String",
    #     allow_major_version_upgrade: false,
    #     db_instance_parameter_group_name: "String",
    #     domain: "String",
    #     domain_iam_role_name: "String",
    #     scaling_configuration: {
    #       min_capacity: 1,
    #       max_capacity: 1,
    #       auto_pause: false,
    #       seconds_until_auto_pause: 1,
    #       timeout_action: "String",
    #       seconds_before_timeout: 1,
    #     },
    #     deletion_protection: false,
    #     enable_http_endpoint: false,
    #     copy_tags_to_snapshot: false,
    #     enable_global_write_forwarding: false,
    #     db_cluster_instance_class: "String",
    #     allocated_storage: 1,
    #     storage_type: "String",
    #     iops: 1,
    #     auto_minor_version_upgrade: false,
    #     monitoring_interval: 1,
    #     monitoring_role_arn: "String",
    #     database_insights_mode: "standard", # accepts standard, advanced
    #     enable_performance_insights: false,
    #     performance_insights_kms_key_id: "String",
    #     performance_insights_retention_period: 1,
    #     serverless_v2_scaling_configuration: {
    #       min_capacity: 1.0,
    #       max_capacity: 1.0,
    #       seconds_until_auto_pause: 1,
    #     },
    #     network_type: "String",
    #     manage_master_user_password: false,
    #     rotate_master_user_password: false,
    #     master_user_secret_kms_key_id: "String",
    #     engine_mode: "String",
    #     allow_engine_mode_change: false,
    #     enable_local_write_forwarding: false,
    #     aws_backup_recovery_point_arn: "AwsBackupRecoveryPointArn",
    #     enable_limitless_database: false,
    #     ca_certificate_identifier: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster.allocated_storage #=> Integer
    #   resp.db_cluster.availability_zones #=> Array
    #   resp.db_cluster.availability_zones[0] #=> String
    #   resp.db_cluster.backup_retention_period #=> Integer
    #   resp.db_cluster.character_set_name #=> String
    #   resp.db_cluster.database_name #=> String
    #   resp.db_cluster.db_cluster_identifier #=> String
    #   resp.db_cluster.db_cluster_parameter_group #=> String
    #   resp.db_cluster.db_subnet_group #=> String
    #   resp.db_cluster.status #=> String
    #   resp.db_cluster.automatic_restart_time #=> Time
    #   resp.db_cluster.percent_progress #=> String
    #   resp.db_cluster.earliest_restorable_time #=> Time
    #   resp.db_cluster.endpoint #=> String
    #   resp.db_cluster.reader_endpoint #=> String
    #   resp.db_cluster.custom_endpoints #=> Array
    #   resp.db_cluster.custom_endpoints[0] #=> String
    #   resp.db_cluster.multi_az #=> Boolean
    #   resp.db_cluster.engine #=> String
    #   resp.db_cluster.engine_version #=> String
    #   resp.db_cluster.latest_restorable_time #=> Time
    #   resp.db_cluster.port #=> Integer
    #   resp.db_cluster.master_username #=> String
    #   resp.db_cluster.db_cluster_option_group_memberships #=> Array
    #   resp.db_cluster.db_cluster_option_group_memberships[0].db_cluster_option_group_name #=> String
    #   resp.db_cluster.db_cluster_option_group_memberships[0].status #=> String
    #   resp.db_cluster.preferred_backup_window #=> String
    #   resp.db_cluster.preferred_maintenance_window #=> String
    #   resp.db_cluster.replication_source_identifier #=> String
    #   resp.db_cluster.read_replica_identifiers #=> Array
    #   resp.db_cluster.read_replica_identifiers[0] #=> String
    #   resp.db_cluster.status_infos #=> Array
    #   resp.db_cluster.status_infos[0].status_type #=> String
    #   resp.db_cluster.status_infos[0].normal #=> Boolean
    #   resp.db_cluster.status_infos[0].status #=> String
    #   resp.db_cluster.status_infos[0].message #=> String
    #   resp.db_cluster.db_cluster_members #=> Array
    #   resp.db_cluster.db_cluster_members[0].db_instance_identifier #=> String
    #   resp.db_cluster.db_cluster_members[0].is_cluster_writer #=> Boolean
    #   resp.db_cluster.db_cluster_members[0].db_cluster_parameter_group_status #=> String
    #   resp.db_cluster.db_cluster_members[0].promotion_tier #=> Integer
    #   resp.db_cluster.vpc_security_groups #=> Array
    #   resp.db_cluster.vpc_security_groups[0].vpc_security_group_id #=> String
    #   resp.db_cluster.vpc_security_groups[0].status #=> String
    #   resp.db_cluster.hosted_zone_id #=> String
    #   resp.db_cluster.storage_encrypted #=> Boolean
    #   resp.db_cluster.kms_key_id #=> String
    #   resp.db_cluster.db_cluster_resource_id #=> String
    #   resp.db_cluster.db_cluster_arn #=> String
    #   resp.db_cluster.associated_roles #=> Array
    #   resp.db_cluster.associated_roles[0].role_arn #=> String
    #   resp.db_cluster.associated_roles[0].status #=> String
    #   resp.db_cluster.associated_roles[0].feature_name #=> String
    #   resp.db_cluster.iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster.clone_group_id #=> String
    #   resp.db_cluster.cluster_create_time #=> Time
    #   resp.db_cluster.earliest_backtrack_time #=> Time
    #   resp.db_cluster.backtrack_window #=> Integer
    #   resp.db_cluster.backtrack_consumed_change_records #=> Integer
    #   resp.db_cluster.enabled_cloudwatch_logs_exports #=> Array
    #   resp.db_cluster.enabled_cloudwatch_logs_exports[0] #=> String
    #   resp.db_cluster.capacity #=> Integer
    #   resp.db_cluster.engine_mode #=> String
    #   resp.db_cluster.scaling_configuration_info.min_capacity #=> Integer
    #   resp.db_cluster.scaling_configuration_info.max_capacity #=> Integer
    #   resp.db_cluster.scaling_configuration_info.auto_pause #=> Boolean
    #   resp.db_cluster.scaling_configuration_info.seconds_until_auto_pause #=> Integer
    #   resp.db_cluster.scaling_configuration_info.timeout_action #=> String
    #   resp.db_cluster.scaling_configuration_info.seconds_before_timeout #=> Integer
    #   resp.db_cluster.rds_custom_cluster_configuration.interconnect_subnet_id #=> String
    #   resp.db_cluster.rds_custom_cluster_configuration.transit_gateway_multicast_domain_id #=> String
    #   resp.db_cluster.rds_custom_cluster_configuration.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_cluster.deletion_protection #=> Boolean
    #   resp.db_cluster.http_endpoint_enabled #=> Boolean
    #   resp.db_cluster.activity_stream_mode #=> String, one of "sync", "async"
    #   resp.db_cluster.activity_stream_status #=> String, one of "stopped", "starting", "started", "stopping"
    #   resp.db_cluster.activity_stream_kms_key_id #=> String
    #   resp.db_cluster.activity_stream_kinesis_stream_name #=> String
    #   resp.db_cluster.copy_tags_to_snapshot #=> Boolean
    #   resp.db_cluster.cross_account_clone #=> Boolean
    #   resp.db_cluster.domain_memberships #=> Array
    #   resp.db_cluster.domain_memberships[0].domain #=> String
    #   resp.db_cluster.domain_memberships[0].status #=> String
    #   resp.db_cluster.domain_memberships[0].fqdn #=> String
    #   resp.db_cluster.domain_memberships[0].iam_role_name #=> String
    #   resp.db_cluster.domain_memberships[0].ou #=> String
    #   resp.db_cluster.domain_memberships[0].auth_secret_arn #=> String
    #   resp.db_cluster.domain_memberships[0].dns_ips #=> Array
    #   resp.db_cluster.domain_memberships[0].dns_ips[0] #=> String
    #   resp.db_cluster.tag_list #=> Array
    #   resp.db_cluster.tag_list[0].key #=> String
    #   resp.db_cluster.tag_list[0].value #=> String
    #   resp.db_cluster.global_cluster_identifier #=> String
    #   resp.db_cluster.global_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "unknown"
    #   resp.db_cluster.global_write_forwarding_requested #=> Boolean
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable #=> Array
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable[0] #=> String
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable #=> Array
    #   resp.db_cluster.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable[0] #=> String
    #   resp.db_cluster.pending_modified_values.db_cluster_identifier #=> String
    #   resp.db_cluster.pending_modified_values.master_user_password #=> String
    #   resp.db_cluster.pending_modified_values.iam_database_authentication_enabled #=> Boolean
    #   resp.db_cluster.pending_modified_values.engine_version #=> String
    #   resp.db_cluster.pending_modified_values.backup_retention_period #=> Integer
    #   resp.db_cluster.pending_modified_values.allocated_storage #=> Integer
    #   resp.db_cluster.pending_modified_values.rds_custom_cluster_configuration.interconnect_subnet_id #=> String
    #   resp.db_cluster.pending_modified_values.rds_custom_cluster_configuration.transit_gateway_multicast_domain_id #=> String
    #   resp.db_cluster.pending_modified_values.rds_custom_cluster_configuration.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_cluster.pending_modified_values.iops #=> Integer
    #   resp.db_cluster.pending_modified_values.storage_type #=> String
    #   resp.db_cluster.pending_modified_values.certificate_details.ca_identifier #=> String
    #   resp.db_cluster.pending_modified_values.certificate_details.valid_till #=> Time
    #   resp.db_cluster.db_cluster_instance_class #=> String
    #   resp.db_cluster.storage_type #=> String
    #   resp.db_cluster.iops #=> Integer
    #   resp.db_cluster.publicly_accessible #=> Boolean
    #   resp.db_cluster.auto_minor_version_upgrade #=> Boolean
    #   resp.db_cluster.monitoring_interval #=> Integer
    #   resp.db_cluster.monitoring_role_arn #=> String
    #   resp.db_cluster.database_insights_mode #=> String, one of "standard", "advanced"
    #   resp.db_cluster.performance_insights_enabled #=> Boolean
    #   resp.db_cluster.performance_insights_kms_key_id #=> String
    #   resp.db_cluster.performance_insights_retention_period #=> Integer
    #   resp.db_cluster.serverless_v2_scaling_configuration.min_capacity #=> Float
    #   resp.db_cluster.serverless_v2_scaling_configuration.max_capacity #=> Float
    #   resp.db_cluster.serverless_v2_scaling_configuration.seconds_until_auto_pause #=> Integer
    #   resp.db_cluster.serverless_v2_platform_version #=> String
    #   resp.db_cluster.network_type #=> String
    #   resp.db_cluster.db_system_id #=> String
    #   resp.db_cluster.master_user_secret.secret_arn #=> String
    #   resp.db_cluster.master_user_secret.secret_status #=> String
    #   resp.db_cluster.master_user_secret.kms_key_id #=> String
    #   resp.db_cluster.io_optimized_next_allowed_modification_time #=> Time
    #   resp.db_cluster.local_write_forwarding_status #=> String, one of "enabled", "disabled", "enabling", "disabling", "requested"
    #   resp.db_cluster.aws_backup_recovery_point_arn #=> String
    #   resp.db_cluster.limitless_database.status #=> String, one of "active", "not-in-use", "enabled", "disabled", "enabling", "disabling", "modifying-max-capacity", "error"
    #   resp.db_cluster.limitless_database.min_required_acu #=> Float
    #   resp.db_cluster.storage_throughput #=> Integer
    #   resp.db_cluster.cluster_scalability_type #=> String, one of "standard", "limitless"
    #   resp.db_cluster.certificate_details.ca_identifier #=> String
    #   resp.db_cluster.certificate_details.valid_till #=> Time
    #   resp.db_cluster.engine_lifecycle_support #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBCluster AWS API Documentation
    #
    # @overload modify_db_cluster(params = {})
    # @param [Hash] params ({})
    def modify_db_cluster(params = {}, options = {})
      req = build_request(:modify_db_cluster, params)
      req.send_request(options)
    end

    # Modifies the properties of an endpoint in an Amazon Aurora DB cluster.
    #
    # <note markdown="1"> This operation only applies to Aurora DB clusters.
    #
    #  </note>
    #
    # @option params [required, String] :db_cluster_endpoint_identifier
    #   The identifier of the endpoint to modify. This parameter is stored as
    #   a lowercase string.
    #
    # @option params [String] :endpoint_type
    #   The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
    #
    # @option params [Array<String>] :static_members
    #   List of DB instance identifiers that are part of the custom endpoint
    #   group.
    #
    # @option params [Array<String>] :excluded_members
    #   List of DB instance identifiers that aren't part of the custom
    #   endpoint group. All other eligible instances are reachable through the
    #   custom endpoint. Only relevant if the list of static members is empty.
    #
    # @return [Types::DBClusterEndpoint] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBClusterEndpoint#db_cluster_endpoint_identifier #db_cluster_endpoint_identifier} => String
    #   * {Types::DBClusterEndpoint#db_cluster_identifier #db_cluster_identifier} => String
    #   * {Types::DBClusterEndpoint#db_cluster_endpoint_resource_identifier #db_cluster_endpoint_resource_identifier} => String
    #   * {Types::DBClusterEndpoint#endpoint #endpoint} => String
    #   * {Types::DBClusterEndpoint#status #status} => String
    #   * {Types::DBClusterEndpoint#endpoint_type #endpoint_type} => String
    #   * {Types::DBClusterEndpoint#custom_endpoint_type #custom_endpoint_type} => String
    #   * {Types::DBClusterEndpoint#static_members #static_members} => Array&lt;String&gt;
    #   * {Types::DBClusterEndpoint#excluded_members #excluded_members} => Array&lt;String&gt;
    #   * {Types::DBClusterEndpoint#db_cluster_endpoint_arn #db_cluster_endpoint_arn} => String
    #
    #
    # @example Example: To modify a custom DB cluster endpoint
    #
    #   # The following example modifies the specified custom DB cluster endpoint.
    #
    #   resp = client.modify_db_cluster_endpoint({
    #     db_cluster_endpoint_identifier: "mycustomendpoint", 
    #     static_members: [
    #       "dbinstance1", 
    #       "dbinstance2", 
    #       "dbinstance3", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     custom_endpoint_type: "READER", 
    #     db_cluster_endpoint_arn: "arn:aws:rds:us-east-1:123456789012:cluster-endpoint:mycustomendpoint", 
    #     db_cluster_endpoint_identifier: "mycustomendpoint", 
    #     db_cluster_endpoint_resource_identifier: "cluster-endpoint-ANPAJ4AE5446DAEXAMPLE", 
    #     db_cluster_identifier: "mydbcluster", 
    #     endpoint: "mycustomendpoint.cluster-custom-cnpexample.us-east-1.rds.amazonaws.com", 
    #     endpoint_type: "CUSTOM", 
    #     excluded_members: [
    #     ], 
    #     static_members: [
    #       "dbinstance1", 
    #       "dbinstance2", 
    #       "dbinstance3", 
    #     ], 
    #     status: "modifying", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_db_cluster_endpoint({
    #     db_cluster_endpoint_identifier: "String", # required
    #     endpoint_type: "String",
    #     static_members: ["String"],
    #     excluded_members: ["String"],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_endpoint_identifier #=> String
    #   resp.db_cluster_identifier #=> String
    #   resp.db_cluster_endpoint_resource_identifier #=> String
    #   resp.endpoint #=> String
    #   resp.status #=> String
    #   resp.endpoint_type #=> String
    #   resp.custom_endpoint_type #=> String
    #   resp.static_members #=> Array
    #   resp.static_members[0] #=> String
    #   resp.excluded_members #=> Array
    #   resp.excluded_members[0] #=> String
    #   resp.db_cluster_endpoint_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterEndpoint AWS API Documentation
    #
    # @overload modify_db_cluster_endpoint(params = {})
    # @param [Hash] params ({})
    def modify_db_cluster_endpoint(params = {}, options = {})
      req = build_request(:modify_db_cluster_endpoint, params)
      req.send_request(options)
    end

    # Modifies the parameters of a DB cluster parameter group. To modify
    # more than one parameter, submit a list of the following:
    # `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20
    # parameters can be modified in a single request.
    #
    # After you create a DB cluster parameter group, you should wait at
    # least 5 minutes before creating your first DB cluster that uses that
    # DB cluster parameter group as the default parameter group. This allows
    # Amazon RDS to fully complete the create operation before the parameter
    # group is used as the default for a new DB cluster. This is especially
    # important for parameters that are critical when creating the default
    # database for a DB cluster, such as the character set for the default
    # database defined by the `character_set_database` parameter. You can
    # use the *Parameter Groups* option of the [Amazon RDS console][1] or
    # the `DescribeDBClusterParameters` operation to verify that your DB
    # cluster parameter group has been created or modified.
    #
    #  If the modified DB cluster parameter group is used by an Aurora
    # Serverless v1 cluster, Aurora applies the update immediately. The
    # cluster restart might interrupt your workload. In that case, your
    # application must reopen any connections and retry any transactions
    # that were active when the parameter changes took effect.
    #
    # For more information on Amazon Aurora DB clusters, see [ What is
    # Amazon Aurora?][2] in the *Amazon Aurora User Guide*.
    #
    # For more information on Multi-AZ DB clusters, see [ Multi-AZ DB
    # cluster deployments][3] in the *Amazon RDS User Guide.*
    #
    #
    #
    # [1]: https://console.aws.amazon.com/rds/
    # [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html
    # [3]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html
    #
    # @option params [required, String] :db_cluster_parameter_group_name
    #   The name of the DB cluster parameter group to modify.
    #
    # @option params [required, Array<Types::Parameter>] :parameters
    #   A list of parameters in the DB cluster parameter group to modify.
    #
    #   Valid Values (for the application method): `immediate |
    #   pending-reboot`
    #
    #   <note markdown="1"> You can use the `immediate` value with dynamic parameters only. You
    #   can use the `pending-reboot` value for both dynamic and static
    #   parameters.
    #
    #    When the application method is `immediate`, changes to dynamic
    #   parameters are applied immediately to the DB clusters associated with
    #   the parameter group. When the application method is `pending-reboot`,
    #   changes to dynamic and static parameters are applied after a reboot
    #   without failover to the DB clusters associated with the parameter
    #   group.
    #
    #    </note>
    #
    # @return [Types::DBClusterParameterGroupNameMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBClusterParameterGroupNameMessage#db_cluster_parameter_group_name #db_cluster_parameter_group_name} => String
    #
    #
    # @example Example: To modify parameters in a DB cluster parameter group
    #
    #   # The following example modifies the values of parameters in a DB cluster parameter group.
    #
    #   resp = client.modify_db_cluster_parameter_group({
    #     db_cluster_parameter_group_name: "mydbclusterpg", 
    #     parameters: [
    #       {
    #         apply_method: "immediate", 
    #         parameter_name: "server_audit_logging", 
    #         parameter_value: "1", 
    #       }, 
    #       {
    #         apply_method: "immediate", 
    #         parameter_name: "server_audit_logs_upload", 
    #         parameter_value: "1", 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster_parameter_group_name: "mydbclusterpg", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_db_cluster_parameter_group({
    #     db_cluster_parameter_group_name: "String", # required
    #     parameters: [ # required
    #       {
    #         parameter_name: "String",
    #         parameter_value: "String",
    #         description: "String",
    #         source: "String",
    #         apply_type: "String",
    #         data_type: "String",
    #         allowed_values: "String",
    #         is_modifiable: false,
    #         minimum_engine_version: "String",
    #         apply_method: "immediate", # accepts immediate, pending-reboot
    #         supported_engine_modes: ["String"],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_parameter_group_name #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterParameterGroup AWS API Documentation
    #
    # @overload modify_db_cluster_parameter_group(params = {})
    # @param [Hash] params ({})
    def modify_db_cluster_parameter_group(params = {}, options = {})
      req = build_request(:modify_db_cluster_parameter_group, params)
      req.send_request(options)
    end

    # Adds an attribute and values to, or removes an attribute and values
    # from, a manual DB cluster snapshot.
    #
    # To share a manual DB cluster snapshot with other Amazon Web Services
    # accounts, specify `restore` as the `AttributeName` and use the
    # `ValuesToAdd` parameter to add a list of IDs of the Amazon Web
    # Services accounts that are authorized to restore the manual DB cluster
    # snapshot. Use the value `all` to make the manual DB cluster snapshot
    # public, which means that it can be copied or restored by all Amazon
    # Web Services accounts.
    #
    # <note markdown="1"> Don't add the `all` value for any manual DB cluster snapshots that
    # contain private information that you don't want available to all
    # Amazon Web Services accounts.
    #
    #  </note>
    #
    # If a manual DB cluster snapshot is encrypted, it can be shared, but
    # only by specifying a list of authorized Amazon Web Services account
    # IDs for the `ValuesToAdd` parameter. You can't use `all` as a value
    # for that parameter in this case.
    #
    # To view which Amazon Web Services accounts have access to copy or
    # restore a manual DB cluster snapshot, or whether a manual DB cluster
    # snapshot is public or private, use the
    # DescribeDBClusterSnapshotAttributes API operation. The accounts are
    # returned as values for the `restore` attribute.
    #
    # @option params [required, String] :db_cluster_snapshot_identifier
    #   The identifier for the DB cluster snapshot to modify the attributes
    #   for.
    #
    # @option params [required, String] :attribute_name
    #   The name of the DB cluster snapshot attribute to modify.
    #
    #   To manage authorization for other Amazon Web Services accounts to copy
    #   or restore a manual DB cluster snapshot, set this value to `restore`.
    #
    #   <note markdown="1"> To view the list of attributes available to modify, use the
    #   DescribeDBClusterSnapshotAttributes API operation.
    #
    #    </note>
    #
    # @option params [Array<String>] :values_to_add
    #   A list of DB cluster snapshot attributes to add to the attribute
    #   specified by `AttributeName`.
    #
    #   To authorize other Amazon Web Services accounts to copy or restore a
    #   manual DB cluster snapshot, set this list to include one or more
    #   Amazon Web Services account IDs, or `all` to make the manual DB
    #   cluster snapshot restorable by any Amazon Web Services account. Do not
    #   add the `all` value for any manual DB cluster snapshots that contain
    #   private information that you don't want available to all Amazon Web
    #   Services accounts.
    #
    # @option params [Array<String>] :values_to_remove
    #   A list of DB cluster snapshot attributes to remove from the attribute
    #   specified by `AttributeName`.
    #
    #   To remove authorization for other Amazon Web Services accounts to copy
    #   or restore a manual DB cluster snapshot, set this list to include one
    #   or more Amazon Web Services account identifiers, or `all` to remove
    #   authorization for any Amazon Web Services account to copy or restore
    #   the DB cluster snapshot. If you specify `all`, an Amazon Web Services
    #   account whose account ID is explicitly added to the `restore`
    #   attribute can still copy or restore a manual DB cluster snapshot.
    #
    # @return [Types::ModifyDBClusterSnapshotAttributeResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ModifyDBClusterSnapshotAttributeResult#db_cluster_snapshot_attributes_result #db_cluster_snapshot_attributes_result} => Types::DBClusterSnapshotAttributesResult
    #
    #
    # @example Example: To modify a DB cluster snapshot attribute
    #
    #   # The following example makes changes to the specified DB cluster snapshot attribute.
    #
    #   resp = client.modify_db_cluster_snapshot_attribute({
    #     attribute_name: "restore", 
    #     db_cluster_snapshot_identifier: "myclustersnapshot", 
    #     values_to_add: [
    #       "123456789012", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_cluster_snapshot_attributes_result: {
    #       db_cluster_snapshot_attributes: [
    #         {
    #           attribute_name: "restore", 
    #           attribute_values: [
    #             "123456789012", 
    #           ], 
    #         }, 
    #       ], 
    #       db_cluster_snapshot_identifier: "myclustersnapshot", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_db_cluster_snapshot_attribute({
    #     db_cluster_snapshot_identifier: "String", # required
    #     attribute_name: "String", # required
    #     values_to_add: ["String"],
    #     values_to_remove: ["String"],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_cluster_snapshot_attributes_result.db_cluster_snapshot_identifier #=> String
    #   resp.db_cluster_snapshot_attributes_result.db_cluster_snapshot_attributes #=> Array
    #   resp.db_cluster_snapshot_attributes_result.db_cluster_snapshot_attributes[0].attribute_name #=> String
    #   resp.db_cluster_snapshot_attributes_result.db_cluster_snapshot_attributes[0].attribute_values #=> Array
    #   resp.db_cluster_snapshot_attributes_result.db_cluster_snapshot_attributes[0].attribute_values[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterSnapshotAttribute AWS API Documentation
    #
    # @overload modify_db_cluster_snapshot_attribute(params = {})
    # @param [Hash] params ({})
    def modify_db_cluster_snapshot_attribute(params = {}, options = {})
      req = build_request(:modify_db_cluster_snapshot_attribute, params)
      req.send_request(options)
    end

    # Modifies settings for a DB instance. You can change one or more
    # database configuration parameters by specifying these parameters and
    # the new values in the request. To learn what modifications you can
    # make to your DB instance, call `DescribeValidDBInstanceModifications`
    # before you call `ModifyDBInstance`.
    #
    # @option params [required, String] :db_instance_identifier
    #   The identifier of DB instance to modify. This value is stored as a
    #   lowercase string.
    #
    #   Constraints:
    #
    #   * Must match the identifier of an existing DB instance.
    #
    #   ^
    #
    # @option params [Integer] :allocated_storage
    #   The new amount of storage in gibibytes (GiB) to allocate for the DB
    #   instance.
    #
    #   For RDS for Db2, MariaDB, RDS for MySQL, RDS for Oracle, and RDS for
    #   PostgreSQL, the value supplied must be at least 10% greater than the
    #   current value. Values that are not at least 10% greater than the
    #   existing value are rounded up so that they are 10% greater than the
    #   current value.
    #
    #   For the valid values for allocated storage for each engine, see
    #   `CreateDBInstance`.
    #
    #   Constraints:
    #
    #   * When you increase the allocated storage for a DB instance that uses
    #     Provisioned IOPS (`gp3`, `io1`, or `io2` storage type), you must
    #     also specify the `Iops` parameter. You can use the current value for
    #     `Iops`.
    #
    #   ^
    #
    # @option params [String] :db_instance_class
    #   The new compute and memory capacity of the DB instance, for example
    #   `db.m4.large`. Not all DB instance classes are available in all Amazon
    #   Web Services Regions, or for all database engines. For the full list
    #   of DB instance classes, and availability for your engine, see [DB
    #   Instance Class][1] in the *Amazon RDS User Guide* or [Aurora DB
    #   instance classes][2] in the *Amazon Aurora User Guide*. For RDS
    #   Custom, see [DB instance class support for RDS Custom for Oracle][3]
    #   and [ DB instance class support for RDS Custom for SQL Server][4].
    #
    #   If you modify the DB instance class, an outage occurs during the
    #   change. The change is applied during the next maintenance window,
    #   unless you specify `ApplyImmediately` in your request.
    #
    #   Default: Uses existing setting
    #
    #   Constraints:
    #
    #   * If you are modifying the DB instance class and upgrading the engine
    #     version at the same time, the currently running engine version must
    #     be supported on the specified DB instance class. Otherwise, the
    #     operation returns an error. In this case, first run the operation to
    #     upgrade the engine version, and then run it again to modify the DB
    #     instance class.
    #
    #   ^
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html
    #   [3]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits.html#custom-reqs-limits.instances
    #   [4]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html#custom-reqs-limits.instancesMS
    #
    # @option params [String] :db_subnet_group_name
    #   The new DB subnet group for the DB instance. You can use this
    #   parameter to move your DB instance to a different VPC. If your DB
    #   instance isn't in a VPC, you can also use this parameter to move your
    #   DB instance into a VPC. For more information, see [Working with a DB
    #   instance in a VPC][1] in the *Amazon RDS User Guide*.
    #
    #   Changing the subnet group causes an outage during the change. The
    #   change is applied during the next maintenance window, unless you
    #   enable `ApplyImmediately`.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Constraints:
    #
    #   * If supplied, must match existing DB subnet group.
    #
    #   ^
    #
    #   Example: `mydbsubnetgroup`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC
    #
    # @option params [Array<String>] :db_security_groups
    #   A list of DB security groups to authorize on this DB instance.
    #   Changing this setting doesn't result in an outage and the change is
    #   asynchronously applied as soon as possible.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Constraints:
    #
    #   * If supplied, must match existing DB security groups.
    #
    #   ^
    #
    # @option params [Array<String>] :vpc_security_group_ids
    #   A list of Amazon EC2 VPC security groups to associate with this DB
    #   instance. This change is asynchronously applied as soon as possible.
    #
    #   This setting doesn't apply to the following DB instances:
    #
    #   * Amazon Aurora (The associated list of EC2 VPC security groups is
    #     managed by the DB cluster. For more information, see
    #     `ModifyDBCluster`.)
    #
    #   * RDS Custom
    #
    #   Constraints:
    #
    #   * If supplied, must match existing VPC security group IDs.
    #
    #   ^
    #
    # @option params [Boolean] :apply_immediately
    #   Specifies whether the modifications in this request and any pending
    #   modifications are asynchronously applied as soon as possible,
    #   regardless of the `PreferredMaintenanceWindow` setting for the DB
    #   instance. By default, this parameter is disabled.
    #
    #   If this parameter is disabled, changes to the DB instance are applied
    #   during the next maintenance window. Some parameter changes can cause
    #   an outage and are applied on the next call to RebootDBInstance, or the
    #   next failure reboot. Review the table of parameters in [Modifying a DB
    #   Instance][1] in the *Amazon RDS User Guide* to see the impact of
    #   enabling or disabling `ApplyImmediately` for each modified parameter
    #   and to determine when the changes are applied.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html
    #
    # @option params [String] :master_user_password
    #   The new password for the master user.
    #
    #   Changing this parameter doesn't result in an outage and the change is
    #   asynchronously applied as soon as possible. Between the time of the
    #   request and the completion of the request, the `MasterUserPassword`
    #   element exists in the `PendingModifiedValues` element of the operation
    #   response.
    #
    #   <note markdown="1"> Amazon RDS API operations never return the password, so this operation
    #   provides a way to regain access to a primary instance user if the
    #   password is lost. This includes restoring privileges that might have
    #   been accidentally revoked.
    #
    #    </note>
    #
    #   This setting doesn't apply to the following DB instances:
    #
    #   * Amazon Aurora
    #
    #     The password for the master user is managed by the DB cluster. For
    #     more information, see `ModifyDBCluster`.
    #
    #   * RDS Custom
    #
    #   * RDS for Oracle CDBs in the multi-tenant configuration
    #
    #     Specify the master password in `ModifyTenantDatabase` instead.
    #
    #   Default: Uses existing setting
    #
    #   Constraints:
    #
    #   * Can't be specified if `ManageMasterUserPassword` is turned on.
    #
    #   * Can include any printable ASCII character except "/", """, or
    #     "@". For RDS for Oracle, can't include the "&amp;" (ampersand)
    #     or the "'" (single quotes) character.
    #
    #   Length Constraints:
    #
    #   * RDS for Db2 - Must contain from 8 to 255 characters.
    #
    #   * RDS for MariaDB - Must contain from 8 to 41 characters.
    #
    #   * RDS for Microsoft SQL Server - Must contain from 8 to 128
    #     characters.
    #
    #   * RDS for MySQL - Must contain from 8 to 41 characters.
    #
    #   * RDS for Oracle - Must contain from 8 to 30 characters.
    #
    #   * RDS for PostgreSQL - Must contain from 8 to 128 characters.
    #
    # @option params [String] :db_parameter_group_name
    #   The name of the DB parameter group to apply to the DB instance.
    #
    #   Changing this setting doesn't result in an outage. The parameter
    #   group name itself is changed immediately, but the actual parameter
    #   changes are not applied until you reboot the instance without
    #   failover. In this case, the DB instance isn't rebooted automatically,
    #   and the parameter changes aren't applied during the next maintenance
    #   window. However, if you modify dynamic parameters in the newly
    #   associated DB parameter group, these changes are applied immediately
    #   without a reboot.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Default: Uses existing setting
    #
    #   Constraints:
    #
    #   * Must be in the same DB parameter group family as the DB instance.
    #
    #   ^
    #
    # @option params [Integer] :backup_retention_period
    #   The number of days to retain automated backups. Setting this parameter
    #   to a positive number enables backups. Setting this parameter to 0
    #   disables automated backups.
    #
    #   <note markdown="1"> Enabling and disabling backups can result in a brief I/O suspension
    #   that lasts from a few seconds to a few minutes, depending on the size
    #   and class of your DB instance.
    #
    #    </note>
    #
    #   These changes are applied during the next maintenance window unless
    #   the `ApplyImmediately` parameter is enabled for this request. If you
    #   change the parameter from one non-zero value to another non-zero
    #   value, the change is asynchronously applied as soon as possible.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. The
    #   retention period for automated backups is managed by the DB cluster.
    #   For more information, see `ModifyDBCluster`.
    #
    #   Default: Uses existing setting
    #
    #   Constraints:
    #
    #   * Must be a value from 0 to 35.
    #
    #   * Can't be set to 0 if the DB instance is a source to read replicas.
    #
    #   * Can't be set to 0 for an RDS Custom for Oracle DB instance.
    #
    # @option params [String] :preferred_backup_window
    #   The daily time range during which automated backups are created if
    #   automated backups are enabled, as determined by the
    #   `BackupRetentionPeriod` parameter. Changing this parameter doesn't
    #   result in an outage and the change is asynchronously applied as soon
    #   as possible. The default is a 30-minute window selected at random from
    #   an 8-hour block of time for each Amazon Web Services Region. For more
    #   information, see [Backup window][1] in the *Amazon RDS User Guide*.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. The daily
    #   time range for creating automated backups is managed by the DB
    #   cluster. For more information, see `ModifyDBCluster`.
    #
    #   Constraints:
    #
    #   * Must be in the format `hh24:mi-hh24:mi`.
    #
    #   * Must be in Universal Coordinated Time (UTC).
    #
    #   * Must not conflict with the preferred maintenance window.
    #
    #   * Must be at least 30 minutes.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow
    #
    # @option params [String] :preferred_maintenance_window
    #   The weekly time range during which system maintenance can occur, which
    #   might result in an outage. Changing this parameter doesn't result in
    #   an outage, except in the following situation, and the change is
    #   asynchronously applied as soon as possible. If there are pending
    #   actions that cause a reboot, and the maintenance window is changed to
    #   include the current time, then changing this parameter causes a reboot
    #   of the DB instance. If you change this window to the current time,
    #   there must be at least 30 minutes between the current time and end of
    #   the window to ensure pending changes are applied.
    #
    #   For more information, see [Amazon RDS Maintenance Window][1] in the
    #   *Amazon RDS User Guide.*
    #
    #   Default: Uses existing setting
    #
    #   Constraints:
    #
    #   * Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
    #
    #   * The day values must be `mon | tue | wed | thu | fri | sat | sun`.
    #
    #   * Must be in Universal Coordinated Time (UTC).
    #
    #   * Must not conflict with the preferred backup window.
    #
    #   * Must be at least 30 minutes.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance
    #
    # @option params [Boolean] :multi_az
    #   Specifies whether the DB instance is a Multi-AZ deployment. Changing
    #   this parameter doesn't result in an outage. The change is applied
    #   during the next maintenance window unless the `ApplyImmediately`
    #   parameter is enabled for this request.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [String] :engine_version
    #   The version number of the database engine to upgrade to. Changing this
    #   parameter results in an outage and the change is applied during the
    #   next maintenance window unless the `ApplyImmediately` parameter is
    #   enabled for this request.
    #
    #   For major version upgrades, if a nondefault DB parameter group is
    #   currently in use, a new DB parameter group in the DB parameter group
    #   family for the new engine version must be specified. The new DB
    #   parameter group can be the default for that DB parameter group family.
    #
    #   If you specify only a major version, Amazon RDS updates the DB
    #   instance to the default minor version if the current minor version is
    #   lower. For information about valid engine versions, see
    #   `CreateDBInstance`, or call `DescribeDBEngineVersions`.
    #
    #   If the instance that you're modifying is acting as a read replica,
    #   the engine version that you specify must be the same or higher than
    #   the version that the source DB instance or cluster is running.
    #
    #   In RDS Custom for Oracle, this parameter is supported for read
    #   replicas only if they are in the `PATCH_DB_FAILURE` lifecycle.
    #
    #   Constraints:
    #
    #   * If you are upgrading the engine version and modifying the DB
    #     instance class at the same time, the currently running engine
    #     version must be supported on the specified DB instance class.
    #     Otherwise, the operation returns an error. In this case, first run
    #     the operation to upgrade the engine version, and then run it again
    #     to modify the DB instance class.
    #
    #   ^
    #
    # @option params [Boolean] :allow_major_version_upgrade
    #   Specifies whether major version upgrades are allowed. Changing this
    #   parameter doesn't result in an outage and the change is
    #   asynchronously applied as soon as possible.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Constraints:
    #
    #   * Major version upgrades must be allowed when specifying a value for
    #     the `EngineVersion` parameter that's a different major version than
    #     the DB instance's current version.
    #
    #   ^
    #
    # @option params [Boolean] :auto_minor_version_upgrade
    #   Specifies whether minor version upgrades are applied automatically to
    #   the DB instance during the maintenance window. An outage occurs when
    #   all the following conditions are met:
    #
    #   * The automatic upgrade is enabled for the maintenance window.
    #
    #   * A newer minor version is available.
    #
    #   * RDS has enabled automatic patching for the engine version.
    #
    #   If any of the preceding conditions isn't met, Amazon RDS applies the
    #   change as soon as possible and doesn't cause an outage.
    #
    #   For an RDS Custom DB instance, don't enable this setting. Otherwise,
    #   the operation returns an error.
    #
    #   For more information about automatic minor version upgrades, see
    #   [Automatically upgrading the minor engine version][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades
    #
    # @option params [String] :license_model
    #   The license model for the DB instance.
    #
    #   This setting doesn't apply to Amazon Aurora or RDS Custom DB
    #   instances.
    #
    #   Valid Values:
    #
    #   * RDS for Db2 - `bring-your-own-license`
    #
    #   * RDS for MariaDB - `general-public-license`
    #
    #   * RDS for Microsoft SQL Server - `license-included`
    #
    #   * RDS for MySQL - `general-public-license`
    #
    #   * RDS for Oracle - `bring-your-own-license | license-included`
    #
    #   * RDS for PostgreSQL - `postgresql-license`
    #
    # @option params [Integer] :iops
    #   The new Provisioned IOPS (I/O operations per second) value for the RDS
    #   instance.
    #
    #   Changing this setting doesn't result in an outage and the change is
    #   applied during the next maintenance window unless the
    #   `ApplyImmediately` parameter is enabled for this request. If you are
    #   migrating from Provisioned IOPS to standard storage, set this value to
    #   0. The DB instance will require a reboot for the change in storage
    #   type to take effect.
    #
    #   If you choose to migrate your DB instance from using standard storage
    #   to Provisioned IOPS (io1), or from Provisioned IOPS to standard
    #   storage, the process can take time. The duration of the migration
    #   depends on several factors such as database load, storage size,
    #   storage type (standard or Provisioned IOPS), amount of IOPS
    #   provisioned (if any), and the number of prior scale storage
    #   operations. Typical migration times are under 24 hours, but the
    #   process can take up to several days in some cases. During the
    #   migration, the DB instance is available for use, but might experience
    #   performance degradation. While the migration takes place, nightly
    #   backups for the instance are suspended. No other Amazon RDS operations
    #   can take place for the instance, including modifying the instance,
    #   rebooting the instance, deleting the instance, creating a read replica
    #   for the instance, and creating a DB snapshot of the instance.
    #
    #
    #
    #   Constraints:
    #
    #   * For RDS for MariaDB, RDS for MySQL, RDS for Oracle, and RDS for
    #     PostgreSQL - The value supplied must be at least 10% greater than
    #     the current value. Values that are not at least 10% greater than the
    #     existing value are rounded up so that they are 10% greater than the
    #     current value.
    #
    #   * When you increase the Provisioned IOPS, you must also specify the
    #     `AllocatedStorage` parameter. You can use the current value for
    #     `AllocatedStorage`.
    #
    #   Default: Uses existing setting
    #
    # @option params [String] :option_group_name
    #   The option group to associate the DB instance with.
    #
    #   Changing this parameter doesn't result in an outage, with one
    #   exception. If the parameter change results in an option group that
    #   enables OEM, it can cause a brief period, lasting less than a second,
    #   during which new connections are rejected but existing connections
    #   aren't interrupted.
    #
    #   The change is applied during the next maintenance window unless the
    #   `ApplyImmediately` parameter is enabled for this request.
    #
    #   Permanent options, such as the TDE option for Oracle Advanced Security
    #   TDE, can't be removed from an option group, and that option group
    #   can't be removed from a DB instance after it is associated with a DB
    #   instance.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [String] :new_db_instance_identifier
    #   The new identifier for the DB instance when renaming a DB instance.
    #   When you change the DB instance identifier, an instance reboot occurs
    #   immediately if you enable `ApplyImmediately`, or will occur during the
    #   next maintenance window if you disable `ApplyImmediately`. This value
    #   is stored as a lowercase string.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Constraints:
    #
    #   * Must contain from 1 to 63 letters, numbers, or hyphens.
    #
    #   * The first character must be a letter.
    #
    #   * Can't end with a hyphen or contain two consecutive hyphens.
    #
    #   Example: `mydbinstance`
    #
    # @option params [String] :storage_type
    #   The storage type to associate with the DB instance.
    #
    #   If you specify `io1`, `io2`, or `gp3` you must also include a value
    #   for the `Iops` parameter.
    #
    #   If you choose to migrate your DB instance from using standard storage
    #   to gp2 (General Purpose SSD), gp3, or Provisioned IOPS (io1), or from
    #   these storage types to standard storage, the process can take time.
    #   The duration of the migration depends on several factors such as
    #   database load, storage size, storage type (standard or Provisioned
    #   IOPS), amount of IOPS provisioned (if any), and the number of prior
    #   scale storage operations. Typical migration times are under 24 hours,
    #   but the process can take up to several days in some cases. During the
    #   migration, the DB instance is available for use, but might experience
    #   performance degradation. While the migration takes place, nightly
    #   backups for the instance are suspended. No other Amazon RDS operations
    #   can take place for the instance, including modifying the instance,
    #   rebooting the instance, deleting the instance, creating a read replica
    #   for the instance, and creating a DB snapshot of the instance.
    #
    #   Valid Values: `gp2 | gp3 | io1 | io2 | standard`
    #
    #   Default: `io1`, if the `Iops` parameter is specified. Otherwise,
    #   `gp2`.
    #
    # @option params [String] :tde_credential_arn
    #   The ARN from the key store with which to associate the instance for
    #   TDE encryption.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [String] :tde_credential_password
    #   The password for the given ARN from the key store in order to access
    #   the device.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [String] :ca_certificate_identifier
    #   The CA certificate identifier to use for the DB instance's server
    #   certificate.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   For more information, see [Using SSL/TLS to encrypt a connection to a
    #   DB instance][1] in the *Amazon RDS User Guide* and [ Using SSL/TLS to
    #   encrypt a connection to a DB cluster][2] in the *Amazon Aurora User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html
    #
    # @option params [String] :domain
    #   The Active Directory directory ID to move the DB instance to. Specify
    #   `none` to remove the instance from its current domain. You must create
    #   the domain before this operation. Currently, you can create only Db2,
    #   MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an
    #   Active Directory Domain.
    #
    #   For more information, see [ Kerberos Authentication][1] in the *Amazon
    #   RDS User Guide*.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html
    #
    # @option params [String] :domain_fqdn
    #   The fully qualified domain name (FQDN) of an Active Directory domain.
    #
    #   Constraints:
    #
    #   * Can't be longer than 64 characters.
    #
    #   ^
    #
    #   Example: `mymanagedADtest.mymanagedAD.mydomain`
    #
    # @option params [String] :domain_ou
    #   The Active Directory organizational unit for your DB instance to join.
    #
    #   Constraints:
    #
    #   * Must be in the distinguished name format.
    #
    #   * Can't be longer than 64 characters.
    #
    #   Example:
    #   `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
    #
    # @option params [String] :domain_auth_secret_arn
    #   The ARN for the Secrets Manager secret with the credentials for the
    #   user joining the domain.
    #
    #   Example:
    #   `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
    #
    # @option params [Array<String>] :domain_dns_ips
    #   The IPv4 DNS IP addresses of your primary and secondary Active
    #   Directory domain controllers.
    #
    #   Constraints:
    #
    #   * Two IP addresses must be provided. If there isn't a secondary
    #     domain controller, use the IP address of the primary domain
    #     controller for both entries in the list.
    #
    #   ^
    #
    #   Example: `123.124.125.126,234.235.236.237`
    #
    # @option params [Boolean] :copy_tags_to_snapshot
    #   Specifies whether to copy all tags from the DB instance to snapshots
    #   of the DB instance. By default, tags aren't copied.
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. Copying
    #   tags to snapshots is managed by the DB cluster. Setting this value for
    #   an Aurora DB instance has no effect on the DB cluster setting. For
    #   more information, see `ModifyDBCluster`.
    #
    # @option params [Integer] :monitoring_interval
    #   The interval, in seconds, between points when Enhanced Monitoring
    #   metrics are collected for the DB instance. To disable collection of
    #   Enhanced Monitoring metrics, specify `0`.
    #
    #   If `MonitoringRoleArn` is specified, set `MonitoringInterval` to a
    #   value other than `0`.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
    #
    #   Default: `0`
    #
    # @option params [Integer] :db_port_number
    #   The port number on which the database accepts connections.
    #
    #   The value of the `DBPortNumber` parameter must not match any of the
    #   port values specified for options in the option group for the DB
    #   instance.
    #
    #   If you change the `DBPortNumber` value, your database restarts
    #   regardless of the value of the `ApplyImmediately` parameter.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Valid Values: `1150-65535`
    #
    #   Default:
    #
    #   * Amazon Aurora - `3306`
    #
    #   * RDS for Db2 - `50000`
    #
    #   * RDS for MariaDB - `3306`
    #
    #   * RDS for Microsoft SQL Server - `1433`
    #
    #   * RDS for MySQL - `3306`
    #
    #   * RDS for Oracle - `1521`
    #
    #   * RDS for PostgreSQL - `5432`
    #
    #   Constraints:
    #
    #   * For RDS for Microsoft SQL Server, the value can't be `1234`,
    #     `1434`, `3260`, `3343`, `3389`, `47001`, or `49152-49156`.
    #
    #   ^
    #
    # @option params [Boolean] :publicly_accessible
    #   Specifies whether the DB instance is publicly accessible.
    #
    #   When the DB instance is publicly accessible and you connect from
    #   outside of the DB instance's virtual private cloud (VPC), its Domain
    #   Name System (DNS) endpoint resolves to the public IP address. When you
    #   connect from within the same VPC as the DB instance, the endpoint
    #   resolves to the private IP address. Access to the DB instance is
    #   ultimately controlled by the security group it uses. That public
    #   access isn't permitted if the security group assigned to the DB
    #   instance doesn't permit it.
    #
    #   When the DB instance isn't publicly accessible, it is an internal DB
    #   instance with a DNS name that resolves to a private IP address.
    #
    #   `PubliclyAccessible` only applies to DB instances in a VPC. The DB
    #   instance must be part of a public subnet and `PubliclyAccessible` must
    #   be enabled for it to be publicly accessible.
    #
    #   Changes to the `PubliclyAccessible` parameter are applied immediately
    #   regardless of the value of the `ApplyImmediately` parameter.
    #
    # @option params [String] :monitoring_role_arn
    #   The ARN for the IAM role that permits RDS to send enhanced monitoring
    #   metrics to Amazon CloudWatch Logs. For example,
    #   `arn:aws:iam:123456789012:role/emaccess`. For information on creating
    #   a monitoring role, see [To create an IAM role for Amazon RDS Enhanced
    #   Monitoring][1] in the *Amazon RDS User Guide.*
    #
    #   If `MonitoringInterval` is set to a value other than `0`, supply a
    #   `MonitoringRoleArn` value.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole
    #
    # @option params [String] :domain_iam_role_name
    #   The name of the IAM role to use when making API calls to the Directory
    #   Service.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [Boolean] :disable_domain
    #   Specifies whether to remove the DB instance from the Active Directory
    #   domain.
    #
    # @option params [Integer] :promotion_tier
    #   The order of priority in which an Aurora Replica is promoted to the
    #   primary instance after a failure of the existing primary instance. For
    #   more information, see [ Fault Tolerance for an Aurora DB Cluster][1]
    #   in the *Amazon Aurora User Guide*.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Default: `1`
    #
    #   Valid Values: `0 - 15`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance
    #
    # @option params [Boolean] :enable_iam_database_authentication
    #   Specifies whether to enable mapping of Amazon Web Services Identity
    #   and Access Management (IAM) accounts to database accounts. By default,
    #   mapping isn't enabled.
    #
    #   This setting doesn't apply to Amazon Aurora. Mapping Amazon Web
    #   Services IAM accounts to database accounts is managed by the DB
    #   cluster.
    #
    #   For more information about IAM database authentication, see [ IAM
    #   Database Authentication for MySQL and PostgreSQL][1] in the *Amazon
    #   RDS User Guide.*
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html
    #
    # @option params [String] :database_insights_mode
    #   Specifies the mode of Database Insights to enable for the DB instance.
    #
    #   <note markdown="1"> Aurora DB instances inherit this value from the DB cluster, so you
    #   can't change this value.
    #
    #    </note>
    #
    # @option params [Boolean] :enable_performance_insights
    #   Specifies whether to enable Performance Insights for the DB instance.
    #
    #   For more information, see [Using Amazon Performance Insights][1] in
    #   the *Amazon RDS User Guide*.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html
    #
    # @option params [String] :performance_insights_kms_key_id
    #   The Amazon Web Services KMS key identifier for encryption of
    #   Performance Insights data.
    #
    #   The Amazon Web Services KMS key identifier is the key ARN, key ID,
    #   alias ARN, or alias name for the KMS key.
    #
    #   If you don't specify a value for `PerformanceInsightsKMSKeyId`, then
    #   Amazon RDS uses your default KMS key. There is a default KMS key for
    #   your Amazon Web Services account. Your Amazon Web Services account has
    #   a different default KMS key for each Amazon Web Services Region.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [Integer] :performance_insights_retention_period
    #   The number of days to retain Performance Insights data.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   Valid Values:
    #
    #   * `7`
    #
    #   * *month* * 31, where *month* is a number of months from 1-23.
    #     Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19
    #     months * 31)
    #
    #   * `731`
    #
    #   Default: `7` days
    #
    #   If you specify a retention period that isn't valid, such as `94`,
    #   Amazon RDS returns an error.
    #
    # @option params [Types::CloudwatchLogsExportConfiguration] :cloudwatch_logs_export_configuration
    #   The log types to be enabled for export to CloudWatch Logs for a
    #   specific DB instance.
    #
    #   A change to the `CloudwatchLogsExportConfiguration` parameter is
    #   always applied to the DB instance immediately. Therefore, the
    #   `ApplyImmediately` parameter has no effect.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #   The following values are valid for each DB engine:
    #
    #   * Aurora MySQL - `audit | error | general | slowquery |
    #     iam-db-auth-error`
    #
    #   * Aurora PostgreSQL - `postgresql | iam-db-auth-error`
    #
    #   * RDS for MySQL - `error | general | slowquery | iam-db-auth-error`
    #
    #   * RDS for PostgreSQL - `postgresql | upgrade | iam-db-auth-error`
    #
    #   For more information about exporting CloudWatch Logs for Amazon RDS,
    #   see [ Publishing Database Logs to Amazon CloudWatch Logs][1] in the
    #   *Amazon RDS User Guide*.
    #
    #   For more information about exporting CloudWatch Logs for Amazon
    #   Aurora, see [Publishing Database Logs to Amazon CloudWatch Logs][2] in
    #   the *Amazon Aurora User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch
    #
    # @option params [Array<Types::ProcessorFeature>] :processor_features
    #   The number of CPU cores and the number of threads per core for the DB
    #   instance class of the DB instance.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [Boolean] :use_default_processor_features
    #   Specifies whether the DB instance class of the DB instance uses its
    #   default processor features.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [Boolean] :deletion_protection
    #   Specifies whether the DB instance has deletion protection enabled. The
    #   database can't be deleted when deletion protection is enabled. By
    #   default, deletion protection isn't enabled. For more information, see
    #   [ Deleting a DB Instance][1].
    #
    #   This setting doesn't apply to Amazon Aurora DB instances. You can
    #   enable or disable deletion protection for the DB cluster. For more
    #   information, see `ModifyDBCluster`. DB instances in a DB cluster can
    #   be deleted even when deletion protection is enabled for the DB
    #   cluster.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html
    #
    # @option params [Integer] :max_allocated_storage
    #   The upper limit in gibibytes (GiB) to which Amazon RDS can
    #   automatically scale the storage of the DB instance.
    #
    #   For more information about this setting, including limitations that
    #   apply to it, see [ Managing capacity automatically with Amazon RDS
    #   storage autoscaling][1] in the *Amazon RDS User Guide*.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling
    #
    # @option params [Boolean] :certificate_rotation_restart
    #   Specifies whether the DB instance is restarted when you rotate your
    #   SSL/TLS certificate.
    #
    #   By default, the DB instance is restarted when you rotate your SSL/TLS
    #   certificate. The certificate is not updated until the DB instance is
    #   restarted.
    #
    #   Set this parameter only if you are *not* using SSL/TLS to connect to
    #   the DB instance.
    #
    #   If you are using SSL/TLS to connect to the DB instance, follow the
    #   appropriate instructions for your DB engine to rotate your SSL/TLS
    #   certificate:
    #
    #   * For more information about rotating your SSL/TLS certificate for RDS
    #     DB engines, see [ Rotating Your SSL/TLS Certificate.][1] in the
    #     *Amazon RDS User Guide.*
    #
    #   * For more information about rotating your SSL/TLS certificate for
    #     Aurora DB engines, see [ Rotating Your SSL/TLS Certificate][2] in
    #     the *Amazon Aurora User Guide*.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html
    #
    # @option params [String] :replica_mode
    #   The open mode of a replica database.
    #
    #   This parameter is only supported for Db2 DB instances and Oracle DB
    #   instances.
    #
    #   Db2
    #
    #   : Standby DB replicas are included in Db2 Advanced Edition (AE) and
    #     Db2 Standard Edition (SE). The main use case for standby replicas is
    #     cross-Region disaster recovery. Because it doesn't accept user
    #     connections, a standby replica can't serve a read-only workload.
    #
    #     You can create a combination of standby and read-only DB replicas
    #     for the same primary DB instance. For more information, see [Working
    #     with replicas for Amazon RDS for Db2][1] in the *Amazon RDS User
    #     Guide*.
    #
    #     To create standby DB replicas for RDS for Db2, set this parameter to
    #     `mounted`.
    #
    #   Oracle
    #
    #   : Mounted DB replicas are included in Oracle Database Enterprise
    #     Edition. The main use case for mounted replicas is cross-Region
    #     disaster recovery. The primary database doesn't use Active Data
    #     Guard to transmit information to the mounted replica. Because it
    #     doesn't accept user connections, a mounted replica can't serve a
    #     read-only workload.
    #
    #     You can create a combination of mounted and read-only DB replicas
    #     for the same primary DB instance. For more information, see [Working
    #     with read replicas for Amazon RDS for Oracle][2] in the *Amazon RDS
    #     User Guide*.
    #
    #     For RDS Custom, you must specify this parameter and set it to
    #     `mounted`. The value won't be set by default. After replica
    #     creation, you can manage the open mode manually.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-replication.html
    #   [2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html
    #
    # @option params [Boolean] :enable_customer_owned_ip
    #   Specifies whether to enable a customer-owned IP address (CoIP) for an
    #   RDS on Outposts DB instance.
    #
    #   A *CoIP* provides local or external connectivity to resources in your
    #   Outpost subnets through your on-premises network. For some use cases,
    #   a CoIP can provide lower latency for connections to the DB instance
    #   from outside of its virtual private cloud (VPC) on your local network.
    #
    #   For more information about RDS on Outposts, see [Working with Amazon
    #   RDS on Amazon Web Services Outposts][1] in the *Amazon RDS User
    #   Guide*.
    #
    #   For more information about CoIPs, see [Customer-owned IP addresses][2]
    #   in the *Amazon Web Services Outposts User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html
    #   [2]: https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing
    #
    # @option params [String] :aws_backup_recovery_point_arn
    #   The Amazon Resource Name (ARN) of the recovery point in Amazon Web
    #   Services Backup.
    #
    #   This setting doesn't apply to RDS Custom DB instances.
    #
    # @option params [String] :automation_mode
    #   The automation mode of the RDS Custom DB instance. If `full`, the DB
    #   instance automates monitoring and instance recovery. If `all paused`,
    #   the instance pauses automation for the duration set by
    #   `ResumeFullAutomationModeMinutes`.
    #
    # @option params [Integer] :resume_full_automation_mode_minutes
    #   The number of minutes to pause the automation. When the time period
    #   ends, RDS Custom resumes full automation.
    #
    #   Default: `60`
    #
    #   Constraints:
    #
    #   * Must be at least 60.
    #
    #   * Must be no more than 1,440.
    #
    # @option params [String] :network_type
    #   The network type of the DB instance.
    #
    #   The network type is determined by the `DBSubnetGroup` specified for
    #   the DB instance. A `DBSubnetGroup` can support only the IPv4 protocol
    #   or the IPv4 and the IPv6 protocols (`DUAL`).
    #
    #   For more information, see [ Working with a DB instance in a VPC][1] in
    #   the *Amazon RDS User Guide.*
    #
    #   Valid Values: `IPV4 | DUAL`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html
    #
    # @option params [Integer] :storage_throughput
    #   The storage throughput value for the DB instance.
    #
    #   This setting applies only to the `gp3` storage type.
    #
    #   This setting doesn't apply to Amazon Aurora or RDS Custom DB
    #   instances.
    #
    # @option params [Boolean] :manage_master_user_password
    #   Specifies whether to manage the master user password with Amazon Web
    #   Services Secrets Manager.
    #
    #   If the DB instance doesn't manage the master user password with
    #   Amazon Web Services Secrets Manager, you can turn on this management.
    #   In this case, you can't specify `MasterUserPassword`.
    #
    #   If the DB instance already manages the master user password with
    #   Amazon Web Services Secrets Manager, and you specify that the master
    #   user password is not managed with Amazon Web Services Secrets Manager,
    #   then you must specify `MasterUserPassword`. In this case, Amazon RDS
    #   deletes the secret and uses the new password for the master user
    #   specified by `MasterUserPassword`.
    #
    #   For more information, see [Password management with Amazon Web
    #   Services Secrets Manager][1] in the *Amazon RDS User Guide.*
    #
    #   Constraints:
    #
    #   * Can't manage the master user password with Amazon Web Services
    #     Secrets Manager if `MasterUserPassword` is specified.
    #
    #   * Can't specify for RDS for Oracle CDB instances in the multi-tenant
    #     configuration. Use `ModifyTenantDatabase` instead.
    #
    #   * Can't specify the parameters `ManageMasterUserPassword` and
    #     `MultiTenant` in the same operation.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html
    #
    # @option params [Boolean] :rotate_master_user_password
    #   Specifies whether to rotate the secret managed by Amazon Web Services
    #   Secrets Manager for the master user password.
    #
    #   This setting is valid only if the master user password is managed by
    #   RDS in Amazon Web Services Secrets Manager for the DB instance. The
    #   secret value contains the updated password.
    #
    #   For more information, see [Password management with Amazon Web
    #   Services Secrets Manager][1] in the *Amazon RDS User Guide.*
    #
    #   Constraints:
    #
    #   * You must apply the change immediately when rotating the master user
    #     password.
    #
    #   ^
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html
    #
    # @option params [String] :master_user_secret_kms_key_id
    #   The Amazon Web Services KMS key identifier to encrypt a secret that is
    #   automatically generated and managed in Amazon Web Services Secrets
    #   Manager.
    #
    #   This setting is valid only if both of the following conditions are
    #   met:
    #
    #   * The DB instance doesn't manage the master user password in Amazon
    #     Web Services Secrets Manager.
    #
    #     If the DB instance already manages the master user password in
    #     Amazon Web Services Secrets Manager, you can't change the KMS key
    #     used to encrypt the secret.
    #
    #   * You are turning on `ManageMasterUserPassword` to manage the master
    #     user password in Amazon Web Services Secrets Manager.
    #
    #     If you are turning on `ManageMasterUserPassword` and don't specify
    #     `MasterUserSecretKmsKeyId`, then the `aws/secretsmanager` KMS key is
    #     used to encrypt the secret. If the secret is in a different Amazon
    #     Web Services account, then you can't use the `aws/secretsmanager`
    #     KMS key to encrypt the secret, and you must use a customer managed
    #     KMS key.
    #
    #   The Amazon Web Services KMS key identifier is the key ARN, key ID,
    #   alias ARN, or alias name for the KMS key. To use a KMS key in a
    #   different Amazon Web Services account, specify the key ARN or alias
    #   ARN.
    #
    #   There is a default KMS key for your Amazon Web Services account. Your
    #   Amazon Web Services account has a different default KMS key for each
    #   Amazon Web Services Region.
    #
    # @option params [String] :engine
    #   The target Oracle DB engine when you convert a non-CDB to a CDB. This
    #   intermediate step is necessary to upgrade an Oracle Database 19c
    #   non-CDB to an Oracle Database 21c CDB.
    #
    #   Note the following requirements:
    #
    #   * Make sure that you specify `oracle-ee-cdb` or `oracle-se2-cdb`.
    #
    #   * Make sure that your DB engine runs Oracle Database 19c with an April
    #     2021 or later RU.
    #
    #   Note the following limitations:
    #
    #   * You can't convert a CDB to a non-CDB.
    #
    #   * You can't convert a replica database.
    #
    #   * You can't convert a non-CDB to a CDB and upgrade the engine version
    #     in the same command.
    #
    #   * You can't convert the existing custom parameter or option group
    #     when it has options or parameters that are permanent or persistent.
    #     In this situation, the DB instance reverts to the default option and
    #     parameter group. To avoid reverting to the default, specify a new
    #     parameter group with `--db-parameter-group-name` and a new option
    #     group with `--option-group-name`.
    #
    # @option params [Boolean] :dedicated_log_volume
    #   Indicates whether the DB instance has a dedicated log volume (DLV)
    #   enabled.
    #
    # @option params [Boolean] :multi_tenant
    #   Specifies whether the to convert your DB instance from the
    #   single-tenant conﬁguration to the multi-tenant conﬁguration. This
    #   parameter is supported only for RDS for Oracle CDB instances.
    #
    #   During the conversion, RDS creates an initial tenant database and
    #   associates the DB name, master user name, character set, and national
    #   character set metadata with this database. The tags associated with
    #   the instance also propagate to the initial tenant database. You can
    #   add more tenant databases to your DB instance by using the
    #   `CreateTenantDatabase` operation.
    #
    #   The conversion to the multi-tenant configuration is permanent and
    #   irreversible, so you can't later convert back to the single-tenant
    #   configuration. When you specify this parameter, you must also specify
    #   `ApplyImmediately`.
    #
    # @return [Types::ModifyDBInstanceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ModifyDBInstanceResult#db_instance #db_instance} => Types::DBInstance
    #
    #
    # @example Example: To modify a DB instance
    #
    #   # The following example associates an option group and a parameter group with a compatible Microsoft SQL Server DB
    #   # instance. The ApplyImmediately parameter causes the option and parameter groups to be associated immediately, instead of
    #   # waiting until the next maintenance window.
    #
    #   resp = client.modify_db_instance({
    #     apply_immediately: true, 
    #     db_instance_identifier: "database-2", 
    #     db_parameter_group_name: "test-sqlserver-se-2017", 
    #     option_group_name: "test-se-2017", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_instance: {
    #       associated_roles: [
    #       ], 
    #       auto_minor_version_upgrade: false, 
    #       availability_zone: "us-west-2d", 
    #       character_set_name: "SQL_Latin1_General_CP1_CI_AS", 
    #       db_instance_class: "db.r4.large", 
    #       db_instance_identifier: "database-2", 
    #       db_instance_status: "available", 
    #       db_parameter_groups: [
    #         {
    #           db_parameter_group_name: "test-sqlserver-se-2017", 
    #           parameter_apply_status: "applying", 
    #         }, 
    #       ], 
    #       deletion_protection: false, 
    #       engine: "sqlserver-se", 
    #       engine_version: "14.00.3281.6.v1", 
    #       license_model: "license-included", 
    #       max_allocated_storage: 1000, 
    #       multi_az: true, 
    #       option_group_memberships: [
    #         {
    #           option_group_name: "test-se-2017", 
    #           status: "pending-apply", 
    #         }, 
    #       ], 
    #       publicly_accessible: true, 
    #       read_replica_db_instance_identifiers: [
    #       ], 
    #       secondary_availability_zone: "us-west-2c", 
    #       storage_type: "gp2", 
    #     }, # Some output ommitted.
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_db_instance({
    #     db_instance_identifier: "String", # required
    #     allocated_storage: 1,
    #     db_instance_class: "String",
    #     db_subnet_group_name: "String",
    #     db_security_groups: ["String"],
    #     vpc_security_group_ids: ["String"],
    #     apply_immediately: false,
    #     master_user_password: "String",
    #     db_parameter_group_name: "String",
    #     backup_retention_period: 1,
    #     preferred_backup_window: "String",
    #     preferred_maintenance_window: "String",
    #     multi_az: false,
    #     engine_version: "String",
    #     allow_major_version_upgrade: false,
    #     auto_minor_version_upgrade: false,
    #     license_model: "String",
    #     iops: 1,
    #     option_group_name: "String",
    #     new_db_instance_identifier: "String",
    #     storage_type: "String",
    #     tde_credential_arn: "String",
    #     tde_credential_password: "String",
    #     ca_certificate_identifier: "String",
    #     domain: "String",
    #     domain_fqdn: "String",
    #     domain_ou: "String",
    #     domain_auth_secret_arn: "String",
    #     domain_dns_ips: ["String"],
    #     copy_tags_to_snapshot: false,
    #     monitoring_interval: 1,
    #     db_port_number: 1,
    #     publicly_accessible: false,
    #     monitoring_role_arn: "String",
    #     domain_iam_role_name: "String",
    #     disable_domain: false,
    #     promotion_tier: 1,
    #     enable_iam_database_authentication: false,
    #     database_insights_mode: "standard", # accepts standard, advanced
    #     enable_performance_insights: false,
    #     performance_insights_kms_key_id: "String",
    #     performance_insights_retention_period: 1,
    #     cloudwatch_logs_export_configuration: {
    #       enable_log_types: ["String"],
    #       disable_log_types: ["String"],
    #     },
    #     processor_features: [
    #       {
    #         name: "String",
    #         value: "String",
    #       },
    #     ],
    #     use_default_processor_features: false,
    #     deletion_protection: false,
    #     max_allocated_storage: 1,
    #     certificate_rotation_restart: false,
    #     replica_mode: "open-read-only", # accepts open-read-only, mounted
    #     enable_customer_owned_ip: false,
    #     aws_backup_recovery_point_arn: "AwsBackupRecoveryPointArn",
    #     automation_mode: "full", # accepts full, all-paused
    #     resume_full_automation_mode_minutes: 1,
    #     network_type: "String",
    #     storage_throughput: 1,
    #     manage_master_user_password: false,
    #     rotate_master_user_password: false,
    #     master_user_secret_kms_key_id: "String",
    #     engine: "String",
    #     dedicated_log_volume: false,
    #     multi_tenant: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.db_instance.db_instance_identifier #=> String
    #   resp.db_instance.db_instance_class #=> String
    #   resp.db_instance.engine #=> String
    #   resp.db_instance.db_instance_status #=> String
    #   resp.db_instance.automatic_restart_time #=> Time
    #   resp.db_instance.master_username #=> String
    #   resp.db_instance.db_name #=> String
    #   resp.db_instance.endpoint.address #=> String
    #   resp.db_instance.endpoint.port #=> Integer
    #   resp.db_instance.endpoint.hosted_zone_id #=> String
    #   resp.db_instance.allocated_storage #=> Integer
    #   resp.db_instance.instance_create_time #=> Time
    #   resp.db_instance.preferred_backup_window #=> String
    #   resp.db_instance.backup_retention_period #=> Integer
    #   resp.db_instance.db_security_groups #=> Array
    #   resp.db_instance.db_security_groups[0].db_security_group_name #=> String
    #   resp.db_instance.db_security_groups[0].status #=> String
    #   resp.db_instance.vpc_security_groups #=> Array
    #   resp.db_instance.vpc_security_groups[0].vpc_security_group_id #=> String
    #   resp.db_instance.vpc_security_groups[0].status #=> String
    #   resp.db_instance.db_parameter_groups #=> Array
    #   resp.db_instance.db_parameter_groups[0].db_parameter_group_name #=> String
    #   resp.db_instance.db_parameter_groups[0].parameter_apply_status #=> String
    #   resp.db_instance.availability_zone #=> String
    #   resp.db_instance.db_subnet_group.db_subnet_group_name #=> String
    #   resp.db_instance.db_subnet_group.db_subnet_group_description #=> String
    #   resp.db_instance.db_subnet_group.vpc_id #=> String
    #   resp.db_instance.db_subnet_group.subnet_group_status #=> String
    #   resp.db_instance.db_subnet_group.subnets #=> Array
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_identifier #=> String
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_availability_zone.name #=> String
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_outpost.arn #=> String
    #   resp.db_instance.db_subnet_group.subnets[0].subnet_status #=> String
    #   resp.db_instance.db_subnet_group.db_subnet_group_arn #=> String
    #   resp.db_instance.db_subnet_group.supported_network_types #=> Array
    #   resp.db_instance.db_subnet_group.supported_network_types[0] #=> String
    #   resp.db_instance.preferred_maintenance_window #=> String
    #   resp.db_instance.pending_modified_values.db_instance_class #=> String
    #   resp.db_instance.pending_modified_values.allocated_storage #=> Integer
    #   resp.db_instance.pending_modified_values.master_user_password #=> String
    #   resp.db_instance.pending_modified_values.port #=> Integer
    #   resp.db_instance.pending_modified_values.backup_retention_period #=> Integer
    #   resp.db_instance.pending_modified_values.multi_az #=> Boolean
    #   resp.db_instance.pending_modified_values.engine_version #=> String
    #   resp.db_instance.pending_modified_values.license_model #=> String
    #   resp.db_instance.pending_modified_values.iops #=> Integer
    #   resp.db_instance.pending_modified_values.db_instance_identifier #=> String
    #   resp.db_instance.pending_modified_values.storage_type #=> String
    #   resp.db_instance.pending_modified_values.ca_certificate_identifier #=> String
    #   resp.db_instance.pending_modified_values.db_subnet_group_name #=> String
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable #=> Array
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_enable[0] #=> String
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable #=> Array
    #   resp.db_instance.pending_modified_values.pending_cloudwatch_logs_exports.log_types_to_disable[0] #=> String
    #   resp.db_instance.pending_modified_values.processor_features #=> Array
    #   resp.db_instance.pending_modified_values.processor_features[0].name #=> String
    #   resp.db_instance.pending_modified_values.processor_features[0].value #=> String
    #   resp.db_instance.pending_modified_values.iam_database_authentication_enabled #=> Boolean
    #   resp.db_instance.pending_modified_values.automation_mode #=> String, one of "full", "all-paused"
    #   resp.db_instance.pending_modified_values.resume_full_automation_mode_time #=> Time
    #   resp.db_instance.pending_modified_values.storage_throughput #=> Integer
    #   resp.db_instance.pending_modified_values.engine #=> String
    #   resp.db_instance.pending_modified_values.dedicated_log_volume #=> Boolean
    #   resp.db_instance.pending_modified_values.multi_tenant #=> Boolean
    #   resp.db_instance.latest_restorable_time #=> Time
    #   resp.db_instance.multi_az #=> Boolean
    #   resp.db_instance.engine_version #=> String
    #   resp.db_instance.auto_minor_version_upgrade #=> Boolean
    #   resp.db_instance.read_replica_source_db_instance_identifier #=> String
    #   resp.db_instance.read_replica_db_instance_identifiers #=> Array
    #   resp.db_instance.read_replica_db_instance_identifiers[0] #=> String
    #   resp.db_instance.read_replica_db_cluster_identifiers #=> Array
    #   resp.db_instance.read_replica_db_cluster_identifiers[0] #=> String
    #   resp.db_instance.replica_mode #=> String, one of "open-read-only", "mounted"
    #   resp.db_instance.license_model #=> String
    #   resp.db_instance.iops #=> Integer
    #   resp.db_instance.option_group_memberships #=> Array
    #   resp.db_instance.option_group_memberships[0].option_group_name #=> String
    #   resp.db_instance.option_group_memberships[0].status #=> String
    #   resp.db_instance.character_set_name #=> String
    #   resp.db_instance.nchar_character_set_name #=> String
    #   resp.db_instance.secondary_availability_zone #=> String
    #   resp.db_instance.publicly_accessible #=> Boolean
    #   resp.db_instance.status_infos #=> Array
    #   resp.db_instance.status_infos[0].status_type #=> String
    #   resp.db_instance.status_infos[0].normal #=> Boolean
    #   resp.db_instance.status_infos[0].status #=> String
    #   resp.db_instance.status_infos[0].message #=> String
    #   resp.db_instance.storage_type #=> String
    #   resp.db_instance.tde_credential_arn #=> String
    #   resp.db_instance.db_instance_port #=> Integer
    #   resp.db_instance.db_cluster_identifier #=> String
    #   resp.db_instance.storage_encrypted #=> Boolean
    #   resp.db_instance.kms_key_id #=> String
    #   resp.db_instance.dbi_resource_id #=> String
    #   resp.db_instance.ca_certificate_identifier #=> String
    #   resp.db_instance.domain_memberships #=> Array
    #   resp.db_instance.domain_memberships[0].domain #=> String
    #   resp.db_instance.domain_memberships[0].status #=> String
    #   resp.db_instance.domain_memberships[0].fqdn #=> String
    #   resp.db_instance.domain_memberships[0].iam_role_name #=> String
    #   resp.db_instance.domain_memberships[0].ou #=> String
    #   resp.db_instance.domain_memberships[0].auth_secret_arn #=> String
    #   resp.db_instance.domain_memberships[0].dns_ips #=> Array
    #   resp.db_instance.domain_memberships[0].dns_ips[0] #=> String
    #   resp.db_instance.copy_tags_to_snapshot #=> Boolean
    #   resp.db_instance.monitoring_interval #=> Integer
    #   resp.db_instance.enhanced_monitoring_resource_arn #=> String
    #   resp.db_instance.monitoring_role_arn #=> String
    #   resp.db_instance.promotion_tier #=> Integer
    #   resp.db_instance.db_instance_arn #=> String
    #   resp.db_instance.timezone #=> String
    #   resp.db_instance.iam_database_authentication_enabled #=> Boolean
    #   resp.db_instance.database_insights_mode #=> String, one of "standard", "advanced"
    #   resp.db_instance.performance_insights_enabled #=> Boolean
    #   resp.db_instance.performance_insights_kms_key_id #=> String
    #   resp.db_instance.performance_insights_retention_period #=> Integer
    #   resp.db_instance.enabled_cloudwatch_logs_exports #=> Array
    #   resp.db_instance.enabled_cloudwatch_logs_exports[0] #=> String
    #   resp.db_instance.processor_features #=> Array
    #   resp.db_instance.processor_features[0].name #=> String
    #   resp.db_instance.processor_features[0].value #=> String
    #   resp.db_instance.deletion_protection #=> Boolean
    #   resp.db_instance.associated_roles #=> Array
    #   resp.db_instance.associated_roles[0].role_arn #=> String
    #   resp.db_instance.associated_roles[0].feature_name #=> String
    #   resp.db_instance.associated_roles[0].status #=> String
    #   resp.db_instance.listener_endpoint.address #=> String
    #   resp.db_instance.listener_endpoint.port #=> Integer
    #   resp.db_instance.listener_endpoint.hosted_zone_id #=> String
    #   resp.db_instance.max_allocated_storage #=> Integer
    #   resp.db_instance.tag_list #=> Array
    #   resp.db_instance.tag_list[0].key #=> String
    #   resp.db_instance.tag_list[0].value #=> String
    #   resp.db_instance.db_instance_automated_backups_replications #=> Array
    #   resp.db_instance.db_instance_automated_backups_replications[0].db_instance_automated_backups_arn #=> String
    #   resp.db_instance.customer_owned_ip_enabled #=> Boolean
    #   resp.db_instance.aws_backup_recovery_point_arn #=> String
    #   resp.db_instance.activity_stream_status #=> String, one of "stopped", "starting", "started", "stopping"
    #   resp.db_instance.activity_stream_kms_key_id #=> String
    #   resp.db_instance.activity_stream_kinesis_stream_name #=> String
    #   resp.db_instance.activity_stream_mode #=> String, one of "sync", "async"
    #   resp.db_instance.activity_stream_engine_native_audit_fields_included #=> Boolean
    #   resp.db_instance.automation_mode #=> String, one of "full", "all-paused"
    #   resp.db_instance.resume_full_automation_mode_time #=> Time
    #   resp.db_instance.custom_iam_instance_profile #=> String
    #   resp.db_instance.backup_target #=> String
    #   resp.db_instance.network_type #=> String
    #   resp.db_instance.activity_stream_policy_status #=> String, one of "locked", "unlocked", "locking-policy", "unlocking-policy"
    #   resp.db_instance.storage_throughput #=> Integer
    #   resp.db_instance.db_system_id #=> String
    #   resp.db_instance.master_user_secret.secret_arn #=> String
    #   resp.db_instance.master_user_secret.secret_status #=> String
    #   resp.db_instance.master_user_secret.kms_key_id #=> String
    #   resp.db_instance.certificate_details.ca_identifier #=> String
    #   resp.db_instance.certificate_details.valid_till #=> Time
    #   resp.db_instance.read_replica_source_db_cluster_identifier #=> String
    #   resp.db_instance.percent_progress #=> String
    #   resp.db_instance.dedicated_log_volume #=> Boolean
    #   resp.db_instance.is_storage_config_upgrade_available #=> Boolean
    #   resp.db_instance.multi_tenant #=> Boolean
    #   resp.db_instance.engine_lifecycle_support #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBInstance AWS API Documentation
    #
    # @overload modify_db_instance(params = {})
    # @param [Hash] params ({})
    def modify_db_instance(params = {}, options = {})
      req = build_request(:modify_db_instance, params)
      req.send_request(options)
    end

    # Modifies the parameters of a DB parameter group. To modify more than
    # one parameter, submit a list of the following: `ParameterName`,
    # `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be
    # modified in a single request.
    #
    # After you modify a DB parameter group, you should wait at least 5
    # minutes before creating your first DB instance that uses that DB
    # parameter group as the default parameter group. This allows Amazon RDS
    # to fully complete the modify operation before the parameter group is
    # used as the default for a new DB instance. This is especially
    # important for parameters that are critical when creating the default
    # database for a DB instance, such as the character set for the default
    # database defined by the `character_set_database` parameter. You can
    # use the *Parameter Groups* option of the [Amazon RDS console][1] or
    # the *DescribeDBParameters* command to verify that your DB parameter
    # group has been created or modified.
    #
    #
    #
    # [1]: https://console.aws.amazon.com/rds/
    #
    # @option params [required, String] :db_parameter_group_name
    #   The name of the DB parameter group.
    #
    #   Constraints:
    #
    #   * If supplied, must match the name of an existing `DBParameterGroup`.
    #
    #   ^
    #
    # @option params [required, Array<Types::Parameter>] :parameters
    #   An array of parameter names, values, and the application methods for
    #   the parameter update. At least one parameter name, value, and
    #   application method must be supplied; later arguments are optional. A
    #   maximum of 20 parameters can be modified in a single request.
    #
    #   Valid Values (for the application method): `immediate |
    #   pending-reboot`
    #
    #   You can use the `immediate` value with dynamic parameters only. You
    #   can use the `pending-reboot` value for both dynamic and static
    #   parameters.
    #
    #   When the application method is `immediate`, changes to dynamic
    #   parameters are applied immediately to the DB instances associated with
    #   the parameter group.
    #
    #   When the application method is `pending-reboot`, changes to dynamic
    #   and static parameters are applied after a reboot without failover to
    #   the DB instances associated with the parameter group.
    #
    #   <note markdown="1"> You can't use `pending-reboot` with dynamic parameters on RDS for SQL
    #   Server DB instances. Use `immediate`.
    #
    #    </note>
    #
    #   For more information on modifying DB parameters, see [Working with DB
    #   parameter groups][1] in the *Amazon RDS User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html
    #
    # @return [Types::DBParameterGroupNameMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBParameterGroupNameMessage#db_parameter_group_name #db_parameter_group_name} => String
    #
    #
    # @example Example: To modify a DB parameter group
    #
    #   # The following example changes the value of the clr enabled parameter in a DB parameter group. The value of the
    #   # ApplyMethod parameter causes the DB parameter group to be modified immediately, instead of waiting until the next
    #   # maintenance window.
    #
    #   resp = client.modify_db_parameter_group({
    #     db_parameter_group_name: "test-sqlserver-se-2017", 
    #     parameters: [
    #       {
    #         apply_method: "immediate", 
    #         parameter_name: "clr enabled", 
    #         parameter_value: "1", 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     db_parameter_group_name: "test-sqlserver-se-2017", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_db_parameter_group({
    #     db_parameter_group_name: "String", # required
    #     parameters: [ # required
    #       {
    #         parameter_name: "String",
    #         parameter_value: "String",
    #         description: "String",
    #         source: "String",
    #         apply_type: "String",
    #         data_type: "String",
    #         allowed_values: "String",
    #         is_modifiable: false,
    #         minimum_engine_version: "String",
    #         apply_method: "immediate", # accepts immediate, pending-reboot
    #         supported_engine_modes: ["String"],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_parameter_group_name #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBParameterGroup AWS API Documentation
    #
    # @overload modify_db_parameter_group(params = {})
    # @param [Hash] params ({})
    def modify_db_parameter_group(params = {}, options = {})
      req = build_request(:modify_db_parameter_group, params)
      req.send_request(options)
    end

    # Changes the settings for an existing DB proxy.
    #
    # @option params [required, String] :db_proxy_name
    #   The identifier for the `DBProxy` to modify.
    #
    # @option params [String] :new_db_proxy_name
    #   The new identifier for the `DBProxy`. An identifier must begin with a
    #   letter and must contain only ASCII letters, digits, and hyphens; it
    #   can't end with a hyphen or contain two consecutive hyphens.
    #
    # @option params [Array<Types::UserAuthConfig>] :auth
    #   The new authentication settings for the `DBProxy`.
    #
    # @option params [Boolean] :require_tls
    #   Whether Transport Layer Security (TLS) encryption is required for
    #   connections to the proxy. By enabling this setting, you can enforce
    #   encrypted TLS connections to the proxy, even if the associated
    #   database doesn't use TLS.
    #
    # @option params [Integer] :idle_client_timeout
    #   The number of seconds that a connection to the proxy can be inactive
    #   before the proxy disconnects it. You can set this value higher or
    #   lower than the connection timeout limit for the associated database.
    #
    # @option params [Boolean] :debug_logging
    #   Specifies whether the proxy logs detailed connection and query
    #   information. When you enable `DebugLogging`, the proxy captures
    #   connection details and connection pool behavior from your queries.
    #   Debug logging increases CloudWatch costs and can impact proxy
    #   performance. Enable this option only when you need to troubleshoot
    #   connection or performance issues.
    #
    # @option params [String] :role_arn
    #   The Amazon Resource Name (ARN) of the IAM role that the proxy uses to
    #   access secrets in Amazon Web Services Secrets Manager.
    #
    # @option params [Array<String>] :security_groups
    #   The new list of security groups for the `DBProxy`.
    #
    # @return [Types::ModifyDBProxyResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ModifyDBProxyResponse#db_proxy #db_proxy} => Types::DBProxy
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_db_proxy({
    #     db_proxy_name: "String", # required
    #     new_db_proxy_name: "String",
    #     auth: [
    #       {
    #         description: "String",
    #         user_name: "String",
    #         auth_scheme: "SECRETS", # accepts SECRETS
    #         secret_arn: "String",
    #         iam_auth: "DISABLED", # accepts DISABLED, REQUIRED, ENABLED
    #         client_password_auth_type: "MYSQL_NATIVE_PASSWORD", # accepts MYSQL_NATIVE_PASSWORD, MYSQL_CACHING_SHA2_PASSWORD, POSTGRES_SCRAM_SHA_256, POSTGRES_MD5, SQL_SERVER_AUTHENTICATION
    #       },
    #     ],
    #     require_tls: false,
    #     idle_client_timeout: 1,
    #     debug_logging: false,
    #     role_arn: "String",
    #     security_groups: ["String"],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_proxy.db_proxy_name #=> String
    #   resp.db_proxy.db_proxy_arn #=> String
    #   resp.db_proxy.status #=> String, one of "available", "modifying", "incompatible-network", "insufficient-resource-limits", "creating", "deleting", "suspended", "suspending", "reactivating"
    #   resp.db_proxy.engine_family #=> String
    #   resp.db_proxy.vpc_id #=> String
    #   resp.db_proxy.vpc_security_group_ids #=> Array
    #   resp.db_proxy.vpc_security_group_ids[0] #=> String
    #   resp.db_proxy.vpc_subnet_ids #=> Array
    #   resp.db_proxy.vpc_subnet_ids[0] #=> String
    #   resp.db_proxy.auth #=> Array
    #   resp.db_proxy.auth[0].description #=> String
    #   resp.db_proxy.auth[0].user_name #=> String
    #   resp.db_proxy.auth[0].auth_scheme #=> String, one of "SECRETS"
    #   resp.db_proxy.auth[0].secret_arn #=> String
    #   resp.db_proxy.auth[0].iam_auth #=> String, one of "DISABLED", "REQUIRED", "ENABLED"
    #   resp.db_proxy.auth[0].client_password_auth_type #=> String, one of "MYSQL_NATIVE_PASSWORD", "MYSQL_CACHING_SHA2_PASSWORD", "POSTGRES_SCRAM_SHA_256", "POSTGRES_MD5", "SQL_SERVER_AUTHENTICATION"
    #   resp.db_proxy.role_arn #=> String
    #   resp.db_proxy.endpoint #=> String
    #   resp.db_proxy.require_tls #=> Boolean
    #   resp.db_proxy.idle_client_timeout #=> Integer
    #   resp.db_proxy.debug_logging #=> Boolean
    #   resp.db_proxy.created_date #=> Time
    #   resp.db_proxy.updated_date #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxy AWS API Documentation
    #
    # @overload modify_db_proxy(params = {})
    # @param [Hash] params ({})
    def modify_db_proxy(params = {}, options = {})
      req = build_request(:modify_db_proxy, params)
      req.send_request(options)
    end

    # Changes the settings for an existing DB proxy endpoint.
    #
    # @option params [required, String] :db_proxy_endpoint_name
    #   The name of the DB proxy sociated with the DB proxy endpoint that you
    #   want to modify.
    #
    # @option params [String] :new_db_proxy_endpoint_name
    #   The new identifier for the `DBProxyEndpoint`. An identifier must begin
    #   with a letter and must contain only ASCII letters, digits, and
    #   hyphens; it can't end with a hyphen or contain two consecutive
    #   hyphens.
    #
    # @option params [Array<String>] :vpc_security_group_ids
    #   The VPC security group IDs for the DB proxy endpoint. When the DB
    #   proxy endpoint uses a different VPC than the original proxy, you also
    #   specify a different set of security group IDs than for the original
    #   proxy.
    #
    # @return [Types::ModifyDBProxyEndpointResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ModifyDBProxyEndpointResponse#db_proxy_endpoint #db_proxy_endpoint} => Types::DBProxyEndpoint
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_db_proxy_endpoint({
    #     db_proxy_endpoint_name: "DBProxyEndpointName", # required
    #     new_db_proxy_endpoint_name: "DBProxyEndpointName",
    #     vpc_security_group_ids: ["String"],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_proxy_endpoint.db_proxy_endpoint_name #=> String
    #   resp.db_proxy_endpoint.db_proxy_endpoint_arn #=> String
    #   resp.db_proxy_endpoint.db_proxy_name #=> String
    #   resp.db_proxy_endpoint.status #=> String, one of "available", "modifying", "incompatible-network", "insufficient-resource-limits", "creating", "deleting"
    #   resp.db_proxy_endpoint.vpc_id #=> String
    #   resp.db_proxy_endpoint.vpc_security_group_ids #=> Array
    #   resp.db_proxy_endpoint.vpc_security_group_ids[0] #=> String
    #   resp.db_proxy_endpoint.vpc_subnet_ids #=> Array
    #   resp.db_proxy_endpoint.vpc_subnet_ids[0] #=> String
    #   resp.db_proxy_endpoint.endpoint #=> String
    #   resp.db_proxy_endpoint.created_date #=> Time
    #   resp.db_proxy_endpoint.target_role #=> String, one of "READ_WRITE", "READ_ONLY"
    #   resp.db_proxy_endpoint.is_default #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxyEndpoint AWS API Documentation
    #
    # @overload modify_db_proxy_endpoint(params = {})
    # @param [Hash] params ({})
    def modify_db_proxy_endpoint(params = {}, options = {})
      req = build_request(:modify_db_proxy_endpoint, params)
      req.send_request(options)
    end

    # Modifies the properties of a `DBProxyTargetGroup`.
    #
    # @option params [required, String] :target_group_name
    #   The name of the target group to modify.
    #
    # @option params [required, String] :db_proxy_name
    #   The name of the proxy.
    #
    # @option params [Types::ConnectionPoolConfiguration] :connection_pool_config
    #   The settings that determine the size and behavior of the connection
    #   pool for the target group.
    #
    # @option params [String] :new_name
    #   The new name for the modified `DBProxyTarget`. An identifier must
    #   begin with a letter and must contain only ASCII letters, digits, and
    #   hyphens; it can't end with a hyphen or contain two consecutive
    #   hyphens.
    #
    #   You can't rename the `default` target group.
    #
    # @return [Types::ModifyDBProxyTargetGroupResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ModifyDBProxyTargetGroupResponse#db_proxy_target_group #db_proxy_target_group} => Types::DBProxyTargetGroup
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_db_proxy_target_group({
    #     target_group_name: "String", # required
    #     db_proxy_name: "String", # required
    #     connection_pool_config: {
    #       max_connections_percent: 1,
    #       max_idle_connections_percent: 1,
    #       connection_borrow_timeout: 1,
    #       session_pinning_filters: ["String"],
    #       init_query: "String",
    #     },
    #     new_name: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.db_proxy_target_group.db_proxy_name #=> String
    #   resp.db_proxy_target_group.target_group_name #=> String
    #   resp.db_proxy_target_group.target_group_arn #=> String
    #   resp.db_proxy_target_group.is_default #=> Boolean
    #   resp.db_proxy_target_group.status #=> String
    #   resp.db_proxy_target_group.connection_pool_config.max_connections_percent #=> Integer
    #   resp.db_proxy_target_group.connection_pool_config.max_idle_connections_percent #=> Integer
    #   resp.db_proxy_target_group.connection_pool_config.connection_borrow_timeout #=> Integer
    #   resp.db_proxy_target_group.connection_pool_config.session_pinning_filters #=> Array
    #   resp.db_proxy_target_group.connection_pool_config.session_pinning_filters[0] #=> String
    #   resp.db_proxy_target_group.connection_pool_config.init_query #=> String
    #   resp.db_proxy_target_group.created_date #=> Time
    #   resp.db_proxy_target_group.updated_date #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxyTargetGroup AWS API Documentation
    #
    # @overload modify_db_proxy_target_group(params = {})
    # @param [Hash] params ({})
    def modify_db_proxy_target_group(params = {}, options = {})
      req = build_request(:modify_db_proxy_target_group, params)
      req.send_request(options)
    end

    # Updates the recommendation status and recommended action status for
    # the specified recommendation.
    #
    # @option params [required, String] :recommendation_id
    #   The identifier of the recommendation to update.
    #
    # @option params [String] :locale
    #   The language of the modified recommendation.
    #
    # @option params [String] :status
    #   The recommendation status to update.
    #
    #   Valid values:
    #
    #   * active
    #
    #   * dismissed
    #
    # @option params [Array<Types::RecommendedActionUpdate>] :recommended_action_updates
    #   The list of recommended action status to update. You can update
    #   multiple recommended actions at one time.
    #
    # @return [Types::DBRecommendationMessage] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DBRecommendationMessage#db_recommendation #db_recommendation} => Types::DBRecommendation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_db_recommendation({
    #     recommendation_id: "String", # required
    #     locale: "String",
    #     status: "String",
    #     recommended_action_updates: [
    #       {
    #         action_id: "String", # required
    #         status: "String", # required
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.db_recommendation.recommendation_id #=> String
    #   resp.db_recommendation.type_id #=> String
    #   resp.db_recommendation.severity #=> String
    #   resp.db_recommendation.resource_arn #=> String
    #   resp.db_recommendation.status #=> String
    #   resp.db_recommendation.created_time #=> Time
    #   resp.db_recommendation.updated_time #=> Time
    #   resp.db_recommendation.detection #=> String
    #   resp.db_recommendation.recommendation #=> String
    #   resp.db_recommendation.description #=> String
    #   resp.db_recommendation.reason #=> String
    #   resp.db_recommendation.recommended_actions #=> Array
    #   resp.db_recommendation.recommended_actions[0].action_id #=> String
    #   resp.db_recommendation.recommended_actions[0].title #=> String
    #   resp.db_recommendation.recommended_actions[0].description #=> String
    #   resp.db_recommendation.recommended_actions[0].operation #=> String
    #   resp.db_recommendation.recommended_actions[0].parameters #=> Array
    #   resp.db_recommendation.recommended_actions[0].parameters[0].key #=> String
    #   resp.db_recommendation.recommended_actions[0].parameters[0].value #=> String
    #   resp.db_recommendation.recommended_actions[0].apply_modes #=> Array
    #   resp.db_recommendation.recommended_actions[0].apply_modes[0] #=> String
    #   resp.db_recommendation.recommended_actions[0].status #=> String
    #   resp.db_recommendation.recommended_actions[0].issue_details.performance_issue_details.start_time #=> Time
    #   resp.db_recommendation.recommended_actions[0].issue_details.performance_issue_details.end_time #=> Time
    #   resp.db_recommendation.recommended_actions[0].issue_details.performance_issue_details.metrics #=> Array
    #   resp.db_recommendation.recommended_actions[0].issue_details.performance_issue_details.metrics[0].name #=> String
    #   resp.db_recommendation.recommended_actions[0].issue_details.performance_issue_details.metrics[0].references #=> Array
    #   resp.db_recommendation.recommended_actions[0].issue_details.performance_issue_details.metrics[0].references[0].name #=> String
    #   resp.db_recommendation.recommended_actions[0].issue_details.performance_issue_details.metrics[0].references[0].reference_details.scalar_reference_details.value #=> Float
    #   resp.db_recommendation.recommended_actions[0].issue_details.performance_issue_details.metrics[0].statistics_details #=> String
    #   resp.db_recommendation.recommended_actions[0].issue_details.performance_issue_details.metrics[0].metric_query.performa