# frozen_string_literal: true

# WARNING ABOUT GENERATED CODE
#
# This file is generated. See the contributing guide for more information:
# https://github.com/aws/aws-sdk-ruby/blob/version-3/CONTRIBUTING.md
#
# WARNING ABOUT GENERATED CODE

require 'aws-sdk-core/waiters'

module Aws::EKS
  # Waiters are utility methods that poll for a particular state to occur
  # on a client. Waiters can fail after a number of attempts at a polling
  # interval defined for the service client.
  #
  # For a list of operations that can be waited for and the
  # client methods called for each operation, see the table below or the
  # {Client#wait_until} field documentation for the {Client}.
  #
  # # Invoking a Waiter
  # To invoke a waiter, call #wait_until on a {Client}. The first parameter
  # is the waiter name, which is specific to the service client and indicates
  # which operation is being waited for. The second parameter is a hash of
  # parameters that are passed to the client method called by the waiter,
  # which varies according to the waiter name.
  #
  # # Wait Failures
  # To catch errors in a waiter, use WaiterFailed,
  # as shown in the following example.
  #
  #     rescue rescue Aws::Waiters::Errors::WaiterFailed => error
  #       puts "failed waiting for instance running: #{error.message}
  #     end
  #
  # # Configuring a Waiter
  # Each waiter has a default polling interval and a maximum number of
  # attempts it will make before returning control to your program.
  # To set these values, use the `max_attempts` and `delay` parameters
  # in your `#wait_until` call.
  # The following example waits for up to 25 seconds, polling every five seconds.
  #
  #     client.wait_until(...) do |w|
  #       w.max_attempts = 5
  #       w.delay = 5
  #     end
  #
  # To disable wait failures, set the value of either of these parameters
  # to `nil`.
  #
  # # Extending a Waiter
  # To modify the behavior of waiters, you can register callbacks that are
  # triggered before each polling attempt and before waiting.
  #
  # The following example implements an exponential backoff in a waiter
  # by doubling the amount of time to wait on every attempt.
  #
  #     client.wait_until(...) do |w|
  #       w.interval = 0 # disable normal sleep
  #       w.before_wait do |n, resp|
  #         sleep(n ** 2)
  #       end
  #     end
  #
  # # Available Waiters
  #
  # The following table lists the valid waiter names, the operations they call,
  # and the default `:delay` and `:max_attempts` values.
  #
  # | waiter_name             | params                            | :delay   | :max_attempts |
  # | ----------------------- | --------------------------------- | -------- | ------------- |
  # | addon_active            | {Client#describe_addon}           | 10       | 60            |
  # | addon_deleted           | {Client#describe_addon}           | 10       | 60            |
  # | cluster_active          | {Client#describe_cluster}         | 30       | 40            |
  # | cluster_deleted         | {Client#describe_cluster}         | 30       | 40            |
  # | fargate_profile_active  | {Client#describe_fargate_profile} | 10       | 60            |
  # | fargate_profile_deleted | {Client#describe_fargate_profile} | 30       | 60            |
  # | nodegroup_active        | {Client#describe_nodegroup}       | 30       | 80            |
  # | nodegroup_deleted       | {Client#describe_nodegroup}       | 30       | 40            |
  #
  module Waiters

    class AddonActive

      # @param [Hash] options
      # @option options [required, Client] :client
      # @option options [Integer] :max_attempts (60)
      # @option options [Integer] :delay (10)
      # @option options [Proc] :before_attempt
      # @option options [Proc] :before_wait
      def initialize(options)
        @client = options.fetch(:client)
        @waiter = Aws::Waiters::Waiter.new({
          max_attempts: 60,
          delay: 10,
          poller: Aws::Waiters::Poller.new(
            operation_name: :describe_addon,
            acceptors: [
              {
                "expected" => "CREATE_FAILED",
                "matcher" => "path",
                "state" => "failure",
                "argument" => "addon.status"
              },
              {
                "expected" => "DEGRADED",
                "matcher" => "path",
                "state" => "failure",
                "argument" => "addon.status"
              },
              {
                "expected" => "ACTIVE",
                "matcher" => "path",
                "state" => "success",
                "argument" => "addon.status"
              }
            ]
          )
        }.merge(options))
      end

      # @option (see Client#describe_addon)
      # @return (see Client#describe_addon)
      def wait(params = {})
        @waiter.wait(client: @client, params: params)
      end

      # @api private
      attr_reader :waiter

    end

    class AddonDeleted

      # @param [Hash] options
      # @option options [required, Client] :client
      # @option options [Integer] :max_attempts (60)
      # @option options [Integer] :delay (10)
      # @option options [Proc] :before_attempt
      # @option options [Proc] :before_wait
      def initialize(options)
        @client = options.fetch(:client)
        @waiter = Aws::Waiters::Waiter.new({
          max_attempts: 60,
          delay: 10,
          poller: Aws::Waiters::Poller.new(
            operation_name: :describe_addon,
            acceptors: [
              {
                "expected" => "DELETE_FAILED",
                "matcher" => "path",
                "state" => "failure",
                "argument" => "addon.status"
              },
              {
                "expected" => "ResourceNotFoundException",
                "matcher" => "error",
                "state" => "success"
              }
            ]
          )
        }.merge(options))
      end

      # @option (see Client#describe_addon)
      # @return (see Client#describe_addon)
      def wait(params = {})
        @waiter.wait(client: @client, params: params)
      end

      # @api private
      attr_reader :waiter

    end

    class ClusterActive

      # @param [Hash] options
      # @option options [required, Client] :client
      # @option options [Integer] :max_attempts (40)
      # @option options [Integer] :delay (30)
      # @option options [Proc] :before_attempt
      # @option options [Proc] :before_wait
      def initialize(options)
        @client = options.fetch(:client)
        @waiter = Aws::Waiters::Waiter.new({
          max_attempts: 40,
          delay: 30,
          poller: Aws::Waiters::Poller.new(
            operation_name: :describe_cluster,
            acceptors: [
              {
                "expected" => "DELETING",
                "matcher" => "path",
                "state" => "failure",
                "argument" => "cluster.status"
              },
              {
                "expected" => "FAILED",
                "matcher" => "path",
                "state" => "failure",
                "argument" => "cluster.status"
              },
              {
                "expected" => "ACTIVE",
                "matcher" => "path",
                "state" => "success",
                "argument" => "cluster.status"
              }
            ]
          )
        }.merge(options))
      end

      # @option (see Client#describe_cluster)
      # @return (see Client#describe_cluster)
      def wait(params = {})
        @waiter.wait(client: @client, params: params)
      end

      # @api private
      attr_reader :waiter

    end

    class ClusterDeleted

      # @param [Hash] options
      # @option options [required, Client] :client
      # @option options [Integer] :max_attempts (40)
      # @option options [Integer] :delay (30)
      # @option options [Proc] :before_attempt
      # @option options [Proc] :before_wait
      def initialize(options)
        @client = options.fetch(:client)
        @waiter = Aws::Waiters::Waiter.new({
          max_attempts: 40,
          delay: 30,
          poller: Aws::Waiters::Poller.new(
            operation_name: :describe_cluster,
            acceptors: [
              {
                "expected" => "ACTIVE",
                "matcher" => "path",
                "state" => "failure",
                "argument" => "cluster.status"
              },
              {
                "expected" => "CREATING",
                "matcher" => "path",
                "state" => "failure",
                "argument" => "cluster.status"
              },
              {
                "expected" => "PENDING",
                "matcher" => "path",
                "state" => "failure",
                "argument" => "cluster.status"
              },
              {
                "expected" => "ResourceNotFoundException",
                "matcher" => "error",
                "state" => "success"
              }
            ]
          )
        }.merge(options))
      end

      # @option (see Client#describe_cluster)
      # @return (see Client#describe_cluster)
      def wait(params = {})
        @waiter.wait(client: @client, params: params)
      end

      # @api private
      attr_reader :waiter

    end

    class FargateProfileActive

      # @param [Hash] options
      # @option options [required, Client] :client
      # @option options [Integer] :max_attempts (60)
      # @option options [Integer] :delay (10)
      # @option options [Proc] :before_attempt
      # @option options [Proc] :before_wait
      def initialize(options)
        @client = options.fetch(:client)
        @waiter = Aws::Waiters::Waiter.new({
          max_attempts: 60,
          delay: 10,
          poller: Aws::Waiters::Poller.new(
            operation_name: :describe_fargate_profile,
            acceptors: [
              {
                "expected" => "CREATE_FAILED",
                "matcher" => "path",
                "state" => "failure",
                "argument" => "fargate_profile.status"
              },
              {
                "expected" => "ACTIVE",
                "matcher" => "path",
                "state" => "success",
                "argument" => "fargate_profile.status"
              }
            ]
          )
        }.merge(options))
      end

      # @option (see Client#describe_fargate_profile)
      # @return (see Client#describe_fargate_profile)
      def wait(params = {})
        @waiter.wait(client: @client, params: params)
      end

      # @api private
      attr_reader :waiter

    end

    class FargateProfileDeleted

      # @param [Hash] options
      # @option options [required, Client] :client
      # @option options [Integer] :max_attempts (60)
      # @option options [Integer] :delay (30)
      # @option options [Proc] :before_attempt
      # @option options [Proc] :before_wait
      def initialize(options)
        @client = options.fetch(:client)
        @waiter = Aws::Waiters::Waiter.new({
          max_attempts: 60,
          delay: 30,
          poller: Aws::Waiters::Poller.new(
            operation_name: :describe_fargate_profile,
            acceptors: [
              {
                "expected" => "DELETE_FAILED",
                "matcher" => "path",
                "state" => "failure",
                "argument" => "fargate_profile.status"
              },
              {
                "expected" => "ResourceNotFoundException",
                "matcher" => "error",
                "state" => "success"
              }
            ]
          )
        }.merge(options))
      end

      # @option (see Client#describe_fargate_profile)
      # @return (see Client#describe_fargate_profile)
      def wait(params = {})
        @waiter.wait(client: @client, params: params)
      end

      # @api private
      attr_reader :waiter

    end

    class NodegroupActive

      # @param [Hash] options
      # @option options [required, Client] :client
      # @option options [Integer] :max_attempts (80)
      # @option options [Integer] :delay (30)
      # @option options [Proc] :before_attempt
      # @option options [Proc] :before_wait
      def initialize(options)
        @client = options.fetch(:client)
        @waiter = Aws::Waiters::Waiter.new({
          max_attempts: 80,
          delay: 30,
          poller: Aws::Waiters::Poller.new(
            operation_name: :describe_nodegroup,
            acceptors: [
              {
                "expected" => "CREATE_FAILED",
                "matcher" => "path",
                "state" => "failure",
                "argument" => "nodegroup.status"
              },
              {
                "expected" => "ACTIVE",
                "matcher" => "path",
                "state" => "success",
                "argument" => "nodegroup.status"
              }
            ]
          )
        }.merge(options))
      end

      # @option (see Client#describe_nodegroup)
      # @return (see Client#describe_nodegroup)
      def wait(params = {})
        @waiter.wait(client: @client, params: params)
      end

      # @api private
      attr_reader :waiter

    end

    class NodegroupDeleted

      # @param [Hash] options
      # @option options [required, Client] :client
      # @option options [Integer] :max_attempts (40)
      # @option options [Integer] :delay (30)
      # @option options [Proc] :before_attempt
      # @option options [Proc] :before_wait
      def initialize(options)
        @client = options.fetch(:client)
        @waiter = Aws::Waiters::Waiter.new({
          max_attempts: 40,
          delay: 30,
          poller: Aws::Waiters::Poller.new(
            operation_name: :describe_nodegroup,
            acceptors: [
              {
                "expected" => "DELETE_FAILED",
                "matcher" => "path",
                "state" => "failure",
                "argument" => "nodegroup.status"
              },
              {
                "expected" => "ResourceNotFoundException",
                "matcher" => "error",
                "state" => "success"
              }
            ]
          )
        }.merge(options))
      end

      # @option (see Client#describe_nodegroup)
      # @return (see Client#describe_nodegroup)
      def wait(params = {})
        @waiter.wait(client: @client, params: params)
      end

      # @api private
      attr_reader :waiter

    end
  end
end
